/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CompletedTxn;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\reh\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|w\r\t\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005YqN\u001a4tKRLe\u000eZ3y+\u0005A\u0003CA\u0015+\u001b\u0005\u0011\u0011BA\u0016\u0003\u0005-yeMZ:fi&sG-\u001a=\t\u00115\u0002!\u0011!Q\u0001\n!\nAb\u001c4gg\u0016$\u0018J\u001c3fq\u0002B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\ni&lW-\u00138eKb,\u0012!\r\t\u0003SIJ!a\r\u0002\u0003\u0013QKW.Z%oI\u0016D\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0015QLW.Z%oI\u0016D\b\u0005\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u0003!!\bP\\%oI\u0016DX#A\u001d\u0011\u0005%R\u0014BA\u001e\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003:\u0003%!\bP\\%oI\u0016D\b\u0005\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002\u0003B\u0011\u0011BQ\u0005\u0003\u0007*\u0011A\u0001T8oO\"AQ\t\u0001B\u0001B\u0003%\u0011)A\u0006cCN,wJ\u001a4tKR\u0004\u0003\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm]\u000b\u0002\u0013B\u0011\u0011BS\u0005\u0003\u0017*\u00111!\u00138u\u0011!i\u0005A!A!\u0002\u0013I\u0015aE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\u0003\u0002C(\u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u0019I|G\u000e\u001c&jiR,'/T:\t\u0011E\u0003!\u0011!Q\u0001\n\u0005\u000bQB]8mY*KG\u000f^3s\u001bN\u0004\u0003\u0002C*\u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u00195\f\u0007pU3h[\u0016tG/T:\t\u0011U\u0003!\u0011!Q\u0001\n\u0005\u000bQ\"\\1y'\u0016<W.\u001a8u\u001bN\u0004\u0003\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0001%\u0002\u001f5\f\u0007pU3h[\u0016tGOQ=uKND\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I!S\u0001\u0011[\u0006D8+Z4nK:$()\u001f;fg\u0002B\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001X\u0001\u0005i&lW-F\u0001^!\tq\u0006-D\u0001`\u0015\t\t\"$\u0003\u0002b?\n!A+[7f\u0011!\u0019\u0007A!A!\u0002\u0013i\u0016!\u0002;j[\u0016\u0004\u0003BB3\u0001\t\u0003\u0011a-\u0001\u0004=S:LGO\u0010\u000b\fO\"L'n\u001b7n]>\u0004\u0018\u000f\u0005\u0002*\u0001!)1\u0001\u001aa\u0001-!)a\u0005\u001aa\u0001Q!)q\u0006\u001aa\u0001c!)q\u0007\u001aa\u0001s!)q\b\u001aa\u0001\u0003\")q\t\u001aa\u0001\u0013\")q\n\u001aa\u0001\u0003\")1\u000b\u001aa\u0001\u0003\")q\u000b\u001aa\u0001\u0013\")1\f\u001aa\u0001;\")1\u000f\u0001C\u0001i\u0006Q1\u000f[8vY\u0012\u0014v\u000e\u001c7\u0015\u000bUD(\u0010 @\u0011\u0005%1\u0018BA<\u000b\u0005\u001d\u0011un\u001c7fC:DQ!\u001f:A\u0002%\u000bA\"\\3tg\u0006<Wm]*ju\u0016DQa\u001f:A\u0002\u0005\u000ba#\\1y)&lWm\u001d;b[BLe.T3tg\u0006<Wm\u001d\u0005\u0006{J\u0004\r!Q\u0001\u0014[\u0006DxJ\u001a4tKRLe.T3tg\u0006<Wm\u001d\u0005\u0006\u007fJ\u0004\r!Q\u0001\u0004]><\bbBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000ee\u0016\u001c\u0018N_3J]\u0012,\u00070Z:\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004\u0013\u0005%\u0011bAA\u0006\u0015\t!QK\\5u\u0011\u001d\ty!!\u0001A\u0002%\u000bAa]5{K\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011aC:b]&$\u0018p\u00115fG.$B!a\u0002\u0002\u0018!9\u0011\u0011DA\t\u0001\u0004)\u0018!\u0007;j[\u0016Le\u000eZ3y\r&dWMT3xYf\u001c%/Z1uK\u0012D\u0001\"!\b\u0001\u0001\u0004%I\u0001Q\u0001\bGJ,\u0017\r^3e\u0011%\t\t\u0003\u0001a\u0001\n\u0013\t\u0019#A\u0006de\u0016\fG/\u001a3`I\u0015\fH\u0003BA\u0004\u0003KA\u0011\"a\n\u0002 \u0005\u0005\t\u0019A!\u0002\u0007a$\u0013\u0007C\u0004\u0002,\u0001\u0001\u000b\u0015B!\u0002\u0011\r\u0014X-\u0019;fI\u0002B\u0001\"a\f\u0001\u0001\u0004%I\u0001S\u0001\u0019Ef$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\b\"CA\u001a\u0001\u0001\u0007I\u0011BA\u001b\u0003q\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/_0%KF$B!a\u0002\u00028!I\u0011qEA\u0019\u0003\u0003\u0005\r!\u0013\u0005\b\u0003w\u0001\u0001\u0015)\u0003J\u0003e\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0011\t\u0013\u0005}\u0002\u00011A\u0005\n\u0005\u0005\u0013!\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]\u000b\u0003\u0003\u0007\u0002B!CA#\u0003&\u0019\u0011q\t\u0006\u0003\r=\u0003H/[8o\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti%A\rs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA\u0004\u0003\u001fB!\"a\n\u0002J\u0005\u0005\t\u0019AA\"\u0011!\t\u0019\u0006\u0001Q!\n\u0005\r\u0013A\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e\u001d\u0011\t\u0011\u0005]\u0003\u00011A\u0005\n\u0001\u000b\u0011#\\1y)&lWm\u001d;b[B\u001cvNR1s\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti&A\u000bnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ|F%Z9\u0015\t\u0005\u001d\u0011q\f\u0005\n\u0003O\tI&!AA\u0002\u0005Cq!a\u0019\u0001A\u0003&\u0011)\u0001\nnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\u0004\u0003\u0006BA1\u0003O\u00022!CA5\u0013\r\tYG\u0003\u0002\tm>d\u0017\r^5mK\"A\u0011q\u000e\u0001A\u0002\u0013%\u0001)\u0001\u000bpM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\n\u0003g\u0002\u0001\u0019!C\u0005\u0003k\n\u0001d\u001c4gg\u0016$xJZ'bqRKW.Z:uC6\u0004x\fJ3r)\u0011\t9!a\u001e\t\u0013\u0005\u001d\u0012\u0011OA\u0001\u0002\u0004\t\u0005bBA>\u0001\u0001\u0006K!Q\u0001\u0016_\u001a47/\u001a;PM6\u000b\u0007\u0010V5nKN$\u0018-\u001c9!Q\u0011\tI(a\u001a\t\r\u0005=\u0001\u0001\"\u0001I\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000b\u000b!dY1o\u0007>tg/\u001a:u)>\u0014V\r\\1uSZ,wJ\u001a4tKR$2!^AD\u0011\u001d\tI)!!A\u0002\u0005\u000baa\u001c4gg\u0016$\bbBAG\u0001\u0011\u0005\u0011qR\u0001\u0007CB\u0004XM\u001c3\u0015\u0015\u0005\u001d\u0011\u0011SAK\u00033\u000bi\nC\u0004\u0002\u0014\u0006-\u0005\u0019A!\u0002\u001b1\f'oZ3ti>3gm]3u\u0011\u001d\t9*a#A\u0002\u0005\u000b\u0001\u0003\\1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9\t\u000f\u0005m\u00151\u0012a\u0001\u0003\u0006Y2\u000f[1mY><xJ\u001a4tKR|e-T1y)&lWm\u001d;b[BD\u0001\"a(\u0002\f\u0002\u0007\u0011\u0011U\u0001\be\u0016\u001cwN\u001d3t!\r9\u00121U\u0005\u0004\u0003KC\"!D'f[>\u0014\u0018PU3d_J$7\u000f\u000b\u0003\u0002\f\u0006%\u0006cA\b\u0002,&\u0019\u0011Q\u0016\t\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0011\u001d\t\t\f\u0001C\u0005\u0003g\u000b1#\u001a8tkJ,wJ\u001a4tKRLeNU1oO\u0016$B!a\u0002\u00026\"9\u0011\u0011RAX\u0001\u0004\t\u0005bBA]\u0001\u0011%\u00111X\u0001\u0014CB\u0004XM\u001c3DQVt7N\u0012:p[\u001aKG.\u001a\u000b\b\u0013\u0006u\u0016qXAb\u0011\u001d\ty*a.A\u0002YAq!!1\u00028\u0002\u0007\u0011*\u0001\u0005q_NLG/[8o\u0011!\t)-a.A\u0002\u0005\u001d\u0017A\u00042vM\u001a,'oU;qa2LWM\u001d\t\u0004/\u0005%\u0017bAAf1\tq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\bbBAh\u0001\u0011\u0005\u0011\u0011[\u0001\u000fCB\u0004XM\u001c3Ge>lg)\u001b7f)\u0015I\u00151[Ak\u0011\u001d\ty*!4A\u0002YAq!a6\u0002N\u0002\u0007\u0011*A\u0003ti\u0006\u0014H\u000fC\u0004\u0002\\\u0002!\t!!8\u0002\u001dU\u0004H-\u0019;f)bt\u0017J\u001c3fqR1\u0011qAAp\u0003SD\u0001\"!9\u0002Z\u0002\u0007\u00111]\u0001\rG>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\t\u0004S\u0005\u0015\u0018bAAt\u0005\ta1i\\7qY\u0016$X\r\u001a+y]\"9\u00111^Am\u0001\u0004\t\u0015\u0001\u00057bgR\u001cF/\u00192mK>3gm]3uQ\u0011\tI.!+\t\u000f\u0005E\b\u0001\"\u0003\u0002t\u0006\u0019R\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u00148\u000b^1uKR1\u0011qAA{\u0003\u007fD\u0001\"a>\u0002p\u0002\u0007\u0011\u0011`\u0001\u0015aJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0011\u0007%\nY0C\u0002\u0002~\n\u0011A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\b\u0002\u0003B\u0001\u0003_\u0004\rAa\u0001\u0002\u000b\t\fGo\u00195\u0011\u0007]\u0011)!C\u0002\u0003\ba\u00111BU3d_J$')\u0019;dQ\"A!1\u0002\u0001\u0005\u0002\t\u0011i!A\bue\u0006t7\u000f\\1uK>3gm]3u)\u0019\u0011yAa\u000e\u0003:A!!\u0011\u0003B\u0019\u001d\u0011\u0011\u0019B!\f\u000f\t\tU!1\u0006\b\u0005\u0005/\u0011IC\u0004\u0003\u0003\u001a\t\u001db\u0002\u0002B\u000e\u0005KqAA!\b\u0003$5\u0011!q\u0004\u0006\u0004\u0005C1\u0011A\u0002\u001fs_>$h(C\u0001!\u0013\tqr$\u0003\u0002\u0006;%\u00111\u0004H\u0005\u00033iI1Aa\f\u0019\u0003-1\u0015\u000e\\3SK\u000e|'\u000fZ:\n\t\tM\"Q\u0007\u0002\u0012\u0019><wJ\u001a4tKR\u0004vn]5uS>t'b\u0001B\u00181!9\u0011\u0011\u0012B\u0005\u0001\u0004\t\u0005\"\u0003B\u001e\u0005\u0013\u0001\n\u00111\u0001J\u0003Q\u0019H/\u0019:uS:<g)\u001b7f!>\u001c\u0018\u000e^5p]\"\"!\u0011\u0002B !\ry!\u0011I\u0005\u0004\u0005\u0007\u0002\"A\u0003;ie\u0016\fGm]1gK\"9!q\t\u0001\u0005\u0002\t%\u0013\u0001\u0002:fC\u0012$BBa\u0013\u0003X\tm#q\fB2\u0005O\u0002BA!\u0014\u0003T5\u0011!q\n\u0006\u0004\u0005#\"\u0011AB:feZ,'/\u0003\u0003\u0003V\t=#!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u0003Z\t\u0015\u0003\u0019A!\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\t\u0005;\u0012)\u00051\u0001\u0002D\u0005IQ.\u0019=PM\u001a\u001cX\r\u001e\u0005\b\u0005C\u0012)\u00051\u0001J\u0003\u001di\u0017\r_*ju\u0016D\u0011B!\u001a\u0003FA\u0005\t\u0019A!\u0002\u00175\f\u0007\u0010U8tSRLwN\u001c\u0005\n\u0005S\u0012)\u0005%AA\u0002U\fQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007\u0006\u0002B#\u0005\u007fAqAa\u001c\u0001\t\u0003\u0011\t(A\u000bgKR\u001c\u0007.\u00169qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0015\r\u0005\r#1\u000fB?\u0011!\u0011)H!\u001cA\u0002\t]\u0014aE:uCJ$xJ\u001a4tKR\u0004vn]5uS>t\u0007cA\u0015\u0003z%\u0019!1\u0010\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"9!q\u0010B7\u0001\u0004I\u0015!\u00034fi\u000eD7+\u001b>f\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0005\u000b\u000bqA]3d_Z,'\u000fF\u0003J\u0005\u000f\u0013I\t\u0003\u0005\u0002x\n\u0005\u0005\u0019AA}\u0011)\u0011YI!!\u0011\u0002\u0003\u0007!QR\u0001\u0011Y\u0016\fG-\u001a:Fa>\u001c\u0007nQ1dQ\u0016\u0004R!CA#\u0005\u001f\u0003BA!%\u0003\u00186\u0011!1\u0013\u0006\u0005\u0005+\u0013y%A\u0003fa>\u001c\u0007.\u0003\u0003\u0003\u001a\nM%\u0001\u0005'fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195fQ\u0011\u0011\t)!+\t\u000f\t}\u0005\u0001\"\u0003\u0003\"\u0006!Bn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B$\"!a\u0002\t\u000f\t\u0015\u0006\u0001\"\u0001\u0003(\u0006Y\u0001.Y:Pm\u0016\u0014h\r\\8x+\u0005)\bb\u0002BV\u0001\u0011\u0005!QV\u0001\u0013G>dG.Z2u\u0003\n|'\u000f^3e)bt7\u000f\u0006\u0004\u00030\nU&\u0011\u0018\t\u0004S\tE\u0016b\u0001BZ\u0005\t!B\u000b\u001f8J]\u0012,\u0007pU3be\u000eD'+Z:vYRDqAa.\u0003*\u0002\u0007\u0011)A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bb\u0002B^\u0005S\u0003\r!Q\u0001\u0011kB\u0004XM\u001d\"pk:$wJ\u001a4tKRDqAa0\u0001\t\u0003\u0012\t-\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019\r\u0005\u0003\u0003F\n=WB\u0001Bd\u0015\u0011\u0011IMa3\u0002\t1\fgn\u001a\u0006\u0003\u0005\u001b\fAA[1wC&!!\u0011\u001bBd\u0005\u0019\u0019FO]5oO\"9!Q\u001b\u0001\u0005\u0002\t]\u0017A\u0003;sk:\u001c\u0017\r^3U_R\u0019\u0011J!7\t\u000f\u0005%%1\u001ba\u0001\u0003\"\"!1[AU\u0011\u0019\u0011y\u000e\u0001C\u0001\u0001\u0006q!/Z1e\u001d\u0016DHo\u00144gg\u0016$\b\u0006\u0002Bo\u0005\u007fAqA!:\u0001\t\u0003\u0011\t+A\u0003gYV\u001c\b\u000e\u000b\u0003\u0003d\n}\u0002b\u0002Bv\u0001\u0011\u0005!Q^\u0001\nkB$\u0017\r^3ESJ$B!a\u0002\u0003p\"A!\u0011\u001fBu\u0001\u0004\u0011\u00190A\u0002eSJ\u0004BA!>\u0003|6\u0011!q\u001f\u0006\u0005\u0005s\u0014Y-\u0001\u0002j_&!!Q B|\u0005\u00111\u0015\u000e\\3\t\u000f\r\u0005\u0001\u0001\"\u0001\u0004\u0004\u0005\u00112\r[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3t)\u0019\t9a!\u0002\u0004\u0016!A1q\u0001B\u0000\u0001\u0004\u0019I!A\u0005pY\u0012\u001cVO\u001a4jqB!11BB\t\u001d\rI1QB\u0005\u0004\u0007\u001fQ\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0003R\u000eM!bAB\b\u0015!A1q\u0003B\u0000\u0001\u0004\u0019I!A\u0005oK^\u001cVO\u001a4jq\"911\u0004\u0001\u0005\u0002\t\u0005\u0016aF8o\u0005\u0016\u001cw.\\3J]\u0006\u001cG/\u001b<f'\u0016<W.\u001a8u\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007C\t\u0011\u0003^5nK^\u000b\u0017\u000e^3e\r>\u0014(k\u001c7m)\u0015\t51EB\u0013\u0011\u0019y8Q\u0004a\u0001\u0003\"91qEB\u000f\u0001\u0004\t\u0015\u0001E7fgN\fw-\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\u0019Y\u0003\u0001C\u0001\u0007[\tQCZ5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u00040\r]21\b\t\u0006\u0013\u0005\u00153\u0011\u0007\t\u0004S\rM\u0012bAB\u001b\u0005\tyA+[7fgR\fW\u000e](gMN,G\u000fC\u0004\u0004:\r%\u0002\u0019A!\u0002\u0013QLW.Z:uC6\u0004\b\"CB\u001f\u0007S\u0001\n\u00111\u0001B\u00039\u0019H/\u0019:uS:<wJ\u001a4tKRDqa!\u0011\u0001\t\u0003\u0011\t+A\u0003dY>\u001cX\rC\u0004\u0004F\u0001!\tA!)\u0002\u001b\rdwn]3IC:$G.\u001a:t\u0011\u001d\u0019I\u0005\u0001C\u0001\u0005C\u000ba\u0002Z3mKR,\u0017JZ#ySN$8\u000f\u0003\u0004\u0004N\u0001!\t\u0001Q\u0001\rY\u0006\u001cH/T8eS\u001aLW\r\u001a\u0005\u0007\u0003/\u0003A\u0011\u0001!\t\u000f\rM\u0003\u0001\"\u0001\u0004V\u0005\u0001B.Y:u\u001b>$\u0017NZ5fI~#S-\u001d\u000b\u0005\u0007/\u001a9\u0007\u0005\u0003\u0004Z\r\rTBAB.\u0015\u0011\u0019ifa\u0018\u0002\t\u0019LG.\u001a\u0006\u0005\u0007C\u0012Y-A\u0002oS>LAa!\u001a\u0004\\\t!\u0001+\u0019;i\u0011\u001d\u0019Ig!\u0015A\u0002\u0005\u000b!!\\:\t\u0013\r5\u0004!%A\u0005\u0002\r=\u0014!\u0005:fG>4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u000f\u0016\u0005\u0005\u001b\u001b\u0019h\u000b\u0002\u0004vA!1qOBA\u001b\t\u0019IH\u0003\u0003\u0004|\ru\u0014!C;oG\",7m[3e\u0015\r\u0019yHC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBB\u0007s\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00199\tAI\u0001\n\u0003\u0019I)\u0001\bsK\u0006$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r-%fA!\u0004t!I1q\u0012\u0001\u0012\u0002\u0013\u00051\u0011S\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019\u0019JK\u0002v\u0007gB\u0011ba&\u0001#\u0003%\ta!'\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u00077S3!SB:\u0011%\u0019y\nAI\u0001\n\u0003\u0019I)A\u0010gS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9%I\u00164\u0017-\u001e7uIIB3\u0001AAU\u000f\u001d\u0019)K\u0001E\u0001\u0007O\u000b!\u0002T8h'\u0016<W.\u001a8u!\rI3\u0011\u0016\u0004\u0007\u0003\tA\taa+\u0014\u0007\r%\u0006\u0002C\u0004f\u0007S#\taa,\u0015\u0005\r\u001d\u0006\u0002CBZ\u0007S#\ta!.\u0002\t=\u0004XM\u001c\u000b\u0012O\u000e]6\u0011XB^\u0007\u000b\u001c9ma3\u0004P\u000eM\u0007\u0002\u0003By\u0007c\u0003\rAa=\t\r}\u001a\t\f1\u0001B\u0011!\u0019il!-A\u0002\r}\u0016AB2p]\u001aLw\rE\u0002*\u0007\u0003L1aa1\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004\\\u0007c\u0003\r!\u0018\u0005\n\u0007\u0013\u001c\t\f%AA\u0002U\f\u0011CZ5mK\u0006c'/Z1es\u0016C\u0018n\u001d;t\u0011%\u0019im!-\u0011\u0002\u0003\u0007\u0011*\u0001\u0007j]&$h)\u001b7f'&TX\rC\u0005\u0004R\u000eE\u0006\u0013!a\u0001k\u0006Y\u0001O]3bY2|7-\u0019;f\u0011)\u0019)n!-\u0011\u0002\u0003\u00071\u0011B\u0001\u000bM&dWmU;gM&D\b\u0002CB%\u0007S#\ta!7\u0015\u0011\u0005\u001d11\\Bo\u0007?D\u0001B!=\u0004X\u0002\u0007!1\u001f\u0005\u0007\u007f\r]\u0007\u0019A!\t\u0015\rU7q\u001bI\u0001\u0002\u0004\u0019I\u0001\u0003\u0006\u0004d\u000e%\u0016\u0013!C\u0001\u0007#\u000bab\u001c9f]\u0012\"WMZ1vYR$S\u0007\u0003\u0006\u0004h\u000e%\u0016\u0013!C\u0001\u00073\u000bab\u001c9f]\u0012\"WMZ1vYR$c\u0007\u0003\u0006\u0004l\u000e%\u0016\u0013!C\u0001\u0007#\u000bab\u001c9f]\u0012\"WMZ1vYR$s\u0007\u0003\u0006\u0004p\u000e%\u0016\u0013!C\u0001\u0007c\fab\u001c9f]\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0004t*\"1\u0011BB:\u0011)\u00199p!+\u0012\u0002\u0013\u00051\u0011_\u0001\u0019I\u0016dW\r^3JM\u0016C\u0018n\u001d;tI\u0011,g-Y;mi\u0012\u001a\u0004")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final OffsetIndex offsetIndex;
    private final TimeIndex timeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final long maxSegmentMs;
    private final int maxSegmentBytes;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long kafka$log$LogSegment$$maxTimestampSoFar;
    private volatile long kafka$log$LogSegment$$offsetOfMaxTimestamp;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileRecords log() {
        return this.log;
    }

    public OffsetIndex offsetIndex() {
        return this.offsetIndex;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public long maxSegmentMs() {
        return this.maxSegmentMs;
    }

    public int maxSegmentBytes() {
        return this.maxSegmentBytes;
    }

    public Time time() {
        return this.time;
    }

    public boolean shouldRoll(int messagesSize, long maxTimestampInMessages, long maxOffsetInMessages, long now) {
        boolean reachedRollMs = this.timeWaitedForRoll(now, maxTimestampInMessages) > this.maxSegmentMs() - this.rollJitterMs();
        return this.size() > this.maxSegmentBytes() - messagesSize || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(maxOffsetInMessages);
    }

    public void resizeIndexes(int size2) {
        this.offsetIndex().resize(size2);
        this.timeIndex().resize(size2);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.offsetIndex().file().exists()) {
            this.offsetIndex().sanityCheck();
            Object object = timeIndexFileNewlyCreated ? BoxesRunTime.boxToBoolean((boolean)this.timeIndex().resize(0)) : BoxedUnit.UNIT;
            this.timeIndex().sanityCheck();
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset index file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offsetIndex().file().getAbsolutePath()})));
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    public long kafka$log$LogSegment$$maxTimestampSoFar() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar;
    }

    public void kafka$log$LogSegment$$maxTimestampSoFar_$eq(long x$1) {
        this.kafka$log$LogSegment$$maxTimestampSoFar = x$1;
    }

    public long kafka$log$LogSegment$$offsetOfMaxTimestamp() {
        return this.kafka$log$LogSegment$$offsetOfMaxTimestamp;
    }

    public void kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(long x$1) {
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = x$1;
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset2) {
        return this.offsetIndex().canAppendOffset(offset2);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, largestOffset, largestTimestamp, shallowOffsetOfMaxTimestamp, records){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long largestOffset$1;
                private final long largestTimestamp$1;
                private final long shallowOffsetOfMaxTimestamp$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting ", " bytes at end offset ", " at position ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.largestOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with largest timestamp ", " at shallow offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.largestTimestamp$1), BoxesRunTime.boxToLong((long)this.shallowOffsetOfMaxTimestamp$1)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.largestOffset$1 = largestOffset$1;
                    this.largestTimestamp$1 = largestTimestamp$1;
                    this.shallowOffsetOfMaxTimestamp$1 = shallowOffsetOfMaxTimestamp$1;
                    this.records$1 = records$1;
                }
            });
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.kafka$log$LogSegment$$ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)new Serializable(this, largestOffset, appendedBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long largestOffset$1;
                private final int appendedBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appended ", " to ", " at end offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.appendedBytes$1), this.$outer.log().file(), BoxesRunTime.boxToLong((long)this.largestOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.largestOffset$1 = largestOffset$1;
                    this.appendedBytes$1 = appendedBytes$1;
                }
            });
            if (largestTimestamp > this.kafka$log$LogSegment$$maxTimestampSoFar()) {
                this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(largestTimestamp);
                this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    public void kafka$log$LogSegment$$ensureOffsetInRange(long offset2) {
        if (this.canConvertToRelativeOffset(offset2)) {
            return;
        }
        throw new LogSegmentOffsetOverflowException(this, offset2);
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        Iterator nextBatches = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator();
        nextBatches.takeWhile((Function1)new Serializable(this, bytesToAppend, readBuffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;
            private final IntRef bytesToAppend$1;
            private final ObjectRef readBuffer$1;

            public final boolean apply(RecordBatch batch) {
                return this.$outer.kafka$log$LogSegment$$canAppend$1(batch, this.bytesToAppend$1, this.readBuffer$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytesToAppend$1 = bytesToAppend$1;
                this.readBuffer$1 = readBuffer$1;
            }
        }).foreach((Function1)new Serializable(this, bytesToAppend, maxTimestamp, offsetOfMaxTimestamp, maxOffset){
            public static final long serialVersionUID = 0L;
            private final IntRef bytesToAppend$1;
            private final LongRef maxTimestamp$1;
            private final LongRef offsetOfMaxTimestamp$1;
            private final LongRef maxOffset$1;

            public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                if (batch.maxTimestamp() > this.maxTimestamp$1.elem) {
                    this.maxTimestamp$1.elem = batch.maxTimestamp();
                    this.offsetOfMaxTimestamp$1.elem = batch.lastOffset();
                }
                this.maxOffset$1.elem = batch.lastOffset();
                this.bytesToAppend$1.elem += batch.sizeInBytes();
            }
            {
                this.bytesToAppend$1 = bytesToAppend$1;
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
                this.maxOffset$1 = maxOffset$1;
            }
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset2) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)new Serializable(this, completedTxn, lastStableOffset2){
                public static final long serialVersionUID = 0L;
                private final CompletedTxn completedTxn$1;
                private final long lastStableOffset$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing aborted transaction ", " to transaction index, last stable offset is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.completedTxn$1, BoxesRunTime.boxToLong((long)this.lastStableOffset$1)}));
                }
                {
                    this.completedTxn$1 = completedTxn$1;
                    this.lastStableOffset$1 = lastStableOffset$1;
                }
            });
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset2));
        }
    }

    public void kafka$log$LogSegment$$updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, false);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1)new Serializable(this, producerStateManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final ProducerStateManager producerStateManager$2;

                public final void apply(CompletedTxn completedTxn) {
                    long lastStableOffset2 = this.producerStateManager$2.completeTxn(completedTxn);
                    this.$outer.updateTxnIndex(completedTxn, lastStableOffset2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerStateManager$2 = producerStateManager$2;
                }
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset2, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset2);
        return this.log().searchForOffsetWithSize(offset2, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        Option<Object> option;
        block9: {
            int n;
            int adjustedMaxSize;
            LogOffsetMetadata offsetMetadata;
            int startPosition;
            FileRecords.LogOffsetPosition startOffsetAndSize;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid max size ", " for log read from segment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize), this.log()})));
                    }
                    logSize = this.log().sizeInBytes();
                    startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startOffsetAndSize == null) {
                        return null;
                    }
                    startPosition = startOffsetAndSize.position;
                    offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
                    int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
                    if (adjustedMaxSize == 0) {
                        return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
                    }
                    option = maxOffset;
                    if (!None$.MODULE$.equals(option)) break block7;
                    n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long offset2 = BoxesRunTime.unboxToLong((Object)some.x());
                if (offset2 < startOffset) {
                    return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, FetchDataInfo$.MODULE$.apply$default$4());
                }
                FileRecords.LogOffsetPosition mapping = this.translateOffset(offset2, startPosition);
                int endPosition = mapping == null ? logSize : mapping.position;
                n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
            }
            int fetchSize = n;
            return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
        }
        throw new MatchError(option);
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetPosition x$1) {
                return x$1.offset();
            }
        });
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1)new Serializable(this, producerStateManager, leaderEpochCache, validBytes, lastIndexEntry){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final ProducerStateManager producerStateManager$1;
                private final Option leaderEpochCache$1;
                private final IntRef validBytes$1;
                private final IntRef lastIndexEntry$1;

                public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                    batch.ensureValid();
                    this.$outer.kafka$log$LogSegment$$ensureOffsetInRange(batch.lastOffset());
                    if (batch.maxTimestamp() > this.$outer.kafka$log$LogSegment$$maxTimestampSoFar()) {
                        this.$outer.kafka$log$LogSegment$$maxTimestampSoFar_$eq(batch.maxTimestamp());
                        this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(batch.lastOffset());
                    }
                    if (this.validBytes$1.elem - this.lastIndexEntry$1.elem > this.$outer.indexIntervalBytes()) {
                        this.$outer.offsetIndex().append(batch.lastOffset(), this.validBytes$1.elem);
                        this.$outer.timeIndex().maybeAppend(this.$outer.kafka$log$LogSegment$$maxTimestampSoFar(), this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.$outer.timeIndex().maybeAppend$default$3());
                        this.lastIndexEntry$1.elem = this.validBytes$1.elem;
                    }
                    this.validBytes$1.elem += batch.sizeInBytes();
                    if (batch.magic() >= 2) {
                        this.leaderEpochCache$1.foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(LeaderEpochCache cache) {
                                if (this.batch$1.partitionLeaderEpoch() > cache.latestEpoch()) {
                                    cache.assign(this.batch$1.partitionLeaderEpoch(), this.batch$1.baseOffset());
                                }
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                        this.$outer.kafka$log$LogSegment$$updateProducerState(this.producerStateManager$1, (RecordBatch)batch);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producerStateManager$1 = producerStateManager$1;
                    this.leaderEpochCache$1 = leaderEpochCache$1;
                    this.validBytes$1 = validBytes$1;
                    this.lastIndexEntry$1 = lastIndexEntry$1;
                }
            });
        }
        catch (CorruptRecordException corruptRecordException) {
            this.warn((Function0<String>)new Serializable(this, validBytes, corruptRecordException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final IntRef validBytes$1;
                private final CorruptRecordException e$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.validBytes$1.elem), this.e$1.getMessage()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.validBytes$1 = validBytes$1;
                    this.e$1 = e$1;
                }
            });
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)new Serializable(this, truncated){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final int truncated$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated ", " invalid bytes at the end of segment ", " during recovery"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.truncated$1), this.$outer.log().file().getAbsoluteFile()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.truncated$1 = truncated$1;
                }
            });
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToInteger((int)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset2) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset2, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset2);
        this.timeIndex().truncateTo(offset2);
        this.txnIndex().truncateTo(offset2);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
        return fetchData == null ? this.baseOffset() : BoxesRunTime.unboxToLong((Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RecordBatch x$2) {
                return x$2.nextOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.baseOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.offsetIndex().flush();
                this.$outer.timeIndex().flush();
                this.$outer.txnIndex().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.offsetIndex().file_$eq(new File(dir, this.offsetIndex().file().getName()));
        this.timeIndex().file_$eq(new File(dir, this.timeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.offsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        java.util.Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<TimestampOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TimestampOffset apply(FileRecords.TimestampAndOffset timestampAndOffset) {
                return new TimestampOffset(timestampAndOffset.timestamp, timestampAndOffset.offset);
            }
        });
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().maybeAppend(this.$outer.kafka$log$LogSegment$$maxTimestampSoFar(), this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.offsetIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.txnIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.offsetIndex().closeHandler();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().closeHandler();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().closeHandlers();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.txnIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$1 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().log().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "log", this.$outer.log().file(), true);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$2 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().offsetIndex().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "offset index", this.$outer.offsetIndex().file(), true);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$3 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().timeIndex().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "time index", this.$outer.timeIndex().file(), true);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogSegment$$delete$1((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteIfExists$4 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.$outer.kafka$log$LogSegment$$anonfun$$$outer().txnIndex().deleteIfExists();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, "transaction index", this.$outer.txnIndex().file(), false);
            }

            public /* synthetic */ LogSegment kafka$log$LogSegment$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L ? this.kafka$log$LogSegment$$maxTimestampSoFar() : this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.offsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.timeIndex().file().toPath(), fileTime);
    }

    public final boolean kafka$log$LogSegment$$canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public final void kafka$log$LogSegment$$delete$1(Function0 delete2, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete2.apply$mcZ$sp()) {
                this.info((Function0<String>)new Serializable(this, fileType, file){
                    public static final long serialVersionUID = 0L;
                    private final String fileType$1;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileType$1, this.file$1.getAbsolutePath()}));
                    }
                    {
                        this.fileType$1 = fileType$1;
                        this.file$1 = file$1;
                    }
                });
            } else if (logIfMissing) {
                this.info((Function0<String>)new Serializable(this, fileType, file){
                    public static final long serialVersionUID = 0L;
                    private final String fileType$1;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete ", " ", " because it does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fileType$1, this.file$1.getAbsolutePath()}));
                    }
                    {
                        this.fileType$1 = fileType$1;
                        this.file$1 = file$1;
                    }
                });
            }
            return;
        }
        catch (IOException iOException) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delete of ", " ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, file.getAbsolutePath()})), iOException);
        }
    }

    public LogSegment(FileRecords log, OffsetIndex offsetIndex, TimeIndex timeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, long maxSegmentMs, int maxSegmentBytes, Time time) {
        this.log = log;
        this.offsetIndex = offsetIndex;
        this.timeIndex = timeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.maxSegmentMs = maxSegmentMs;
        this.maxSegmentBytes = maxSegmentBytes;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.kafka$log$LogSegment$$maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }
}

