/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.cluster.ReplicaTest$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001\u001d\u00111BU3qY&\u001c\u0017\rV3ti*\u00111\u0001B\u0001\bG2,8\u000f^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\u0002U\ta\u0001^7q\t&\u0014X#\u0001\f\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012AA5p\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\t\u0019KG.\u001a\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\f\u0002\u000fQl\u0007\u000fR5sA!9\u0011\u0005\u0001b\u0001\n\u0003)\u0012A\u00027pO\u0012K'\u000f\u0003\u0004$\u0001\u0001\u0006IAF\u0001\bY><G)\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002\u0019\nA\u0001^5nKV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\t\u0005)Q\u000f^5mg&\u0011A&\u000b\u0002\t\u001b>\u001c7\u000eV5nK\"1a\u0006\u0001Q\u0001\n\u001d\nQ\u0001^5nK\u0002Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011'\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t!\u0007\u0005\u00024m5\tAG\u0003\u00026\t\u000511/\u001a:wKJL!a\u000e\u001b\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\bBB\u001d\u0001A\u0003%!'A\tce>\\WM\u001d+pa&\u001c7\u000b^1ug\u0002B\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001f\u0002\u00071|w-F\u0001>!\tq\u0004)D\u0001@\u0015\tYD!\u0003\u0002B\u007f\t\u0019Aj\\4\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0003!\u0015a\u00027pO~#S-\u001d\u000b\u0003\u000b\"\u0003\"!\u0003$\n\u0005\u001dS!\u0001B+oSRDq!\u0013\"\u0002\u0002\u0003\u0007Q(A\u0002yIEBaa\u0013\u0001!B\u0013i\u0014\u0001\u00027pO\u0002B\u0011\"\u0014\u0001A\u0002\u0003\u0007I\u0011\u0001(\u0002\u000fI,\u0007\u000f\\5dCV\tq\n\u0005\u0002\u0013!&\u0011\u0011K\u0001\u0002\b%\u0016\u0004H.[2b\u0011%\u0019\u0006\u00011AA\u0002\u0013\u0005A+A\u0006sKBd\u0017nY1`I\u0015\fHCA#V\u0011\u001dI%+!AA\u0002=Caa\u0016\u0001!B\u0013y\u0015\u0001\u0003:fa2L7-\u0019\u0011\t\u000be\u0003A\u0011\u0001.\u0002\u000bM,G/\u001e9\u0015\u0003\u0015C#\u0001\u0017/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017!\u00026v]&$(\"A1\u0002\u0007=\u0014x-\u0003\u0002d=\n1!)\u001a4pe\u0016DQ!\u001a\u0001\u0005\u0002i\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003I\u001e\u0004\"!\u00185\n\u0005%t&!B!gi\u0016\u0014\b\"B6\u0001\t\u0003Q\u0016A\r;fgR\u001cVmZ7f]R$U\r\\3uS>tw+\u001b;i\u0011&<\u0007nV1uKJl\u0017M]6J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8)\u0005)l\u0007CA/o\u0013\tygL\u0001\u0003UKN$\b\"B9\u0001\t\u0003Q\u0016A\f;fgR\u001c\u0015M\u001c8pi\u0012+G.\u001a;f'\u0016<W.\u001a8ug\u0006#xJ]!c_Z,\u0007*[4i/\u0006$XM]7be.D#\u0001]7\t\u000bQ\u0004A\u0011\u0001.\u0002eQ,7\u000f^\"b]:|G/\u00138de\u0016lWM\u001c;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;QCN$\b*[4i/\u0006$XM]7be.DCa]7wo\u0006AQ\r\u001f9fGR,GmI\u0001y!\rI\u00181A\u0007\u0002u*\u00111\u0010`\u0001\u0007KJ\u0014xN]:\u000b\u0005ut\u0018AB2p[6|gN\u0003\u0002\u0006\u007f*\u0019\u0011\u0011\u00011\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\t)A\u001f\u0002\u001a\u001f\u001a47/\u001a;PkR|eMU1oO\u0016,\u0005pY3qi&|g\u000e")
public class ReplicaTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private Log log;
    private Replica replica;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.log_$eq(Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.time().scheduler(), this.brokerTopicStats(), (Time)this.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10)));
        int x$1 = 0;
        TopicPartition x$2 = new TopicPartition("foo", 0);
        MockTime x$3 = this.time();
        Some x$4 = new Some((Object)this.log());
        long x$5 = Replica$.MODULE$.$lessinit$greater$default$4();
        this.replica_$eq(new Replica(x$1, x$2, (Time)x$3, x$5, (Option)x$4));
    }

    @After
    public void tearDown() {
        this.log().close();
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testSegmentDeletionWithHighWatermarkInitialization() {
        long initialHighWatermark = 25L;
        this.replica_$eq(new Replica(0, new TopicPartition("foo", 0), (Time)this.time(), initialHighWatermark, (Option)new Some((Object)this.log())));
        Assert.assertEquals((long)initialHighWatermark, (long)this.replica().highWatermark().messageOffset());
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, expiredTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;
            private final long expiredTimestamp$1;

            public final LogAppendInfo apply(int i) {
                byte[] x$6 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes();
                long x$7 = this.expiredTimestamp$1;
                byte[] x$8 = TestUtils$.MODULE$.singletonRecords$default$2();
                CompressionType x$9 = TestUtils$.MODULE$.singletonRecords$default$3();
                byte x$10 = TestUtils$.MODULE$.singletonRecords$default$5();
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$6, x$8, x$9, x$7, x$10);
                Log qual$1 = this.$outer.log();
                MemoryRecords x$11 = records2;
                int x$12 = 0;
                boolean x$13 = qual$1.appendAsLeader$default$3();
                return qual$1.appendAsLeader(x$11, x$12, x$13);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expiredTimestamp$1 = expiredTimestamp$1;
            }
        });
        int initialNumSegments = this.log().numberOfSegments();
        this.log().deleteOldSegments();
        Assert.assertTrue((this.log().numberOfSegments() < initialNumSegments ? 1 : 0) != 0);
        Assert.assertTrue((this.replica().logStartOffset() <= initialHighWatermark ? 1 : 0) != 0);
    }

    @Test
    public void testCannotDeleteSegmentsAtOrAboveHighWatermark() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, expiredTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;
            private final long expiredTimestamp$2;

            public final LogAppendInfo apply(int i) {
                byte[] x$14 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes();
                long x$15 = this.expiredTimestamp$2;
                byte[] x$16 = TestUtils$.MODULE$.singletonRecords$default$2();
                CompressionType x$17 = TestUtils$.MODULE$.singletonRecords$default$3();
                byte x$18 = TestUtils$.MODULE$.singletonRecords$default$5();
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$14, x$16, x$17, x$15, x$18);
                Log qual$2 = this.$outer.log();
                MemoryRecords x$19 = records2;
                int x$20 = 0;
                boolean x$21 = qual$2.appendAsLeader$default$3();
                return qual$2.appendAsLeader(x$19, x$20, x$21);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expiredTimestamp$2 = expiredTimestamp$2;
            }
        });
        Assert.assertTrue((this.log().numberOfSegments() > 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.replica().highWatermark().messageOffset());
        Assert.assertEquals((long)0L, (long)this.replica().logStartOffset());
        Assert.assertEquals((long)100L, (long)this.replica().logEndOffset().messageOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;

            public final void apply(int hw) {
                this.apply$mcVI$sp(hw);
            }

            public void apply$mcVI$sp(int hw) {
                this.$outer.replica().highWatermark_$eq(new LogOffsetMetadata((long)hw, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                Assert.assertEquals((long)hw, (long)this.$outer.replica().highWatermark().messageOffset());
                this.$outer.log().deleteOldSegments();
                Assert.assertTrue((this.$outer.replica().logStartOffset() <= (long)hw ? 1 : 0) != 0);
                this.$outer.log().logSegments().headOption().foreach((Function1)new Serializable(this, hw){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1 $outer;
                    private final int hw$1;

                    public final void apply(LogSegment segment) {
                        Assert.assertTrue((segment.baseOffset() <= (long)this.hw$1 ? 1 : 0) != 0);
                        Assert.assertTrue((segment.baseOffset() >= this.$outer.kafka$cluster$ReplicaTest$$anonfun$$$outer().replica().logStartOffset() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.hw$1 = hw$1;
                    }
                });
                ((IterableLike)this.$outer.log().logSegments().tail()).foreach((Function1)new Serializable(this, hw){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1 $outer;
                    private final int hw$1;

                    public final void apply(LogSegment segment) {
                        Assert.assertTrue((segment.baseOffset() > (long)this.hw$1 ? 1 : 0) != 0);
                        Assert.assertTrue((segment.baseOffset() >= this.$outer.kafka$cluster$ReplicaTest$$anonfun$$$outer().replica().logStartOffset() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.hw$1 = hw$1;
                    }
                });
            }

            public /* synthetic */ ReplicaTest kafka$cluster$ReplicaTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)100L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)1L, (long)this.log().numberOfSegments());
        Assert.assertEquals((long)0L, (long)this.log().activeSegment().size());
    }

    @Test(expected=OffsetOutOfRangeException.class)
    public void testCannotIncrementLogStartOffsetPastHighWatermark() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaTest $outer;

            public final LogAppendInfo apply(int i) {
                MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                Log qual$3 = this.$outer.log();
                MemoryRecords x$22 = records2;
                int x$23 = 0;
                boolean x$24 = qual$3.appendAsLeader$default$3();
                return qual$3.appendAsLeader(x$22, x$23, x$24);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.replica().highWatermark_$eq(new LogOffsetMetadata(25L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        this.replica().maybeIncrementLogStartOffset(26L);
    }
}

