/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001\u001d\u0011QDU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bIR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005iF\u0002\b'F\u0001\u0017!\t9r$D\u0001\u0019\u0015\tI\"$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bmQ!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO&\u0011\u0001\u0005\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0011\u0003\u0001)A\u0005-\u0005)A/\r91A!9A\u0005\u0001b\u0001\n\u0013)\u0012\u0001\u0002;2aFBaA\n\u0001!\u0002\u00131\u0012!\u0002;2aF\u0002\u0003\"\u0002\u0015\u0001\t\u0003I\u0013AI5tgV,7/\u00129pG\"\u0014V-];fgR4%o\\7M_\u000e\fGNU3qY&\u001c\u0017\rF\u0001+!\tI1&\u0003\u0002-\u0015\t!QK\\5uQ\t9c\u0006\u0005\u00020e5\t\u0001G\u0003\u00022;\u0005)!.\u001e8ji&\u00111\u0007\r\u0002\u0005)\u0016\u001cH\u000fC\u00036\u0001\u0011\u0005\u0011&A\u001fgKR\u001c\u0007.\u00129pG\"\u001chI]8n\u0019\u0016\fG-\u001a:TQ>,H\u000e\u001a%b]\u0012dW-\u0012=dKB$\u0018n\u001c8Ge>lw)\u001a;M_\u000e\fGNU3qY&\u001c\u0017\r\u000b\u00025]!)\u0001\b\u0001C\u0001S\u0005i2\u000f[8vY\u0012$&/\u001e8dCR,Gk\u001c*fa2L7-Y(gMN,G\u000f\u000b\u00028]!)1\b\u0001C\u0001S\u0005i3\u000f[8vY\u0012$&/\u001e8dCR,Gk\\#oI>3gm]3u\u001f\u001ad\u0015M]4fgR\u001cu.\\7p]\u0016\u0003xn\u00195)\u0005ir\u0003\"\u0002 \u0001\t\u0003I\u0013!Q:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u0013:LG/[1m\r\u0016$8\r[(gMN,G/\u00134SKBd\u0017nY1SKR,(O\\:V]\u0012,g-\u001b8fI>3gm]3uQ\tid\u0006C\u0003B\u0001\u0011\u0005\u0011&A\u0016tQ>,H\u000e\u001a)pY2Le\u000eZ3gS:LG/\u001a7z\u0013\u001a\u0014V\r\u001d7jG\u0006tu\u000e^!wC&d\u0017M\u00197fQ\t\u0001e\u0006C\u0003E\u0001\u0011\u0005\u0011&\u0001\u0014tQ>,H\u000e\u001a$fi\u000eDG*Z1eKJ,\u0005o\\2i\u001f:4\u0015N]:u\r\u0016$8\r[(oYfD#a\u0011\u0018\t\u000b\u001d\u0003A\u0011A\u0015\u00029MDw.\u001e7e\r\u0016$8\r[(oKJ+\u0007\u000f\\5dC\u0006#\u0018\tV5nK\"\u0012aI\f\u0005\u0006\u0015\u0002!\t!K\u0001.g\"|W\u000f\u001c3GKR\u001c\u0007NT8o\t\u0016d\u0017-_3e\u0003:$gj\u001c8UeVt7-\u0019;j]\u001e\u0014V\r\u001d7jG\u0006\u001c\bFA%/\u0011\u0015i\u0005\u0001\"\u0001O\u0003\u0011\u0019H/\u001e2\u0015\r=s6-Z4j!\r\u00016+V\u0007\u0002#*\u0011!+H\u0001\tK\u0006\u001c\u00180\\8dW&\u0011A+\u0015\u0002\u0014\u0013\u0016C\b/Z2uCRLwN\\*fiR,'o\u001d\t\u0004\u0013YC\u0016BA,\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\fX\u0007\u00025*\u00111\fB\u0001\bG2,8\u000f^3s\u0013\ti&LA\u0005QCJ$\u0018\u000e^5p]\")q\f\u0014a\u0001A\u0006Y!/\u001a9mS\u000e\fG+\r91!\tI\u0016-\u0003\u0002c5\n9!+\u001a9mS\u000e\f\u0007\"\u00023M\u0001\u0004\u0001\u0017a\u0003:fa2L7-\u0019+2aFBQA\u001a'A\u0002\u0001\fQBZ;ukJ,'+\u001a9mS\u000e\f\u0007\"\u00025M\u0001\u0004A\u0016!\u00039beRLG/[8o\u0011\u0015QG\n1\u0001l\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"A\u00057\n\u00055\u0014!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006_\u0002!\t\u0001]\u0001\u0016gR,(mV5uQ\u001a+Go\u00195NKN\u001c\u0018mZ3t)\u001d\t(o\u001d;vm^\u00042\u0001U*+\u0011\u0015yf\u000e1\u0001a\u0011\u0015!g\u000e1\u0001a\u0011\u00151g\u000e1\u0001a\u0011\u0015Ag\u000e1\u0001Y\u0011\u0015Qg\u000e1\u0001l\u0011\u0015Ah\u000e1\u0001z\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0002QurL!a_)\u0003\u000f\r\u000b\u0007\u000f^;sKB!\u0011\"`@+\u0013\tq(BA\u0005Gk:\u001cG/[8ocA1\u0011\u0011AA\u0004\u0003\u0017i!!a\u0001\u000b\u0007\u0005\u0015!\"\u0001\u0006d_2dWm\u0019;j_:LA!!\u0003\u0002\u0004\t\u00191+Z9\u0011\r%\tiAFA\t\u0013\r\tyA\u0003\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007I\t\u0019\"C\u0002\u0002\u0016\t\u0011!CR3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uC\u0002")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    @Test
    public void issuesEpochRequestFromLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        LeaderEpochCache leaderEpochs = (LeaderEpochCache)EasyMock.createNiceMock(LeaderEpochCache.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 2;
        int leo = 13;
        EasyMock.expect((Object)replica.epochs()).andReturn((Object)new Some((Object)leaderEpochs)).anyTimes();
        EasyMock.expect((Object)leaderEpochs.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch, (long)leo)).anyTimes();
        this.stub(replica, replica, futureReplica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{leaderEpochs, replicaManager, replica});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, null, null);
        Map result = thread.fetchEpochsFromLeader((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)BoxesRunTime.boxToInteger((int)leaderEpoch))})));
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(Errors.NONE, leaderEpoch, (long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(Errors.NONE, leaderEpoch, (long)leo))}));
        Assert.assertEquals((String)"results from leader epoch request should have offset from local replica", (Object)expected, (Object)result);
    }

    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        LeaderEpochCache leaderEpochs = (LeaderEpochCache)EasyMock.createNiceMock(LeaderEpochCache.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 2;
        int leo = 13;
        EasyMock.expect((Object)replica.epochs()).andReturn((Object)new Some((Object)leaderEpochs)).anyTimes();
        EasyMock.expect((Object)leaderEpochs.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch, (long)leo)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p0())).andReturn((Object)replica).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p1())).andThrow((Throwable)new KafkaStorageException()).once();
        EasyMock.expect((Object)replicaManager.getPartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.replay((Object[])new Object[]{leaderEpochs, replicaManager, replica});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, null, null);
        Map result = thread.fetchEpochsFromLeader((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)BoxesRunTime.boxToInteger((int)leaderEpoch))})));
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(Errors.NONE, leaderEpoch, (long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(Errors.KAFKA_STORAGE_ERROR, -1, -1L))}));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void shouldTruncateToReplicaOffset() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LeaderEpochCache leaderEpochsT1p0 = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        LeaderEpochCache leaderEpochsT1p1 = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        LeaderEpochCache futureReplicaLeaderEpochs = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replicaT1p0 = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica replicaT1p1 = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replicaT1p0.epochs()).andReturn((Object)new Some((Object)leaderEpochsT1p0)).anyTimes();
        EasyMock.expect((Object)replicaT1p1.epochs()).andReturn((Object)new Some((Object)leaderEpochsT1p1)).anyTimes();
        EasyMock.expect((Object)futureReplica.epochs()).andReturn((Object)new Some((Object)futureReplicaLeaderEpochs)).anyTimes();
        EasyMock.expect((Object)futureReplica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)futureReplicaLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpochs.latestEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).anyTimes();
        EasyMock.expect((Object)leaderEpochsT1p0.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch, (long)replicaT1p0LEO)).anyTimes();
        EasyMock.expect((Object)leaderEpochsT1p1.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch, (long)replicaT1p1LEO)).anyTimes();
        EasyMock.expect((Object)futureReplicaLeaderEpochs.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch, (long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(replicaT1p0, replicaT1p1, futureReplica, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{leaderEpochsT1p0, leaderEpochsT1p1, futureReplicaLeaderEpochs, replicaManager, logManager, quotaManager, replicaT1p0, replicaT1p1, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)BoxesRunTime.boxToLong((long)0L))})));
        thread.doWork();
        Assert.assertTrue((boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaT1p0LEO)));
        Assert.assertTrue((boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)futureReplicaLEO)));
    }

    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LeaderEpochCache leaderEpochs = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        LeaderEpochCache futureReplicaLeaderEpochs = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.epochs()).andReturn((Object)new Some((Object)leaderEpochs)).anyTimes();
        EasyMock.expect((Object)futureReplica.epochs()).andReturn((Object)new Some((Object)futureReplicaLeaderEpochs)).anyTimes();
        EasyMock.expect((Object)futureReplica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)futureReplicaLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpochs.latestEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpochs.latestEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2))).once();
        EasyMock.expect((Object)leaderEpochs.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch - 1, (long)replicaLEO)).anyTimes();
        EasyMock.expect((Object)futureReplicaLeaderEpochs.endOffsetFor(leaderEpoch - 1)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch - 2, (long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)leaderEpochs.endOffsetFor(leaderEpoch - 2)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch - 2, (long)replicaEpochEndOffset)).anyTimes();
        EasyMock.expect((Object)futureReplicaLeaderEpochs.endOffsetFor(leaderEpoch - 2)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch - 2, (long)futureReplicaEpochEndOffset)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(replica, replica, futureReplica, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{leaderEpochs, futureReplicaLeaderEpochs, replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToLong((long)0L))})));
        thread.doWork();
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected offset ").append((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)).append((Object)" in captured truncation offsets ").append((Object)truncateToCapture.getValues()).toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)));
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        LeaderEpochCache leaderEpochs = (LeaderEpochCache)EasyMock.createNiceMock(LeaderEpochCache.class);
        LeaderEpochCache futureReplicaLeaderEpochs = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int initialFetchOffset = 100;
        int futureReplicaLEO = 111;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)futureReplica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)futureReplicaLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replica.epochs()).andReturn((Object)new Some((Object)leaderEpochs)).anyTimes();
        EasyMock.expect((Object)futureReplica.epochs()).andReturn((Object)new Some((Object)futureReplicaLeaderEpochs)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpochs.latestEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)-1)).anyTimes();
        EasyMock.expect((Object)leaderEpochs.endOffsetFor(-1)).andReturn((Object)new Tuple2.mcIJ.sp(-1, -1L)).anyTimes();
        this.stubWithFetchMessages(replica, replica, futureReplica, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, leaderEpochs, futureReplicaLeaderEpochs, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToLong((long)initialFetchOffset))})));
        thread.doWork();
        Assert.assertEquals((String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET", (long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LeaderEpochCache leaderEpochs = (LeaderEpochCache)EasyMock.createNiceMock(LeaderEpochCache.class);
        LeaderEpochCache futureReplicaLeaderEpochs = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.epochs()).andReturn((Object)new Some((Object)leaderEpochs)).anyTimes();
        EasyMock.expect((Object)futureReplica.epochs()).andReturn((Object)new Some((Object)futureReplicaLeaderEpochs)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpochs.latestEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)).anyTimes();
        EasyMock.expect((Object)leaderEpochs.endOffsetFor(futureReplicaLeaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(futureReplicaLeaderEpoch, (long)replicaLEO)).anyTimes();
        EasyMock.expect((Object)futureReplicaLeaderEpochs.endOffsetFor(futureReplicaLeaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(futureReplicaLeaderEpoch, (long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureReplica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)futureReplicaLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplica(this.t1p0())).andReturn((Object)new Some((Object)replica)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplica(this.t1p0(), Request$.MODULE$.FutureLocalReplicaId())).andReturn((Object)new Some((Object)futureReplica)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p0(), Request$.MODULE$.FutureLocalReplicaId())).andReturn((Object)futureReplica).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p0())).andThrow((Throwable)new ReplicaNotAvailableException("")).times(3);
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p0())).andReturn((Object)replica).once();
        EasyMock.expect((Object)replicaManager.getPartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (IsolationLevel)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, responseCallback){
            private final Capture responseCallback$2;

            public void answer() {
                ((Function1)this.responseCallback$2.getValue()).apply((Object)Seq$.MODULE$.empty());
            }
            {
                this.responseCallback$2 = responseCallback$2;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{leaderEpochs, futureReplicaLeaderEpochs, replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToLong((long)0L))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, thread){
            public static final long serialVersionUID = 0L;
            private final ReplicaAlterLogDirsThread thread$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.thread$1.doWork();
            }
            {
                this.thread$1 = thread$1;
            }
        });
        Assert.assertEquals((long)0L, (long)truncated.getValues().size());
        thread.doWork();
        Assert.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LeaderEpochCache leaderEpochs = (LeaderEpochCache)EasyMock.createNiceMock(LeaderEpochCache.class);
        LeaderEpochCache futureReplicaLeaderEpochs = (LeaderEpochCache)EasyMock.createMock(LeaderEpochCache.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        partition.truncateTo((long)futureReplicaLEO, true);
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replica.epochs()).andReturn((Object)new Some((Object)leaderEpochs)).anyTimes();
        EasyMock.expect((Object)futureReplica.epochs()).andReturn((Object)new Some((Object)futureReplicaLeaderEpochs)).anyTimes();
        EasyMock.expect((Object)futureReplica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)futureReplicaLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpochs.latestEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        EasyMock.expect((Object)leaderEpochs.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch, (long)replicaLEO));
        EasyMock.expect((Object)futureReplicaLeaderEpochs.endOffsetFor(leaderEpoch)).andReturn((Object)new Tuple2.mcIJ.sp(leaderEpoch, (long)futureReplicaLEO));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(replica, replica, futureReplica, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{leaderEpochs, futureReplicaLeaderEpochs, replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToLong((long)0L))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, thread){
            public static final long serialVersionUID = 0L;
            private final ReplicaAlterLogDirsThread thread$2;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                this.thread$2.doWork();
            }
            {
                this.thread$2 = thread$2;
            }
        });
        EasyMock.verify((Object[])new Object[]{partition});
    }

    @Test
    public void shouldFetchOneReplicaAtATime() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)123L)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(replica, replica, futureReplica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)BoxesRunTime.boxToLong((long)0L))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetchRequest((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.t1p0(), (Object)new PartitionFetchState(150L)), new Tuple2((Object)this.t1p1(), (Object)new PartitionFetchState(160L))})));
        if (resultWithPartitions != null) {
            Tuple2 tuple2;
            ReplicaAlterLogDirsThread.FetchRequest fetchRequest = (ReplicaAlterLogDirsThread.FetchRequest)resultWithPartitions.result();
            Set partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)fetchRequest, (Object)partitionsWithError);
            ReplicaAlterLogDirsThread.FetchRequest fetchRequest2 = (ReplicaAlterLogDirsThread.FetchRequest)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            Assert.assertFalse((boolean)fetchRequest2.isEmpty());
            Assert.assertFalse((boolean)partitionsWithError2.nonEmpty());
            FetchRequest request = (FetchRequest)fetchRequest2.underlying().build();
            Assert.assertEquals((long)0L, (long)request.minBytes());
            Seq fetchInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq();
            Assert.assertEquals((long)1L, (long)fetchInfos.length());
            Assert.assertEquals((String)"Expected fetch request for largest partition", (Object)this.t1p1(), (Object)((Tuple2)fetchInfos.head())._1());
            Assert.assertEquals((long)160L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
            return;
        }
        throw new MatchError((Object)resultWithPartitions);
    }

    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)123L)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(replica, replica, futureReplica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)BoxesRunTime.boxToLong((long)0L))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetchRequest((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.t1p0(), (Object)new PartitionFetchState(150L)), new Tuple2((Object)this.t1p1(), (Object)new PartitionFetchState(160L, true))})));
        if (resultWithPartitions != null) {
            Tuple2 tuple2;
            ReplicaAlterLogDirsThread.FetchRequest fetchRequest = (ReplicaAlterLogDirsThread.FetchRequest)resultWithPartitions.result();
            Set partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)fetchRequest, (Object)partitionsWithError);
            ReplicaAlterLogDirsThread.FetchRequest fetchRequest2 = (ReplicaAlterLogDirsThread.FetchRequest)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            Assert.assertFalse((boolean)fetchRequest2.isEmpty());
            Assert.assertFalse((boolean)partitionsWithError2.nonEmpty());
            Seq fetchInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest2.underlying().build()).fetchData()).asScala()).toSeq();
            Assert.assertEquals((long)1L, (long)fetchInfos.length());
            Assert.assertEquals((String)"Expected fetch request for non-truncating partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos.head())._1());
            Assert.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
            AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.buildFetchRequest((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.t1p0(), (Object)new PartitionFetchState(140L)), new Tuple2((Object)this.t1p1(), (Object)new PartitionFetchState(160L, new DelayedItem(5000L)))})));
            if (resultWithPartitions2 != null) {
                Tuple2 tuple23;
                ReplicaAlterLogDirsThread.FetchRequest fetchRequest22 = (ReplicaAlterLogDirsThread.FetchRequest)resultWithPartitions2.result();
                Set partitionsWithError22 = resultWithPartitions2.partitionsWithError();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)fetchRequest22, (Object)partitionsWithError22);
                ReplicaAlterLogDirsThread.FetchRequest fetchRequest23 = (ReplicaAlterLogDirsThread.FetchRequest)tuple24._1();
                Set partitionsWithError23 = (Set)tuple24._2();
                Assert.assertFalse((boolean)fetchRequest23.isEmpty());
                Assert.assertFalse((boolean)partitionsWithError23.nonEmpty());
                Seq fetchInfos2 = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest23.underlying().build()).fetchData()).asScala()).toSeq();
                Assert.assertEquals((long)1L, (long)fetchInfos2.length());
                Assert.assertEquals((String)"Expected fetch request for non-delayed partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos2.head())._1());
                Assert.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
                AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.buildFetchRequest((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.t1p0(), (Object)new PartitionFetchState(140L, new DelayedItem(5000L))), new Tuple2((Object)this.t1p1(), (Object)new PartitionFetchState(160L, new DelayedItem(5000L)))})));
                if (resultWithPartitions3 != null) {
                    Tuple2 tuple25;
                    ReplicaAlterLogDirsThread.FetchRequest fetchRequest3 = (ReplicaAlterLogDirsThread.FetchRequest)resultWithPartitions3.result();
                    Set partitionsWithError3 = resultWithPartitions3.partitionsWithError();
                    Tuple2 tuple26 = tuple25 = new Tuple2((Object)fetchRequest3, (Object)partitionsWithError3);
                    ReplicaAlterLogDirsThread.FetchRequest fetchRequest32 = (ReplicaAlterLogDirsThread.FetchRequest)tuple26._1();
                    Set partitionsWithError32 = (Set)tuple26._2();
                    Assert.assertTrue((String)"Expected no fetch requests since all partitions are delayed", (boolean)fetchRequest32.isEmpty());
                    Assert.assertFalse((boolean)partitionsWithError32.nonEmpty());
                    return;
                }
                throw new MatchError((Object)resultWithPartitions3);
            }
            throw new MatchError((Object)resultWithPartitions2);
        }
        throw new MatchError((Object)resultWithPartitions);
    }

    public IExpectationSetters<Option<Partition>> stub(Replica replicaT1p0, Replica replicaT1p1, Replica futureReplica, Partition partition, ReplicaManager replicaManager) {
        EasyMock.expect((Object)replicaManager.getReplica(this.t1p0())).andReturn((Object)new Some((Object)replicaT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplica(this.t1p0(), Request$.MODULE$.FutureLocalReplicaId())).andReturn((Object)new Some((Object)futureReplica)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p0())).andReturn((Object)replicaT1p0).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p0(), Request$.MODULE$.FutureLocalReplicaId())).andReturn((Object)futureReplica).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplica(this.t1p1())).andReturn((Object)new Some((Object)replicaT1p1)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplica(this.t1p1(), Request$.MODULE$.FutureLocalReplicaId())).andReturn((Object)new Some((Object)futureReplica)).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p1())).andReturn((Object)replicaT1p1).anyTimes();
        EasyMock.expect((Object)replicaManager.getReplicaOrException(this.t1p1(), Request$.MODULE$.FutureLocalReplicaId())).andReturn((Object)futureReplica).anyTimes();
        return EasyMock.expect((Object)replicaManager.getPartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
    }

    public IExpectationSetters<BoxedUnit> stubWithFetchMessages(Replica replicaT1p0, Replica replicaT1p1, Replica futureReplica, Partition partition, ReplicaManager replicaManager, Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(replicaT1p0, replicaT1p1, futureReplica, partition, replicaManager);
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture(responseCallback), (IsolationLevel)EasyMock.anyObject());
        return EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, responseCallback){
            private final Capture responseCallback$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Seq$.MODULE$.empty());
            }
            {
                this.responseCallback$1 = responseCallback$1;
            }
        }).anyTimes();
    }
}

