/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001\u001d\u0011ADU3tKR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005a\u0019uN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oIR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000fE\u0001!\u0019!C\u0001%\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003vi&d'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019a\u0002\u0001)A\u0005'\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0019!x\u000e]5dcU\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$/\u0005!A.\u00198h\u0013\t)#E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000fQ|\u0007/[22A!9\u0011\u0006\u0001b\u0001\n\u0003y\u0012A\u0002;pa&\u001c'\u0007\u0003\u0004,\u0001\u0001\u0006I\u0001I\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015i\u0003\u0001\"\u0011/\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u0018\u0011\u0007ARTH\u0004\u00022o9\u0011!'N\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0003Y\nQa]2bY\u0006L!\u0001O\u001d\u0002\u000fA\f7m[1hK*\ta'\u0003\u0002<y\t\u00191+Z9\u000b\u0005aJ\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!i\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003E\u0001\u0011\u0005Q)\u0001\u0011uKN$(+Z:fi>3gm]3ug:{G/\u0012=jgRLgnZ$s_V\u0004H#\u0001$\u0011\u0005\u001dCU\"A\u001d\n\u0005%K$\u0001B+oSRD#aQ&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015!\u00026v]&$(\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u001b\n!A+Z:u\u0011\u0015!\u0006\u0001\"\u0001F\u0003u!Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=jgRLgn\u001a+pa&\u001c\u0007FA*L\u0011\u00159\u0006\u0001\"\u0001F\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8M_\u000e\fG\u000eR1uKRKW.\u001a\u0015\u0003-.CQA\u0017\u0001\u0005\u0002\u0015\u000bq\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_j{g.\u001a3ECR,G+[7fQ\tI6\nC\u0003^\u0001\u0011\u0005Q)\u0001\u000euKN$(+Z:fi>3gm]3ug\nKH)\u001e:bi&|g\u000e\u000b\u0002]\u0017\")\u0001\r\u0001C\u0001\u000b\u0006!C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]R{W)\u0019:mS\u0016\u001cH\u000f\u000b\u0002`\u0017\")1\r\u0001C\u0001\u000b\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti\"\u0012!m\u0013\u0005\u0006M\u0002!\t!R\u0001\u0019i\u0016\u001cHOU3tKR|eMZ:fiN$v\u000eT1uKN$\bFA3L\u0011\u0015I\u0007\u0001\"\u0001F\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0015\u0003Q.CQ\u0001\u001c\u0001\u0005\u0002\u0015\u000b\u0001\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_N\u0003XmY5gS\u000e|eMZ:fi\"\u00121n\u0013\u0005\u0006_\u0002!\t!R\u0001\u001ai\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u!2,8\u000f\u000b\u0002o\u0017\")!\u000f\u0001C\u0001\u000b\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go]*iS\u001a$X*\u001b8vg\"\u0012\u0011o\u0013\u0005\u0006k\u0002!\t!R\u0001)i\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u0005fdun^3s)\"\fg.R1sY&,7\u000f\u001e\u0015\u0003i.CQ\u0001\u001f\u0001\u0005\u0002\u0015\u000bq\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=IS\u001eDWM\u001d+iC:d\u0015\r^3ti\"\u0012qo\u0013\u0005\u0006w\u0002!\t!R\u0001%i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\"\u0012!p\u0013\u0005\u0006}\u0002!\t!R\u00011i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8)\u0005u\\\u0005BBA\u0002\u0001\u0011\u0005Q)\u0001\u0012uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148U_BL7m\u001d\u0015\u0004\u0003\u0003Y\u0005BBA\u0005\u0001\u0011\u0005Q)A\u0018uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148U_BL7m]!oIB\u000b'\u000f^5uS>t7\u000fK\u0002\u0002\b-Ca!a\u0004\u0001\t\u0003)\u0015\u0001\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t\u000bb\u0004xN\u001d;J[B|'\u000f\u001e)mC:D3!!\u0004L\u0011\u0019\t)\u0002\u0001C\u0001\u000b\u0006QC/Z:u%\u0016\u001cX\r^,ji\",fN]3d_\u001et\u0017N_3e\u001d\u0016<8i\u001c8tk6,'o\u00149uS>t\u0007fBA\n\u0017\u0006e\u00111D\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0011\u00111E\u0001\u000bU>\u0004Ho]5na2,\u0017\u0002BA\u0014\u0003C\u0011qb\u00149uS>tW\t_2faRLwN\u001c\u0005\b\u0003W\u0001A\u0011BA\u0017\u0003=\u0001(o\u001c3vG\u0016lUm]:bO\u0016\u001cH#\u0002$\u00020\u0005}\u0002\u0002CA\u0019\u0003S\u0001\r!a\r\u0002\u000bQ|\u0007/[2\u0011\t\u0005U\u00121\b\b\u0004\u000f\u0006]\u0012bAA\u001ds\u00051\u0001K]3eK\u001aL1!JA\u001f\u0015\r\tI$\u000f\u0005\t\u0003\u0003\nI\u00031\u0001\u0002D\u0005Ya.^7NKN\u001c\u0018mZ3t!\r9\u0015QI\u0005\u0004\u0003\u000fJ$aA%oi\"9\u00111\n\u0001\u0005\n\u00055\u0013!\u00079s_\u0012,8-Z\"p]N,X.Z!oINCW\u000f\u001e3po:$rARA(\u0003#\n)\u0006\u0003\u0005\u00022\u0005%\u0003\u0019AA\u001a\u0011!\t\u0019&!\u0013A\u0002\u0005\r\u0013!\u0004;pi\u0006dW*Z:tC\u001e,7\u000f\u0003\u0006\u0002X\u0005%\u0003\u0013!a\u0001\u0003\u0007\nAB\\;n\u0007>t7/^7feNDq!a\u0017\u0001\t\u0013\ti&A\u000bbo\u0006LGoQ8ogVlWM\u001d)s_\u001e\u0014Xm]:\u0015\u000b\u0019\u000by&!\u0019\t\u0015\u0005E\u0012\u0011\fI\u0001\u0002\u0004\t\u0019\u0004\u0003\u0005\u0002d\u0005e\u0003\u0019AA3\u0003\u0015\u0019w.\u001e8u!\r9\u0015qM\u0005\u0004\u0003SJ$\u0001\u0002'p]\u001eDq!!\u001c\u0001\t\u0013\ty'A\u000bsKN,G/\u00118e\u0003N\u001cXM\u001d;PM\u001a\u001cX\r^:\u0015\u0013\u0019\u000b\t(a\u001f\u0002\u0000\u0005\r\u0005\u0002CA:\u0003W\u0002\r!!\u001e\u0002\t\u0005\u0014xm\u001d\t\u0006\u000f\u0006]\u00141G\u0005\u0004\u0003sJ$!B!se\u0006L\b\u0002CA?\u0003W\u0002\r!!\u001a\u0002\u001d\u0015D\b/Z2uK\u0012|eMZ:fi\"Q\u0011\u0011QA6!\u0003\u0005\r!a\r\u0002\u000b\u001d\u0014x.\u001e9\t\u0015\u0005\u0015\u00151\u000eI\u0001\u0002\u0004\t9)\u0001\u0004eef\u0014VO\u001c\t\u0004\u000f\u0006%\u0015bAAFs\t9!i\\8mK\u0006t\u0007bBAH\u0001\u0011%\u0011\u0011S\u0001\u001fe\u0016\u001cX\r^!oI\u0006\u001b8/\u001a:u\u001f\u001a47/\u001a;t\u0007>lW.\u001b;uK\u0012$rARAJ\u0003[\u000bI\r\u0003\u0005\u0002\u0016\u00065\u0005\u0019AAL\u0003Q\u0019wN\\:v[\u0016\u0014xI]8vaN+'O^5dKB!\u0011\u0011TAT\u001d\u0011\tY*a)\u000f\t\u0005u\u0015\u0011\u0015\b\u0004e\u0005}\u0015\"A\u0003\n\u0005\r!\u0011bAAS\u0005\u0005!2i\u001c8tk6,'o\u0012:pkB\u001cu.\\7b]\u0012LA!!+\u0002,\n!2i\u001c8tk6,'o\u0012:pkB\u001cVM\u001d<jG\u0016T1!!*\u0003\u0011!\ty+!$A\u0002\u0005E\u0016aD3ya\u0016\u001cG/\u001a3PM\u001a\u001cX\r^:\u0011\u0011\u0005U\u00121WA\\\u0003KJA!!.\u0002>\t\u0019Q*\u00199\u0011\t\u0005e\u0016QY\u0007\u0003\u0003wSA!!0\u0002@\u000611m\\7n_:T1!BAa\u0015\r\t\u0019mT\u0001\u0007CB\f7\r[3\n\t\u0005\u001d\u00171\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\t\t$!$A\u0002\u0005M\u0002bBAg\u0001\u0011%\u0011qZ\u0001\re\u0016\u001cX\r^(gMN,Go\u001d\u000b\u0005\u0003c\u000b\t\u000e\u0003\u0005\u0002\u0016\u0006-\u0007\u0019AAL\u0011%\t)\u000eAI\u0001\n\u0013\t9.A\u0010sKN,G/\u00118e\u0003N\u001cXM\u001d;PM\u001a\u001cX\r^:%I\u00164\u0017-\u001e7uIM*\"!!7+\t\u0005M\u00121\\\u0016\u0003\u0003;\u0004B!a8\u0002j6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/A\u0005v]\u000eDWmY6fI*\u0019\u0011q]\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002l\u0006\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u001e\u0001\u0012\u0002\u0013%\u0011\u0011_\u0001 e\u0016\u001cX\r^!oI\u0006\u001b8/\u001a:u\u001f\u001a47/\u001a;tI\u0011,g-Y;mi\u0012\"TCAAzU\u0011\t9)a7\t\u0013\u0005]\b!%A\u0005\n\u0005]\u0017aH1xC&$8i\u001c8tk6,'\u000f\u0015:pOJ,7o\u001d\u0013eK\u001a\fW\u000f\u001c;%c!I\u00111 \u0001\u0012\u0002\u0013%\u0011Q`\u0001$aJ|G-^2f\u0007>t7/^7f\u0003:$7\u000b[;uI><h\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\tyP\u000b\u0003\u0002D\u0005m\u0007")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "missing.group", "--all-topics", "--to-current", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        Map resetOffsets2 = consumerGroupCommand.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets2);
        String x$6 = "missing.group";
        String x$7 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets2, this.committedOffsets(x$7, x$6));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "new.group", "--topic", this.topic(), "--to-offset", "50"});
        this.produceMessages(this.topic(), 100);
        String[] x$8 = args;
        long x$9 = 50L;
        boolean x$10 = true;
        String x$11 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$8, x$9, x$11, x$10);
        String[] x$12 = (String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$13 = 50L;
        boolean x$14 = true;
        String x$15 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$12, x$13, x$15, x$14);
        this.resetAndAssertOffsets((String[])Predef$.MODULE$.refArrayOps((Object[])args).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, "new.group", this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        long x$16 = 100L;
        String x$17 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$17, x$16);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"});
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        long x$18 = 100L;
        String x$19 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$19, x$18);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(checkpoint), "--execute"});
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT1M", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT0.1S", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-latest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-current", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "1", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic(), "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$20 = topic;
        int x$21 = 2;
        int x$22 = 1;
        Properties x$23 = qual$1.createTopic$default$4();
        RackAwareMode x$24 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$20, x$21, x$22, x$23, x$24);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        AdminZkClient qual$2 = this.adminZkClient();
        String x$25 = topic1;
        int x$26 = 1;
        int x$27 = 1;
        Properties x$28 = qual$2.createTopic$default$4();
        RackAwareMode x$29 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$25, x$26, x$27, x$28, x$29);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$30 = topic2;
        int x$31 = 1;
        int x$32 = 1;
        Properties x$33 = qual$3.createTopic$default$4();
        RackAwareMode x$34 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$30, x$31, x$32, x$33, x$34);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, 100, 1);
        this.produceConsumeAndShutdown(topic2, 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), allResetOffsets);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        AdminZkClient qual$4 = this.adminZkClient();
        String x$35 = topic1;
        int x$36 = 2;
        int x$37 = 1;
        Properties x$38 = qual$4.createTopic$default$4();
        RackAwareMode x$39 = qual$4.createTopic$default$5();
        qual$4.createTopic(x$35, x$36, x$37, x$38, x$39);
        AdminZkClient qual$5 = this.adminZkClient();
        String x$40 = topic2;
        int x$41 = 2;
        int x$42 = 1;
        Properties x$43 = qual$5.createTopic$default$4();
        RackAwareMode x$44 = qual$5.createTopic$default$5();
        qual$5.createTopic(x$40, x$41, x$42, x$43, x$44);
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic1})), "--topic", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic2})), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, 100, 2);
        this.produceConsumeAndShutdown(topic2, 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), allResetOffsets);
        Assert.assertEquals((Object)priorCommittedOffsets1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)priorCommittedOffsets2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        AdminZkClient qual$6 = this.adminZkClient();
        String x$45 = topic;
        int x$46 = 2;
        int x$47 = 1;
        Properties x$48 = qual$6.createTopic$default$4();
        RackAwareMode x$49 = qual$6.createTopic$default$5();
        qual$6.createTopic(x$45, x$46, x$47, x$48, x$49);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToReset(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)exportedOffsets.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$2) {
                return x$2.offset();
            }
        }));
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)importedOffsets.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$3) {
                return x$3.offset();
            }
        }));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test(expected=OptionException.class)
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        this.getConsumerGroupService(cgcArgs);
    }

    private void produceMessages(String topic, int numMessages) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final ProducerRecord<byte[], byte[]> apply(int x$4) {
                return new ProducerRecord(this.topic$1, (Object)new byte[100000]);
            }
            {
                this.topic$1 = topic$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records2, 1, TestUtils$.MODULE$.produceMessages$default$4());
    }

    private void produceConsumeAndShutdown(String topic, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        this.awaitConsumerProgress(topic, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$3() {
        return 1;
    }

    private void awaitConsumerProgress(String topic, long count) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResetConsumerGroupOffsetTest $outer;
            private final String topic$2;
            private final long count$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Iterable offsets = this.$outer.committedOffsets(this.topic$2, this.$outer.committedOffsets$default$2()).values();
                return this.count$1 == BoxesRunTime.unboxToLong((Object)offsets.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.count$1 = count$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected that consumer group has consumed all messages from topic/partition.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    /*
     * WARNING - void declaration
     */
    private void resetAndAssertOffsets(String[] args, long expectedOffset, String group, boolean dryRun) {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        try {
            String x$50 = group;
            String x$51 = this.committedOffsets$default$1();
            Map priorOffsets = this.committedOffsets(x$51, x$50);
            Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}));
            Assert.assertEquals((Object)expectedOffsets, this.resetOffsets(consumerGroupCommand));
            String x$52 = group;
            String x$53 = this.committedOffsets$default$1();
            Assert.assertEquals((Object)(dryRun ? priorOffsets : expectedOffsets), this.committedOffsets(x$53, x$52));
        }
        catch (Throwable throwable) {
            void var6_5;
            var6_5.close();
            throw throwable;
        }
        consumerGroupCommand.close();
    }

    private String resetAndAssertOffsets$default$3() {
        return this.group();
    }

    private boolean resetAndAssertOffsets$default$4() {
        return false;
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, Map<TopicPartition, Object> expectedOffsets, String topic) {
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupService);
        allResetOffsets.foreach((Function1)new Serializable(this, expectedOffsets){
            public static final long serialVersionUID = 0L;
            private final Map expectedOffsets$1;

            public final void apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)this.expectedOffsets$1.apply((Object)tp)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.expectedOffsets$1 = expectedOffsets$1;
            }
        });
        Assert.assertEquals(expectedOffsets, this.committedOffsets(topic, this.committedOffsets$default$2()));
    }

    private Map<TopicPartition, Object> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$5) {
                return x$5.offset();
            }
        });
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

