/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.cluster.Replica;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0003\u001b\u0001\u0011\u00053$\u0001\u0006ok6\u0014%o\\6feN,\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0004\u0013:$\bbB\u0012\u0001\u0005\u0004%\taG\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u001d\u00039\u0001(o\u001c3vG\u0016\u00148i\\;oi\u0002Bqa\n\u0001C\u0002\u0013\u00051$A\u0007d_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u001d\r|gn];nKJ\u001cu.\u001e8uA!91\u0006\u0001b\u0001\n\u0003a\u0013!C2p]N,X.\u001a:t+\u0005i\u0003c\u0001\u00184k5\tqF\u0003\u00021c\u00059Q.\u001e;bE2,'B\u0001\u001a\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003i=\u0012aAQ;gM\u0016\u0014\b\u0003\u0002\u001cA\u0005\nk\u0011a\u000e\u0006\u0003qe\n\u0001bY8ogVlWM\u001d\u0006\u0003um\nqa\u00197jK:$8O\u0003\u0002\u0006y)\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0013\t\tuGA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0004;\r+\u0015B\u0001#\u001f\u0005\u0015\t%O]1z!\tib)\u0003\u0002H=\t!!)\u001f;f\u0011\u0019I\u0005\u0001)A\u0005[\u0005Q1m\u001c8tk6,'o\u001d\u0011\t\u000f-\u0003!\u0019!C\u0001\u0019\u0006I\u0001O]8ek\u000e,'o]\u000b\u0002\u001bB\u0019af\r(\u0011\t=\u0013&IQ\u0007\u0002!*\u0011\u0011+O\u0001\taJ|G-^2fe&\u00111\u000b\u0015\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\rU\u0003\u0001\u0015!\u0003N\u0003)\u0001(o\u001c3vG\u0016\u00148\u000f\t\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0003\u0015!x\u000e]5d+\u0005I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0007'R\u0014\u0018N\\4\t\r\t\u0004\u0001\u0015!\u0003Z\u0003\u0019!x\u000e]5dA!9A\r\u0001b\u0001\n\u0003Y\u0012\u0001\u00029beRDaA\u001a\u0001!\u0002\u0013a\u0012!\u00029beR\u0004\u0003b\u00025\u0001\u0005\u0004%\t![\u0001\u0003iB,\u0012A\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[n\naaY8n[>t\u0017BA8m\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!\u001d\u0001!\u0002\u0013Q\u0017a\u0001;qA!91\u000f\u0001b\u0001\n\u0003Y\u0012aE4sC\u000e,g-\u001e7DY>\u001cX\rV5nK6\u001b\bBB;\u0001A\u0003%A$\u0001\u000bhe\u0006\u001cWMZ;m\u00072|7/\u001a+j[\u0016l5\u000f\t\u0005\bo\u0002\u0011\r\u0011\"\u0001y\u0003!)\u00070Z2vi>\u0014X#A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018AC2p]\u000e,(O]3oi*\u0011a0X\u0001\u0005kRLG.C\u0002\u0002\u0002m\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001d\t)\u0001\u0001Q\u0001\ne\f\u0011\"\u001a=fGV$xN\u001d\u0011\t\u0013\u0005%\u0001A1A\u0005\u0002\u0005-\u0011A\u00049s_\u0012,8-\u001a:D_:4\u0017nZ\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00125\tQ0C\u0002\u0002\u0014u\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\t9\u0002\u0001Q\u0001\n\u00055\u0011a\u00049s_\u0012,8-\u001a:D_:4\u0017n\u001a\u0011\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005-\u0011AD2p]N,X.\u001a:D_:4\u0017n\u001a\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u000e\u0005y1m\u001c8tk6,'oQ8oM&<\u0007\u0005C\u0004\u0002$\u0001!\t!!\n\u0002\u0019M,'O^3s\u0007>tg-[4\u0015\u0005\u00055\u0001bBA\u0015\u0001\u0011\u0005\u00131F\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\u0011\u0011Q\u0006\t\u0007\u0003_\ty$!\u0012\u000f\t\u0005E\u00121\b\b\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012bAA\u001f=\u00059\u0001/Y2lC\u001e,\u0017\u0002BA!\u0003\u0007\u00121aU3r\u0015\r\tiD\b\t\u0004\u0013\u0005\u001d\u0013bAA%\u0015\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\ti\u0005\u0001C!\u0003\u001f\nQa]3u+B$\"!!\u0015\u0011\u0007u\t\u0019&C\u0002\u0002Vy\u0011A!\u00168ji\"\"\u00111JA-!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0}\u0005)!.\u001e8ji&!\u00111MA/\u0005\u0019\u0011UMZ8sK\"9\u0011q\r\u0001\u0005\u0002\u0005%\u0014AD2sK\u0006$X\r\u0015:pIV\u001cWM]\u000b\u0002\u001d\"9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014AD2sK\u0006$XmQ8ogVlWM]\u000b\u0002k!9\u00111\u000f\u0001\u0005B\u0005=\u0013\u0001\u0003;fCJ$un\u001e8)\t\u0005E\u0014q\u000f\t\u0005\u00037\nI(\u0003\u0003\u0002|\u0005u#!B!gi\u0016\u0014\bbBA@\u0001\u0011\u0005\u0011qJ\u0001\"i\u0016\u001cHoQ8ogVl\u0007\u000f^5p]^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u0015\u0005\u0003{\n\u0019\t\u0005\u0003\u0002\\\u0005\u0015\u0015\u0002BAD\u0003;\u0012a!S4o_J,\u0007\u0006BA?\u0003\u0017\u0003B!a\u0017\u0002\u000e&!\u0011qRA/\u0005\u0011!Vm\u001d;\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u0006I2m\u001c8tk6,w+\u001b;i\u0005J|7.\u001a:GC&dWO]3t)\u0011\t\t&a&\t\u000f\u0005e\u0015\u0011\u0013a\u00019\u0005Aa.^7Ji\u0016\u00148\u000fC\u0004\u0002\u001e\u0002!\t!a\u0014\u0002GQ,7\u000f^*fK.\fe\u000eZ\"p[6LGoV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fg\"\"\u00111TAF\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003K\u000bqd]3fW\u0006sGmQ8n[&$x+\u001b;i\u0005J|7.\u001a:GC&dWO]3t)\u0011\t\t&a*\t\u000f\u0005e\u0015\u0011\u0015a\u00019!9\u00111\u0016\u0001\u0005\u0002\u0005=\u0013!\t;fgR\u001cVOY:de&\u0014Wm\u00165f]R{\u0007/[2V]\u00064\u0018-\u001b7bE2,\u0007\u0006BAU\u0003\u0017Cq!!-\u0001\t\u0003\ty%A\u0005uKN$8\t\\8tK\"\"\u0011qVAF\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000b!c\u00195fG.\u001cEn\\:f\u000f>|G\rU1uQR1\u0011\u0011KA^\u0003\u007fCq!!0\u00026\u0002\u0007A$\u0001\u0006ok6\u0014VmY8sIND\u0001\"!1\u00026\u0002\u0007\u00111Y\u0001\bOJ|W\u000f]%e!\u0011\t)-a3\u000f\u0007u\t9-C\u0002\u0002Jz\ta\u0001\u0015:fI\u00164\u0017b\u00011\u0002N*\u0019\u0011\u0011\u001a\u0010\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\u0006\u00013\r[3dW\u000ecwn]3XSRD7i\\8sI&t\u0017\r^8s\r\u0006LG.\u001e:f)!\t\t&!6\u0002X\u0006m\u0007bBA_\u0003\u001f\u0004\r\u0001\b\u0005\t\u00033\fy\r1\u0001\u0002D\u0006aA-\u001f8b[&\u001cwI]8va\"A\u0011Q\\Ah\u0001\u0004\t\u0019-A\u0006nC:,\u0018\r\\$s_V\u0004\bbBAq\u0001\u0011%\u00111]\u0001\u0010M&tGmQ8pe\u0012Lg.\u0019;peR\u0019A$!:\t\u0011\u0005\u001d\u0018q\u001ca\u0001\u0003\u0007\fQa\u001a:pkBDq!a;\u0001\t\u0013\ti/\u0001\u000fdQ\u0016\u001c7n\u00117pg\u0016<\u0016\u000e\u001e5DYV\u001cH/\u001a:GC&dWO]3\u0015\u0011\u0005E\u0013q^Ay\u0003kDq!!0\u0002j\u0002\u0007A\u0004\u0003\u0005\u0002t\u0006%\b\u0019AAb\u0003\u00199'o\\;qc!A\u0011q_Au\u0001\u0004\t\u0019-\u0001\u0004he>,\bO\r\u0005\b\u0003w\u0004A\u0011AA(\u0003a!Xm\u001d;DY>\u001cX\rR;sS:<'+\u001a2bY\u0006t7-\u001a\u0015\u0005\u0003s\fY\tC\u0004\u0003\u0002\u0001!IAa\u0001\u00023\rDWmY6DY>\u001cX\rR;sS:<'+\u001a2bY\u0006t7-\u001a\u000b\u000b\u0003#\u0012)Aa\u0002\u0003\n\tE\u0001\u0002CAa\u0003\u007f\u0004\r!a1\t\u000f]\u000by\u00101\u0001\u0002D\"9q/a@A\u0002\t-\u0001c\u0001>\u0003\u000e%\u0019!qB>\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001Ba\u0005\u0002\u0000\u0002\u0007!QC\u0001\u001cEJ|7.\u001a:t\u0003Z\f\u0017\u000e\\1cY\u0016$UO]5oO\u000ecwn]3\u0011\u0007u\u00119\"C\u0002\u0003\u001ay\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002n\u0001!IA!\b\u0015\u0007U\u0012y\u0002\u0003\u0005\u0002B\nm\u0001\u0019AAb\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005K\t\u0001d\u0019:fCR,7i\u001c8tk6,'/\u00118e%\u0016\u001cW-\u001b<f)\u001d)$q\u0005B\u0015\u0005[A\u0001\"!1\u0003\"\u0001\u0007\u00111\u0019\u0005\t\u0005W\u0011\t\u00031\u0001\u0003\u0016\u0005aQ.\u00198vC2\f5o]5h]\"9\u0011Q\u0018B\u0011\u0001\u0004a\u0002b\u0002B\u0019\u0001\u0011%!1G\u0001\u000fe\u0016\u001cW-\u001b<f%\u0016\u001cwN\u001d3t))\t\tF!\u000e\u00038\te\"1\b\u0005\u0007q\t=\u0002\u0019A\u001b\t\u000f\u0005u&q\u0006a\u00019!IqKa\f\u0011\u0002\u0003\u0007\u00111\u0019\u0005\u000b\u0005{\u0011y\u0003%AA\u0002\t}\u0012!\u0003;j[\u0016|W\u000f^'t!\ri\"\u0011I\u0005\u0004\u0005\u0007r\"\u0001\u0002'p]\u001eDqAa\u0012\u0001\t\u0013\u0011I%\u0001\ftk\nl\u0017\u000e^\"m_N,\u0017I\u001c3WC2LG-\u0019;f))\u0011YEa\u0016\u0003Z\tu#q\r\t\u0006u\n5#\u0011K\u0005\u0004\u0005\u001fZ(A\u0002$viV\u0014X\rE\u0002\u001e\u0005'J1A!\u0016\u001f\u0005\r\te.\u001f\u0005\u0007q\t\u0015\u0003\u0019A\u001b\t\u0011\tm#Q\ta\u0001\u0005\u007f\tab\u00197pg\u0016$\u0016.\\3pkRl5\u000f\u0003\u0005\u0003`\t\u0015\u0003\u0019\u0001B1\u00039i\u0017N\\\"m_N,G+[7f\u001bN\u0004R!\bB2\u0005\u007fI1A!\u001a\u001f\u0005\u0019y\u0005\u000f^5p]\"A!\u0011\u000eB#\u0001\u0004\u0011\t'\u0001\bnCb\u001cEn\\:f)&lW-T:\t\u000f\t5\u0004\u0001\"\u0003\u0003p\u0005\u00012\r[3dW\u000ecwn]3e'R\fG/\u001a\u000b\u0007\u0003#\u0012\tHa\u001d\t\u0011\u0005\u0005'1\u000ea\u0001\u0003\u0007DqA!\u001e\u0003l\u0001\u0007A$\u0001\td_6l\u0017\u000e\u001e;fIJ+7m\u001c:eg\u001a1!\u0011\u0010\u0001\u0005\u0005w\u0012QCQ8v]\u000e,'I]8lKJ\u001c6\r[3ek2,'o\u0005\u0003\u0003x\tu\u0004cA\b\u0003\u0000%\u0019!\u0011\u0011\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\u000b\u00033\u00139H!b\u0001\n\u0003Y\u0002B\u0003BD\u0005o\u0012\t\u0011)A\u00059\u0005Ia.^7Ji\u0016\u00148\u000f\t\u0005\b+\t]D\u0011\u0001BF)\u0011\u0011iI!%\u0011\t\t=%qO\u0007\u0002\u0001!9\u0011\u0011\u0014BE\u0001\u0004a\u0002\"\u0003BK\u0005o\u0002\r\u0011\"\u0001\u001c\u0003\u0011IG/\u001a:\t\u0015\te%q\u000fa\u0001\n\u0003\u0011Y*\u0001\u0005ji\u0016\u0014x\fJ3r)\u0011\t\tF!(\t\u0013\t}%qSA\u0001\u0002\u0004a\u0012a\u0001=%c!A!1\u0015B<A\u0003&A$A\u0003ji\u0016\u0014\b\u0005\u0003\u0005\u0003(\n]D\u0011IA(\u0003\u0019!wnV8sW\"9!1\u0016\u0001\u0005\n\t5\u0016aC:f]\u0012\u0014VmY8sIN$b!!\u0015\u00030\nE\u0006bBA_\u0005S\u0003\r\u0001\b\u0005\n/\n%\u0006\u0013!a\u0001\u0003\u0007D\u0011B!.\u0001#\u0003%IAa.\u0002+M,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0018\u0016\u0005\u0003\u0007\u0014Yl\u000b\u0002\u0003>B!!q\u0018Be\u001b\t\u0011\tM\u0003\u0003\u0003D\n\u0015\u0017!C;oG\",7m[3e\u0015\r\u00119MH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bf\u0005\u0003\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011y\rAI\u0001\n\u0013\u00119,\u0001\rsK\u000e,\u0017N^3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIMB\u0011Ba5\u0001#\u0003%IA!6\u00021I,7-Z5wKJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003X*\"!q\bB^\u0001")
public class ConsumerBounceTest
extends BaseRequestTest {
    private final int producerCount;
    private final int consumerCount;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Properties producerConfig = new Properties();
    private final Properties consumerConfig = new Properties();

    @Override
    public int numBrokers() {
        return 3;
    }

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Properties producerConfig() {
        return this.producerConfig;
    }

    public Properties consumerConfig() {
        return this.consumerConfig;
    }

    /*
     * WARNING - void declaration
     */
    public Properties serverConfig() {
        void var1_1;
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return var1_1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.producerCount()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final Buffer<KafkaProducer<byte[], byte[]>> apply(int _) {
                return this.$outer.producers().$plus$eq(this.$outer.createProducer());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.consumerCount()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int _) {
                return this.$outer.consumers().$plus$eq(this.$outer.createConsumer());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.createTopic(this.topic(), 1, this.numBrokers(), this.createTopic$default$4());
    }

    public KafkaProducer<byte[], byte[]> createProducer() {
        String x$7 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$8 = SecurityProtocol.PLAINTEXT;
        Some x$9 = new Some((Object)this.producerConfig());
        int x$10 = TestUtils$.MODULE$.createProducer$default$2();
        long x$11 = TestUtils$.MODULE$.createProducer$default$3();
        long x$12 = TestUtils$.MODULE$.createProducer$default$4();
        int x$13 = TestUtils$.MODULE$.createProducer$default$5();
        long x$14 = TestUtils$.MODULE$.createProducer$default$6();
        long x$15 = TestUtils$.MODULE$.createProducer$default$7();
        Option<File> x$16 = TestUtils$.MODULE$.createProducer$default$9();
        Option<Properties> x$17 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$18 = TestUtils$.MODULE$.createProducer$default$11();
        ByteArraySerializer x$19 = TestUtils$.MODULE$.createProducer$default$12();
        return TestUtils$.MODULE$.createProducer(x$7, x$10, x$11, x$12, x$13, x$14, x$15, x$8, x$16, x$17, x$18, x$19, (Option<Properties>)x$9);
    }

    public KafkaConsumer<byte[], byte[]> createConsumer() {
        String x$20 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$21 = SecurityProtocol.PLAINTEXT;
        Some x$22 = new Some((Object)this.consumerConfig());
        String x$23 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$24 = TestUtils$.MODULE$.createConsumer$default$3();
        long x$25 = TestUtils$.MODULE$.createConsumer$default$4();
        String x$26 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$27 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$28 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$29 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$30 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$31 = TestUtils$.MODULE$.createConsumer$default$11();
        return TestUtils$.MODULE$.createConsumer(x$20, x$23, x$24, x$25, x$26, x$27, x$21, x$28, x$29, x$30, x$31, (Option<Properties>)x$22);
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
            this.producers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                    x$2.close();
                }
            });
            this.consumers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaConsumer<byte[], byte[]> x$3) {
                    x$3.close();
                }
            });
            return;
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$4) {
                x$4.close();
            }
        });
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records2 = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records2.foreach((Function1)new Serializable(this, consumed){
                public static final long serialVersionUID = 0L;
                private final LongRef consumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> record) {
                    Assert.assertEquals((long)this.consumed$1.elem, (long)record.offset());
                    ++this.consumed$1.elem;
                }
                {
                    this.consumed$1 = consumed$1;
                }
            });
            if (!records2.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$5) {
                x$5.close();
            }
        });
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            public final int numRecords$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$seekAndCommitWithBrokerFailures$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return ((Replica)server.replicaManager().getReplica(this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().tp()).get()).highWatermark().messageOffset() == (long)this.$outer.numRecords$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for followers after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Seeking to end of log";
                    }
                });
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)new Serializable(this, pos){
                    public static final long serialVersionUID = 0L;
                    private final long pos$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Seeking to ").append((Object)BoxesRunTime.boxToLong((long)this.pos$1)).toString();
                    }
                    {
                        this.pos$1 = pos$1;
                    }
                });
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Committing offset.";
                }
            });
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.numBrokers(), this.$outer.numBrokers(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        this.sendRecords$1(numRecords, newtopic);
        this.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)consumer, numRecords, newtopic, 10000L);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, numRecords, newtopic, consumer){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int numRecords$2;
            private final String newtopic$1;
            private final KafkaConsumer consumer$1;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, this.newtopic$1, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$2 = numRecords$2;
                this.newtopic$1 = newtopic$1;
                this.consumer$1 = consumer$1;
            }
        });
        this.sendRecords$1(numRecords, newtopic);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, group).build();
        ByteBuffer resp = this.connectAndSend((AbstractRequest)request, ApiKeys.FIND_COORDINATOR, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        FindCoordinatorResponse response = FindCoordinatorResponse.parse((ByteBuffer)resp, (short)ApiKeys.FIND_COORDINATOR.latestVersion());
        return response.node().id();
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.numBrokers(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumer(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer1, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumer(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer2, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        this.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createConsumer(String groupId) {
        void var2_2;
        this.consumerConfig().setProperty("group.id", groupId);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer();
        this.consumers().$plus$eq(consumer);
        return var2_2;
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, this.receiveRecords$default$3(), this.receiveRecords$default$4());
        return consumer;
    }

    public void kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, String topic, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(1000L).count()) {
        }
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private String receiveRecords$default$3() {
        return this.topic();
    }

    private long receiveRecords$default$4() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, consumer, closeTimeoutMs, minCloseTimeMs, maxCloseTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaConsumer consumer$2;
            public final long closeTimeoutMs$1;
            private final Option minCloseTimeMs$1;
            private final Option maxCloseTimeMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int closeGraceTimeMs = 2000;
                long startNanos = System.nanoTime();
                this.$outer.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$submitCloseAndValidate$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Closing consumer with timeout ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.closeTimeoutMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$2.close(this.closeTimeoutMs$1, TimeUnit.MILLISECONDS);
                long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                this.maxCloseTimeMs$1.foreach((Function1)new Serializable(this, closeGraceTimeMs, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final int closeGraceTimeMs$1;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close took too long ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 < ms + (long)this.closeGraceTimeMs$1 ? 1 : 0) != 0);
                    }
                    {
                        this.closeGraceTimeMs$1 = closeGraceTimeMs$1;
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.minCloseTimeMs$1.foreach((Function1)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close finished too quickly ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 >= ms ? 1 : 0) != 0);
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.$outer.info((Function0<String>)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"consumer.close() completed in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$2 = consumer$2;
                this.closeTimeoutMs$1 = closeTimeoutMs$1;
                this.minCloseTimeMs$1 = minCloseTimeMs$1;
                this.maxCloseTimeMs$1 = maxCloseTimeMs$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(this, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assigment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private void sendRecords(int numRecords, String topic) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String topic$1;

            public final Future<RecordMetadata> apply(int i) {
                return ((KafkaProducer)this.$outer.producers().head()).send(new ProducerRecord(this.topic$1, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$6) {
                return x$6.get();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$2() {
        return this.topic();
    }

    private final void sendRecords$1(int numRecords, String topic) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;
                private final String topic$2;

                public final Future<RecordMetadata> apply(int i) {
                    return ((KafkaProducer)this.$outer.producers().head()).send(new ProducerRecord(this.topic$2, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$2 = topic$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1)new Serializable(this, remainingRecords){
                public static final long serialVersionUID = 0L;
                private final IntRef remainingRecords$1;

                public final void apply(Future<RecordMetadata> future) {
                    try {
                        future.get();
                        --this.remainingRecords$1.elem;
                    }
                    catch (Exception exception) {}
                }
                {
                    this.remainingRecords$1 = remainingRecords$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$3, ExecutorService executor$1) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, topic$3, consumer, revokeSemaphore){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final KafkaConsumer consumer$3;
            public final Option revokeSemaphore$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$3.subscribe(Collections.singletonList(this.topic$3), new ConsumerRebalanceListener(this){
                    private final /* synthetic */ $anonfun$subscribeAndPoll$1$1 $outer;

                    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    }

                    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                        this.$outer.revokeSemaphore$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Semaphore s) {
                                s.release();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$3.poll(0L);
            }
            {
                this.topic$3 = topic$3;
                this.consumer$3 = consumer$3;
                this.revokeSemaphore$1 = revokeSemaphore$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsumerRecords<byte[], byte[]> apply(KafkaConsumer<byte[], byte[]> consumer) {
                    return consumer.poll(100L);
                }
            });
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, String topic$3, ExecutorService executor$1) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = this.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$3, executor$1);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public ConsumerBounceTest() {
        this.producerCount = 1;
        this.consumerCount = 2;
        this.topic = "topic";
        this.part = 0;
        this.gracefulCloseTimeMs = 1000;
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", "10000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "3000");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

