/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002U1si&$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\u0002u\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u001f!\tyr%D\u0001!\u0015\t\t#%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019Q\u0003\u0001)A\u0005=\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\tQLW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0006kRLGn]\u0005\u0003gA\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u000bQLW.\u001a\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yZ$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u0001\u0005\u0001)A\u0005s\u0005\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u00069Q.\u001a;sS\u000e\u001cX#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\t\u0003\u0013B\u0001%G\u0005\u001diU\r\u001e:jGNDaA\u0013\u0001!\u0002\u0013!\u0015\u0001C7fiJL7m\u001d\u0011\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015A\u0002;na\u0012K'/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u00111\u0015\u000e\\3\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0016A\u0003;na\u0012K'o\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003\u0013iK!a\u0017\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\u0007?\u0002\u0001\u000b\u0015\u0002(\u0002\u000fQl\u0007\u000fR5sA!I\u0011\r\u0001a\u0001\u0002\u0004%\t!T\u0001\bY><G)\u001b:2\u0011%\u0019\u0007\u00011AA\u0002\u0013\u0005A-A\u0006m_\u001e$\u0015N]\u0019`I\u0015\fHCA-f\u0011\u001di&-!AA\u00029Caa\u001a\u0001!B\u0013q\u0015\u0001\u00037pO\u0012K'/\r\u0011\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003i\u0015a\u00027pO\u0012K'O\r\u0005\nW\u0002\u0001\r\u00111A\u0005\u00021\f1\u0002\\8h\t&\u0014(g\u0018\u0013fcR\u0011\u0011,\u001c\u0005\b;*\f\t\u00111\u0001O\u0011\u0019y\u0007\u0001)Q\u0005\u001d\u0006AAn\\4ESJ\u0014\u0004\u0005C\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#A:\u0011\u0005i\"\u0018BA;<\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0001=\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u00033fDq!\u0018<\u0002\u0002\u0003\u00071\u000f\u0003\u0004|\u0001\u0001\u0006Ka]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!IQ\u0010\u0001a\u0001\u0002\u0004%\tA`\u0001\u000bY><W*\u00198bO\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u0005\u0003\rawnZ\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0006M_\u001el\u0015M\\1hKJD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010\u0005qAn\\4NC:\fw-\u001a:`I\u0015\fHcA-\u0002\u0012!AQ,a\u0003\u0002\u0002\u0003\u0007q\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0015B@\u0002\u00171|w-T1oC\u001e,'\u000f\t\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0003\tY\"A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011Q\u0004\t\u0005\u0003\u0003\ty\"\u0003\u0003\u0002\"\u0005\r!!\u0003'pO\u000e{gNZ5h\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\u0002\u001b1|wmQ8oM&<w\fJ3r)\rI\u0016\u0011\u0006\u0005\n;\u0006\r\u0012\u0011!a\u0001\u0003;A\u0001\"!\f\u0001A\u0003&\u0011QD\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003bBA\u0019\u0001\u0011\u0005\u00111G\u0001\u0006g\u0016$X\u000f\u001d\u000b\u00023\"\"\u0011qFA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fK\u0005)!.\u001e8ji&!\u0011\u0011IA\u001e\u0005\u0019\u0011UMZ8sK\"9\u0011Q\t\u0001\u0005\u0002\u0005M\u0012\u0001\u0003;fCJ$un\u001e8)\t\u0005\r\u0013\u0011\n\t\u0005\u0003s\tY%\u0003\u0003\u0002N\u0005m\"!B!gi\u0016\u0014\bbBA)\u0001\u0011\u0005\u00111G\u0001 i\u0016\u001cH/T1lK2+\u0017\rZ3s+B$\u0017\r^3t\u000bB|7\r[\"bG\",\u0007\u0006BA(\u0003+\u0002B!!\u000f\u0002X%!\u0011\u0011LA\u001e\u0005\u0011!Vm\u001d;\t\u000f\u0005u\u0003\u0001\"\u0001\u00024\u0005AC/Z:u\u001b\u0006L(-\u001a*fa2\f7-Z\"veJ,g\u000e^,ji\"4U\u000f^;sKJ+\u0007\u000f\\5dC\"\"\u00111LA+\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003g\ta\u0006^3ti\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3t\u0003N4u\u000e\u001c7po\u0016\u0014()\u001a7po2{wm\u0015;beR|eMZ:fi\"\"\u0011\u0011MA+\u0011\u001d\tI\u0007\u0001C\u0001\u0003g\ta\u0002^3ti\u001e+GOU3qY&\u001c\u0017\r\u000b\u0003\u0002h\u0005U\u0003bBA8\u0001\u0011\u0005\u00111G\u00018i\u0016\u001cH/\u00119qK:$'+Z2pe\u0012\u001cHk\u001c$pY2|w/\u001a:XSRDgj\u001c*fa2L7-\u0019+ie><8/\u0012=dKB$\u0018n\u001c8)\t\u00055\u0014Q\u000b\u0005\b\u0003k\u0002A\u0011AA\u001a\u0003\u0011\"Xm\u001d;NC.,gi\u001c7m_^,'oV5uQ:{G*Z1eKJLEm\u00115b]\u001e,\u0007\u0006BA:\u0003+Bq!a\u001f\u0001\t\u0003\t\u0019$A$uKN$hi\u001c7m_^,'\u000fR8fg:{GOS8j]&\u001b&+\u00168uS2\u001c\u0015-^4iiV\u0003Hk\\(gMN,GoV5uQ&t7)\u001e:sK:$H*Z1eKJ,\u0005o\\2iQ\u0011\tI(!\u0016\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\u0006i1M]3bi\u0016\u0014VmY8sIN$\u0002\"!\"\u0002\u0012\u0006M\u0016Q\u0018\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111\u0012\u0011\u0002\rI,7m\u001c:e\u0013\u0011\ty)!#\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\t\u0019*a A\u0002\u0005U\u0015a\u0002:fG>\u0014Hm\u001d\t\u0007\u0003/\u000b9+!,\u000f\t\u0005e\u00151\u0015\b\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011bAAS\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002BAU\u0003W\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003KS\u0001\u0003BAD\u0003_KA!!-\u0002\n\na1+[7qY\u0016\u0014VmY8sI\"A\u0011QWA@\u0001\u0004\t9,\u0001\u0006cCN,wJ\u001a4tKR\u00042!CA]\u0013\r\tYL\u0003\u0002\u0005\u0019>tw\rC\u0005\u0002@\u0006}\u0004\u0013!a\u0001-\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"D\u0011\"a1\u0001#\u0003%\t!!2\u0002/\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTCAAdU\r1\u0012\u0011Z\u0016\u0003\u0003\u0017\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001b\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0006='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$6 = false;
        int x$7 = CleanerConfig$.MODULE$.apply$default$1();
        long x$8 = CleanerConfig$.MODULE$.apply$default$2();
        double x$9 = CleanerConfig$.MODULE$.apply$default$3();
        int x$10 = CleanerConfig$.MODULE$.apply$default$4();
        int x$11 = CleanerConfig$.MODULE$.apply$default$5();
        double x$12 = CleanerConfig$.MODULE$.apply$default$6();
        long x$13 = CleanerConfig$.MODULE$.apply$default$7();
        String x$14 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$6, x$14), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put(KafkaConfig$.MODULE$.LogDirsProp(), ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getAbsolutePath();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        EasyMock.expect((Object)kafkaZkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)logProps).anyTimes();
        EasyMock.expect((Object)kafkaZkClient.conditionalUpdatePath((String)EasyMock.anyObject(), (byte[])EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), (Option)EasyMock.anyObject())).andReturn((Object)new Tuple2.mcZI.sp(true, 0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
        this.replicaManager().shutdown(false);
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int controllerEpoch = 3;
        int leader2 = this.brokerId();
        int follower2 = this.brokerId() + 1;
        int controllerId = this.brokerId() + 3;
        List replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        List isr = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$15 = this.topicPartition();
        LogConfig x$16 = this.logConfig();
        boolean x$17 = qual$1.getOrCreateLog$default$3();
        boolean x$18 = qual$1.getOrCreateLog$default$4();
        Log log2 = qual$1.getOrCreateLog(x$15, x$16, x$17, x$18);
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log2.appendAsLeader$default$3());
        Assert.assertEquals((long)4L, (long)log2.logEndOffset());
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assert.assertTrue((String)"Expected makeLeader to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Replica x$2) {
                return x$2.logEndOffset().messageOffset();
            }
        }));
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(leaderEpoch);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$2 = this.logManager();
        TopicPartition x$19 = this.topicPartition();
        LogConfig x$20 = this.logConfig();
        boolean x$21 = qual$2.getOrCreateLog$default$3();
        boolean x$22 = qual$2.getOrCreateLog$default$4();
        Log log1 = qual$2.getOrCreateLog(x$19, x$20, x$21, x$22);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$3 = this.logManager();
        TopicPartition x$23 = this.topicPartition();
        LogConfig x$24 = this.logConfig();
        boolean x$25 = true;
        boolean x$26 = qual$3.getOrCreateLog$default$3();
        Log log2 = qual$3.getOrCreateLog(x$23, x$24, x$26, x$25);
        int x$27 = this.brokerId();
        TopicPartition x$28 = this.topicPartition();
        MockTime x$29 = this.time();
        Some x$30 = new Some((Object)log1);
        long x$31 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$27, x$28, (Time)x$29, x$31, (Option)x$30);
        int x$32 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$33 = this.topicPartition();
        MockTime x$34 = this.time();
        Some x$35 = new Some((Object)log2);
        long x$36 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$32, x$33, (Time)x$34, x$36, (Option)x$35);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.getReplica(this.brokerId()));
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.getReplica(Request$.MODULE$.FutureLocalReplicaId()));
        Thread thread1 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.removeFutureLocalReplica(this.partition$1.removeFutureLocalReplica$default$1());
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        Thread thread2 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.maybeReplaceCurrentWithFutureReplica();
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.getReplica(Request$.MODULE$.FutureLocalReplicaId()));
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$4 = this.logManager();
        TopicPartition x$37 = this.topicPartition();
        LogConfig x$38 = this.logConfig();
        boolean x$39 = qual$4.getOrCreateLog$default$3();
        boolean x$40 = qual$4.getOrCreateLog$default$4();
        Log log2 = qual$4.getOrCreateLog(x$37, x$38, x$39, x$40);
        int x$41 = this.brokerId();
        TopicPartition x$42 = this.topicPartition();
        MockTime x$43 = this.time();
        Some x$44 = new Some((Object)log2);
        long x$45 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$41, x$42, (Time)x$43, x$45, (Option)x$44);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.getReplica(replica.brokerId()));
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.partition$2.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 3L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)7L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 7:"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MemoryRecords records2 = this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), 3L, this.$outer.createRecords$default$3());
                this.partition$2.appendRecordsToFollowerOrFutureReplica(records2, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 8:"})).s((Seq)Nil$.MODULE$), (long)9L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testGetReplica() {
        LogManager qual$5 = this.logManager();
        TopicPartition x$46 = this.topicPartition();
        LogConfig x$47 = this.logConfig();
        boolean x$48 = qual$5.getOrCreateLog$default$3();
        boolean x$49 = qual$5.getOrCreateLog$default$4();
        Log log2 = qual$5.getOrCreateLog(x$46, x$47, x$48, x$49);
        int x$50 = this.brokerId();
        TopicPartition x$51 = this.topicPartition();
        MockTime x$52 = this.time();
        Some x$53 = new Some((Object)log2);
        long x$54 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$50, x$51, (Time)x$52, x$54, (Option)x$53);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.getReplica(this.brokerId()));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$3;

            public final Replica apply() {
                return this.partition$3.getReplicaOrException(this.$outer.brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$3 = partition$3;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)replica, (Object)partition.getReplicaOrException(this.brokerId()));
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.partition$4.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 0L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$4 = partition$4;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        LeaderAndIsrRequest.PartitionState partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        partition.makeFollower(0, partitionStateInfo, 0);
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 3, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        Assert.assertTrue((boolean)partition.makeFollower(0, partitionStateInfo, 1));
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        Assert.assertFalse((boolean)partition.makeFollower(0, partitionStateInfo, 2));
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        Assert.assertFalse((boolean)partition.makeFollower(0, partitionStateInfo, 2));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader2 = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        List replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        List isr = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord("k4".getBytes(), "v2".getBytes()), new SimpleRecord("k5".getBytes(), "v3".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k6".getBytes(), "v1".getBytes()), new SimpleRecord("k7".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$3) {
                return x$3.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition.getReplica(leader2).get();
        Replica follower1Replica = (Replica)partition.getReplica(follower1).get();
        Replica follower2Replica = (Replica)partition.getReplica(follower2).get();
        long lastOffsetOfFirstBatch = partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3()).lastOffset();
        partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)leaderReplica.highWatermark().messageOffset());
        partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)partition.makeLeader(controllerEpoch, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch + 2, isr, 1, replicas, false), 2));
        long currentLeaderEpochStartOffset = leaderReplica.logEndOffset().messageOffset();
        partition.appendRecordsToLeader(batch3, true, partition.appendRecordsToLeader$default$3());
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$4) {
                return x$4.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch3, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$5) {
                return x$5.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    private final LogReadResult readResult$1(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset().messageOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    public PartitionTest() {
        this.brokerId = 101;
    }
}

