/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u000f\t\tB)\u001f8b[&\u001c7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u00135Q#A\to_:,\u00050[:uK:$8i\u001c8gS\u001e,\u0012A\u0006\t\u0003/uq!\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0010 \u0005\u0019\u0019FO]5oO*\u0011A$\u0007\u0005\u0007C\u0001\u0001\u000bQ\u0002\f\u0002%9|g.\u0012=jgR,g\u000e^\"p]\u001aLw\r\t\u0005\bG\u0001\u0011\r\u0011\"\u0004\u0016\u0003%\u0019x.\\3WC2,X\r\u0003\u0004&\u0001\u0001\u0006iAF\u0001\u000bg>lWMV1mk\u0016\u0004\u0003\"B\u0014\u0001\t\u0003A\u0013aK:i_VdGMR1jY^CWM\\\"iC:<\u0017N\\4DY&,g\u000e^%e+:\\gn\\<o\u0007>tg-[4\u0015\u0003%\u0002\"\u0001\u0007\u0016\n\u0005-J\"\u0001B+oSRDCAJ\u00176mA\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002e\u0005\u0019qN]4\n\u0005Qz#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002oA\u0011\u0001\b\u0011\b\u0003syr!AO\u001f\u000e\u0003mR!\u0001\u0010\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA \u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0011\"\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u0002@3!)A\t\u0001C\u0001Q\u000593\u000f[8vY\u00124\u0015-\u001b7XQ\u0016t7\t[1oO&tw-V:feVs7N\\8x]\u000e{gNZ5hQ\u0011\u0019U&\u000e\u001c\t\u000b\u001d\u0003A\u0011\u0001\u0015\u0002QMDw.\u001e7e\r\u0006LG\u000eT3bI\u0016\u00148i\u001c8gS\u001e\u001cx+\u001b;i\u0013:4\u0018\r\\5e-\u0006dW/Z:)\t\u0019kS'S\u0012\u0002\u0015B\u00111jU\u0007\u0002\u0019*\u0011QJT\u0001\u0007G>tg-[4\u000b\u0005=\u0003\u0016AB2p[6|gN\u0003\u0002\u0006#*\u0011!+M\u0001\u0007CB\f7\r[3\n\u0005Qc%aD\"p]\u001aLw-\u0012=dKB$\u0018n\u001c8\t\u000bY\u0003A\u0011\u0001\u0015\u0002UMDw.\u001e7e\r\u0006LGNR8mY><XM]\"p]\u001aLwm],ji\"LeN^1mS\u00124\u0016\r\\;fg\"\"Q+L\u001bJ\u0001")
public class DynamicConfigTest
extends ZooKeeperTestHarness {
    private final String nonExistentConfig;
    private final String someValue;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        this.adminZkClient().changeClientIdConfig("ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingUserUnknownConfig() {
        this.adminZkClient().changeUserOrUserClientIdConfig("UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailLeaderConfigsWithInvalidValues() {
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100"));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailFollowerConfigsWithInvalidValues() {
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100"));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

