/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$;
import kafka.controller.PartitionStateMachine$$anonfun$leaderForOffline$1$;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\re\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!\u0011!Q\u0001\nY\taaY8oM&<\u0007CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0019\u0019XM\u001d<fe&\u00111\u0004\u0007\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011q$J\u0005\u0003M\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!A\u0003A!A!\u0002\u0013I\u0013\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005)jS\"A\u0016\u000b\u00051\"\u0011A\u0001>l\u0013\tq3FA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005q\u0001/\u0019:uSRLwN\\*uCR,\u0007\u0003\u0002\u001a8s\u0011k\u0011a\r\u0006\u0003iU\nq!\\;uC\ndWM\u0003\u00027\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001a$aA'baB\u0011!HQ\u0007\u0002w)\u0011A(P\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q$BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001eL!aQ\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011q$R\u0005\u0003\r\n\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\r\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0003q\u0019wN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\"a\b&\n\u0005-\u0013!\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0005\u0006\u001b\u0002!\tAT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f=\u0003\u0016KU*U+B\u0011q\u0004\u0001\u0005\u0006+1\u0003\rA\u0006\u0005\u0006;1\u0003\rA\b\u0005\u0006G1\u0003\r\u0001\n\u0005\u0006Q1\u0003\r!\u000b\u0005\u0006a1\u0003\r!\r\u0005\u0006\u00112\u0003\r!\u0013\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u00031\u0019wN\u001c;s_2dWM]%e+\u0005I\u0006CA\u0005[\u0013\tY&BA\u0002J]RDa!\u0018\u0001!\u0002\u0013I\u0016!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\u0006!Bo\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ,\u0012!\u0019\t\u0003?\tL!a\u0019\u0002\u0003)Q{\u0007/[2EK2,G/[8o\u001b\u0006t\u0017mZ3s\u0011%)\u0007\u00011AA\u0002\u0013%a-\u0001\ru_BL7\rR3mKRLwN\\'b]\u0006<WM]0%KF$\"a\u001a6\u0011\u0005%A\u0017BA5\u000b\u0005\u0011)f.\u001b;\t\u000f-$\u0017\u0011!a\u0001C\u0006\u0019\u0001\u0010J\u0019\t\r5\u0004\u0001\u0015)\u0003b\u0003U!x\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4fe\u0002Bqa\u001c\u0001A\u0002\u0013\u0005\u0001,A\u000bpM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\t\u000fE\u0004\u0001\u0019!C\u0001e\u0006IrN\u001a4mS:,\u0007+\u0019:uSRLwN\\\"pk:$x\fJ3r)\t97\u000fC\u0004la\u0006\u0005\t\u0019A-\t\rU\u0004\u0001\u0015)\u0003Z\u0003YygM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004\u0003\"B<\u0001\t\u0003A\u0018aB:uCJ$X\u000f\u001d\u000b\u0002O\")!\u0010\u0001C\u0001q\u0006A1\u000f[;uI><h\u000eC\u0003}\u0001\u0011\u0005Q0A\ftKR$v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4feR\u0011qM \u0005\u0006?n\u0004\r!\u0019\u0005\u0007\u0003\u0003\u0001A\u0011\u0002=\u00021%t\u0017\u000e^5bY&TX\rU1si&$\u0018n\u001c8Ti\u0006$X\r\u0003\u0004\u0002\u0006\u0001!\t\u0001_\u0001\"iJLwmZ3s\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]N#\u0018\r^3DQ\u0006tw-\u001a\u0005\b\u0003\u000b\u0001A\u0011AA\u0005)\r9\u00171\u0002\u0005\t\u0003\u001b\t9\u00011\u0001\u0002\u0010\u0005)Ao\u001c9jGB!\u0011\u0011CA\f\u001d\rI\u00111C\u0005\u0004\u0003+Q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!AB*ue&twMC\u0002\u0002\u0016)Aq!!\u0002\u0001\t\u0003\ty\u0002F\u0002h\u0003CAq\u0001MA\u000f\u0001\u0004\t\u0019\u0003\u0005\u0004\u0002\u0012\u0005\u0015\u0012\bR\u0005\u0004q\u0005m\u0001bBA\u0015\u0001\u0011\u0005\u00111F\u0001\u0013Q\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000fF\u0004h\u0003[\tI%!\u0014\t\u0011\u0005=\u0012q\u0005a\u0001\u0003c\t!\u0002]1si&$\u0018n\u001c8t!\u0015\t\u0019$a\u0011:\u001d\u0011\t)$a\u0010\u000f\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f\u0007\u0003\u0019a$o\\8u}%\t1\"C\u0002\u0002B)\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#aA*fc*\u0019\u0011\u0011\t\u0006\t\u000f\u0005-\u0013q\u0005a\u0001\t\u0006YA/\u0019:hKR\u001cF/\u0019;f\u0011)\ty%a\n\u0011\u0002\u0003\u0007\u0011\u0011K\u0001#a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:\u001cFO]1uK\u001eLx\n\u001d;\u0011\u000b%\t\u0019&a\u0016\n\u0007\u0005U#B\u0001\u0004PaRLwN\u001c\t\u0004?\u0005e\u0013bAA.\u0005\ty\u0002+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\*ue\u0006$XmZ=\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005\t\u0002/\u0019:uSRLwN\\:J]N#\u0018\r^3\u0015\t\u0005\r\u0014\u0011\u000e\t\u0006\u0003#\t)'O\u0005\u0005\u0003O\nYBA\u0002TKRDq!a\u001b\u0002^\u0001\u0007A)A\u0003ti\u0006$X\rC\u0004\u0002p\u0001!I!!\u001d\u0002\u001b\rD\u0017M\\4f'R\fG/\u001a+p)\u001d9\u00171OA<\u0003wBq!!\u001e\u0002n\u0001\u0007\u0011(A\u0005qCJ$\u0018\u000e^5p]\"9\u0011\u0011PA7\u0001\u0004!\u0015\u0001D2veJ,g\u000e^*uCR,\u0007bBA&\u0003[\u0002\r\u0001\u0012\u0005\b\u0003\u007f\u0002A\u0011BAA\u0003])\b\u000fZ1uK\u000e{g\u000e\u001e:pY2,'/T3ue&\u001c7\u000fF\u0004h\u0003\u0007\u000b))a\"\t\u000f\u0005U\u0014Q\u0010a\u0001s!9\u0011\u0011PA?\u0001\u0004!\u0005bBA&\u0003{\u0002\r\u0001\u0012\u0005\b\u0003\u0017\u0003A\u0011BAG\u0003Q!w\u000eS1oI2,7\u000b^1uK\u000eC\u0017M\\4fgR9q-a$\u0002\u0012\u0006M\u0005\u0002CA\u0018\u0003\u0013\u0003\r!!\r\t\u000f\u0005-\u0013\u0011\u0012a\u0001\t\"A\u0011qJAE\u0001\u0004\t\t\u0006C\u0004\u0002\u0018\u0002!I!!'\u0002G%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014\u0018I\u001c3JgJ4uN\u001d)beRLG/[8ogR!\u0011\u0011GAN\u0011!\ty#!&A\u0002\u0005E\u0002bBAP\u0001\u0011%\u0011\u0011U\u0001\u0019K2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:\u001cHCBA\u0019\u0003G\u000b)\u000b\u0003\u0005\u00020\u0005u\u0005\u0019AA\u0019\u0011!\t9+!(A\u0002\u0005]\u0013a\b9beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o'R\u0014\u0018\r^3hs\"9\u00111\u0016\u0001\u0005\n\u00055\u0016A\u00073p\u000b2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:\u001cHCBAX\u0003{\u000by\fE\u0005\n\u0003c\u000b\t$!\r\u00026&\u0019\u00111\u0017\u0006\u0003\rQ+\b\u000f\\34!\u001d\t\t\"!\n:\u0003o\u0003B!a\r\u0002:&!\u00111XA$\u0005%)\u0005pY3qi&|g\u000e\u0003\u0005\u00020\u0005%\u0006\u0019AA\u0019\u0011!\t9+!+A\u0002\u0005]\u0003bBAb\u0001\u0011%\u0011QY\u0001\u0011Y\u0016\fG-\u001a:G_J|eM\u001a7j]\u0016$B!a2\u0002\\B1\u00111GA\"\u0003\u0013\u0004\u0002\"CAYs\u0005-\u0017\u0011\u001c\t\u0006\u0013\u0005M\u0013Q\u001a\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*\u0019\u00111\u001b\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002X\u0006E'\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\b#BA\u001a\u0003\u0007J\u0006\u0002CAo\u0003\u0003\u0004\r!a8\u000291,\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2igB1\u00111GA\"\u0003C\u0004b!CArs\u0005\u001d\u0018bAAs\u0015\t1A+\u001e9mKJ\u00022aHAu\u0013\r\tYO\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f\u0005=\b\u0001\"\u0003\u0002r\u0006\tB.Z1eKJ4uN\u001d*fCN\u001c\u0018n\u001a8\u0015\t\u0005\u001d\u00171\u001f\u0005\t\u0003;\fi\u000f1\u0001\u0002`\"9\u0011q\u001f\u0001\u0005\n\u0005e\u0018!\u00077fC\u0012,'OR8s!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006$B!a2\u0002|\"A\u0011Q\\A{\u0001\u0004\ty\u000eC\u0004\u0002\u0000\u0002!IA!\u0001\u000271,\u0017\rZ3s\r>\u00148i\u001c8ue>dG.\u001a3TQV$Hm\\<o)\u0019\t9Ma\u0001\u0003\u0006!A\u0011Q\\A\u007f\u0001\u0004\ty\u000e\u0003\u0005\u0003\b\u0005u\b\u0019\u0001B\u0005\u0003M\u0019\b.\u001e;uS:<Gi\\<o\u0005J|7.\u001a:t!\u0015\t\t\"!\u001aZ\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f\t\u0011#[:WC2LG\r\u0016:b]NLG/[8o)\u0019\u0011\tBa\u0006\u0003\u001aA\u0019\u0011Ba\u0005\n\u0007\tU!BA\u0004C_>dW-\u00198\t\u000f\u0005U$1\u0002a\u0001s!9\u00111\nB\u0006\u0001\u0004!\u0005b\u0002B\u000f\u0001\u0011%!qD\u0001\u0015Y><\u0017J\u001c<bY&$GK]1og&$\u0018n\u001c8\u0015\u000b\u001d\u0014\tCa\t\t\u000f\u0005U$1\u0004a\u0001s!9\u00111\nB\u000e\u0001\u0004!\u0005b\u0002B\u0014\u0001\u0011%!\u0011F\u0001\u0015Y><g)Y5mK\u0012\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\u0013\u001d\u0014YC!\f\u00032\tM\u0002bBA;\u0005K\u0001\r!\u000f\u0005\b\u0005_\u0011)\u00031\u0001E\u0003%\u0019WO\u001d:Ti\u0006$X\rC\u0004\u0002L\t\u0015\u0002\u0019\u0001#\t\u0011\tU\"Q\u0005a\u0001\u0005o\tAaY8eKB!!\u0011\bB(\u001d\u0011\u0011YD!\u0013\u000f\t\tu\"Q\t\b\u0005\u0005\u007f\u0011\u0019E\u0004\u0003\u00028\t\u0005\u0013\"A!\n\u0005}\u0002\u0015b\u0001B$}\u0005I!p\\8lK\u0016\u0004XM]\u0005\u0005\u0005\u0017\u0012i%A\bLK\u0016\u0004XM]#yG\u0016\u0004H/[8o\u0015\r\u00119EP\u0005\u0005\u0005#\u0012\u0019F\u0001\u0003D_\u0012,'\u0002\u0002B&\u0005\u001bBqAa\n\u0001\t\u0013\u00119\u0006F\u0005h\u00053\u0012YF!\u0018\u0003`!9\u0011Q\u000fB+\u0001\u0004I\u0004b\u0002B\u0018\u0005+\u0002\r\u0001\u0012\u0005\b\u0003\u0017\u0012)\u00061\u0001E\u0011!\u0011\tG!\u0016A\u0002\t\r\u0014!\u0001;\u0011\t\u0005M\"QM\u0005\u0005\u0005O\n9EA\u0005UQJ|w/\u00192mK\"I!1\u000e\u0001\u0012\u0002\u0013\u0005!QN\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yG\u000b\u0003\u0002R\tE4F\u0001B:!\u0011\u0011)Ha \u000e\u0005\t]$\u0002\u0002B=\u0005w\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tu$\"\u0001\u0006b]:|G/\u0019;j_:LAA!!\u0003x\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class PartitionStateMachine
implements Logging {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    public final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final KafkaZkClient zkClient;
    public final Map<TopicPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState;
    public final ControllerBrokerRequestBatch kafka$controller$PartitionStateMachine$$controllerBrokerRequestBatch;
    private final int kafka$controller$PartitionStateMachine$$controllerId;
    private TopicDeletionManager kafka$controller$PartitionStateMachine$$topicDeletionManager;
    private int offlinePartitionCount;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int kafka$controller$PartitionStateMachine$$controllerId() {
        return this.kafka$controller$PartitionStateMachine$$controllerId;
    }

    public TopicDeletionManager kafka$controller$PartitionStateMachine$$topicDeletionManager() {
        return this.kafka$controller$PartitionStateMachine$$topicDeletionManager;
    }

    private void kafka$controller$PartitionStateMachine$$topicDeletionManager_$eq(TopicDeletionManager x$1) {
        this.kafka$controller$PartitionStateMachine$$topicDeletionManager = x$1;
    }

    public int offlinePartitionCount() {
        return this.offlinePartitionCount;
    }

    public void offlinePartitionCount_$eq(int x$1) {
        this.offlinePartitionCount = x$1;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Initializing partition state";
            }
        });
        this.initializePartitionState();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Triggering online partition state changes";
            }
        });
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started partition state machine with initial state -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$partitionState}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$partitionState.clear();
        this.offlinePartitionCount_$eq(0);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped partition state machine";
            }
        });
    }

    public void setTopicDeletionManager(TopicDeletionManager topicDeletionManager) {
        this.kafka$controller$PartitionStateMachine$$topicDeletionManager_$eq(topicDeletionManager);
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext.allPartitions().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final void apply(TopicPartition topicPartition) {
                Option option;
                block7: {
                    block6: {
                        block5: {
                            BoxedUnit boxedUnit;
                            option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionLeadershipInfo().get((Object)topicPartition);
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            if (this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), topicPartition, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline$default$3())) {
                                this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(topicPartition, NonExistentPartition$.MODULE$, OnlinePartition$.MODULE$);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(topicPartition, NonExistentPartition$.MODULE$, OfflinePartition$.MODULE$);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            break block6;
                        }
                        if (!None$.MODULE$.equals(option)) break block7;
                        this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(topicPartition, NonExistentPartition$.MODULE$, NewPartition$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void triggerOnlinePartitionStateChange() {
        this.triggerOnlinePartitionStateChange((scala.collection.immutable.Map<TopicPartition, PartitionState>)this.kafka$controller$PartitionStateMachine$$partitionState.toMap(Predef$.MODULE$.$conforms()));
    }

    public void triggerOnlinePartitionStateChange(String topic) {
        this.triggerOnlinePartitionStateChange((scala.collection.immutable.Map<TopicPartition, PartitionState>)this.kafka$controller$PartitionStateMachine$$partitionState.filterKeys((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final boolean apply(TopicPartition p) {
                return p.topic().equals(this.topic$1);
            }
            {
                this.topic$1 = topic$1;
            }
        }).toMap(Predef$.MODULE$.$conforms()));
    }

    public void triggerOnlinePartitionStateChange(scala.collection.immutable.Map<TopicPartition, PartitionState> partitionState) {
        Seq partitionsToTrigger = ((MapLike)partitionState.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final boolean apply(Tuple2<TopicPartition, PartitionState> x0$1) {
                Tuple2<TopicPartition, PartitionState> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    PartitionState partitionState = (PartitionState)tuple2._2();
                    boolean bl = !this.$outer.kafka$controller$PartitionStateMachine$$topicDeletionManager().isTopicQueuedUpForDeletion(partition.topic()) && (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).keys().toSeq();
        this.handleStateChanges((Seq<TopicPartition>)partitionsToTrigger, OnlinePartition$.MODULE$, (Option<PartitionLeaderElectionStrategy>)Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        if (!partitions.nonEmpty()) return;
        try {
            this.kafka$controller$PartitionStateMachine$$controllerBrokerRequestBatch.newBatch();
            this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
            this.kafka$controller$PartitionStateMachine$$controllerBrokerRequestBatch.sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controllerContext.epoch());
            return;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while moving some partitions to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
            return;
        }
        catch (ControllerMovedException controllerMovedException) {
            this.error((Function0<String>)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller moved to another broker when moving some partitions to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }, (Function0<Throwable>)new Serializable(this, controllerMovedException){
                public static final long serialVersionUID = 0L;
                private final ControllerMovedException e$1;

                public final ControllerMovedException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw controllerMovedException;
        }
    }

    public Option<PartitionLeaderElectionStrategy> handleStateChanges$default$3() {
        return None$.MODULE$;
    }

    public Set<TopicPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.kafka$controller$PartitionStateMachine$$partitionState.filter((Function1)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final PartitionState state$1;

            public final boolean apply(Tuple2<TopicPartition, PartitionState> x0$2) {
                Tuple2<TopicPartition, PartitionState> tuple2 = x0$2;
                if (tuple2 != null) {
                    PartitionState s;
                    PartitionState partitionState = s = (PartitionState)tuple2._2();
                    PartitionState partitionState2 = this.state$1;
                    boolean bl = !(partitionState != null ? !partitionState.equals(partitionState2) : partitionState2 != null);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.state$1 = state$1;
            }
        })).keySet().toSet();
    }

    public void kafka$controller$PartitionStateMachine$$changeStateTo(TopicPartition partition, PartitionState currentState, PartitionState targetState) {
        this.kafka$controller$PartitionStateMachine$$partitionState.put((Object)partition, (Object)targetState);
        this.updateControllerMetrics(partition, currentState, targetState);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateControllerMetrics(TopicPartition partition, PartitionState currentState, PartitionState targetState) {
        if (this.kafka$controller$PartitionStateMachine$$topicDeletionManager().isTopicWithDeletionStarted(partition.topic())) return;
        PartitionState partitionState = currentState;
        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
        if (partitionState == null ? offlinePartition$ != null : !partitionState.equals(offlinePartition$)) {
            PartitionState partitionState2 = targetState;
            OfflinePartition$ offlinePartition$2 = OfflinePartition$.MODULE$;
            if (!(partitionState2 != null ? !partitionState2.equals(offlinePartition$2) : offlinePartition$2 != null)) {
                this.offlinePartitionCount_$eq(this.offlinePartitionCount() + 1);
                return;
            }
        }
        PartitionState partitionState3 = currentState;
        OfflinePartition$ offlinePartition$3 = OfflinePartition$.MODULE$;
        if (partitionState3 == null) {
            if (offlinePartition$3 != null) {
                return;
            }
        } else if (!partitionState3.equals(offlinePartition$3)) return;
        PartitionState partitionState4 = targetState;
        OfflinePartition$ offlinePartition$4 = OfflinePartition$.MODULE$;
        if (partitionState4 == null) {
            if (offlinePartition$4 == null) return;
        } else if (partitionState4.equals(offlinePartition$4)) return;
        this.offlinePartitionCount_$eq(this.offlinePartitionCount() - 1);
    }

    private void doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        Tuple2 tuple2;
        block6: {
            PartitionState partitionState;
            block11: {
                block8: {
                    Seq validPartitions;
                    StateChangeLogger stateChangeLog;
                    block10: {
                        block9: {
                            BoxedUnit boxedUnit;
                            block7: {
                                Tuple2 tuple22;
                                stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.kafka$controller$PartitionStateMachine$$controllerContext.epoch());
                                partitions.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;

                                    public final PartitionState apply(TopicPartition partition) {
                                        return (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.getOrElseUpdate((Object)partition, (Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final NonExistentPartition$ apply() {
                                                return NonExistentPartition$.MODULE$;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                tuple2 = partitions.partition((Function1)new Serializable(this, targetState){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;
                                    private final PartitionState targetState$2;

                                    public final boolean apply(TopicPartition partition) {
                                        return this.$outer.kafka$controller$PartitionStateMachine$$isValidTransition(partition, this.targetState$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                    }
                                });
                                if (tuple2 == null) break block6;
                                Seq validPartitions2 = (Seq)tuple2._1();
                                Seq invalidPartitions = (Seq)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)validPartitions2, (Object)invalidPartitions);
                                validPartitions = (Seq)tuple23._1();
                                Seq invalidPartitions2 = (Seq)tuple23._2();
                                invalidPartitions2.foreach((Function1)new Serializable(this, targetState){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;
                                    private final PartitionState targetState$2;

                                    public final void apply(TopicPartition partition) {
                                        this.$outer.kafka$controller$PartitionStateMachine$$logInvalidTransition(partition, this.targetState$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                    }
                                });
                                partitionState = targetState;
                                if (!NewPartition$.MODULE$.equals(partitionState)) break block7;
                                validPartitions.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;
                                    public final PartitionState targetState$2;
                                    private final StateChangeLogger stateChangeLog$1;

                                    public final void apply(TopicPartition partition) {
                                        this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$doHandleStateChanges$3 $outer;
                                            private final TopicPartition partition$8;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", " with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$8, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$partitionState.apply((Object)this.partition$8), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.partitionReplicaAssignment(this.partition$8).mkString(",")}))).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.partition$8 = partition$8;
                                            }
                                        });
                                        this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), NewPartition$.MODULE$);
                                    }

                                    public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                        this.stateChangeLog$1 = stateChangeLog$1;
                                    }
                                });
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                break block8;
                            }
                            if (!OnlinePartition$.MODULE$.equals(partitionState)) break block9;
                            Seq uninitializedPartitions = (Seq)validPartitions.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ PartitionStateMachine $outer;

                                public final boolean apply(TopicPartition partition) {
                                    Object object = this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition);
                                    NewPartition$ newPartition$ = NewPartition$.MODULE$;
                                    return !(object != null ? !object.equals(newPartition$) : newPartition$ != null);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Seq partitionsToElectLeader = (Seq)validPartitions.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ PartitionStateMachine $outer;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean apply(TopicPartition partition) {
                                    Object object = this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition);
                                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                                    if (object == null) {
                                        if (offlinePartition$ == null) return true;
                                    } else if (object.equals(offlinePartition$)) return true;
                                    Object object2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition);
                                    OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                                    if (object2 != null) {
                                        if (!object2.equals(onlinePartition$)) return false;
                                        return true;
                                    }
                                    if (onlinePartition$ == null) return true;
                                    return false;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            if (uninitializedPartitions.nonEmpty()) {
                                Seq<TopicPartition> successfulInitializations = this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions);
                                successfulInitializations.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;
                                    public final PartitionState targetState$2;
                                    private final StateChangeLogger stateChangeLog$1;

                                    public final void apply(TopicPartition partition) {
                                        this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$doHandleStateChanges$4 $outer;
                                            private final TopicPartition partition$9;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$9, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$partitionState.apply((Object)this.partition$9), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LeaderIsrAndControllerEpoch)this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.partitionLeadershipInfo().apply((Object)this.partition$9)).leaderAndIsr()}))).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.partition$9 = partition$9;
                                            }
                                        });
                                        this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), OnlinePartition$.MODULE$);
                                    }

                                    public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                        this.stateChangeLog$1 = stateChangeLog$1;
                                    }
                                });
                            }
                            if (partitionsToElectLeader.nonEmpty()) {
                                Seq<TopicPartition> successfulElections = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.get());
                                successfulElections.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;
                                    public final PartitionState targetState$2;
                                    private final StateChangeLogger stateChangeLog$1;

                                    public final void apply(TopicPartition partition) {
                                        this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$doHandleStateChanges$5 $outer;
                                            private final TopicPartition partition$10;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$10, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$partitionState.apply((Object)this.partition$10), this.$outer.targetState$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LeaderIsrAndControllerEpoch)this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.partitionLeadershipInfo().apply((Object)this.partition$10)).leaderAndIsr()}))).toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.partition$10 = partition$10;
                                            }
                                        });
                                        this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), OnlinePartition$.MODULE$);
                                    }

                                    public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.targetState$2 = targetState$2;
                                        this.stateChangeLog$1 = stateChangeLog$1;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit3 = boxedUnit;
                            break block8;
                        }
                        if (!OfflinePartition$.MODULE$.equals(partitionState)) break block10;
                        validPartitions.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PartitionStateMachine $outer;
                            public final PartitionState targetState$2;
                            private final StateChangeLogger stateChangeLog$1;

                            public final void apply(TopicPartition partition) {
                                this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$doHandleStateChanges$6 $outer;
                                    private final TopicPartition partition$11;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$11, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$partitionState.apply((Object)this.partition$11), this.$outer.targetState$2}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.partition$11 = partition$11;
                                    }
                                });
                                this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), OfflinePartition$.MODULE$);
                            }

                            public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.targetState$2 = targetState$2;
                                this.stateChangeLog$1 = stateChangeLog$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (!NonExistentPartition$.MODULE$.equals(partitionState)) break block11;
                    validPartitions.foreach((Function1)new Serializable(this, targetState, stateChangeLog){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PartitionStateMachine $outer;
                        public final PartitionState targetState$2;
                        private final StateChangeLogger stateChangeLog$1;

                        public final void apply(TopicPartition partition) {
                            this.stateChangeLog$1.trace((Function0<String>)new Serializable(this, partition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$doHandleStateChanges$7 $outer;
                                private final TopicPartition partition$12;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$12, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$partitionState.apply((Object)this.partition$12), this.$outer.targetState$2}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.partition$12 = partition$12;
                                }
                            });
                            this.$outer.kafka$controller$PartitionStateMachine$$changeStateTo(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), NonExistentPartition$.MODULE$);
                        }

                        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.targetState$2 = targetState$2;
                            this.stateChangeLog$1 = stateChangeLog$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)partitionState);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var2_2;
        Seq seq;
        Tuple2 tuple22;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Seq replicasPerPartition = (Seq)partitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Tuple2<TopicPartition, Seq<Object>> apply(TopicPartition partition) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq liveReplicasPerPartition = (Seq)replicasPerPartition.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Tuple2<TopicPartition, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$3) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Seq liveReplicasForPartition = (Seq)replicas.filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$15 $outer;
                        private final TopicPartition partition$1;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$1, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = liveReplicasPerPartition.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Seq<Object>> x0$4) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    Seq liveReplicas = (Seq)tuple2._2();
                    boolean bl = liveReplicas.isEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas2 = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithoutLiveReplicas, (Object)partitionsWithLiveReplicas2);
        Seq partitionsWithoutLiveReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple23._2();
        partitionsWithoutLiveReplicas2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final void apply(Tuple2<TopicPartition, Seq<Object>> x0$5) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error during state change of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.epoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " from New to Online, assigned replicas are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "], live brokers are [", "]. No assigned "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(","), this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.liveBrokerIds()}))).append((Object)"replica is alive.").toString();
                    this.$outer.kafka$controller$PartitionStateMachine$$logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((TraversableOnce)partitionsWithLiveReplicas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicPartition, Seq<Object>> x0$6) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq liveReplicas = (Seq)tuple2._2();
                    LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.epoch());
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs, this.kafka$controller$PartitionStateMachine$$controllerContext.epochZkVersion());
        }
        catch (Exception exception) {
            partitionsWithLiveReplicas.foreach((Function1)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final Exception e$4;

                public final void apply(Tuple2<TopicPartition, Seq<Object>> x0$7) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$7;
                    if (tuple2 != null) {
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        this.$outer.kafka$controller$PartitionStateMachine$$logFailedStateChange(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), (PartitionState)NewPartition$.MODULE$, this.e$4);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.e$4 = e$4;
                }
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        catch (ControllerMovedException controllerMovedException) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Controller moved to another broker when trying to create the topic partition state znode";
                }
            }, (Function0<Throwable>)new Serializable(this, controllerMovedException){
                public static final long serialVersionUID = 0L;
                private final ControllerMovedException e$3;

                public final ControllerMovedException apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = e$3;
                }
            });
            throw controllerMovedException;
        }
        Seq createResponses = seq;
        createResponses.foreach((Function1)new Serializable(this, successfulInitializations, leaderIsrAndControllerEpochs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final Buffer successfulInitializations$1;
            private final scala.collection.immutable.Map leaderIsrAndControllerEpochs$1;

            public final Object apply(CreateResponse createResponse2) {
                BoxedUnit boxedUnit;
                KeeperException.Code code = createResponse2.resultCode();
                TopicPartition partition = (TopicPartition)createResponse2.ctx().get();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)this.leaderIsrAndControllerEpochs$1.apply((Object)partition);
                KeeperException.Code code2 = code;
                KeeperException.Code code3 = KeeperException.Code.OK;
                if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                    this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                    this.$outer.kafka$controller$PartitionStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition), true);
                    boxedUnit = this.successfulInitializations$1.$plus$eq((Object)partition);
                } else {
                    this.$outer.kafka$controller$PartitionStateMachine$$logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulInitializations$1 = successfulInitializations$1;
                this.leaderIsrAndControllerEpochs$1 = leaderIsrAndControllerEpochs$1;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        void var3_3;
        Buffer successfulElections = (Buffer)Buffer$.MODULE$.empty();
        Seq remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.doElectLeaderForPartitions(partitions, partitionLeaderElectionStrategy);
            if (tuple3 != null) {
                Tuple3 tuple32;
                Seq success = (Seq)tuple3._1();
                Seq updatesToRetry = (Seq)tuple3._2();
                scala.collection.immutable.Map failedElections = (scala.collection.immutable.Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)success, (Object)updatesToRetry, (Object)failedElections);
                Seq success2 = (Seq)tuple33._1();
                Seq updatesToRetry2 = (Seq)tuple33._2();
                scala.collection.immutable.Map failedElections2 = (scala.collection.immutable.Map)tuple33._3();
                remaining = updatesToRetry2;
                successfulElections.$plus$plus$eq((TraversableOnce)success2);
                failedElections2.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;

                    public final void apply(Tuple2<TopicPartition, Exception> x0$8) {
                        Tuple2<TopicPartition, Exception> tuple2 = x0$8;
                        if (tuple2 != null) {
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            Exception e = (Exception)tuple2._2();
                            this.$outer.kafka$controller$PartitionStateMachine$$logFailedStateChange(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                continue;
            }
            throw new MatchError(tuple3);
        }
        return var3_3;
    }

    private Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Tuple2 tuple2;
        block8: {
            PartitionLeaderElectionStrategy partitionLeaderElectionStrategy2;
            block13: {
                Tuple2 tuple22;
                Map failedElections;
                block10: {
                    Set shuttingDownBrokers;
                    Buffer validPartitionsForElection;
                    block12: {
                        block11: {
                            block9: {
                                Tuple2 tuple23;
                                Seq<GetDataResponse> getDataResponses;
                                try {
                                    getDataResponses = this.zkClient.getTopicPartitionStatesRaw(partitions);
                                }
                                catch (Exception exception) {
                                    return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)((TraversableOnce)partitions.map((Function1)new Serializable(this, exception){
                                        public static final long serialVersionUID = 0L;
                                        private final Exception e$5;

                                        public final Tuple2<TopicPartition, Exception> apply(TopicPartition x$4) {
                                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$4), (Object)this.e$5);
                                        }
                                        {
                                            this.e$5 = e$5;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                                }
                                failedElections = Map$.MODULE$.empty();
                                Buffer leaderIsrAndControllerEpochPerPartition = (Buffer)Buffer$.MODULE$.empty();
                                getDataResponses.foreach((Function1)new Serializable(this, failedElections, leaderIsrAndControllerEpochPerPartition){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;
                                    private final Map failedElections$1;
                                    private final Buffer leaderIsrAndControllerEpochPerPartition$1;

                                    public final Object apply(GetDataResponse getDataResponse) {
                                        Option option;
                                        TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
                                        PartitionState currState = (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition);
                                        KeeperException.Code code = getDataResponse.resultCode();
                                        KeeperException.Code code2 = KeeperException.Code.OK;
                                        if (!(code != null ? !code.equals(code2) : code2 != null)) {
                                            BoxedUnit boxedUnit;
                                            Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                                            if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                                                StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                                                boxedUnit = this.failedElections$1.put((Object)partition, (Object)exception);
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            option = this.leaderIsrAndControllerEpochPerPartition$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderIsrAndControllerEpochOpt.get()));
                                        } else {
                                            KeeperException.Code code3 = getDataResponse.resultCode();
                                            KeeperException.Code code4 = KeeperException.Code.NONODE;
                                            if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                                                StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                                                option = this.failedElections$1.put((Object)partition, (Object)exception);
                                            } else {
                                                option = this.failedElections$1.put((Object)partition, getDataResponse.resultException().get());
                                            }
                                        }
                                        return option;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.failedElections$1 = failedElections$1;
                                        this.leaderIsrAndControllerEpochPerPartition$1 = leaderIsrAndControllerEpochPerPartition$1;
                                    }
                                });
                                tuple2 = leaderIsrAndControllerEpochPerPartition.partition((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;

                                    public final boolean apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$9) {
                                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$9;
                                        if (tuple2 != null) {
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                                            boolean bl = leaderIsrAndControllerEpoch.controllerEpoch() > this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.epoch();
                                            return bl;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                if (tuple2 == null) break block8;
                                Buffer invalidPartitionsForElection = (Buffer)tuple2._1();
                                Buffer validPartitionsForElection2 = (Buffer)tuple2._2();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)invalidPartitionsForElection, (Object)validPartitionsForElection2);
                                Buffer invalidPartitionsForElection2 = (Buffer)tuple24._1();
                                validPartitionsForElection = (Buffer)tuple24._2();
                                invalidPartitionsForElection2.foreach((Function1)new Serializable(this, failedElections){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ PartitionStateMachine $outer;
                                    private final Map failedElections$1;

                                    public final Option<Exception> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$10) {
                                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$10;
                                        if (tuple2 != null) {
                                            TopicPartition partition = (TopicPartition)tuple2._1();
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                                            String failMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborted leader election for partition ", " since the LeaderAndIsr path was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already written by another controller. This probably means that the current controller ", " went through "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a soft failure and another controller was elected with epoch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}))).toString();
                                            Option option = this.failedElections$1.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
                                            return option;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.failedElections$1 = failedElections$1;
                                    }
                                });
                                if (validPartitionsForElection.isEmpty()) {
                                    return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)failedElections.toMap(Predef$.MODULE$.$conforms()));
                                }
                                shuttingDownBrokers = this.kafka$controller$PartitionStateMachine$$controllerContext.shuttingDownBrokerIds().toSet();
                                partitionLeaderElectionStrategy2 = partitionLeaderElectionStrategy;
                                if (!OfflinePartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block9;
                                tuple22 = this.leaderForOffline((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection).partition((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> x0$11) {
                                        Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> tuple3 = x0$11;
                                        if (tuple3 != null) {
                                            Option newLeaderAndIsrOpt = (Option)tuple3._2();
                                            boolean bl = newLeaderAndIsrOpt.isEmpty();
                                            return bl;
                                        }
                                        throw new MatchError(tuple3);
                                    }
                                });
                                break block10;
                            }
                            if (!ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block11;
                            tuple22 = this.leaderForReassign((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection).partition((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> x0$12) {
                                    Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> tuple3 = x0$12;
                                    if (tuple3 != null) {
                                        Option newLeaderAndIsrOpt = (Option)tuple3._2();
                                        boolean bl = newLeaderAndIsrOpt.isEmpty();
                                        return bl;
                                    }
                                    throw new MatchError(tuple3);
                                }
                            });
                            break block10;
                        }
                        if (!PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block12;
                        tuple22 = this.leaderForPreferredReplica((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection).partition((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> x0$13) {
                                Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> tuple3 = x0$13;
                                if (tuple3 != null) {
                                    Option newLeaderAndIsrOpt = (Option)tuple3._2();
                                    boolean bl = newLeaderAndIsrOpt.isEmpty();
                                    return bl;
                                }
                                throw new MatchError(tuple3);
                            }
                        });
                        break block10;
                    }
                    if (!ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) break block13;
                    tuple22 = this.leaderForControlledShutdown((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection, (Set<Object>)shuttingDownBrokers).partition((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> x0$14) {
                            Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> tuple3 = x0$14;
                            if (tuple3 != null) {
                                Option newLeaderAndIsrOpt = (Option)tuple3._2();
                                boolean bl = newLeaderAndIsrOpt.isEmpty();
                                return bl;
                            }
                            throw new MatchError(tuple3);
                        }
                    });
                }
                Tuple2 tuple25 = tuple22;
                if (tuple25 != null) {
                    Tuple2 tuple26;
                    Seq partitionsWithoutLeaders = (Seq)tuple25._1();
                    Seq partitionsWithLeaders = (Seq)tuple25._2();
                    Tuple2 tuple27 = tuple26 = new Tuple2((Object)partitionsWithoutLeaders, (Object)partitionsWithLeaders);
                    Seq partitionsWithoutLeaders2 = (Seq)tuple27._1();
                    Seq partitionsWithLeaders2 = (Seq)tuple27._2();
                    partitionsWithoutLeaders2.foreach((Function1)new Serializable(this, partitionLeaderElectionStrategy, failedElections){
                        public static final long serialVersionUID = 0L;
                        private final PartitionLeaderElectionStrategy partitionLeaderElectionStrategy$1;
                        private final Map failedElections$1;

                        public final Option<Exception> apply(Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> x0$15) {
                            Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> tuple3 = x0$15;
                            if (tuple3 != null) {
                                TopicPartition partition = (TopicPartition)tuple3._1();
                                String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to elect leader for partition ", " under strategy ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, this.partitionLeaderElectionStrategy$1}));
                                Option option = this.failedElections$1.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
                                return option;
                            }
                            throw new MatchError(tuple3);
                        }
                        {
                            this.partitionLeaderElectionStrategy$1 = partitionLeaderElectionStrategy$1;
                            this.failedElections$1 = failedElections$1;
                        }
                    });
                    scala.collection.immutable.Map recipientsPerPartition = ((TraversableOnce)partitionsWithLeaders2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicPartition, Seq<Object>> apply(Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> x0$16) {
                            Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> tuple3 = x0$16;
                            if (tuple3 != null) {
                                TopicPartition partition = (TopicPartition)tuple3._1();
                                Seq recipients = (Seq)tuple3._3();
                                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)recipients);
                                return tuple2;
                            }
                            throw new MatchError(tuple3);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    scala.collection.immutable.Map adjustedLeaderAndIsrs = ((TraversableOnce)partitionsWithLeaders2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicPartition, LeaderAndIsr> apply(Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> x0$17) {
                            Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> tuple3 = x0$17;
                            if (tuple3 != null) {
                                TopicPartition partition = (TopicPartition)tuple3._1();
                                Option leaderAndIsrOpt = (Option)tuple3._2();
                                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderAndIsrOpt.get());
                                return tuple2;
                            }
                            throw new MatchError(tuple3);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.kafka$controller$PartitionStateMachine$$controllerContext.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext.epochZkVersion());
                    if (updateLeaderAndIsrResult != null) {
                        Tuple3 tuple3;
                        scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
                        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
                        scala.collection.immutable.Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
                        Tuple3 tuple32 = tuple3 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
                        scala.collection.immutable.Map successfulUpdates2 = (scala.collection.immutable.Map)tuple32._1();
                        Seq updatesToRetry2 = (Seq)tuple32._2();
                        scala.collection.immutable.Map failedUpdates2 = (scala.collection.immutable.Map)tuple32._3();
                        successfulUpdates2.foreach((Function1)new Serializable(this, recipientsPerPartition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ PartitionStateMachine $outer;
                            private final scala.collection.immutable.Map recipientsPerPartition$1;

                            public final void apply(Tuple2<TopicPartition, LeaderAndIsr> x0$18) {
                                Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$18;
                                if (tuple2 != null) {
                                    TopicPartition partition = (TopicPartition)tuple2._1();
                                    LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                                    Seq<Object> replicas = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition);
                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.epoch());
                                    this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                                    this.$outer.kafka$controller$PartitionStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)this.recipientsPerPartition$1.apply((Object)partition)), partition, leaderIsrAndControllerEpoch, replicas, false);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.recipientsPerPartition$1 = recipientsPerPartition$1;
                            }
                        });
                        return new Tuple3((Object)successfulUpdates2.keys().toSeq(), (Object)updatesToRetry2, (Object)failedElections.toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedUpdates2));
                    }
                    throw new MatchError((Object)updateLeaderAndIsrResult);
                }
                throw new MatchError((Object)tuple25);
            }
            throw new MatchError((Object)partitionLeaderElectionStrategy2);
        }
        throw new MatchError((Object)tuple2);
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForOffline(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        Tuple2 tuple2 = leaderIsrAndControllerEpochs.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final boolean apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$19) {
                Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$19;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                    List liveInSyncReplicas = (List)leaderIsrAndControllerEpoch.leaderAndIsr().isr().filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$29 $outer;
                        private final TopicPartition partition$3;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$3, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$3 = partition$3;
                        }
                    });
                    boolean bl = liveInSyncReplicas.isEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
            Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionsWithNoLiveInSyncReplicas, (Object)partitionsWithLiveInSyncReplicas);
            Seq partitionsWithNoLiveInSyncReplicas2 = (Seq)tuple23._1();
            Seq partitionsWithLiveInSyncReplicas2 = (Seq)tuple23._2();
            Tuple2<scala.collection.immutable.Map<String, LogConfig>, scala.collection.immutable.Map<String, Exception>> tuple24 = this.zkClient.getLogConfigs((Seq<String>)((Seq)partitionsWithNoLiveInSyncReplicas2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$20) {
                    Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$20;
                    if (tuple2 != null) {
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        String string = partition.topic();
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())), this.config.originals());
            if (tuple24 != null) {
                Tuple2 tuple25;
                scala.collection.immutable.Map logConfigs = (scala.collection.immutable.Map)tuple24._1();
                scala.collection.immutable.Map failed = (scala.collection.immutable.Map)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)logConfigs, (Object)failed);
                scala.collection.immutable.Map logConfigs2 = (scala.collection.immutable.Map)tuple26._1();
                scala.collection.immutable.Map failed2 = (scala.collection.immutable.Map)tuple26._2();
                Seq partitionsWithUncleanLeaderElectionState = (Seq)((TraversableLike)partitionsWithNoLiveInSyncReplicas2.map((Function1)new Serializable(this, logConfigs2, failed2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;
                    private final scala.collection.immutable.Map logConfigs$1;
                    private final scala.collection.immutable.Map failed$1;

                    public final Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$21) {
                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$21;
                        if (tuple2 != null) {
                            Tuple3 tuple3;
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                            if (this.failed$1.contains((Object)partition.topic())) {
                                this.$outer.kafka$controller$PartitionStateMachine$$logFailedStateChange(partition, (PartitionState)this.$outer.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)this.failed$1.apply((Object)partition.topic()));
                                tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            } else {
                                tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)((Object)this.logConfigs$1.apply((Object)partition.topic()))).uncleanLeaderElectionEnable()));
                            }
                            Tuple3 tuple32 = tuple3;
                            return tuple32;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.logConfigs$1 = logConfigs$1;
                        this.failed$1 = failed$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLiveInSyncReplicas2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$22) {
                        Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$22;
                        if (tuple2 != null) {
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            return tuple3;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                return (Seq)partitionsWithUncleanLeaderElectionState.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionStateMachine $outer;

                    public final Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> apply(Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object> x0$23) {
                        Tuple3<TopicPartition, Option<LeaderIsrAndControllerEpoch>, Object> tuple3 = x0$23;
                        if (tuple3 != null) {
                            Tuple3 tuple32;
                            TopicPartition partition = (TopicPartition)tuple3._1();
                            Option leaderIsrAndControllerEpochOpt = (Option)tuple3._2();
                            boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                            Seq<Object> assignment = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition);
                            Seq liveReplicas = (Seq)assignment.filter((Function1)new Serializable(this, partition){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$leaderForOffline$1 $outer;
                                private final TopicPartition partition$4;

                                public final boolean apply(int replica) {
                                    return this.apply$mcZI$sp(replica);
                                }

                                public boolean apply$mcZI$sp(int replica) {
                                    return this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$4, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.partition$4 = partition$4;
                                }
                            });
                            if (leaderIsrAndControllerEpochOpt.nonEmpty()) {
                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                                List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
                                Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet(), uncleanLeaderElectionEnabled, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext);
                                Option newLeaderAndIsrOpt = leaderOpt.map((Function1)new Serializable(this, partition, leaderIsrAndControllerEpoch, isr){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$leaderForOffline$1 $outer;
                                    public final TopicPartition partition$4;
                                    private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;
                                    private final List isr$1;

                                    public final LeaderAndIsr apply(int leader) {
                                        List newIsr = this.isr$1.contains((Object)BoxesRunTime.boxToInteger((int)leader)) ? (List)this.isr$1.filter((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$leaderForOffline$1$$anonfun$33 $outer;

                                            public final boolean apply(int replica) {
                                                return this.apply$mcZI$sp(replica);
                                            }

                                            public boolean apply$mcZI$sp(int replica) {
                                                return this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.$outer.partition$4, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        }) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                                        return this.leaderIsrAndControllerEpoch$1.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)newIsr);
                                    }

                                    public /* synthetic */ $anonfun$leaderForOffline$1 kafka$controller$PartitionStateMachine$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.partition$4 = partition$4;
                                        this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch$1;
                                        this.isr$1 = isr$1;
                                    }
                                });
                                tuple32 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveReplicas);
                            } else {
                                tuple32 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)liveReplicas);
                            }
                            Tuple3 tuple33 = tuple32;
                            return tuple33;
                        }
                        throw new MatchError(tuple3);
                    }

                    public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForReassign(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$24) {
                Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$24;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                    Seq<Object> reassignment = ((ReassignedPartitionsContext)this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionsBeingReassigned().apply((Object)partition)).newReplicas();
                    Seq liveReplicas = (Seq)reassignment.filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$leaderForReassign$1 $outer;
                        private final TopicPartition partition$5;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$5, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$5 = partition$5;
                        }
                    });
                    List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
                    Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
                    Option newLeaderAndIsrOpt = leaderOpt.map((Function1)new Serializable(this, leaderIsrAndControllerEpoch){
                        public static final long serialVersionUID = 0L;
                        private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$2;

                        public final LeaderAndIsr apply(int leader) {
                            return this.leaderIsrAndControllerEpoch$2.leaderAndIsr().newLeader(leader);
                        }
                        {
                            this.leaderIsrAndControllerEpoch$2 = leaderIsrAndControllerEpoch$2;
                        }
                    });
                    Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, reassignment);
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForPreferredReplica(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$25) {
                Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$25;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                    Seq<Object> assignment = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition);
                    Seq liveReplicas = (Seq)assignment.filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$leaderForPreferredReplica$1 $outer;
                        private final TopicPartition partition$6;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$6, this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline$default$3());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$6 = partition$6;
                        }
                    });
                    List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
                    Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
                    Option newLeaderAndIsrOpt = leaderOpt.map((Function1)new Serializable(this, leaderIsrAndControllerEpoch){
                        public static final long serialVersionUID = 0L;
                        private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$3;

                        public final LeaderAndIsr apply(int leader) {
                            return this.leaderIsrAndControllerEpoch$3.leaderAndIsr().newLeader(leader);
                        }
                        {
                            this.leaderIsrAndControllerEpoch$3 = leaderIsrAndControllerEpoch$3;
                        }
                    });
                    Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, assignment);
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForControlledShutdown(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs, Set<Object> shuttingDownBrokers) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1)new Serializable(this, shuttingDownBrokers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final Set shuttingDownBrokers$1;

            public final Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$26) {
                Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$26;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                    Seq<Object> assignment = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.partitionReplicaAssignment(partition);
                    Seq liveOrShuttingDownReplicas = (Seq)assignment.filter((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$leaderForControlledShutdown$1 $outer;
                        private final TopicPartition partition$7;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.isReplicaOnline(replica, this.partition$7, true);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$7 = partition$7;
                        }
                    });
                    List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
                    Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveOrShuttingDownReplicas.toSet(), (Set<Object>)this.shuttingDownBrokers$1);
                    List newIsr = (List)isr.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$leaderForControlledShutdown$1 $outer;

                        public final boolean apply(int replica) {
                            return this.apply$mcZI$sp(replica);
                        }

                        public boolean apply$mcZI$sp(int replica) {
                            return !this.$outer.kafka$controller$PartitionStateMachine$$anonfun$$$outer().kafka$controller$PartitionStateMachine$$controllerContext.shuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replica));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    Option newLeaderAndIsrOpt = leaderOpt.map((Function1)new Serializable(this, leaderIsrAndControllerEpoch, newIsr){
                        public static final long serialVersionUID = 0L;
                        private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$4;
                        private final List newIsr$1;

                        public final LeaderAndIsr apply(int leader) {
                            return this.leaderIsrAndControllerEpoch$4.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)this.newIsr$1);
                        }
                        {
                            this.leaderIsrAndControllerEpoch$4 = leaderIsrAndControllerEpoch$4;
                            this.newIsr$1 = newIsr$1;
                        }
                    });
                    Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveOrShuttingDownReplicas);
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shuttingDownBrokers$1 = shuttingDownBrokers$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public boolean kafka$controller$PartitionStateMachine$$isValidTransition(TopicPartition partition, PartitionState targetState) {
        return targetState.validPreviousStates().contains(this.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition));
    }

    public void kafka$controller$PartitionStateMachine$$logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState.apply((Object)partition);
        IllegalStateException e = new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should be in one of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " states before moving to ", " state. Instead it is in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState.validPreviousStates().mkString(","), targetState}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currState}))).toString());
        this.kafka$controller$PartitionStateMachine$$logFailedStateChange(partition, currState, targetState, e);
    }

    public void kafka$controller$PartitionStateMachine$$logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.kafka$controller$PartitionStateMachine$$logFailedStateChange(partition, currState, targetState, (Throwable)KeeperException.create((KeeperException.Code)code));
    }

    public void kafka$controller$PartitionStateMachine$$logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.kafka$controller$PartitionStateMachine$$controllerContext.epoch()).error((Function0<String>)new Serializable(this, partition, currState, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final TopicPartition partition$2;
            private final PartitionState currState$1;
            private final PartitionState targetState$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " failed to change state for partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$PartitionStateMachine$$controllerContext.epoch()), this.partition$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currState$1, this.targetState$3}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
                this.currState$1 = currState$1;
                this.targetState$3 = targetState$3;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public PartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, KafkaZkClient zkClient, Map<TopicPartition, PartitionState> partitionState, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.kafka$controller$PartitionStateMachine$$controllerContext = controllerContext;
        this.zkClient = zkClient;
        this.kafka$controller$PartitionStateMachine$$partitionState = partitionState;
        this.kafka$controller$PartitionStateMachine$$controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerId = config.brokerId();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[PartitionStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controllerId())})));
        this.offlinePartitionCount = 0;
    }
}

