/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rf!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t\u001b^\u001b2\u0001A\u0005\u0012!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011aa\u00142kK\u000e$\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u000e\u0003\tIw.\u0003\u0002\u0017'\tI1\t\\8tK\u0006\u0014G.\u001a\u0005\t1\u0001\u0011\t\u0019!C\u00013\u0005!a-\u001b7f+\u0005Q\u0002C\u0001\n\u001c\u0013\ta2C\u0001\u0003GS2,\u0007\u0002\u0003\u0010\u0001\u0005\u0003\u0007I\u0011A\u0010\u0002\u0011\u0019LG.Z0%KF$\"\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\bOu\t\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\tS\u0001\u0011\t\u0011)Q\u00055\u0005)a-\u001b7fA!\u0012\u0001f\u000b\t\u0003C1J!!\f\u0012\u0003\u0011Y|G.\u0019;jY\u0016D\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001M\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$X#A\u0019\u0011\u0005\u0005\u0012\u0014BA\u001a#\u0005\u0011auN\\4\t\u0011U\u0002!\u0011!Q\u0001\nE\n1BY1tK>3gm]3uA!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001(\u0001\u0007nCbLe\u000eZ3y'&TX-F\u0001:!\t\t#(\u0003\u0002<E\t\u0019\u0011J\u001c;\t\u0011u\u0002!\u0011!Q\u0001\ne\nQ\"\\1y\u0013:$W\r_*ju\u0016\u0004\u0003\u0002C \u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u0011]\u0014\u0018\u000e^1cY\u0016,\u0012!\u0011\t\u0003C\tK!a\u0011\u0012\u0003\u000f\t{w\u000e\\3b]\"AQ\t\u0001B\u0001B\u0003%\u0011)A\u0005xe&$\u0018M\u00197fA!)q\t\u0001C\u0001\u0011\u00061A(\u001b8jiz\"R!S-[7r\u0003BA\u0013\u0001L-6\t!\u0001\u0005\u0002M\u001b2\u0001A!\u0002(\u0001\u0005\u0004y%!A&\u0012\u0005A\u001b\u0006CA\u0011R\u0013\t\u0011&EA\u0004O_RD\u0017N\\4\u0011\u0005\u0005\"\u0016BA+#\u0005\r\te.\u001f\t\u0003\u0019^#Q\u0001\u0017\u0001C\u0002=\u0013\u0011A\u0016\u0005\u00061\u0019\u0003\rA\u0007\u0005\u0006_\u0019\u0003\r!\r\u0005\bo\u0019\u0003\n\u00111\u0001:\u0011\u0015yd\t1\u0001B\u0011%q\u0006\u00011AA\u0002\u0013%\u0001'A\u0004`Y\u0016tw\r\u001e5\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n\u0013\t\u0017aC0mK:<G\u000f[0%KF$\"\u0001\t2\t\u000f\u001dz\u0016\u0011!a\u0001c!1A\r\u0001Q!\nE\n\u0001b\u00187f]\u001e$\b\u000e\t\u0015\u0003G.BQa\u001a\u0001\u0007\u0012a\n\u0011\"\u001a8uef\u001c\u0016N_3\t\u000b%\u0004A\u0011\u0003\u001d\u0002\u0019};\u0018M]7F]R\u0014\u0018.Z:\t\u000f-\u0004!\u0019!C\tY\u0006!An\\2l+\u0005i\u0007C\u00018v\u001b\u0005y'B\u00019r\u0003\u0015awnY6t\u0015\t\u00118/\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001^\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003m>\u0014QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007B\u0002=\u0001A\u0003%Q.A\u0003m_\u000e\\\u0007\u0005C\u0004{\u0001\u0001\u0007I\u0011C>\u0002\t5l\u0017\r]\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a`\u0007\u0002\u00079Lw.C\u0002\u0002\u0004y\u0014\u0001#T1qa\u0016$')\u001f;f\u0005V4g-\u001a:\t\u0013\u0005\u001d\u0001\u00011A\u0005\u0012\u0005%\u0011\u0001C7nCB|F%Z9\u0015\u0007\u0001\nY\u0001\u0003\u0005(\u0003\u000b\t\t\u00111\u0001}\u0011\u001d\ty\u0001\u0001Q!\nq\fQ!\\7ba\u0002B3!!\u0004,\u0011\u001d\t)\u0002\u0001Q!\ne\n1bX7bq\u0016sGO]5fg\"\u001a\u00111C\u0016\t\u0011\u0005m\u0001\u00011A\u0005\u0012a\n\u0001bX3oiJLWm\u001d\u0005\n\u0003?\u0001\u0001\u0019!C\t\u0003C\tAbX3oiJLWm]0%KF$2\u0001IA\u0012\u0011!9\u0013QDA\u0001\u0002\u0004I\u0004bBA\u0014\u0001\u0001\u0006K!O\u0001\n?\u0016tGO]5fg\u0002B3!!\n,\u0011\u0019\ti\u0003\u0001C\u0001\u0001\u00061\u0011n\u001d$vY2Da!!\r\u0001\t\u0003A\u0014AC7bq\u0016sGO]5fg\"1\u0011Q\u0007\u0001\u0005\u0002a\nq!\u001a8ue&,7\u000f\u0003\u0004\u0002:\u0001!\t\u0001M\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u00051!/Z:ju\u0016$2!QA!\u0011\u001d\t\u0019%a\u000fA\u0002e\nqA\\3x'&TX\rC\u0004\u0002H\u0001!\t!!\u0013\u0002\u0011I,g.Y7f)>$2\u0001IA&\u0011\u001d\ti%!\u0012A\u0002i\t\u0011A\u001a\u0005\b\u0003#\u0002A\u0011AA*\u0003\u00151G.^:i)\u0005\u0001\u0003bBA,\u0001\u0011\u0005\u0011\u0011L\u0001\u000fI\u0016dW\r^3JM\u0016C\u0018n\u001d;t)\u0005\t\u0005bBA/\u0001\u0011\u0005\u00111K\u0001\u0010iJLW\u000eV8WC2LGmU5{K\"1\u0011\u0011\r\u0001\u0005\u0002a\n1b]5{K&s')\u001f;fg\"9\u0011Q\r\u0001\u0005\u0002\u0005M\u0013!B2m_N,\u0007bBA5\u0001\u0011\u0005\u00111K\u0001\rG2|7/\u001a%b]\u0012dWM\u001d\u0005\b\u0003[\u0002a\u0011AA*\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u000f\u0005E\u0004A\"\u0005\u0002T\u0005AAO];oG\u0006$X\rC\u0004\u0002v\u00011\t!a\u001e\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000eF\u0002!\u0003sBq!a\u001f\u0002t\u0001\u0007\u0011'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003\u007f\u0002A\u0011AA*\u0003\u0015\u0011Xm]3u\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000b\u000baB]3mCRLg/Z(gMN,G\u000fF\u0002:\u0003\u000fCq!a\u001f\u0002\u0002\u0002\u0007\u0011\u0007C\u0004\u0002\f\u0002!\t!!$\u0002\u001f\r\fg.\u00119qK:$wJ\u001a4tKR$2!QAH\u0011\u001d\tY(!#A\u0002EBq!a%\u0001\t#\t\u0019&\u0001\btC\u001a,gi\u001c:dKVsW.\u00199\t\u0011\u0005]\u0005\u0001\"\u0005\u0003\u0003'\n!BZ8sG\u0016,f.\\1q\u0011\u001d\tY\n\u0001C\t\u0003;\u000b\u0011\"\\1zE\u0016dunY6\u0016\t\u0005}\u0015Q\u0015\u000b\u0005\u0003C\u000b\u0019\f\u0006\u0003\u0002$\u0006%\u0006c\u0001'\u0002&\u00129\u0011qUAM\u0005\u0004y%!\u0001+\t\u0013\u0005-\u0016\u0011\u0014CA\u0002\u00055\u0016a\u00014v]B)\u0011%a,\u0002$&\u0019\u0011\u0011\u0017\u0012\u0003\u0011q\u0012\u0017P\\1nKzBqa[AM\u0001\u0004\t)\fE\u0002o\u0003oK1!!/p\u0005\u0011aunY6\t\u000f\u0005u\u0006A\"\u0005\u0002@\u0006Q\u0001/\u0019:tK\u0016sGO]=\u0015\r\u0005\u0005\u0017qYAi!\rQ\u00151Y\u0005\u0004\u0003\u000b\u0014!AC%oI\u0016DXI\u001c;ss\"A\u0011\u0011ZA^\u0001\u0004\tY-\u0001\u0004ck\u001a4WM\u001d\t\u0004{\u00065\u0017bAAh}\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\u0005M\u00171\u0018a\u0001s\u0005\ta\u000eC\u0004\u0002X\u0002!\t\"!7\u000211\f'oZ3ti2{w/\u001a:C_VtGm\u00157pi\u001a{'\u000fF\u0004:\u00037\fy.a9\t\u0011\u0005u\u0017Q\u001ba\u0001\u0003\u0017\f1!\u001b3y\u0011\u001d\t\t/!6A\u0002E\na\u0001^1sO\u0016$\b\u0002CAs\u0003+\u0004\r!a:\u0002\u0019M,\u0017M]2i\u000b:$\u0018\u000e^=\u0011\t\u0005%\u0018Q \b\u0005\u0003W\fIP\u0004\u0003\u0002n\u0006]h\u0002BAx\u0003kl!!!=\u000b\u0007\u0005Mh!\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u00111\u0001B\u0005\u0004\u0003w\u0014\u0011aD%oI\u0016D8+Z1sG\"$\u0016\u0010]3\n\t\u0005}(\u0011\u0001\u0002\u0012\u0013:$W\r_*fCJ\u001c\u0007.\u00128uSRL(bAA~\u0005!9!Q\u0001\u0001\u0005\u0012\t\u001d\u0011!G:nC2dWm\u001d;VaB,'OQ8v]\u0012\u001cFn\u001c;G_J$r!\u000fB\u0005\u0005\u0017\u0011i\u0001\u0003\u0005\u0002^\n\r\u0001\u0019AAf\u0011\u001d\t\tOa\u0001A\u0002EB\u0001\"!:\u0003\u0004\u0001\u0007\u0011q\u001d\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0003EIg\u000eZ3y'2|GOU1oO\u00164uN\u001d\u000b\t\u0005+\u0011YB!\b\u0003 A)\u0011Ea\u0006:s%\u0019!\u0011\u0004\u0012\u0003\rQ+\b\u000f\\33\u0011!\tiNa\u0004A\u0002\u0005-\u0007bBAq\u0005\u001f\u0001\r!\r\u0005\t\u0003K\u0014y\u00011\u0001\u0002h\"9!1\u0005\u0001\u0005\n\t\u0015\u0012!E2p[B\f'/Z%oI\u0016DXI\u001c;ssR9\u0011Ha\n\u0003,\t5\u0002\u0002\u0003B\u0015\u0005C\u0001\r!!1\u0002\u0015%tG-\u001a=F]R\u0014\u0018\u0010C\u0004\u0002b\n\u0005\u0002\u0019A\u0019\t\u0011\u0005\u0015(\u0011\u0005a\u0001\u0003ODqA!\r\u0001\t\u0013\u0011\u0019$\u0001\rs_VtG\rR8x]R{W\t_1di6+H\u000e^5qY\u0016$R!\u000fB\u001b\u0005sAqAa\u000e\u00030\u0001\u0007\u0011(\u0001\u0004ok6\u0014WM\u001d\u0005\b\u0005w\u0011y\u00031\u0001:\u0003\u00191\u0017m\u0019;pe\"9!q\b\u0001\u0005\n\t\u0005\u0013A\u0003;p%\u0016d\u0017\r^5wKR!!1\tB%!\u0011\t#QI\u001d\n\u0007\t\u001d#E\u0001\u0004PaRLwN\u001c\u0005\b\u0003w\u0012i\u00041\u00012\u000f\u001d\u0011iE\u0001E\u0001\u0005\u001f\nQ\"\u00112tiJ\f7\r^%oI\u0016D\bc\u0001&\u0003R\u00191\u0011A\u0001E\u0001\u0005'\u001abA!\u0015\u0003V\tm\u0003cA\u0011\u0003X%\u0019!\u0011\f\u0012\u0003\r\u0005s\u0017PU3g!\u0011\u0011iFa\u0019\u000e\u0005\t}#b\u0001B1\t\u0005)Q\u000f^5mg&!!Q\rB0\u0005\u001daunZ4j]\u001eDqa\u0012B)\t\u0003\u0011I\u0007\u0006\u0002\u0003P!Q!Q\u000eB)\u0005\u0004%\tEa\u001c\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0003rA!!1\u000fB=\u001d\r\t#QO\u0005\u0004\u0005o\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0003|\tu$AB*ue&twMC\u0002\u0003x\tB\u0011B!!\u0003R\u0001\u0006IA!\u001d\u0002\u00171|wmZ3s\u001d\u0006lW\r\t\u0005\u000b\u0005\u000b\u0013\t&%A\u0005\u0002\t\u001d\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0004\u0003\n\n}%\u0011U\u000b\u0003\u0005\u0017S3!\u000fBGW\t\u0011y\t\u0005\u0003\u0003\u0012\nmUB\u0001BJ\u0015\u0011\u0011)Ja&\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BME\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu%1\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002(\u0003\u0004\n\u0007q\n\u0002\u0004Y\u0005\u0007\u0013\ra\u0014")
public abstract class AbstractIndex<K, V>
implements Closeable {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long kafka$log$AbstractIndex$$_length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        AbstractIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        AbstractIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        AbstractIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        AbstractIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        AbstractIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return AbstractIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return AbstractIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        AbstractIndex$.MODULE$.trace(function0);
    }

    public static String msgWithLogIdent(String string) {
        return AbstractIndex$.MODULE$.msgWithLogIdent(string);
    }

    public static void logIdent_$eq(String string) {
        AbstractIndex$.MODULE$.logIdent_$eq(string);
    }

    public static String logIdent() {
        return AbstractIndex$.MODULE$.logIdent();
    }

    public static Logger logger() {
        return AbstractIndex$.MODULE$.logger();
    }

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return AbstractIndex$.MODULE$.loggerName();
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    public long kafka$log$AbstractIndex$$_length() {
        return this.kafka$log$AbstractIndex$$_length;
    }

    public void kafka$log$AbstractIndex$$_length_$eq(long x$1) {
        this.kafka$log$AbstractIndex$$_length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this.kafka$log$AbstractIndex$$_length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                boolean bl;
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                if (this.$outer.kafka$log$AbstractIndex$$_length() == (long)roundedNewSize) {
                    AbstractIndex$.MODULE$.debug((Function0<String>)new Serializable(this, roundedNewSize){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resize$1 $outer;
                        private final int roundedNewSize$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " was not resized because it already has size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.roundedNewSize$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.roundedNewSize$1 = roundedNewSize$1;
                        }
                    });
                    return false;
                }
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rw");
                try {
                    int position = this.$outer.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.$outer.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this.$outer.kafka$log$AbstractIndex$$_length_$eq(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    this.$outer.mmap().position(position);
                    AbstractIndex$.MODULE$.debug((Function0<String>)new Serializable(this, roundedNewSize){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resize$1 $outer;
                        private final int roundedNewSize$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resized ", " to ", ", position is ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.roundedNewSize$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().mmap().position())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and limit is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().mmap().limit())}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.roundedNewSize$1 = roundedNewSize$1;
                        }
                    });
                    bl = true;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
                    throw throwable;
                }
                return bl;
            }

            public /* synthetic */ AbstractIndex kafka$log$AbstractIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean deleteIfExists() {
        this.closeHandler();
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
        this.closeHandler();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset2) {
        Option<Object> relativeOffset = this.toRelative(offset2);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integer overflow for offset: ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.file().getAbsoluteFile()})));
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset2) {
        return this.toRelative(offset2).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable throwable) {
            AbstractIndex$.MODULE$.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIndex $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unmapping index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
            return;
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (OperatingSystem.IS_WINDOWS) {
            lock2.lock();
        }
        try {
            return (T)fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            }
            return n;
        }
        throw new MatchError((Object)value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset2) {
        long relativeOffset = offset2 - this.baseOffset();
        return relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, Enumeration.Value searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this.kafka$log$AbstractIndex$$_length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.kafka$log$AbstractIndex$$_length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.kafka$log$AbstractIndex$$_length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            }, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var7_6;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

