/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcher;
import kafka.tools.ReplicaVerificationTool$$anonfun$3$;
import kafka.tools.TopicPartitionReplica;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ToolsUtils$;
import kafka.utils.Whitelist;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ReplicaVerificationTool$
implements Logging {
    public static final ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    private Logger logger$lzycompute() {
        ReplicaVerificationTool$ replicaVerificationTool$ = this;
        synchronized (replicaVerificationTool$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(Time.SYSTEM.milliseconds()));
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        Tuple2 tuple2;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(30000L), (Object[])new Long[0]);
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print usage information.").forHelp();
        AbstractOptionSpec versionOpt = parser.accepts("version", "Print version information and exit.").forHelp();
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has((OptionSpec)helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        if (options.has((OptionSpec)versionOpt)) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = (String)options.valueOf((OptionSpec)topicWhiteListOpt);
        Whitelist topicWhiteListFiler = new Whitelist(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            void var12_12;
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is an invalid regex."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_12})));
        }
        int fetchSize = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        long initialOffsetTime = (Long)options.valueOf((OptionSpec)initialOffsetTimeOpt);
        long reportInterval = (Long)options.valueOf((OptionSpec)reportIntervalOpt);
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Getting topic metadata...";
            }
        });
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        AdminClient adminClient = this.createAdminClient(brokerList);
        try {
            tuple2 = new Tuple2(this.listTopicsMetadata(adminClient), this.brokerDetails(adminClient));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(adminClient){
                public static final long serialVersionUID = 0L;
                private final AdminClient adminClient$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.adminClient$1.close();
                }
                {
                    this.adminClient$1 = adminClient$1;
                }
            }, this, CoreUtils$.MODULE$.swallow$default$3());
        }
        catch (Throwable throwable) {
            void var23_19;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, this, CoreUtils$.MODULE$.swallow$default$3());
            throw throwable;
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            Tuple2 tuple23;
            Seq topicsMetadata = (Seq)tuple22._1();
            scala.collection.immutable.Map brokerInfo = (scala.collection.immutable.Map)tuple22._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)topicsMetadata, (Object)brokerInfo);
            Seq topicsMetadata2 = (Seq)tuple24._1();
            scala.collection.immutable.Map brokerInfo2 = (scala.collection.immutable.Map)tuple24._2();
            Seq filteredTopicMetadata = (Seq)topicsMetadata2.filter((Function1)new Serializable(topicWhiteListFiler){
                public static final long serialVersionUID = 0L;
                private final Whitelist topicWhiteListFiler$1;

                public final boolean apply(TopicDescription topicMetaData) {
                    return this.topicWhiteListFiler$1.isTopicAllowed(topicMetaData.name(), false);
                }
                {
                    this.topicWhiteListFiler$1 = topicWhiteListFiler$1;
                }
            });
            if (filteredTopicMetadata.isEmpty()) {
                this.error((Function0<String>)new Serializable(topicWhiteListOpt){
                    public static final long serialVersionUID = 0L;
                    private final ArgumentAcceptingOptionSpec topicWhiteListOpt$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No topics found. ", " if specified, is either filtering out all topics or there is no topic."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicWhiteListOpt$1}));
                    }
                    {
                        this.topicWhiteListOpt$1 = topicWhiteListOpt$1;
                    }
                });
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            Seq topicPartitionReplicas = (Seq)filteredTopicMetadata.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Buffer<TopicPartitionReplica> apply(TopicDescription topicMetadata) {
                    return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitions()).asScala()).flatMap((Function1)new Serializable(this, topicMetadata){
                        public static final long serialVersionUID = 0L;
                        public final TopicDescription topicMetadata$1;

                        public final Buffer<TopicPartitionReplica> apply(TopicPartitionInfo partitionMetadata) {
                            return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this, partitionMetadata){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$3$$anonfun$apply$1 $outer;
                                private final TopicPartitionInfo partitionMetadata$1;

                                public final TopicPartitionReplica apply(Node node2) {
                                    return new TopicPartitionReplica(this.$outer.topicMetadata$1.name(), this.partitionMetadata$1.partition(), node2.id());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.partitionMetadata$1 = partitionMetadata$1;
                                }
                            }, Buffer$.MODULE$.canBuildFrom());
                        }
                        {
                            this.topicMetadata$1 = topicMetadata$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(topicPartitionReplicas){
                public static final long serialVersionUID = 0L;
                private final Seq topicPartitionReplicas$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Selected topic partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartitionReplicas$1}));
                }
                {
                    this.topicPartitionReplicas$1 = topicPartitionReplicas$1;
                }
            });
            scala.collection.immutable.Map brokerToTopicPartitions = (scala.collection.immutable.Map)topicPartitionReplicas.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(TopicPartitionReplica x$2) {
                    return x$2.replicaId();
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Seq<TopicPartition>> apply(Tuple2<Object, Seq<TopicPartitionReplica>> x0$1) {
                    Tuple2<Object, Seq<TopicPartitionReplica>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int brokerId = tuple2._1$mcI$sp();
                        Seq partitions = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), partitions.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TopicPartition apply(TopicPartitionReplica partition) {
                                return new TopicPartition(partition.topic(), partition.partitionId());
                            }
                        }, Seq$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(brokerToTopicPartitions){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map brokerToTopicPartitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic partitions per broker: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerToTopicPartitions$1}));
                }
                {
                    this.brokerToTopicPartitions$1 = brokerToTopicPartitions$1;
                }
            });
            scala.collection.immutable.Map expectedReplicasPerTopicPartition = (scala.collection.immutable.Map)topicPartitionReplicas.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TopicPartition apply(TopicPartitionReplica replica) {
                    return new TopicPartition(replica.topic(), replica.partitionId());
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Seq<TopicPartitionReplica>> x0$2) {
                    Tuple2<TopicPartition, Seq<TopicPartitionReplica>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition topicAndPartition = (TopicPartition)tuple2._1();
                        Seq replicaSet = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)BoxesRunTime.boxToInteger((int)replicaSet.size()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(expectedReplicasPerTopicPartition){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map expectedReplicasPerTopicPartition$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replicas per topic partition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expectedReplicasPerTopicPartition$1}));
                }
                {
                    this.expectedReplicasPerTopicPartition$1 = expectedReplicasPerTopicPartition$1;
                }
            });
            Seq topicPartitions = (Seq)filteredTopicMetadata.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Buffer<TopicPartition> apply(TopicDescription topicMetaData) {
                    return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetaData.partitions()).asScala()).map((Function1)new Serializable(this, topicMetaData){
                        public static final long serialVersionUID = 0L;
                        private final TopicDescription topicMetaData$1;

                        public final TopicPartition apply(TopicPartitionInfo partitionMetadata) {
                            return new TopicPartition(this.topicMetaData$1.name(), partitionMetadata.partition());
                        }
                        {
                            this.topicMetaData$1 = topicMetaData$1;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                }
            }, Seq$.MODULE$.canBuildFrom());
            Properties consumerProps = this.consumerConfig(brokerList);
            ReplicaBuffer replicaBuffer = new ReplicaBuffer((scala.collection.immutable.Map<TopicPartition, Object>)expectedReplicasPerTopicPartition, this.initialOffsets((Seq<TopicPartition>)topicPartitions, consumerProps, initialOffsetTime), brokerToTopicPartitions.size(), reportInterval);
            int verificationBrokerId = ((Tuple2)brokerToTopicPartitions.head())._1$mcI$sp();
            AtomicInteger counter = new AtomicInteger(0);
            scala.collection.immutable.Iterable fetcherThreads = (scala.collection.immutable.Iterable)brokerToTopicPartitions.map((Function1)new Serializable(fetchSize, maxWaitMs, brokerInfo2, consumerProps, replicaBuffer, verificationBrokerId, counter){
                public static final long serialVersionUID = 0L;
                private final int fetchSize$1;
                private final int maxWaitMs$1;
                private final scala.collection.immutable.Map brokerInfo$1;
                private final Properties consumerProps$1;
                private final ReplicaBuffer replicaBuffer$1;
                private final int verificationBrokerId$1;
                private final AtomicInteger counter$1;

                public final ReplicaFetcher apply(Tuple2<Object, Seq<TopicPartition>> x0$3) {
                    Tuple2<Object, Seq<TopicPartition>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int brokerId = tuple2._1$mcI$sp();
                        Seq topicPartitions = (Seq)tuple2._2();
                        ReplicaFetcher replicaFetcher = new ReplicaFetcher(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ReplicaFetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})), (Node)this.brokerInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Iterable<TopicPartition>)topicPartitions, this.replicaBuffer$1, 30000, 256000, this.fetchSize$1, this.maxWaitMs$1, 1, brokerId == this.verificationBrokerId$1, this.consumerProps$1, this.counter$1.incrementAndGet());
                        return replicaFetcher;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fetchSize$1 = fetchSize$1;
                    this.maxWaitMs$1 = maxWaitMs$1;
                    this.brokerInfo$1 = brokerInfo$1;
                    this.consumerProps$1 = consumerProps$1;
                    this.replicaBuffer$1 = replicaBuffer$1;
                    this.verificationBrokerId$1 = verificationBrokerId$1;
                    this.counter$1 = counter$1;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            Runtime.getRuntime().addShutdownHook(new Thread(fetcherThreads){
                private final scala.collection.immutable.Iterable fetcherThreads$1;

                public void run() {
                    ReplicaVerificationTool$.MODULE$.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Stopping all fetchers";
                        }
                    });
                    this.fetcherThreads$1.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ReplicaFetcher x$3) {
                            x$3.shutdown();
                        }
                    });
                }
                {
                    this.fetcherThreads$1 = fetcherThreads$1;
                }
            });
            fetcherThreads.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ReplicaFetcher x$4) {
                    x$4.start();
                }
            });
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": verification process is started."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCurrentTimeString()})));
            return;
        }
        throw new MatchError((Object)tuple22);
    }

    private Seq<TopicDescription> listTopicsMetadata(AdminClient adminClient) {
        Set topics = (Set)adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get();
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((java.util.Map)adminClient.describeTopics((Collection)topics).all().get()).values()).asScala()).toBuffer();
    }

    private scala.collection.immutable.Map<Object, Node> brokerDetails(AdminClient adminClient) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster().nodes().get()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Node> apply(Node n) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)n.id()), (Object)n);
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private AdminClient createAdminClient(String brokerUrl) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerUrl);
        return AdminClient.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<TopicPartition, Object> initialOffsets(Seq<TopicPartition> topicPartitions, Properties consumerConfig, long initialOffsetTime) {
        scala.collection.immutable.Map map;
        KafkaConsumer<String, String> consumer;
        block4: {
            consumer = this.createConsumer(consumerConfig);
            try {
                if (-1L == initialOffsetTime) {
                    map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).mapValues((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Long x$5) {
                            return x$5;
                        }
                    }).toMap(Predef$.MODULE$.$conforms());
                    break block4;
                }
                if (-2L == initialOffsetTime) {
                    map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).mapValues((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Long x$6) {
                            return x$6;
                        }
                    }).toMap(Predef$.MODULE$.$conforms());
                    break block4;
                }
                scala.collection.immutable.Map timestampsToSearch = ((TraversableOnce)topicPartitions.map((Function1)new Serializable(initialOffsetTime){
                    public static final long serialVersionUID = 0L;
                    private final long initialOffsetTime$1;

                    public final Tuple2<TopicPartition, Long> apply(TopicPartition tp) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Predef$.MODULE$.long2Long(this.initialOffsetTime$1));
                    }
                    {
                        this.initialOffsetTime$1 = initialOffsetTime$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)timestampsToSearch).asJava())).asScala()).mapValues((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final long apply(OffsetAndTimestamp v) {
                        return v.offset();
                    }
                }).toMap(Predef$.MODULE$.$conforms());
            }
            catch (Throwable throwable) {
                void var5_4;
                var5_4.close();
                throw throwable;
            }
        }
        consumer.close();
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Properties consumerConfig(String brokerUrl) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerUrl);
        properties.put("group.id", "ReplicaVerification");
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        return var2_2;
    }

    private KafkaConsumer<String, String> createConsumer(Properties consumerConfig) {
        return new KafkaConsumer(consumerConfig);
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

