/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Iterator;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011)\u0019!C\u0001!\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t7\u0001A\u000b\u0002#A\u0011!CG\u0007\u0002')\u0011A#F\u0001\u0007G>lWn\u001c8\u000b\u0005\u00151\"BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001eL!aG\n\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"AQ\u0004\u0001B\u0001B\u0003%\u0011#A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011!y\u0002A!b\u0001\n\u0003\u0001\u0013A\u00039s_\u0012,8-\u001a:JIV\t\u0011\u0005\u0005\u0002\tE%\u00111%\u0003\u0002\u0005\u0019>tw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\"\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u001d\u0002!Q1A\u0005\u0002!\nAbY;se\u0016tG/\u00128uef,\u0012!\u000b\t\u0003U-j\u0011AA\u0005\u0003Y\t\u0011!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ss\"Aa\u0006\u0001B\u0001B\u0003%\u0011&A\u0007dkJ\u0014XM\u001c;F]R\u0014\u0018\u0010\t\u0005\ta\u0001\u0011)\u0019!C\u0001c\u0005qa/\u00197jI\u0006$\u0018n\u001c8UsB,W#\u0001\u001a\u0011\u0005)\u001a\u0014B\u0001\u001b\u0003\u000591\u0016\r\\5eCRLwN\u001c+za\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0010m\u0006d\u0017\u000eZ1uS>tG+\u001f9fA!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"RAO\u001e={y\u0002\"A\u000b\u0001\t\u000b99\u0004\u0019A\t\t\u000b}9\u0004\u0019A\u0011\t\u000b\u001d:\u0004\u0019A\u0015\t\u000bA:\u0004\u0019\u0001\u001a\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\u0006aAO]1og\u0006\u001cG/[8ogV\t!\tE\u0002D\u0011*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bq!\\;uC\ndWM\u0003\u0002H\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005%#%A\u0003'jgR\u0014UO\u001a4feB\u0011!fS\u0005\u0003\u0019\n\u00111\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\"1a\n\u0001Q\u0001\n\t\u000bQ\u0002\u001e:b]N\f7\r^5p]N\u0004\u0003b\u0002)\u0001\u0005\u0004%I\u0001K\u0001\rkB$\u0017\r^3e\u000b:$(/\u001f\u0005\u0007%\u0002\u0001\u000b\u0011B\u0015\u0002\u001bU\u0004H-\u0019;fI\u0016sGO]=!\u0011\u0015!\u0006\u0001\"\u0003V\u0003Mi\u0017-\u001f2f-\u0006d\u0017\u000eZ1uK\u0006\u0003\b/\u001a8e)\u00111\u0016LX2\u0011\u0005!9\u0016B\u0001-\n\u0005\u0011)f.\u001b;\t\u000bi\u001b\u0006\u0019A.\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\tAA,\u0003\u0002^\u0013\t)1\u000b[8si\")ql\u0015a\u0001A\u0006Aa-\u001b:tiN+\u0017\u000f\u0005\u0002\tC&\u0011!-\u0003\u0002\u0004\u0013:$\b\"\u00023T\u0001\u0004\t\u0013AB8gMN,G\u000fC\u0003g\u0001\u0011%q-\u0001\ndQ\u0016\u001c7\u000e\u0015:pIV\u001cWM]#q_\u000eDGc\u0001,iS\")!,\u001aa\u00017\")A-\u001aa\u0001C!)1\u000e\u0001C\u0005Y\u0006i1\r[3dWN+\u0017/^3oG\u0016$BAV7oa\")!L\u001ba\u00017\")qN\u001ba\u0001A\u0006q\u0011\r\u001d9f]\u00124\u0015N]:u'\u0016\f\b\"\u00023k\u0001\u0004\t\u0003\"\u0002:\u0001\t\u0013\u0019\u0018AC5o'\u0016\fX/\u001a8dKR\u0019Ao^=\u0011\u0005!)\u0018B\u0001<\n\u0005\u001d\u0011un\u001c7fC:DQ\u0001_9A\u0002\u0001\fq\u0001\\1tiN+\u0017\u000fC\u0003{c\u0002\u0007\u0001-A\u0004oKb$8+Z9\t\u000bq\u0004A\u0011A?\u0002\r\u0005\u0004\b/\u001a8e)\u0015q\u0018\u0011BA\r!\u0011Aq0a\u0001\n\u0007\u0005\u0005\u0011B\u0001\u0004PaRLwN\u001c\t\u0004U\u0005\u0015\u0011bAA\u0004\u0005\ta1i\\7qY\u0016$X\r\u001a+y]\"9\u00111B>A\u0002\u00055\u0011!\u00022bi\u000eD\u0007\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M1#\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003/\t\tBA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007bBA\u000ew\u0002\u0007\u0011QD\u0001\u0017M&\u00148\u000f^(gMN,G/T3uC\u0012\fG/Y(qiB!\u0001b`A\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013\t\u000511/\u001a:wKJLA!!\u000b\u0002$\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\rq\u0004A\u0011AA\u0017)=1\u0016qFA\u001a\u0003k\t9$a\u000f\u0002@\u0005\r\u0003bBA\u0019\u0003W\u0001\raW\u0001\u0006KB|7\r\u001b\u0005\u0007?\u0006-\u0002\u0019\u00011\t\ra\fY\u00031\u0001a\u0011\u001d\tI$a\u000bA\u0002\u0005\nQ\u0002\\1tiRKW.Z:uC6\u0004\b\u0002CA\u001f\u0003W\u0001\r!a\b\u0002'\u0019L'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\u000f\u0005\u0005\u00131\u0006a\u0001C\u0005QA.Y:u\u001f\u001a47/\u001a;\t\u000f\u0005\u0015\u00131\u0006a\u0001i\u0006y\u0011n\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eC\u0004\u0002J\u0001!\t!a\u0013\u0002%\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u000b\u000b\u0003\u0007\ti%a\u0016\u0002Z\u0005m\u0003\u0002CA(\u0003\u000f\u0002\r!!\u0015\u0002\u0019\u0015tG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0011\t\u0005=\u00111K\u0005\u0005\u0003+\n\tB\u0001\u000bF]\u0012$&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM\u001d\u0005\u00075\u0006\u001d\u0003\u0019A.\t\r\u0011\f9\u00051\u0001\"\u0011\u001d\ti&a\u0012A\u0002\u0005\n\u0011\u0002^5nKN$\u0018-\u001c9\t\r\u0005\u0005\u0004\u0001\"\u0001)\u0003\u001d!x.\u00128uefDq!!\u001a\u0001\t\u0003\t9'A\nti\u0006\u0014H/\u001a3Ue\u0006t7/Y2uS>t7/\u0006\u0002\u0002jA)\u00111NA>\u0015:!\u0011QNA<\u001d\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:\u001f\u00051AH]8pizJ\u0011AC\u0005\u0004\u0003sJ\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyH\u0001\u0003MSN$(bAA=\u0013!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0005\u0003BAE\u0003\u001fs1\u0001CAF\u0013\r\ti)C\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\u0015\u0002")
public class ProducerAppendInfo {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq, long offset2) {
        ValidationType validationType;
        block5: {
            block3: {
                block4: {
                    block2: {
                        validationType = this.validationType();
                        if (!ValidationType$None$.MODULE$.equals(validationType)) break block2;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!ValidationType$EpochOnly$.MODULE$.equals(validationType)) break block4;
                    this.checkProducerEpoch(producerEpoch, offset2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!ValidationType$Full$.MODULE$.equals(validationType)) break block5;
                this.checkProducerEpoch(producerEpoch, offset2);
                this.checkSequence(producerEpoch, firstSeq, offset2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)validationType);
    }

    private void checkProducerEpoch(short producerEpoch, long offset2) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            throw new ProducerFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer's epoch at offset ", " is no longer valid in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", ": ", " (request epoch), ", " (current epoch)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.updatedEntry().producerEpoch())}))).toString());
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset2) {
        int currentLastSeq;
        block9: {
            block8: {
                block7: {
                    if (producerEpoch == this.updatedEntry().producerEpoch()) break block7;
                    if (appendFirstSeq != 0) {
                        if (this.updatedEntry().producerEpoch() != -1) {
                            throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number for new epoch at offset ", " in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", ": ", " (request epoch), ", " (seq. number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).toString());
                        }
                        throw new UnknownProducerIdException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found no record of producerId=", " on the broker at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToLong((long)offset2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in partition ", ". It is possible that the last message with the producerId=", " has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)"been removed due to hitting the retention limit.").toString());
                    }
                    break block8;
                }
                int n = this.updatedEntry().isEmpty() ? (producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1) : (currentLastSeq = this.updatedEntry().lastSeq());
                if (currentLastSeq == -1 && appendFirstSeq != 0) {
                    throw new UnknownProducerIdException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local producer state matches expected epoch ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for producerId=", " at offset ", " in partition ", ", but the next expected "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToLong((long)offset2), this.topicPartition()}))).append((Object)"sequence number is not known.").toString());
                }
                if (!this.inSequence(currentLastSeq, appendFirstSeq)) break block9;
            }
            return;
        }
        throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ": ", " (incoming seq. number), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.topicPartition(), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (current end sequence number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentLastSeq)}))).toString());
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch, Option<LogOffsetMetadata> firstOffsetMetadataOpt) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record2 = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record2);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record2.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            LogOffsetMetadata firstOffsetMetadata = (LogOffsetMetadata)firstOffsetMetadataOpt.getOrElse((Function0)new Serializable(this, batch){
                public static final long serialVersionUID = 0L;
                private final RecordBatch batch$1;

                public final LogOffsetMetadata apply() {
                    return new LogOffsetMetadata(this.batch$1.baseOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
                }
                {
                    this.batch$1 = batch$1;
                }
            });
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), firstOffsetMetadata, batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, LogOffsetMetadata firstOffsetMetadata, long lastOffset, boolean isTransactional) {
        long firstOffset = firstOffsetMetadata.messageOffset();
        this.maybeValidateAppend(epoch, firstSeq, firstOffset);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected transactional write from producer ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstOffsetMetadata, this.topicPartition()}))).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffsetMetadata, TxnMetadata$.MODULE$.apply$default$3()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset2, long timestamp) {
        Option<Object> option;
        block6: {
            long l;
            block5: {
                block4: {
                    long txnFirstOffset;
                    this.checkProducerEpoch(producerEpoch, offset2);
                    if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
                        throw new TransactionCoordinatorFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid coordinator epoch for producerId ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.topicPartition(), BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(zombie), ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().coordinatorEpoch())}))).toString());
                    }
                    this.updatedEntry().maybeUpdateEpoch(producerEpoch);
                    option = this.updatedEntry().currentTxnFirstOffset();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.x());
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset2));
                l = offset2;
            }
            long firstOffset = l;
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
            this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
            ControlRecordType controlRecordType = endTxnMarker.controlType();
            ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
            return new CompletedTxn(this.producerId(), firstOffset, offset2, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
        }
        throw new MatchError(option);
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public String toString() {
        return new StringBuilder().append((Object)"ProducerAppendInfo(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.updatedEntry().producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().firstSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().lastSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updatedEntry().currentTxnFirstOffset()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startedTransactions=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactions()}))).toString();
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, ValidationType validationType) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

