/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.PasswordEncoder$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015x!B\u0001\u0003\u0011\u00039\u0011a\u0004)bgN<xN\u001d3F]\u000e|G-\u001a:\u000b\u0005\r!\u0011!B;uS2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\ty\u0001+Y:to>\u0014H-\u00128d_\u0012,'o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000fYI!\u0019!C\u0001/\u000592*Z=GC\u000e$xN]=BY\u001e|'/\u001b;i[B\u0013x\u000e]\u000b\u00021A\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB*ue&tw\r\u0003\u0004\"\u0013\u0001\u0006I\u0001G\u0001\u0019\u0017\u0016Lh)Y2u_JL\u0018\t\\4pe&$\b.\u001c)s_B\u0004\u0003bB\u0012\n\u0005\u0004%\taF\u0001\u0014\u0007&\u0004\b.\u001a:BY\u001e|'/\u001b;i[B\u0013x\u000e\u001d\u0005\u0007K%\u0001\u000b\u0011\u0002\r\u0002)\rK\u0007\u000f[3s\u00032<wN]5uQ6\u0004&o\u001c9!\u0011\u001d9\u0013B1A\u0005\u0002]\t\u0001$\u00138ji&\fG.\u001b>bi&|gNV3di>\u0014\bK]8q\u0011\u0019I\u0013\u0002)A\u00051\u0005I\u0012J\\5uS\u0006d\u0017N_1uS>tg+Z2u_J\u0004&o\u001c9!\u0011\u001dY\u0013B1A\u0005\u0002]\tQbS3z\u0019\u0016tw\r\u001e5Qe>\u0004\bBB\u0017\nA\u0003%\u0001$\u0001\bLKfdUM\\4uQB\u0013x\u000e\u001d\u0011\t\u000f=J!\u0019!C\u0001/\u0005A1+\u00197u!J|\u0007\u000f\u0003\u00042\u0013\u0001\u0006I\u0001G\u0001\n'\u0006dG\u000f\u0015:pa\u0002BqaM\u0005C\u0002\u0013\u0005q#\u0001\bJi\u0016\u0014\u0018\r^5p]N\u0004&o\u001c9\t\rUJ\u0001\u0015!\u0003\u0019\u0003=IE/\u001a:bi&|gn\u001d)s_B\u0004\u0003bB\u001c\n\u0005\u0004%\taF\u0001\u0016\u000b:\u001c\u0017P\u001d9uK\u0012\u0004\u0016m]:x_J$\u0007K]8q\u0011\u0019I\u0014\u0002)A\u00051\u00051RI\\2zeB$X\r\u001a)bgN<xN\u001d3Qe>\u0004\b\u0005C\u0004<\u0013\t\u0007I\u0011A\f\u0002%A\u000b7o]<pe\u0012dUM\\4uQB\u0013x\u000e\u001d\u0005\u0007{%\u0001\u000b\u0011\u0002\r\u0002'A\u000b7o]<pe\u0012dUM\\4uQB\u0013x\u000e\u001d\u0011\u0007\t)\u0011\u0001aP\n\u0004}1\u0001\u0005C\u0001\u0005B\u0013\t\u0011%AA\u0004M_\u001e<\u0017N\\4\t\u0011\u0011s$\u0011!Q\u0001\n\u0015\u000baa]3de\u0016$\bC\u0001$S\u001b\u00059%B\u0001%J\u0003\u0015!\u0018\u0010]3t\u0015\tQ5*\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u00196\u000baaY8n[>t'BA\u0003O\u0015\ty\u0005+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0006\u0019qN]4\n\u0005M;%\u0001\u0003)bgN<xN\u001d3\t\u0011Us$\u0011!Q\u0001\nY\u000b1c[3z\r\u0006\u001cGo\u001c:z\u00032<wN]5uQ6\u00042!D,Z\u0013\tAfB\u0001\u0004PaRLwN\u001c\t\u00035vs!!D.\n\u0005qs\u0011A\u0002)sK\u0012,g-\u0003\u0002 =*\u0011AL\u0004\u0005\tAz\u0012\t\u0011)A\u00053\u0006y1-\u001b9iKJ\fEnZ8sSRDW\u000e\u0003\u0005c}\t\u0005\t\u0015!\u0003d\u0003%YW-\u001f'f]\u001e$\b\u000e\u0005\u0002\u000eI&\u0011QM\u0004\u0002\u0004\u0013:$\b\u0002C4?\u0005\u0003\u0005\u000b\u0011B2\u0002\u0015%$XM]1uS>t7\u000fC\u0003\u0014}\u0011\u0005\u0011\u000e\u0006\u0004kW2lgn\u001c\t\u0003\u0011yBQ\u0001\u00125A\u0002\u0015CQ!\u00165A\u0002YCQ\u0001\u00195A\u0002eCQA\u00195A\u0002\rDQa\u001a5A\u0002\rDq!\u001d C\u0002\u0013%!/\u0001\u0007tK\u000e,(/\u001a*b]\u0012|W.F\u0001t!\t!x/D\u0001v\u0015\t1H$\u0001\u0005tK\u000e,(/\u001b;z\u0013\tAXO\u0001\u0007TK\u000e,(/\u001a*b]\u0012|W\u000e\u0003\u0004{}\u0001\u0006Ia]\u0001\u000eg\u0016\u001cWO]3SC:$w.\u001c\u0011\t\u000fqt$\u0019!C\u0005{\u0006\u00192-\u001b9iKJ\u0004\u0016M]1ng\u0016s7m\u001c3feV\ta\u0010E\u0002\u0000\u0003\u0003i\u0011A\u0010\u0004\n\u0003\u0007q\u0004\u0013aI\u0005\u0003\u000b\u00111cQ5qQ\u0016\u0014\b+\u0019:b[N,enY8eKJ\u001c2!!\u0001\r\u0011!\tI!!\u0001\u0007\u0002\u0005-\u0011!\u0002;p\u001b\u0006\u0004H\u0003BA\u0007\u00033\u0001b!a\u0004\u0002\u0016eKVBAA\t\u0015\r\t\u0019BD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\f\u0003#\u00111!T1q\u0011!\tY\"a\u0002A\u0002\u0005u\u0011AB2ja\",'\u000fE\u0002u\u0003?I1!!\tv\u0005M\tEnZ8sSRDW\u000eU1sC6,G/\u001a:t\u0011!\t)#!\u0001\u0007\u0002\u0005\u001d\u0012a\u0004;p!\u0006\u0014\u0018-\\3uKJ\u001c\u0006/Z2\u0015\t\u0005%\u0012Q\u0007\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF;\u0002\tM\u0004XmY\u0005\u0005\u0003g\tiC\u0001\fBY\u001e|'/\u001b;i[B\u000b'/Y7fi\u0016\u00148\u000b]3d\u0011!\t9$a\tA\u0002\u00055\u0011\u0001\u00039be\u0006lW*\u00199\t\u000f\u0005mb\b)A\u0005}\u0006!2-\u001b9iKJ\u0004\u0016M]1ng\u0016s7m\u001c3fe\u0002Bq!a\u0010?\t\u0003\t\t%\u0001\u0004f]\u000e|G-\u001a\u000b\u00043\u0006\r\u0003bBA#\u0003{\u0001\r!R\u0001\ta\u0006\u001c8o^8sI\"9\u0011\u0011\n \u0005\u0002\u0005-\u0013A\u00023fG>$W\rF\u0002F\u0003\u001bBq!a\u0014\u0002H\u0001\u0007\u0011,A\bf]\u000e|G-\u001a3QCN\u001cxo\u001c:e\u0011\u001d\t\u0019F\u0010C\u0005\u0003+\n\u0001c]3de\u0016$8*Z=GC\u000e$xN]=\u0015\t\u0005]\u0013q\r\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0019\u0019'/\u001f9u_*\u0011\u0011\u0011M\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003K\nYF\u0001\tTK\u000e\u0014X\r^&fs\u001a\u000b7\r^8ss\"9\u0011\u0011NA)\u0001\u00041\u0016!D6fs\u001a\u000b7\r^8ss\u0006cw\rC\u0004\u0002ny\"I!a\u001c\u0002\u001bM,7M]3u\u0017\u0016L8\u000b]3d)1\t\t(a\u001f\u0002\u0000\u0005\r\u0015QQAK!\u0011\t\u0019(a\u001e\u000e\u0005\u0005U$\u0002BA\u0018\u00037JA!!\u001f\u0002v\ti1+Z2sKR\\U-_*qK\u000eD\u0001\"! \u0002l\u0001\u0007\u0011qK\u0001\u000bW\u0016Lh)Y2u_JL\bbBAA\u0003W\u0002\r!W\u0001\nG&\u0004\b.\u001a:BY\u001eDaAYA6\u0001\u0004\u0019\u0007\u0002CAD\u0003W\u0002\r!!#\u0002\tM\fG\u000e\u001e\t\u0006\u001b\u0005-\u0015qR\u0005\u0004\u0003\u001bs!!B!se\u0006L\bcA\u0007\u0002\u0012&\u0019\u00111\u0013\b\u0003\t\tKH/\u001a\u0005\u0007O\u0006-\u0004\u0019A2\t\u000f\u0005ee\b\"\u0003\u0002\u001c\u0006a!-Y:fmQ*enY8eKR\u0019\u0011,!(\t\u0011\u0005}\u0015q\u0013a\u0001\u0003\u0013\u000bQAY=uKND\u0001\"a)?\t\u0003\u0011\u0011QU\u0001\rE\u0006\u001cXM\u000e\u001bEK\u000e|G-\u001a\u000b\u0005\u0003\u0013\u000b9\u000bC\u0004\u0002*\u0006\u0005\u0006\u0019A-\u0002\u000f\u0015t7m\u001c3fI\"9\u0011Q\u0016 \u0005\n\u0005=\u0016\u0001F2ja\",'\u000fU1sC6\u001c\u0018J\\:uC:\u001cW\rF\u0002\u007f\u0003cCa\u0001YAV\u0001\u0004IfABA[}\u0011\t9LA\bJmB\u000b'/Y7t\u000b:\u001cw\u000eZ3s'\u0011\t\u0019\f\u0004@\t\u000fM\t\u0019\f\"\u0001\u0002<R\u0011\u0011Q\u0018\t\u0004\u007f\u0006M\u0006\u0002CA\u0005\u0003g#\t!!1\u0015\t\u00055\u00111\u0019\u0005\t\u0003\u000b\fy\f1\u0001\u0002\u001e\u0005a1-\u001b9iKJ\u0004\u0016M]1ng\"A\u0011QEAZ\t\u0003\tI\r\u0006\u0003\u0002*\u0005-\u0007\u0002CA\u001c\u0003\u000f\u0004\r!!\u0004\u0007\r\u0005=g\bBAi\u0005A95-\u001c)be\u0006l7/\u00128d_\u0012,'o\u0005\u0003\u0002N2q\bbB\n\u0002N\u0012\u0005\u0011Q\u001b\u000b\u0003\u0003/\u00042a`Ag\u0011!\tI!!4\u0005\u0002\u0005mG\u0003BA\u0007\u0003;D\u0001\"!2\u0002Z\u0002\u0007\u0011Q\u0004\u0005\t\u0003K\ti\r\"\u0001\u0002bR!\u0011\u0011FAr\u0011!\t9$a8A\u0002\u00055\u0001")
public class PasswordEncoder
implements Logging {
    private final Password secret;
    private final Option<String> keyFactoryAlgorithm;
    private final String cipherAlgorithm;
    private final int keyLength;
    private final int iterations;
    private final SecureRandom secureRandom;
    private final CipherParamsEncoder cipherParamsEncoder;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String PasswordLengthProp() {
        return PasswordEncoder$.MODULE$.PasswordLengthProp();
    }

    public static String EncyrptedPasswordProp() {
        return PasswordEncoder$.MODULE$.EncyrptedPasswordProp();
    }

    public static String IterationsProp() {
        return PasswordEncoder$.MODULE$.IterationsProp();
    }

    public static String SaltProp() {
        return PasswordEncoder$.MODULE$.SaltProp();
    }

    public static String KeyLengthProp() {
        return PasswordEncoder$.MODULE$.KeyLengthProp();
    }

    public static String InitializationVectorProp() {
        return PasswordEncoder$.MODULE$.InitializationVectorProp();
    }

    public static String CipherAlgorithmProp() {
        return PasswordEncoder$.MODULE$.CipherAlgorithmProp();
    }

    public static String KeyFactoryAlgorithmProp() {
        return PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp();
    }

    private Logger logger$lzycompute() {
        PasswordEncoder passwordEncoder2 = this;
        synchronized (passwordEncoder2) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private SecureRandom secureRandom() {
        return this.secureRandom;
    }

    private CipherParamsEncoder cipherParamsEncoder() {
        return this.cipherParamsEncoder;
    }

    public String encode(Password password) {
        byte[] salt = new byte[256];
        this.secureRandom().nextBytes(salt);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        SecretKeyFactory keyFactory = this.secretKeyFactory(this.keyFactoryAlgorithm);
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, this.cipherAlgorithm, this.keyLength, salt, this.iterations);
        cipher.init(1, keySpec);
        byte[] encryptedPassword = cipher.doFinal(password.value().getBytes(StandardCharsets.UTF_8));
        Map encryptedMap = ((MapLike)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()), (Object)keyFactory.getAlgorithm()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()), (Object)this.cipherAlgorithm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.KeyLengthProp()), (Object)BoxesRunTime.boxToInteger((int)this.keyLength)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.SaltProp()), (Object)this.kafka$utils$PasswordEncoder$$base64Encode(salt)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.IterationsProp()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.iterations)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp()), (Object)this.kafka$utils$PasswordEncoder$$base64Encode(encryptedPassword)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()), (Object)BoxesRunTime.boxToInteger((int)password.value().length()))}))).$plus$plus(this.cipherParamsEncoder().toMap(cipher.getParameters()));
        return ((TraversableOnce)encryptedMap.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Password decode(String encodedPassword) {
        String password;
        block2: {
            Map<String, String> params = CoreUtils$.MODULE$.parseCsvMap(encodedPassword);
            String keyFactoryAlg = (String)params.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp());
            String cipherAlg = (String)params.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp());
            int keyLength = new StringOps(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()))).toInt();
            byte[] salt = this.base64Decode((String)params.apply((Object)PasswordEncoder$.MODULE$.SaltProp()));
            int iterations = new StringOps(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()))).toInt();
            byte[] encryptedPassword = this.base64Decode((String)params.apply((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp()));
            int passwordLengthProp = new StringOps(Predef$.MODULE$.augmentString((String)params.apply((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()))).toInt();
            Cipher cipher = Cipher.getInstance(cipherAlg);
            SecretKeyFactory keyFactory = this.secretKeyFactory((Option<String>)new Some((Object)keyFactoryAlg));
            SecretKeySpec keySpec = this.secretKeySpec(keyFactory, cipherAlg, keyLength, salt, iterations);
            cipher.init(2, (Key)keySpec, this.cipherParamsEncoder().toParameterSpec(params));
            try {
                byte[] decrypted = cipher.doFinal(encryptedPassword);
                password = new String(decrypted, StandardCharsets.UTF_8);
                if (password.length() == passwordLengthProp) break block2;
            }
            catch (Exception exception) {
                throw new ConfigException("Password could not be decoded", (Object)exception);
            }
            throw new ConfigException("Password could not be decoded, sanity check of length failed");
        }
        return new Password(password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecretKeyFactory secretKeyFactory(Option<String> keyFactoryAlg) {
        SecretKeyFactory secretKeyFactory;
        Option<String> option = keyFactoryAlg;
        if (option instanceof Some) {
            Some some = (Some)option;
            String algorithm = (String)some.x();
            return SecretKeyFactory.getInstance(algorithm);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        try {
            secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            return secretKeyFactory;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        return secretKeyFactory;
    }

    private SecretKeySpec secretKeySpec(SecretKeyFactory keyFactory, String cipherAlg, int keyLength, byte[] salt, int iterations) {
        PBEKeySpec keySpec = new PBEKeySpec(this.secret.value().toCharArray(), salt, iterations, keyLength);
        String algorithm = cipherAlg.indexOf(47) > 0 ? cipherAlg.substring(0, cipherAlg.indexOf(47)) : cipherAlg;
        return new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), algorithm);
    }

    public String kafka$utils$PasswordEncoder$$base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public byte[] base64Decode(String encoded) {
        return Base64.getDecoder().decode(encoded);
    }

    private CipherParamsEncoder cipherParamsInstance(String cipherAlgorithm) {
        String string;
        String string2;
        Regex aesPattern = new StringOps(Predef$.MODULE$.augmentString("AES/(.*)/.*")).r();
        Option option = aesPattern.unapplySeq((CharSequence)(string2 = cipherAlgorithm));
        CipherParamsEncoder cipherParamsEncoder = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && "GCM".equals(string = (String)((LinearSeqOptimized)option.get()).apply(0)) ? new GcmParamsEncoder() : new IvParamsEncoder();
        return cipherParamsEncoder;
    }

    public PasswordEncoder(Password secret, Option<String> keyFactoryAlgorithm, String cipherAlgorithm, int keyLength, int iterations) {
        this.secret = secret;
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyLength = keyLength;
        this.iterations = iterations;
        Logging$class.$init$(this);
        this.secureRandom = new SecureRandom();
        this.cipherParamsEncoder = this.cipherParamsInstance(cipherAlgorithm);
    }

    public class IvParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams == null) {
                throw new IllegalStateException("Could not determine initialization vector for cipher");
            }
            IvParameterSpec ivSpec = cipherParams.getParameterSpec(IvParameterSpec.class);
            return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.InitializationVectorProp()), (Object)this.kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer().kafka$utils$PasswordEncoder$$base64Encode(ivSpec.getIV()))}));
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new IvParameterSpec(this.kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer().base64Decode((String)paramMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ PasswordEncoder kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer() {
            return PasswordEncoder.this;
        }

        public IvParamsEncoder() {
            if (PasswordEncoder.this == null) {
                throw null;
            }
        }
    }

    public class GcmParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams == null) {
                throw new IllegalStateException("Could not determine initialization vector for cipher");
            }
            GCMParameterSpec spec = cipherParams.getParameterSpec(GCMParameterSpec.class);
            return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PasswordEncoder$.MODULE$.InitializationVectorProp()), (Object)this.kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer().kafka$utils$PasswordEncoder$$base64Encode(spec.getIV())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"authenticationTagLength"), (Object)((Object)BoxesRunTime.boxToInteger((int)spec.getTLen())).toString())}));
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new GCMParameterSpec(new StringOps(Predef$.MODULE$.augmentString((String)paramMap.apply((Object)"authenticationTagLength"))).toInt(), this.kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer().base64Decode((String)paramMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ PasswordEncoder kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer() {
            return PasswordEncoder.this;
        }

        public GcmParamsEncoder() {
            if (PasswordEncoder.this == null) {
                throw null;
            }
        }
    }

    public interface CipherParamsEncoder {
        public Map<String, String> toMap(AlgorithmParameters var1);

        public AlgorithmParameterSpec toParameterSpec(Map<String, String> var1);
    }
}

