/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager$;
import kafka.server.DelegationTokenManager$TokenChangedNotificationHandler$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$class;
import kafka.zk.DelegationTokenChangeNotificationSequenceZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Time;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rUt!B\u0001\u0003\u0011\u00039\u0011A\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\u0002]\tA\u0003R3gCVdG\u000fS7bG\u0006cwm\u001c:ji\"lW#\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t11\u000b\u001e:j]\u001eDa!I\u0005!\u0002\u0013A\u0012!\u0006#fM\u0006,H\u000e\u001e%nC\u000e\fEnZ8sSRDW\u000e\t\u0005\bG%\u0011\r\u0011\"\u0001\u0018\u0003!yuO\\3s\u0017\u0016L\bBB\u0013\nA\u0003%\u0001$A\u0005Po:,'oS3zA!9q%\u0003b\u0001\n\u00039\u0012a\u0003*f]\u0016<XM]:LKfDa!K\u0005!\u0002\u0013A\u0012\u0001\u0004*f]\u0016<XM]:LKf\u0004\u0003bB\u0016\n\u0005\u0004%\taF\u0001\u0012\u0013N\u001cX/\u001a+j[\u0016\u001cH/Y7q\u0017\u0016L\bBB\u0017\nA\u0003%\u0001$\u0001\nJgN,X\rV5nKN$\u0018-\u001c9LKf\u0004\u0003bB\u0018\n\u0005\u0004%\taF\u0001\u0010\u001b\u0006DH+[7fgR\fW\u000e]&fs\"1\u0011'\u0003Q\u0001\na\t\u0001#T1y)&lWm\u001d;b[B\\U-\u001f\u0011\t\u000fMJ!\u0019!C\u0001/\u0005\u0011R\t\u001f9jef$\u0016.\\3ti\u0006l\u0007oS3z\u0011\u0019)\u0014\u0002)A\u00051\u0005\u0019R\t\u001f9jef$\u0016.\\3ti\u0006l\u0007oS3zA!9q'\u0003b\u0001\n\u00039\u0012A\u0003+pW\u0016t\u0017\nZ&fs\"1\u0011(\u0003Q\u0001\na\t1\u0002V8lK:LEmS3zA!91(\u0003b\u0001\n\u00039\u0012A\u0003,feNLwN\\&fs\"1Q(\u0003Q\u0001\na\t1BV3sg&|gnS3zA!9q(\u0003b\u0001\n\u0003\u0001\u0015AD\"veJ,g\u000e\u001e,feNLwN\\\u000b\u0002\u0003B\u0011QBQ\u0005\u0003\u0007:\u00111!\u00138u\u0011\u0019)\u0015\u0002)A\u0005\u0003\u0006y1)\u001e:sK:$h+\u001a:tS>t\u0007\u0005C\u0004H\u0013\t\u0007I\u0011\u0001!\u0002\u001d\u0015\u0013(o\u001c:US6,7\u000f^1na\"1\u0011*\u0003Q\u0001\n\u0005\u000bq\"\u0012:s_J$\u0016.\\3ti\u0006l\u0007\u000f\t\u0005\u0006\u0017&!\t\u0001T\u0001\u000bGJ,\u0017\r^3I[\u0006\u001cGcA'T7B\u0019QB\u0014)\n\u0005=s!!B!se\u0006L\bCA\u0007R\u0013\t\u0011fB\u0001\u0003CsR,\u0007\"\u0002+K\u0001\u0004)\u0016a\u0002;pW\u0016t\u0017\n\u001a\t\u0003-fs!!D,\n\u0005as\u0011A\u0002)sK\u0012,g-\u0003\u0002 5*\u0011\u0001L\u0004\u0005\u00069*\u0003\r!V\u0001\ng\u0016\u001c'/\u001a;LKfDQAX\u0005\u0005\u0002}\u000bqb\u0019:fCR,7+Z2sKR\\U-\u001f\u000b\u0003A\"\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\u0005)\u0017!\u00026bm\u0006D\u0018BA4c\u0005%\u0019Vm\u0019:fi.+\u0017\u0010C\u0003j;\u0002\u0007Q*\u0001\u0005lKf\u0014\u0017\u0010^3t\u0011\u0015Y\u0017\u0002\"\u0001m\u0003A\u0019'/Z1uK\n\u000b7/\u001a\u001c5\u00116\u000b5\tF\u0002V[:DQ\u0001\u00166A\u0002UCQ\u0001\u00186A\u0002\u0001DQaS\u0005\u0005\u0002A$2!T9s\u0011\u0015!v\u000e1\u0001V\u0011\u0015av\u000e1\u0001a\u0011\u0015!\u0018\u0002\"\u0001v\u0003M!xNS:p]\u000e{W\u000e]1uS\ndW-T1q)\t1H\u0010\u0005\u0003WoVK\u0018B\u0001=[\u0005\ri\u0015\r\u001d\t\u0003\u001biL!a\u001f\b\u0003\u0007\u0005s\u0017\u0010C\u0003~g\u0002\u0007a0A\u0003u_.,g\u000eE\u0002\u0000\u00033i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u000bI\u0016dWmZ1uS>t'bA?\u0002\b)!\u0011\u0011BA\u0006\u0003!\u0019XmY;sSRL(\u0002BA\u0007\u0003\u001f\taaY8n[>t'bA\u0003\u0002\u0012)!\u00111CA\u000b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qC\u0001\u0004_J<\u0017\u0002BA\u000e\u0003\u0003\u0011q\u0002R3mK\u001e\fG/[8o)>\\WM\u001c\u0005\b\u0003?IA\u0011AA\u0011\u0003%1'o\\7CsR,7\u000f\u0006\u0003\u0002$\u0005=\u0002#B\u0007\u0002&\u0005%\u0012bAA\u0014\u001d\t1q\n\u001d;j_:\u00042a`A\u0016\u0013\u0011\ti#!\u0001\u0003!Q{7.\u001a8J]\u001a|'/\\1uS>t\u0007bBA\u0019\u0003;\u0001\r!T\u0001\u0006Ef$Xm\u001d\u0005\b\u0003kIA\u0011AA\u001c\u0003-1\u0017\u000e\u001c;feR{7.\u001a8\u0015\u0015\u0005e\u0012qHA(\u0003[\ny\u0007E\u0002\u000e\u0003wI1!!\u0010\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0011\u00024\u0001\u0007\u00111I\u0001\u0013e\u0016\fX/Z:uK\u0012\u0004&/\u001b8dSB\fG\u000e\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\u0002\u0002\t\u0005,H\u000f[\u0005\u0005\u0003\u001b\n9E\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\u0011\u0005E\u00131\u0007a\u0001\u0003'\naa\\<oKJ\u001c\b#B\u0007\u0002&\u0005U\u0003CBA,\u0003O\n\u0019E\u0004\u0003\u0002Z\u0005\rd\u0002BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}c!\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019\u0011Q\r\b\u0002\u000fA\f7m[1hK&!\u0011\u0011NA6\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u0015d\u0002C\u0004~\u0003g\u0001\r!!\u000b\t\u0011\u0005E\u00141\u0007a\u0001\u0003g\na\"Y;uQ>\u0014\u0018N_3U_.,g\u000e\u0005\u0004\u000e\u0003k*\u0016\u0011H\u0005\u0004\u0003or!!\u0003$v]\u000e$\u0018n\u001c82\r\u0015Q!\u0001AA>'\u001d\tI\bDA?\u0003\u0013\u0003B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007#\u0011!B;uS2\u001c\u0018\u0002BAD\u0003\u0003\u0013q\u0001T8hO&tw\r\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty\tB\u0001\b[\u0016$(/[2t\u0013\u0011\t\u0019*!$\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000fC\u0006\u0002\u0018\u0006e$Q1A\u0005\u0002\u0005e\u0015AB2p]\u001aLw-\u0006\u0002\u0002\u001cB\u0019\u0001\"!(\n\u0007\u0005}%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bCAR\u0003s\u0012\t\u0011)A\u0005\u00037\u000bqaY8oM&<\u0007\u0005C\u0006\u0002(\u0006e$Q1A\u0005\u0002\u0005%\u0016A\u0003;pW\u0016t7)Y2iKV\u0011\u00111\u0016\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*!\u0011\u0011WA\u0001\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u00026\u0006=&\u0001\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8DC\u000eDW\rC\u0006\u0002:\u0006e$\u0011!Q\u0001\n\u0005-\u0016a\u0003;pW\u0016t7)Y2iK\u0002B1\"!0\u0002z\t\u0015\r\u0011\"\u0001\u0002@\u0006!A/[7f+\t\t\t\r\u0005\u0003\u0002D\u0006\u001dWBAAc\u0015\u0011\t\u0019)a\u0003\n\t\u0005%\u0017Q\u0019\u0002\u0005)&lW\rC\u0006\u0002N\u0006e$\u0011!Q\u0001\n\u0005\u0005\u0017!\u0002;j[\u0016\u0004\u0003bCAi\u0003s\u0012)\u0019!C\u0001\u0003'\f\u0001B_6DY&,g\u000e^\u000b\u0003\u0003+\u0004B!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0004\u00037$\u0011A\u0001>l\u0013\u0011\ty.!7\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011-\t\u0019/!\u001f\u0003\u0002\u0003\u0006I!!6\u0002\u0013i\\7\t\\5f]R\u0004\u0003bB\n\u0002z\u0011\u0005\u0011q\u001d\u000b\u000b\u0003S\fY/!<\u0002p\u0006E\bc\u0001\u0005\u0002z!A\u0011qSAs\u0001\u0004\tY\n\u0003\u0005\u0002(\u0006\u0015\b\u0019AAV\u0011!\ti,!:A\u0002\u0005\u0005\u0007\u0002CAi\u0003K\u0004\r!!6\u0006\u000f\u0005U\u0018\u0011\u0010\u0001\u0002x\n12I]3bi\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0004\u000e\u0003k\nI0a@\u0011\u0007!\tY0C\u0002\u0002~\n\u0011\u0011c\u0011:fCR,Gk\\6f]J+7/\u001e7u!\ri!\u0011A\u0005\u0004\u0005\u0007q!\u0001B+oSR,qAa\u0002\u0002z\u0001\u0011IAA\u000bSK:,wOU3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u00135\u0011YAa\u0004\u0003\u001c\u0005}\u0018b\u0001B\u0007\u001d\tIa)\u001e8di&|gN\r\t\u0005\u0005#\u00119\"\u0004\u0002\u0003\u0014)!!QCA\u0006\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\r\u0005'\u0011a!\u0012:s_J\u001c\bcA\u0007\u0003\u001e%\u0019!q\u0004\b\u0003\t1{gnZ\u0003\b\u0005G\tI\b\u0001B\u0005\u0005Y)\u0005\u0010]5sKJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\Wa\u0002B\u0014\u0003s\u0002!\u0011\u0006\u0002\u0019\t\u0016\u001c8M]5cKJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007#C\u0007\u0003\f\t=!1FA\u0000!\u0015\t9&a\u001a\u007f\u0011%a\u0016\u0011\u0010b\u0001\n\u0003\u0011y#F\u0001a\u0011!\u0011\u0019$!\u001f!\u0002\u0013\u0001\u0017AC:fGJ,GoS3zA!Q!qGA=\u0005\u0004%\tA!\u000f\u0002!Q|7.\u001a8NCbd\u0015NZ3uS6,WC\u0001B\u000e\u0011%\u0011i$!\u001f!\u0002\u0013\u0011Y\"A\tu_.,g.T1y\u0019&4W\r^5nK\u0002B!B!\u0011\u0002z\t\u0007I\u0011\u0001B\u001d\u0003U!WMZ1vYR$vn[3o%\u0016tWm\u001e+j[\u0016D\u0011B!\u0012\u0002z\u0001\u0006IAa\u0007\u0002-\u0011,g-Y;miR{7.\u001a8SK:,w\u000fV5nK\u0002B!B!\u0013\u0002z\t\u0007I\u0011\u0001B\u001d\u0003a!xn[3o%\u0016lwN^3s'\u000e\fg.\u00138uKJ4\u0018\r\u001c\u0005\n\u0005\u001b\nI\b)A\u0005\u00057\t\u0011\u0004^8lK:\u0014V-\\8wKJ\u001c6-\u00198J]R,'O^1mA!Q!\u0011KA=\u0005\u0004%IAa\u0015\u0002\t1|7m[\u000b\u0003\u0005+\u00022!\u0007B,\u0013\r\u0011IF\u0007\u0002\u0007\u001f\nTWm\u0019;\t\u0013\tu\u0013\u0011\u0010Q\u0001\n\tU\u0013!\u00027pG.\u0004\u0003B\u0003B1\u0003s\u0002\r\u0011\"\u0003\u0003d\u0005\u0019Bo\\6f]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feV\u0011!Q\r\t\u0005\u0005O\u0012Y'\u0004\u0002\u0003j)\u0019\u0011Q\u0002\u0003\n\t\t5$\u0011\u000e\u0002!5.tu\u000eZ3DQ\u0006tw-\u001a(pi&4\u0017nY1uS>tG*[:uK:,'\u000f\u0003\u0006\u0003r\u0005e\u0004\u0019!C\u0005\u0005g\nq\u0003^8lK:\u001c\u0005.\u00198hK2K7\u000f^3oKJ|F%Z9\u0015\t\u0005}(Q\u000f\u0005\u000b\u0005o\u0012y'!AA\u0002\t\u0015\u0014a\u0001=%c!I!1PA=A\u0003&!QM\u0001\u0015i>\\WM\\\"iC:<W\rT5ti\u0016tWM\u001d\u0011\t\u0011\t}\u0014\u0011\u0010C\u0001\u0005\u0003\u000bqa\u001d;beR,\b\u000f\u0006\u0002\u0002\u0000\"A!QQA=\t\u0003\u0011\t)\u0001\u0005tQV$Hm\\<o\u0011!\u0011I)!\u001f\u0005\n\t\u0005\u0015!\u00037pC\u0012\u001c\u0015m\u00195f\u0011!\u0011i)!\u001f\u0005\n\t=\u0015AD4fiR{7.\u001a8Ge>l'l\u001b\u000b\u0005\u0005#\u0013\u0019\n\u0005\u0003\u000e\u0003Kq\bB\u0002+\u0003\f\u0002\u0007Q\u000b\u0003\u0005\u0003\u0018\u0006eD\u0011\u0002BM\u0003-)\b\u000fZ1uK\u000e\u000b7\r[3\u0015\t\u0005}(1\u0014\u0005\u0007{\nU\u0005\u0019\u0001@\t\u0011\t}\u0015\u0011\u0010C\u0005\u0005C\u000bq\u0003\u001d:fa\u0006\u0014XmU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\t\r&\u0011\u0017\t\u0006-^,&Q\u0015\t\u0005\u0005O\u0013i+\u0004\u0002\u0003**!!1VA\u0004\u0003\u0015\u00198M]1n\u0013\u0011\u0011yK!+\u0003\u001fM\u001b'/Y7De\u0016$WM\u001c;jC2DqAa-\u0003\u001e\u0002\u0007Q+\u0001\u0006i[\u0006\u001c7\u000b\u001e:j]\u001eD\u0001Ba.\u0002z\u0011\u0005!\u0011X\u0001\fGJ,\u0017\r^3U_.,g\u000e\u0006\u0006\u0002\u0000\nm&q\u0018Bb\u0005\u000fD\u0001B!0\u00036\u0002\u0007\u00111I\u0001\u0006_^tWM\u001d\u0005\t\u0005\u0003\u0014)\f1\u0001\u0002V\u0005A!/\u001a8fo\u0016\u00148\u000f\u0003\u0005\u0003F\nU\u0006\u0019\u0001B\u000e\u00035i\u0017\r\u001f'jM\u0016$\u0016.\\3Ng\"A!\u0011\u001aB[\u0001\u0004\u0011Y-\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB!!QZAz\u001b\t\tI\b\u0003\u0005\u0003R\u0006eD\u0011\u0001Bj\u0003)\u0011XM\\3x)>\\WM\u001c\u000b\u000b\u0003\u007f\u0014)N!7\u0003j\n5\b\u0002\u0003Bl\u0005\u001f\u0004\r!a\u0011\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007\u0002\u0003Bn\u0005\u001f\u0004\rA!8\u0002\t!l\u0017m\u0019\t\u0005\u0005?\u0014)/\u0004\u0002\u0003b*\u0019!1\u001d\u000f\u0002\u00079Lw.\u0003\u0003\u0003h\n\u0005(A\u0003\"zi\u0016\u0014UO\u001a4fe\"A!1\u001eBh\u0001\u0004\u0011Y\"A\bsK:,w\u000fT5gKRKW.Z't\u0011!\u0011yOa4A\u0002\tE\u0018!\u0004:f]\u0016<8)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0003N\n\u0015\u0001\u0002\u0003B{\u0003s\"IAa>\u0002\u0017U\u0004H-\u0019;f)>\\WM\u001c\u000b\u0005\u0003\u007f\u0014I\u0010\u0003\u0004~\u0005g\u0004\rA \u0005\t\u0005{\fI\b\"\u0003\u0003\u0000\u0006Aq-\u001a;U_.,g\u000e\u0006\u0003\u0003\u0012\u000e\u0005\u0001\u0002\u0003Bn\u0005w\u0004\rA!8\t\u0011\r\u0015\u0011\u0011\u0010C\u0005\u0007\u000f\ta\"\u00197m_^,G\rV8SK:,w\u000f\u0006\u0004\u0002:\r%11\u0002\u0005\t\u0005/\u001c\u0019\u00011\u0001\u0002D!A1QBB\u0002\u0001\u0004\tI#A\u0005u_.,g.\u00138g_\"A!Q`A=\t\u0003\u0019\t\u0002\u0006\u0003\u0003\u0012\u000eM\u0001B\u0002+\u0004\u0010\u0001\u0007Q\u000b\u0003\u0005\u0003~\u0006eD\u0011BB\f)\rq8\u0011\u0004\u0005\t\u0007\u001b\u0019)\u00021\u0001\u0002*!A1QDA=\t\u0003\u0019y\"A\u0006fqBL'/\u001a+pW\u0016tGCCA\u0000\u0007C\u0019\u0019c!\n\u0004*!A!q[B\u000e\u0001\u0004\t\u0019\u0005\u0003\u0005\u0003\\\u000em\u0001\u0019\u0001Bo\u0011!\u00199ca\u0007A\u0002\tm\u0011\u0001E3ya&\u0014X\rT5gKRKW.Z't\u0011!\u0019Yca\u0007A\u0002\r5\u0012AF3ya&\u0014XMU3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\t\t5'\u0011\u0005\u0005\t\u0007c\tI\b\"\u0003\u00044\u0005Y!/Z7pm\u0016$vn[3o)\u0011\typ!\u000e\t\rQ\u001by\u00031\u0001V\u0011!\u0019I$!\u001f\u0005\n\rm\u0012a\u0003:f[>4XmQ1dQ\u0016$B!a@\u0004>!1Aka\u000eA\u0002UC\u0001b!\u0011\u0002z\u0011\u0005!\u0011Q\u0001\rKb\u0004\u0018N]3U_.,gn\u001d\u0005\t\u0007\u000b\nI\b\"\u0001\u0004H\u00051r-\u001a;BY2$vn[3o\u0013:4wN]7bi&|g\u000e\u0006\u0002\u0004JA1\u0011qKA4\u0003SA\u0001b!\u0014\u0002z\u0011\u00051qJ\u0001\nO\u0016$Hk\\6f]N$BAa\u000b\u0004R!A\u0011QGB&\u0001\u0004\u0019\u0019\u0006E\u0004\u000e\u0003k\nI#!\u000f\b\u0011\r]\u0013\u0011\u0010E\u0001\u00073\nq\u0004V8lK:\u001c\u0005.\u00198hK\u0012tu\u000e^5gS\u000e\fG/[8o\u0011\u0006tG\r\\3s!\u0011\u0011ima\u0017\u0007\u0011\ru\u0013\u0011\u0010E\u0001\u0007?\u0012q\u0004V8lK:\u001c\u0005.\u00198hK\u0012tu\u000e^5gS\u000e\fG/[8o\u0011\u0006tG\r\\3s'\u0015\u0019Y\u0006DB1!\u0011\u00119ga\u0019\n\t\r\u0015$\u0011\u000e\u0002\u0014\u001d>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM\u001d\u0005\b'\rmC\u0011AB5)\t\u0019I\u0006\u0003\u0005\u0004n\rmC\u0011IB8\u0003M\u0001(o\\2fgNtu\u000e^5gS\u000e\fG/[8o)\u0011\typ!\u001d\t\u000f\rM41\u000ea\u0001\u001b\u0006aAo\\6f]&#')\u001f;fg\u0002")
public class DelegationTokenManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final DelegationTokenCache tokenCache;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final SecretKey secretKey;
    private final long tokenMaxLifetime;
    private final long defaultTokenRenewTime;
    private final long tokenRemoverScanInterval;
    private final Object kafka$server$DelegationTokenManager$$lock;
    private ZkNodeChangeNotificationListener tokenChangeListener;
    private volatile DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$module;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean filterToken(KafkaPrincipal kafkaPrincipal, Option<List<KafkaPrincipal>> option, TokenInformation tokenInformation, Function1<String, Object> function1) {
        return DelegationTokenManager$.MODULE$.filterToken(kafkaPrincipal, option, tokenInformation, function1);
    }

    public static Option<TokenInformation> fromBytes(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.fromBytes(byArray);
    }

    public static scala.collection.immutable.Map<String, Object> toJsonCompatibleMap(DelegationToken delegationToken) {
        return DelegationTokenManager$.MODULE$.toJsonCompatibleMap(delegationToken);
    }

    public static byte[] createHmac(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(string, secretKey);
    }

    public static String createBase64HMAC(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createBase64HMAC(string, secretKey);
    }

    public static SecretKey createSecretKey(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.createSecretKey(byArray);
    }

    public static byte[] createHmac(String string, String string2) {
        return DelegationTokenManager$.MODULE$.createHmac(string, string2);
    }

    public static int ErrorTimestamp() {
        return DelegationTokenManager$.MODULE$.ErrorTimestamp();
    }

    public static int CurrentVersion() {
        return DelegationTokenManager$.MODULE$.CurrentVersion();
    }

    public static String VersionKey() {
        return DelegationTokenManager$.MODULE$.VersionKey();
    }

    public static String TokenIdKey() {
        return DelegationTokenManager$.MODULE$.TokenIdKey();
    }

    public static String ExpiryTimestampKey() {
        return DelegationTokenManager$.MODULE$.ExpiryTimestampKey();
    }

    public static String MaxTimestampKey() {
        return DelegationTokenManager$.MODULE$.MaxTimestampKey();
    }

    public static String IssueTimestampKey() {
        return DelegationTokenManager$.MODULE$.IssueTimestampKey();
    }

    public static String RenewersKey() {
        return DelegationTokenManager$.MODULE$.RenewersKey();
    }

    public static String OwnerKey() {
        return DelegationTokenManager$.MODULE$.OwnerKey();
    }

    public static String DefaultHmacAlgorithm() {
        return DelegationTokenManager$.MODULE$.DefaultHmacAlgorithm();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$lzycompute() {
        DelegationTokenManager delegationTokenManager = this;
        synchronized (delegationTokenManager) {
            if (this.TokenChangedNotificationHandler$module != null) return this.TokenChangedNotificationHandler$module;
            this.TokenChangedNotificationHandler$module = new DelegationTokenManager$TokenChangedNotificationHandler$(this);
            return this.TokenChangedNotificationHandler$module;
        }
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    private Logger logger$lzycompute() {
        DelegationTokenManager delegationTokenManager = this;
        synchronized (delegationTokenManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Time time() {
        return this.time;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public long tokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long defaultTokenRenewTime() {
        return this.defaultTokenRenewTime;
    }

    public long tokenRemoverScanInterval() {
        return this.tokenRemoverScanInterval;
    }

    public Object kafka$server$DelegationTokenManager$$lock() {
        return this.kafka$server$DelegationTokenManager$$lock;
    }

    private ZkNodeChangeNotificationListener tokenChangeListener() {
        return this.tokenChangeListener;
    }

    private void tokenChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.tokenChangeListener = x$1;
    }

    public void startup() {
        if (this.config().tokenAuthEnabled()) {
            this.zkClient().createDelegationTokenPaths();
            this.loadCache();
            this.tokenChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), DelegationTokenChangeNotificationZNode$.MODULE$.path(), DelegationTokenChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.TokenChangedNotificationHandler(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
            this.tokenChangeListener().init();
        }
    }

    public void shutdown() {
        if (this.config().tokenAuthEnabled() && this.tokenChangeListener() != null) {
            this.tokenChangeListener().close();
        }
    }

    private void loadCache() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Seq<String> tokens = this.zkClient().getChildren(DelegationTokensZNode$.MODULE$.path());
            this.info((Function0<String>)new Serializable(this, tokens){
                public static final long serialVersionUID = 0L;
                private final Seq tokens$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading the token cache. Total token count: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tokens$1.size())}));
                }
                {
                    this.tokens$1 = tokens$1;
                }
            });
            tokens.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelegationTokenManager $outer;

                public final void apply(String tokenId) {
                    block4: {
                        try {
                            Option<DelegationToken> option = this.$outer.kafka$server$DelegationTokenManager$$getTokenFromZk(tokenId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                DelegationToken token = (DelegationToken)some.x();
                                this.$outer.kafka$server$DelegationTokenManager$$updateCache(token);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (None$.MODULE$.equals(option)) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            throw new MatchError(option);
                        }
                        catch (Throwable throwable) {
                            this.$outer.error((Function0<String>)new Serializable(this, tokenId){
                                public static final long serialVersionUID = 0L;
                                private final String tokenId$3;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while getting Token for tokenId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenId$3}));
                                }
                                {
                                    this.tokenId$3 = tokenId$3;
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID = 0L;
                                private final Throwable ex$1;

                                public final Throwable apply() {
                                    return this.ex$1;
                                }
                                {
                                    this.ex$1 = ex$1;
                                }
                            });
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public Option<DelegationToken> kafka$server$DelegationTokenManager$$getTokenFromZk(String tokenId) {
        Option<TokenInformation> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = this.zkClient().getDelegationTokenInfo(tokenId);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    TokenInformation tokenInformation = (TokenInformation)some.x();
                    byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
                    none$ = new Some((Object)new DelegationToken(tokenInformation, hmac));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public void kafka$server$DelegationTokenManager$$updateCache(DelegationToken token) {
        String hmacString = token.hmacAsBase64String();
        scala.collection.immutable.Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache().updateCache(token, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(scramCredentialMap).asJava());
    }

    private scala.collection.immutable.Map<String, ScramCredential> prepareScramCredentials(String hmacString) {
        scala.collection.mutable.Map scramCredentialMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()).foreach((Function1)new Serializable(this, hmacString, scramCredentialMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManager $outer;
            private final String hmacString$1;
            private final scala.collection.mutable.Map scramCredentialMap$1;

            public final void apply(ScramMechanism mechanism) {
                this.scramCredentialMap$1.update((Object)mechanism.mechanismName(), (Object)this.$outer.kafka$server$DelegationTokenManager$$scramCredential$1(mechanism, this.hmacString$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hmacString$1 = hmacString$1;
                this.scramCredentialMap$1 = scramCredentialMap$1;
            }
        });
        return scramCredentialMap.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createToken(KafkaPrincipal owner, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            responseCallback.apply((Object)new CreateTokenResult(-1L, -1L, -1L, "", (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.DELEGATION_TOKEN_AUTH_DISABLED));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            String tokenId = CoreUtils$.MODULE$.generateUuidAsBase64();
            long issueTimeStamp = this.time().milliseconds();
            long maxLifeTime = maxLifeTimeMs <= 0L ? this.tokenMaxLifetime() : Math.min(maxLifeTimeMs, this.tokenMaxLifetime());
            long maxLifeTimeStamp = issueTimeStamp + maxLifeTime;
            long expiryTimeStamp = Math.min(maxLifeTimeStamp, issueTimeStamp + this.defaultTokenRenewTime());
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimeStamp, maxLifeTimeStamp, expiryTimeStamp);
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            DelegationToken token = new DelegationToken(tokenInfo, hmac);
            this.updateToken(token);
            this.info((Function0<String>)new Serializable(this, owner, tokenId){
                public static final long serialVersionUID = 0L;
                private final KafkaPrincipal owner$1;
                private final String tokenId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a delegation token: ", " for owner: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenId$1, this.owner$1}));
                }
                {
                    this.owner$1 = owner$1;
                    this.tokenId$1 = tokenId$1;
                }
            });
            responseCallback.apply((Object)new CreateTokenResult(issueTimeStamp, expiryTimeStamp, maxLifeTimeStamp, tokenId, hmac, Errors.NONE));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        if (!this.config().tokenAuthEnabled()) {
            renewCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                DelegationToken token = (DelegationToken)some.x();
                long now = this.time().milliseconds();
                TokenInformation tokenInfo = token.tokenInfo();
                if (this.allowedToRenew(principal, tokenInfo)) {
                    if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                        boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                    } else {
                        long renewLifeTime = renewLifeTimeMs < 0L ? this.defaultTokenRenewTime() : renewLifeTimeMs;
                        long renewTimeStamp = now + renewLifeTime;
                        long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), renewTimeStamp);
                        tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                        this.updateToken(token);
                        this.info((Function0<String>)new Serializable(this, tokenInfo){
                            public static final long serialVersionUID = 0L;
                            private final TokenInformation tokenInfo$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation token renewed for token: ", " for owner: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenInfo$1.tokenId(), this.tokenInfo$1.owner()}));
                            }
                            {
                                this.tokenInfo$1 = tokenInfo$1;
                            }
                        });
                        boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                    }
                } else {
                    boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                BoxedUnit boxedUnit = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            }
            return;
        }
    }

    private void updateToken(DelegationToken token) {
        this.zkClient().setOrCreateDelegationToken(token);
        this.kafka$server$DelegationTokenManager$$updateCache(token);
        this.zkClient().createTokenChangeNotification(token.tokenInfo().tokenId());
    }

    private Option<DelegationToken> getToken(ByteBuffer hmac) {
        Object object;
        try {
            byte[] byteArray = new byte[hmac.remaining()];
            hmac.get(byteArray);
            String base64Pwd = Base64.getEncoder().encodeToString(byteArray);
            TokenInformation tokenInfo = this.tokenCache().tokenForHmac(base64Pwd);
            object = tokenInfo == null ? None$.MODULE$ : new Some((Object)new DelegationToken(tokenInfo, byteArray));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while getting token for hmac";
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            object = None$.MODULE$;
        }
        return object;
    }

    private boolean allowedToRenew(KafkaPrincipal principal, TokenInformation tokenInfo) {
        return principal.equals((Object)tokenInfo.owner()) || ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewers()).asScala()).toList().contains((Object)principal);
    }

    public Option<DelegationToken> getToken(String tokenId) {
        TokenInformation tokenInfo = this.tokenCache().token(tokenId);
        return tokenInfo == null ? None$.MODULE$ : new Some((Object)this.kafka$server$DelegationTokenManager$$getToken(tokenInfo));
    }

    public DelegationToken kafka$server$DelegationTokenManager$$getToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenInfo.tokenId(), this.secretKey());
        return new DelegationToken(tokenInfo, hmac);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)BoxesRunTime.boxToLong((long)-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            block11: {
                Option<DelegationToken> option;
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        block10: {
                            option = this.getToken(hmac);
                            if (!(option instanceof Some)) break block9;
                            Some some = (Some)option;
                            DelegationToken token = (DelegationToken)some.x();
                            TokenInformation tokenInfo = token.tokenInfo();
                            long now = this.time().milliseconds();
                            if (!this.allowedToRenew(principal, tokenInfo)) break block10;
                            if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                                boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)BoxesRunTime.boxToLong((long)-1L));
                                break block8;
                            } else if (expireLifeTimeMs < 0L) {
                                this.kafka$server$DelegationTokenManager$$removeToken(tokenInfo.tokenId());
                                this.info((Function0<String>)new Serializable(this, tokenInfo){
                                    public static final long serialVersionUID = 0L;
                                    private final TokenInformation tokenInfo$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Token expired for token: ", " for owner: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenInfo$2.tokenId(), this.tokenInfo$2.owner()}));
                                    }
                                    {
                                        this.tokenInfo$2 = tokenInfo$2;
                                    }
                                });
                                boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)now));
                                break block8;
                            } else {
                                long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), now + expireLifeTimeMs);
                                tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                                this.updateToken(token);
                                this.info((Function0<String>)new Serializable(this, tokenInfo){
                                    public static final long serialVersionUID = 0L;
                                    private final TokenInformation tokenInfo$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated expiry time for token: ", " for owner: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenInfo$2.tokenId(), this.tokenInfo$2.owner()}));
                                    }
                                    {
                                        this.tokenInfo$2 = tokenInfo$2;
                                    }
                                });
                                boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)BoxesRunTime.boxToLong((long)expiryTimeStamp));
                            }
                            break block8;
                        }
                        boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)BoxesRunTime.boxToLong((long)-1L));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block11;
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                BoxedUnit boxedUnit = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)BoxesRunTime.boxToLong((long)-1L));
            }
            return;
        }
    }

    public void kafka$server$DelegationTokenManager$$removeToken(String tokenId) {
        this.zkClient().deleteDelegationToken(tokenId);
        this.kafka$server$DelegationTokenManager$$removeCache(tokenId);
        this.zkClient().createTokenChangeNotification(tokenId);
    }

    public void kafka$server$DelegationTokenManager$$removeCache(String tokenId) {
        this.tokenCache().removeCache(tokenId);
    }

    public void expireTokens() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            this.getAllTokenInformation().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelegationTokenManager $outer;

                public final void apply(TokenInformation tokenInfo) {
                    long now = this.$outer.time().milliseconds();
                    if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                        this.$outer.info((Function0<String>)new Serializable(this, tokenInfo){
                            public static final long serialVersionUID = 0L;
                            private final TokenInformation tokenInfo$3;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation token expired for token: ", " for owner: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tokenInfo$3.tokenId(), this.tokenInfo$3.owner()}));
                            }
                            {
                                this.tokenInfo$3 = tokenInfo$3;
                            }
                        });
                        this.$outer.kafka$server$DelegationTokenManager$$removeToken(tokenInfo.tokenId());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public List<TokenInformation> getAllTokenInformation() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.tokenCache().tokens()).asScala()).toList();
    }

    public List<DelegationToken> getTokens(Function1<TokenInformation, Object> filterToken) {
        return (List)((List)this.getAllTokenInformation().filter(filterToken)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManager $outer;

            public final DelegationToken apply(TokenInformation token) {
                return this.$outer.kafka$server$DelegationTokenManager$$getToken(token);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler() {
        return this.TokenChangedNotificationHandler$module == null ? this.TokenChangedNotificationHandler$lzycompute() : this.TokenChangedNotificationHandler$module;
    }

    public final ScramCredential kafka$server$DelegationTokenManager$$scramCredential$1(ScramMechanism mechanism, String hmacString$1) {
        return new ScramFormatter(mechanism).generateCredential(hmacString$1, mechanism.minIterations());
    }

    public DelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        this.config = config;
        this.tokenCache = tokenCache;
        this.time = time;
        this.zkClient = zkClient;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Token Manager on Broker ", "]: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokerId())})));
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenMasterKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || keyBytes.length == 0 ? null : DelegationTokenManager$.MODULE$.createSecretKey(keyBytes);
        this.tokenMaxLifetime = Predef$.MODULE$.Long2long(config.delegationTokenMaxLifeMs());
        this.defaultTokenRenewTime = Predef$.MODULE$.Long2long(config.delegationTokenExpiryTimeMs());
        this.tokenRemoverScanInterval = Predef$.MODULE$.Long2long(config.delegationTokenExpiryCheckIntervalMs());
        this.kafka$server$DelegationTokenManager$$lock = new Object();
        this.tokenChangeListener = null;
    }
}

