/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.common.KafkaException;
import kafka.coordinator.transaction.ProducerIdBlock;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dq!B\u0001\u0003\u0011\u0003I\u0011!\u0005)s_\u0012,8-\u001a:JI6\u000bg.Y4fe*\u00111\u0001B\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA\t!\u0004\u0002\u0012!J|G-^2fe&#W*\u00198bO\u0016\u00148cA\u0006\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\u00067-!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%AqAH\u0006C\u0002\u0013\u0005q$\u0001\bDkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003\u0001\u0002\"aD\u0011\n\u0005\t\u0002\"\u0001\u0002'p]\u001eDa\u0001J\u0006!\u0002\u0013\u0001\u0013aD\"veJ,g\u000e\u001e,feNLwN\u001c\u0011\t\u000f\u0019Z!\u0019!C\u0001?\u0005a\u0001+\u001b3CY>\u001c7nU5{K\"1\u0001f\u0003Q\u0001\n\u0001\nQ\u0002U5e\u00052|7m[*ju\u0016\u0004\u0003\"\u0002\u0016\f\t\u0003Y\u0013aG4f]\u0016\u0014\u0018\r^3Qe>$WoY3s\u0013\u0012\u0014En\\2l\u0015N|g\u000e\u0006\u0002-oA\u0011Q\u0006\u000e\b\u0003]I\u0002\"a\f\t\u000e\u0003AR!!\r\u0005\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u0011\u0011\u0015A\u0014\u00061\u0001:\u0003=\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\"m_\u000e\\\u0007C\u0001\u0006;\u0013\tY$AA\bQe>$WoY3s\u0013\u0012\u0014En\\2l\u0011\u0015i4\u0002\"\u0001?\u0003a\u0001\u0018M]:f!J|G-^2fe&#'\t\\8dW\u0012\u000bG/\u0019\u000b\u0003s}BQ\u0001\u0011\u001fA\u00021\n\u0001B[:p]\u0012\u000bG/\u0019\u0004\u0005\u0019\t\u0001!iE\u0002B\u001dQA\u0001\u0002R!\u0003\u0006\u0004%\t!R\u0001\tEJ|7.\u001a:JIV\ta\t\u0005\u0002\u0010\u000f&\u0011\u0001\n\u0005\u0002\u0004\u0013:$\b\u0002\u0003&B\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003\u0002\u0003'B\u0005\u000b\u0007I\u0011A'\u0002\u000fi\\W\u000b^5mgV\ta\n\u0005\u0002\u0016\u001f&\u0011\u0001K\u0006\u0002\b5.,F/\u001b7t\u0011!\u0011\u0016I!A!\u0002\u0013q\u0015\u0001\u0003>l+RLGn\u001d\u0011\t\u000bm\tE\u0011\u0001+\u0015\u0007U3v\u000b\u0005\u0002\u000b\u0003\")Ai\u0015a\u0001\r\")Aj\u0015a\u0001\u001d\"9\u0011,\u0011a\u0001\n\u0013Q\u0016AF2veJ,g\u000e\u001e)s_\u0012,8-\u001a:JI\ncwnY6\u0016\u0003eBq\u0001X!A\u0002\u0013%Q,\u0001\u000edkJ\u0014XM\u001c;Qe>$WoY3s\u0013\u0012\u0014En\\2l?\u0012*\u0017\u000f\u0006\u0002_CB\u0011qbX\u0005\u0003AB\u0011A!\u00168ji\"9!mWA\u0001\u0002\u0004I\u0014a\u0001=%c!1A-\u0011Q!\ne\nqcY;se\u0016tG\u000f\u0015:pIV\u001cWM]%e\u00052|7m\u001b\u0011\t\u000f\u0019\f\u0005\u0019!C\u0005?\u0005qa.\u001a=u!J|G-^2fe&#\u0007b\u00025B\u0001\u0004%I![\u0001\u0013]\u0016DH\u000f\u0015:pIV\u001cWM]%e?\u0012*\u0017\u000f\u0006\u0002_U\"9!mZA\u0001\u0002\u0004\u0001\u0003B\u00027BA\u0003&\u0001%A\boKb$\bK]8ek\u000e,'/\u00133!\u0011\u0015q\u0017\t\"\u0003p\u0003U9W\r\u001e(foB\u0013x\u000eZ;dKJLEM\u00117pG.$\u0012A\u0018\u0005\u0006c\u0006#IA]\u0001\u001bG\",7m\u001b)s_\u0012,8-\u001a:JI\ncwnY6[W\u0012\u000bG/\u0019\u000b\u0005gfTH\u0010\u0005\u0003\u0010iZ4\u0015BA;\u0011\u0005\u0019!V\u000f\u001d7feA\u0011qb^\u0005\u0003qB\u0011qAQ8pY\u0016\fg\u000eC\u0003Ma\u0002\u0007a\nC\u0003|a\u0002\u0007A&\u0001\u0003qCRD\u0007\"B?q\u0001\u0004a\u0013\u0001D3ya\u0016\u001cG/\u001a3ECR\f\u0007BB@B\t\u0003\t\t!\u0001\nhK:,'/\u0019;f!J|G-^2fe&#G#\u0001\u0011\t\r\u0005\u0015\u0011\t\"\u0001p\u0003!\u0019\b.\u001e;e_^t\u0007")
public class ProducerIdManager
implements Logging {
    private final int brokerId;
    private final ZkUtils zkUtils;
    private ProducerIdBlock currentProducerIdBlock;
    private long nextProducerId;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static ProducerIdBlock parseProducerIdBlockData(String string) {
        return ProducerIdManager$.MODULE$.parseProducerIdBlockData(string);
    }

    public static String generateProducerIdBlockJson(ProducerIdBlock producerIdBlock) {
        return ProducerIdManager$.MODULE$.generateProducerIdBlockJson(producerIdBlock);
    }

    public static long PidBlockSize() {
        return ProducerIdManager$.MODULE$.PidBlockSize();
    }

    public static long CurrentVersion() {
        return ProducerIdManager$.MODULE$.CurrentVersion();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerIdManager producerIdManager = this;
        synchronized (producerIdManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private ProducerIdBlock currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private void currentProducerIdBlock_$eq(ProducerIdBlock x$1) {
        this.currentProducerIdBlock = x$1;
    }

    private long nextProducerId() {
        return this.nextProducerId;
    }

    private void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    private void getNewProducerIdBlock() {
        boolean zkWriteComplete = false;
        while (!zkWriteComplete) {
            ProducerIdBlock producerIdBlock;
            Tuple2<Option<String>, Object> tuple2 = this.zkUtils().readDataAndVersionMaybeNull(ZkUtils$.MODULE$.ProducerIdBlockPath());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option dataOpt = (Option)tuple2._1();
            int zkVersion = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)dataOpt, (Object)BoxesRunTime.boxToInteger((int)zkVersion));
            Tuple2 tuple23 = tuple22;
            Option dataOpt2 = (Option)tuple23._1();
            int zkVersion2 = tuple23._2$mcI$sp();
            Option option = dataOpt2;
            if (option instanceof Some) {
                Some some = (Some)option;
                String data = (String)some.value();
                ProducerIdBlock currProducerIdBlock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(data);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read current producerId block ", ", Zk path version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currProducerIdBlock, BoxesRunTime.boxToInteger((int)zkVersion2)})));
                if (currProducerIdBlock.blockEndId() > Long.MAX_VALUE - ProducerIdManager$.MODULE$.PidBlockSize()) {
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exhausted all producerIds as the next block's end producerId is will has exceeded long type limit (current block end producerId is ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)currProducerIdBlock.blockEndId())})));
                    throw new KafkaException("Have exhausted all producerIds.");
                }
                producerIdBlock = new ProducerIdBlock(this.brokerId(), currProducerIdBlock.blockEndId() + 1L, currProducerIdBlock.blockEndId() + ProducerIdManager$.MODULE$.PidBlockSize());
            } else if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is no producerId block yet (Zk path version ", "), creating the first block"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)zkVersion2)})));
                producerIdBlock = new ProducerIdBlock(this.brokerId(), 0L, ProducerIdManager$.MODULE$.PidBlockSize() - 1L);
            } else {
                throw new MatchError((Object)option);
            }
            this.currentProducerIdBlock_$eq(producerIdBlock);
            String newProducerIdBlockData = ProducerIdManager$.MODULE$.generateProducerIdBlockJson(this.currentProducerIdBlock());
            Tuple2<Object, Object> tuple24 = this.zkUtils().conditionalUpdatePersistentPath(ZkUtils$.MODULE$.ProducerIdBlockPath(), newProducerIdBlockData, zkVersion2, (Option<Function3<ZkUtils, String, String, Tuple2<Object, Object>>>)new Some((Function3 & Serializable & scala.Serializable)(zkUtils, path, expectedData) -> this.checkProducerIdBlockZkData((ZkUtils)zkUtils, (String)path, (String)expectedData)));
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            boolean succeeded = tuple24._1$mcZ$sp();
            int version = tuple24._2$mcI$sp();
            Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(succeeded, version);
            Tuple2.mcZI.sp sp3 = sp2;
            boolean succeeded2 = sp3._1$mcZ$sp();
            int version2 = sp3._2$mcI$sp();
            zkWriteComplete = succeeded2;
            if (!zkWriteComplete) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Acquired new producerId block ", " by writing to Zk with path version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentProducerIdBlock(), BoxesRunTime.boxToInteger((int)version2)})));
        }
    }

    private Tuple2<Object, Object> checkProducerIdBlockZkData(ZkUtils zkUtils, String path, String expectedData) {
        Tuple2.mcZI.sp sp2;
        try {
            Tuple2.mcZI.sp sp3;
            ProducerIdBlock expectedPidBlock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(expectedData);
            Tuple2<Option<String>, Object> tuple2 = zkUtils.readDataAndVersionMaybeNull(ZkUtils$.MODULE$.ProducerIdBlockPath());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option dataOpt = (Option)tuple2._1();
            int zkVersion = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)dataOpt, (Object)BoxesRunTime.boxToInteger((int)zkVersion));
            Tuple2 tuple23 = tuple22;
            Option dataOpt2 = (Option)tuple23._1();
            int zkVersion2 = tuple23._2$mcI$sp();
            Option option = dataOpt2;
            if (option instanceof Some) {
                ProducerIdBlock currProducerIdBLock;
                Some some = (Some)option;
                String data = (String)some.value();
                ProducerIdBlock producerIdBlock = currProducerIdBLock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(data);
                ProducerIdBlock producerIdBlock2 = expectedPidBlock;
                sp3 = new Tuple2.mcZI.sp(!(producerIdBlock != null ? !((Object)producerIdBlock).equals(producerIdBlock2) : producerIdBlock2 != null), zkVersion2);
            } else if (None$.MODULE$.equals(option)) {
                sp3 = new Tuple2.mcZI.sp(false, -1);
            } else {
                throw new MatchError((Object)option);
            }
            sp2 = sp3;
        }
        catch (Exception e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while checking for producerId block Zk data on path ", ": expected data ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, expectedData})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            sp2 = new Tuple2.mcZI.sp(false, -1);
        }
        return sp2;
    }

    public synchronized long generateProducerId() {
        if (this.nextProducerId() > this.currentProducerIdBlock().blockEndId()) {
            this.getNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().blockStartId() + 1L);
        } else {
            this.nextProducerId_$eq(this.nextProducerId() + 1L);
        }
        return this.nextProducerId() - 1L;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shutdown complete: last producerId assigned ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.nextProducerId())})));
    }

    public ProducerIdManager(int brokerId, ZkUtils zkUtils) {
        this.brokerId = brokerId;
        this.zkUtils = zkUtils;
        Logging.$init$(this);
        this.logIdent_$eq("[ProducerId Manager " + brokerId + "]: ");
        this.currentProducerIdBlock = null;
        this.nextProducerId = -1L;
        ProducerIdManager producerIdManager = this;
        synchronized (producerIdManager) {
            this.getNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().blockStartId());
        }
    }
}

