/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import kafka.api.RequestOrResponse;
import kafka.network.BlockingChannel$;
import kafka.network.RequestOrResponseSend;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ev!B\u0001\u0003\u0011\u00039\u0011a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00039\u0012\u0001F+tK\u0012+g-Y;mi\n+hMZ3s'&TX-F\u0001\u0019!\ti\u0011$\u0003\u0002\u001b\u001d\t\u0019\u0011J\u001c;\t\rqI\u0001\u0015!\u0003\u0019\u0003U)6/\u001a#fM\u0006,H\u000e\u001e\"vM\u001a,'oU5{K\u0002BC!\u0003\u0010\"GA\u0011QbH\u0005\u0003A9\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005\u0011\u0013\u0001\u0013+iSN\u0004sN\u00196fGR\u0004\u0003.Y:!E\u0016,g\u000e\t3faJ,7-\u0019;fI\u0002\ng\u000e\u001a\u0011xS2d\u0007EY3!e\u0016lwN^3eA%t\u0007%\u0019\u0011gkR,(/\u001a\u0011sK2,\u0017m]3/C\u0005!\u0013\u0001\u0003\u0019/cEr\u0003G\f\u0019)\t%qbeI\u0011\u0002O\u00059E\u000b[5tA\rd\u0017m]:!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004s/\u001b7mA\t,\u0007E]3n_Z,G\rI5oA\u0005\u0004c-\u001e;ve\u0016\u0004#/\u001a7fCN,g\u0006\u000b\u0003\u0001=\u0005\u001ac\u0001\u0002\u0006\u0003\u0001)\u001a2!\u000b\u0007,!\tas&D\u0001.\u0015\tqC!A\u0003vi&d7/\u0003\u00021[\t9Aj\\4hS:<\u0007\u0002\u0003\u001a*\u0005\u000b\u0007I\u0011A\u001a\u0002\t!|7\u000f^\u000b\u0002iA\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\b\u000e\u0003aR!!\u000f\u0004\u0002\rq\u0012xn\u001c;?\u0013\tYd\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u000f\u0011!\u0001\u0015F!A!\u0002\u0013!\u0014!\u00025pgR\u0004\u0003\u0002\u0003\"*\u0005\u000b\u0007I\u0011A\f\u0002\tA|'\u000f\u001e\u0005\t\t&\u0012\t\u0011)A\u00051\u0005)\u0001o\u001c:uA!Aa)\u000bBC\u0002\u0013\u0005q#\u0001\bsK\u0006$')\u001e4gKJ\u001c\u0016N_3\t\u0011!K#\u0011!Q\u0001\na\tqB]3bI\n+hMZ3s'&TX\r\t\u0005\t\u0015&\u0012)\u0019!C\u0001/\u0005yqO]5uK\n+hMZ3s'&TX\r\u0003\u0005MS\t\u0005\t\u0015!\u0003\u0019\u0003A9(/\u001b;f\u0005V4g-\u001a:TSj,\u0007\u0005\u0003\u0005OS\t\u0015\r\u0011\"\u0001\u0018\u00035\u0011X-\u00193US6,w.\u001e;Ng\"A\u0001+\u000bB\u0001B\u0003%\u0001$\u0001\bsK\u0006$G+[7f_V$Xj\u001d\u0011\t\u000bMIC\u0011\u0001*\u0015\rM#VKV,Y!\tA\u0011\u0006C\u00033#\u0002\u0007A\u0007C\u0003C#\u0002\u0007\u0001\u0004C\u0003G#\u0002\u0007\u0001\u0004C\u0003K#\u0002\u0007\u0001\u0004C\u0003O#\u0002\u0007\u0001\u0004C\u0004[S\u0001\u0007I\u0011B.\u0002\u0013\r|gN\\3di\u0016$W#\u0001/\u0011\u00055i\u0016B\u00010\u000f\u0005\u001d\u0011un\u001c7fC:Dq\u0001Y\u0015A\u0002\u0013%\u0011-A\u0007d_:tWm\u0019;fI~#S-\u001d\u000b\u0003E\u0016\u0004\"!D2\n\u0005\u0011t!\u0001B+oSRDqAZ0\u0002\u0002\u0003\u0007A,A\u0002yIEBa\u0001[\u0015!B\u0013a\u0016AC2p]:,7\r^3eA!9!.\u000ba\u0001\n\u0013Y\u0017aB2iC:tW\r\\\u000b\u0002YB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\tG\"\fgN\\3mg*\u0011\u0011O]\u0001\u0004]&|'\"A:\u0002\t)\fg/Y\u0005\u0003k:\u0014QbU8dW\u0016$8\t[1o]\u0016d\u0007bB<*\u0001\u0004%I\u0001_\u0001\fG\"\fgN\\3m?\u0012*\u0017\u000f\u0006\u0002cs\"9aM^A\u0001\u0002\u0004a\u0007BB>*A\u0003&A.\u0001\u0005dQ\u0006tg.\u001a7!\u0011\u001di\u0018\u00061A\u0005\ny\f1B]3bI\u000eC\u0017M\u001c8fYV\tq\u0010E\u0002n\u0003\u0003I1!a\u0001o\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0011%\t9!\u000ba\u0001\n\u0013\tI!A\bsK\u0006$7\t[1o]\u0016dw\fJ3r)\r\u0011\u00171\u0002\u0005\tM\u0006\u0015\u0011\u0011!a\u0001\u007f\"9\u0011qB\u0015!B\u0013y\u0018\u0001\u0004:fC\u0012\u001c\u0005.\u00198oK2\u0004\u0003\"CA\nS\u0001\u0007I\u0011BA\u000b\u000319(/\u001b;f\u0007\"\fgN\\3m+\t\t9\u0002E\u0002n\u00033I1!a\u0007o\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\"I\u0011qD\u0015A\u0002\u0013%\u0011\u0011E\u0001\u0011oJLG/Z\"iC:tW\r\\0%KF$2AYA\u0012\u0011%1\u0017QDA\u0001\u0002\u0004\t9\u0002\u0003\u0005\u0002(%\u0002\u000b\u0015BA\f\u000359(/\u001b;f\u0007\"\fgN\\3mA!I\u00111F\u0015C\u0002\u0013%\u0011QF\u0001\u0005Y>\u001c7.\u0006\u0002\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026I\fA\u0001\\1oO&!\u0011\u0011HA\u001a\u0005\u0019y%M[3di\"A\u0011QH\u0015!\u0002\u0013\ty#A\u0003m_\u000e\\\u0007\u0005\u0003\u0005\u0002B%\u0012\r\u0011\"\u0003\u0018\u0003A\u0019wN\u001c8fGR$\u0016.\\3pkRl5\u000fC\u0004\u0002F%\u0002\u000b\u0011\u0002\r\u0002#\r|gN\\3diRKW.Z8vi6\u001b\b\u0005\u0003\u0005\u0002J%\u0002\r\u0011\"\u00034\u00031\u0019wN\u001c8fGRLwN\\%e\u0011%\ti%\u000ba\u0001\n\u0013\ty%\u0001\td_:tWm\u0019;j_:LEm\u0018\u0013fcR\u0019!-!\u0015\t\u0011\u0019\fY%!AA\u0002QBq!!\u0016*A\u0003&A'A\u0007d_:tWm\u0019;j_:LE\r\t\u0005\b\u00033JC\u0011AA.\u0003\u001d\u0019wN\u001c8fGR$\u0012A\u0019\u0005\b\u0003?JC\u0011AA.\u0003)!\u0017n]2p]:,7\r\u001e\u0005\u0007\u0003GJC\u0011A.\u0002\u0017%\u001c8i\u001c8oK\u000e$X\r\u001a\u0005\b\u0003OJC\u0011AA5\u0003\u0011\u0019XM\u001c3\u0015\t\u0005-\u0014\u0011\u000f\t\u0004\u001b\u00055\u0014bAA8\u001d\t!Aj\u001c8h\u0011!\t\u0019(!\u001aA\u0002\u0005U\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111\u0010\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u0000\u0005e$!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tK\"9\u00111Q\u0015\u0005\u0002\u0005\u0015\u0015a\u0002:fG\u0016Lg/\u001a\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u001c6\u0011\u00111\u0012\u0006\u0004\u0007\u00055%\u0002BAH\u0003#\u000baaY8n[>t'bA\u0003\u0002\u0014*!\u0011QSAL\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011T\u0001\u0004_J<\u0017\u0002BAO\u0003\u0017\u0013aBT3uo>\u00148NU3dK&4X\rC\u0004\u0002\"&\"I!a)\u0002\u001dI,\u0017\rZ\"p[BdW\r^3msR!\u0011qQAS\u0011\u0019Q\u0017q\u0014a\u0001\u007f\"\"\u0011F\b\u0014$Q\rI\u00131\u0016\t\u0004Y\u00055\u0016bAAX[\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class BlockingChannel
implements Logging {
    private final String host;
    private final int port;
    private final int readBufferSize;
    private final int writeBufferSize;
    private final int readTimeoutMs;
    private boolean connected;
    private SocketChannel channel;
    private ReadableByteChannel readChannel;
    private GatheringByteChannel writeChannel;
    private final Object lock;
    private final int connectTimeoutMs;
    private String connectionId;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int UseDefaultBufferSize() {
        return BlockingChannel$.MODULE$.UseDefaultBufferSize();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BlockingChannel blockingChannel = this;
        synchronized (blockingChannel) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int readBufferSize() {
        return this.readBufferSize;
    }

    public int writeBufferSize() {
        return this.writeBufferSize;
    }

    public int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean x$1) {
        this.connected = x$1;
    }

    private SocketChannel channel() {
        return this.channel;
    }

    private void channel_$eq(SocketChannel x$1) {
        this.channel = x$1;
    }

    private ReadableByteChannel readChannel() {
        return this.readChannel;
    }

    private void readChannel_$eq(ReadableByteChannel x$1) {
        this.readChannel = x$1;
    }

    private GatheringByteChannel writeChannel() {
        return this.writeChannel;
    }

    private void writeChannel_$eq(GatheringByteChannel x$1) {
        this.writeChannel = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private int connectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    private String connectionId() {
        return this.connectionId;
    }

    private void connectionId_$eq(String x$1) {
        this.connectionId = x$1;
    }

    public void connect() {
        Object object = this.lock();
        synchronized (object) {
            if (!this.connected()) {
                this.liftedTree1$1();
            }
        }
    }

    public void disconnect() {
        Object object = this.lock();
        synchronized (object) {
            if (this.channel() != null) {
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.channel().close());
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.channel().socket().close());
                this.channel_$eq(null);
                this.writeChannel_$eq(null);
            }
            if (this.readChannel() != null) {
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readChannel().close());
                this.readChannel_$eq(null);
            }
            this.connected_$eq(false);
        }
    }

    public boolean isConnected() {
        return this.connected();
    }

    public long send(RequestOrResponse request) {
        if (!this.connected()) {
            throw new ClosedChannelException();
        }
        RequestOrResponseSend send = new RequestOrResponseSend(this.connectionId(), request);
        return send.writeCompletely(this.writeChannel());
    }

    /*
     * WARNING - void declaration
     */
    public NetworkReceive receive() {
        void var1_1;
        if (!this.connected()) {
            throw new ClosedChannelException();
        }
        NetworkReceive response = this.readCompletely(this.readChannel());
        response.payload().rewind();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private NetworkReceive readCompletely(ReadableByteChannel channel) {
        void var2_2;
        NetworkReceive response = new NetworkReceive();
        while (!response.complete()) {
            response.readFromReadableChannel(channel);
        }
        return var2_2;
    }

    private final void liftedTree1$1() {
        try {
            this.channel_$eq(SocketChannel.open());
            if (this.readBufferSize() > 0) {
                this.channel().socket().setReceiveBufferSize(this.readBufferSize());
            }
            if (this.writeBufferSize() > 0) {
                this.channel().socket().setSendBufferSize(this.writeBufferSize());
            }
            this.channel().configureBlocking(true);
            this.channel().socket().setSoTimeout(this.readTimeoutMs());
            this.channel().socket().setKeepAlive(true);
            this.channel().socket().setTcpNoDelay(true);
            this.channel().socket().connect(new InetSocketAddress(this.host(), this.port()), this.connectTimeoutMs());
            this.writeChannel_$eq(this.channel());
            this.readChannel_$eq(Channels.newChannel(this.channel().socket().getInputStream()));
            this.connected_$eq(true);
            String localHost = this.channel().socket().getLocalAddress().getHostAddress();
            int localPort = this.channel().socket().getLocalPort();
            String remoteHost = this.channel().socket().getInetAddress().getHostAddress();
            int remotePort = this.channel().socket().getPort();
            this.connectionId_$eq(localHost + ":" + localPort + "-" + remoteHost + ":" + remotePort);
            String msg = "Created socket with SO_TIMEOUT = %d (requested %d), SO_RCVBUF = %d (requested %d), SO_SNDBUF = %d (requested %d), connectTimeoutMs = %d.";
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.channel().socket().getSoTimeout()), BoxesRunTime.boxToInteger((int)this.readTimeoutMs()), BoxesRunTime.boxToInteger((int)this.channel().socket().getReceiveBufferSize()), BoxesRunTime.boxToInteger((int)this.readBufferSize()), BoxesRunTime.boxToInteger((int)this.channel().socket().getSendBufferSize()), BoxesRunTime.boxToInteger((int)this.writeBufferSize()), BoxesRunTime.boxToInteger((int)this.connectTimeoutMs())})));
        }
        catch (Throwable throwable) {
            this.disconnect();
        }
    }

    public BlockingChannel(String host, int port, int readBufferSize, int writeBufferSize, int readTimeoutMs) {
        this.host = host;
        this.port = port;
        this.readBufferSize = readBufferSize;
        this.writeBufferSize = writeBufferSize;
        this.readTimeoutMs = readTimeoutMs;
        Logging.$init$(this);
        this.connected = false;
        this.channel = null;
        this.readChannel = null;
        this.writeChannel = null;
        this.lock = new Object();
        this.connectTimeoutMs = readTimeoutMs;
        this.connectionId = "";
    }
}

