/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ProducerPerformance;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ProducerPerformance$
implements Logging {
    public static ProducerPerformance$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ProducerPerformance$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ProducerPerformance$ producerPerformance$ = this;
        synchronized (producerPerformance$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        ProducerPerformance.ProducerPerfConfig config = new ProducerPerformance.ProducerPerfConfig(args);
        if (!config.isFixedSize()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("WARN: Throughput will be slower due to changing message size per request");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        AtomicLong totalBytesSent = new AtomicLong(0L);
        AtomicLong totalMessagesSent = new AtomicLong(0L);
        ExecutorService executor = Executors.newFixedThreadPool(config.numThreads());
        CountDownLatch allDone = new CountDownLatch(config.numThreads());
        long startMs = System.currentTimeMillis();
        Random rand = new Random();
        if (!config.hideHeader()) {
            Predef$.MODULE$.println((Object)"start.time, end.time, compression, message.size, batch.size, total.data.sent.in.MB, MB.sec, total.data.sent.in.nMsg, nMsg.sec");
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> executor.execute(new ProducerPerformance.ProducerThread(i, config, totalBytesSent, totalMessagesSent, allDone, rand)));
        allDone.await();
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        double totalMBSent = (double)totalBytesSent.get() * 1.0 / (double)0x100000;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s, %s, %d, %d, %d, %.2f, %.4f, %d, %.4f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)config.compressionCodec().codec()), BoxesRunTime.boxToInteger((int)config.messageSize()), BoxesRunTime.boxToInteger((int)config.batchSize()), BoxesRunTime.boxToDouble((double)totalMBSent), BoxesRunTime.boxToDouble((double)(totalMBSent / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesSent.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesSent.get() / elapsedSecs))})));
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private ProducerPerformance$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

