/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.common.NotificationHandler;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.common.ZkNodeChangeNotificationListener$ChangeNotificationHandler$;
import kafka.common.ZkNodeChangeNotificationListener$ZkStateChangeHandler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001\u001d\u0011\u0001EW6O_\u0012,7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u0019&\u001cH/\u001a8fe*\u00111\u0001B\u0001\u0007G>lWn\u001c8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\t\u0001B_6DY&,g\u000e^\u000b\u0002/A\u0011\u0001dG\u0007\u00023)\u0011!\u0004B\u0001\u0003u.L!\u0001H\r\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011!q\u0002A!A!\u0002\u00139\u0012!\u0003>l\u00072LWM\u001c;!\u0011!\u0001\u0003A!b\u0001\n\u0013\t\u0013aC:fc:{G-\u001a*p_R,\u0012A\t\t\u0003G)r!\u0001\n\u0015\u0011\u0005\u0015RQ\"\u0001\u0014\u000b\u0005\u001d2\u0011A\u0002\u001fs_>$h(\u0003\u0002*\u0015\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tI#\u0002\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003#\u00031\u0019X-\u001d(pI\u0016\u0014vn\u001c;!\u0011!\u0001\u0004A!b\u0001\n\u0013\t\u0013!D:fc:{G-\u001a)sK\u001aL\u0007\u0010\u0003\u00053\u0001\t\u0005\t\u0015!\u0003#\u00039\u0019X-\u001d(pI\u0016\u0004&/\u001a4jq\u0002B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%I!N\u0001\u0014]>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM]\u000b\u0002mA\u0011q\u0007O\u0007\u0002\u0005%\u0011\u0011H\u0001\u0002\u0014\u001d>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005m\u0005!bn\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7fe\u0002B\u0001\"\u0010\u0001\u0003\u0006\u0004%IAP\u0001\u0013G\"\fgnZ3FqBL'/\u0019;j_:l5/F\u0001@!\tI\u0001)\u0003\u0002B\u0015\t!Aj\u001c8h\u0011!\u0019\u0005A!A!\u0002\u0013y\u0014aE2iC:<W-\u0012=qSJ\fG/[8o\u001bN\u0004\u0003\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0002$\u0002\tQLW.Z\u000b\u0002\u000fB\u0011\u0001\nU\u0007\u0002\u0013*\u0011\u0011C\u0013\u0006\u0003\u0007-S!!\u0002'\u000b\u00055s\u0015AB1qC\u000eDWMC\u0001P\u0003\ry'oZ\u0005\u0003#&\u0013A\u0001V5nK\"A1\u000b\u0001B\u0001B\u0003%q)A\u0003uS6,\u0007\u0005C\u0003V\u0001\u0011\u0005a+\u0001\u0004=S:LGO\u0010\u000b\b/bK&l\u0017/^!\t9\u0004\u0001C\u0003\u0016)\u0002\u0007q\u0003C\u0003!)\u0002\u0007!\u0005C\u00031)\u0002\u0007!\u0005C\u00035)\u0002\u0007a\u0007C\u0004>)B\u0005\t\u0019A \t\u000f\u0015#\u0006\u0013!a\u0001\u000f\"9q\f\u0001a\u0001\n\u0013q\u0014A\u00057bgR,\u00050Z2vi\u0016$7\t[1oO\u0016Dq!\u0019\u0001A\u0002\u0013%!-\u0001\fmCN$X\t_3dkR,Gm\u00115b]\u001e,w\fJ3r)\t\u0019g\r\u0005\u0002\nI&\u0011QM\u0003\u0002\u0005+:LG\u000fC\u0004hA\u0006\u0005\t\u0019A \u0002\u0007a$\u0013\u0007\u0003\u0004j\u0001\u0001\u0006KaP\u0001\u0014Y\u0006\u001cH/\u0012=fGV$X\rZ\"iC:<W\r\t\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0003\u0015\tX/Z;f+\u0005i\u0007c\u00018vo6\tqN\u0003\u0002qc\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005I\u001c\u0018\u0001B;uS2T\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002w_\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB\u0011\u00010_\u0007\u0002\u0001\u0019!!\u0010\u0001\u0001|\u0005I\u0019\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8\u0014\u0005eD\u0001\"B+z\t\u0003iH#A<\t\r}LH\u0011AA\u0001\u0003\u001d\u0001(o\\2fgN$\u0012a\u0019\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003n\u0003\u0019\tX/Z;fA!I\u0011\u0011\u0002\u0001C\u0002\u0013%\u00111B\u0001\u0007i\"\u0014X-\u00193\u0016\u0005\u00055\u0001c\u0001=\u0002\u0010\u00191\u0011\u0011\u0003\u0001\u0001\u0003'\u0011\u0001d\u00115b]\u001e,WI^3oiB\u0013xnY3tgRC'/Z1e'\u0011\ty!!\u0006\u0011\u0007=\t9\"C\u0002\u0002\u001aA\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"a\u0011QDA\b\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002 \u0005!a.Y7f\u0013\u0011\ti\"a\u0006\t\u000fU\u000by\u0001\"\u0001\u0002$Q!\u0011QBA\u0013\u0011\u001d\ti\"!\tA\u0002\tB\u0001\"!\u000b\u0002\u0010\u0011\u0005\u0013\u0011A\u0001\u0007I><vN]6\t\u0011\u00055\u0002\u0001)A\u0005\u0003\u001b\tq\u0001\u001e5sK\u0006$\u0007\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024\u0005A\u0011n]\"m_N,G-\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<=\fa!\u0019;p[&\u001c\u0017\u0002BA \u0003s\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002CA\"\u0001\u0001\u0006I!!\u000e\u0002\u0013%\u001c8\t\\8tK\u0012\u0004\u0003bBA$\u0001\u0011\u0005\u0011\u0011A\u0001\u0005S:LG\u000fC\u0004\u0002L\u0001!\t!!\u0001\u0002\u000b\rdwn]3\t\u000f\u0005=\u0003\u0001\"\u0003\u0002\u0002\u0005!\u0002O]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]NDq!a\u0015\u0001\t\u0013\t)&A\nqe>\u001cWm]:O_RLg-[2bi&|g\u000eF\u0002d\u0003/Bq!!\u0017\u0002R\u0001\u0007!%\u0001\u0007o_RLg-[2bi&|g\u000eC\u0004\u0002^\u0001!I!!\u0001\u0002+\u0005$Gm\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]\"9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0014A\u00079ve\u001e,wJY:pY\u0016$XMT8uS\u001aL7-\u0019;j_:\u001cH#B2\u0002f\u0005%\u0004bBA4\u0003?\u0002\raP\u0001\u0004]><\b\u0002CA6\u0003?\u0002\r!!\u001c\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t!\u0015\ty'!\u001f#\u001d\u0011\t\t(!\u001e\u000f\u0007\u0015\n\u0019(C\u0001\f\u0013\r\t9HC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY(! \u0003\u0007M+\u0017OC\u0002\u0002x)Aq!!!\u0001\t\u0013\t\u0019)\u0001\u0007dQ\u0006tw-\u001a(v[\n,'\u000fF\u0002@\u0003\u000bCq!!\b\u0002\u0000\u0001\u0007!eB\u0004\u0002\n\u0002A\t!a#\u00023\rC\u0017M\\4f\u001d>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM\u001d\t\u0004q\u00065eaBAH\u0001!\u0005\u0011\u0011\u0013\u0002\u001a\u0007\"\fgnZ3O_RLg-[2bi&|g\u000eS1oI2,'oE\u0003\u0002\u000e\"\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI\nB\u0001\nu>|7.Z3qKJLA!!(\u0002\u0018\n9\"LT8eK\u000eC\u0017\u000e\u001c3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u0005\b+\u00065E\u0011AAQ)\t\tY\tC\u0005\u0002&\u00065%\u0019!C!C\u0005!\u0001/\u0019;i\u0011!\tI+!$!\u0002\u0013\u0011\u0013!\u00029bi\"\u0004\u0003\u0002CAW\u0003\u001b#\t%!\u0001\u0002#!\fg\u000e\u001a7f\u0007\"LG\u000eZ\"iC:<WmB\u0004\u00022\u0002A\t!a-\u0002)i[7\u000b^1uK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s!\rA\u0018Q\u0017\u0004\b\u0003o\u0003\u0001\u0012AA]\u0005QQ6n\u0015;bi\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feN)\u0011Q\u0017\u0005\u0002<B!\u0011QSA_\u0013\u0011\ty,a&\u0003%M#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u0005\b+\u0006UF\u0011AAb)\t\t\u0019\fC\u0005\u0002\u001e\u0005U&\u0019!C!C!A\u0011\u0011ZA[A\u0003%!%A\u0003oC6,\u0007\u0005\u0003\u0005\u0002N\u0006UF\u0011IA\u0001\u0003a\tg\r^3s\u0013:LG/[1mSjLgnZ*fgNLwN\\\u0004\n\u0003#\u0014\u0011\u0011!E\u0001\u0003'\f\u0001EW6O_\u0012,7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u0019&\u001cH/\u001a8feB\u0019q'!6\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003/\u001c2!!6\t\u0011\u001d)\u0016Q\u001bC\u0001\u00037$\"!a5\t\u0015\u0005}\u0017Q[I\u0001\n\u0003\t\t/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003GT3aPAsW\t\t9\u000f\u0005\u0003\u0002j\u0006MXBAAv\u0015\u0011\ti/a<\u0002\u0013Ut7\r[3dW\u0016$'bAAy\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00181\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA}\u0003+\f\n\u0011\"\u0001\u0002|\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!!@+\u0007\u001d\u000b)\u000f")
public class ZkNodeChangeNotificationListener
implements Logging {
    private volatile ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler$module;
    private volatile ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler$module;
    private final KafkaZkClient zkClient;
    private final String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    private final String seqNodePrefix;
    private final NotificationHandler notificationHandler;
    private final long changeExpirationMs;
    private final Time time;
    private long lastExecutedChange;
    private final LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue;
    private final ChangeEventProcessThread thread;
    private final AtomicBoolean isClosed;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$6() {
        return ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6();
    }

    public static long $lessinit$greater$default$5() {
        return ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkNodeChangeNotificationListener$ChangeNotificationHandler$ ChangeNotificationHandler() {
        if (this.ChangeNotificationHandler$module == null) {
            this.ChangeNotificationHandler$lzycompute$1();
        }
        return this.ChangeNotificationHandler$module;
    }

    public ZkNodeChangeNotificationListener$ZkStateChangeHandler$ ZkStateChangeHandler() {
        if (this.ZkStateChangeHandler$module == null) {
            this.ZkStateChangeHandler$lzycompute$1();
        }
        return this.ZkStateChangeHandler$module;
    }

    private Logger logger$lzycompute() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public String kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot;
    }

    private String seqNodePrefix() {
        return this.seqNodePrefix;
    }

    private NotificationHandler notificationHandler() {
        return this.notificationHandler;
    }

    private long changeExpirationMs() {
        return this.changeExpirationMs;
    }

    private Time time() {
        return this.time;
    }

    private long lastExecutedChange() {
        return this.lastExecutedChange;
    }

    private void lastExecutedChange_$eq(long x$1) {
        this.lastExecutedChange = x$1;
    }

    public LinkedBlockingQueue<ChangeNotification> kafka$common$ZkNodeChangeNotificationListener$$queue() {
        return this.kafka$common$ZkNodeChangeNotificationListener$$queue;
    }

    private ChangeEventProcessThread thread() {
        return this.thread;
    }

    private AtomicBoolean isClosed() {
        return this.isClosed;
    }

    public void init() {
        this.zkClient().registerStateChangeHandler(this.ZkStateChangeHandler());
        this.zkClient().registerZNodeChildChangeHandler(this.ChangeNotificationHandler());
        this.kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification();
        this.thread().start();
    }

    public void close() {
        this.isClosed().set(true);
        this.zkClient().unregisterStateChangeHandler(this.ZkStateChangeHandler().name());
        this.zkClient().unregisterZNodeChildChangeHandler(this.ChangeNotificationHandler().path());
        this.kafka$common$ZkNodeChangeNotificationListener$$queue().clear();
        this.thread().shutdown();
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$processNotifications() {
        try {
            Seq notifications = (Seq)this.zkClient().getChildren(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).sorted((Ordering)Ordering.String$.MODULE$);
            if (notifications.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Processing notification(s) to ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString());
                long now = this.time().milliseconds();
                notifications.foreach((Function1 & Serializable & scala.Serializable)notification -> {
                    ZkNodeChangeNotificationListener.$anonfun$processNotifications$2(this, notification);
                    return BoxedUnit.UNIT;
                });
                this.purgeObsoleteNotifications(now, (Seq<String>)notifications);
            }
        }
        catch (InterruptedException e) {
            if (!this.isClosed().get()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Error while processing notification change for path = ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Error while processing notification change for path = ").append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private void processNotification(String notification) {
        Option data;
        Option data2;
        String changeZnode = new StringBuilder(1).append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).append("/").append(notification).toString();
        Tuple2<Option<byte[]>, Stat> tuple2 = this.zkClient().getDataAndStat(changeZnode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = data2 = (Option)tuple2._1();
        Option option2 = data = option;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            byte[] d = (byte[])some.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.notificationHandler().processNotification(d));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("error processing change notification ").append(new String(d, StandardCharsets.UTF_8)).append(" from ").append(changeZnode).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("read null data from ").append(changeZnode).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option2);
        }
    }

    public void kafka$common$ZkNodeChangeNotificationListener$$addChangeNotification() {
        block0: {
            if (this.isClosed().get() || this.kafka$common$ZkNodeChangeNotificationListener$$queue().peek() != null) break block0;
            this.kafka$common$ZkNodeChangeNotificationListener$$queue().put(new ChangeNotification());
        }
    }

    private void purgeObsoleteNotifications(long now, Seq<String> notifications) {
        ((IterableLike)notifications.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)notification -> {
            Object object;
            String notificationNode = new StringBuilder(1).append(this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot()).append("/").append((String)notification).toString();
            Tuple2<Option<byte[]>, Stat> tuple2 = this.zkClient().getDataAndStat(notificationNode);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option data = (Option)tuple2._1();
            Stat stat = (Stat)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)data, (Object)stat);
            Tuple2 tuple23 = tuple22;
            Option data2 = (Option)tuple23._1();
            Stat stat2 = (Stat)tuple23._2();
            if (data2.isDefined()) {
                if (now - stat2.getCtime() > this.changeExpirationMs()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Purging change notification ").append(notificationNode).toString());
                    object = BoxesRunTime.boxToBoolean((boolean)this.zkClient().deletePath(notificationNode));
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    private long changeNumber(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(name.substring(this.seqNodePrefix().length()))).toLong();
    }

    private final void ChangeNotificationHandler$lzycompute$1() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (this.ChangeNotificationHandler$module == null) {
                this.ChangeNotificationHandler$module = new ZkNodeChangeNotificationListener$ChangeNotificationHandler$(this);
            }
        }
    }

    private final void ZkStateChangeHandler$lzycompute$1() {
        ZkNodeChangeNotificationListener zkNodeChangeNotificationListener = this;
        synchronized (zkNodeChangeNotificationListener) {
            if (this.ZkStateChangeHandler$module == null) {
                this.ZkStateChangeHandler$module = new ZkNodeChangeNotificationListener$ZkStateChangeHandler$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processNotifications$2(ZkNodeChangeNotificationListener $this, String notification) {
        block0: {
            long changeId = $this.changeNumber(notification);
            if (changeId <= $this.lastExecutedChange()) break block0;
            $this.processNotification(notification);
            $this.lastExecutedChange_$eq(changeId);
        }
    }

    public ZkNodeChangeNotificationListener(KafkaZkClient zkClient, String seqNodeRoot, String seqNodePrefix, NotificationHandler notificationHandler, long changeExpirationMs, Time time) {
        this.zkClient = zkClient;
        this.kafka$common$ZkNodeChangeNotificationListener$$seqNodeRoot = seqNodeRoot;
        this.seqNodePrefix = seqNodePrefix;
        this.notificationHandler = notificationHandler;
        this.changeExpirationMs = changeExpirationMs;
        this.time = time;
        Logging.$init$(this);
        this.lastExecutedChange = -1L;
        this.kafka$common$ZkNodeChangeNotificationListener$$queue = new LinkedBlockingQueue();
        this.thread = new ChangeEventProcessThread(new StringBuilder(21).append(seqNodeRoot).append("-event-process-thread").toString());
        this.isClosed = new AtomicBoolean(false);
    }

    public class ChangeEventProcessThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer().kafka$common$ZkNodeChangeNotificationListener$$queue().take().process();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeEventProcessThread$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeEventProcessThread(String name) {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
            super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public class ChangeNotification {
        public void process() {
            this.kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer().kafka$common$ZkNodeChangeNotificationListener$$processNotifications();
        }

        public /* synthetic */ ZkNodeChangeNotificationListener kafka$common$ZkNodeChangeNotificationListener$ChangeNotification$$$outer() {
            return ZkNodeChangeNotificationListener.this;
        }

        public ChangeNotification() {
            if (ZkNodeChangeNotificationListener.this == null) {
                throw null;
            }
        }
    }
}

