/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.QueueItem;
import kafka.controller.RequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005Mx!B\u0001\u0003\u0011\u00039\u0011\u0001G\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tA2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00039\u0012aE)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t11\u000b\u001e:j]\u001eDa!I\u0005!\u0002\u0013A\u0012\u0001F)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,\u0007\u0005C\u0004$\u0013\t\u0007I\u0011A\f\u0002CI+\u0017/^3tiJ\u000bG/Z!oIF+X-^3US6,W*\u001a;sS\u000et\u0015-\\3\t\r\u0015J\u0001\u0015!\u0003\u0019\u0003\t\u0012V-];fgR\u0014\u0016\r^3B]\u0012\fV/Z;f)&lW-T3ue&\u001cg*Y7fA!9q%CI\u0001\n\u0003A\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'F\u0001*U\tQs\u0007E\u0002\u000eW5J!\u0001\f\b\u0003\r=\u0003H/[8o!\tqSG\u0004\u00020gA\u0011\u0001GD\u0007\u0002c)\u0011!GB\u0001\u0007yI|w\u000e\u001e \n\u0005Qr\u0011A\u0002)sK\u0012,g-\u0003\u0002 m)\u0011AGD\u0016\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0010\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002@u\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0007\t)\u0011\u0001!Q\n\u0005\u00012\u0011\u0005\n\u0005\u0002D\r6\tAI\u0003\u0002F\t\u0005)Q\u000f^5mg&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h!\tIE*D\u0001K\u0015\tYE!A\u0004nKR\u0014\u0018nY:\n\u00055S%!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\"Aq\n\u0011B\u0001B\u0003%\u0001+A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\"\u0001C)\n\u0005I\u0013!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"AA\u000b\u0011B\u0001B\u0003%Q+\u0001\u0004d_:4\u0017n\u001a\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\taa]3sm\u0016\u0014\u0018B\u0001.X\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011q\u0003%\u0011!Q\u0001\nu\u000bA\u0001^5nKB\u0011alZ\u0007\u0002?*\u0011Q\t\u0019\u0006\u0003C\n\faaY8n[>t'BA\u0003d\u0015\t!W-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0006\u0019qN]4\n\u0005!|&\u0001\u0002+j[\u0016D\u0001b\u0013!\u0003\u0002\u0003\u0006IA\u001b\t\u0003W6l\u0011\u0001\u001c\u0006\u0003\u0017\u0002L!A\u001c7\u0003\u000f5+GO]5dg\"A\u0001\u000f\u0011B\u0001B\u0003%\u0011/A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\"\u0001\u0003:\n\u0005M\u0014!!E*uCR,7\t[1oO\u0016dunZ4fe\"AQ\u000f\u0011B\u0001B\u0003%!&\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\")1\u0003\u0011C\u0001oR9\u00010\u001f>|yvt\bC\u0001\u0005A\u0011\u0015ye\u000f1\u0001Q\u0011\u0015!f\u000f1\u0001V\u0011\u0015af\u000f1\u0001^\u0011\u0015Ye\u000f1\u0001k\u0011\u0015\u0001h\u000f1\u0001r\u0011\u001d)h\u000f%AA\u0002)B\u0011\"!\u0001A\u0005\u0004%\t\"a\u0001\u0002\u001f\t\u0014xn[3s'R\fG/Z%oM>,\"!!\u0002\u0011\u0011\u0005\u001d\u0011\u0011CA\u000b\u00037i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\b[V$\u0018M\u00197f\u0015\r\tyAD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\n\u0003\u0013\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u0002\u000e\u0003/I1!!\u0007\u000f\u0005\rIe\u000e\u001e\t\u0004\u0011\u0005u\u0011bAA\u0010\u0005\tI2i\u001c8ue>dG.\u001a:Ce>\\WM]*uCR,\u0017J\u001c4p\u0011!\t\u0019\u0003\u0011Q\u0001\n\u0005\u0015\u0011\u0001\u00052s_.,'o\u0015;bi\u0016LeNZ8!\u0011%\t9\u0003\u0011b\u0001\n\u0013\tI#\u0001\u0006ce>\\WM\u001d'pG.,\"!a\u000b\u0011\u0007e\ti#C\u0002\u00020i\u0011aa\u00142kK\u000e$\b\u0002CA\u001a\u0001\u0002\u0006I!a\u000b\u0002\u0017\t\u0014xn[3s\u0019>\u001c7\u000e\t\u0005\b\u0003o\u0001E\u0011AA\u001d\u0003\u001d\u0019H/\u0019:ukB$\"!a\u000f\u0011\u00075\ti$C\u0002\u0002@9\u0011A!\u00168ji\"9\u00111\t!\u0005\u0002\u0005e\u0012\u0001C:ikR$wn\u001e8\t\u000f\u0005\u001d\u0003\t\"\u0001\u0002J\u0005Y1/\u001a8e%\u0016\fX/Z:u))\tY$a\u0013\u0002P\u0005}\u0013q\u0012\u0005\t\u0003\u001b\n)\u00051\u0001\u0002\u0016\u0005A!M]8lKJLE\r\u0003\u0005\u0002R\u0005\u0015\u0003\u0019AA*\u0003\u0019\t\u0007/[&fsB!\u0011QKA.\u001b\t\t9FC\u0002\u0002Z\u0001\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003;\n9FA\u0004Ba&\\U-_:\t\u0011\u0005\u0005\u0014Q\ta\u0001\u0003G\nqA]3rk\u0016\u001cH\u000f\r\u0003\u0002f\u0005u\u0004CBA4\u0003g\nIH\u0004\u0003\u0002j\u0005=TBAA6\u0015\r\ti\u0007Y\u0001\te\u0016\fX/Z:ug&!\u0011\u0011OA6\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0002BA;\u0003o\u0012qAQ;jY\u0012,'O\u0003\u0003\u0002r\u0005-\u0004\u0003BA>\u0003{b\u0001\u0001\u0002\u0007\u0002\u0000\u0005}\u0013\u0011!A\u0001\u0006\u0003\t\tIA\u0002`IE\nB!a!\u0002\nB\u0019Q\"!\"\n\u0007\u0005\u001deBA\u0004O_RD\u0017N\\4\u0011\t\u0005%\u00141R\u0005\u0005\u0003\u001b\u000bYGA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011)\t\t*!\u0012\u0011\u0002\u0003\u0007\u00111S\u0001\tG\u0006dGNY1dWB9Q\"!&\u0002\u001a\u0006m\u0012bAAL\u001d\tIa)\u001e8di&|g.\r\t\u0005\u0003S\nY*\u0003\u0003\u0002\u001e\u0006-$\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0011\u001d\t\t\u000b\u0011C\u0001\u0003G\u000b\u0011\"\u00193e\u0005J|7.\u001a:\u0015\t\u0005m\u0012Q\u0015\u0005\t\u0003O\u000by\n1\u0001\u0002*\u00061!M]8lKJ\u0004B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_#\u0011aB2mkN$XM]\u0005\u0005\u0003g\u000biK\u0001\u0004Ce>\\WM\u001d\u0005\b\u0003o\u0003E\u0011AA]\u00031\u0011X-\\8wK\n\u0013xn[3s)\u0011\tY$a/\t\u0011\u00055\u0013Q\u0017a\u0001\u0003+Aq!a0A\t\u0013\t\t-\u0001\u0007bI\u0012tUm\u001e\"s_.,'\u000f\u0006\u0003\u0002<\u0005\r\u0007\u0002CAT\u0003{\u0003\r!!+\t\u000f\u0005\u001d\u0007\t\"\u0003\u0002J\u0006\u0001\"M]8lKJlU\r\u001e:jGR\u000bwm\u001d\u000b\u0005\u0003\u0017\f9\u000e\u0005\u0004\u0002N\u0006M\u0007\u0004G\u0007\u0003\u0003\u001fTA!!5\u0002\u000e\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003+\fyMA\u0002NCBD\u0001\"!\u0014\u0002F\u0002\u0007\u0011Q\u0003\u0005\b\u00037\u0004E\u0011BAo\u0003Q\u0011X-\\8wK\u0016C\u0018n\u001d;j]\u001e\u0014%o\\6feR!\u00111HAp\u0011!\t\t/!7A\u0002\u0005m\u0011a\u00032s_.,'o\u0015;bi\u0016Dq!!:A\t#\t9/\u0001\fti\u0006\u0014HOU3rk\u0016\u001cHoU3oIRC'/Z1e)\u0011\tY$!;\t\u0011\u00055\u00131\u001da\u0001\u0003+A\u0011\"!<A#\u0003%\t!a<\u0002+M,g\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u001f\u0016\u0004\u0003';\u0004")
public class ControllerChannelManager
implements KafkaMetricsGroup {
    private final ControllerContext controllerContext;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object kafka$controller$ControllerChannelManager$$brokerLock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return ControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static String RequestRateAndQueueTimeMetricName() {
        return ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName();
    }

    public static String QueueSizeMetricName() {
        return ControllerChannelManager$.MODULE$.QueueSizeMetricName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ControllerChannelManager controllerChannelManager = this;
        synchronized (controllerChannelManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    public Object kafka$controller$ControllerChannelManager$$brokerLock() {
        return this.kafka$controller$ControllerChannelManager$$brokerLock;
    }

    public void startup() {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
        }
    }

    public void shutdown() {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void sendRequest(int brokerId, ApiKeys apiKey, AbstractRequest.Builder<? extends AbstractRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            Option stateInfoOpt;
            Option option = stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ControllerBrokerStateInfo stateInfo = (ControllerBrokerStateInfo)some.value();
                stateInfo.messageQueue().put(new QueueItem(apiKey, request, callback, this.time.milliseconds()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Not sending request ").append(request).append(" to broker ").append(brokerId).append(", since it is offline.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$4() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.kafka$controller$ControllerChannelManager$$brokerLock();
        synchronized (object) {
            this.removeExistingBroker((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
        }
    }

    private void addNewBroker(Broker broker) {
        String string;
        LinkedBlockingQueue<QueueItem> messageQueue = new LinkedBlockingQueue<QueueItem>();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        Node brokerNode = broker.node(this.config.interBrokerListenerName());
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.config.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)this.config.interBrokerListenerName(), (String)this.config.saslMechanismInterBrokerProtocol(), (boolean)this.config.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{brokerNode}))).asJava()), ((Object)BoxesRunTime.boxToInteger((int)this.config.brokerId())).toString(), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), this.time, false, new ApiVersions(), logContext);
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        String threadName = string;
        Timer requestRateAndQueueTimeMetrics = this.newTimer(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, (Map<String, String>)this.brokerMetricTags(broker.id()));
        RequestSendThread requestThread = new RequestSendThread(this.config.brokerId(), this.controllerContext, messageQueue, networkClient, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, threadName);
        requestThread.setDaemon(false);
        Gauge<Object> queueSizeGauge = this.newGauge(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), (Gauge)new Gauge<Object>(null, messageQueue){
            private final LinkedBlockingQueue messageQueue$1;

            public int value() {
                return this.messageQueue$1.size();
            }
            {
                this.messageQueue$1 = messageQueue$1;
            }
        }, (Map<String, String>)this.brokerMetricTags(broker.id()));
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo(networkClient, brokerNode, messageQueue, requestThread, queueSizeGauge, requestRateAndQueueTimeMetrics));
    }

    private scala.collection.immutable.Map<String, String> brokerMetricTags(int brokerId) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString())}));
    }

    private void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
        try {
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().clear();
            this.removeMetric(ControllerChannelManager$.MODULE$.QueueSizeMetricName(), (Map<String, String>)this.brokerMetricTags(brokerState.brokerNode().id()));
            this.removeMetric(ControllerChannelManager$.MODULE$.RequestRateAndQueueTimeMetricName(), (Map<String, String>)this.brokerMetricTags(brokerState.brokerNode().id()));
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void startRequestSendThread(int brokerId) {
        block0: {
            RequestSendThread requestThread = ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
            Thread.State state = requestThread.getState();
            Thread.State state2 = Thread.State.NEW;
            if (state != null ? !((Object)((Object)state)).equals((Object)state2) : state2 != null) break block0;
            requestThread.start();
        }
    }

    public ControllerChannelManager(ControllerContext controllerContext, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerContext = controllerContext;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.brokerStateInfo = new HashMap();
        this.kafka$controller$ControllerChannelManager$$brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.newGauge("TotalQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ControllerChannelManager $outer;

            public int value() {
                int n;
                Object object = this.$outer.kafka$controller$ControllerChannelManager$$brokerLock();
                synchronized (object) {
                    n = BoxesRunTime.unboxToInt((Object)this.$outer.brokerStateInfo().values().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$1(x$1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                return n;
            }

            public static final /* synthetic */ int $anonfun$value$1(ControllerBrokerStateInfo x$1) {
                return x$1.messageQueue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.controller.ControllerBrokerStateInfo )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        controllerContext.liveBrokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
    }
}

