/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager$;
import kafka.controller.ControllerState;
import kafka.controller.ControllerState$Idle$;
import kafka.controller.KafkaController$ShutdownEventThread$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaTimer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=u!B\u0001\u0003\u0011\u00039\u0011AF\"p]R\u0014x\u000e\u001c7fe\u00163XM\u001c;NC:\fw-\u001a:\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003-\r{g\u000e\u001e:pY2,'/\u0012<f]Rl\u0015M\\1hKJ\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u0017\u0013\t\u0007I\u0011A\f\u00023\r{g\u000e\u001e:pY2,'/\u0012<f]R$\u0006N]3bI:\u000bW.Z\u000b\u00021A\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB*ue&tw\r\u0003\u0004\"\u0013\u0001\u0006I\u0001G\u0001\u001b\u0007>tGO]8mY\u0016\u0014XI^3oiRC'/Z1e\u001d\u0006lW\r\t\u0004\u0005\u0015\t\u00011eE\u0002#\u0019\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u0003\u0002\u000f5,GO]5dg&\u0011\u0011F\n\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002C\u0016#\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0011\u00055i\u0013B\u0001\u0018\u000f\u0005\rIe\u000e\u001e\u0005\ta\t\u0012\t\u0011)A\u0005c\u0005\u0011\"/\u0019;f\u0003:$G+[7f\u001b\u0016$(/[2t!\u0011\u0011Tg\u000e\u001e\u000e\u0003MR!\u0001\u000e\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00027g\t\u0019Q*\u00199\u0011\u0005!A\u0014BA\u001d\u0003\u0005=\u0019uN\u001c;s_2dWM]*uCR,\u0007CA\u0013<\u0013\tadE\u0001\u0006LC\u001a\\\u0017\rV5nKJD\u0001B\u0010\u0012\u0003\u0002\u0003\u0006IaP\u0001\u0017KZ,g\u000e\u001e)s_\u000e,7o]3e\u0019&\u001cH/\u001a8feB!Q\u0002\u0011\"F\u0013\t\teBA\u0005Gk:\u001cG/[8ocA\u0011\u0001bQ\u0005\u0003\t\n\u0011qbQ8oiJ|G\u000e\\3s\u000bZ,g\u000e\u001e\t\u0003\u001b\u0019K!a\u0012\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006'\t\"\t!\u0013\u000b\u0005\u0015.cU\n\u0005\u0002\tE!)1\u0006\u0013a\u0001Y!)\u0001\u0007\u0013a\u0001c!)a\b\u0013a\u0001\u007f!9qJ\ta\u0001\n\u0013\u0001\u0016AB0ti\u0006$X-F\u00018\u0011\u001d\u0011&\u00051A\u0005\nM\u000b!bX:uCR,w\fJ3r)\t)E\u000bC\u0004V#\u0006\u0005\t\u0019A\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004XE\u0001\u0006KaN\u0001\b?N$\u0018\r^3!Q\t1\u0016\f\u0005\u0002\u000e5&\u00111L\u0004\u0002\tm>d\u0017\r^5mK\"9QL\tb\u0001\n\u0013q\u0016a\u00029vi2{7m[\u000b\u0002?B\u0011\u0001mZ\u0007\u0002C*\u0011!mY\u0001\u0006Y>\u001c7n\u001d\u0006\u0003I\u0016\f!bY8oGV\u0014(/\u001a8u\u0015\t1G$\u0001\u0003vi&d\u0017B\u00015b\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\"1!N\tQ\u0001\n}\u000b\u0001\u0002];u\u0019>\u001c7\u000e\t\u0005\bY\n\u0012\r\u0011\"\u0003n\u0003\u0015\tX/Z;f+\u0005q\u0007cA8q\u00056\t1-\u0003\u0002rG\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vK\"11O\tQ\u0001\n9\fa!];fk\u0016\u0004\u0003bB;#\u0005\u0004%IA^\u0001\u0007i\"\u0014X-\u00193\u0016\u0003]\u0004\"\u0001_=\u000e\u0003\t2AA\u001f\u0012\u0001w\n)2i\u001c8ue>dG.\u001a:Fm\u0016tG\u000f\u00165sK\u0006$7CA=}!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010B\u0001\u0006kRLGn]\u0005\u0004\u0003\u0007q(AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012DA\"a\u0002z\u0005\u0003\u0005\u000b\u0011BA\u0005\u0003;\tAA\\1nKB!\u00111BA\r\u001d\u0011\ti!!\u0006\u0011\u0007\u0005=a\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0004\u0002\rq\u0012xn\u001c;?\u0013\r\t9BD\u0001\u0007!J,G-\u001a4\n\u0007}\tYBC\u0002\u0002\u00189IA!a\u0002\u0002\u0002!11#\u001fC\u0001\u0003C!2a^A\u0012\u0011!\t9!a\bA\u0002\u0005%\u0001bBA\u0014s\u0012\u0005\u0013\u0011F\u0001\u0007I><vN]6\u0015\u0003\u0015Cq!!\f#A\u0003%q/A\u0004uQJ,\u0017\r\u001a\u0011\t\u0013\u0005E\"E1A\u0005\n\u0005M\u0012\u0001\u0002;j[\u0016,\"!!\u000e\u0011\t\u0005]\u0012\u0011J\u0007\u0003\u0003sQ1a`A\u001e\u0015\u0011\ti$a\u0010\u0002\r\r|W.\\8o\u0015\r)\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\n1a\u001c:h\u0013\u0011\tY%!\u000f\u0003\tQKW.\u001a\u0005\t\u0003\u001f\u0012\u0003\u0015!\u0003\u00026\u0005)A/[7fA!I\u00111\u000b\u0012C\u0002\u0013%\u0011QK\u0001\u0013KZ,g\u000e^)vKV,G+[7f\u0011&\u001cH/\u0006\u0002\u0002XA!\u0011\u0011LA5\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013\u0001B2pe\u0016T1aJA1\u0015\u0011\t\u0019'!\u001a\u0002\re\fW.\\3s\u0015\t\t9'A\u0002d_6LA!a\u001b\u0002\\\tI\u0001*[:u_\u001e\u0014\u0018-\u001c\u0005\t\u0003_\u0012\u0003\u0015!\u0003\u0002X\u0005\u0019RM^3oiF+X-^3US6,\u0007*[:uA!1\u00111\u000f\u0012\u0005\u0002A\u000bQa\u001d;bi\u0016Dq!a\u001e#\t\u0003\tI#A\u0003ti\u0006\u0014H\u000fC\u0004\u0002|\t\"\t!!\u000b\u0002\u000b\rdwn]3\t\u000f\u0005}$\u0005\"\u0001\u0002\u0002\u0006\u0019\u0001/\u001e;\u0015\u0007\u0015\u000b\u0019\tC\u0004\u0002\u0006\u0006u\u0004\u0019\u0001\"\u0002\u000b\u00154XM\u001c;\t\u000f\u0005%%\u0005\"\u0001\u0002\f\u0006Y1\r\\3be\u0006sG\rU;u)\r)\u0015Q\u0012\u0005\b\u0003\u000b\u000b9\t1\u0001C\u0001")
public class ControllerEventManager
implements KafkaMetricsGroup {
    public final int kafka$controller$ControllerEventManager$$controllerId;
    public final Map<ControllerState, KafkaTimer> kafka$controller$ControllerEventManager$$rateAndTimeMetrics;
    public final Function1<ControllerEvent, BoxedUnit> kafka$controller$ControllerEventManager$$eventProcessedListener;
    private volatile ControllerState kafka$controller$ControllerEventManager$$_state;
    private final ReentrantLock putLock;
    private final LinkedBlockingQueue<ControllerEvent> kafka$controller$ControllerEventManager$$queue;
    private final ControllerEventThread thread;
    private final Time kafka$controller$ControllerEventManager$$time;
    private final Histogram kafka$controller$ControllerEventManager$$eventQueueTimeHist;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String ControllerEventThreadName() {
        return ControllerEventManager$.MODULE$.ControllerEventThreadName();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ControllerEventManager controllerEventManager = this;
        synchronized (controllerEventManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ControllerState kafka$controller$ControllerEventManager$$_state() {
        return this.kafka$controller$ControllerEventManager$$_state;
    }

    public void kafka$controller$ControllerEventManager$$_state_$eq(ControllerState x$1) {
        this.kafka$controller$ControllerEventManager$$_state = x$1;
    }

    private ReentrantLock putLock() {
        return this.putLock;
    }

    public LinkedBlockingQueue<ControllerEvent> kafka$controller$ControllerEventManager$$queue() {
        return this.kafka$controller$ControllerEventManager$$queue;
    }

    private ControllerEventThread thread() {
        return this.thread;
    }

    public Time kafka$controller$ControllerEventManager$$time() {
        return this.kafka$controller$ControllerEventManager$$time;
    }

    public Histogram kafka$controller$ControllerEventManager$$eventQueueTimeHist() {
        return this.kafka$controller$ControllerEventManager$$eventQueueTimeHist;
    }

    public ControllerState state() {
        return this.kafka$controller$ControllerEventManager$$_state();
    }

    public void start() {
        this.thread().start();
    }

    public void close() {
        this.clearAndPut(KafkaController$ShutdownEventThread$.MODULE$);
        this.thread().awaitShutdown();
    }

    public void put(ControllerEvent event) {
        CoreUtils$.MODULE$.inLock(this.putLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.kafka$controller$ControllerEventManager$$queue().put(event));
    }

    public void clearAndPut(ControllerEvent event) {
        CoreUtils$.MODULE$.inLock(this.putLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.kafka$controller$ControllerEventManager$$queue().clear();
            this.put(event);
        });
    }

    public ControllerEventManager(int controllerId, Map<ControllerState, KafkaTimer> rateAndTimeMetrics, Function1<ControllerEvent, BoxedUnit> eventProcessedListener) {
        this.kafka$controller$ControllerEventManager$$controllerId = controllerId;
        this.kafka$controller$ControllerEventManager$$rateAndTimeMetrics = rateAndTimeMetrics;
        this.kafka$controller$ControllerEventManager$$eventProcessedListener = eventProcessedListener;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$controller$ControllerEventManager$$_state = ControllerState$Idle$.MODULE$;
        this.putLock = new ReentrantLock();
        this.kafka$controller$ControllerEventManager$$queue = new LinkedBlockingQueue();
        this.thread = new ControllerEventThread(ControllerEventManager$.MODULE$.ControllerEventThreadName());
        this.kafka$controller$ControllerEventManager$$time = Time.SYSTEM;
        this.kafka$controller$ControllerEventManager$$eventQueueTimeHist = this.newHistogram("EventQueueTimeMs", this.newHistogram$default$2(), this.newHistogram$default$3());
        this.newGauge("EventQueueSize", new Gauge<Object>(this){
            private final /* synthetic */ ControllerEventManager $outer;

            public int value() {
                return this.$outer.kafka$controller$ControllerEventManager$$queue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class ControllerEventThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            ControllerEvent controllerEvent = this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$queue().take();
            if (KafkaController$ShutdownEventThread$.MODULE$.equals(controllerEvent)) {
                this.initiateShutdown();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object;
                Object object2;
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$_state_$eq(controllerEvent.state());
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$eventQueueTimeHist().update(this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$time().milliseconds() - controllerEvent.enqueueTimeMs());
                try {
                    object2 = ((KafkaTimer)this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$rateAndTimeMetrics.apply((Object)this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().state())).time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> controllerEvent.process());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error processing event ").append(controllerEvent).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    object2 = BoxedUnit.UNIT;
                }
                try {
                    object = this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$eventProcessedListener.apply((Object)controllerEvent);
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Error while invoking listener for processed event ").append(controllerEvent).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    object = BoxedUnit.UNIT;
                }
                this.kafka$controller$ControllerEventManager$ControllerEventThread$$$outer().kafka$controller$ControllerEventManager$$_state_$eq(ControllerState$Idle$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public /* synthetic */ ControllerEventManager kafka$controller$ControllerEventManager$ControllerEventThread$$$outer() {
            return ControllerEventManager.this;
        }

        public ControllerEventThread(String name) {
            if (ControllerEventManager.this == null) {
                throw null;
            }
            super(name, false);
            this.logIdent_$eq(new StringBuilder(38).append("[ControllerEventThread controllerId=").append(ControllerEventManager.this.kafka$controller$ControllerEventManager$$controllerId).append("] ").toString());
        }
    }
}

