/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005{W\u000ec\u0017.\u001a8u!\t\tC%D\u0001#\u0015\t\u0019C!\u0001\u0002{W&\u0011QE\t\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0011I#f\u000b\u0017\u0011\u0005Y\u0001\u0001\"B\u0002'\u0001\u0004)\u0002\"\u0002\u000e'\u0001\u0004Y\u0002\"B\u0010'\u0001\u0004\u0001\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0019\u0011\u0005Y\t\u0014B\u0001\u001a\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0019\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003QI7\u000fR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fIV\t\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\u000f\t{w\u000e\\3b]\"1\u0011\t\u0001Q\u0001\na\nQ#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$\u0007\u0005C\u0004D\u0001\t\u0007I\u0011\u0001#\u0002#Q|\u0007/[2t)>\u0014U\rR3mKR,G-F\u0001F!\r15*T\u0007\u0002\u000f*\u0011\u0001*S\u0001\b[V$\u0018M\u00197f\u0015\tQ%\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001T$\u0003\u0007M+G\u000f\u0005\u0002O+:\u0011qj\u0015\t\u0003!*i\u0011!\u0015\u0006\u0003%\u001a\ta\u0001\u0010:p_Rt\u0014B\u0001+\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005QS\u0001BB-\u0001A\u0003%Q)\u0001\nu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001X\u0001\u0016a\u0006\u0014H/\u001b;j_:\u001cHk\u001c\"f\t\u0016dW\r^3e+\u0005i\u0006c\u0001$L=B\u0011qlZ\u0007\u0002A*\u0011\u0011MY\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0019'B\u00013f\u0003\u0019\t\u0007/Y2iK*\ta-A\u0002pe\u001eL!\u0001\u001b1\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1!\u000e\u0001Q\u0001\nu\u000ba\u0003]1si&$\u0018n\u001c8t)>\u0014U\rR3mKR,G\r\t\u0005\bY\u0002\u0011\r\u0011\"\u0001E\u0003m!x\u000e]5dg&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]\"1a\u000e\u0001Q\u0001\n\u0015\u000bA\u0004^8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007\u0005C\u0003q\u0001\u0011\u0005\u0011/\u0001\u0003j]&$Hc\u0001:vuB\u0011\u0011b]\u0005\u0003i*\u0011A!\u00168ji\")ao\u001ca\u0001o\u0006A\u0012N\\5uS\u0006dGk\u001c9jGN$vNQ3EK2,G/\u001a3\u0011\u0007aLX*D\u0001J\u0013\ta\u0015\nC\u0003|_\u0002\u0007q/\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0006{\u0002!\tA`\u0001\u0011iJLHk\u001c9jG\u0012+G.\u001a;j_:$\u0012A\u001d\u0005\u0007\u0003\u0003\u0001A\u0011\u0001@\u0002\u000bI,7/\u001a;\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005ARM\\9vKV,Gk\u001c9jGN4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007I\fI\u0001C\u0004\u0002\f\u0005\r\u0001\u0019A<\u0002\rQ|\u0007/[2t\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\tqC]3tk6,G)\u001a7fi&|gNR8s)>\u0004\u0018nY:\u0015\u0007I\f\u0019\u0002C\u0005\u0002\f\u00055\u0001\u0013!a\u0001o\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011a\u00054bS2\u0014V\r\u001d7jG\u0006$U\r\\3uS>tGc\u0001:\u0002\u001c!A\u0011QDA\u000b\u0001\u0004\ty\"\u0001\u0005sKBd\u0017nY1t!\u0011A\u00180!\t\u0011\u0007Y\t\u0019#C\u0002\u0002&\t\u00111\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!!\u000b\u0001\t\u0003\tY#\u0001\u0010nCJ\\Gk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R\u0019!/!\f\t\u000f\u0005-\u0011q\u0005a\u0001o\"9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0012\u0001H5t)>\u0004\u0018nY%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0005\u0003k\tI\u0004E\u0002\n\u0003oI!a\u0010\u0006\t\u000f\u0005m\u0012q\u0006a\u0001\u001b\u0006)Ao\u001c9jG\"9\u0011q\b\u0001\u0005\n\u0005\u0005\u0013!G5t)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8J]B\u0013xn\u001a:fgN$B!!\u000e\u0002D!9\u00111HA\u001f\u0001\u0004i\u0005bBA$\u0001\u0011\u0005\u0011\u0011J\u0001\u0017SN\u0004\u0016M\u001d;ji&|g\u000eV8CK\u0012+G.\u001a;fIR!\u0011QGA&\u0011\u001d\ti%!\u0012A\u0002y\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'\n!$[:U_BL7-U;fk\u0016$W\u000b\u001d$pe\u0012+G.\u001a;j_:$B!!\u000e\u0002V!9\u00111HA(\u0001\u0004i\u0005bBA-\u0001\u0011\u0005\u00111L\u0001\u0018G>l\u0007\u000f\\3uKJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:$2A]A/\u0011!\ti\"a\u0016A\u0002\u0005}\u0001bBA1\u0001\u0011%\u00111M\u0001\u001bSN$v\u000e]5d\u000b2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0005\u0003k\t)\u0007C\u0004\u0002<\u0005}\u0003\u0019A'\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l\u0005IR.\u0019:l)>\u0004\u0018n\u0019$pe\u0012+G.\u001a;j_:\u0014V\r\u001e:z)\r\u0011\u0018Q\u000e\u0005\b\u0003w\t9\u00071\u0001N\u0011\u001d\t\t\b\u0001C\u0005\u0003g\n1cY8na2,G/\u001a#fY\u0016$X\rV8qS\u000e$2A]A;\u0011\u001d\tY$a\u001cA\u00025Cq!!\u001f\u0001\t\u0013\tY(A\bp]R{\u0007/[2EK2,G/[8o)\r\u0011\u0018Q\u0010\u0005\b\u0003\u0017\t9\b1\u0001x\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000bAc\u001d;beR\u0014V\r\u001d7jG\u0006$U\r\\3uS>tGc\u0001:\u0002\u0006\"A\u0011qQA@\u0001\u0004\ty\"\u0001\u000fsKBd\u0017nY1t\r>\u0014Hk\u001c9jGN$vNQ3EK2,G/\u001a3\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\u0006\u0019rN\u001c)beRLG/[8o\t\u0016dW\r^5p]R\u0019!/a$\t\u000fm\u000bI\t1\u0001\u0002\u0012B\u0019\u00010\u001f0\t\r\u0005U\u0005\u0001\"\u0003\u007f\u0003=\u0011Xm];nK\u0012+G.\u001a;j_:\u001c\b\"CAM\u0001E\u0005I\u0011AAN\u0003\u0005\u0012Xm];nK\u0012+G.\u001a;j_:4uN\u001d+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiJK\u0002x\u0003?[#!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WS\u0011AC1o]>$\u0018\r^5p]&!\u0011qVAS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TopicDeletionManager
implements Logging {
    private final KafkaController controller;
    private final ControllerEventManager eventManager;
    private final KafkaZkClient zkClient;
    private final ControllerContext controllerContext;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)this.topicsToBeDeleted().flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), scala.collection.mutable.Set$.MODULE$.canBuildFrom()));
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
            this.zkClient.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq());
        }
    }

    public void tryTopicDeletion() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.resumeDeletions();
        }
    }

    public void reset() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom()));
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) break block0;
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
            this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).toString());
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    private void markTopicForDeletionRetry(String topic) {
        scala.collection.immutable.Set<PartitionAndReplica> failedReplicas = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Retrying delete topic for topic ").append(topic).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
    }

    private void completeDeleteTopic(String topic) {
        this.controller.unregisterPartitionModificationsHandlers((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        scala.collection.immutable.Set<PartitionAndReplica> replicasForDeletedTopic = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), OfflinePartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
        this.controller.partitionStateMachine().handleStateChanges((Seq<TopicPartition>)partitionsForDeletedTopic.toSeq(), NonExistentPartition$.MODULE$, this.controller.partitionStateMachine().handleStateChanges$default$3());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$completeDeleteTopic$1(topic, x$2)));
        this.zkClient.deleteTopicZNode(topic);
        this.zkClient.deleteTopicConfigs((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.zkClient.deleteTopicDeletions((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        this.controllerContext().removeTopic(topic);
    }

    private void onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Topic deletion callback for ").append(topics.mkString(",")).toString());
        Set partitions = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
        this.controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)partitions);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.onPartitionDeletion(this.controllerContext().partitionsForTopic(topic));
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic()).keys().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, topic);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Partition deletion callback for ").append(partitionsToBeDeleted.mkString(",")).toString());
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handling deletion for topics ").append(topicsQueuedForDeletion.mkString(",")).toString());
        }
        topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$resumeDeletions$2(this, topic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$completeDeleteTopic$1(String topic$2, TopicPartition x$2) {
        String string = x$2.topic();
        String string2 = topic$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$3, PartitionAndReplica p) {
        String string = p.topic();
        String string2 = topic$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, String topic) {
        block0: {
            Set aliveReplicasForTopic = (Set)$this.controllerContext().allLiveReplicas().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
            scala.collection.immutable.Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$, $this.controller.replicaStateMachine().handleStateChanges$default$3());
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$, $this.controller.replicaStateMachine().handleStateChanges$default$3());
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion started for replicas ").append(replicasForDeletionRetry.mkString(",")).toString());
            $this.controller.replicaStateMachine().handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$, new Callbacks((Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(stopReplicaResponseObj, replicaId) -> {
                $this.eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived($this.controller, stopReplicaResponseObj, BoxesRunTime.unboxToInt((Object)replicaId)));
                return BoxedUnit.UNIT;
            }));
            if (!deadReplicasForTopic.nonEmpty()) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Dead Replicas (").append(deadReplicasForTopic.mkString(",")).append(") found for topic ").append(topic).toString());
            $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        }
    }

    public static final /* synthetic */ void $anonfun$resumeDeletions$2(TopicDeletionManager $this, String topic) {
        block6: {
            block5: {
                if ($this.controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    $this.completeDeleteTopic(topic);
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append(topic).append(" successfully completed").toString());
                } else if ($this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    scala.collection.immutable.Set<PartitionAndReplica> replicasInDeletionStartedState = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    scala.collection.immutable.Set replicaIds = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.replica()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.topicPartition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion for replicas ").append(replicaIds.mkString(",")).append(" for partition ").append(partitions.mkString(",")).append(" of topic ").append(topic).append(" in progress").toString());
                } else if ($this.controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    $this.markTopicForDeletionRetry(topic);
                }
                if (!$this.isTopicEligibleForDeletion(topic)) break block5;
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append(topic).append(" (re)started").toString());
                $this.onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                break block6;
            }
            if (!$this.isTopicIneligibleForDeletion(topic)) break block6;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Not retrying deletion of topic ").append(topic).append(" at this time since it is marked ineligible for deletion").toString());
        }
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager, KafkaZkClient zkClient) {
        this.controller = controller;
        this.eventManager = eventManager;
        this.zkClient = zkClient;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(27).append("[Topic Deletion Manager ").append(controller.config().brokerId()).append("], ").toString());
        this.controllerContext = controller.controllerContext();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.partitionsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

