/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rUu!B\u0001\u0003\u0011\u00039\u0011a\u0005#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003'\u0011Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!Aa#\u0003b\u0001\n\u0003\u0011q#\u0001\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4t+\u0005A\u0002cA\r\u001fA5\t!D\u0003\u0002\u001c9\u00059Q.\u001e;bE2,'BA\u000f\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003?i\u00111aU3u!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001$A\fEs:\fW.[2TK\u000e,(/\u001b;z\u0007>tg-[4tA!91&\u0003b\u0001\n\u00039\u0012!E!mY\u0012Kh.Y7jG\u000e{gNZ5hg\"1Q&\u0003Q\u0001\na\t!#\u00117m\tft\u0017-\\5d\u0007>tg-[4tA!9q&\u0003b\u0001\n\u00139\u0012\u0001\u0005)fe\n\u0013xn[3s\u0007>tg-[4t\u0011\u0019\t\u0014\u0002)A\u00051\u0005\t\u0002+\u001a:Ce>\\WM]\"p]\u001aLwm\u001d\u0011\t\u000fMJ!\u0019!C\u0005i\u0005AB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:\u0016\u0003U\u00022AN\u001c!\u001b\u0005a\u0012BA\u0010\u001d\u0011\u0019I\u0014\u0002)A\u0005k\u0005IB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:!\u0011\u001dY\u0014B1A\u0005\u0002q\n1\u0003T5ti\u0016tWM]\"p]\u001aLwMU3hKb,\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000b\u0001\"\\1uG\"Lgn\u001a\u0006\u0003\u0005:\tA!\u001e;jY&\u0011Ai\u0010\u0002\u0006%\u0016<W\r\u001f\u0005\u0007\r&\u0001\u000b\u0011B\u001f\u0002)1K7\u000f^3oKJ\u001cuN\u001c4jOJ+w-\u001a=!\u0011\u001dA\u0015B1A\u0005\n]\ta\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm\u001d\u0005\u0007\u0015&\u0001\u000b\u0011\u0002\r\u0002/\u0011Kh.Y7jGB\u000b7o]<pe\u0012\u001cuN\u001c4jON\u0004\u0003\"\u0002'\n\t\u0003i\u0015\u0001E5t!\u0006\u001c8o^8sI\u000e{gNZ5h)\tq\u0015\u000b\u0005\u0002\u000e\u001f&\u0011\u0001K\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015\u00116\n1\u0001T\u0003\u0011q\u0017-\\3\u0011\u0005Q[fBA+Z!\t1f\"D\u0001X\u0015\tAf!\u0001\u0004=e>|GOP\u0005\u00035:\ta\u0001\u0015:fI\u00164\u0017BA\u0014]\u0015\tQf\u0002C\u0003_\u0013\u0011\u0005q,\u0001\u000bce>\\WM]\"p]\u001aLwmU=o_:LXn\u001d\u000b\u0004A&T\u0007cA1g':\u0011!\r\u001a\b\u0003-\u000eL\u0011aD\u0005\u0003K:\tq\u0001]1dW\u0006<W-\u0003\u0002hQ\n!A*[:u\u0015\t)g\u0002C\u0003S;\u0002\u00071\u000bC\u0003l;\u0002\u0007a*A\u000bnCR\u001c\u0007\u000eT5ti\u0016tWM](wKJ\u0014\u0018\u000eZ3\t\u000b5LA\u0011\u00018\u0002\u001fY\fG.\u001b3bi\u0016\u001cuN\u001c4jON$2a\u001c:z!\ti\u0001/\u0003\u0002r\u001d\t!QK\\5u\u0011\u0015\u0019H\u000e1\u0001u\u0003\u0015\u0001(o\u001c9t!\t)x/D\u0001w\u0015\t\u0011E%\u0003\u0002ym\nQ\u0001K]8qKJ$\u0018.Z:\t\u000bid\u0007\u0019\u0001(\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001eDQ\u0001`\u0005\u0005\nu\f\u0001\u0003]3s\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u0005y|\bc\u0001\u001c8'\")1o\u001fa\u0001i\"9\u00111A\u0005\u0005\n\u0005\u0015\u0011!\u00058p]\u0012Kh.Y7jG\u000e{gNZ5hgR\u0019a0a\u0002\t\rM\f\t\u00011\u0001u\u0011\u001d\tY!\u0003C\u0005\u0003\u001b\tAe]3dkJLG/_\"p]\u001aLwm],ji\"|W\u000f\u001e'jgR,g.\u001a:Qe\u00164\u0017\u000e\u001f\u000b\u0004}\u0006=\u0001BB:\u0002\n\u0001\u0007A\u000fC\u0004\u0002\u0014%!I!!\u0006\u0002'Y\fG.\u001b3bi\u0016\u001cuN\u001c4jORK\b/Z:\u0015\u0007=\f9\u0002\u0003\u0004t\u0003#\u0001\r\u0001\u001e\u0005\t\u00037IA\u0011\u0001\u0002\u0002\u001e\u0005\t\u0012\r\u001a3Es:\fW.[2D_:4\u0017nZ:\u0015\u0007=\fy\u0002\u0003\u0005\u0002\"\u0005e\u0001\u0019AA\u0012\u0003%\u0019wN\u001c4jO\u0012+g\r\u0005\u0003\u0002&\u0005eRBAA\u0014\u0015\u0011\tI#a\u000b\u0002\r\r|gNZ5h\u0015\u0011\ti#a\f\u0002\r\r|W.\\8o\u0015\r)\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003o\t1a\u001c:h\u0013\u0011\tY$a\n\u0003\u0013\r{gNZ5h\t\u00164\u0007\u0002CA \u0013\u0011\u0005!!!\u0011\u00021\u0011Lh.Y7jG\u000e{gNZ5h+B$\u0017\r^3N_\u0012,7/\u0006\u0002\u0002DA)Q/!\u0012T'&\u0019\u0011q\t<\u0003\u00075\u000b\u0007OB\u0003\u000b\u0005\u0001\tYeE\u0003\u0002J1\ti\u0005\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019\u0006B\u0001\u0006kRLGn]\u0005\u0005\u0003/\n\tFA\u0004M_\u001e<\u0017N\\4\t\u0017\u0005m\u0013\u0011\nBC\u0002\u0013%\u0011QL\u0001\fW\u000647.Y\"p]\u001aLw-\u0006\u0002\u0002`A\u0019\u0001\"!\u0019\n\u0007\u0005\r$AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bCA4\u0003\u0013\u0012\t\u0011)A\u0005\u0003?\nAb[1gW\u0006\u001cuN\u001c4jO\u0002BqaEA%\t\u0003\tY\u0007\u0006\u0003\u0002n\u0005=\u0004c\u0001\u0005\u0002J!A\u00111LA5\u0001\u0004\ty\u0006C\u0006\u0002t\u0005%#\u0019!C\u0001\u0005\u0005U\u0014aE:uCRL7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cXCAA<!\u0015I\u0012\u0011\u0010\u0011!\u0013\r\t9E\u0007\u0005\n\u0003{\nI\u0005)A\u0005\u0003o\nAc\u001d;bi&\u001c'I]8lKJ\u001cuN\u001c4jON\u0004\u0003bCAA\u0003\u0013\u0012\r\u0011\"\u0001\u0003\u0003k\nAc\u001d;bi&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b\"CAC\u0003\u0013\u0002\u000b\u0011BA<\u0003U\u0019H/\u0019;jG\u0012+g-Y;mi\u000e{gNZ5hg\u0002B!\"!#\u0002J\t\u0007I\u0011BAF\u0003Q!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011\u0011Q\u0012\t\u00063\u0005e4k\u0015\u0005\n\u0003#\u000bI\u0005)A\u0005\u0003\u001b\u000bQ\u0003Z=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b\u0005\u0003\u0006\u0002\u0016\u0006%#\u0019!C\u0005\u0003\u0017\u000bQ\u0003Z=oC6L7\rR3gCVdGoQ8oM&<7\u000fC\u0005\u0002\u001a\u0006%\u0003\u0015!\u0003\u0002\u000e\u00061B-\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\b\u0005\u0003\u0006\u0002\u001e\u0006%#\u0019!C\u0005\u0003?\u000bqB]3d_:4\u0017nZ;sC\ndWm]\u000b\u0003\u0003C\u0003R!GAR\u0003OK1!!*\u001b\u0005\u0019\u0011UO\u001a4feB!\u0011\u0011VAV\u001b\t\tY#\u0003\u0003\u0002.\u0006-\"A\u0004*fG>tg-[4ve\u0006\u0014G.\u001a\u0005\n\u0003c\u000bI\u0005)A\u0005\u0003C\u000b\u0001C]3d_:4\u0017nZ;sC\ndWm\u001d\u0011\t\u0015\u0005U\u0016\u0011\nb\u0001\n\u0013\t9,A\u000bce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\u0005e\u0006#B\r\u0002$\u0006m\u0006c\u0001\u0005\u0002>&\u0019\u0011q\u0018\u0002\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0011%\t\u0019-!\u0013!\u0002\u0013\tI,\u0001\fce>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z:!\u0011)\t9-!\u0013C\u0002\u0013%\u0011\u0011Z\u0001\u0005Y>\u001c7.\u0006\u0002\u0002LB!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017!\u00027pG.\u001c(bAAkm\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u0017q\u001a\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"I\u0011Q\\A%A\u0003%\u00111Z\u0001\u0006Y>\u001c7\u000e\t\u0005\u000b\u0003C\fI\u00051A\u0005\n\u0005u\u0013!D2veJ,g\u000e^\"p]\u001aLw\r\u0003\u0006\u0002f\u0006%\u0003\u0019!C\u0005\u0003O\f\u0011cY;se\u0016tGoQ8oM&<w\fJ3r)\ry\u0017\u0011\u001e\u0005\u000b\u0003W\f\u0019/!AA\u0002\u0005}\u0013a\u0001=%c!I\u0011q^A%A\u0003&\u0011qL\u0001\u000fGV\u0014(/\u001a8u\u0007>tg-[4!\u0011)\t\u00190!\u0013C\u0002\u0013%\u0011Q_\u0001\u001dIft\u0017-\\5d\u0007>tg-[4QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s+\t\t9\u0010E\u0003\u000e\u0003s\fi0C\u0002\u0002|:\u0011aa\u00149uS>t\u0007\u0003BA(\u0003\u007fLAA!\u0001\u0002R\ty\u0001+Y:to>\u0014H-\u00128d_\u0012,'\u000fC\u0005\u0003\u0006\u0005%\u0003\u0015!\u0003\u0002x\u0006iB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014\b\u0005C\u0005\u0003\n\u0005%C\u0011\u0001\u0002\u0003\f\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007=\u0014i\u0001\u0003\u0005\u0003\u0010\t\u001d\u0001\u0019\u0001B\t\u0003!Q8n\u00117jK:$\b\u0003\u0002B\n\u00053i!A!\u0006\u000b\u0007\t]A!\u0001\u0002{W&!!1\u0004B\u000b\u00055Y\u0015MZ6b5.\u001cE.[3oi\"A!qDA%\t\u0003\u0011\t#\u0001\nbI\u0012\u0014VmY8oM&<WO]1cY\u0016\u001cHcA8\u0003$!A!Q\u0005B\u000f\u0001\u0004\u00119#A\u0006lC\u001a\\\u0017mU3sm\u0016\u0014\bc\u0001\u0005\u0003*%\u0019!1\u0006\u0002\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\t\u0005_\tI\u0005\"\u0001\u00032\u0005\t\u0012\r\u001a3SK\u000e|gNZ5hkJ\f'\r\\3\u0015\u0007=\u0014\u0019\u0004\u0003\u0005\u00036\t5\u0002\u0019AAT\u00039\u0011XmY8oM&<WO]1cY\u0016D\u0001B!\u000f\u0002J\u0011\u0005!1H\u0001\u0018C\u0012$'I]8lKJ\u0014VmY8oM&<WO]1cY\u0016$2a\u001cB\u001f\u0011!\u0011)Da\u000eA\u0002\u0005m\u0006\u0002\u0003B!\u0003\u0013\"\tAa\u0011\u0002)I,Wn\u001c<f%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\ry'Q\t\u0005\t\u0005k\u0011y\u00041\u0001\u0002(\"A!\u0011JA%\t\u0013\u0011Y%A\u000ewKJLg-\u001f*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u000b\u0004_\n5\u0003b\u0002B(\u0005\u000f\u0002\rA`\u0001\fG>tg-[4OC6,7\u000fC\u0005\u0003T\u0005%C\u0011\u0001\u0002\u0002^\u0005\u00112-\u001e:sK:$8*\u00194lC\u000e{gNZ5h\u0011%\u00119&!\u0013\u0005\u0002\t\u0011I&A\u000edkJ\u0014XM\u001c;Es:\fW.[2Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u00057\u0002RA\u000eB/'NK1!a\u0012\u001d\u0011%\u0011\t'!\u0013\u0005\u0002\t\u0011I&\u0001\u000fdkJ\u0014XM\u001c;Es:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\t\u0013\t\u0015\u0014\u0011\nC\u0001\u0005\t\u001d\u0014AE;qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$Ra\u001cB5\u0005gB\u0001Ba\u001b\u0003d\u0001\u0007!QN\u0001\tEJ|7.\u001a:JIB\u0019QBa\u001c\n\u0007\tEdBA\u0002J]RDqA!\u001e\u0003d\u0001\u0007A/A\bqKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t\u0011%\u0011I(!\u0013\u0005\u0002\t\u0011Y(A\nva\u0012\fG/\u001a#fM\u0006,H\u000e^\"p]\u001aLw\rF\u0002p\u0005{BqA!\u001e\u0003x\u0001\u0007A\u000f\u0003\u0005\u0003\u0002\u0006%C\u0011\u0002BB\u0003ii\u0017-\u001f2f\u0007J,\u0017\r^3QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s)\u0011\t9P!\"\t\u0011\t\u001d%q\u0010a\u0001\u0005\u0013\u000baa]3de\u0016$\b#B\u0007\u0002z\n-\u0005\u0003\u0002BG\u0005'k!Aa$\u000b\t\tE\u0015qE\u0001\u0006if\u0004Xm]\u0005\u0005\u0005+\u0013yI\u0001\u0005QCN\u001cxo\u001c:e\u0011!\u0011I*!\u0013\u0005\n\tm\u0015a\u00049bgN<xN\u001d3F]\u000e|G-\u001a:\u0016\u0005\u0005u\b\"\u0003BP\u0003\u0013\"\tA\u0001BQ\u0003E!x\u000eU3sg&\u001cH/\u001a8u!J|\u0007o\u001d\u000b\u0006i\n\r&q\u0015\u0005\b\u0005K\u0013i\n1\u0001u\u0003-\u0019wN\u001c4jOB\u0013x\u000e]:\t\ri\u0014i\n1\u0001O\u0011%\u0011Y+!\u0013\u0005\u0002\t\u0011i+A\nge>l\u0007+\u001a:tSN$XM\u001c;Qe>\u00048\u000fF\u0003u\u0005_\u0013\t\fC\u0004\u0003v\t%\u0006\u0019\u0001;\t\ri\u0014I\u000b1\u0001O\u0011!\u0011),!\u0013\u0005\n\t]\u0016AF7bs\n,'+Z#oG>$W\rU1tg^|'\u000fZ:\u0015\u000bQ\u0014ILa/\t\u000f\tU$1\u0017a\u0001i\"A!Q\u0018BZ\u0001\u0004\u0011y,A\u0007bI6LgNW6DY&,g\u000e\u001e\t\u0005\u0005'\u0011\t-\u0003\u0003\u0003D\nU!!D!e[&t'l[\"mS\u0016tG\u000fC\u0005\u0003H\u0006%C\u0011\u0001\u0002\u0003J\u0006Aa/\u00197jI\u0006$X\rF\u0003p\u0005\u0017\u0014i\r\u0003\u0004t\u0005\u000b\u0004\r\u0001\u001e\u0005\u0007u\n\u0015\u0007\u0019\u0001(\t\u0011\tE\u0017\u0011\nC\u0005\u0005'\fAC]3n_Z,\u0017J\u001c<bY&$7i\u001c8gS\u001e\u001cH#B8\u0003V\n]\u0007BB:\u0003P\u0002\u0007A\u000f\u0003\u0004{\u0005\u001f\u0004\rA\u0014\u0005\n\u00057\fI\u0005\"\u0001\u0003\u0005;\f\u0001#\\1zE\u0016\u0014VmY8oM&<WO]3\u0015\u000f=\u0014yN!9\u0003f\"A!Q\u0007Bm\u0001\u0004\t9\u000b\u0003\u0005\u0003d\ne\u0007\u0019AA0\u0003%yG\u000eZ\"p]\u001aLw\r\u0003\u0005\u0003h\ne\u0007\u0019\u0001Bu\u0003%qWm^\"p]\u001aLw\r\r\u0003\u0003l\nE\bCB;\u0002FM\u0013i\u000f\u0005\u0003\u0003p\nEH\u0002\u0001\u0003\r\u0005g\u0014)/!A\u0001\u0002\u000b\u0005!Q\u001f\u0002\u0004?\u0012\n\u0014\u0003\u0002B|\u0005{\u00042!\u0004B}\u0013\r\u0011YP\u0004\u0002\b\u001d>$\b.\u001b8h!\ri!q`\u0005\u0004\u0007\u0003q!aA!os\"A1QAA%\t\u0013\u00199!\u0001\bva\u0012\fG/\u001a3D_:4\u0017nZ:\u0015\r\r%11CB\u0011a\u0011\u0019Yaa\u0004\u0011\re\tIhUB\u0007!\u0011\u0011yoa\u0004\u0005\u0019\rE11AA\u0001\u0002\u0003\u0015\tA!>\u0003\u0007}#S\u0007\u0003\u0005\u0004\u0016\r\r\u0001\u0019AB\f\u0003!qWm\u001e)s_B\u001c\b\u0007BB\r\u0007;\u0001b!^A#'\u000em\u0001\u0003\u0002Bx\u0007;!Aba\b\u0004\u0014\u0005\u0005\t\u0011!B\u0001\u0005k\u00141a\u0018\u00133\u0011!\u0019\u0019ca\u0001A\u0002\r\u0015\u0012\u0001D2veJ,g\u000e\u001e)s_B\u001c\bGBB\u0014\u0007W\u0019\t\u0004E\u0004v\u0003\u000b\u001aIca\f\u0011\t\t=81\u0006\u0003\r\u0007[\u0019\t#!A\u0001\u0002\u000b\u0005!Q\u001f\u0002\u0004?\u0012\u001a\u0004\u0003\u0002Bx\u0007c!Aba\r\u0004\"\u0005\u0005\t\u0011!B\u0001\u0005k\u00141a\u0018\u00135\u0011!\u00199$!\u0013\u0005\n\re\u0012!D8wKJ\u0014\u0018\u000eZ3Qe>\u00048\u000fF\u0003p\u0007w\u0019i\u0004C\u0004t\u0007k\u0001\r!!$\t\u0011\r}2Q\u0007a\u0001\u0003\u001b\u000bQ\u0002\u001d:paN|e/\u001a:sS\u0012,\u0007\u0002CB\"\u0003\u0013\"Ia!\u0012\u0002'U\u0004H-\u0019;f\u0007V\u0014(/\u001a8u\u0007>tg-[4\u0015\u0003=D\u0001b!\u0013\u0002J\u0011%11J\u0001\u0017aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R11QJB+\u0007/\u0002r!DB(\u0003?\u001a\u0019&C\u0002\u0004R9\u0011a\u0001V;qY\u0016\u0014\u0004\u0003B1g\u0003wC\u0001b!\u0006\u0004H\u0001\u0007!1\f\u0005\b\u00073\u001a9\u00051\u0001O\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011!\u0019i&!\u0013\u0005\n\r}\u0013\u0001\u00068fK\u0012\u001c(+Z2p]\u001aLw-\u001e:bi&|g\u000eF\u0003O\u0007C\u001aI\u0007\u0003\u0005\u0004d\rm\u0003\u0019AB3\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004B!^B4'&\u0011qD\u001e\u0005\b\u0007W\u001aY\u00061\u0001\u007f\u0003-)\b\u000fZ1uK\u0012\\U-_:\t\u0011\r=\u0014\u0011\nC\u0005\u0007c\nQ\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sC\ndW\rF\u0006p\u0007g\u001a)h!\u001f\u0004\b\u000eM\u0005\u0002\u0003B\u001b\u0007[\u0002\r!a*\t\u000f\r]4Q\u000ea\u0001}\u0006\u0011R\u000f\u001d3bi\u0016$7i\u001c8gS\u001et\u0015-\\3t\u0011!\u0019Yh!\u001cA\u0002\ru\u0014!D1mY:+woQ8oM&<7\u000f\r\u0003\u0004\u0000\r\r\u0005CB;\u0002FM\u001b\t\t\u0005\u0003\u0003p\u000e\rE\u0001DBC\u0007s\n\t\u0011!A\u0003\u0002\tU(aA0%m!A1\u0011RB7\u0001\u0004\u0019Y)\u0001\toK^\u001cUo\u001d;p[\u000e{gNZ5hgB1Q/!\u0012T\u0007\u001b\u00032!IBH\u0013\r\u0019\tJ\t\u0002\u0007\u001f\nTWm\u0019;\t\u000f\re3Q\u000ea\u0001\u001d\u0002")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicBrokerConfig dynamicBrokerConfig = this;
        synchronized (dynamicBrokerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)this.kafkaConfig().brokerId())).toString());
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
    }

    public void addReconfigurables(KafkaServer kafkaServer) {
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs((Set<String>)((Set)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()));
            return this.reconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs(reconfigurable.reconfigurableConfigs());
            return this.brokerReconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.reconfigurables().$minus$eq((Object)reconfigurable));
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Set nonDynamic = (Set)configNames.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
            Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
        });
    }

    public KafkaConfig currentKafkaConfig() {
        return (KafkaConfig)((Object)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.currentConfig()));
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicBrokerConfigs().clone());
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicDefaultConfigs().clone());
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, true);
                this.dynamicBrokerConfigs().clear();
                this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId).append(" could not be applied: ").append(persistentProps).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void updateDefaultConfig(Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, false);
                this.dynamicDefaultConfigs().clear();
                this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)configProps.clone();
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$2(this, perBrokerConfig, props, x0$2);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$6(this, props, x0$3);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        block0: {
            Properties props = (Properties)persistentProps.clone();
            if (!((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) break block0;
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, adminZkClient, props, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            DynamicBrokerConfig$.MODULE$.validateConfigs(props, perBrokerConfig);
            scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newProps.$plus$plus$eq(this.staticBrokerConfigs());
            if (perBrokerConfig) {
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()));
            } else {
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()));
                this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
            }
            return this.processReconfiguration((Map<String, String>)newProps, true);
        });
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$5)));
            invalidProps.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Dynamic ").append(configSource).append(" config contains invalid values: ").append(invalidProps).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        block0: {
            if (!((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) break block0;
            reconfigurable.reconfigure(newConfig);
        }
    }

    private scala.collection.mutable.Map<String, ?> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<?, ?> currentProps) {
        return (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$6)));
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        propsOverride.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            Option option = props.put((Object)k, (Object)v);
            return option;
        });
    }

    private void updateCurrentConfig() {
        block1: {
            scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newProps.$plus$plus$eq(this.staticBrokerConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
            KafkaConfig oldConfig = this.currentConfig();
            Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            KafkaConfig newConfig = (KafkaConfig)((Object)tuple2._1());
            List brokerReconfigurablesToUpdate = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate);
            Tuple2 tuple23 = tuple22;
            KafkaConfig newConfig2 = (KafkaConfig)((Object)tuple23._1());
            List brokerReconfigurablesToUpdate2 = (List)tuple23._2();
            if (newConfig2 == this.currentConfig()) break block1;
            this.currentConfig_$eq(newConfig2);
            this.kafkaConfig().updateCurrentConfig(newConfig2);
            brokerReconfigurablesToUpdate2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.reconfigure(oldConfig, newConfig2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        Tuple2 tuple2;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        scala.collection.mutable.Map<String, ?> updatedMap = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (updatedMap.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(newConfig.valuesFromThisConfig().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> customConfigs.remove(x$1));
                this.reconfigurables().foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                    DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, validateOnly, newConfig, updatedMap, customConfigs, x0$8);
                    return BoxedUnit.UNIT;
                });
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                    Object object;
                    if (this.needsReconfiguration((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)updatedMap.keySet())) {
                        reconfigurable.validateReconfiguration(newConfig);
                        object = !validateOnly ? brokerReconfigurablesToUpdate.$plus$eq(reconfigurable) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                tuple2 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(newConfig.originalsFromThisConfig()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        } else {
            tuple2 = new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
        }
        return tuple2;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys) {
        return ((TraversableOnce)((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty();
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        block3: {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allNewConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Object object = newConfigs.put(k, v);
                return object;
            });
            newConfigs.putAll(newCustomConfigs);
            try {
                reconfigurable.validateReconfiguration(newConfigs);
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception exception) {
                throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
            }
            if (validateOnly) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" custom configs: ").append(newCustomConfigs).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$2, Properties props$3) {
        block1: {
            if (value == null) break block1;
            if (!perBrokerConfig$2) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$2(DynamicBrokerConfig $this, boolean perBrokerConfig$2, Properties props$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.encodePassword$1(name, value, perBrokerConfig$2, props$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        block0: {
            if (!invalidPropNames.nonEmpty()) break block0;
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        block2: {
            if (value == null) break block2;
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$6(DynamicBrokerConfig $this, Properties props$4, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.decodePassword$1(name, value, props$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$4(DynamicBrokerConfig $this, Properties props$6, PasswordEncoder passwordDecoder$1, Tuple2 x0$4) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String configName = (String)tuple2._1();
            String value2 = (String)tuple2._2();
            if (value2 != null) {
                Some some;
                try {
                    some = new Some((Object)passwordDecoder$1.decode(value2).value());
                }
                catch (Exception exception) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                    some = None$.MODULE$;
                }
                Some decoded = some;
                decoded.foreach((Function1 & Serializable & scala.Serializable)value -> props$6.put(configName, $this.passwordEncoder().encode(new Password(value))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, AdminZkClient adminZkClient$1, Properties props$6, PasswordEncoder passwordDecoder) {
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$4($this, props$6, passwordDecoder, x0$4);
            return BoxedUnit.UNIT;
        });
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$6);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$5) {
        boolean bl;
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        boolean bl = !BoxesRunTime.equals((Object)v, currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, boolean validateOnly$1, KafkaConfig newConfig$3, scala.collection.mutable.Map updatedMap$1, HashMap customConfigs$1, Reconfigurable x0$8) {
        Reconfigurable reconfigurable = x0$8;
        if (reconfigurable instanceof ListenerReconfigurable) {
            BoxedUnit boxedUnit;
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            ListenerName listenerName = listenerReconfigurable.listenerName();
            java.util.Map<String, Object> oldValues = $this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
            java.util.Map<String, Object> newValues = newConfig$3.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
            Set updatedKeys = $this.updatedConfigs(newValues, oldValues).keySet();
            if ($this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys)) {
                $this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs$1, validateOnly$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if ($this.needsReconfiguration(reconfigurable.reconfigurableConfigs(), (Set<String>)updatedMap$1.keySet())) {
                $this.processReconfigurable(reconfigurable, (Set<String>)updatedMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }
}

