/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001%\u0011A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",'BA\u0002\u0005\u0003\u0015)\u0007o\\2i\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u000b!Q\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005AaU-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013a\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003;\u0015j\u0011A\b\u0006\u0003?\u0001\naaY8n[>t'BA\u0004\"\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019r\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005\u0019A.Z8\u0011\u0007-QC&\u0003\u0002,\u0019\tIa)\u001e8di&|g\u000e\r\t\u0003[9j\u0011\u0001B\u0005\u0003_\u0011\u0011\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014AC2iK\u000e\\\u0007o\\5oiB\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\fG\",7m\u001b9pS:$8/\u0003\u00028i\t)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\b\"B\u001d\u0001\t\u0003Q\u0014A\u0002\u001fj]&$h\b\u0006\u0003<yur\u0004CA\t\u0001\u0011\u0015Y\u0002\b1\u0001\u001d\u0011\u0015A\u0003\b1\u0001*\u0011\u0015\t\u0004\b1\u00013\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000bA\u0001\\8dWV\t!\t\u0005\u0002D\u00196\tAI\u0003\u0002F\r\u0006)An\\2lg*\u0011q\tS\u0001\u000bG>t7-\u001e:sK:$(BA%K\u0003\u0011)H/\u001b7\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0012\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"1q\n\u0001Q\u0001\n\t\u000bQ\u0001\\8dW\u0002Bq!\u0015\u0001A\u0002\u0013%!+\u0001\u0004fa>\u001c\u0007n]\u000b\u0002'B\u0019A+W.\u000e\u0003US!AV,\u0002\u000f5,H/\u00192mK*\u0011\u0001\fD\u0001\u000bG>dG.Z2uS>t\u0017B\u0001.V\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0003#qK!!\u0018\u0002\u0003\u0015\u0015\u0003xn\u00195F]R\u0014\u0018\u0010C\u0004`\u0001\u0001\u0007I\u0011\u00021\u0002\u0015\u0015\u0004xn\u00195t?\u0012*\u0017\u000f\u0006\u0002bIB\u00111BY\u0005\u0003G2\u0011A!\u00168ji\"9QMXA\u0001\u0002\u0004\u0019\u0016a\u0001=%c!1q\r\u0001Q!\nM\u000bq!\u001a9pG\"\u001c\b\u0005C\u0003j\u0001\u0011\u0005#.\u0001\u0004bgNLwM\u001c\u000b\u0004C.|\u0007\"B\u0002i\u0001\u0004a\u0007CA\u0006n\u0013\tqGBA\u0002J]RDQ\u0001\u001d5A\u0002E\faa\u001c4gg\u0016$\bCA\u0006s\u0013\t\u0019HB\u0001\u0003M_:<\u0007\"B;\u0001\t\u00032\u0018a\u00037bi\u0016\u001cH/\u00129pG\"$\u0012\u0001\u001c\u0005\u0006q\u0002!\t%_\u0001\rK:$wJ\u001a4tKR4uN\u001d\u000b\u0003uv\u0004BaC>mc&\u0011A\u0010\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000by<\b\u0019\u00017\u0002\u001dI,\u0017/^3ti\u0016$W\t]8dQ\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0011aE2mK\u0006\u0014\u0018I\u001c3GYV\u001c\b\u000eT1uKN$HcA1\u0002\u0006!)\u0001o a\u0001c\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011!F2mK\u0006\u0014\u0018I\u001c3GYV\u001c\b.R1sY&,7\u000f\u001e\u000b\u0004C\u00065\u0001B\u00029\u0002\b\u0001\u0007\u0011\u000fC\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u001b\rdW-\u0019:B]\u00124E.^:i)\u0005\t\u0007bBA\f\u0001\u0011\u0005\u00131C\u0001\u0006G2,\u0017M\u001d\u0005\b\u00037\u0001A\u0011AA\u000f\u00031)\u0007o\\2i\u000b:$(/[3t)\u0005\u0019\u0006bBA\u0011\u0001\u0011%\u00111E\u0001\u000fK\u0006\u0014H.[3ti>3gm]3u)\u0005\t\bbBA\u0014\u0001\u0011%\u00111E\u0001\rY\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0003W\u0001A\u0011BA\n\u0003\u00151G.^:i\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\ta\"\u001a9pG\"\u001c\u0005.\u00198hK6\u001bx\r\u0006\u0004\u00024\u0005%\u00131\n\t\u0005\u0003k\t\u0019E\u0004\u0003\u00028\u0005}\u0002cAA\u001d\u00195\u0011\u00111\b\u0006\u0004\u0003{A\u0011A\u0002\u001fs_>$h(C\u0002\u0002B1\ta\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u0012aa\u0015;sS:<'bAA!\u0019!11!!\fA\u00021Da\u0001]A\u0017\u0001\u0004\t\bbBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u0015m\u0006d\u0017\u000eZ1uK\u0006sG-T1zE\u0016<\u0016M\u001d8\u0015\u000b\u0005\f\u0019&!\u0016\t\r\r\ti\u00051\u0001m\u0011\u0019\u0001\u0018Q\na\u0001c\u0002")
public class LeaderEpochFileCache
implements LeaderEpochCache,
Logging {
    private final TopicPartition topicPartition;
    private final Function0<LogOffsetMetadata> leo;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private ListBuffer<EpochEntry> epochs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LeaderEpochFileCache leaderEpochFileCache = this;
        synchronized (leaderEpochFileCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ListBuffer<EpochEntry> epochs() {
        return this.epochs;
    }

    private void epochs_$eq(ListBuffer<EpochEntry> x$1) {
        this.epochs = x$1;
    }

    @Override
    public void assign(int epoch, long offset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (epoch >= 0 && epoch > this.latestEpoch() && offset >= this.latestOffset()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Updated PartitionLeaderEpoch. ").append(this.epochChangeMsg(epoch, offset)).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
                this.epochs().$plus$eq((Object)new EpochEntry(epoch, offset));
                this.flush();
            } else {
                this.validateAndMaybeWarn(epoch, offset);
            }
        });
    }

    @Override
    public int latestEpoch() {
        return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.epochs().isEmpty() ? -1 : ((EpochEntry)this.epochs().last()).epoch()));
    }

    @Override
    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch) {
        return (Tuple2)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var3_9;
            Tuple2.mcIJ.sp sp2;
            if (requestedEpoch == -1) {
                sp2 = new Tuple2.mcIJ.sp(-1, -1L);
            } else if (requestedEpoch == this.latestEpoch()) {
                sp2 = new Tuple2.mcIJ.sp(requestedEpoch, ((LogOffsetMetadata)$this.leo.apply()).messageOffset());
            } else {
                Tuple2 tuple2 = this.epochs().partition((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$endOffsetFor$2(requestedEpoch, e)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ListBuffer subsequentEpochs = (ListBuffer)tuple2._1();
                ListBuffer previousEpochs = (ListBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)subsequentEpochs, (Object)previousEpochs);
                Tuple2 tuple23 = tuple22;
                ListBuffer subsequentEpochs2 = (ListBuffer)tuple23._1();
                ListBuffer previousEpochs2 = (ListBuffer)tuple23._2();
                sp2 = subsequentEpochs2.isEmpty() || requestedEpoch < ((EpochEntry)this.epochs().head()).epoch() ? new Tuple2.mcIJ.sp(-1, -1L) : new Tuple2.mcIJ.sp(((EpochEntry)previousEpochs2.last()).epoch(), ((EpochEntry)subsequentEpochs2.head()).startOffset());
            }
            Tuple2.mcIJ.sp epochAndOffset = sp2;
            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$3(this, requestedEpoch, (Tuple2)epochAndOffset)));
            return var3_9;
        });
    }

    @Override
    public void clearAndFlushLatest(long offset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                ListBuffer<EpochEntry> before = this.epochs();
                if (offset < 0L || offset > this.latestOffset()) break block0;
                this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)this.epochs().filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$clearAndFlushLatest$2(offset, entry)))));
                this.flush();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Cleared latest ").append(before.toSet().filterNot((Function1)this.epochs().toSet())).append(" entries from epoch cache based on passed offset ").append(offset).append(" leaving ").append(this.epochs().size()).append(" in EpochFile for partition ").append($this.topicPartition).toString());
            }
        });
    }

    @Override
    public void clearAndFlushEarliest(long offset) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                BoxedUnit boxedUnit;
                ListBuffer earliest;
                ListBuffer<EpochEntry> before = this.epochs();
                if (offset < 0L || this.earliestOffset() >= offset || !(earliest = (ListBuffer)this.epochs().filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$clearAndFlushEarliest$2(offset, entry)))).nonEmpty()) break block2;
                this.epochs_$eq((ListBuffer<EpochEntry>)((ListBuffer)this.epochs().$minus$minus$eq((TraversableOnce)earliest)));
                if (offset < this.earliestOffset() || this.epochs().isEmpty()) {
                    EpochEntry epochEntry = new EpochEntry(((EpochEntry)earliest.last()).epoch(), offset);
                    boxedUnit = this.epochs().$plus$eq$colon((Object)epochEntry);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.flush();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Cleared earliest ").append(((TraversableOnce)before.toSet().filterNot((Function1)this.epochs().toSet())).size()).append(" entries from epoch cache based on passed offset ").append(offset).append(" leaving ").append(this.epochs().size()).append(" in EpochFile for partition ").append($this.topicPartition).toString());
            }
        });
    }

    @Override
    public void clearAndFlush() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.epochs().clear();
            this.flush();
        });
    }

    @Override
    public void clear() {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.epochs().clear());
    }

    public ListBuffer<EpochEntry> epochEntries() {
        return this.epochs();
    }

    private long earliestOffset() {
        return this.epochs().isEmpty() ? -1L : ((EpochEntry)this.epochs().head()).startOffset();
    }

    private long latestOffset() {
        return this.epochs().isEmpty() ? -1L : ((EpochEntry)this.epochs().last()).startOffset();
    }

    private void flush() {
        this.checkpoint.write((Seq<EpochEntry>)this.epochs());
    }

    public String epochChangeMsg(int epoch, long offset) {
        return new StringBuilder(66).append("New: {epoch:").append(epoch).append(", offset:").append(offset).append("}, Current: {epoch:").append(this.latestEpoch()).append(", offset:").append(this.latestOffset()).append("} for Partition: ").append(this.topicPartition).toString();
    }

    public void validateAndMaybeWarn(int epoch, long offset) {
        block1: {
            block0: {
                Predef$.MODULE$.assert(epoch >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Received a PartitionLeaderEpoch assignment for an epoch < 0. This should not happen. ").append(this.epochChangeMsg(epoch, offset)).toString());
                if (epoch >= this.latestEpoch()) break block0;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Received a PartitionLeaderEpoch assignment for an epoch < latestEpoch. ").append(new StringBuilder(49).append("This implies messages have arrived out of order. ").append(this.epochChangeMsg(epoch, offset)).toString()).toString());
                break block1;
            }
            if (offset >= this.latestOffset()) break block1;
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(123).append("Received a PartitionLeaderEpoch assignment for an offset < latest offset for the most recent, stored PartitionLeaderEpoch. ").append(new StringBuilder(49).append("This implies messages have arrived out of order. ").append(this.epochChangeMsg(epoch, offset)).toString()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$endOffsetFor$2(int requestedEpoch$1, EpochEntry e) {
        return e.epoch() > requestedEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$3(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(114).append("Processed offset for epoch request for partition ").append($this.topicPartition).append(" epoch:").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" and offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch list of size ").append($this.epochs().size()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$clearAndFlushLatest$2(long offset$3, EpochEntry entry) {
        return entry.startOffset() < offset$3;
    }

    public static final /* synthetic */ boolean $anonfun$clearAndFlushEarliest$2(long offset$4, EpochEntry entry) {
        return entry.startOffset() < offset$4;
    }

    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<LogOffsetMetadata> leo, LeaderEpochCheckpoint checkpoint) {
        this.topicPartition = topicPartition;
        this.leo = leo;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.epochs = (ListBuffer)CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply($this.checkpoint.read()));
    }
}

