/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kafka.utils.json.JsonValue;
import kafka.utils.json.JsonValue$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public final class Json$ {
    public static Json$ MODULE$;
    private final ObjectMapper mapper;

    static {
        new Json$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public Option<JsonValue> parseFull(String input) {
        Option option;
        try {
            option = Option$.MODULE$.apply((Object)this.mapper().readTree(input)).map((Function1 & Serializable & scala.Serializable)x$1 -> JsonValue$.MODULE$.apply((JsonNode)x$1));
        }
        catch (JsonProcessingException jsonProcessingException) {
            String escapedInput = input.replaceAll("\\\\", "\\\\\\\\");
            try {
                option = Option$.MODULE$.apply((Object)this.mapper().readTree(escapedInput)).map((Function1 & Serializable & scala.Serializable)x$2 -> JsonValue$.MODULE$.apply((JsonNode)x$2));
            }
            catch (JsonProcessingException jsonProcessingException2) {
                option = None$.MODULE$;
            }
        }
        return option;
    }

    public <T> Either<JsonProcessingException, T> parseStringAs(String input, ClassTag<T> tag) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public Option<JsonValue> parseBytes(byte[] input) {
        None$ none$;
        try {
            none$ = Option$.MODULE$.apply((Object)this.mapper().readTree(input)).map((Function1 & Serializable & scala.Serializable)x$3 -> JsonValue$.MODULE$.apply((JsonNode)x$3));
        }
        catch (JsonProcessingException jsonProcessingException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Either<JsonProcessingException, JsonValue> tryParseBytes(byte[] input) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.mapper().readTree(input)).right().map((Function1 & Serializable & scala.Serializable)x$4 -> JsonValue$.MODULE$.apply((JsonNode)x$4));
        }
        catch (JsonProcessingException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public <T> Either<JsonProcessingException, T> parseBytesAs(byte[] input, ClassTag<T> tag) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public String legacyEncodeAsString(Object obj2) {
        String string;
        block9: {
            Object object;
            while (true) {
                if ((object = obj2) == null) {
                    string = "null";
                    break block9;
                }
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    string = ((Object)BoxesRunTime.boxToBoolean((boolean)bl)).toString();
                    break block9;
                }
                if (object instanceof String) {
                    String string2 = (String)object;
                    string = this.mapper().writeValueAsString((Object)string2);
                    break block9;
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    string = number.toString();
                    break block9;
                }
                if (object instanceof Map) {
                    Map map = (Map)object;
                    string = new StringBuilder(2).append("{").append(((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new IllegalArgumentException(new StringBuilder(26).append("Invalid map element '").append(tuple2).append("' in ").append(obj2).toString());
                        }
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.legacyEncodeAsString(k)).append(":").append(MODULE$.legacyEncodeAsString(v)).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).append("}").toString();
                    break block9;
                }
                if (!ScalaRunTime$.MODULE$.isArray(object, 1)) break;
                Object object2 = object;
                obj2 = Predef$.MODULE$.genericArrayOps(object2).toSeq();
            }
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                string = new StringBuilder(2).append("[").append(((TraversableOnce)iterable.map((Function1 & Serializable & scala.Serializable)obj -> MODULE$.legacyEncodeAsString(obj), Iterable$.MODULE$.canBuildFrom())).mkString(",")).append("]").toString();
            } else {
                if (object instanceof Object) {
                    Object object3 = object;
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unknown argument of type ").append(object3.getClass()).append(": ").append(object3).toString());
                }
                throw new MatchError(object);
            }
        }
        return string;
    }

    public String encodeAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    public byte[] encodeAsBytes(Object obj) {
        return this.mapper().writeValueAsBytes(obj);
    }

    private Json$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
    }
}

