/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType$;
import kafka.zk.AclChangeNode;
import kafka.zk.AclChangeNotificationHandler;
import kafka.zk.AclChangeSubscription;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkAclChangeStore;
import org.apache.kafka.common.resource.PatternType;
import scala.Array$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LiteralAclChangeStore$
implements ZkAclChangeStore,
Product,
Serializable {
    public static LiteralAclChangeStore$ MODULE$;
    private final String name;
    private final String aclChangePath;

    static {
        new LiteralAclChangeStore$();
    }

    @Override
    public String createPath() {
        return ZkAclChangeStore.createPath$(this);
    }

    @Override
    public AclChangeNode createChangeNode(Resource resource) {
        return ZkAclChangeStore.createChangeNode$(this, resource);
    }

    @Override
    public AclChangeSubscription createListener(AclChangeNotificationHandler handler, KafkaZkClient zkClient) {
        return ZkAclChangeStore.createListener$(this, handler, zkClient);
    }

    public String name() {
        return this.name;
    }

    @Override
    public String aclChangePath() {
        return this.aclChangePath;
    }

    @Override
    public byte[] encode(Resource resource) {
        PatternType patternType = resource.patternType();
        PatternType patternType2 = PatternType.LITERAL;
        if (patternType == null ? patternType2 != null : !patternType.equals(patternType2)) {
            throw new IllegalArgumentException("Only literal resource patterns can be encoded");
        }
        String legacyName = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)resource.resourceType()), Resource$.MODULE$.Separator())).append(resource.name()).toString();
        return legacyName.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Resource decode(byte[] bytes) {
        String string = new String(bytes, StandardCharsets.UTF_8);
        String[] stringArray = string.split(Resource$.MODULE$.Separator(), 2);
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) < 0) {
            throw new IllegalArgumentException(new StringBuilder(62).append("expected a string in format ResourceType:ResourceName but got ").append(string).toString());
        }
        String resourceType = (String)((SeqLike)option.get()).apply(0);
        String resourceName = (String)((SeqLike)option.get()).apply(1);
        Resource resource = new Resource(ResourceType$.MODULE$.fromString(resourceType), resourceName, PatternType.LITERAL);
        return resource;
    }

    public String productPrefix() {
        return "LiteralAclChangeStore";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LiteralAclChangeStore$;
    }

    public int hashCode() {
        return -1625819498;
    }

    public String toString() {
        return "LiteralAclChangeStore";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LiteralAclChangeStore$() {
        MODULE$ = this;
        ZkAclChangeStore.$init$(this);
        Product.$init$((Product)this);
        this.name = "LiteralAclChangeStore";
        this.aclChangePath = "/kafka-acl-changes";
    }
}

