/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t'v\u001bB\u0001A\u0005\u0012/A\u0011!bD\u0007\u0002\u0017)\u0011A\"D\u0001\u0005Y\u0006twMC\u0001\u000f\u0003\u0011Q\u0017M^1\n\u0005AY!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\u001b\u0005\u0011\u0011n\\\u0005\u0003-M\u0011\u0011b\u00117pg\u0016\f'\r\\3\u0011\u0005aYR\"A\r\u000b\u0005i!\u0011!B;uS2\u001c\u0018B\u0001\u000f\u001a\u0005\u001daunZ4j]\u001eD\u0001B\b\u0001\u0003\u0002\u0004%\taH\u0001\u0005M&dW-F\u0001!!\t\u0011\u0012%\u0003\u0002#'\t!a)\u001b7f\u0011!!\u0003A!a\u0001\n\u0003)\u0013\u0001\u00034jY\u0016|F%Z9\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDq!L\u0012\u0002\u0002\u0003\u0007\u0001%A\u0002yIEB\u0001b\f\u0001\u0003\u0002\u0003\u0006K\u0001I\u0001\u0006M&dW\r\t\u0015\u0003]E\u0002\"a\n\u001a\n\u0005MB#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0011U\u0002!Q1A\u0005\u0002Y\n!BY1tK>3gm]3u+\u00059\u0004CA\u00149\u0013\tI\u0004F\u0001\u0003M_:<\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u0017\t\f7/Z(gMN,G\u000f\t\u0005\t{\u0001\u0011)\u0019!C\u0001}\u0005aQ.\u0019=J]\u0012,\u0007pU5{KV\tq\b\u0005\u0002(\u0001&\u0011\u0011\t\u000b\u0002\u0004\u0013:$\b\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B \u0002\u001b5\f\u00070\u00138eKb\u001c\u0016N_3!\u0011!)\u0005A!b\u0001\n\u00031\u0015\u0001C<sSR\f'\r\\3\u0016\u0003\u001d\u0003\"a\n%\n\u0005%C#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000f\u0006IqO]5uC\ndW\r\t\u0005\u0006\u001b\u0002!\tAT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b={\u0006-\u00192\u0011\tA\u0003\u0011\u000bX\u0007\u0002\u0005A\u0011!k\u0015\u0007\u0001\t\u0015!\u0006A1\u0001V\u0005\u0005Y\u0015C\u0001,Z!\t9s+\u0003\u0002YQ\t9aj\u001c;iS:<\u0007CA\u0014[\u0013\tY\u0006FA\u0002B]f\u0004\"AU/\u0005\u000by\u0003!\u0019A+\u0003\u0003YCQA\b'A\u0002\u0001BQ!\u000e'A\u0002]Bq!\u0010'\u0011\u0002\u0003\u0007q\bC\u0003F\u0019\u0002\u0007q\tC\u0005e\u0001\u0001\u0007\t\u0019!C\u0005m\u00059q\f\\3oORD\u0007\"\u00034\u0001\u0001\u0004\u0005\r\u0011\"\u0003h\u0003-yF.\u001a8hi\"|F%Z9\u0015\u0005\u0019B\u0007bB\u0017f\u0003\u0003\u0005\ra\u000e\u0005\nU\u0002\u0001\r\u0011!Q!\n]\n\u0001b\u00187f]\u001e$\b\u000e\t\u0015\u0003SFBQ!\u001c\u0001\u0007\u0012y\n\u0011\"\u001a8uef\u001c\u0016N_3\t\u000b=\u0004A\u0011\u0003 \u0002\u0019};\u0018M]7F]R\u0014\u0018.Z:\t\u000fE\u0004!\u0019!C\te\u0006!An\\2l+\u0005\u0019\bC\u0001;|\u001b\u0005)(B\u0001<x\u0003\u0015awnY6t\u0015\tA\u00180\u0001\u0006d_:\u001cWO\u001d:f]RT!A_\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003yV\u0014QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007B\u0002@\u0001A\u0003%1/A\u0003m_\u000e\\\u0007\u0005C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0005\u0002\u0004\u0005!Q.\\1q+\t\t)\u0001\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY!D\u0001\u0004]&|\u0017\u0002BA\b\u0003\u0013\u0011\u0001#T1qa\u0016$')\u001f;f\u0005V4g-\u001a:\t\u0013\u0005M\u0001\u00011A\u0005\u0012\u0005U\u0011\u0001C7nCB|F%Z9\u0015\u0007\u0019\n9\u0002C\u0005.\u0003#\t\t\u00111\u0001\u0002\u0006!A\u00111\u0004\u0001!B\u0013\t)!A\u0003n[\u0006\u0004\b\u0005K\u0002\u0002\u001aEBq!!\t\u0001A\u0003&q(A\u0006`[\u0006DXI\u001c;sS\u0016\u001c\bfAA\u0010c!A\u0011q\u0005\u0001A\u0002\u0013Ea(\u0001\u0005`K:$(/[3t\u0011%\tY\u0003\u0001a\u0001\n#\ti#\u0001\u0007`K:$(/[3t?\u0012*\u0017\u000fF\u0002'\u0003_A\u0001\"LA\u0015\u0003\u0003\u0005\ra\u0010\u0005\b\u0003g\u0001\u0001\u0015)\u0003@\u0003%yVM\u001c;sS\u0016\u001c\b\u0005K\u0002\u00022EBa!!\u000f\u0001\t\u00031\u0015AB5t\rVdG\u000e\u0003\u0004\u0002>\u0001!\tAP\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001c\bBBA!\u0001\u0011\u0005a(A\u0004f]R\u0014\u0018.Z:\t\r\u0005\u0015\u0003\u0001\"\u00017\u0003\u0019aWM\\4uQ\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013A\u0002:fg&TX\rF\u0002H\u0003\u001bBq!a\u0014\u0002H\u0001\u0007q(A\u0004oK^\u001c\u0016N_3\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005A!/\u001a8b[\u0016$v\u000eF\u0002'\u0003/Bq!!\u0017\u0002R\u0001\u0007\u0001%A\u0001g\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\nQA\u001a7vg\"$\u0012A\n\u0005\b\u0003G\u0002A\u0011AA3\u00039!W\r\\3uK&3W\t_5tiN$\u0012a\u0012\u0005\b\u0003S\u0002A\u0011AA0\u0003=!(/[7U_Z\u000bG.\u001b3TSj,\u0007BBA7\u0001\u0011\u0005a(A\u0006tSj,\u0017J\u001c\"zi\u0016\u001c\bbBA9\u0001\u0011\u0005\u0011qL\u0001\u0006G2|7/\u001a\u0005\b\u0003k\u0002A\u0011AA0\u00031\u0019Gn\\:f\u0011\u0006tG\r\\3s\u0011\u001d\tI\b\u0001D\u0001\u0003?\n1b]1oSRL8\t[3dW\"9\u0011Q\u0010\u0001\u0007\u0012\u0005}\u0013\u0001\u0003;sk:\u001c\u0017\r^3\t\u000f\u0005\u0005\u0005A\"\u0001\u0002\u0004\u0006QAO];oG\u0006$X\rV8\u0015\u0007\u0019\n)\tC\u0004\u0002\b\u0006}\u0004\u0019A\u001c\u0002\r=4gm]3u\u0011\u001d\tY\t\u0001C\u0001\u0003?\nQA]3tKRDq!a$\u0001\t\u0003\t\t*\u0001\bsK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\u0007}\n\u0019\nC\u0004\u0002\b\u00065\u0005\u0019A\u001c\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006y1-\u00198BaB,g\u000eZ(gMN,G\u000fF\u0002H\u00037Cq!a\"\u0002\u0016\u0002\u0007q\u0007C\u0004\u0002 \u0002!\t\"a\u0018\u0002\u001dM\fg-\u001a$pe\u000e,WK\\7ba\"A\u00111\u0015\u0001\u0005\u0012\t\ty&\u0001\u0006g_J\u001cW-\u00168nCBDq!a*\u0001\t#\tI+A\u0005nCf\u0014W\rT8dWV!\u00111VAY)\u0011\ti+a0\u0015\t\u0005=\u0016Q\u0017\t\u0004%\u0006EFaBAZ\u0003K\u0013\r!\u0016\u0002\u0002)\"I\u0011qWAS\t\u0003\u0007\u0011\u0011X\u0001\u0004MVt\u0007#B\u0014\u0002<\u0006=\u0016bAA_Q\tAAHY=oC6,g\bC\u0004r\u0003K\u0003\r!!1\u0011\u0007Q\f\u0019-C\u0002\u0002FV\u0014A\u0001T8dW\"9\u0011\u0011\u001a\u0001\u0007\u0012\u0005-\u0017A\u00039beN,WI\u001c;ssR1\u0011QZAj\u0003;\u00042\u0001UAh\u0013\r\t\tN\u0001\u0002\u000b\u0013:$W\r_#oiJL\b\u0002CAk\u0003\u000f\u0004\r!a6\u0002\r\t,hMZ3s!\u0011\t9!!7\n\t\u0005m\u0017\u0011\u0002\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBAp\u0003\u000f\u0004\raP\u0001\u0002]\"9\u00111\u001d\u0001\u0005\u0012\u0005\u0015\u0018\u0001\u00077be\u001e,7\u000f\u001e'po\u0016\u0014(i\\;oINcw\u000e\u001e$peR9q(a:\u0002l\u0006=\b\u0002CAu\u0003C\u0004\r!a6\u0002\u0007%$\u0007\u0010C\u0004\u0002n\u0006\u0005\b\u0019A\u001c\u0002\rQ\f'oZ3u\u0011!\t\t0!9A\u0002\u0005M\u0018\u0001D:fCJ\u001c\u0007.\u00128uSRL\b\u0003BA{\u0005\u0013qA!a>\u0003\u00069!\u0011\u0011 B\u0002\u001d\u0011\tYP!\u0001\u000e\u0005\u0005u(bAA\u0000\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u0007\u0011I1Aa\u0002\u0003\u0003=Ie\u000eZ3y'\u0016\f'o\u00195UsB,\u0017\u0002\u0002B\u0006\u0005\u001b\u0011\u0011#\u00138eKb\u001cV-\u0019:dQ\u0016sG/\u001b;z\u0015\r\u00119A\u0001\u0005\b\u0005#\u0001A\u0011\u0003B\n\u0003e\u0019X.\u00197mKN$X\u000b\u001d9fe\n{WO\u001c3TY>$hi\u001c:\u0015\u000f}\u0012)Ba\u0006\u0003\u001a!A\u0011\u0011\u001eB\b\u0001\u0004\t9\u000eC\u0004\u0002n\n=\u0001\u0019A\u001c\t\u0011\u0005E(q\u0002a\u0001\u0003gDqA!\b\u0001\t\u0013\u0011y\"A\tj]\u0012,\u0007p\u00157piJ\u000bgnZ3G_J$\u0002B!\t\u0003(\t%\"1\u0006\t\u0006O\t\rrhP\u0005\u0004\u0005KA#A\u0002+va2,'\u0007\u0003\u0005\u0002j\nm\u0001\u0019AAl\u0011\u001d\tiOa\u0007A\u0002]B\u0001\"!=\u0003\u001c\u0001\u0007\u00111\u001f\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0003E\u0019w.\u001c9be\u0016Le\u000eZ3y\u000b:$(/\u001f\u000b\b\u007f\tM\"q\u0007B\u001d\u0011!\u0011)D!\fA\u0002\u00055\u0017AC5oI\u0016DXI\u001c;ss\"9\u0011Q\u001eB\u0017\u0001\u00049\u0004\u0002CAy\u0005[\u0001\r!a=\t\u000f\tu\u0002\u0001\"\u0003\u0003@\u0005A\"o\\;oI\u0012{wO\u001c+p\u000bb\f7\r^'vYRL\u0007\u000f\\3\u0015\u000b}\u0012\tE!\u0012\t\u000f\t\r#1\ba\u0001\u007f\u00051a.^7cKJDqAa\u0012\u0003<\u0001\u0007q(\u0001\u0004gC\u000e$xN\u001d\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0003)!xNU3mCRLg/\u001a\u000b\u0005\u0005\u001f\u0012)\u0006\u0005\u0003(\u0005#z\u0014b\u0001B*Q\t1q\n\u001d;j_:Dq!a\"\u0003J\u0001\u0007qgB\u0005\u0003Z\t\t\t\u0011#\u0001\u0003\\\u0005i\u0011IY:ue\u0006\u001cG/\u00138eKb\u00042\u0001\u0015B/\r!\t!!!A\t\u0002\t}3\u0003\u0002B/\u0005C\u00022a\nB2\u0013\r\u0011)\u0007\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000f5\u0013i\u0006\"\u0001\u0003jQ\u0011!1\f\u0005\u000b\u0005[\u0012i&%A\u0005\u0002\t=\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0004\u0003r\t\u001d%\u0011R\u000b\u0003\u0005gR3a\u0010B;W\t\u00119\b\u0005\u0003\u0003z\t\rUB\u0001B>\u0015\u0011\u0011iHa \u0002\u0013Ut7\r[3dW\u0016$'b\u0001BAQ\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015%1\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002+\u0003l\t\u0007Q\u000b\u0002\u0004_\u0005W\u0012\r!\u0016")
public abstract class AbstractIndex<K, V>
implements Closeable,
Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long _length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    private long _length() {
        return this._length;
    }

    private void _length_$eq(long x$1) {
        this._length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this._length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            int roundedNewSize = this.roundDownToExactMultiple(newSize, this.entrySize());
            if (this._length() == (long)roundedNewSize) {
                bl = false;
            } else {
                RandomAccessFile raf = new RandomAccessFile(this.file(), "rw");
                try {
                    int position = this.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this._length_$eq(roundedNewSize);
                    this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    $this._maxEntries = this.mmap().limit() / this.entrySize();
                    this.mmap().position(position);
                    bl = true;
                }
                finally {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
            }
            return bl;
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.mmap().force());
    }

    public boolean deleteIfExists() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.safeForceUnmap());
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.resize(this.entrySize() * this._entries()));
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.safeForceUnmap());
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset) {
        Option<Object> relativeOffset = this.toRelative(offset);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringBuilder(32).append("Integer overflow for offset: ").append(offset).append(" (").append(this.file().getAbsoluteFile()).append(")").toString());
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset) {
        return this.toRelative(offset).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error unmapping index ").append(this.file()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        int n;
        Enumeration.Value value = searchEntity;
        Enumeration.Value value2 = IndexSearchType$.MODULE$.KEY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
        } else {
            Enumeration.Value value4 = IndexSearchType$.MODULE$.VALUE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            } else {
                throw new MatchError((Object)value);
            }
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset) {
        long relativeOffset = offset - this.baseOffset();
        return relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, Enumeration.Value searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Invalid max index size: ").append(maxIndexSize).toString());
                }
                raf.setLength(this.roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this._length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.roundDownToExactMultiple(idx.limit(), this.entrySize()));
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

