/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.CleanedTransactionMetadata$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEd!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005\"\u0002.\u0001\t#Z\u0016A\u00037pO\u001e,'OT1nKV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\rM#(/\u001b8h\u0011\u001d)\u0007\u00011A\u0005\n\u0019\f!B]3bI\n+hMZ3s+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016a\u0003\rq\u0017n\\\u0005\u0003Y&\u0014!BQ=uK\n+hMZ3s\u0011\u001dq\u0007\u00011A\u0005\n=\faB]3bI\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002Ka\"9\u0011/\\A\u0001\u0002\u00049\u0017a\u0001=%c!11\u000f\u0001Q!\n\u001d\f1B]3bI\n+hMZ3sA!9Q\u000f\u0001a\u0001\n\u00131\u0017aC<sSR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010A\bxe&$XMQ;gM\u0016\u0014x\fJ3r)\tQ\u0015\u0010C\u0004rm\u0006\u0005\t\u0019A4\t\rm\u0004\u0001\u0015)\u0003h\u000319(/\u001b;f\u0005V4g-\u001a:!\u0011\u001di\bA1A\u0005\ny\f1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u00029\u0003\u0019\u0011XmY8sI&!\u0011\u0011BA\u0002\u00059\u0011UO\u001a4feN+\b\u000f\u001d7jKJDq!!\u0004\u0001A\u0003%q0\u0001\u000feK\u000e|W\u000e\u001d:fgNLwN\u001c\"vM\u001a,'oU;qa2LWM\u001d\u0011\t\u0011\u0005E\u0001\u0001\"\u0001\u0003\u0003'\tQa\u00197fC:$B!!\u0006\u0002(A9\u0001\"a\u0006\u0002\u001c\u0005\u0005\u0012bAA\r\u0013\t1A+\u001e9mKJ\u00022\u0001CA\u000f\u0013\r\ty\"\u0003\u0002\u0005\u0019>tw\rE\u0002!\u0003GI1!!\n\u0003\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011!\tI#a\u0004A\u0002\u0005-\u0012!C2mK\u0006t\u0017M\u00197f!\r\u0001\u0013QF\u0005\u0004\u0003_\u0011!A\u0003'pOR{7\t\\3b]\"A\u00111\u0007\u0001\u0005\u0002\t\t)$A\u0004e_\u000ecW-\u00198\u0015\r\u0005U\u0011qGA\u001d\u0011!\tI#!\rA\u0002\u0005-\u0002\u0002CA\u001e\u0003c\u0001\r!a\u0007\u0002\u001f\u0011,G.\u001a;f\u0011>\u0014\u0018N_8o\u001bND\u0001\"a\u0010\u0001\t\u0003\u0011\u0011\u0011I\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015\u0017)\u000b\u0019%a\u0013\u0002n\u0005E\u00141\u000f\u0005\b\u0007\u0005u\u0002\u0019AA#!\r\u0001\u0013qI\u0005\u0004\u0003\u0013\u0012!a\u0001'pO\"A\u0011QJA\u001f\u0001\u0004\ty%\u0001\u0005tK\u001elWM\u001c;t!\u0019\t\t&!\u0019\u0002h9!\u00111KA/\u001d\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-+\u00051AH]8pizJ\u0011AC\u0005\u0004\u0003?J\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)GA\u0002TKFT1!a\u0018\n!\r\u0001\u0013\u0011N\u0005\u0004\u0003W\u0012!A\u0003'pON+w-\\3oi\"9\u0011qNA\u001f\u0001\u0004y\u0012aA7ba\"A\u00111HA\u001f\u0001\u0004\tY\u0002\u0003\u0005\u0002v\u0005u\u0002\u0019AA\u0011\u0003\u0015\u0019H/\u0019;t\u0011!\tI\b\u0001C\u0001\u0005\u0005m\u0014!C2mK\u0006t\u0017J\u001c;p)MQ\u0015QPAA\u0003\u0017\u000by)!%\u0002\u001c\u0006}\u0015\u0011VA_\u0011\u001d\ty(a\u001eA\u0002\u0019\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002\u0004\u0006]\u0004\u0019AAC\u00035\u0019x.\u001e:dKJ+7m\u001c:egB!\u0011\u0011AAD\u0013\u0011\tI)a\u0001\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm\u001d\u0005\t\u0003\u001b\u000b9\b1\u0001\u0002h\u0005!A-Z:u\u0011\u001d\ty'a\u001eA\u0002}A\u0001\"a%\u0002x\u0001\u0007\u0011QS\u0001\u000ee\u0016$\u0018-\u001b8EK2,G/Z:\u0011\u0007!\t9*C\u0002\u0002\u001a&\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001e\u0006]\u0004\u0019A\f\u0002#5\f\u0007\u0010T8h\u001b\u0016\u001c8/Y4f'&TX\r\u0003\u0005\u0002\"\u0006]\u0004\u0019AAR\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\r\u0001\u0013QU\u0005\u0004\u0003O\u0013!AG\"mK\u0006tW\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007\u0002CAV\u0003o\u0002\r!!,\u0002\u001f\u0005\u001cG/\u001b<f!J|G-^2feN\u0004r!a,\u00028\u0006mqC\u0004\u0003\u00022\u0006M\u0006cAA+\u0013%\u0019\u0011QW\u0005\u0002\rA\u0013X\rZ3g\u0013\u0011\tI,a/\u0003\u00075\u000b\u0007OC\u0002\u00026&A\u0001\"!\u001e\u0002x\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003\u0003\u0004A\u0011BAb\u0003E9'o\\<Ck\u001a4WM]:Pe\u001a\u000b\u0017\u000e\u001c\u000b\n\u0015\u0006\u0015\u0017qYAf\u0003\u001bD\u0001\"a!\u0002@\u0002\u0007\u0011Q\u0011\u0005\b\u0003\u0013\fy\f1\u0001\u0018\u0003!\u0001xn]5uS>t\u0007bBAO\u0003\u007f\u0003\ra\u0006\u0005\t\u0003\u001f\fy\f1\u0001\u0002R\u0006iQ.Z7pef\u0014VmY8sIN\u0004B!!\u0001\u0002T&!\u0011Q[A\u0002\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0017AE:i_VdG\rR5tG\u0006\u0014HMQ1uG\"$\u0002\"!&\u0002^\u0006\u001d\u0018\u0011\u001e\u0005\t\u0003?\f9\u000e1\u0001\u0002b\u0006)!-\u0019;dQB!\u0011\u0011AAr\u0013\u0011\t)/a\u0001\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\t\u0003C\u000b9\u000e1\u0001\u0002$\"A\u00111^Al\u0001\u0004\t)*\u0001\tsKR\f\u0017N\u001c+y]6\u000b'o[3sg\"9\u0011q\u001e\u0001\u0005\n\u0005E\u0018AE:i_VdGMU3uC&t'+Z2pe\u0012$B\"!&\u0002t\u0006U\u0018q_A}\u0005\u0003Aq!a\u001c\u0002n\u0002\u0007q\u0004\u0003\u0005\u0002\u0014\u00065\b\u0019AAK\u0011!\ty.!<A\u0002\u0005\u0005\b\u0002CA\u0003\u0003[\u0004\r!a?\u0011\t\u0005\u0005\u0011Q`\u0005\u0005\u0003\u007f\f\u0019A\u0001\u0004SK\u000e|'\u000f\u001a\u0005\t\u0003k\ni\u000f1\u0001\u0002\"!9!Q\u0001\u0001\u0005\u0002\t\u001d\u0011aC4s_^\u0014UO\u001a4feN$2A\u0013B\u0005\u0011\u001d\tiJa\u0001A\u0002]AqA!\u0004\u0001\t\u0003\u0011y!\u0001\bsKN$xN]3Ck\u001a4WM]:\u0015\u0003)C\u0001Ba\u0005\u0001\t\u0003\u0011!QC\u0001\u0014OJ|W\u000f]*fO6,g\u000e^:CsNK'0\u001a\u000b\u000b\u0005/\u0011iBa\u000b\u00030\tM\u0002CBA)\u00053\ty%\u0003\u0003\u0003\u001c\u0005\u0015$\u0001\u0002'jgRD\u0001\"!\u0014\u0003\u0012\u0001\u0007!q\u0004\t\u0007\u0005C\u00119#a\u001a\u000e\u0005\t\r\"b\u0001B\u0013\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%\"1\u0005\u0002\t\u0013R,'/\u00192mK\"9!Q\u0006B\t\u0001\u00049\u0012aB7bqNK'0\u001a\u0005\b\u0005c\u0011\t\u00021\u0001\u0018\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0011!\u0011)D!\u0005A\u0002\u0005m\u0011A\u00064jeN$XK\\2mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;\t\u000f\te\u0002\u0001\"\u0003\u0003<\u0005IB.Y:u\u001f\u001a47/\u001a;G_J4\u0015N]:u'\u0016<W.\u001a8u)\u0019\tYB!\u0010\u0003D!A!q\bB\u001c\u0001\u0004\u0011\t%\u0001\u0003tK\u001e\u001c\bCBA)\u00053\t9\u0007\u0003\u0005\u00036\t]\u0002\u0019AA\u000e\u0011!\u00119\u0005\u0001C\u0001\u0005\t%\u0013A\u00042vS2$wJ\u001a4tKRl\u0015\r\u001d\u000b\f\u0015\n-#Q\nB)\u0005+\u00129\u0006C\u0004\u0004\u0005\u000b\u0002\r!!\u0012\t\u0011\t=#Q\ta\u0001\u00037\tQa\u001d;beRD\u0001Ba\u0015\u0003F\u0001\u0007\u00111D\u0001\u0004K:$\u0007bBA8\u0005\u000b\u0002\ra\b\u0005\t\u0003k\u0012)\u00051\u0001\u0002\"!9!1\f\u0001\u0005\n\tu\u0013\u0001\u00072vS2$wJ\u001a4tKRl\u0015\r\u001d$peN+w-\\3oiR\u0001\u0012Q\u0013B0\u0005C\u0012)Ga\u001a\u0003l\t5$q\u000e\u0005\b\u0003\u007f\u0012I\u00061\u0001G\u0011!\u0011\u0019G!\u0017A\u0002\u0005\u001d\u0014aB:fO6,g\u000e\u001e\u0005\b\u0003_\u0012I\u00061\u0001 \u0011!\u0011IG!\u0017A\u0002\u0005m\u0011aC:uCJ$xJ\u001a4tKRDq!!(\u0003Z\u0001\u0007q\u0003\u0003\u0005\u0002\"\ne\u0003\u0019AAR\u0011!\t)H!\u0017A\u0002\u0005\u0005\u0002")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        long l;
        Option option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogSegment seg = (LogSegment)some.value();
            l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        long deleteHorizonMs = l;
        return this.doClean(cleanable, deleteHorizonMs);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(deleteHorizonMs)})));
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), deleteHorizonMs, stats);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats) {
        LogSegment cleaned = LogCleaner$.MODULE$.createNewCleanedSegment(log, ((LogSegment)segments.head()).baseOffset());
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> map.latestOffset() + 1L));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, (Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
                boolean retainDeletes = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Cleaning segment ").append(startOffset).append(" in log ").append(log.name()).append(" (largest timestamp ").append(new Date(currentSegment.largestTimestamp())).append(") ").append(new StringBuilder(16).append("into ").append(cleaned.baseOffset()).append(", ").append((Object)(retainDeletes ? "retaining" : "discarding")).append(" deletes.").toString()).toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletes, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, log.activeProducersWithLastSequence(), stats);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments, log.replaceSegments$default$3());
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            finally {
                throw e;
            }
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, Object> activeProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, map, retainDeletes, transactionMetadata, activeProducers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanedTransactionMetadata transactionMetadata$1;
            private final Map activeProducers$1;
            private final CleanerStats stats$4;

            public boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            public void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$1, this.retainDeletes$2));
                return batch.hasProducerId() && this.activeProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).contains((Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$3, this.retainDeletes$2, batch, record, this.stats$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.transactionMetadata$1 = transactionMetadata$1;
                this.activeProducers$1 = activeProducers$1;
                this.stats$4 = stats$4;
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record.hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && record.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && !record.hasValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append("bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        block1: {
            if (this.readBuffer().capacity() > this.ioBufferSize) {
                this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            }
            if (this.writeBuffer().capacity() <= this.ioBufferSize) break block1;
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? ((LogSegment)segs.apply(1)).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, CleanedTransactionMetadata$.MODULE$.apply$default$2());
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$2(full, segment))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$buildOffsetMap$3(this, log, start, map, stats, dirty, transactionMetadata, full, segment);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        boolean bl;
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(67).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(map, startOffset, transactionMetadata, stats, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            this.restoreBuffers();
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$2(BooleanRef full$1, LogSegment segment) {
        return !full$1.elem;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$3(Cleaner $this, Log log$3, long start$1, OffsetMap map$1, CleanerStats stats$3, Buffer dirty$1, CleanedTransactionMetadata transactionMetadata$2, BooleanRef full$1, LogSegment segment) {
        block0: {
            $this.checkDone.apply((Object)log$3.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$3.topicPartition(), segment, map$1, start$1, Predef$.MODULE$.Integer2int(log$3.config().maxMessageSize()), transactionMetadata$2, stats$3);
            if (!full$1.elem) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(OffsetMap map$4, long startOffset$2, CleanerStats stats$5, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$2) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(OffsetMap map$4, long startOffset$2, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$5, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MutableRecordBatch batch) {
        block4: {
            if (batch.isControlBatch()) {
                transactionMetadata$3.onControlBatchRead((RecordBatch)batch);
                stats$5.indexMessagesRead(1);
            } else {
                boolean isAborted = transactionMetadata$3.onBatchRead((RecordBatch)batch);
                if (isAborted) {
                    stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                } else {
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                        Cleaner.$anonfun$buildOffsetMapForSegment$2(map$4, startOffset$2, stats$5, maxDesiredMapSize$1, nonLocalReturnKey1$1, record);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (batch.lastOffset() < startOffset$2) break block4;
            map$4.updateLatestOffset(batch.lastOffset());
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

