/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashSet;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001\u001d\u0011q#\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195D_:$X\r\u001f;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\r\r\u0016$8\r[\"p]R,\u0007\u0010\u001e\u0005\t'\u0001\u0011)\u0019!C\u0005)\u0005!A/[7f+\u0005)\u0002C\u0001\f!\u001b\u00059\"B\u0001\r\u001a\u0003\u0015)H/\u001b7t\u0015\tQ2$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bqQ!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO&\u0011\u0011e\u0006\u0002\u0005)&lW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0015!\u0018.\\3!\u0011!)\u0003A!b\u0001\n\u00131\u0013a\u0003:fc6+G/\u00193bi\u0006,\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003Ue\t\u0001B]3rk\u0016\u001cHo]\u0005\u0003Y%\u0012QBR3uG\"lU\r^1eCR\f\u0007\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u0019I,\u0017/T3uC\u0012\fG/\u0019\u0011\t\u0011A\u0002!Q1A\u0005\nE\nqa]3tg&|g.F\u00013!\ty1'\u0003\u00025\u0005\taa)\u001a;dQN+7o]5p]\"Aa\u0007\u0001B\u0001B\u0003%!'\u0001\u0005tKN\u001c\u0018n\u001c8!\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q!!h\u000f\u001f>!\ty\u0001\u0001C\u0003\u0014o\u0001\u0007Q\u0003C\u0003&o\u0001\u0007q\u0005C\u00031o\u0001\u0007!\u0007C\u0003@\u0001\u0011\u0005\u0003)\u0001\bhKR4U\r^2i\u001f\u001a47/\u001a;\u0015\u0005\u0005;\u0005cA\u0005C\t&\u00111I\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005%)\u0015B\u0001$\u000b\u0005\u0011auN\\4\t\u000b!s\u0004\u0019A%\u0002\u0005Q\u0004\bC\u0001&L\u001b\u0005I\u0012B\u0001'\u001a\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DQA\u0014\u0001\u0005B=\u000b\u0001CZ8sK\u0006\u001c\u0007\u000eU1si&$\u0018n\u001c8\u0015\u0005A\u001b\u0006CA\u0005R\u0013\t\u0011&B\u0001\u0003V]&$\b\"\u0002+N\u0001\u0004)\u0016a\u00014v]B)\u0011BV%Y!&\u0011qK\u0003\u0002\n\rVt7\r^5p]J\u0002\"!\u0017/\u000f\u0005!R\u0016BA.*\u000311U\r^2i%\u0016\fX/Z:u\u0013\tifLA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u00037&2A\u0001\u0019\u0001\u0005C\n\t\u0002+\u0019:uSRLwN\\%uKJ\fGo\u001c:\u0014\u0007}\u0013'\u000e\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!A.\u00198h\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\r=\u0013'.Z2u!\tYgN\u0004\u0002\u0010Y&\u0011QNA\u0001\r\r\u0016$8\r[*fgNLwN\\\u0005\u0003_B\u0014QBU#T!~k\u0015\tU0J)\u0016\u0013&BA7\u0003\u0011!\u0011xL!b\u0001\n\u0003\u0019\u0018\u0001B5uKJ,\u0012A\u001b\u0005\tk~\u0013\t\u0011)A\u0005U\u0006)\u0011\u000e^3sA!Aqo\u0018BC\u0002\u0013\u0005\u00010A\u0013va\u0012\fG/\u001a$fi\u000eD7i\u001c8uKb$\u0018I\u001c3SK6|g/Z+og\u0016dWm\u0019;fIV\t\u0011\u0010\u0005\u0002\nu&\u00111P\u0003\u0002\b\u0005>|G.Z1o\u0011!ixL!A!\u0002\u0013I\u0018AJ;qI\u0006$XMR3uG\"\u001cuN\u001c;fqR\fe\u000e\u001a*f[>4X-\u00168tK2,7\r^3eA!)\u0001h\u0018C\u0001\u007fR1\u0011\u0011AA\u0003\u0003\u000f\u00012!a\u0001`\u001b\u0005\u0001\u0001\"\u0002:\u007f\u0001\u0004Q\u0007\"B<\u007f\u0001\u0004I\b\"CA\u0006?\u0002\u0007I\u0011AA\u0007\u0003-qW\r\u001f;FY\u0016lWM\u001c;\u0016\u0005\u0005=\u0001cBA\t\u0003CI\u0015q\u0005\b\u0005\u0003'\tYB\u0004\u0003\u0002\u0016\u0005]Q\"\u00014\n\u0007\u0005ea-\u0001\u0003vi&d\u0017\u0002BA\u000f\u0003?\t1!T1q\u0015\r\tIBZ\u0005\u0005\u0003G\t)CA\u0003F]R\u0014\u0018P\u0003\u0003\u0002\u001e\u0005}\u0001CBA\u0015\u0003_\t\u0019DD\u0002)\u0003WI1!!\f*\u000351U\r^2i%\u0016\u001c\bo\u001c8tK&\u0019Q,!\r\u000b\u0007\u00055\u0012\u0006\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI$G\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005u\u0012q\u0007\u0002\b%\u0016\u001cwN\u001d3t\u0011%\t\te\u0018a\u0001\n\u0003\t\u0019%A\boKb$X\t\\3nK:$x\fJ3r)\r\u0001\u0016Q\t\u0005\u000b\u0003\u000f\ny$!AA\u0002\u0005=\u0011a\u0001=%c!A\u00111J0!B\u0013\ty!\u0001\u0007oKb$X\t\\3nK:$\b\u0005C\u0004\u0002P}#\t%!\u0015\u0002\u000f!\f7OT3yiR\t\u0011\u0010C\u0004\u0002V}#\t%a\u0016\u0002\t9,\u0007\u0010\u001e\u000b\u0003\u0003\u001fAq!a\u0017`\t\u0003\ni&\u0001\u0004sK6|g/\u001a\u000b\u0003\u0003?\u00022!CA1\u0013\r\t\u0019G\u0003\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\t9\u0007\u0001C!\u0003S\nqbZ3u%\u0016\u001c\bo\u001c8tKNK'0\u001a\u000b\u0007\u0003W\n\t(a\u001f\u0011\u0007%\ti'C\u0002\u0002p)\u00111!\u00138u\u0011!\t\u0019(!\u001aA\u0002\u0005U\u0014aB;qI\u0006$Xm\u001d\t\u0004W\u0006]\u0014bAA=a\nA!+R*Q?6\u000b\u0005\u000b\u0003\u0005\u0002~\u0005\u0015\u0004\u0019AA@\u0003%1XM]:j_:LE\rE\u0002\n\u0003\u0003K1!a!\u000b\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t9\t\u0001C!\u0003\u0013\u000bQ$\u001e9eCR,\u0017I\u001c3HK:,'/\u0019;f%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u000b\u0005\u0003\u0017\u000b\t\nE\u0003)\u0003\u001b\u000b\u0019$C\u0002\u0002\u0010&\u0012QBR3uG\"\u0014Vm\u001d9p]N,\u0007\u0002CA:\u0003\u000b\u0003\r!!\u001e\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\u0006!r-\u001a;UQJ|G\u000f\u001e7fIJ+7\u000f]8og\u0016$B!a#\u0002\u001a\"A\u00111TAJ\u0001\u0004\tY'\u0001\buQJ|G\u000f\u001e7f)&lW-T:")
public class IncrementalFetchContext
implements FetchContext {
    private final Time time;
    private final FetchMetadata reqMetadata;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        IncrementalFetchContext incrementalFetchContext = this;
        synchronized (incrementalFetchContext) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    @Override
    public Option<Object> getFetchOffset(TopicPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.kafka$server$IncrementalFetchContext$$session().partitionMap().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)part -> {
                fun.apply((Object)new TopicPartition(part.topic(), part.partition()), (Object)part.reqData());
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicPartition, FetchResponse.PartitionData<Records>> updates, short versionId) {
        int n;
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (java.util.Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
        }
        return n;
    }

    @Override
    public FetchResponse<Records> updateAndGenerateResponseData(LinkedHashMap<TopicPartition, FetchResponse.PartitionData<Records>> updates) {
        FetchResponse fetchResponse;
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse2;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append(new StringBuilder(34).append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString()).toString());
                fetchResponse2 = new FetchResponse(Errors.INVALID_FETCH_SESSION_EPOCH, new LinkedHashMap(), 0, this.kafka$server$IncrementalFetchContext$$session().id());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").append(String.valueOf(this.partitionsToLogString(updates.keySet()))).toString());
                fetchResponse2 = new FetchResponse(Errors.NONE, updates, 0, this.kafka$server$IncrementalFetchContext$$session().id());
            }
            fetchResponse = fetchResponse2;
        }
        return fetchResponse;
    }

    @Override
    public FetchResponse<Records> getThrottledResponse(int throttleTimeMs) {
        FetchResponse fetchResponse;
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse2;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append(new StringBuilder(34).append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString()).toString());
                fetchResponse2 = new FetchResponse(Errors.INVALID_FETCH_SESSION_EPOCH, new LinkedHashMap(), throttleTimeMs, this.kafka$server$IncrementalFetchContext$$session().id());
            } else {
                fetchResponse2 = new FetchResponse(Errors.NONE, new LinkedHashMap(), throttleTimeMs, this.kafka$server$IncrementalFetchContext$$session().id());
            }
            fetchResponse = fetchResponse2;
        }
        return fetchResponse;
    }

    public IncrementalFetchContext(Time time, FetchMetadata reqMetadata, FetchSession session) {
        this.time = time;
        this.reqMetadata = reqMetadata;
        this.kafka$server$IncrementalFetchContext$$session = session;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }

    public class PartitionIterator
    implements java.util.Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> {
        private final java.util.Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> x$1) {
            java.util.Iterator.super.forEachRemaining(x$1);
        }

        public java.util.Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        public Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> nextElement() {
            return this.nextElement;
        }

        public void nextElement_$eq(Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> element = this.iter().next();
                TopicPartition topicPart = element.getKey();
                FetchResponse.PartitionData<Records> respData = element.getValue();
                CachedPartition cachedPart = (CachedPartition)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashSet.Element)new CachedPartition(topicPart));
                boolean mustRespond = cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected());
                if (mustRespond) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected()) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashSet.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> element = this.nextElement();
            this.nextElement_$eq(null);
            return var1_1;
        }

        public Nothing$ remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, java.util.Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.nextElement = null;
        }
    }
}

