/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherManager$;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011QCU3qY&\u001c\u0017MR3uG\",'/T1oC\u001e,'O\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002E\u0002\n\u00151i\u0011AA\u0005\u0003\u0017\t\u0011a#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\t\u0003\u00135I!A\u0004\u0002\u0003)I+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0011!\u0001\u0002A!A!\u0002\u0013\t\u0012\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0005\u0013\u0013\t\u0019\"AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0003\f\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\tq\u0003\u0005\u0002\n1%\u0011\u0011D\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!Y\u0002A!A!\u0002\u00139\u0012a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\t\u0011u\u0001!\u0011!Q\u0001\ny\tq!\\3ue&\u001c7\u000f\u0005\u0002 Q5\t\u0001E\u0003\u0002\u001eC)\u0011!eI\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!#BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001eL!!\u000b\u0011\u0003\u000f5+GO]5dg\"A1\u0006\u0001B\u0001B\u0003%A&\u0001\u0003uS6,\u0007CA\u00171\u001b\u0005q#BA\u0018\"\u0003\u0015)H/\u001b7t\u0013\t\tdF\u0001\u0003US6,\u0007\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bcA\u001b9u5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004PaRLwN\u001c\t\u0003w\ts!\u0001\u0010!\u0011\u0005u2T\"\u0001 \u000b\u0005}2\u0011A\u0002\u001fs_>$h(\u0003\u0002Bm\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\te\u0007\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\tI\u0001*\u0003\u0002J\u0005\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f5su\nU)S'B\u0011\u0011\u0002\u0001\u0005\u0006!)\u0003\r!\u0005\u0005\u0006+)\u0003\ra\u0006\u0005\u0006;)\u0003\rA\b\u0005\u0006W)\u0003\r\u0001\f\u0005\bg)\u0003\n\u00111\u00015\u0011\u00151%\n1\u0001H\u0011\u0015)\u0006\u0001\"\u0011W\u0003M\u0019'/Z1uK\u001a+Go\u00195feRC'/Z1e)\raq\u000b\u0018\u0005\u00061R\u0003\r!W\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"!\u000e.\n\u0005m3$aA%oi\")Q\f\u0016a\u0001=\u0006a1o\\;sG\u0016\u0014%o\\6feB\u0011qLY\u0007\u0002A*\u0011\u0011\rB\u0001\bG2,8\u000f^3s\u0013\t\u0019\u0007M\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\t\u000b\u0015\u0004A\u0011\u00014\u0002\u0011MDW\u000f\u001e3po:$\u0012a\u001a\t\u0003k!L!!\u001b\u001c\u0003\tUs\u0017\u000e^\u0004\bW\n\t\t\u0011#\u0001m\u0003U\u0011V\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ\u0004\"!C7\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001]N\u0011Qn\u001c\t\u0003kAL!!\u001d\u001c\u0003\r\u0005s\u0017PU3g\u0011\u0015YU\u000e\"\u0001t)\u0005a\u0007bB;n#\u0003%\tA^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0003]T#\u0001\u000e=,\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0013Ut7\r[3dW\u0016$'B\u0001@7\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003Y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReplicaFetcherManager
extends AbstractFetcherManager<ReplicaFetcherThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ReplicationQuotaManager quotaManager;

    public static Option<String> $lessinit$greater$default$5() {
        return ReplicaFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        String prefix = (String)this.threadNamePrefix.map((Function1 & java.io.Serializable & Serializable)tp -> new StringBuilder(1).append((String)tp).append(":").toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
        String threadName = new StringBuilder(22).append(prefix).append("ReplicaFetcherThread-").append(fetcherId).append("-").append(sourceBroker.id()).toString();
        return new ReplicaFetcherThread(threadName, fetcherId, sourceBroker, this.brokerConfig, this.replicaManager(), this.metrics, this.time, this.quotaManager, ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9());
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaManager = quotaManager;
        super(new StringBuilder(32).append("ReplicaFetcherManager on broker ").append(brokerConfig.brokerId()).toString(), "Replica", Predef$.MODULE$.Integer2int(brokerConfig.numReplicaFetchers()));
    }
}

