/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001\u001d\u0011Q\"\u00113nS:T6n\u00117jK:$(BA\u0002\u0005\u0003\tQ8NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003!Q8n\u00117jK:$\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u00055Y\u0015MZ6b5.\u001cE.[3oi\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!\b\u0010\u0011\u0005]\u0001\u0001\"B\u000b\u001b\u0001\u00041\u0002\"\u0002\u0011\u0001\t\u0003\t\u0013aC2sK\u0006$X\rV8qS\u000e$bAI\u00133oe\u001a\u0005CA\u0005$\u0013\t!#B\u0001\u0003V]&$\b\"\u0002\u0014 \u0001\u00049\u0013!\u0002;pa&\u001c\u0007C\u0001\u00150\u001d\tIS\u0006\u0005\u0002+\u00155\t1F\u0003\u0002-\r\u00051AH]8pizJ!A\f\u0006\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003])AQaM\u0010A\u0002Q\n!\u0002]1si&$\u0018n\u001c8t!\tIQ'\u0003\u00027\u0015\t\u0019\u0011J\u001c;\t\u000baz\u0002\u0019\u0001\u001b\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004;?A\u0005\t\u0019A\u001e\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA!\u001e;jY*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\t~\u0001\n\u00111\u0001F\u00035\u0011\u0018mY6Bo\u0006\u0014X-T8eKB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nB\u0001\u0006C\u0012l\u0017N\\\u0005\u0003\u0015\u001e\u0013QBU1dW\u0006;\u0018M]3N_\u0012,\u0007\"\u0002'\u0001\t\u0003i\u0015AE4fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCN$2AT,Y!\ry%\u000bV\u0007\u0002!*\u0011\u0011KC\u0001\u000bG>dG.Z2uS>t\u0017BA*Q\u0005\r\u0019V-\u001d\t\u0003\rVK!AV$\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\"9Ai\u0013I\u0001\u0002\u0004)\u0005bB-L!\u0003\u0005\rAW\u0001\u000bEJ|7.\u001a:MSN$\bcA\u0005\\;&\u0011AL\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\u0013F\u0007C\u0003`\u0001\u0011\u0005\u0001-\u0001\u0018de\u0016\fG/Z(s+B$\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8BgNLwM\\7f]R\u0004\u0016\r\u001e5J]j[E#\u0002\u0012bE\u001eL\u0007\"\u0002\u0014_\u0001\u00049\u0003\"B2_\u0001\u0004!\u0017A\u00079beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\b\u0003B(fiuK!A\u001a)\u0003\u00075\u000b\u0007\u000fC\u0004i=B\u0005\t\u0019A\u001e\u0002\r\r|gNZ5h\u0011\u001dQg\f%AA\u0002-\fa!\u001e9eCR,\u0007CA\u0005m\u0013\ti'BA\u0004C_>dW-\u00198\t\u000b=\u0004A\u0011\u00019\u00027Y\fG.\u001b3bi\u0016\u001c%/Z1uK>\u0013X\u000b\u001d3bi\u0016$v\u000e]5d)\u0015\u0011\u0013O]:u\u0011\u00151c\u000e1\u0001(\u0011\u0015\u0019g\u000e1\u0001e\u0011\u0015Ag\u000e1\u0001<\u0011\u0015Qg\u000e1\u0001l\u0011\u00151\b\u0001\"\u0003x\u0003u9(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$H\u0003\u0002\u0012ysnDQAJ;A\u0002\u001dBQA_;A\u0002\u0011\f\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u0015QW\u000f1\u0001l\u0011\u0015i\b\u0001\"\u0001\u007f\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0005\tz\b\"\u0002\u0014}\u0001\u00049\u0003bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\u001b\u0011\f9!!\u0003\u0002\u000e\u0005E\u0011QCA\r\u0011\u00191\u0013\u0011\u0001a\u0001O!9\u00111BA\u0001\u0001\u0004!\u0017AE3ySN$\u0018N\\4BgNLwM\\7f]RDq!a\u0004\u0002\u0002\u0001\u0007a*\u0001\u0006bY2\u0014%o\\6feND\u0011\"a\u0005\u0002\u0002A\u0005\t\u0019\u0001\u001b\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011%Q\u0018\u0011\u0001I\u0001\u0002\u0004\t9\u0002E\u0002\n7\u0012D\u0011\"a\u0007\u0002\u0002A\u0005\t\u0019A6\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"\u0005Ib/\u00197jI\u0006$XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u001d\u0011\u00131EA\u0013\u0003SAaA_A\u000f\u0001\u0004!\u0007bBA\u0014\u0003;\u0001\r\u0001N\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u0005\u0002,\u0005u\u0001\u0019AA\u0017\u0003I\tg/Y5mC\ndWM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\t!\ny\u0003N\u0005\u0004\u0003c\t$aA*fi\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012a\u00039beN,'I]8lKJ$B!!\u000f\u0002<A\u0019\u0011b\u0017\u001b\t\u000f\u0005u\u00121\u0007a\u0001O\u00051!M]8lKJDq!!\u0011\u0001\t\u0003\t\u0019%A\u0007dQ\u0006tw-Z\"p]\u001aLwm\u001d\u000b\bE\u0005\u0015\u0013\u0011JA'\u0011\u001d\t9%a\u0010A\u0002\u001d\n!\"\u001a8uSRLH+\u001f9f\u0011\u001d\tY%a\u0010A\u0002\u001d\n!\"\u001a8uSRLh*Y7f\u0011\u001d\ty%a\u0010A\u0002m\nqaY8oM&<7\u000fC\u0004\u0002T\u0001!\t!!\u0016\u0002)\rD\u0017M\\4f\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015\u0011\u0013qKA.\u0011\u001d\tI&!\u0015A\u0002\u001d\n\u0011c]1oSRL'0\u001a3DY&,g\u000e^%e\u0011\u001d\ty%!\u0015A\u0002mBq!a\u0018\u0001\t\u0003\t\t'\u0001\u0010dQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR)!%a\u0019\u0002h!9\u0011QMA/\u0001\u00049\u0013aE:b]&$\u0018N_3e\u000b:$\u0018\u000e^=OC6,\u0007bBA(\u0003;\u0002\ra\u000f\u0005\b\u0003W\u0002A\u0011AA7\u0003M1\u0018\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h)\u0015\u0011\u0013qNA9\u0011\u00191\u0013\u0011\u000ea\u0001O!9\u0011qJA5\u0001\u0004Y\u0004bBA;\u0001\u0011\u0005\u0011qO\u0001\u0012G\"\fgnZ3U_BL7mQ8oM&<G#\u0002\u0012\u0002z\u0005m\u0004B\u0002\u0014\u0002t\u0001\u0007q\u0005C\u0004\u0002P\u0005M\u0004\u0019A\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\u0006\u00112\r[1oO\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0015\u0011\u00131QAD\u0011\u001d\t))! A\u0002u\u000bqA\u0019:pW\u0016\u00148\u000fC\u0004\u0002P\u0005u\u0004\u0019A\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\fR)!%!$\u0002\u0010\"A\u0011QHAE\u0001\u0004\tI\u0004C\u0004\u0002P\u0005%\u0005\u0019A\u001e\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u0006!b/\u00197jI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$2AIAL\u0011\u001d\ty%!%A\u0002mBq!a'\u0001\t\u0013\ti*\u0001\ndQ\u0006tw-Z#oi&$\u0018pQ8oM&<Gc\u0002\u0012\u0002 \u0006\r\u0016q\u0015\u0005\b\u0003C\u000bI\n1\u0001(\u00039\u0011xn\u001c;F]RLG/\u001f+za\u0016Dq!!*\u0002\u001a\u0002\u0007q%A\fgk2d7+\u00198ji&TX\rZ#oi&$\u0018PT1nK\"9\u0011qJAM\u0001\u0004Y\u0004bBAV\u0001\u0011\u0005\u0011QV\u0001\u0012M\u0016$8\r[#oi&$\u0018pQ8oM&<G#B\u001e\u00020\u0006E\u0006bBAQ\u0003S\u0003\ra\n\u0005\b\u0003K\nI\u000b1\u0001(\u0011\u001d\t)\f\u0001C\u0001\u0003o\u000b!cZ3u\u00032dGk\u001c9jG\u000e{gNZ5hgR\u0011\u0011\u0011\u0018\t\u0005\u001f\u0016<3\bC\u0004\u0002>\u0002!\t!a0\u0002+\u0019,Go\u00195BY2,e\u000e^5us\u000e{gNZ5hgR!\u0011\u0011XAa\u0011\u001d\t9%a/A\u0002\u001dBq!!2\u0001\t\u0003\t9-\u0001\u000egKR\u001c\u0007.\u00117m\u0007\"LG\u000eZ#oi&$\u0018pQ8oM&<7\u000f\u0006\u0004\u0002:\u0006%\u00171\u001a\u0005\b\u0003C\u000b\u0019\r1\u0001(\u0011\u001d\ti-a1A\u0002\u001d\nqb\u00195jY\u0012,e\u000e^5usRK\b/\u001a\u0005\n\u0003#\u0004\u0011\u0013!C\u0001\u0003'\fAdZ3u\u0005J|7.\u001a:NKR\fG-\u0019;bg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002V*\u001aQ)a6,\u0005\u0005e\u0007\u0003BAn\u0003Kl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a9\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\fiNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a;\u0001#\u0003%\t!!<\u00029\u001d,GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u001e\u0016\u00045\u0006]\u0007\"CAz\u0001E\u0005I\u0011AA{\u0003a\u001a'/Z1uK>\u0013X\u000b\u001d3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e)bi\"LeNW&%I\u00164\u0017-\u001e7uIM*\"!a>+\u0007m\n9\u000eC\u0005\u0002|\u0002\t\n\u0011\"\u0001\u0002~\u0006A4M]3bi\u0016|%/\u00169eCR,Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;QCRD\u0017J\u001c.LI\u0011,g-Y;mi\u0012\"TCAA\u0000U\rY\u0017q\u001b\u0005\n\u0005\u0007\u0001\u0011\u0013!C\u0001\u0003k\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$C\u0007C\u0005\u0003\b\u0001\t\n\u0011\"\u0001\u0002T\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012*\u0004\"\u0003B\u0006\u0001E\u0005I\u0011\u0001B\u0007\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u0010)\u001aA'a6\t\u0013\tM\u0001!%A\u0005\u0002\tU\u0011aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u00119B\u000b\u0003\u0002\u0018\u0005]\u0007\"\u0003B\u000e\u0001E\u0005I\u0011AA\u007f\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$c\u0007")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminZkClient adminZkClient = this;
        synchronized (adminZkClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable & scala.Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        Seq brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        this.validateCreateOrUpdateTopic(topic, partitionReplicaAssignment, config, update);
        if (!update) {
            this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        }
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, update);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$3() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return false;
    }

    public void validateCreateOrUpdateTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update) {
        block6: {
            Topic.validate((String)topic);
            if (!update) {
                if (this.zkClient.topicExists(topic)) {
                    throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
                }
                if (Topic.hasCollisionChars((String)topic)) {
                    Seq<String> allTopics = this.zkClient.getAllTopicsInCluster();
                    if (allTopics.contains((Object)topic)) {
                        throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
                    }
                    Seq collidingTopics = (Seq)allTopics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateCreateOrUpdateTopic$1(topic, x$3)));
                    if (collidingTopics.nonEmpty()) {
                        throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
                    }
                }
            }
            if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
                throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
            }
            partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)reps -> {
                AdminZkClient.$anonfun$validateCreateOrUpdateTopic$3(partitionReplicaAssignment, reps);
                return BoxedUnit.UNIT;
            });
            if (update) break block6;
            LogConfig$.MODULE$.validate(config);
        }
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int partitionId = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (!update) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Topic creation ").append(assignment).toString());
                this.zkClient.createTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment);
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Topic update ").append(assignment).toString());
                this.zkClient.setTopicAssignment(topic, (scala.collection.immutable.Map<TopicPartition, Seq<Object>>)assignment, this.zkClient.setTopicAssignment$default$3());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        } else {
            throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
        }
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, Seq<Object>> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map proposedAssignment;
        block1: {
            Seq existingAssignmentPartition0 = (Seq)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
                throw new AdminOperationException(new StringBuilder(80).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append(new StringBuilder(12).append("Assignment: ").append(existingAssignment).toString()).toString());
            });
            int partitionsToAdd = numPartitions - existingAssignment.size();
            if (partitionsToAdd <= 0) {
                throw new InvalidPartitionsException(new StringBuilder(60).append("The number of partitions for a topic can only be increased. ").append(new StringBuilder(34).append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").toString()).append(new StringBuilder(26).append(numPartitions).append(" would not be an increase.").toString()).toString());
            }
            replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)proposedReplicaAssignment -> {
                this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom())).toSet());
                return BoxedUnit.UNIT;
            });
            Map proposedAssignmentForNewPartitions = (Map)replicaAssignment.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                int startIndex = package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$addPartitions$5(existingAssignmentPartition0, x$6))));
                return AdminUtils$.MODULE$.assignReplicasToBrokers(allBrokers, partitionsToAdd, existingAssignmentPartition0.size(), startIndex, existingAssignment.size());
            });
            proposedAssignment = existingAssignment.$plus$plus((GenTraversableOnce)proposedAssignmentForNewPartitions);
            if (validateOnly) break block1;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Creating ").append(partitionsToAdd).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(new StringBuilder(1).append(proposedAssignmentForNewPartitions).append(".").toString()).toString());
            String x$8 = topic;
            Map x$9 = proposedAssignment;
            boolean x$10 = true;
            Properties x$11 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
            this.createOrUpdateTopicPartitionAssignmentPathInZK(x$8, (Map<Object, Seq<Object>>)x$9, x$11, x$10);
        }
        return proposedAssignment;
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq replicas;
            int partitionId;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                partitionId = tuple2._1$mcI$sp();
                replicas = (Seq)tuple2._2();
                if (replicas.isEmpty()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
                }
                if (replicas.size() != replicas.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(53).append("Duplicate brokers not allowed in replica assignment: ").append(new StringBuilder(19).append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString()).toString());
                }
                if (!replicas.toSet().subsetOf((GenSet)availableBrokerIds)) {
                    throw new BrokerNotAvailableException(new StringBuilder(60).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append(new StringBuilder(21).append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").toString()).append(new StringBuilder(20).append("available brokers: ").append(availableBrokerIds.mkString(", ")).append(".").toString()).toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
            return tuple22;
        });
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(null, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition = A1._1$mcI$sp();
                    Seq replicas = (Seq)A1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                Seq replicas;
                Tuple2<Object, Seq<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (replicas = (Seq)tuple2._2()).size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$3)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$4)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$5)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder(52).append("Inconsistent replication factor between partitions, ").append(new StringBuilder(42).append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").toString()).append(new StringBuilder(37).append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString()).toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        None$ none$;
        String string = broker;
        String string2 = ConfigEntityName$.MODULE$.Default();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            try {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(broker)).toInt()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            none$ = some;
        }
        return none$;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Topic();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.changeTopicConfig(entityName, configs);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = ConfigType$.MODULE$.Client();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.changeClientIdConfig(entityName, configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = ConfigType$.MODULE$.User();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    this.changeUserOrUserClientIdConfig(entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = ConfigType$.MODULE$.Broker();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        this.changeBrokerConfig(this.parseBroker(entityName), configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(49).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.Topic()).append(", ").append(ConfigType$.MODULE$.Client()).append(", ").append(ConfigType$.MODULE$.Broker()).toString());
                    }
                }
            }
        }
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map = !(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)broker)).toString(), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable & scala.Serializable)x$7 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$7))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateCreateOrUpdateTopic$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ void $anonfun$validateCreateOrUpdateTopic$3(Map partitionReplicaAssignment$1, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$6) {
        return x$6.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$3) {
        int partitionId;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$4) {
        int partitionId;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = partitionId = tuple2._1$mcI$sp();
        return n;
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$5) {
        int rf;
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = rf = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$7) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$7)).toString();
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        Option option = rootPath;
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)option);
        }
        String root = string;
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        Option option2 = rootPath;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String path = (String)some.value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option2)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)option2);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging.$init$(this);
    }
}

