/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FetcherLagMetrics;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!\u0002\f\u0018\u0003\u0003a\u0002\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011A\u0019\t\u0011u\u0002!\u0011!Q\u0001\nIB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\")1\t\u0001C\u0001\t\"AQ\u000b\u0001b\u0001\n\u00039b\u000b\u0003\u0004c\u0001\u0001\u0006Ia\u0016\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019i\u0007\u0001)A\u0005K\"9a\u000e\u0001a\u0001\n\u0013y\u0007b\u00029\u0001\u0001\u0004%I!\u001d\u0005\u0007o\u0002\u0001\u000b\u0015\u0002!\t\u000ba\u0004A\u0011A=\t\rq\u0004A\u0011A\f~\u0011!\ti\u0002\u0001C\u0001/\u0005}\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003o\u0001a\u0011AA\u001d\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005]\u0004\u0001\"\u0001\u0002v\t1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'O\u0003\u0002\u00193\u000511/\u001a:wKJT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001+\ti\u0012j\u0005\u0003\u0001=\u0011R\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&Q5\taE\u0003\u0002(3\u0005)Q\u000f^5mg&\u0011\u0011F\n\u0002\b\u0019><w-\u001b8h!\tYc&D\u0001-\u0015\ti\u0013$A\u0004nKR\u0014\u0018nY:\n\u0005=b#!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006!a.Y7f+\u0005\u0011\u0004CA\u001a;\u001d\t!\u0004\b\u0005\u00026A5\taG\u0003\u000287\u00051AH]8pizJ!!\u000f\u0011\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s\u0001\nQA\\1nK\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\f]Vlg)\u001a;dQ\u0016\u00148\u000f\u0005\u0002 \u0003&\u0011!\t\t\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0003F%N#\u0006c\u0001$\u0001\u000f6\tq\u0003\u0005\u0002I\u00132\u0001A!\u0002&\u0001\u0005\u0004Y%!\u0001+\u0012\u00051{\u0005CA\u0010N\u0013\tq\u0005EA\u0004O_RD\u0017N\\4\u0011\u0005\u0019\u0003\u0016BA)\u0018\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012DQ\u0001M\u0003A\u0002IBQAP\u0003A\u0002IBQaP\u0003A\u0002\u0001\u000b\u0001CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199\u0016\u0003]\u0003B\u0001W/`\u000f6\t\u0011L\u0003\u0002[7\u00069Q.\u001e;bE2,'B\u0001/!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003=f\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002GA&\u0011\u0011m\u0006\u0002\u0015\u0005J|7.\u001a:JI\u0006sGMR3uG\",'/\u00133\u0002#\u0019,Go\u00195feRC'/Z1e\u001b\u0006\u0004\b%\u0001\u0003m_\u000e\\W#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001\u00027b]\u001eT\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n1qJ\u00196fGR\fQ\u0001\\8dW\u0002\nAC\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014X#\u0001!\u000219,XNR3uG\",'o\u001d)fe\n\u0013xn[3s?\u0012*\u0017\u000f\u0006\u0002skB\u0011qd]\u0005\u0003i\u0002\u0012A!\u00168ji\"9aoCA\u0001\u0002\u0004\u0001\u0015a\u0001=%c\u0005)b.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ\u0004\u0013\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\t\u0011(\u0010C\u0003|\u001b\u0001\u0007\u0001)A\u0004oK^\u001c\u0016N_3\u0002\u0015\u001d,GOR3uG\",'\u000fF\u0002\u007f\u0003\u0007\u00012aH@H\u0013\r\t\t\u0001\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0015a\u00021\u0001\u0002\b\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\u0005\u00033i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0007G>lWn\u001c8\u000b\u0007i\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0018\u0005\u0019qN]4\n\t\u0005m\u00111\u0002\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u000319W\r\u001e$fi\u000eDWM]%e)\r\u0001\u0015\u0011\u0005\u0005\b\u0003\u000by\u0001\u0019AA\u0004\u0003mi\u0017M]6QCJ$\u0018\u000e^5p]N4uN\u001d+sk:\u001c\u0017\r^5p]R9!/a\n\u0002,\u00055\u0002BBA\u0015!\u0001\u0007\u0001)\u0001\u0005ce>\\WM]%e\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000fAq!a\f\u0011\u0001\u0004\t\t$\u0001\tueVt7-\u0019;j_:|eMZ:fiB\u0019q$a\r\n\u0007\u0005U\u0002E\u0001\u0003M_:<\u0017aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$G#B$\u0002<\u0005}\u0002BBA\u001f#\u0001\u0007\u0001)A\u0005gKR\u001c\u0007.\u001a:JI\"9\u0011\u0011I\tA\u0002\u0005\r\u0013\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\b\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%\u0013$A\u0004dYV\u001cH/\u001a:\n\t\u00055\u0013q\t\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0003]\tG\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002s\u0003'Bq!!\u0016\u0013\u0001\u0004\t9&A\nqCJ$\u0018\u000e^5p]\u0006sGm\u00144gg\u0016$8\u000f\u0005\u0005\u0002Z\u0005m\u0013qAA0\u001b\u0005Y\u0016bAA/7\n\u0019Q*\u00199\u0011\u0007\u0019\u000b\t'C\u0002\u0002d]\u0011\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0003i\u0011X-\\8wK\u001a+Go\u00195fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\r\u0011\u0018\u0011\u000e\u0005\b\u0003W\u001a\u0002\u0019AA7\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u00033\ny'a\u0002\n\u0007\u0005E4LA\u0002TKR\f!d\u001d5vi\u0012|wO\\%eY\u00164U\r^2iKJ$\u0006N]3bIN$\u0012A]\u0001\u0011G2|7/Z!mY\u001a+Go\u00195feN\u0004")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Option option;
        Object object = this.lock();
        synchronized (object) {
            option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
        }
        return option;
    }

    public int getFetcherId(TopicPartition topicPartition) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
        }
        return n;
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)tuple2._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            });
            partitionsPerFetcher.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> {
                fetcher.removePartitions((Set<TopicPartition>)partitions);
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)tuple2._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$4)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$5);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
        }
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, Tuple2 x0$1) {
        Map<TopicPartition, InitialFetchState> removedPartitions;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)tuple2._1();
            AbstractFetcherThread thread = (AbstractFetcherThread)tuple2._2();
            removedPartitions = thread.partitionsAndOffsets();
            $this.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
            if (id.fetcherId() >= newSize$1) {
                thread.shutdown();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.addFetcherForPartitions(removedPartitions);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$addFetcherForPartitions$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        InitialFetchState brokerAndInitOffset = (InitialFetchState)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(brokerAndInitOffset.initOffset(), brokerAndInitOffset.currentLeaderEpoch()));
        return tuple22;
    }

    public static final /* synthetic */ String $anonfun$addFetcherForPartitions$5(BrokerAndFetcherId brokerAndFetcherId$1, Map initialOffsetAndEpochs$1) {
        return new StringBuilder(40).append("Added fetcher to broker ").append(brokerAndFetcherId$1.broker()).append(" for partitions ").append(initialOffsetAndEpochs$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$2) {
        var4_2 = x$2;
        if (var4_2 == null) ** GOTO lbl27
        brokerAndFetcherId = (BrokerAndFetcherId)var4_2._1();
        initialFetchOffsets = (Map)var4_2._2();
        brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
        var9_6 = false;
        var10_7 = null;
        var11_8 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
        if (!(var11_8 instanceof Some)) ** GOTO lbl-1000
        var9_6 = true;
        var10_7 = (Some)var11_8;
        currentFetcherThread = (AbstractFetcherThread)var10_7.value();
        v0 = currentFetcherThread.sourceBroker();
        var13_10 = brokerAndFetcherId.broker();
        if (!(v0 != null ? v0.equals(var13_10) == false : var13_10 != null)) {
            var3_11 = currentFetcherThread;
        } else if (var9_6) {
            f = (AbstractFetcherThread)var10_7.value();
            f.shutdown();
            var3_11 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else if (None$.MODULE$.equals(var11_8)) {
            var3_11 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else {
            throw new MatchError((Object)var11_8);
lbl27:
            // 1 sources

            throw new MatchError((Object)var4_2);
        }
        fetcherThread = var3_11;
        initialOffsetAndEpochs = (Map)initialFetchOffsets.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom());
        fetcherThread.addPartitions((Map<TopicPartition, OffsetAndEpoch>)initialOffsetAndEpochs);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addFetcherForPartitions$5(kafka.server.BrokerAndFetcherId scala.collection.Map ), ()Ljava/lang/String;)((BrokerAndFetcherId)brokerAndFetcherId, (Map)initialOffsetAndEpochs));
        var2_15 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        boolean bl = fetcher.initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        fetcher.shutdown();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$1(BoxesRunTime.unboxToLong((Object)curMaxAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ long $anonfun$value$2(long curMaxThread, Tuple2 fetcherLagStatsEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(curMaxThread), ((FetcherLagMetrics)fetcherLagStatsEntry._2()).lag());
            }

            public static final /* synthetic */ long $anonfun$value$1(long curMaxAll, Tuple2 fetcherThreadMapEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherLagStats().stats().foldLeft(BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxThread, fetcherLagStatsEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$2(BoxesRunTime.unboxToLong((Object)curMaxThread), fetcherLagStatsEntry))))), curMaxAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(java.lang.Object scala.Tuple2 ), $anonfun$value$2$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public double value() {
                double headRate = BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$3(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                return BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ double $anonfun$value$3(Tuple2 x$1) {
                return ((AbstractFetcherThread)x$1._2()).fetcherStats().requestRate().oneMinuteRate();
            }

            public static final /* synthetic */ double $anonfun$value$5(double curMinAll, Tuple2 fetcherThreadMapEntry) {
                return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherStats().requestRate().oneMinuteRate()), curMinAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4(), $anonfun$value$5$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
    }
}

