/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConnectionQuota;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rUw!\u0002(P\u0011\u0003!f!\u0002,P\u0011\u00039\u0006\"\u00020\u0002\t\u0003y\u0006\u0002\u00031\u0002\u0005\u0004%\taT1\t\rI\f\u0001\u0015!\u0003c\u0011\u001d\u0019\u0018A1A\u0005\u0002\u0005Da\u0001^\u0001!\u0002\u0013\u0011\u0007bB;\u0002\u0005\u0004%I!\u0019\u0005\u0007m\u0006\u0001\u000b\u0011\u00022\t\u000f]\f!\u0019!C\u0005q\"1A0\u0001Q\u0001\neDq!`\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004\u007f\u0003\u0001\u0006I!\u001f\u0005\t\u007f\u0006\u0011\r\u0011\"\u0001\u0002\u0002!A\u00111C\u0001!\u0002\u0013\t\u0019\u0001\u0003\u0005\u0002\u0016\u0005\u0011\r\u0011\"\u0003b\u0011\u001d\t9\"\u0001Q\u0001\n\tDq!!\u0007\u0002\t\u0003\tY\u0002C\u0004\u0002<\u0005!\t!!\u0010\t\u000f\u0005]\u0013\u0001\"\u0001\u0002Z!9\u00111O\u0001\u0005\n\u0005U\u0004bBA>\u0003\u0011%\u0011Q\u0010\u0005\b\u0003\u0003\u000bA\u0011BAB\u0011\u001d\t9)\u0001C\u0005\u0003\u0013C\u0001\"!$\u0002\t\u0003y\u0015q\u0012\u0005\t\u0003_\u000bA\u0011A(\u00022\u001a)ak\u0014\u0001\u0002:\"Q\u0011q\u0019\u000e\u0003\u0006\u0004%I!!3\t\u0015\u0005E'D!A!\u0002\u0013\tY\r\u0003\u0004_5\u0011\u0005\u00111\u001b\u0005\u000b\u00033T\"\u0019!C\u0001\u001f\u0006m\u0007\u0002CAq5\u0001\u0006I!!8\t\u0015\u0005\r(D1A\u0005\u0002=\u000bY\u000e\u0003\u0005\u0002fj\u0001\u000b\u0011BAo\u0011%\t9O\u0007b\u0001\n\u0013\tI\u000f\u0003\u0005\u0002nj\u0001\u000b\u0011BAv\u0011%\tyO\u0007b\u0001\n\u0013\tI\u000f\u0003\u0005\u0002rj\u0001\u000b\u0011BAv\u0011%\t\u0019P\u0007b\u0001\n\u0013\t)\u0010\u0003\u0005\u0003\u0006i\u0001\u000b\u0011BA|\u0011%\u00119A\u0007b\u0001\n\u0013\u0011I\u0001\u0003\u0005\u0003\u0014i\u0001\u000b\u0011\u0002B\u0006\u0011%\u0011)B\u0007b\u0001\n\u0013\u00119\u0002\u0003\u0005\u0003*i\u0001\u000b\u0011\u0002B\r\u0011%\u0011YC\u0007a\u0001\n\u0013\tI\rC\u0005\u0003.i\u0001\r\u0011\"\u0003\u00030!A!Q\u0007\u000e!B\u0013\tY\rC\u0005\u00038i\u0011\r\u0011\"\u0003\u0003:!A!q\t\u000e!\u0002\u0013\u0011Y\u0004\u0003\u0005\u0003Ji!\ta\u0014B&\u0011!\u0011iF\u0007C\u0001\u001f\n}\u0003b\u0002B15\u0011\u0005!1\r\u0005\b\u0005_RB\u0011\u0001B9\u0011\u001d\u00119H\u0007C\u0001\u0005sBqA! \u001b\t\u0003\u0011y\bC\u0004\u0003\u0004j!IA!\"\t\u0011\t-%\u0004\"\u0001P\u0003\u0013D\u0001B!$\u001b\t\u0003y%q\u0012\u0005\t\u0005+SB\u0011A(\u0003\u0010\"A!q\u0013\u000e\u0005\u0002=\u0013I\n\u0003\u0005\u0003*j!\ta\u0014BV\u0011!\u0011yK\u0007C\u0001\u001f\nE\u0006b\u0002B\\5\u0011%!\u0011\u0018\u0005\b\u0005\u001bTB\u0011\u0002Bh\u0011!\u0011\tN\u0007C\u0001\u001f\nM\u0007\u0002\u0003Bn5\u0011\u0005qJ!8\t\u000f\t\r(\u0004\"\u0003\u0003f\"9!1\u001f\u000e\u0005\n\tU\b\u0002\u0003B\u007f5\u0011\u0005qJa@\t\u000f\r\u0015!\u0004\"\u0003\u0004\b!A1Q\u0002\u000e\u0005\u0002=\u001by\u0001C\u0004\u00046i!Iaa\u000e\t\u000f\r\r$\u0004\"\u0003\u0004f!911\u000e\u000e\u0005\n\t}\u0003bBB75\u0011%1q\u000e\u0005\b\u0007\u007fRB\u0011BBA\u0011\u001d\u0019yI\u0007C\u0005\u0007#Cqaa.\u001b\t\u0013\u0019I,A\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwM\u0003\u0002Q#\u000611/\u001a:wKJT\u0011AU\u0001\u0006W\u000647.Y\u0002\u0001!\t)\u0016!D\u0001P\u0005M!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h'\t\t\u0001\f\u0005\u0002Z96\t!LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u000ba\u0003R=oC6L7mU3dkJLG/_\"p]\u001aLwm]\u000b\u0002EB\u00191\r\u001b6\u000e\u0003\u0011T!!\u001a4\u0002\u000f5,H/\u00192mK*\u0011qMW\u0001\u000bG>dG.Z2uS>t\u0017BA5e\u0005\r\u0019V\r\u001e\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fA\u0001\\1oO*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005\u0019\u0019FO]5oO\u00069B)\u001f8b[&\u001c7+Z2ve&$\u0018pQ8oM&<7\u000fI\u0001\u0012\u00032dG)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0018AE!mY\u0012Kh.Y7jG\u000e{gNZ5hg\u0002\n\u0001\u0003U3s\u0005J|7.\u001a:D_:4\u0017nZ:\u0002#A+'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%\u0001\rMSN$XM\\3s\u001b\u0016\u001c\u0007.\u00198jg6\u001cuN\u001c4jON,\u0012!\u001f\t\u0004unTW\"\u00014\n\u0005%4\u0017!\u0007'jgR,g.\u001a:NK\u000eD\u0017M\\5t[\u000e{gNZ5hg\u0002\nQCU3m_\u0006$\u0017M\u00197f\r&dWmQ8oM&<7/\u0001\fSK2|\u0017\rZ1cY\u00164\u0015\u000e\\3D_:4\u0017nZ:!\u0003Ma\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u0014VmZ3y+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u00115\fGo\u00195j]\u001eT1!!\u0004[\u0003\u0011)H/\u001b7\n\t\u0005E\u0011q\u0001\u0002\u0006%\u0016<W\r_\u0001\u0015\u0019&\u001cH/\u001a8fe\u000e{gNZ5h%\u0016<W\r\u001f\u0011\u0002-\u0011Kh.Y7jGB\u000b7o]<pe\u0012\u001cuN\u001c4jON\fq\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm\u001d\u0011\u0002!%\u001c\b+Y:to>\u0014HmQ8oM&<G\u0003BA\u000f\u0003G\u00012!WA\u0010\u0013\r\t\tC\u0017\u0002\b\u0005>|G.Z1o\u0011\u001d\t)#\u0005a\u0001\u0003O\tAA\\1nKB!\u0011\u0011FA\u001c\u001d\u0011\tY#a\r\u0011\u0007\u00055\",\u0004\u0002\u00020)\u0019\u0011\u0011G*\u0002\rq\u0012xn\u001c;?\u0013\r\t)DW\u0001\u0007!J,G-\u001a4\n\u0007E\fIDC\u0002\u00026i\u000bAC\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0016P\\8os6\u001cHCBA \u0003#\n\u0019\u0006\u0005\u0004\u0002B\u0005-\u0013q\u0005\b\u0005\u0003\u0007\n9E\u0004\u0003\u0002.\u0005\u0015\u0013\"A.\n\u0007\u0005%#,A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0013q\n\u0002\u0005\u0019&\u001cHOC\u0002\u0002JiCq!!\n\u0013\u0001\u0004\t9\u0003C\u0004\u0002VI\u0001\r!!\b\u0002+5\fGo\u00195MSN$XM\\3s\u001fZ,'O]5eK\u0006ya/\u00197jI\u0006$XmQ8oM&<7\u000f\u0006\u0004\u0002\\\u0005\u0005\u0014q\u000e\t\u00043\u0006u\u0013bAA05\n!QK\\5u\u0011\u001d\t\u0019g\u0005a\u0001\u0003K\nQ\u0001\u001d:paN\u0004B!a\u001a\u0002l5\u0011\u0011\u0011\u000e\u0006\u0004\u0003\u001bq\u0017\u0002BA7\u0003S\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t\th\u0005a\u0001\u0003;\tq\u0002]3s\u0005J|7.\u001a:D_:4\u0017nZ\u0001\u0011a\u0016\u0014(I]8lKJ\u001cuN\u001c4jON$B!a\u001e\u0002zA!!p_A\u0014\u0011\u001d\t\u0019\u0007\u0006a\u0001\u0003K\n\u0011C\\8o\tft\u0017-\\5d\u0007>tg-[4t)\u0011\t9(a \t\u000f\u0005\rT\u00031\u0001\u0002f\u0005!3/Z2ve&$\u0018pQ8oM&<7oV5uQ>,H\u000fT5ti\u0016tWM\u001d)sK\u001aL\u0007\u0010\u0006\u0003\u0002x\u0005\u0015\u0005bBA2-\u0001\u0007\u0011QM\u0001\u0014m\u0006d\u0017\u000eZ1uK\u000e{gNZ5h)f\u0004Xm\u001d\u000b\u0005\u00037\nY\tC\u0004\u0002d]\u0001\r!!\u001a\u0002#\u0005$G\rR=oC6L7mQ8oM&<7\u000f\u0006\u0003\u0002\\\u0005E\u0005bBAJ1\u0001\u0007\u0011QS\u0001\nG>tg-[4EK\u001a\u0004B!a&\u0002,6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003?\u000b\t+\u0001\u0004d_6lwN\u001c\u0006\u0004%\u0006\r&\u0002BAS\u0003O\u000ba!\u00199bG\",'BAAU\u0003\ry'oZ\u0005\u0005\u0003[\u000bIJA\u0005D_:4\u0017n\u001a#fM\u0006AB-\u001f8b[&\u001c7i\u001c8gS\u001e,\u0006\u000fZ1uK6{G-Z:\u0016\u0005\u0005M\u0006\u0003CA4\u0003k\u000b9#a\n\n\t\u0005]\u0016\u0011\u000e\u0002\u0004\u001b\u0006\u00048\u0003\u0002\u000eY\u0003w\u0003B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003\f\u0016!B;uS2\u001c\u0018\u0002BAc\u0003\u007f\u0013q\u0001T8hO&tw-A\u0006lC\u001a\\\u0017mQ8oM&<WCAAf!\r)\u0016QZ\u0005\u0004\u0003\u001f|%aC&bM.\f7i\u001c8gS\u001e\fAb[1gW\u0006\u001cuN\u001c4jO\u0002\"B!!6\u0002XB\u0011QK\u0007\u0005\b\u0003\u000fl\u0002\u0019AAf\u0003M\u0019H/\u0019;jG\n\u0013xn[3s\u0007>tg-[4t+\t\ti\u000eE\u0003d\u0003?T'.C\u0002\u00028\u0012\fAc\u001d;bi&\u001c'I]8lKJ\u001cuN\u001c4jON\u0004\u0013\u0001F:uCRL7\rR3gCVdGoQ8oM&<7/A\u000bti\u0006$\u0018n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm\u001d\u0011\u0002)\u0011Lh.Y7jG\n\u0013xn[3s\u0007>tg-[4t+\t\tY\u000fE\u0004d\u0003?\f9#a\n\u0002+\u0011Lh.Y7jG\n\u0013xn[3s\u0007>tg-[4tA\u0005)B-\u001f8b[&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\u0018A\u00063z]\u0006l\u0017n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm\u001d\u0011\u0002\u001fI,7m\u001c8gS\u001e,(/\u00192mKN,\"!a>\u0011\u000b\r\fI0!@\n\u0007\u0005mHM\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003\u007f\u0014\t!\u0004\u0002\u0002\u001e&!!1AAO\u00059\u0011VmY8oM&<WO]1cY\u0016\f\u0001C]3d_:4\u0017nZ;sC\ndWm\u001d\u0011\u0002+\t\u0014xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fgV\u0011!1\u0002\t\u0006G\u0006e(Q\u0002\t\u0004+\n=\u0011b\u0001B\t\u001f\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\faC\u0019:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,7\u000fI\u0001\u0005Y>\u001c7.\u0006\u0002\u0003\u001aA!!1\u0004B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012!\u00027pG.\u001c(\u0002\u0002B\u0012\u0003S\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\u00119C!\b\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\fQ\u0001\\8dW\u0002\nQbY;se\u0016tGoQ8oM&<\u0017!E2veJ,g\u000e^\"p]\u001aLwm\u0018\u0013fcR!\u00111\fB\u0019\u0011%\u0011\u0019$LA\u0001\u0002\u0004\tY-A\u0002yIE\nabY;se\u0016tGoQ8oM&<\u0007%\u0001\u000fes:\fW.[2D_:4\u0017n\u001a)bgN<xN\u001d3F]\u000e|G-\u001a:\u0016\u0005\tm\u0002#B-\u0003>\t\u0005\u0013b\u0001B 5\n1q\n\u001d;j_:\u0004B!!0\u0003D%!!QIA`\u0005=\u0001\u0016m]:x_J$WI\\2pI\u0016\u0014\u0018!\b3z]\u0006l\u0017nY\"p]\u001aLw\rU1tg^|'\u000fZ#oG>$WM\u001d\u0011\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0003\u0002\\\t5\u0003b\u0002B(c\u0001\u0007!\u0011K\u0001\tu.\u001cE.[3oiB!!1\u000bB-\u001b\t\u0011)FC\u0002\u0003XE\u000b!A_6\n\t\tm#Q\u000b\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u000b\rdW-\u0019:\u0015\u0005\u0005m\u0013AE1eIJ+7m\u001c8gS\u001e,(/\u00192mKN$B!a\u0017\u0003f!9!qM\u001aA\u0002\t%\u0014aC6bM.\f7+\u001a:wKJ\u00042!\u0016B6\u0013\r\u0011ig\u0014\u0002\f\u0017\u000647.Y*feZ,'/A\tbI\u0012\u0014VmY8oM&<WO]1cY\u0016$B!a\u0017\u0003t!9!Q\u000f\u001bA\u0002\u0005u\u0018A\u0004:fG>tg-[4ve\u0006\u0014G.Z\u0001\u0018C\u0012$'I]8lKJ\u0014VmY8oM&<WO]1cY\u0016$B!a\u0017\u0003|!9!QO\u001bA\u0002\t5\u0011\u0001\u0006:f[>4XMU3d_:4\u0017nZ;sC\ndW\r\u0006\u0003\u0002\\\t\u0005\u0005b\u0002B;m\u0001\u0007\u0011Q`\u0001\u001cm\u0016\u0014\u0018NZ=SK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0015\t\u0005m#q\u0011\u0005\b\u0005\u0013;\u0004\u0019AA<\u0003-\u0019wN\u001c4jO:\u000bW.Z:\u0002%\r,(O]3oi.\u000bgm[1D_:4\u0017nZ\u0001\u001cGV\u0014(/\u001a8u\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\tE\u0005c\u0002>\u0003\u0014\u0006\u001d\u0012qE\u0005\u0004\u0003o3\u0017\u0001H2veJ,g\u000e\u001e#z]\u0006l\u0017n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm]\u0001\u0013kB$\u0017\r^3Ce>\\WM]\"p]\u001aLw\r\u0006\u0004\u0002\\\tm%Q\u0015\u0005\b\u0005;[\u0004\u0019\u0001BP\u0003!\u0011'o\\6fe&#\u0007cA-\u0003\"&\u0019!1\u0015.\u0003\u0007%sG\u000fC\u0004\u0003(n\u0002\r!!\u001a\u0002\u001fA,'o]5ti\u0016tG\u000f\u0015:paN\f1#\u001e9eCR,G)\u001a4bk2$8i\u001c8gS\u001e$B!a\u0017\u0003.\"9!q\u0015\u001fA\u0002\u0005\u0015\u0014!\n:fY>\fG-\u00169eCR,GMR5mKN<\u0016\u000e\u001e5pkR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0011\tYFa-\t\u000f\tUV\b1\u0001\u0002f\u0005Aa.Z<Qe>\u00048/\u0001\u000enCf\u0014Wm\u0011:fCR,\u0007+Y:to>\u0014H-\u00128d_\u0012,'\u000f\u0006\u0003\u0003<\tm\u0006b\u0002B_}\u0001\u0007!qX\u0001\u0007g\u0016\u001c'/\u001a;\u0011\u000be\u0013iD!1\u0011\t\t\r'\u0011Z\u0007\u0003\u0005\u000bTAAa2\u0002\u001a\u0006)A/\u001f9fg&!!1\u001aBc\u0005!\u0001\u0016m]:x_J$\u0017a\u00049bgN<xN\u001d3F]\u000e|G-\u001a:\u0016\u0005\t\u0005\u0013!\u0005;p!\u0016\u00148/[:uK:$\bK]8qgR1\u0011Q\rBk\u00053DqAa6A\u0001\u0004\t)'A\u0006d_:4\u0017n\u001a)s_B\u001c\bbBA9\u0001\u0002\u0007\u0011QD\u0001\u0014MJ|W\u000eU3sg&\u001cH/\u001a8u!J|\u0007o\u001d\u000b\u0007\u0003K\u0012yN!9\t\u000f\t\u001d\u0016\t1\u0001\u0002f!9\u0011\u0011O!A\u0002\u0005u\u0011AF7bs\n,'+Z#oG>$W\rU1tg^|'\u000fZ:\u0015\r\u0005\u0015$q\u001dBu\u0011\u001d\u00119K\u0011a\u0001\u0003KBqAa;C\u0001\u0004\u0011i/A\u0007bI6LgNW6DY&,g\u000e\u001e\t\u0005\u0005'\u0012y/\u0003\u0003\u0003r\nU#!D!e[&t'l[\"mS\u0016tG/A\nwC2LG-\u0019;fI.\u000bgm[1Qe>\u00048\u000f\u0006\u0004\u0003\u0012\n](1 \u0005\b\u0005s\u001c\u0005\u0019AA3\u00035\u0001(o\u001c9t\u001fZ,'O]5eK\"9\u0011\u0011O\"A\u0002\u0005u\u0011\u0001\u0003<bY&$\u0017\r^3\u0015\r\u0005m3\u0011AB\u0002\u0011\u001d\t\u0019\u0007\u0012a\u0001\u0003KBq!!\u001dE\u0001\u0004\ti\"\u0001\u000bsK6|g/Z%om\u0006d\u0017\u000eZ\"p]\u001aLwm\u001d\u000b\u0007\u00037\u001aIaa\u0003\t\u000f\u0005\rT\t1\u0001\u0002f!9\u0011\u0011O#A\u0002\u0005u\u0011\u0001E7bs\n,'+Z2p]\u001aLw-\u001e:f)!\tYf!\u0005\u0004\u0014\r]\u0001b\u0002B;\r\u0002\u0007\u0011Q \u0005\b\u0007+1\u0005\u0019AAf\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u0004\u001a\u0019\u0003\raa\u0007\u0002\u00139,woQ8oM&<\u0007\u0007BB\u000f\u0007G\u0001\u0002\"a\u001a\u00026\u0006\u001d2q\u0004\t\u0005\u0007C\u0019\u0019\u0003\u0004\u0001\u0005\u0019\r\u00152qCA\u0001\u0002\u0003\u0015\taa\n\u0003\u0007}#\u0013'\u0005\u0003\u0004*\r=\u0002cA-\u0004,%\u00191Q\u0006.\u0003\u000f9{G\u000f[5oOB\u0019\u0011l!\r\n\u0007\rM\"LA\u0002B]f\fa\"\u001e9eCR,GmQ8oM&<7\u000f\u0006\u0004\u0004:\r\r3q\n\u0019\u0005\u0007w\u0019y\u0004E\u0004d\u0003?\f9c!\u0010\u0011\t\r\u00052q\b\u0003\f\u0007\u0003:\u0015\u0011!A\u0001\u0006\u0003\u00199CA\u0002`IUBqA!.H\u0001\u0004\u0019)\u0005\r\u0003\u0004H\r-\u0003\u0003CA4\u0003k\u000b9c!\u0013\u0011\t\r\u000521\n\u0003\r\u0007\u001b\u001a\u0019%!A\u0001\u0002\u000b\u00051q\u0005\u0002\u0004?\u0012\u0012\u0004bBB)\u000f\u0002\u000711K\u0001\rGV\u0014(/\u001a8u!J|\u0007o\u001d\u0019\u0007\u0007+\u001aIfa\u0018\u0011\u0011\u0005\u001d\u0014QWB,\u0007;\u0002Ba!\t\u0004Z\u0011a11LB(\u0003\u0003\u0005\tQ!\u0001\u0004(\t\u0019q\fJ\u001a\u0011\t\r\u00052q\f\u0003\r\u0007C\u001ay%!A\u0001\u0002\u000b\u00051q\u0005\u0002\u0004?\u0012\"\u0014!D8wKJ\u0014\u0018\u000eZ3Qe>\u00048\u000f\u0006\u0004\u0002\\\r\u001d4\u0011\u000e\u0005\b\u0003GB\u0005\u0019AAv\u0011\u001d\u0011I\u0010\u0013a\u0001\u0003W\f1#\u001e9eCR,7)\u001e:sK:$8i\u001c8gS\u001e\fa\u0003\u001d:pG\u0016\u001c8OU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0007\u0007c\u001aIha\u001f\u0011\u000fe\u001b\u0019(a3\u0004x%\u00191Q\u000f.\u0003\rQ+\b\u000f\\33!\u0019\t\t%a\u0013\u0003\u000e!9!Q\u0017&A\u0002\tE\u0005bBB?\u0015\u0002\u0007\u0011QD\u0001\rm\u0006d\u0017\u000eZ1uK>sG._\u0001\u0015]\u0016,Gm\u001d*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\r\u0005u11QBF\u0011\u001d\u0019)i\u0013a\u0001\u0007\u000f\u000bQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0005\u0004\u0002h\r%\u0015qE\u0005\u0004S\u0006%\u0004bBBG\u0017\u0002\u0007\u0011qO\u0001\fkB$\u0017\r^3e\u0017\u0016L8/A\u000fqe>\u001cWm]:MSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)1\tYfa%\u0004$\u000e\u00156\u0011WBZ\u0011\u001d\u0019)\n\u0014a\u0001\u0007/\u000ba\u0003\\5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0005\u00073\u001by*\u0004\u0002\u0004\u001c*!1QTAO\u0003\u001dqW\r^<pe.LAa!)\u0004\u001c\n1B*[:uK:,'OU3d_:4\u0017nZ;sC\ndW\rC\u0004\u0004\u001a1\u0003\r!a3\t\u000f\r\u001dF\n1\u0001\u0004*\u0006i1-^:u_6\u001cuN\u001c4jON\u0004\u0002\"a\u001a\u00026\u0006\u001d21\u0016\t\u0004W\u000e5\u0016bABXY\n1qJ\u00196fGRDqa! M\u0001\u0004\ti\u0002C\u0004\u000462\u0003\r!!\b\u0002\u0015I,Gn\\1e\u001f:d\u00170A\u000bqe>\u001cWm]:SK\u000e|gNZ5hkJ\f'\r\\3\u0015\u0019\u0005m31XB_\u0007\u0003\u001cyma5\t\u000f\tUT\n1\u0001\u0002~\"91qX'A\u0002\u0005]\u0014AE;qI\u0006$X\rZ\"p]\u001aLwMT1nKNDqaa1N\u0001\u0004\u0019)-A\u0007bY2tUm^\"p]\u001aLwm\u001d\u0019\u0005\u0007\u000f\u001cY\r\u0005\u0005\u0002h\u0005U\u0016qEBe!\u0011\u0019\tca3\u0005\u0019\r57\u0011YA\u0001\u0002\u0003\u0015\taa\n\u0003\u0007}#c\u0007C\u0004\u0004R6\u0003\ra!+\u0002!9,woQ;ti>l7i\u001c8gS\u001e\u001c\bbBB?\u001b\u0002\u0007\u0011Q\u0004")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicBrokerConfig dynamicBrokerConfig = this;
        synchronized (dynamicBrokerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)this.kafkaConfig().brokerId())).toString());
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaServer kafkaServer) {
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicConnectionQuota(kafkaServer));
    }

    public void addReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs((Set<String>)((Set)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()));
            return this.reconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this.verifyReconfigurableConfigs(reconfigurable.reconfigurableConfigs());
            return this.brokerReconfigurables().$plus$eq((Object)reconfigurable);
        });
    }

    public void removeReconfigurable(Reconfigurable reconfigurable) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.reconfigurables().$minus$eq((Object)reconfigurable));
    }

    private void verifyReconfigurableConfigs(Set<String> configNames) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Set nonDynamic = (Set)configNames.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
            Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
        });
    }

    public KafkaConfig currentKafkaConfig() {
        return (KafkaConfig)((Object)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.currentConfig()));
    }

    public Map<String, String> currentDynamicBrokerConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicBrokerConfigs().clone());
    }

    public Map<String, String> currentDynamicDefaultConfigs() {
        return (Map)CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.dynamicDefaultConfigs().clone());
    }

    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, true);
                this.dynamicBrokerConfigs().clear();
                this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId).append(" could not be applied: ").append(persistentProps).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void updateDefaultConfig(Properties persistentProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                Properties props = this.fromPersistentProps(persistentProps, false);
                this.dynamicDefaultConfigs().clear();
                this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
                this.updateCurrentConfig();
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        });
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)this.reconfigurables().filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4(this, newProps, x0$1);
            return BoxedUnit.UNIT;
        }));
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)configProps.clone();
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$2(this, perBrokerConfig, props, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$6(this, props, x0$1);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        block0: {
            Properties props = (Properties)persistentProps.clone();
            if (!((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) break block0;
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        void var3_3;
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsOverride, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(propsOverride).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(propsOverride).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return var3_3;
    }

    public void validate(Properties props, boolean perBrokerConfig) {
        CoreUtils$.MODULE$.inReadLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Map<String, String> newProps = this.validatedKafkaProps(props, perBrokerConfig);
            return this.processReconfiguration(newProps, true);
        });
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Dynamic ").append(configSource).append(" config contains invalid values: ").append(invalidProps).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        block0: {
            if (!((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) break block0;
            reconfigurable.reconfigure(newConfig);
        }
    }

    private scala.collection.mutable.Map<String, ?> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<?, ?> currentProps) {
        return (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
    }

    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        propsOverride.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            Option option = props.put((Object)k, (Object)v);
            return option;
        });
    }

    private void updateCurrentConfig() {
        block1: {
            scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            newProps.$plus$plus$eq(this.staticBrokerConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
            KafkaConfig oldConfig = this.currentConfig();
            Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            KafkaConfig newConfig = (KafkaConfig)((Object)tuple2._1());
            List brokerReconfigurablesToUpdate = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate);
            Tuple2 tuple23 = tuple22;
            KafkaConfig newConfig2 = (KafkaConfig)((Object)tuple23._1());
            List brokerReconfigurablesToUpdate2 = (List)tuple23._2();
            if (newConfig2 == this.currentConfig()) break block1;
            this.currentConfig_$eq(newConfig2);
            this.kafkaConfig().updateCurrentConfig(newConfig2);
            brokerReconfigurablesToUpdate2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.reconfigure(oldConfig, newConfig2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        Tuple2 tuple2;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        scala.collection.mutable.Map<String, ?> updatedMap = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (updatedMap.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(newConfig.valuesFromThisConfig().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> customConfigs.remove(x$1));
                this.reconfigurables().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, updatedMap, x0$1);
                    return BoxedUnit.UNIT;
                });
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                    Object object;
                    if (this.needsReconfiguration((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)updatedMap.keySet())) {
                        reconfigurable.validateReconfiguration(newConfig);
                        object = !validateOnly ? brokerReconfigurablesToUpdate.$plus$eq(reconfigurable) : BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                tuple2 = new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(newConfig.originalsFromThisConfig()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        } else {
            tuple2 = new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
        }
        return tuple2;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys) {
        return ((TraversableOnce)((GenSetLike)JavaConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty();
    }

    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        block0: {
            ListenerName listenerName = listenerReconfigurable.listenerName();
            java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
            java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
            Set updatedKeys = this.updatedConfigs(newValues, oldValues).keySet();
            boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys);
            if (reloadOnly == configsChanged) break block0;
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        block3: {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allNewConfigs).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Object object = newConfigs.put(k, v);
                return object;
            });
            newConfigs.putAll(newCustomConfigs);
            try {
                reconfigurable.validateReconfiguration(newConfigs);
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception exception) {
                throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
            }
            if (validateOnly) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" custom configs: ").append(newCustomConfigs).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        java.util.Set set = reconfigurable.reconfigurableConfigs();
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)set.contains(x$1)));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        Reconfigurable reconfigurable = x0$1;
        if (reconfigurable instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(reconfigurable).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$2) {
        block1: {
            if (value == null) break block1;
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$2.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$2(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.encodePassword$1(name, value, perBrokerConfig$1, props$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$3) {
        block0: {
            if (!invalidPropNames.nonEmpty()) break block0;
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$3.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$3) {
        block2: {
            if (value == null) break block2;
            try {
                props$3.setProperty(configName, this.passwordEncoder().decode(value).value());
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$3.remove(configName);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$6(DynamicBrokerConfig $this, Properties props$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        String value = (String)tuple2._2();
        $this.decodePassword$1(name, value, props$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$4(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$4, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String configName = (String)tuple2._1();
            String value2 = (String)tuple2._2();
            if (value2 != null) {
                Some some;
                try {
                    some = new Some((Object)passwordDecoder$1.decode(value2).value());
                }
                catch (Exception exception) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                    some = None$.MODULE$;
                }
                Some decoded = some;
                decoded.foreach((Function1 & Serializable & scala.Serializable)value -> props$4.put(configName, $this.passwordEncoder().encode(new Password(value))));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$4, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$4($this, passwordDecoder, props$4, x0$1);
            return BoxedUnit.UNIT;
        });
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$4);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        boolean bl;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        boolean bl = !BoxesRunTime.equals((Object)v, currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map updatedMap$1, Reconfigurable x0$1) {
        Reconfigurable reconfigurable = x0$1;
        if (reconfigurable instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)reconfigurable;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if ($this.needsReconfiguration(reconfigurable.reconfigurableConfigs(), (Set<String>)updatedMap$1.keySet())) {
                $this.processReconfigurable(reconfigurable, (Set<String>)updatedMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }
}

