/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tuh!B-[\u0003\u0003y\u0006\"B4\u0001\t\u0003A\u0007b\u00026\u0001\u0005\u0004%\te\u001b\u0005\u0007e\u0002\u0001\u000b\u0011\u00027\t\u000bM\u0004A\u0011\t;\t\u000fa\u0004!\u0019!C\u0001W\"1\u0011\u0010\u0001Q\u0001\n1DqA\u001f\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002?\t\u0013\u0005-\u0001A1A\u0005\u0002\u00055\u0001\u0002CA\u0012\u0001\u0001\u0006I!a\u0004\t\u0011\u0005\u0015\u0002A1A\u0005\u0002mDq!a\n\u0001A\u0003%A\u0010C\u0005\u0002*\u0001\u0011\r\u0011\"\u0001\u0002\u000e!A\u00111\u0006\u0001!\u0002\u0013\ty\u0001\u0003\u0005\u0002.\u0001\u0011\r\u0011\"\u0001|\u0011\u001d\ty\u0003\u0001Q\u0001\nqD\u0001\"!\r\u0001\u0005\u0004%\ta\u001b\u0005\b\u0003g\u0001\u0001\u0015!\u0003m\u0011%\t)\u0004\u0001b\u0001\n\u0003\t9\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\t\u0006\u0001b\u0001\u000e\u0003\ti\u0001C\u0005\u0002T\u0001\u0011\rQ\"\u0001\u0002\u000e!Q\u0011Q\u000b\u0001\t\u0006\u0004%\t&a\u0016\t\u0013\u0005-\u0004A1A\u0005\u0002\u00055\u0004\u0002CA@\u0001\u0001\u0006I!a\u001c\t\u0013\u0005\u0005\u0005A1A\u0005\u0002\u00055\u0004\u0002CAB\u0001\u0001\u0006I!a\u001c\t\u0013\u0005\u0015\u0005A1A\u0005\u0002\u00055\u0004\u0002CAD\u0001\u0001\u0006I!a\u001c\t\u0013\u0005%\u0005A1A\u0005\u0002\u00055\u0004\u0002CAF\u0001\u0001\u0006I!a\u001c\t\u0013\u00055\u0005A1A\u0005\u0002\u00055\u0004\u0002CAH\u0001\u0001\u0006I!a\u001c\t\u0013\u0005E\u0005A1A\u0005\u0002\u00055\u0004\u0002CAJ\u0001\u0001\u0006I!a\u001c\t\u0013\u0005U\u0005A1A\u0005\u0002\u00055\u0004\u0002CAL\u0001\u0001\u0006I!a\u001c\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u00111\u0015\u0001\u0005\u0002\u0005m\u0005bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003W\u0003A\u0011AAN\u0011\u001d\ti\u000b\u0001C\u0001\u00037Cq!a,\u0001\t\u0003\tY\nC\u0004\u00022\u0002!\t!a-\t\u000f\u0005]\u0006\u0001\"\u0001\u0002\u001c\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0005bBA^\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t9\u000e\u0001C\u0001\u0003\u007fCq!!7\u0001\t\u0003\ty\fC\u0004\u0002\\\u0002!\t!a0\t\u000f\u0005u\u0007\u0001\"\u0001\u0002@\"9\u0011q\u001c\u0001\u0005\u0002\u0005}\u0006bBAq\u0001\u0011\u0005\u0011q\u0018\u0005\u0007\u0003G\u0004A\u0011\t;\t\r\u0005M\b\u0001\"\u0011u\u0011\u0019\ti\u0010\u0001C\u0001i\"1!q\u0001\u0001\u0005\u0012QDqA!\u0003\u0001\t\u0013\u0011Y\u0001\u0003\u0004\u00030\u0001!\t\u0001\u001e\u0005\u0007\u0005g\u0001A\u0011\u0001;\t\r\t]\u0002\u0001\"\u0001u\u0011\u0019\u0011Y\u0004\u0001C\u0001i\"1!q\b\u0001\u0005\nQDaA!\u0011\u0001\t\u0013!\bb\u0002B\"\u0001\u0011%!Q\t\u0005\b\u0005\u0013\u0002A\u0011\u0003B&\u0011\u0019\u0011y\u0005\u0001C\u0005i\"1!\u0011\u000b\u0001\u0005\u0002QDaA!\u0016\u0001\t\u0003!\bB\u0002B-\u0001\u0011\u0005A\u000f\u0003\u0004\u0003h\u0001!\t\u0001\u001e\u0005\u0007\u0005W\u0002A\u0011\u0002;\t\r\t5\u0004\u0001\"\u0001u\u0011\u0019\u0011\t\b\u0001C\u0001i\"1!Q\u000f\u0001\u0005\nQDaAa\u001e\u0001\t\u0003!\bb\u0002B>\u0001\u0011U!Q\u0010\u0005\b\u0005;\u0003AQ\u0003BP\u0011%\u0011\u0019\rAI\u0001\n+\u0011)\rC\u0005\u0003\\\u0002\t\n\u0011\"\u0006\u0003F\"I!Q\u001c\u0001\u0012\u0002\u0013U!q\u001c\u0005\n\u0005G\u0004\u0011\u0013!C\u000b\u0005\u000bD\u0011B!:\u0001#\u0003%)Ba:\t\u000f\t-\b\u0001\"\u0003\u0003n\"I!q\u001f\u0001\u0012\u0002\u0013%!Q\u0019\u0005\n\u0005s\u0004\u0011\u0013!C\u0005\u0005\u000bD\u0011Ba?\u0001#\u0003%IAa8\u00033\u0015sG\rV8F]\u0012\fU\u000f\u001e5pe&T\u0018\r^5p]R+7\u000f\u001e\u0006\u00037r\u000b1!\u00199j\u0015\u0005i\u0016!B6bM.\f7\u0001A\n\u0004\u0001\u0001$\u0007CA1c\u001b\u0005Q\u0016BA2[\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bCA1f\u0013\t1'LA\u0005TCNd7+\u001a;va\u00061A(\u001b8jiz\"\u0012!\u001b\t\u0003C\u0002\t1B\u0019:pW\u0016\u00148i\\;oiV\tA\u000e\u0005\u0002na6\taNC\u0001p\u0003\u0015\u00198-\u00197b\u0013\t\thNA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\n1eY8oM&<WO]3TK\u000e,(/\u001b;z\u0005\u00164wN]3TKJ4XM]:Ti\u0006\u0014H\u000fF\u0001v!\tig/\u0003\u0002x]\n!QK\\5u\u0003)qW/\u001c*fG>\u0014Hm]\u0001\f]Vl'+Z2pe\u0012\u001c\b%A\u0006he>,\b\u000f\u0015:fM&DX#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\r\t9A \u0002\u0007'R\u0014\u0018N\\4\u0002\u0019\u001d\u0014x.\u001e9Qe\u00164\u0017\u000e\u001f\u0011\u0002\u000b\u001d\u0014x.\u001e9\u0016\u0005\u0005=\u0001\u0003BA\t\u0003?qA!a\u0005\u0002\u001cA\u0019\u0011Q\u00038\u000e\u0005\u0005]!bAA\r=\u00061AH]8pizJ1!!\bo\u0003\u0019\u0001&/\u001a3fM&!\u0011qAA\u0011\u0015\r\tiB\\\u0001\u0007OJ|W\u000f\u001d\u0011\u0002\u0017Q|\u0007/[2Qe\u00164\u0017\u000e_\u0001\ri>\u0004\u0018n\u0019)sK\u001aL\u0007\u0010I\u0001\u0006i>\u0004\u0018nY\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0011]LG\u000eZ2be\u0012\f\u0011b^5mI\u000e\f'\u000f\u001a\u0011\u0002\tA\f'\u000f^\u0001\u0006a\u0006\u0014H\u000fI\u0001\u0003iB,\"!!\u000f\u0011\t\u0005m\u00121J\u0007\u0003\u0003{QA!a\u0010\u0002B\u000511m\\7n_:T1!XA\"\u0015\u0011\t)%a\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI%A\u0002pe\u001eLA!!\u0014\u0002>\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005y1\r\\5f]R\u0004&/\u001b8dSB\fG.\u0001\blC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002\u001dQ\u0014Xo\u001d;Ti>\u0014XMR5mKV\u0011\u0011\u0011\f\t\u0006[\u0006m\u0013qL\u0005\u0004\u0003;r'\u0001B*p[\u0016\u0004B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0005\u0003K\n\t!\u0001\u0002j_&!\u0011\u0011NA2\u0005\u00111\u0015\u000e\\3\u0002\u001bQ|\u0007/[2SKN|WO]2f+\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003sb\u0016\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005u\u00141\u000f\u0002\t%\u0016\u001cx.\u001e:dK\u0006qAo\u001c9jGJ+7o\\;sG\u0016\u0004\u0013!D4s_V\u0004(+Z:pkJ\u001cW-\u0001\bhe>,\bOU3t_V\u00148-\u001a\u0011\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016\f\u0001c\u00197vgR,'OU3t_V\u00148-\u001a\u0011\u0002+A\u0014XMZ5yK\u0012$v\u000e]5d%\u0016\u001cx.\u001e:dK\u00061\u0002O]3gSb,G\rV8qS\u000e\u0014Vm]8ve\u000e,\u0007%A\u000bqe\u00164\u0017\u000e_3e\u000fJ|W\u000f\u001d*fg>,(oY3\u0002-A\u0014XMZ5yK\u0012<%o\\;q%\u0016\u001cx.\u001e:dK\u0002\nQc^5mI\u000e\f'\u000f\u001a+pa&\u001c'+Z:pkJ\u001cW-\u0001\fxS2$7-\u0019:e)>\u0004\u0018n\u0019*fg>,(oY3!\u0003U9\u0018\u000e\u001c3dCJ$wI]8vaJ+7o\\;sG\u0016\fac^5mI\u000e\f'\u000fZ$s_V\u0004(+Z:pkJ\u001cW\rI\u0001\u0012G2,8\u000f^3s\u0003\u000e$\u0018n\u001c8Be\u001e\u001cXCAAO!\u0015i\u0017qTA\b\u0013\r\t\tK\u001c\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0017i>\u0004\u0018n\u0019\"s_.,'OU3bI\u0006\u001bG.\u0011:hg\u0006q\u0001O]8ek\u000e,\u0017i\u00197Be\u001e\u001cH\u0003BAO\u0003SCq!!\u000b)\u0001\u0004\ty!A\beKN\u001c'/\u001b2f\u0003\u000ed\u0017I]4t\u0003U!W\r\\3uK\u0012+7o\u0019:jE\u0016\f5\r\\!sON\f!\u0003Z3mKR,wK]5uK\u0006\u001bG.\u0011:hg\u0006q1m\u001c8tk6,\u0017i\u00197Be\u001e\u001cH\u0003BAO\u0003kCq!!\u000b-\u0001\u0004\ty!\u0001\u0007he>,\b/Q2m\u0003J<7/A\u000fqe>$WoY3D_:\u001cX/\\3XS2$7-\u0019:e\u0003\u000ed\u0017I]4t\u0003y\u0001(o\u001c3vG\u0016\u001cuN\\:v[\u0016\u0004&/\u001a4jq\u0016$\u0017i\u00197t\u0003J<7/\u0001\tDYV\u001cH/\u001a:BGRLwN\\!dYV\u0011\u0011\u0011\u0019\t\u0007\u0003\u0007\fi-!5\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005-g.\u0001\u0006d_2dWm\u0019;j_:LA!a4\u0002F\n\u00191+\u001a;\u0011\t\u0005E\u00141[\u0005\u0005\u0003+\f\u0019HA\u0002BG2\f!\u0003V8qS\u000e\u0014%o\\6feJ+\u0017\rZ!dY\u0006aqI]8vaJ+\u0017\rZ!dY\u0006aAk\u001c9jGJ+\u0017\rZ!dY\u0006iAk\u001c9jG^\u0013\u0018\u000e^3BG2\f\u0001\u0003V8qS\u000e$Um]2sS\n,\u0017i\u00197\u0002\u001dQ{\u0007/[2De\u0016\fG/Z!dY\u0006)1/\u001a;Va\"\u001aq'a:\u0011\t\u0005%\u0018q^\u0007\u0003\u0003WTA!!<\u0002H\u0005)!.\u001e8ji&!\u0011\u0011_Av\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u00029\u0003o\u0004B!!;\u0002z&!\u00111`Av\u0005\u0015\te\r^3s\u0003m!Xm\u001d;Qe>$WoY3D_:\u001cX/\\3WS\u0006\f5o]5h]\"\u001a\u0011H!\u0001\u0011\t\u0005%(1A\u0005\u0005\u0005\u000b\tYO\u0001\u0003UKN$\u0018AH2p]\u001aL'/\u001c*fCV$\b.\u001a8uS\u000e\fG/[8o\u001b\u0016$(/[2t\u0003!9W\r^$bk\u001e,G\u0003\u0002B\u0007\u0005W\u0001bAa\u0004\u0003\"\t\u0015RB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\t\r|'/\u001a\u0006\u0005\u0005/\u0011I\"A\u0004nKR\u0014\u0018nY:\u000b\t\tm!QD\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\t}\u0011aA2p[&!!1\u0005B\t\u0005\u00159\u0015-^4f!\ri'qE\u0005\u0004\u0005Sq'A\u0002#pk\ndW\rC\u0004\u0003.m\u0002\r!a\u0004\u0002\u00155,GO]5d\u001d\u0006lW-\u0001\u0010uKN$\bK]8ek\u000e,7i\u001c8tk6,g+[1Tk\n\u001c8M]5cK\"\u001aAH!\u0001\u0002EQ,7\u000f\u001e)s_\u0012,8-Z\"p]N,X.Z,ji\"<\u0016\u000e\u001c3dCJ$\u0017i\u00197tQ\ri$\u0011A\u0001#i\u0016\u001cH\u000f\u0015:pIV\u001cWmQ8ogVlWmV5uQB\u0013XMZ5yK\u0012\f5\r\\:)\u0007y\u0012\t!A\u0018uKN$\bK]8ek\u000e,7i\u001c8tk6,Gk\u001c9jG\u0006+Ho\\\"sK\u0006$X\rV8qS\u000e\u001c%/Z1uK\u0006\u001bG\u000eK\u0002@\u0005\u0003\tqc]3u/&dGmY1sIJ+7o\\;sG\u0016\f5\r\\:\u0002/M,G\u000f\u0015:fM&DX\r\u001a*fg>,(oY3BG2\u001c\u0018aE:fiJ+\u0017\rZ!oI^\u0013\u0018\u000e^3BG2\u001cHcA;\u0003H!9\u0011Q\u0007\"A\u0002\u0005e\u0012!E:fi\u0006\u001bGn]!oIB\u0013x\u000eZ;dKR\u0019QO!\u0014\t\u000f\u0005U2\t1\u0001\u0002:\u0005!2/\u001a;D_:\u001cX/\\3s\u000fJ|W\u000f]!dYN\fQ\u0007^3ti:{G)Z:de&\u0014W\r\u0015:pIV\u001cWm\u0014:D_:\u001cX/\\3XSRDw.\u001e;U_BL7\rR3tGJL'-Z!dY\"\u001aQI!\u0001\u00029Q,7\u000f\u001e(p!J|G-^2f/&$\b\u000eR3tGJL'-Z!dY\"\u001aaI!\u0001\u0002QQ,7\u000f\u001e(p\u0007>t7/^7f/&$\bn\\;u\t\u0016\u001c8M]5cK\u0006\u001bGNV5b\u0003N\u001c\u0018n\u001a8)\u000f\u001d\u0013\tA!\u0018\u0003`\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0003bA!\u00111\bB2\u0013\u0011\u0011)'!\u0010\u0003\u001d-\u000bgm[1Fq\u000e,\u0007\u000f^5p]\u0006YC/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5pkR$Um]2sS\n,\u0017i\u00197WS\u0006\u001cVOY:de&\u0014W\rK\u0002I\u0005\u0003\t\u0001E\\8D_:\u001cX/\\3XSRDw.\u001e;EKN\u001c'/\u001b2f\u0003\u000ed7+\u001a;va\u0006)C/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0003\u000edg+[1BgNLwM\u001c\u0015\u0004\u0015\n\u0005\u0011\u0001\u000b;fgRtunQ8ogVlWmV5uQ\u0012+7o\u0019:jE\u0016\f5\r\u001c,jCN+(m]2sS\n,\u0007fA&\u0003\u0002\u0005ibn\\\"p]N,X.Z,ji\"$Um]2sS\n,\u0017i\u00197TKR,\b/\u0001\buKN$hj\\$s_V\u0004\u0018i\u00197)\u00075\u0013\t!A\u0006tK:$'+Z2pe\u0012\u001cHcB;\u0003\u0000\te%1\u0014\u0005\b\u0005\u0003s\u0005\u0019\u0001BB\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003\u0003BC\u0005\u001b\u0013\tJ!%\u000e\u0005\t\u001d%\u0002\u0002BA\u0005\u0013SAAa#\u0002B\u000591\r\\5f]R\u001c\u0018\u0002\u0002BH\u0005\u000f\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#B7\u0002 \nM\u0005cA7\u0003\u0016&\u0019!q\u00138\u0003\t\tKH/\u001a\u0005\u0006q:\u0003\r\u0001\u001c\u0005\b\u0003kq\u0005\u0019AA\u001d\u00039\u0019wN\\:v[\u0016\u0014VmY8sIN$R\"\u001eBQ\u0005_\u0013\tL!.\u00038\ne\u0006b\u0002BR\u001f\u0002\u0007!QU\u0001\tG>t7/^7feBA!q\u0015BV\u0005#\u0013\t*\u0004\u0002\u0003**!!1\u0015BE\u0013\u0011\u0011iK!+\u0003\u0011\r{gn];nKJDq\u0001_(\u0011\u0002\u0003\u0007A\u000e\u0003\u0005\u00034>\u0003\n\u00111\u0001m\u00039\u0019H/\u0019:uS:<wJ\u001a4tKRD\u0011\"!\u000bP!\u0003\u0005\r!a\u0004\t\u0011\u0005Er\n%AA\u00021D\u0011Ba/P!\u0003\u0005\rA!0\u0002\u000fQLW.Z8viB\u0019QNa0\n\u0007\t\u0005gN\u0001\u0003M_:<\u0017\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0019\u0016\u0004Y\n%7F\u0001Bf!\u0011\u0011iMa6\u000e\u0005\t='\u0002\u0002Bi\u0005'\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tUg.\u0001\u0006b]:|G/\u0019;j_:LAA!7\u0003P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"A!9+\t\u0005=!\u0011Z\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*\u0014\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\u001e\u0016\u0005\u0005{\u0013I-A\u0017d_:\u001cX/\\3SK\u000e|'\u000fZ:JO:|'/Z(oK\u0006+H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0012\"\u001eBx\u0005c\u0014\u0019P!>\t\u000f\t\rV\u000b1\u0001\u0003&\"9\u00010\u0016I\u0001\u0002\u0004a\u0007\u0002\u0003BZ+B\u0005\t\u0019\u00017\t\u0013\u0005%R\u000b%AA\u0002\u0005=\u0011aN2p]N,X.\u001a*fG>\u0014Hm]%h]>\u0014Xm\u00148f\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$#'A\u001cd_:\u001cX/\\3SK\u000e|'\u000fZ:JO:|'/Z(oK\u0006+H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:$C-\u001a4bk2$HeM\u00018G>t7/^7f%\u0016\u001cwN\u001d3t\u0013\u001etwN]3P]\u0016\fU\u000f\u001e5pe&T\u0018\r^5p]\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000f\n\u001b")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int brokerCount;
    private final int numRecords;
    private final String groupPrefix;
    private final String group;
    private final String topicPrefix;
    private final String topic;
    private final String wildcard;
    private final int part;
    private final TopicPartition tp;
    private final Resource topicResource;
    private final Resource groupResource;
    private final Resource clusterResource;
    private final Resource prefixedTopicResource;
    private final Resource prefixedGroupResource;
    private final Resource wildcardTopicResource;
    private final Resource wildcardGroupResource;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterActionArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String groupPrefix() {
        return this.groupPrefix;
    }

    public String group() {
        return this.group;
    }

    public String topicPrefix() {
        return this.topicPrefix;
    }

    public String topic() {
        return this.topic;
    }

    public String wildcard() {
        return this.wildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public abstract String clientPrincipal();

    public abstract String kafkaPrincipal();

    private Some<File> trustStoreFile$lzycompute() {
        EndToEndAuthorizationTest endToEndAuthorizationTest = this;
        synchronized (endToEndAuthorizationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    public Resource topicResource() {
        return this.topicResource;
    }

    public Resource groupResource() {
        return this.groupResource;
    }

    public Resource clusterResource() {
        return this.clusterResource;
    }

    public Resource prefixedTopicResource() {
        return this.prefixedTopicResource;
    }

    public Resource prefixedGroupResource() {
        return this.prefixedGroupResource;
    }

    public Resource wildcardTopicResource() {
        return this.wildcardTopicResource;
    }

    public Resource wildcardGroupResource() {
        return this.wildcardGroupResource;
    }

    public String[] clusterActionArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=ClusterAction", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.kafkaPrincipal()).toString()});
    }

    public String[] topicBrokerReadAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), "--operation=Read", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.kafkaPrincipal()).toString()});
    }

    public String[] produceAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] describeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteDescribeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteWriteAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Write", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] consumeAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), new StringBuilder(8).append("--group=").append(this.group()).toString(), "--consumer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] groupAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--group=").append(this.group()).toString(), "--operation=Read", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumeWildcardAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), new StringBuilder(8).append("--group=").append(this.wildcard()).toString(), "--consumer", "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumePrefixedAclsArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topicPrefix()).toString(), new StringBuilder(8).append("--group=").append(this.groupPrefix()).toString(), "--resource-pattern-type=prefixed", "--consumer", "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public scala.collection.immutable.Set<Acl> ClusterActionAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)ClusterAction$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicCreateAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Create$.MODULE$)}));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    public void confirmReauthenticationMetrics() {
        double expiredConnectionsKilledCountTotal = BoxesRunTime.unboxToDouble((Object)this.getGauge("ExpiredConnectionsKilledCount").value());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$1(expiredConnectionsKilledCountTotal, s);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Should have been zero expired connections killed total", (double)0.0, (double)expiredConnectionsKilledCountTotal, (double)0.0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$2(s);
            return BoxedUnit.UNIT;
        });
    }

    private Gauge<Object> getGauge(String metricName) {
        return (Gauge)((Tuple2)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.$anonfun$getGauge$1(metricName, k))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229))))._2();
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithWildcardAcls() {
        this.setWildcardResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithPrefixedAcls() {
        this.setPrefixedResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeTopicAutoCreateTopicCreateAcl() {
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        this.setAclsAndProduce(tp2);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$1 = consumer;
        int x$2 = this.numRecords();
        String x$3 = tp2.topic();
        int x$4 = this.consumeRecords$default$3();
        int x$5 = this.consumeRecords$default$5();
        long x$6 = this.consumeRecords$default$6();
        this.consumeRecords((Consumer<byte[], byte[]>)x$1, x$2, x$4, x$3, x$5, x$6);
        this.confirmReauthenticationMetrics();
    }

    private void setWildcardResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumeWildcardAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setWildcardResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setPrefixedResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumePrefixedAclsArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setPrefixedResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setReadAndWriteAcls(TopicPartition tp) {
        AclCommand$.MODULE$.main(this.produceAclArgs(tp.topic()));
        AclCommand$.MODULE$.main(this.consumeAclArgs(tp.topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setReadAndWriteAcls$1(this, tp, s);
            return BoxedUnit.UNIT;
        });
    }

    public void setAclsAndProduce(TopicPartition tp) {
        this.setReadAndWriteAcls(tp);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), tp);
    }

    private void setConsumerGroupAcls() {
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl() {
        this.setConsumerGroupAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp()), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KafkaConsumer x$1 = consumer;
            int x$2 = this.numRecords();
            String x$3 = this.tp().topic();
            int x$4 = this.consumeRecords$default$3();
            int x$5 = this.consumeRecords$default$5();
            long x$6 = this.consumeRecords$default$6();
            this.consumeRecords((Consumer<byte[], byte[]>)x$1, x$2, x$4, x$3, x$5, x$6);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        AdminClient adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ExecutionException e1 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Map)adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava()).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause()).toString(), (boolean)(e1.getCause() instanceof TopicAuthorizationException));
        String topic2 = "topic2";
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        this.setReadAndWriteAcls(tp2);
        this.sendRecords(producer, this.numRecords(), tp2);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$7 = consumer;
        int x$8 = this.numRecords();
        String x$9 = topic2;
        int x$10 = this.consumeRecords$default$3();
        int x$11 = this.consumeRecords$default$5();
        long x$12 = this.consumeRecords$default$6();
        this.consumeRecords((Consumer<byte[], byte[]>)x$7, x$8, x$10, x$9, x$11, x$12);
        Map describeResults = adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults.get(topic2)).get()).partitions().size());
        ExecutionException e2 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Map)adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava()).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause()).toString(), (boolean)(e2.getCause() instanceof TopicAuthorizationException));
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        this.sendRecords(producer, this.numRecords(), tp2);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.pollRecordsUntilTrue(consumer, (Function1 & Serializable & scala.Serializable)records -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.verifyNoRecords$1(records)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer didn't fail with authorization exception within timeout", TestUtils$.MODULE$.pollRecordsUntilTrue$default$4()), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        this.setReadAndWriteAcls(this.tp());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.numRecords(), topic2);
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer x$13 = consumer;
        int x$14 = this.numRecords();
        String x$15 = this.topic();
        int x$16 = this.consumeRecords$default$3();
        int x$17 = this.consumeRecords$default$5();
        long x$18 = this.consumeRecords$default$6();
        this.consumeRecords((Consumer<byte[], byte[]>)x$13, x$14, x$16, x$15, x$17, x$18);
        Map describeResults2 = adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(this.topic())).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(topic2)).get()).partitions().size());
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        try {
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            this.sendRecords(producer, this.numRecords(), this.tp());
            throw Assertions$.MODULE$.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KafkaConsumer x$1 = consumer;
            long x$2 = 3000L;
            int x$3 = this.consumeRecords$default$2();
            int x$4 = this.consumeRecords$default$3();
            String x$5 = this.consumeRecords$default$4();
            int x$6 = this.consumeRecords$default$5();
            this.consumeRecords((Consumer<byte[], byte[]>)x$1, x$3, x$4, x$5, x$6, x$2);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.setReadAndWriteAcls(this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$))).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KafkaConsumer x$7 = consumer;
            long x$8 = 3000L;
            int x$9 = this.consumeRecords$default$2();
            int x$10 = this.consumeRecords$default$3();
            String x$11 = this.consumeRecords$default$4();
            int x$12 = this.consumeRecords$default$5();
            this.consumeRecords((Consumer<byte[], byte[]>)x$7, x$9, x$10, x$11, x$12, x$8);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.consumeRecordsIgnoreOneAuthorizationException$default$2(), this.consumeRecordsIgnoreOneAuthorizationException$default$3(), this.consumeRecordsIgnoreOneAuthorizationException$default$4());
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.TopicWriteAcl().$plus$plus(this.TopicDescribeAcl()).$plus$plus(this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)this.group(), (Object)e.groupId());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public final void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(consumer, numRecords, timeout);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)topic, (Object)record.topic());
            Assert.assertEquals((long)part, (long)record.partition());
            Assert.assertEquals((long)offset, (long)record.offset());
        });
    }

    public final int consumeRecords$default$2() {
        return 1;
    }

    public final int consumeRecords$default$3() {
        return 0;
    }

    public final String consumeRecords$default$4() {
        return this.topic();
    }

    public final int consumeRecords$default$5() {
        return this.part();
    }

    public final long consumeRecords$default$6() {
        return 10000L;
    }

    private void consumeRecordsIgnoreOneAuthorizationException(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic) {
        try {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.consumeRecords$default$5(), this.consumeRecords$default$6());
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.consumeRecords$default$5(), this.consumeRecords$default$6());
        }
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$2() {
        return 1;
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$3() {
        return 0;
    }

    private String consumeRecordsIgnoreOneAuthorizationException$default$4() {
        return this.topic();
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), Resource$.MODULE$.ClusterResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, "*", PatternType.LITERAL));
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$1(double expiredConnectionsKilledCountTotal$1, KafkaServer s) {
        long numExpiredKilled = TestUtils$.MODULE$.totalMetricValue(s, "expired-connections-killed-count");
        Assert.assertTrue((String)new StringBuilder(58).append("Should have been zero expired connections killed: ").append(numExpiredKilled).append("(total=").append(expiredConnectionsKilledCountTotal$1).append(")").toString(), (numExpiredKilled == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$2(KafkaServer s) {
        Assert.assertTrue((String)"failed re-authentications not 0", (TestUtils$.MODULE$.totalMetricValue(s, "failed-reauthentication-total") == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName k) {
        String string = k.getName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$setWildcardResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl()).$plus$plus($this.TopicBrokerReadAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardGroupResource());
    }

    public static final /* synthetic */ void $anonfun$setPrefixedResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedGroupResource());
    }

    public static final /* synthetic */ void $anonfun$setReadAndWriteAcls$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, tp$1.topic(), PatternType.LITERAL));
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    private static final boolean verifyNoRecords$1(ConsumerRecords records) {
        Assert.assertTrue((String)new StringBuilder(18).append("Consumed records: ").append(records).toString(), (boolean)records.isEmpty());
        return !records.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord(tp$2.topic(), Predef$.MODULE$.int2Integer(tp$2.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$2.send(record);
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 3;
        this.numRecords = 1;
        this.groupPrefix = "gr";
        this.group = new StringBuilder(3).append(this.groupPrefix()).append("oup").toString();
        this.topicPrefix = "e2e";
        this.topic = new StringBuilder(5).append(this.topicPrefix()).append("topic").toString();
        this.wildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicResource = new Resource((ResourceType)Topic$.MODULE$, this.topic(), PatternType.LITERAL);
        this.groupResource = new Resource((ResourceType)Group$.MODULE$, this.group(), PatternType.LITERAL);
        this.clusterResource = Resource$.MODULE$.ClusterResource();
        this.prefixedTopicResource = new Resource((ResourceType)Topic$.MODULE$, this.topicPrefix(), PatternType.PREFIXED);
        this.prefixedGroupResource = new Resource((ResourceType)Group$.MODULE$, this.groupPrefix(), PatternType.PREFIXED);
        this.wildcardTopicResource = new Resource((ResourceType)Topic$.MODULE$, this.wildcard(), PatternType.LITERAL);
        this.wildcardGroupResource = new Resource((ResourceType)Group$.MODULE$, this.wildcard(), PatternType.LITERAL);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp(), "1500");
        this.consumerConfig().setProperty("group.id", "group");
    }
}

