/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.DelayedOperationKey;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004W\u0001\u0001\u0006Ia\u0015\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019!\u0007\u0001)A\u00053\"9Q\r\u0001b\u0001\n\u00031\u0007BB7\u0001A\u0003%q\rC\u0004o\u0001\t\u0007I\u0011A8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001d9\bA1A\u0005\u0002aDaA \u0001!\u0002\u0013I\bBC@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0002!Y\u00111\u0003\u0001A\u0002\u0003\u0007I\u0011AA\u000b\u0011-\t\t\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0001\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011\u0001\u0005\f\u0003K\u0001\u0001\u0019!a\u0001\n\u0003\t9\u0003C\u0006\u0002,\u0001\u0001\r\u0011!Q!\n\u0005\r\u0001bCA\u0017\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003A1\"a\f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00022!Y\u0011Q\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0002\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%\t!!\u000f\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013\u0005\u00111\t\u0005\f\u0003\u000f\u0002\u0001\u0019!A!B\u0013\tY\u0004C\u0006\u0002J\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0003bCA-\u0001\u0001\u0007\t\u0019!C\u0001\u00037B1\"a\u0018\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002N!Y\u0011\u0011\r\u0001A\u0002\u0003\u0007I\u0011AA2\u0011-\tY\u0007\u0001a\u0001\u0002\u0004%\t!!\u001c\t\u0017\u0005E\u0004\u00011A\u0001B\u0003&\u0011Q\r\u0005\f\u0003g\u0002\u0001\u0019!a\u0001\n\u0003\t)\bC\u0006\u0002\u0014\u0002\u0001\r\u00111A\u0005\u0002\u0005U\u0005bCAM\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oBq!a'\u0001\t\u0003\ti\nC\u0004\u0002.\u0002!I!a,\t\u000f\u0005]\u0007\u0001\"\u0001\u0002\u001e\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005u\u0005bBAv\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003_\u0004A\u0011AAO\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003;Cq!a>\u0001\t\u0003\ti\nC\u0004\u0002|\u0002!\t!!(\t\u000f\u0005}\b\u0001\"\u0001\u0002\u001e\"9!1\u0001\u0001\u0005\u0002\u0005u\u0005b\u0002B\u0004\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0005\u0017\u0001A\u0011AAO\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003;CqAa\u0005\u0001\t\u0003\ti\nC\u0004\u0003\u0018\u0001!\t!!(\t\u000f\tm\u0001\u0001\"\u0001\u0002\u001e\"9!q\u0004\u0001\u0005\n\t\u0005\u0002\"\u0003B \u0001E\u0005I\u0011\u0002B!\u0011\u001d\u00119\u0006\u0001C\u0001\u0003;CqAa\u0017\u0001\t\u0003\ti\nC\u0004\u0003`\u0001!\t!!(\t\u000f\t\r\u0004\u0001\"\u0001\u0002\u001e\"9!q\r\u0001\u0005\u0002\u0005u\u0005b\u0002B6\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0005_\u0002A\u0011AAO\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005kB\u0011B!,\u0001#\u0003%\tAa,\t\u000f\tM\u0006\u0001\"\u0001\u00036\"I!Q\u0018\u0001\u0012\u0002\u0013\u0005!q\u0016\u0005\b\u0005\u007f\u0003A\u0011AAO\u00055\u0001\u0016M\u001d;ji&|g\u000eV3ti*\u0011!iQ\u0001\bG2,8\u000f^3s\u0015\u0005!\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u001d\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001P!\t\u0001\u0006!D\u0001B\u0003!\u0011'o\\6fe&#W#A*\u0011\u0005!#\u0016BA+J\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001Z!\tQ&-D\u0001\\\u0015\taV,\u0001\u0004d_6lwN\u001c\u0006\u0003\tzS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111m\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u0002;j[\u0016,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u000e\u000bQ!\u001e;jYNL!\u0001\\5\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003A\u0004\"!\u001d;\u000e\u0003IT!a]\"\u0002\rM,'O^3s\u0013\t)(O\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\u0006\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\u0002\u000f5,GO]5dgV\t\u0011\u0010\u0005\u0002{y6\t1P\u0003\u0002x7&\u0011Qp\u001f\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013A\u0002;na\u0012K'/\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AA5p\u0015\t\ti!\u0001\u0003kCZ\f\u0017\u0002BA\t\u0003\u000f\u0011AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\t\u0005]\u0011Q\u0004\t\u0004\u0011\u0006e\u0011bAA\u000e\u0013\n!QK\\5u\u0011%\ty\"DA\u0001\u0002\u0004\t\u0019!A\u0002yIE\nq\u0001^7q\t&\u0014\b%A\u0004m_\u001e$\u0015N]\u0019\u0002\u00171|w\rR5sc}#S-\u001d\u000b\u0005\u0003/\tI\u0003C\u0005\u0002 A\t\t\u00111\u0001\u0002\u0004\u0005AAn\\4ESJ\f\u0004%A\u0004m_\u001e$\u0015N\u001d\u001a\u0002\u00171|w\rR5se}#S-\u001d\u000b\u0005\u0003/\t\u0019\u0004C\u0005\u0002 M\t\t\u00111\u0001\u0002\u0004\u0005AAn\\4ESJ\u0014\u0004%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005m\u0002cA9\u0002>%\u0019\u0011q\b:\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\t9\"!\u0012\t\u0013\u0005}a#!AA\u0002\u0005m\u0012a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u00151|w-T1oC\u001e,'/\u0006\u0002\u0002NA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\r\u000b1\u0001\\8h\u0013\u0011\t9&!\u0015\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\t\u0005]\u0011Q\f\u0005\n\u0003?I\u0012\u0011!a\u0001\u0003\u001b\n1\u0002\\8h\u001b\u0006t\u0017mZ3sA\u0005IAn\\4D_:4\u0017nZ\u000b\u0003\u0003K\u0002B!a\u0014\u0002h%!\u0011\u0011NA)\u0005%aunZ\"p]\u001aLw-A\u0007m_\u001e\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003/\ty\u0007C\u0005\u0002 q\t\t\u00111\u0001\u0002f\u0005QAn\\4D_:4\u0017n\u001a\u0011\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\t\t9\b\u0005\u0003\u0002z\u00055e\u0002BA>\u0003\u0013sA!! \u0002\b:!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004\u0016\u000ba\u0001\u0010:p_Rt\u0014\"\u0001#\n\u0005M\u001c\u0015bAAFe\u0006a\u0011+^8uC\u001a\u000b7\r^8ss&!\u0011qRAI\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0019\u00111\u0012:\u0002#E,x\u000e^1NC:\fw-\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0018\u0005]\u0005\"CA\u0010?\u0005\u0005\t\u0019AA<\u00039\tXo\u001c;b\u001b\u0006t\u0017mZ3sg\u0002\nQa]3ukB$\"!a\u0006)\u0007\u0005\n\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\r\t9\u000bY\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003W\u000b)K\u0001\u0004CK\u001a|'/Z\u0001\u0014GJ,\u0017\r^3M_\u001e\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003c\u000bi\f\u0005\u0003\u00024\u0006eVBAA[\u0015\u0011\t9,a\u0003\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003w\u000b)L\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a0#\u0001\u0004\t\t-A\u0005pm\u0016\u0014(/\u001b3fgBA\u00111YAf\u0003#\f\tN\u0004\u0003\u0002F\u0006\u001d\u0007cAA@\u0013&\u0019\u0011\u0011Z%\u0002\rA\u0013X\rZ3g\u0013\u0011\ti-a4\u0003\u00075\u000b\u0007OC\u0002\u0002J&\u0003B!a1\u0002T&!\u0011Q[Ah\u0005\u0019\u0019FO]5oO\u0006AA/Z1s\t><h\u000eK\u0002$\u00037\u0004B!a)\u0002^&!\u0011q\\AS\u0005\u0015\te\r^3s\u0003}!Xm\u001d;NC.,G*Z1eKJ,\u0006\u000fZ1uKN,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a\u0015\u0004I\u0005\u0015\b\u0003BAR\u0003OLA!!;\u0002&\n!A+Z:u\u0003I\"Xm\u001d;NC.,G*Z1eKJ$u.Z:O_R,\u0006\u000fZ1uK\u0016\u0003xn\u00195DC\u000eDWMR8s\u001f2$gi\u001c:nCR\u001c\bfA\u0013\u0002f\u0006AC/Z:u\u001b\u0006L(-\u001a*fa2\f7-Z\"veJ,g\u000e^,ji\"4U\u000f^;sKJ+\u0007\u000f\\5dC\"\u001aa%!:\u0002yQ,7\u000f^'bs\n,'+\u001a9mC\u000e,7)\u001e:sK:$x+\u001b;i\rV$XO]3SKBd\u0017nY1ES\u001a4WM]3oi\n\u000b7/Z(gMN,Go\u001d\u0015\u0004O\u0005\u0015\u0018a\f;fgR4U\r^2i\u001f\u001a47/\u001a;T]\u0006\u00048\u000f[8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'\u000fT3bI\u0016\u0014\bf\u0001\u0015\u0002f\u0006\tD/Z:u\r\u0016$8\r[(gMN,Go\u00158baNDw\u000e^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\bfA\u0015\u0002f\u0006YC/Z:u\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000fK\u0002+\u0003K\fQ\u0006^3ti>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\rY\u0013Q]\u0001'i\u0016\u001cHOU3bIJ+7m\u001c:e\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'\u000fT3bI\u0016\u0014\bf\u0001\u0017\u0002f\u0006AC/Z:u%\u0016\fGMU3d_J$W\t]8dQZ\u000bG.\u001b3bi&|gNR8s\r>dGn\\<fe\"\u001aQ&!:\u0002gQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR4uN\u001d+j[\u0016\u001cH/Y7q\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'\u000fT3bI\u0016\u0014\bf\u0001\u0018\u0002f\u0006)D/Z:u\r\u0016$8\r[(gMN,GOR8s)&lWm\u001d;b[B,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\ry\u0013Q]\u0001)i\u0016\u001cHOR3uG\"d\u0015\r^3ti>3gm]3u\u0013:\u001cG.\u001e3fg2+\u0017\rZ3s\u000bB|7\r\u001b\u0015\u0004a\u0005\u0015\u0018!\n;fgRluN\\8u_:L7m\u00144gg\u0016$8/\u00114uKJdU-\u00193fe\u000eC\u0017M\\4fQ\r\t\u0014Q]\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$\u0002Ba\t\u0003*\t5\"q\u0007\t\u0004!\n\u0015\u0012b\u0001B\u0014\u0003\nI\u0001+\u0019:uSRLwN\u001c\u0005\u0007\u0005W\u0011\u0004\u0019A*\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0005_\u0011\u0004\u0019\u0001B\u0019\u0003!I7\u000fT3bI\u0016\u0014\bc\u0001%\u00034%\u0019!QG%\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u000b\u001a\u0011\u0002\u0003\u0007!\u0011\b\t\u0005\u0003\u001f\u0012Y$\u0003\u0003\u0003>\u0005E#a\u0001'pO\u0006\t3/\u001a;vaB\u000b'\u000f^5uS>tw+\u001b;i\u001b>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\t\u0016\u0005\u0005s\u0011)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\r\u0011\t&S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B+\u0005\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\"Xm\u001d;BaB,g\u000e\u001a*fG>\u0014Hm]!t\r>dGn\\<fe\n+Gn\\<M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007Q\n)/A\u000fuKN$H*[:u\u001f\u001a47/\u001a;Jg>d\u0017\r^5p]2+g/\u001a7tQ\r)\u0014Q]\u0001\u000fi\u0016\u001cHoR3u%\u0016\u0004H.[2bQ\r1\u0014Q]\u00018i\u0016\u001cH/\u00119qK:$'+Z2pe\u0012\u001cHk\u001c$pY2|w/\u001a:XSRDgj\u001c*fa2L7-\u0019+ie><8/\u0012=dKB$\u0018n\u001c8)\u0007]\n)/\u0001\u0013uKN$X*Y6f\r>dGn\\<fe^KG\u000f\u001b(p\u0019\u0016\fG-\u001a:JI\u000eC\u0017M\\4fQ\rA\u0014Q]\u0001Hi\u0016\u001cHOR8mY><XM\u001d#pKNtu\u000e\u001e&pS:L5KU+oi&d7)Y;hQR,\u0006\u000fV8PM\u001a\u001cX\r^,ji\"LgnQ;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\"\u001a\u0011(!:\u0002EQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eD\u0017I\u001a;fe\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3tQ\rQ\u0014Q]\u0001\u000eGJ,\u0017\r^3SK\u000e|'\u000fZ:\u0015\u0011\t]$1\u0011BP\u0005S\u0003BA!\u001f\u0003\u00005\u0011!1\u0010\u0006\u0004\u0005{Z\u0016A\u0002:fG>\u0014H-\u0003\u0003\u0003\u0002\nm$!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0003\u0006n\u0002\rAa\"\u0002\u000fI,7m\u001c:egB1!\u0011\u0012BJ\u00053sAAa#\u0003\u0010:!\u0011q\u0010BG\u0013\u0005Q\u0015b\u0001BI\u0013\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BK\u0005/\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005#K\u0005\u0003\u0002B=\u00057KAA!(\u0003|\ta1+[7qY\u0016\u0014VmY8sI\"9!\u0011U\u001eA\u0002\t\r\u0016A\u00032bg\u0016|eMZ:fiB\u0019\u0001J!*\n\u0007\t\u001d\u0016J\u0001\u0003M_:<\u0007\u0002\u0003BVwA\u0005\t\u0019A*\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u00032*\u001a1K!\u0012\u00025\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197SK\u000e|'\u000fZ:\u0015\u0011\t]$q\u0017B]\u0005wCqA!\">\u0001\u0004\u00119\tC\u0004\u0003\"v\u0002\rAa)\t\u0011\t-V\b%AA\u0002M\u000bAe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0014VmY8sIN$C-\u001a4bk2$HeM\u0001\ri\u0016\u001cH/\u0011;NS:L5O\u001d\u0015\u0004\u007f\u0005\u0015\b")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;
    private QuotaFactory.QuotaManagers quotaManagers;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$12 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$12, x$9), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put(KafkaConfig$.MODULE$.LogDirsProp(), ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""));
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), this.quotaManagers(), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        EasyMock.expect((Object)kafkaZkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)logProps).anyTimes();
        EasyMock.expect((Object)kafkaZkClient.conditionalUpdatePath((String)EasyMock.anyObject(), (byte[])EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), (Option)EasyMock.anyObject())).andReturn((Object)new Tuple2.mcZI.sp(true, 0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().shutdown(false);
        this.quotaManagers().shutdown();
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$22 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$22, x$3, x$4);
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.logEndOffset())));
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_10_2_IV0$.MODULE$.shortVersion())})))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = logConfig;
        boolean x$32 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$32, x$4);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.logEndOffset())));
        Assert.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log1 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = this.topicPartition();
        LogConfig x$6 = this.logConfig();
        boolean x$7 = true;
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        Log log2 = qual$2.getOrCreateLog(x$5, x$6, x$8, x$7);
        int x$9 = this.brokerId();
        TopicPartition x$10 = this.topicPartition();
        MockTime x$11 = this.time();
        Some x$12 = new Some((Object)log1);
        long x$13 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$9, x$10, (Time)x$11, x$13, (Option)x$12);
        int x$14 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$15 = this.topicPartition();
        MockTime x$16 = this.time();
        Some x$17 = new Some((Object)log2);
        long x$18 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$14, x$15, (Time)x$16, x$18, (Option)x$17);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Thread thread1 = new Thread(null, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.removeFutureLocalReplica(this.partition$1.removeFutureLocalReplica$default$1());
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        Thread thread2 = new Thread(null, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.maybeReplaceCurrentWithFutureReplica();
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.futureLocalReplica());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log1 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        log1.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())}), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
        log1.roll(log1.roll$default$1());
        log1.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())}), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = this.topicPartition();
        LogConfig x$6 = this.logConfig();
        boolean x$7 = true;
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        Log log2 = qual$2.getOrCreateLog(x$5, x$6, x$8, x$7);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)0);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        log2.appendAsFollower(builder.build());
        int x$9 = this.brokerId();
        TopicPartition x$10 = this.topicPartition();
        MockTime x$11 = this.time();
        Some x$12 = new Some((Object)log1);
        long x$13 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$9, x$10, (Time)x$11, x$13, (Option)x$12);
        int x$14 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$15 = this.topicPartition();
        MockTime x$16 = this.time();
        Some x$17 = new Some((Object)log2);
        long x$18 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$14, x$15, (Time)x$16, x$18, (Option)x$17);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Assert.assertTrue((boolean)partition.maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        Option timestampAndOffsetOpt = partition.fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assert.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)timestampAndOffset.leaderEpoch);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block48: {
            block49: {
                block47: {
                    block45: {
                        block46: {
                            block44: {
                                controllerEpoch = 3;
                                leader = this.brokerId();
                                follower1 = this.brokerId() + 1;
                                follower2 = this.brokerId() + 2;
                                controllerId = this.brokerId() + 3;
                                replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
                                isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
                                leaderEpoch = 8;
                                batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
                                Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 1, replicas, true), 0));
                                Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
                                Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(kafka.cluster.Replica ), (Lkafka/cluster/Replica;)Ljava/lang/Object;)(), Set$.MODULE$.canBuildFrom()));
                                leaderReplica = (Replica)partition.getReplica(leader).get();
                                follower1Replica = (Replica)partition.getReplica(follower1).get();
                                follower2Replica = (Replica)partition.getReplica(follower2).get();
                                partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3());
                                partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
                                Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
                                partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                Assert.assertEquals((long)2L, (long)((Replica)partition.localReplica().get()).highWatermark().messageOffset());
                                var23_15 = false;
                                var24_16 = null;
                                var25_17 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$, partition);
                                if (!(var25_17 instanceof Right)) ** GOTO lbl-1000
                                var23_15 = true;
                                var24_16 = (Right)var25_17;
                                var26_18 = (Option)var24_16.value();
                                if (var26_18 instanceof Some) {
                                    var27_19 = (Some)var26_18;
                                    offsetAndTimestamp = (FileRecords.TimestampAndOffset)var27_19.value();
                                    Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                    var8_21 = BoxedUnit.UNIT;
                                } else if (var23_15 && None$.MODULE$.equals(var29_24 = (Option)var24_16.value())) {
                                    Assert.fail((String)"Should have seen some offsets");
                                    var8_22 = BoxedUnit.UNIT;
                                } else if (var25_17 instanceof Left) {
                                    Assert.fail((String)"Should not have seen an error");
                                    var8_23 = BoxedUnit.UNIT;
                                } else {
                                    throw new MatchError((Object)var25_17);
                                }
                                var30_25 = false;
                                var31_26 = null;
                                var32_27 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                if (!(var32_27 instanceof Right)) ** GOTO lbl-1000
                                var30_25 = true;
                                var31_26 = (Right)var32_27;
                                var33_28 = (Option)var31_26.value();
                                if (var33_28 instanceof Some) {
                                    var34_29 = (Some)var33_28;
                                    offsetAndTimestamp = (FileRecords.TimestampAndOffset)var34_29.value();
                                    Assert.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                    var7_31 = BoxedUnit.UNIT;
                                } else if (var30_25 && None$.MODULE$.equals(var36_34 = (Option)var31_26.value())) {
                                    Assert.fail((String)"Should have seen some offsets");
                                    var7_32 = BoxedUnit.UNIT;
                                } else if (var32_27 instanceof Left) {
                                    Assert.fail((String)"Should not have seen an error");
                                    var7_33 = BoxedUnit.UNIT;
                                } else {
                                    throw new MatchError((Object)var32_27);
                                }
                                Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)PartitionTest.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition));
                                Assert.assertTrue((boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1));
                                Assert.assertTrue((boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch + 2, isr, 1, replicas, false), 2));
                                var37_35 = false;
                                var38_36 = null;
                                var39_37 = false;
                                var40_38 = null;
                                var41_39 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                if (!(var41_39 instanceof Right)) break block44;
                                var37_35 = true;
                                var38_36 = (Right)var41_39;
                                var42_40 = (Option)var38_36.value();
                                if (!(var42_40 instanceof Some)) break block44;
                                Assert.fail((String)"Should have failed with OffsetNotAvailable");
                                var6_41 = BoxedUnit.UNIT;
                                break block45;
                            }
                            if (!var37_35 || !None$.MODULE$.equals(var43_45 = (Option)var38_36.value())) break block46;
                            Assert.fail((String)"Should have seen an error");
                            var6_42 = BoxedUnit.UNIT;
                            break block45;
                        }
                        if (!(var41_39 instanceof Left)) ** GOTO lbl-1000
                        var39_37 = true;
                        var40_38 = (Left)var41_39;
                        e = (ApiException)var40_38.value();
                        if (e instanceof OffsetNotAvailableException) {
                            var6_43 = BoxedUnit.UNIT;
                        } else if (var39_37 && (e = (ApiException)var40_38.value()) != null) {
                            var46_48 = e;
                            Assert.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(var46_48).toString());
                            var6_44 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)var41_39);
                        }
                    }
                    var47_49 = false;
                    var48_50 = null;
                    var49_51 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$, partition);
                    if (!(var49_51 instanceof Right)) ** GOTO lbl-1000
                    var47_49 = true;
                    var48_50 = (Right)var49_51;
                    var50_52 = (Option)var48_50.value();
                    if (var50_52 instanceof Some) {
                        var51_53 = (Some)var50_52;
                        offsetAndTimestamp = (FileRecords.TimestampAndOffset)var51_53.value();
                        Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        var5_55 = BoxedUnit.UNIT;
                    } else if (var47_49 && None$.MODULE$.equals(var53_58 = (Option)var48_50.value())) {
                        Assert.fail((String)"Should have seen some offsets");
                        var5_56 = BoxedUnit.UNIT;
                    } else if (var49_51 instanceof Left && (e = (ApiException)(var54_59 = (Left)var49_51).value()) != null) {
                        var56_61 = e;
                        Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var56_61).toString());
                        var5_57 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)var49_51);
                    }
                    var57_62 = false;
                    var58_63 = null;
                    var59_64 = PartitionTest.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                    if (!(var59_64 instanceof Right)) ** GOTO lbl-1000
                    var57_62 = true;
                    var58_63 = (Right)var59_64;
                    var60_65 = (Option)var58_63.value();
                    if (var60_65 instanceof Some) {
                        var61_66 = (Some)var60_65;
                        offsetAndTimestamp = (FileRecords.TimestampAndOffset)var61_66.value();
                        Assert.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        var4_68 = BoxedUnit.UNIT;
                    } else if (var57_62 && None$.MODULE$.equals(var63_71 = (Option)var58_63.value())) {
                        Assert.fail((String)"Should have seen some offsets");
                        var4_69 = BoxedUnit.UNIT;
                    } else if (var59_64 instanceof Left && (e = (ApiException)(var64_72 = (Left)var59_64).value()) != null) {
                        var66_74 = e;
                        Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var66_74).toString());
                        var4_70 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)var59_64);
                    }
                    var67_75 = false;
                    var68_76 = null;
                    var69_77 = PartitionTest.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                    if (!(var69_77 instanceof Right)) ** GOTO lbl-1000
                    var67_75 = true;
                    var68_76 = (Right)var69_77;
                    var70_78 = (Option)var68_76.value();
                    if (var70_78 instanceof Some) {
                        var71_79 = (Some)var70_78;
                        offsetAndTimestamp = (FileRecords.TimestampAndOffset)var71_79.value();
                        Assert.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                        Assert.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        var3_81 = BoxedUnit.UNIT;
                    } else if (var67_75 && None$.MODULE$.equals(var73_84 = (Option)var68_76.value())) {
                        Assert.fail((String)"Should have seen some offsets");
                        var3_82 = BoxedUnit.UNIT;
                    } else if (var69_77 instanceof Left && (e = (ApiException)(var74_85 = (Left)var69_77).value()) != null) {
                        var76_87 = e;
                        Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var76_87).toString());
                        var3_83 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)var69_77);
                    }
                    var77_88 = false;
                    var78_89 = null;
                    var79_90 = false;
                    var80_91 = null;
                    var81_92 = PartitionTest.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                    if (!(var81_92 instanceof Right)) break block47;
                    var77_88 = true;
                    var78_89 = (Right)var81_92;
                    var82_93 = (Option)var78_89.value();
                    if (!(var82_93 instanceof Some)) break block47;
                    Assert.fail((String)"Should have failed");
                    var2_94 = BoxedUnit.UNIT;
                    break block48;
                }
                if (!var77_88 || !None$.MODULE$.equals(var83_98 = (Option)var78_89.value())) break block49;
                Assert.fail((String)"Should have failed");
                var2_95 = BoxedUnit.UNIT;
                break block48;
            }
            if (!(var81_92 instanceof Left)) ** GOTO lbl-1000
            var79_90 = true;
            var80_91 = (Left)var81_92;
            e = (ApiException)var80_91.value();
            if (e instanceof OffsetNotAvailableException) {
                var2_96 = BoxedUnit.UNIT;
            } else if (var79_90 && (e = (ApiException)var80_91.value()) != null) {
                var86_101 = e;
                Assert.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(var86_101).toString());
                var2_97 = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)var81_92);
            }
        }
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        var87_102 = false;
        var88_103 = null;
        var89_104 = PartitionTest.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
        if (!(var89_104 instanceof Right)) ** GOTO lbl-1000
        var87_102 = true;
        var88_103 = (Right)var89_104;
        var90_105 = (Option)var88_103.value();
        if (var90_105 instanceof Some) {
            var91_106 = (Some)var90_105;
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)var91_106.value();
            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
            var1_108 = BoxedUnit.UNIT;
        } else if (var87_102 && None$.MODULE$.equals(var93_111 = (Option)var88_103.value())) {
            Assert.fail((String)"Should have seen some offsets");
            var1_109 = BoxedUnit.UNIT;
        } else if (var89_104 instanceof Left && (e = (ApiException)(var94_112 = (Left)var89_104).value()) != null) {
            var96_114 = e;
            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(var96_114).toString());
            var1_110 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)var89_104);
        }
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)PartitionTest.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition));
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log) {
        java.util.List replicas;
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        int controllerId = 0;
        int controllerEpoch = 0;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId() + 1, leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)partition.leaderReplicaIfLocal());
        }
        return partition;
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        return qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 3L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)initialLogStartOffset, (long)replica.logEndOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records, false);
        Assert.assertEquals((String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)7L, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 7:", (long)8L, (long)replica.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 3L, this.createRecords$default$3());
            return partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)8L, (long)replica.logEndOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 8:", (long)9L, (long)replica.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        java.util.List replicas;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), 0L, this.createTransactionalRecords$default$3());
        partition.appendRecordsToLeader(records, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((long)3L, (long)PartitionTest.fetchLatestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
        replica.highWatermark_$eq(new LogOffsetMetadata(1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((long)3L, (long)PartitionTest.fetchLatestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)1L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)PartitionTest.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
    }

    @Test
    public void testGetReplica() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        int x$5 = this.brokerId();
        TopicPartition x$6 = this.topicPartition();
        MockTime x$7 = this.time();
        Some x$8 = new Some((Object)log);
        long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.localReplica());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.localReplicaOrException(), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        Assert.assertEquals((Object)replica, (Object)partition.localReplicaOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 0L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        LeaderAndIsrRequest.PartitionState partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        partition.makeFollower(0, partitionStateInfo, 0);
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        Assert.assertTrue((boolean)partition.makeFollower(0, partitionStateInfo, 2));
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava(), false);
        Assert.assertFalse((boolean)partition.makeFollower(0, partitionStateInfo, 2));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition.getReplica(leader).get();
        Replica follower1Replica = (Replica)partition.getReplica(follower1).get();
        Replica follower2Replica = (Replica)partition.getReplica(follower2).get();
        long lastOffsetOfFirstBatch = partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3()).lastOffset();
        partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)leaderReplica.highWatermark().messageOffset());
        partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)partition.makeLeader(controllerEpoch, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch + 2, isr, 1, replicas, false), 2));
        long currentLeaderEpochStartOffset = leaderReplica.logEndOffset();
        partition.appendRecordsToLeader(batch3, true, partition.appendRecordsToLeader$default$3());
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Set$.MODULE$.canBuildFrom()));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch3, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()), Set$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDelayedFetchAfterAppendRecords() {
        java.util.List replicaIds;
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicaIds = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)i -> PartitionTest.$anonfun$testDelayedFetchAfterAppendRecords$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = tp;
            LogConfig x$2 = logConfig;
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq replicas = (IndexedSeq)logs.map((Function1 & Serializable & scala.Serializable)log -> {
            int x$5 = this.brokerId();
            TopicPartition x$6 = log.topicPartition();
            MockTime x$7 = this.time();
            Some x$8 = new Some(log);
            long x$9 = Replica$.MODULE$.$lessinit$greater$default$4();
            return new Replica(x$5, x$6, (Time)x$7, x$9, (Option)x$8);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq partitions = (IndexedSeq)replicas.map((Function1 & Serializable & scala.Serializable)replica -> {
            TopicPartition tp = replica.topicPartition();
            Partition partition = new Partition(tp, false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
            partition.addReplicaIfNotExists(replica);
            partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicaIds, true), 0);
            return partition;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Capture tpKey = EasyMock.newCapture();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.capture((Capture)tpKey));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, tpKey, topicPartitions, partitions, leaderEpoch){
            private final Capture tpKey$1;
            private final IndexedSeq topicPartitions$1;
            private final IndexedSeq partitions$1;
            private final int leaderEpoch$1;

            public void answer() {
                int anotherPartition = (((TopicPartitionOperationKey)this.tpKey$1.getValue()).partition() + 1) % this.topicPartitions$1.size();
                Partition partition = (Partition)this.partitions$1.apply(anotherPartition);
                partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch$1)), true);
            }
            {
                this.tpKey$1 = tpKey$1;
                this.topicPartitions$1 = topicPartitions$1;
                this.partitions$1 = partitions$1;
                this.leaderEpoch$1 = leaderEpoch$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions.size() + 1);
        try {
            try {
                executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (!done.get()) {
                        partitions.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                            x$8.maybeShrinkIsr(10000L);
                            return BoxedUnit.UNIT;
                        });
                    }
                }));
                IndexedSeq futures = (IndexedSeq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> executor.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000).foreach((Function1 & Serializable & scala.Serializable)x$9 -> partition.appendRecordsToLeader(this.createRecords$1(0L), true, partition.appendRecordsToLeader$default$3())))), IndexedSeq$.MODULE$.canBuildFrom());
                futures.foreach((Function1 & Serializable & scala.Serializable)x$10 -> x$10.get(15L, TimeUnit.SECONDS));
                done.set(true);
            }
            catch (TimeoutException e) {
                String allThreads = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringBuilder(53).append("Test timed out with exception ").append(e).append(", thread stack traces: ").append(allThreads).toString());
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)Nil$.MODULE$)).asJava();
        int leaderEpoch = 8;
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertFalse((boolean)partition.isAtMinIsr());
        partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader, leaderEpoch, isr, 1, replicas, true), 0);
        Assert.assertTrue((boolean)partition.isAtMinIsr());
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        Either either = partition$2.fetchOffsetSnapshotOrError(currentLeaderEpoch, true);
        if (either instanceof Left) {
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Errors error = (Errors)right.value();
            Assert.assertEquals((Object)expectedError, (Object)error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        Either either = partition$3.fetchOffsetSnapshotOrError(currentLeaderEpoch, fetchOnlyLeader);
        if (either instanceof Left) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.NONE);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Errors error = (Errors)right.value();
            Assert.assertEquals((Object)expectedError, (Object)error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private final LogReadResult readResult$1(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    private static final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation, Partition partition$10) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)partition$10.fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(partition$10.getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    private static final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel, Partition partition$12) {
        Option res = partition$12.fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private static final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel, Partition partition$12) {
        Option res = partition$12.fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final LogReadResult readResult$2(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    public static final /* synthetic */ TopicPartition $anonfun$testDelayedFetchAfterAppendRecords$1(int i) {
        return new TopicPartition("test-topic", i);
    }

    private final MemoryRecords createRecords$1(long baseOffset) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public PartitionTest() {
        this.brokerId = 101;
    }

    public static final /* synthetic */ Object $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Replica x$4) {
        return BoxesRunTime.boxToInteger((int)x$4.brokerId());
    }
}

