/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u00041\u0001\u0001\u0006I\u0001\u000b\u0005\bc\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0011\u0004\u0001)A\u0005Q!91\u0007\u0001b\u0001\n\u0003!\u0004BB\u001e\u0001A\u0003%Q\u0007C\u0004=\u0001\t\u0007I\u0011A\u001f\t\r\u0011\u0003\u0001\u0015!\u0003?\u0011%)\u0005\u00011AA\u0002\u0013\u0005a\tC\u0005M\u0001\u0001\u0007\t\u0019!C\u0001\u001b\"I1\u000b\u0001a\u0001\u0002\u0003\u0006Ka\u0012\u0005\n)\u0002\u0001\r\u00111A\u0005\u0002UC\u0011\"\u0017\u0001A\u0002\u0003\u0007I\u0011\u0001.\t\u0013q\u0003\u0001\u0019!A!B\u00131\u0006\"B/\u0001\t\u0003q\u0006\"\u00025\u0001\t\u0003q\u0006\"B7\u0001\t\u0003q\u0006\"\u0002:\u0001\t\u0003q\u0006\"\u0002;\u0001\t\u0003q&a\u0003*fa2L7-\u0019+fgRT!a\u0006\r\u0002\u000f\rdWo\u001d;fe*\t\u0011$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002-\u00051A/\u001c9ESJ,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\n!![8\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nA\u0001^5nKV\tQ\u0007\u0005\u00027s5\tqG\u0003\u000291\u0005)Q\u000f^5mg&\u0011!h\u000e\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tG\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0003%\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0004Y><W#A$\u0011\u0005!SU\"A%\u000b\u0005\u0015C\u0012BA&J\u0005\raunZ\u0001\bY><w\fJ3r)\tq\u0015\u000b\u0005\u0002\u001e\u001f&\u0011\u0001K\b\u0002\u0005+:LG\u000fC\u0004S\u0017\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'\u0001\u0003m_\u001e\u0004\u0013a\u0002:fa2L7-Y\u000b\u0002-B\u0011QeV\u0005\u00031Z\u0011qAU3qY&\u001c\u0017-A\u0006sKBd\u0017nY1`I\u0015\fHC\u0001(\\\u0011\u001d\u0011f\"!AA\u0002Y\u000b\u0001B]3qY&\u001c\u0017\rI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002\u001d\"\u0012\u0001\u0003\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fQA[;oSRT\u0011!Z\u0001\u0004_J<\u0017BA4c\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0012UB\u0011\u0011m[\u0005\u0003Y\n\u0014Q!\u00114uKJ\f!\u0007^3tiN+w-\\3oi\u0012+G.\u001a;j_:<\u0016\u000e\u001e5IS\u001eDw+\u0019;fe6\f'o[%oSRL\u0017\r\\5{CRLwN\u001c\u0015\u0003%=\u0004\"!\u00199\n\u0005E\u0014'\u0001\u0002+fgR\fa\u0006^3ti\u000e\u000bgN\\8u\t\u0016dW\r^3TK\u001elWM\u001c;t\u0003R|%/\u00112pm\u0016D\u0015n\u001a5XCR,'/\\1sW\"\u00121c\\\u00013i\u0016\u001cHoQ1o]>$\u0018J\\2sK6,g\u000e\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e)bgRD\u0015n\u001a5XCR,'/\\1sW\"\"Ac\u001c<x\u0003!)\u0007\u0010]3di\u0016$7%\u0001=\u0011\u0007e\f\u0019!D\u0001{\u0015\tYH0\u0001\u0004feJ|'o\u001d\u0006\u0003{z\faaY8n[>t'BA\r\u0000\u0015\r\t\t\u0001Z\u0001\u0007CB\f7\r[3\n\u0007\u0005\u0015!PA\rPM\u001a\u001cX\r^(vi>3'+\u00198hK\u0016C8-\u001a9uS>t\u0007")
public class ReplicaTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private Log log;
    private Replica replica;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.log_$eq(Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.time().scheduler(), this.brokerTopicStats(), (Time)this.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10)));
        int x$1 = 0;
        TopicPartition x$2 = new TopicPartition("foo", 0);
        MockTime x$3 = this.time();
        Some x$4 = new Some((Object)this.log());
        long x$5 = Replica$.MODULE$.$lessinit$greater$default$4();
        this.replica_$eq(new Replica(x$1, x$2, (Time)x$3, x$5, (Option)x$4));
    }

    @After
    public void tearDown() {
        this.log().close();
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testSegmentDeletionWithHighWatermarkInitialization() {
        long initialHighWatermark = 25L;
        this.replica_$eq(new Replica(0, new TopicPartition("foo", 0), (Time)this.time(), initialHighWatermark, (Option)new Some((Object)this.log())));
        Assert.assertEquals((long)initialHighWatermark, (long)this.replica().highWatermark().messageOffset());
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaTest.$anonfun$testSegmentDeletionWithHighWatermarkInitialization$1(this, expiredTimestamp, BoxesRunTime.unboxToInt((Object)i)));
        int initialNumSegments = this.log().numberOfSegments();
        this.log().deleteOldSegments();
        Assert.assertTrue((this.log().numberOfSegments() < initialNumSegments ? 1 : 0) != 0);
        Assert.assertTrue((this.replica().logStartOffset() <= initialHighWatermark ? 1 : 0) != 0);
    }

    @Test
    public void testCannotDeleteSegmentsAtOrAboveHighWatermark() {
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1(this, expiredTimestamp, BoxesRunTime.unboxToInt((Object)i)));
        Assert.assertTrue((this.log().numberOfSegments() > 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.replica().highWatermark().messageOffset());
        Assert.assertEquals((long)0L, (long)this.replica().logStartOffset());
        Assert.assertEquals((long)100L, (long)this.replica().logEndOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)hw -> {
            this.replica().highWatermark_$eq(new LogOffsetMetadata((long)hw, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)hw, (long)this.replica().highWatermark().messageOffset());
            this.log().deleteOldSegments();
            Assert.assertTrue((this.replica().logStartOffset() <= (long)hw ? 1 : 0) != 0);
            this.log().logSegments().headOption().foreach((Function1 & Serializable & scala.Serializable)segment -> {
                ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3(this, hw, segment);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)this.log().logSegments().tail()).foreach((Function1 & Serializable & scala.Serializable)segment -> {
                ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$4(this, hw, segment);
                return BoxedUnit.UNIT;
            });
        });
        Assert.assertEquals((long)100L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)1L, (long)this.log().numberOfSegments());
        Assert.assertEquals((long)0L, (long)this.log().activeSegment().size());
    }

    @Test(expected=OffsetOutOfRangeException.class)
    public void testCannotIncrementLogStartOffsetPastHighWatermark() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaTest.$anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1(this, BoxesRunTime.unboxToInt((Object)i)));
        this.replica().highWatermark_$eq(new LogOffsetMetadata(25L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        this.replica().maybeIncrementLogStartOffset(26L);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testSegmentDeletionWithHighWatermarkInitialization$1(ReplicaTest $this, long expiredTimestamp$1, int i) {
        byte[] x$1 = new StringBuilder(4).append("test").append(i).toString().getBytes();
        long x$2 = expiredTimestamp$1;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
        Log qual$1 = $this.log();
        MemoryRecords x$6 = records;
        int x$7 = 0;
        boolean x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        return qual$1.appendAsLeader(x$6, x$7, x$8, x$9);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1(ReplicaTest $this, long expiredTimestamp$2, int i) {
        byte[] x$1 = new StringBuilder(4).append("test").append(i).toString().getBytes();
        long x$2 = expiredTimestamp$2;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
        Log qual$1 = $this.log();
        MemoryRecords x$6 = records;
        int x$7 = 0;
        boolean x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        return qual$1.appendAsLeader(x$6, x$7, x$8, x$9);
    }

    public static final /* synthetic */ void $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3(ReplicaTest $this, int hw$1, LogSegment segment) {
        Assert.assertTrue((segment.baseOffset() <= (long)hw$1 ? 1 : 0) != 0);
        Assert.assertTrue((segment.baseOffset() >= $this.replica().logStartOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$4(ReplicaTest $this, int hw$1, LogSegment segment) {
        Assert.assertTrue((segment.baseOffset() > (long)hw$1 ? 1 : 0) != 0);
        Assert.assertTrue((segment.baseOffset() >= $this.replica().logStartOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1(ReplicaTest $this, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringBuilder(4).append("test").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log qual$1 = $this.log();
        MemoryRecords x$1 = records;
        int x$2 = 0;
        boolean x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        return qual$1.appendAsLeader(x$1, x$2, x$3, x$4);
    }
}

