/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kafka.coordinator.transaction.ProducerIdBlock;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.coordinator.transaction.ProducerIdManagerTest$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r3Aa\u0002\u0005\u0001\u001f!)a\u0003\u0001C\u0001/!9!\u0004\u0001b\u0001\n\u0013Y\u0002B\u0002\u0012\u0001A\u0003%A\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u00032\u0001\u0011\u0005A\u0005C\u00037\u0001\u0011\u0005AEA\u000bQe>$WoY3s\u0013\u0012l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005%Q\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T!a\u0003\u0007\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0007\t\u00033\u0001i\u0011\u0001C\u0001\tu.\u001cE.[3oiV\tA\u0004\u0005\u0002\u001eA5\taD\u0003\u0002 \u0019\u0005\u0011!p[\u0005\u0003Cy\u0011QbS1gW\u0006T6n\u00117jK:$\u0018!\u0003>l\u00072LWM\u001c;!\u0003!!X-\u0019:E_^tG#A\u0013\u0011\u0005E1\u0013BA\u0014\u0013\u0005\u0011)f.\u001b;)\u0005\u0011I\u0003C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0015QWO\\5u\u0015\u0005q\u0013aA8sO&\u0011\u0001g\u000b\u0002\u0006\u0003\u001a$XM]\u0001\u0012i\u0016\u001cHoR3u!J|G-^2fe&#\u0007FA\u00034!\tQC'\u0003\u00026W\t!A+Z:u\u0003e!Xm\u001d;Fq\u000e,W\r\u001a)s_\u0012,8-\u001a:JI2KW.\u001b;)\t\u0019\u0019\u0004(O\u0001\tKb\u0004Xm\u0019;fI\u000e\n!\b\u0005\u0002<\u00036\tAH\u0003\u0002>}\u000511m\\7n_:T!!D \u000b\u0005\u0001k\u0013AB1qC\u000eDW-\u0003\u0002Cy\tq1*\u00194lC\u0016C8-\u001a9uS>t\u0007")
public class ProducerIdManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    @Test
    public void testGetProducerId() {
        ObjectRef zkVersion = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef data = ObjectRef.create(null);
        EasyMock.expect((Object)this.zkClient().getDataAndVersion(EasyMock.anyString())).andAnswer((IAnswer)new IAnswer<Tuple2<Option<byte[]>, Object>>(null, zkVersion, data){
            private final ObjectRef zkVersion$1;
            private final ObjectRef data$1;

            public Tuple2<Option<byte[]>, Object> answer() {
                return (Tuple2)((Option)this.zkVersion$1.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> $anon$1.$anonfun$answer$1(this, BoxesRunTime.unboxToInt((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0)));
            }

            public static final /* synthetic */ Tuple2 $anonfun$answer$1($anon$1 $this, int x$1) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)((byte[])$this.data$1.elem))), (Object)BoxesRunTime.boxToInteger((int)x$1));
            }
            {
                this.zkVersion$1 = zkVersion$1;
                this.data$1 = data$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(kafka.coordinator.transaction.ProducerIdManagerTest$$anon$1 java.lang.Object ), $anonfun$answer$2()}, serializedLambda);
            }
        }).anyTimes();
        Capture capturedVersion = EasyMock.newCapture();
        Capture capturedData = EasyMock.newCapture();
        EasyMock.expect((Object)this.zkClient().conditionalUpdatePath(EasyMock.anyString(), (byte[])EasyMock.capture((Capture)capturedData), BoxesRunTime.unboxToInt((Object)EasyMock.capture((Capture)capturedVersion)), (Option)EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Tuple2<Object, Object>>(null, capturedVersion, zkVersion, data, capturedData){
            private final Capture capturedVersion$1;
            private final ObjectRef zkVersion$1;
            private final ObjectRef data$1;
            private final Capture capturedData$1;

            public Tuple2<Object, Object> answer() {
                int newZkVersion = BoxesRunTime.unboxToInt((Object)this.capturedVersion$1.getValue()) + 1;
                this.zkVersion$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)newZkVersion));
                this.data$1.elem = (byte[])this.capturedData$1.getValue();
                return new Tuple2.mcZI.sp(true, newZkVersion);
            }
            {
                this.capturedVersion$1 = capturedVersion$1;
                this.zkVersion$1 = zkVersion$1;
                this.data$1 = data$1;
                this.capturedData$1 = capturedData$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        ProducerIdManager manager1 = new ProducerIdManager(0, this.zkClient());
        ProducerIdManager manager2 = new ProducerIdManager(1, this.zkClient());
        long pid1 = manager1.generateProducerId();
        long pid2 = manager2.generateProducerId();
        Assert.assertEquals((long)0L, (long)pid1);
        Assert.assertEquals((long)ProducerIdManager$.MODULE$.PidBlockSize(), (long)pid2);
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)ProducerIdManager$.MODULE$.PidBlockSize())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)(pid1 + i), (long)manager1.generateProducerId()));
        new RichLong(Predef$.MODULE$.longWrapper(1L)).until((Object)BoxesRunTime.boxToLong((long)ProducerIdManager$.MODULE$.PidBlockSize())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)(pid2 + i), (long)manager2.generateProducerId()));
        Assert.assertEquals((long)(pid2 + ProducerIdManager$.MODULE$.PidBlockSize()), (long)manager1.generateProducerId());
        Assert.assertEquals((long)(pid2 + ProducerIdManager$.MODULE$.PidBlockSize() * 2L), (long)manager2.generateProducerId());
    }

    @Test(expected=KafkaException.class)
    public void testExceedProducerIdLimit() {
        EasyMock.expect((Object)this.zkClient().getDataAndVersion(EasyMock.anyString())).andAnswer((IAnswer)new IAnswer<Tuple2<Option<byte[]>, Object>>(null){

            public Tuple2<Option<byte[]>, Object> answer() {
                byte[] json = ProducerIdManager$.MODULE$.generateProducerIdBlockJson(new ProducerIdBlock(0, Long.MAX_VALUE - ProducerIdManager$.MODULE$.PidBlockSize(), Long.MAX_VALUE));
                return new Tuple2((Object)new Some((Object)json), (Object)BoxesRunTime.boxToInteger((int)0));
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        new ProducerIdManager(0, this.zkClient());
    }
}

