/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y4A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!9!\u0004\u0001b\u0001\n\u0003Y\u0002BB\u0015\u0001A\u0003%A\u0004C\u0004+\u0001\t\u0007I\u0011A\u0016\t\rI\u0002\u0001\u0015!\u0003-\u0011\u001d\u0019\u0004A1A\u0005\u0002QBaa\u0010\u0001!\u0002\u0013)\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002(\u0001\t\u0003\t\u0005\"\u0002)\u0001\t\u0013\t\u0006\"\u00022\u0001\t\u0013\u0019'!\u0007'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRT!AD\b\u0002\u00071|wMC\u0001\u0011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0007\n\u0005Yi!!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001a!\t!\u0002!A\u0003d_\u0012,7-F\u0001\u001d!\tir%D\u0001\u001f\u0015\ty\u0002%\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003C\t\naaY8n[>t'B\u0001\t$\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\n\u0005!r\"aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002\r\r|G-Z2!\u0003\u0011!\u0018.\\3\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R!aL\b\u0002\u000bU$\u0018\u000e\\:\n\u0005Er#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012!\u000e\t\u0004meZT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0005qjT\"\u0001\u0011\n\u0005y\u0002#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002\n!\b^3ti6\u000b'o[:QCJ$\u0018\u000e^5p]N\f5o\u00144gY&tW-\u00118e!>\u0004X\u000f\\1uKN,fn\u00197fC:\f'\r\\3NKR\u0014\u0018nY:\u0015\u0003\t\u0003\"AN\"\n\u0005\u0011;$\u0001B+oSRDC\u0001\u0003$M\u001bB\u0011qIS\u0007\u0002\u0011*\u0011\u0011*J\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0017\"\u0013A\u0001V3ti\u00069A/[7f_V$hD\u0001\u001e\u0019\u0004]!Xm\u001d;NCbdunZ\"p[B\f7\r^5p]2\u000bw\r\u000b\u0002\n\r\u0006Y!/Z1e\rJ|W\u000eT8h)\t\u0011f\fE\u0002T-bk\u0011\u0001\u0016\u0006\u0003+^\n!bY8mY\u0016\u001cG/[8o\u0013\t9FK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u00111\u0014lW.\n\u0005i;$A\u0002+va2,'\u0007\u0005\u000279&\u0011Ql\u000e\u0002\u0004\u0013:$\b\"\u0002\b\u000b\u0001\u0004y\u0006C\u0001\u000ba\u0013\t\tWBA\u0002M_\u001e\fAb\u001e:ji\u0016\\U-\u001f#vaN$\u0002\u0002Z4jW2l'\u000f\u001e\t\u0004'\u0016D\u0016B\u00014U\u0005\r\u0019V-\u001d\u0005\u0006Q.\u0001\raW\u0001\b]Vl7*Z=t\u0011\u0015Q7\u00021\u0001\\\u0003\u001dqW/\u001c#vaNDQAD\u0006A\u0002}CQAG\u0006A\u0002qAQA\\\u0006A\u0002=\f\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0005Y\u0002\u0018BA98\u0005\u0011auN\\4\t\u000bM\\\u0001\u0019A.\u0002\u0015M$\u0018M\u001d;WC2,X\rC\u0003v\u0017\u0001\u00071,\u0001\u0003ti\u0016\u0004\b")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test(timeout=15000L)
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        MemoryRecords largeMessageSet;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MemoryRecords memoryRecords = largeMessageSet = (MemoryRecords)tuple2._2();
        MemoryRecords largeMessageSet2 = memoryRecords;
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = maxMessageSize;
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$11));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = LogCleanerIntegrationTest.getGauge$1("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = LogCleanerIntegrationTest.getGauge$1("uncleanable-bytes", uncleanableDirectory);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge.value()) == 2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There should be 2 uncleanable partitions", 2000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        long expectedTotalUncleanableBytes = LogCleaner$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleaner$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge.value()) == expectedTotalUncleanableBytes, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes).append(" uncleanable bytes").toString(), 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assert.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$2 = cleanerBackOffMs;
        long x$3 = minCompactionLagMs;
        int x$4 = segmentSize;
        long x$5 = maxCompactionLagMs;
        float x$6 = minCleanableDirtyRatio;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$6, x$7, x$2, x$8, x$3, x$9, x$4, x$5, x$10, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assert.assertEquals((String)"There should be no cleaning until the max compaction lag has passed", (long)startSizeBlock0, (long)log.size());
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$13 = firstBlockCleanableSegmentOffset;
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, x$13, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", ").append("but lastCleaned=").append(lastCleaned).toString(), (lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0);
        Assert.assertNotEquals((String)"log should still contain non-zero keys", appends1, read1);
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$15 = new TopicPartition("log", 0);
        long x$16 = activeSegAtT1.baseOffset();
        long x$17 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$15, x$16, x$17);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assert.assertEquals((String)"log should only contains zero keys now", appends1, read2);
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assert.assertTrue((String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", ").append("but lastCleaned=").append(lastCleaned2).toString(), (lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        Log log = (Log)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(String metricName$1, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$1) && k.getScope().endsWith(metricScope$1);
    }

    private static final Gauge getGauge$1(String metricName, String metricScope) {
        return (Gauge)((Tuple2)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(metricName, metricScope, k))).headOption().getOrElse((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString())))._2();
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, Log log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = ((Object)BoxesRunTime.boxToInteger((int)curValue)).toString().getBytes();
        CompressionType x$2 = codec$1;
        byte[] x$3 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        long x$4 = timestamp$1;
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$2, x$4, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, Log log$1, CompressionType codec$1, long timestamp$1, int step$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }
}

