/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.CheckpointFile;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00013AAB\u0004\u0001\u001d!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)Q\u0006\u0001C\u0001A!)q\u0006\u0001C\u0001A!)\u0011\u0007\u0001C\u0001A\tArJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$Vm\u001d;\u000b\u0005!I\u0011aC2iK\u000e\\\u0007o\\5oiNT!AC\u0006\u0002\rM,'O^3s\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0017\u0005)Q\u000f^5mg&\u0011!d\u0006\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\tq!\u0001\u0014tQ>,H\u000e\u001a)feNL7\u000f^!oI>3XM]<sSR,\u0017I\u001c3SK2|\u0017\r\u001a$jY\u0016$\u0012!\t\t\u0003!\tJ!aI\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0015\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000b),h.\u001b;\u000b\u0003)\n1a\u001c:h\u0013\tasE\u0001\u0003UKN$\u0018!G:i_VdG\rS1oI2,W*\u001e7uSBdW\rT5oKND#aA\u0013\u0002AMDw.\u001e7e%\u0016$XO\u001d8F[B$\u00180T1q\r>\u0014X)\u001c9us\u001aKG.\u001a\u0015\u0003\t\u0015\n1e\u001d5pk2$G\u000b\u001b:po&3g+\u001a:tS>t\u0017j\u001d(piJ+7m\\4oSN,G\r\u000b\u0003\u0006KM\"\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003U\u0002\"A\u000e \u000e\u0003]R!\u0001O\u001d\u0002\r\u0015\u0014(o\u001c:t\u0015\tQ4(\u0001\u0004d_6lwN\u001c\u0006\u0003\u0019qR!!P\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tytGA\u000bLC\u001a\\\u0017m\u0015;pe\u0006<W-\u0012=dKB$\u0018n\u001c8")
public class OffsetCheckpointFileTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        OffsetCheckpointFileTest offsetCheckpointFileTest = this;
        synchronized (offsetCheckpointFileTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 2)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
        Map offsets2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)15L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 3)), (Object)BoxesRunTime.boxToLong((long)20L))}));
        checkpoint.write(offsets2);
        Assert.assertEquals((Object)offsets2, (Object)checkpoint.read());
    }

    @Test
    public void shouldHandleMultipleLines() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Map offsets = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 6)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 7)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 8)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 9)), (Object)BoxesRunTime.boxToLong((long)10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)5L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 10)), (Object)BoxesRunTime.boxToLong((long)10L))}));
        checkpoint.write(offsets);
        Assert.assertEquals((Object)offsets, (Object)checkpoint.read());
    }

    @Test
    public void shouldReturnEmptyMapForEmptyFile() {
        OffsetCheckpointFile checkpoint = new OffsetCheckpointFile(TestUtils$.MODULE$.tempFile(), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
        checkpoint.write((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)checkpoint.read());
    }

    @Test(expected=KafkaStorageException.class)
    public void shouldThrowIfVersionIsNotRecognised() {
        File file = TestUtils$.MODULE$.tempFile();
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        CheckpointFile checkpointFile = new CheckpointFile(file, OffsetCheckpointFile$.MODULE$.CurrentVersion() + 1, (CheckpointFileFormatter)OffsetCheckpointFile.Formatter$.MODULE$, logDirFailureChannel, file.getParent());
        checkpointFile.write((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)BoxesRunTime.boxToLong((long)10L))})));
        new OffsetCheckpointFile(checkpointFile.file(), logDirFailureChannel).read();
    }

    public OffsetCheckpointFileTest() {
        Logging.$init$((Logging)this);
    }
}

