/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CoreUtils$ {
    public static CoreUtils$ MODULE$;
    private final Logger logger;

    static {
        new CoreUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public <A, B> A min(TraversableOnce<A> traversable, A ifEmpty, Ordering<B> cmp) {
        return (A)(traversable.isEmpty() ? ifEmpty : traversable.min(cmp));
    }

    public Runnable runnable(Function0<BoxedUnit> fun) {
        return new Runnable(fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        };
    }

    public Thread newThread(String name, boolean daemon, Function0<BoxedUnit> fun) {
        return new KafkaThread(name, this.runnable(fun), daemon);
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable e) {
            Level level = logLevel;
            if (Level.ERROR.equals(level)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(e.getMessage(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            if (Level.WARN.equals(level)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(e.getMessage(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            }
            if (Level.INFO.equals(level)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(e.getMessage(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit;
            }
            if (Level.DEBUG.equals(level)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(e.getMessage(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit5 = boxedUnit;
            }
            if (Level.TRACE.equals(level)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(e.getMessage(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit6 = boxedUnit;
            }
            throw new MatchError((Object)level);
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1 & Serializable & scala.Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef exception = ObjectRef.create(null);
        all.foreach((Function1 & Serializable & scala.Serializable)element -> {
            CoreUtils$.$anonfun$tryAll$1(exception, element);
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs;
            MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mBeanServer) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
            }
        }
        catch (Exception e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(25).append("Failed to register Mbean ").append(name).toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs;
        MBeanServer mBeanServer = mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mBeanServer) {
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
        }
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n;
        int n2 = channel.read(buffer);
        if (-1 == n2) {
            throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
        }
        int n3 = n = n2;
        return n3;
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        Tuple2[] keyVals = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*"))).map((Function1 & Serializable & scala.Serializable)s -> {
            int lio = s.lastIndexOf(":");
            return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyVals)).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        return csvList == null || csvList.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*"))).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$parseCsvList$1(v))));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        Class<?> klass = Class.forName(className, true, Utils.getContextOrKafkaClassLoader());
        Constructor<?> constructor = klass.getConstructor((Class[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getClass(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        return (T)constructor.newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        return Iterator$.MODULE$.continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1).flatMap((Function1 & Serializable & scala.Serializable)_ -> CoreUtils$.$anonfun$circularIterator$2(coll, BoxesRunTime.unboxToInt((Object)_)));
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (!s.endsWith(oldSuffix)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Expected string to end with '%s' but string is '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
        }
        return new StringBuilder(0).append(s.substring(0, s.length() - oldSuffix.length())).append(newSuffix).toString();
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        Object object;
        lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        return this.inLock(lock.readLock(), fun);
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        return this.inLock(lock.writeLock(), fun);
    }

    public String JSONEscapeString(String s) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(s)).map((Function1 & Serializable & scala.Serializable)x0$1 -> CoreUtils$.$anonfun$JSONEscapeString$1(BoxesRunTime.unboxToChar((Object)x0$1)), Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    public <T> Iterable<T> duplicates(Traversable<T> s) {
        return ((MapLike)((TraversableLike)s.groupBy((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Traversable l = (Traversable)tuple2._2();
            Tuple2 tuple22 = new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        void var3_5;
        Seq seq;
        try {
            Seq<String> listenerList = this.parseCsvList(listeners);
            seq = (Seq)listenerList.map((Function1 & Serializable & scala.Serializable)x$5 -> EndPoint$.MODULE$.createEndPoint((String)x$5, (Option<Map<ListenerName, SecurityProtocol>>)new Some((Object)securityProtocolMap)), Seq$.MODULE$.canBuildFrom());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Error creating broker listeners from '").append(listeners).append("': ").append(e.getMessage()).toString(), e);
        }
        Seq endPoints = seq;
        CoreUtils$.validate$1(endPoints, listeners);
        return var3_5;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value)}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propsWith(Seq<Tuple2<String, String>> props) {
        void var2_2;
        Properties properties = new Properties();
        props.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = properties.put(k, v);
            return object;
        });
        return var2_2;
    }

    public <K, V> V atomicGetOrUpdate(scala.collection.concurrent.Map<K, V> map, K key, Function0<V> createValue) {
        Object object;
        Option option = map.get(key);
        if (option instanceof Some) {
            Object value;
            Some some = (Some)option;
            object = value = some.value();
        } else if (None$.MODULE$.equals(option)) {
            Object value = createValue.apply();
            object = map.putIfAbsent(key, value).getOrElse((Function0 & Serializable & scala.Serializable)() -> value);
        } else {
            throw new MatchError((Object)option);
        }
        return (V)object;
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete((File)new File(f));
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        block3: {
            try {
                element.apply$mcV$sp();
            }
            catch (Throwable e) {
                if ((Throwable)exception$1.elem != null) {
                    ((Throwable)exception$1.elem).addSuppressed(e);
                    break block3;
                }
                exception$1.elem = e;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseCsvList$1(String v) {
        return !v.equals("");
    }

    public static final /* synthetic */ Iterable $anonfun$circularIterator$2(Iterable coll$1, int _) {
        return (Iterable)coll$1.map((Function1 & Serializable & scala.Serializable)t -> t, Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Object $anonfun$JSONEscapeString$1(char x0$1) {
        Object object;
        char c = x0$1;
        switch (c) {
            case '\"': {
                object = "\\\"";
                break;
            }
            case '\\': {
                object = "\\\\";
                break;
            }
            case '/': {
                object = "\\/";
                break;
            }
            case '\b': {
                object = "\\b";
                break;
            }
            case '\f': {
                object = "\\f";
                break;
            }
            case '\n': {
                object = "\\n";
                break;
            }
            case '\r': {
                object = "\\r";
                break;
            }
            case '\t': {
                object = "\\t";
                break;
            }
            default: {
                if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                    object = new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
                    break;
                }
                object = BoxesRunTime.boxToCharacter((char)c);
                break;
            }
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int l = tuple2._2$mcI$sp();
        boolean bl = l > 1;
        return bl;
    }

    private static final void validate$1(Seq endPoints, String listeners$1) {
        Seq portsExcludingZero = (Seq)((TraversableLike)endPoints.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.port()), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != 0);
        Seq distinctPorts = (Seq)portsExcludingZero.distinct();
        Seq distinctListenerNames = (Seq)((SeqLike)endPoints.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.listenerName(), Seq$.MODULE$.canBuildFrom())).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == portsExcludingZero.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Each listener must have a different port, listeners: ").append(listeners$1).toString());
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Each listener must have a different name, listeners: ").append(listeners$1).toString());
    }

    private CoreUtils$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }
}

