/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeleteRecordsCommand$ {
    public static DeleteRecordsCommand$ MODULE$;
    private final int EarliestVersion;

    static {
        new DeleteRecordsCommand$();
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JsonValue jsonValue = (JsonValue)some2.value();
                n = BoxesRunTime.unboxToInt((Object)jsonValue.to(DecodeJson$DecodeInt$.MODULE$));
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            int version = n;
            return this.parseJsonData(version, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<Tuple2<TopicPartition, Object>> parseJsonData(int version, JsonValue js) {
        Buffer buffer;
        int n = version;
        switch (n) {
            case 1: {
                Option<JsonValue> option = js.asJsonObject().get("partitions");
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JsonValue partitions = (JsonValue)some.value();
                    buffer = partitions.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1 & Serializable & scala.Serializable)partitionJs -> {
                        String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition = BoxesRunTime.unboxToInt((Object)partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        long offset = BoxesRunTime.unboxToLong((Object)partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToLong((long)offset));
                    }).toBuffer();
                    break;
                }
                throw new AdminOperationException("Missing partitions field");
            }
            default: {
                throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
            }
        }
        return buffer;
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        Admin adminClient = this.createAdminClient(opts);
        String offsetJsonFile = (String)opts.options().valueOf(opts.offsetJsonFileOpt());
        String offsetJsonString = Utils.readFileAsString((String)offsetJsonFile);
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Traversable)offsetSeq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
        }
        java.util.Map recordsToDelete = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)offsetSeq.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)RecordsToDelete.beforeOffset((long)offset));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        out.println("Executing records delete operation");
        DeleteRecordsResult deleteRecordsResult = adminClient.deleteRecords(recordsToDelete);
        out.println("Records delete operation completed:");
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(deleteRecordsResult.lowWatermarks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DeleteRecordsCommand$.$anonfun$execute$3(out, x0$3);
            return BoxedUnit.UNIT;
        });
        adminClient.close();
    }

    private Admin createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$execute$3(PrintStream out$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            KafkaFuture partitionResult = (KafkaFuture)tuple2._2();
            try {
                out$1.println(new StringBuilder(27).append("partition: ").append(tp).append("\tlow_watermark: ").append(((DeletedRecords)partitionResult.get()).lowWatermark()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                out$1.println(new StringBuilder(19).append("partition: ").append(tp).append("\terror: ").append(e.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private DeleteRecordsCommand$() {
        MODULE$ = this;
        this.EarliestVersion = 1;
    }
}

