/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagMetrics;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055f!B\u000e\u001d\u0003\u0003\t\u0003\u0002C\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011\t\u0003!\u0011!Q\u0001\n]B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\")\u0001\n\u0001C\u0001\u0013\"A!\f\u0001b\u0001\n\u0003a2\f\u0003\u0004h\u0001\u0001\u0006I\u0001\u0018\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019\u0011\b\u0001)A\u0005U\"91\u000f\u0001a\u0001\n\u0013!\bbB;\u0001\u0001\u0004%IA\u001e\u0005\u0007y\u0002\u0001\u000b\u0015B#\t\u000fu\u0004!\u0019!C\u0001}\"9\u0011Q\u0001\u0001!\u0002\u0013y\b\"CA\u0004\u0001\t\u0007I\u0011AA\u0005\u0011!\t\t\u0003\u0001Q\u0001\n\u0005-\u0001bBA\u0012\u0001\u0011\u0005A\u0004\u001e\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011!\ti\u0003\u0001C\u00019\u0005=\u0002\u0002CA)\u0001\u0011\u0005A$a\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u00111\u000e\u0001\u0007\u0002\u00055\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!a+\u0001\t\u0003\tIK\u0001\fBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s\u0015\tib$\u0001\u0004tKJ4XM\u001d\u0006\u0002?\u0005)1.\u00194lC\u000e\u0001QC\u0001\u0012O'\u0011\u00011%K\u0018\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\tQS&D\u0001,\u0015\tac$A\u0003vi&d7/\u0003\u0002/W\t9Aj\\4hS:<\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u001f\u0003\u001diW\r\u001e:jGNL!\u0001N\u0019\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0003oC6,W#A\u001c\u0011\u0005azdBA\u001d>!\tQT%D\u0001<\u0015\ta\u0004%\u0001\u0004=e>|GOP\u0005\u0003}\u0015\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011a(J\u0001\u0006]\u0006lW\rI\u0001\tG2LWM\u001c;JI\u0006Ya.^7GKR\u001c\u0007.\u001a:t!\t!c)\u0003\u0002HK\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\u0011Qu\u000bW-\u0011\u0007-\u0003A*D\u0001\u001d!\tie\n\u0004\u0001\u0005\u000b=\u0003!\u0019\u0001)\u0003\u0003Q\u000b\"!\u0015+\u0011\u0005\u0011\u0012\u0016BA*&\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aS+\n\u0005Yc\"!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\u0006k\u0015\u0001\ra\u000e\u0005\u0006\u0007\u0016\u0001\ra\u000e\u0005\u0006\t\u0016\u0001\r!R\u0001\u0011M\u0016$8\r[3s)\"\u0014X-\u00193NCB,\u0012\u0001\u0018\t\u0005;\n$G*D\u0001_\u0015\ty\u0006-A\u0004nkR\f'\r\\3\u000b\u0005\u0005,\u0013AC2pY2,7\r^5p]&\u00111M\u0018\u0002\b\u0011\u0006\u001c\b.T1q!\tYU-\u0003\u0002g9\t!\"I]8lKJLE-\u00118e\r\u0016$8\r[3s\u0013\u0012\f\u0011CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199!\u0003\u0011awnY6\u0016\u0003)\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\t1\fgn\u001a\u0006\u0002_\u0006!!.\u0019<b\u0013\t\tHN\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0015]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:\u0016\u0003\u0015\u000b\u0001D\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014x\fJ3r)\t9(\u0010\u0005\u0002%q&\u0011\u00110\n\u0002\u0005+:LG\u000fC\u0004|\u0017\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'A\u000bok64U\r^2iKJ\u001c\b+\u001a:Ce>\\WM\u001d\u0011\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cX#A@\u0011\u0007-\u000b\t!C\u0002\u0002\u0004q\u0011\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002#\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\u000bgC&dW\r\u001a)beRLG/[8og\u000e{WO\u001c;\u0016\u0005\u0005-\u0001#BA\u0007\u0003;)UBAA\b\u0015\u0011\t\t\"a\u0005\u0002\t\r|'/\u001a\u0006\u0004e\u0005U!\u0002BA\f\u00033\ta!_1n[\u0016\u0014(BAA\u000e\u0003\r\u0019w.\\\u0005\u0005\u0003?\tyAA\u0003HCV<W-\u0001\fgC&dW\r\u001a)beRLG/[8og\u000e{WO\u001c;!\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$\u0018\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\r9\u0018\u0011\u0006\u0005\u0007\u0003W\u0011\u0002\u0019A#\u0002\u000f9,woU5{K\u0006Qq-\u001a;GKR\u001c\u0007.\u001a:\u0015\t\u0005E\u0012q\u0007\t\u0005I\u0005MB*C\u0002\u00026\u0015\u0012aa\u00149uS>t\u0007bBA\u001d'\u0001\u0007\u00111H\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ti$!\u0014\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\naaY8n[>t'bA\u0010\u0002F)!\u0011qIA%\u0003\u0019\t\u0007/Y2iK*\u0011\u00111J\u0001\u0004_J<\u0017\u0002BA(\u0003\u007f\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0007hKR4U\r^2iKJLE\rF\u0002F\u0003+Bq!!\u000f\u0015\u0001\u0004\tY$A\u000enCJ\\\u0007+\u0019:uSRLwN\\:G_J$&/\u001e8dCRLwN\u001c\u000b\bo\u0006m\u0013qLA1\u0011\u0019\ti&\u0006a\u0001\u000b\u0006A!M]8lKJLE\rC\u0004\u0002:U\u0001\r!a\u000f\t\u000f\u0005\rT\u00031\u0001\u0002f\u0005\u0001BO];oG\u0006$\u0018n\u001c8PM\u001a\u001cX\r\u001e\t\u0004I\u0005\u001d\u0014bAA5K\t!Aj\u001c8h\u0003M\u0019'/Z1uK\u001a+Go\u00195feRC'/Z1e)\u0015a\u0015qNA:\u0011\u0019\t\tH\u0006a\u0001\u000b\u0006Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\u0005\b\u0003k2\u0002\u0019AA<\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\u0011\tI(a \u000e\u0005\u0005m$bAA?=\u000591\r\\;ti\u0016\u0014\u0018\u0002BAA\u0003w\u0012aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/A\fbI\u00124U\r^2iKJ4uN\u001d)beRLG/[8ogR\u0019q/a\"\t\u000f\u0005%u\u00031\u0001\u0002\f\u0006\u0019\u0002/\u0019:uSRLwN\\!oI>3gm]3ugBA\u0011QRAH\u0003w\t\u0019*D\u0001a\u0013\r\t\t\n\u0019\u0002\u0004\u001b\u0006\u0004\bcA&\u0002\u0016&\u0019\u0011q\u0013\u000f\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X-\u0001\u000esK6|g/\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002x\u0003;Cq!a(\u0019\u0001\u0004\t\t+\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!!$\u0002$\u0006m\u0012bAASA\n\u00191+\u001a;\u00025MDW\u000f\u001e3po:LE\r\\3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ:\u0015\u0003]\f\u0001c\u00197pg\u0016\fE\u000e\u001c$fi\u000eDWM]:")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final Gauge<Object> failedPartitionsCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    public Gauge<Object> failedPartitionsCount() {
        return this.failedPartitionsCount;
    }

    public int deadThreadCount() {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
        }
        return n;
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Option option;
        Object object = this.lock();
        synchronized (object) {
            option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
        }
        return option;
    }

    public int getFetcherId(TopicPartition topicPartition) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
        }
        return n;
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)tuple2._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            });
            partitionsPerFetcher.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, partitionAndOffsets, x$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        block3: {
            Object object = this.lock();
            synchronized (object) {
                this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> {
                    fetcher.removePartitions((Set<TopicPartition>)partitions);
                    return BoxedUnit.UNIT;
                });
                this.failedPartitions().removeAll(partitions);
            }
            if (!partitions.nonEmpty()) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x$4;
                if (tuple2 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)tuple2._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$5)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$6);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
        }
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, Tuple2 x0$1) {
        Map<TopicPartition, InitialFetchState> removedPartitions;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)tuple2._1();
            AbstractFetcherThread thread = (AbstractFetcherThread)tuple2._2();
            removedPartitions = thread.partitionsAndOffsets();
            $this.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
            if (id.fetcherId() >= newSize$1) {
                thread.shutdown();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.addFetcherForPartitions(removedPartitions);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$addFetcherForPartitions$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        InitialFetchState brokerAndInitOffset = (InitialFetchState)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(brokerAndInitOffset.initOffset(), brokerAndInitOffset.currentLeaderEpoch()));
        return tuple22;
    }

    public static final /* synthetic */ String $anonfun$addFetcherForPartitions$5(BrokerAndFetcherId brokerAndFetcherId$1, Map initialOffsetAndEpochs$1) {
        return new StringBuilder(40).append("Added fetcher to broker ").append(brokerAndFetcherId$1.broker()).append(" for partitions ").append(initialOffsetAndEpochs$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Map partitionAndOffsets$1, Tuple2 x$3) {
        var5_3 = x$3;
        if (var5_3 == null) ** GOTO lbl27
        brokerAndFetcherId = (BrokerAndFetcherId)var5_3._1();
        initialFetchOffsets = (Map)var5_3._2();
        brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
        var10_7 = false;
        var11_8 = null;
        var12_9 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
        if (!(var12_9 instanceof Some)) ** GOTO lbl-1000
        var10_7 = true;
        var11_8 = (Some)var12_9;
        currentFetcherThread = (AbstractFetcherThread)var11_8.value();
        v0 = currentFetcherThread.sourceBroker();
        var14_11 = brokerAndFetcherId.broker();
        if (!(v0 != null ? v0.equals(var14_11) == false : var14_11 != null)) {
            var4_12 = currentFetcherThread;
        } else if (var10_7) {
            f = (AbstractFetcherThread)var11_8.value();
            f.shutdown();
            var4_12 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else if (None$.MODULE$.equals(var12_9)) {
            var4_12 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
        } else {
            throw new MatchError((Object)var12_9);
lbl27:
            // 1 sources

            throw new MatchError((Object)var5_3);
        }
        fetcherThread = var4_12;
        initialOffsetAndEpochs = (Map)initialFetchOffsets.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom());
        fetcherThread.addPartitions((Map<TopicPartition, OffsetAndEpoch>)initialOffsetAndEpochs);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addFetcherForPartitions$5(kafka.server.BrokerAndFetcherId scala.collection.Map ), ()Ljava/lang/String;)((BrokerAndFetcherId)brokerAndFetcherId, (Map)initialOffsetAndEpochs));
        $this.failedPartitions().removeAll((Set<TopicPartition>)partitionAndOffsets$1.keySet());
        var3_16 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        boolean bl = fetcher.initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        fetcher.shutdown();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$1(BoxesRunTime.unboxToLong((Object)curMaxAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ long $anonfun$value$2(long curMaxThread, Tuple2 fetcherLagStatsEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(curMaxThread), ((FetcherLagMetrics)fetcherLagStatsEntry._2()).lag());
            }

            public static final /* synthetic */ long $anonfun$value$1(long curMaxAll, Tuple2 fetcherThreadMapEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherLagStats().stats().foldLeft(BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxThread, fetcherLagStatsEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$2(BoxesRunTime.unboxToLong((Object)curMaxThread), fetcherLagStatsEntry))))), curMaxAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(java.lang.Object scala.Tuple2 ), $anonfun$value$2$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public double value() {
                double headRate = BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$3(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                return BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ double $anonfun$value$3(Tuple2 x$1) {
                return ((AbstractFetcherThread)x$1._2()).fetcherStats().requestRate().oneMinuteRate();
            }

            public static final /* synthetic */ double $anonfun$value$5(double curMinAll, Tuple2 fetcherThreadMapEntry) {
                return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherStats().requestRate().oneMinuteRate()), curMinAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4(), $anonfun$value$5$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.failedPartitionsCount = this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public int value() {
                return this.$outer.failedPartitions().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public int value() {
                return this.$outer.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
    }
}

