/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import kafka.ReplicationQuotasTestRig$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\ruu!\u0002-Z\u0011\u0003af!\u00020Z\u0011\u0003y\u0006\"\u00024\u0002\t\u00039\u0007b\u00025\u0002\u0005\u0004%I!\u001b\u0005\u0007e\u0006\u0001\u000b\u0011\u00026\t\u000fM\f!\u0019!C\u0001i\"1\u00010\u0001Q\u0001\nUDQ!_\u0001\u0005\u0002iDq!a\u0007\u0002\t\u0003\tiB\u0002\u0004\u0002(\u0005\u0001\u0015\u0011\u0006\u0005\u000b\u0003oI!Q3A\u0005\u0002\u0005e\u0002BCA\u001e\u0013\tE\t\u0015!\u0003\u0002\b!I\u0011QH\u0005\u0003\u0016\u0004%\t\u0001\u001e\u0005\n\u0003\u007fI!\u0011#Q\u0001\nUD\u0011\"!\u0011\n\u0005+\u0007I\u0011\u0001;\t\u0013\u0005\r\u0013B!E!\u0002\u0013)\bBCA#\u0013\tU\r\u0011\"\u0001\u0002H!Q\u0011qJ\u0005\u0003\u0012\u0003\u0006I!!\u0013\t\u0013\u0005E\u0013B!f\u0001\n\u0003!\b\"CA*\u0013\tE\t\u0015!\u0003v\u0011%\t)&\u0003BK\u0002\u0013\u0005A\u000fC\u0005\u0002X%\u0011\t\u0012)A\u0005k\"1a-\u0003C\u0001\u00033B\u0011\"a\u001a\n\u0005\u0004%\t!a\u0012\t\u0011\u0005%\u0014\u0002)A\u0005\u0003\u0013B\u0011\"a\u001b\n\u0003\u0003%\t!!\u001c\t\u0013\u0005m\u0014\"%A\u0005\u0002\u0005u\u0004\"CAJ\u0013E\u0005I\u0011AAK\u0011%\tI*CI\u0001\n\u0003\t)\nC\u0005\u0002\u001c&\t\n\u0011\"\u0001\u0002\u001e\"I\u0011\u0011U\u0005\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003GK\u0011\u0013!C\u0001\u0003+C\u0001\"!*\n\u0003\u0003%\t%\u001b\u0005\t\u0003OK\u0011\u0011!C\u0001i\"I\u0011\u0011V\u0005\u0002\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003oK\u0011\u0011!C!\u0003sC\u0011\"a2\n\u0003\u0003%\t!!3\t\u0013\u0005M\u0017\"!A\u0005B\u0005U\u0007\"CAl\u0013\u0005\u0005I\u0011IAm\u0011%\tY.CA\u0001\n\u0003\ninB\u0005\u0003&\u0005\t\t\u0011#\u0001\u0003(\u0019I\u0011qE\u0001\u0002\u0002#\u0005!\u0011\u0006\u0005\u0007M&\"\tAa\u000e\t\u0013\u0005]\u0017&!A\u0005F\u0005e\u0007\"\u0003B\u001dS\u0005\u0005I\u0011\u0011B\u001e\u0011%\u0011I%KA\u0001\n\u0003\u0013Y\u0005C\u0005\u0003^%\n\t\u0011\"\u0003\u0003`\u00191!qM\u0001\u0001\u0005SBaAZ\u0018\u0005\u0002\t\r\u0005\u0002\u0003BD_\t\u0007I\u0011A5\t\u000f\t%u\u0006)A\u0005U\"A!1R\u0018A\u0002\u0013\u0005\u0011\u000eC\u0005\u0003\u000e>\u0002\r\u0011\"\u0001\u0003\u0010\"9!1S\u0018!B\u0013Q\u0007\u0002\u0003BK_\t\u0007I\u0011\u0001;\t\u000f\t]u\u0006)A\u0005k\"I!\u0011T\u0018A\u0002\u0013\u0005!1\u0014\u0005\n\u0005_{\u0003\u0019!C\u0001\u0005cC\u0001B!.0A\u0003&!Q\u0014\u0005\n\u0005o{#\u0019!C\u0001\u0005sC\u0001Ba40A\u0003%!1\u0018\u0005\n\u0005#|#\u0019!C\u0001\u0005sC\u0001Ba50A\u0003%!1\u0018\u0005\b\u0005+|C\u0011\u0001Bl\u0011\u001d\u0011yn\fC!\u0005'Aq!a\u00070\t\u0003\u0011\t\u000fC\u0004\u0003j>\"\tAa;\t\u000f\t=x\u0006\"\u0001\u0003r\"91\u0011D\u0018\u0005\u0002\tM\u0001bBB\u000e_\u0011\u00051Q\u0004\u0005\b\u0007SyC\u0011AB\u0016\u0011\u001d\u0019\te\fC\u0001\u0007\u0007Bqaa\u00130\t\u0003\u0019i\u0005C\u0004\u0004d=\"\ta!\u001a\t\u000f\r%t\u0006\"\u0001\u0004l!911P\u0018\u0005\u0002\tM\u0001bBB?_\u0011%1q\u0010\u0005\b\u0007\u001f{C\u0011ABI\r\u0019\t9/\u0001\u0001\u0002j\"1aM\u0014C\u0001\u0003WD\u0011\"!<O\u0005\u0004%I!a<\t\u0011\u0005uh\n)A\u0005\u0003cDq!a@O\t\u0003\u0011\t\u0001C\u0004\u0003\u00069#\tAa\u0002\t\u000f\tEa\n\"\u0001\u0003\u0014!9!Q\u0003(\u0005\u0002\tM\u0001b\u0002B\f\u001d\u0012\u0005!\u0011\u0004\u0005\b\u0005\u0017qE\u0011\u0001B\u0010\u0003a\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018m\u001d+fgR\u0014\u0016n\u001a\u0006\u00025\u0006)1.\u00194lC\u000e\u0001\u0001CA/\u0002\u001b\u0005I&\u0001\u0007*fa2L7-\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e*jON\u0011\u0011\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a\u0016a\u00013jeV\t!\u000e\u0005\u0002la6\tAN\u0003\u0002n]\u0006!A.\u00198h\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d7\u0003\rM#(/\u001b8h\u0003\u0011!\u0017N\u001d\u0011\u0002\u0003-,\u0012!\u001e\t\u0003CZL!a\u001e2\u0003\u0007%sG/\u0001\u0002lA\u0005!Q.Y5o)\tYh\u0010\u0005\u0002by&\u0011QP\u0019\u0002\u0005+:LG\u000f\u0003\u0004\u0000\u000f\u0001\u0007\u0011\u0011A\u0001\u0005CJ<7\u000fE\u0003b\u0003\u0007\t9!C\u0002\u0002\u0006\t\u0014Q!\u0011:sCf\u0004B!!\u0003\u0002\u00189!\u00111BA\n!\r\tiAY\u0007\u0003\u0003\u001fQ1!!\u0005\\\u0003\u0019a$o\\8u}%\u0019\u0011Q\u00032\u0002\rA\u0013X\rZ3g\u0013\r\t\u0018\u0011\u0004\u0006\u0004\u0003+\u0011\u0017a\u0001:v]R910a\b\u0002b\n\u0005\u0002bBA\u0011\u0011\u0001\u0007\u00111E\u0001\u0007G>tg-[4\u0011\u0007\u0005\u0015\u0012\"D\u0001\u0002\u00055)\u0005\u0010]3sS6,g\u000e\u001e#fMN1\u0011\u0002YA\u0016\u0003c\u00012!YA\u0017\u0013\r\tyC\u0019\u0002\b!J|G-^2u!\r\t\u00171G\u0005\u0004\u0003k\u0011'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00028b[\u0016,\"!a\u0002\u0002\u000b9\fW.\u001a\u0011\u0002\u000f\t\u0014xn[3sg\u0006A!M]8lKJ\u001c\b%\u0001\u0006qCJ$\u0018\u000e^5p]N\f1\u0002]1si&$\u0018n\u001c8tA\u0005AA\u000f\u001b:piRdW-\u0006\u0002\u0002JA\u0019\u0011-a\u0013\n\u0007\u00055#M\u0001\u0003M_:<\u0017!\u0003;ie>$H\u000f\\3!\u0003Ai7oZ:QKJ\u0004\u0016M\u001d;ji&|g.A\tng\u001e\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\u0002\nq!\\:h'&TX-\u0001\u0005ng\u001e\u001c\u0016N_3!)9\t\u0019#a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003KBq!a\u000e\u0017\u0001\u0004\t9\u0001\u0003\u0004\u0002>Y\u0001\r!\u001e\u0005\u0007\u0003\u00032\u0002\u0019A;\t\u000f\u0005\u0015c\u00031\u0001\u0002J!1\u0011\u0011\u000b\fA\u0002UDa!!\u0016\u0017\u0001\u0004)\u0018A\u0006;be\u001e,GOQ=uKN\u0004VM\u001d\"s_.,'/\u0014\"\u0002/Q\f'oZ3u\u0005f$Xm\u001d)fe\n\u0013xn[3s\u001b\n\u0003\u0013\u0001B2paf$b\"a\t\u0002p\u0005E\u00141OA;\u0003o\nI\bC\u0005\u00028e\u0001\n\u00111\u0001\u0002\b!A\u0011QH\r\u0011\u0002\u0003\u0007Q\u000f\u0003\u0005\u0002Be\u0001\n\u00111\u0001v\u0011%\t)%\u0007I\u0001\u0002\u0004\tI\u0005\u0003\u0005\u0002Re\u0001\n\u00111\u0001v\u0011!\t)&\u0007I\u0001\u0002\u0004)\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u007fRC!a\u0002\u0002\u0002.\u0012\u00111\u0011\t\u0005\u0003\u000b\u000by)\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003%)hn\u00195fG.,GMC\u0002\u0002\u000e\n\f!\"\u00198o_R\fG/[8o\u0013\u0011\t\t*a\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]%fA;\u0002\u0002\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003?SC!!\u0013\u0002\u0002\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QVAZ!\r\t\u0017qV\u0005\u0004\u0003c\u0013'aA!os\"A\u0011Q\u0017\u0012\u0002\u0002\u0003\u0007Q/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003w\u0003b!!0\u0002D\u00065VBAA`\u0015\r\t\tMY\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAc\u0003\u007f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111ZAi!\r\t\u0017QZ\u0005\u0004\u0003\u001f\u0014'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003k#\u0013\u0011!a\u0001\u0003[\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002k\u0006AAo\\*ue&tw\rF\u0001k\u0003\u0019)\u0017/^1mgR!\u00111ZAp\u0011%\t)lJA\u0001\u0002\u0004\ti\u000bC\u0004\u0002d\"\u0001\r!!:\u0002\u000f)|WO\u001d8bYB\u0019\u0011Q\u0005(\u0003\u000f){WO\u001d8bYN\u0011a\n\u0019\u000b\u0003\u0003K\f1\u0001\\8h+\t\t\t\u0010\u0005\u0003\u0002t\u0006eXBAA{\u0015\r\t9P\\\u0001\u0003S>LA!a?\u0002v\n!a)\u001b7f\u0003\u0011awn\u001a\u0011\u0002\u001f\u0005\u0004\b/\u001a8e)>Tu.\u001e:oC2$2a\u001fB\u0002\u0011\u001d\t\tC\u0015a\u0001\u0003G\t1\"\u00199qK:$7\t[1siR)1P!\u0003\u0003\u000e!9!1B*A\u0002\u0005\u001d\u0011\u0001\u00029bi\"DqAa\u0004T\u0001\u0004\tY-A\u0003gSJ\u001cH/\u0001\u0004iK\u0006$WM\u001d\u000b\u0002w\u00061am\\8uKJ\fa!\u00199qK:$GcA>\u0003\u001c!9!Q\u0004,A\u0002\u0005\u001d\u0011aB7fgN\fw-\u001a\u000b\u0003\u0003\u000fAqAa\t\t\u0001\u0004\tY-A\u000beSN\u0004H.Y=DQ\u0006\u0014Ho](o'\u000e\u0014X-\u001a8\u0002\u001b\u0015C\b/\u001a:j[\u0016tG\u000fR3g!\r\t)#K\n\u0006S\t-\u0012\u0011\u0007\t\u000f\u0005[\u0011\u0019$a\u0002vk\u0006%S/^A\u0012\u001b\t\u0011yCC\u0002\u00032\t\fqA];oi&lW-\u0003\u0003\u00036\t=\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8omQ\u0011!qE\u0001\u0006CB\u0004H.\u001f\u000b\u000f\u0003G\u0011iDa\u0010\u0003B\t\r#Q\tB$\u0011\u001d\t9\u0004\fa\u0001\u0003\u000fAa!!\u0010-\u0001\u0004)\bBBA!Y\u0001\u0007Q\u000fC\u0004\u0002F1\u0002\r!!\u0013\t\r\u0005EC\u00061\u0001v\u0011\u0019\t)\u0006\fa\u0001k\u00069QO\\1qa2LH\u0003\u0002B'\u00053\u0002R!\u0019B(\u0005'J1A!\u0015c\u0005\u0019y\u0005\u000f^5p]BY\u0011M!\u0016\u0002\bU,\u0018\u0011J;v\u0013\r\u00119F\u0019\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\tmS&!AA\u0002\u0005\r\u0012a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0007E\u0002l\u0005GJ1A!\u001am\u0005\u0019y%M[3di\nQQ\t\u001f9fe&lWM\u001c;\u0014\u000b=\u0012YGa\u001e\u0011\t\t5$1O\u0007\u0003\u0005_R1A!\u001dZ\u0003\tQ8.\u0003\u0003\u0003v\t=$\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0003\u0003z\t}TB\u0001B>\u0015\r\u0011i(W\u0001\u0006kRLGn]\u0005\u0005\u0005\u0003\u0013YHA\u0004M_\u001e<\u0017N\\4\u0015\u0005\t\u0015\u0005cAA\u0013_\u0005IAo\u001c9jG:\u000bW.Z\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u0004\u0013AD3ya\u0016\u0014\u0018.\\3oi:\u000bW.Z\u0001\u0013Kb\u0004XM]5nK:$h*Y7f?\u0012*\u0017\u000fF\u0002|\u0005#C\u0001\"!.5\u0003\u0003\u0005\rA[\u0001\u0010Kb\u0004XM]5nK:$h*Y7fA\u0005Y\u0001/\u0019:uSRLwN\\%e\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0003\u001d\u0019XM\u001d<feN,\"A!(\u0011\r\u0005u&q\u0014BR\u0013\u0011\u0011\t+a0\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003&\n-VB\u0001BT\u0015\r\u0011I+W\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t5&q\u0015\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHcA>\u00034\"I\u0011QW\u001d\u0002\u0002\u0003\u0007!QT\u0001\tg\u0016\u0014h/\u001a:tA\u0005YA.Z1eKJ\u0014\u0016\r^3t+\t\u0011Y\fE\u0004\u0003>\n\rWOa2\u000e\u0005\t}&\u0002\u0002Ba\u0003\u007f\u000bq!\\;uC\ndW-\u0003\u0003\u0003F\n}&aA'baB)\u0011-a\u0001\u0003JB\u0019\u0011Ma3\n\u0007\t5'M\u0001\u0004E_V\u0014G.Z\u0001\rY\u0016\fG-\u001a:SCR,7\u000fI\u0001\u000eM>dGn\\<feJ\u000bG/Z:\u0002\u001d\u0019|G\u000e\\8xKJ\u0014\u0016\r^3tA\u0005a1\u000f^1si\n\u0013xn[3sgR\u00191P!7\t\u000f\tmw\b1\u0001\u0003^\u0006I!M]8lKJLEm\u001d\t\u0006\u0003{\u0013y*^\u0001\ti\u0016\f'\u000fR8x]R91Pa9\u0003f\n\u001d\bbBA\u0011\u0003\u0002\u0007\u00111\u0005\u0005\b\u0003G\f\u0005\u0019AAs\u0011\u001d\u0011\u0019#\u0011a\u0001\u0003\u0017\fqC^1mS\u0012\fG/Z!mY>3gm]3ug6\u000bGo\u00195\u0015\u0007m\u0014i\u000fC\u0004\u0002\"\t\u0003\r!a\t\u0002\u00131|wmT;uaV$HcB>\u0003t\nU(Q \u0005\b\u0003C\u0019\u0005\u0019AA\u0012\u0011\u001d\u00119p\u0011a\u0001\u0005s\f\u0001B]3qY&\u001c\u0017m\u001d\t\b\u0003{\u0013Y0\u001eBo\u0013\u0011\u0011)-a0\t\u000f\t}8\t1\u0001\u0004\u0002\u0005ia.Z<BgNLwM\\7f]R\u0004\u0002\"!0\u0003|\u000e\r!Q\u001c\t\u0005\u0007\u000b\u0019)\"\u0004\u0002\u0004\b)!1\u0011BB\u0006\u0003\u0019\u0019w.\\7p]*\u0019!l!\u0004\u000b\t\r=1\u0011C\u0001\u0007CB\f7\r[3\u000b\u0005\rM\u0011aA8sO&!1qCB\u0004\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQd^1ji\u001a{'OU3bgNLwM\\7f]R$vnQ8na2,G/Z\u0001\fe\u0016tG-\u001a:DQ\u0006\u0014H\u000fF\u0005|\u0007?\u0019\u0019c!\n\u0004(!91\u0011E#A\u0002\tm\u0016\u0001\u00023bi\u0006Dq!a\u000eF\u0001\u0004\t9\u0001C\u0004\u0002d\u0016\u0003\r!!:\t\u000f\t\rR\t1\u0001\u0002L\u0006!R.Y=cK\u0012K7\u000f\u001d7bs>s7k\u0019:fK:$Ra_B\u0017\u0007_AqAa\tG\u0001\u0004\tY\rC\u0004\u00042\u0019\u0003\raa\r\u0002\u000b\rD\u0017M\u001d;\u0011\t\rU2QH\u0007\u0003\u0007oQAa!\r\u0004:)!11HB\t\u0003\u0015QgM]3f\u0013\u0011\u0019yda\u000e\u0003\u0015)3%/Z3DQ\u0006\u0014H/A\u0006xe&$X\rV8GS2,GcB>\u0004F\r\u001d3\u0011\n\u0005\b\u0003o9\u0005\u0019AA\u0004\u0011\u001d\t\u0019o\u0012a\u0001\u0003KDqa!\rH\u0001\u0004\u0019\u0019$A\u0006de\u0016\fG/Z\"iCJ$HCBB\u001a\u0007\u001f\u001a\t\u0006C\u0004\u00028!\u0003\r!a\u0002\t\u000f\rM\u0003\n1\u0001\u0004V\u00059A-\u0019;bg\u0016$\b\u0003BB,\u0007?j!a!\u0017\u000b\t\rm3QL\u0001\u0003qfTAa!\t\u0004:%!1\u0011MB-\u0005IA\u0016lU3sS\u0016\u001c8i\u001c7mK\u000e$\u0018n\u001c8\u0002\u001d\u0005$G\rR1uCR{7\t[1siR!1QKB4\u0011\u001d\u0019\t#\u0013a\u0001\u0005w\u000baA]3d_J$G\u0003CB7\u0007_\u001a\u0019ha\u001e\u0011\u000b\u0005\u0014yEa2\t\u000f\rE$\n1\u0001\u0003<\u0006)!/\u0019;fg\"11Q\u000f&A\u0002U\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0007sR\u0005\u0019\u0001Be\u0003-\u0019WO\u001d:f]R\u0014\u0016\r^3\u0002!A\u0014\u0018N\u001c;SCR,W*\u001a;sS\u000e\u001c\u0018\u0001D7fCN,(/\u001a3SCR,GC\u0002Be\u0007\u0003\u001b)\tC\u0004\u0004\u00042\u0003\rAa)\u0002\r\t\u0014xn[3s\u0011\u001d\u00199\t\u0014a\u0001\u0007\u0013\u000bqA]3q)f\u0004X\r\u0005\u0003\u0003&\u000e-\u0015\u0002BBG\u0005O\u0013\u0011\"U;pi\u0006$\u0016\u0010]3\u0002\t)\u001cxN\u001c\u000b\u0005\u0003\u000f\u0019\u0019\nC\u0004\u0004\u00166\u0003\raa&\u0002\u000bQ|\u0007/[2\u0011\u000b\u0005\u001cI*a\u0002\n\u0007\rm%M\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002")
public final class ReplicationQuotasTestRig {
    public static void run(ExperimentDef experimentDef, Journal journal, boolean bl) {
        ReplicationQuotasTestRig$.MODULE$.run(experimentDef, journal, bl);
    }

    public static void main(String[] stringArray) {
        ReplicationQuotasTestRig$.MODULE$.main(stringArray);
    }

    public static int k() {
        return ReplicationQuotasTestRig$.MODULE$.k();
    }

    public static class Experiment
    extends ZooKeeperTestHarness {
        private final String topicName;
        private String experimentName = "unset";
        private final int partitionId;
        private Seq<KafkaServer> servers = null;
        private final scala.collection.mutable.Map<Object, double[]> leaderRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<Object, double[]> followerRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public String topicName() {
            return this.topicName;
        }

        public String experimentName() {
            return this.experimentName;
        }

        public void experimentName_$eq(String x$1) {
            this.experimentName = x$1;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public Seq<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(Seq<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public scala.collection.mutable.Map<Object, double[]> leaderRates() {
            return this.leaderRates;
        }

        public scala.collection.mutable.Map<Object, double[]> followerRates() {
            return this.followerRates;
        }

        public void startBrokers(Seq<Object> brokerIds) {
            Predef$.MODULE$.println((Object)"Starting Brokers");
            this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        }

        @Override
        public void tearDown() {
            TestUtils$.MODULE$.shutdownServers(this.servers());
            super.tearDown();
        }

        /*
         * WARNING - void declaration
         */
        public void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
            void map_bf;
            void map_f;
            this.experimentName_$eq(config.name());
            int n = 100;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive brokers = RichInt$.MODULE$.to$extension0(n, 100 + config.brokers());
            IntRef count = IntRef.create((int)0);
            int shift = Math.round(config.brokers() / 2);
            int n2 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n2, config.partitions());
            CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)partition -> Experiment.$anonfun$run$1(count, shift, config, BoxesRunTime.unboxToInt((Object)partition));
            if (inclusive == null) {
                throw null;
            }
            scala.collection.immutable.Map replicas = ((TraversableOnce)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf)).toMap(Predef$.MODULE$.$conforms());
            this.startBrokers((Seq<Object>)brokers);
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)replicas, this.servers());
            Predef$.MODULE$.println((Object)"Writing Data");
            KafkaProducer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 0, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());
            int n3 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n3, config.msgsPerPartition());
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    Experiment.$anonfun$run$2(this, config, producer, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Predef$.MODULE$.println((Object)"Starting Reassignment");
            Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)brokers, this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
            long start = System.currentTimeMillis();
            ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, new String(ReassignPartitionsZNode$.MODULE$.encode(newAssignment), StandardCharsets.UTF_8), new ReassignPartitionsCommand.Throttle(config.throttle(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
            this.waitForReassignmentToComplete();
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(19).append("Reassignment took ").append((System.currentTimeMillis() - start) / 1000L).append("s").toString());
            this.validateAllOffsetsMatch(config);
            journal.appendToJournal(config);
            this.renderChart(this.leaderRates(), "Leader", journal, displayChartsOnScreen);
            this.renderChart(this.followerRates(), "Follower", journal, displayChartsOnScreen);
            this.logOutput(config, (Map<Object, Seq<Object>>)replicas, (Map<TopicPartition, Seq<Object>>)newAssignment);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(26).append("Output can be found here: ").append(journal.path()).toString());
        }

        public void validateAllOffsetsMatch(ExperimentDef config) {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$validateAllOffsetsMatch$1(this, config, broker);
                return BoxedUnit.UNIT;
            });
        }

        public void logOutput(ExperimentDef config, Map<Object, Seq<Object>> replicas, Map<TopicPartition, Seq<Object>> newAssignment) {
            Map actual = (Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(17).append("The replicas are ").append(((TraversableLike)replicas.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> new java.lang.StringBuilder(1).append("\n").append(x$4).toString(), Seq$.MODULE$.canBuildFrom())).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(40).append("This is the current replica assignment:\n").append(actual.mapValues((Function1 & Serializable & scala.Serializable)x$5 -> x$5.replicas()).toMap(Predef$.MODULE$.$conforms()).toSeq()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("proposed assignment is: \n").append(newAssignment).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(39).append("This is the assignment we ended up with").append(actual.mapValues((Function1 & Serializable & scala.Serializable)x$6 -> x$6.replicas()).toMap(Predef$.MODULE$.$conforms())).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(12).append("numBrokers: ").append(config.brokers()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(15).append("numPartitions: ").append(config.partitions()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(10).append("throttle: ").append(config.throttle()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("numMessagesPerPartition: ").append(config.msgsPerPartition()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(9).append("msgSize: ").append(config.msgSize()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(35).append("We will write ").append(config.targetBytesPerBrokerMB()).append("MB of data per broker").toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(23).append("Worst case duration is ").append(config.targetBytesPerBrokerMB() * 1000L * 1000L / config.throttle()).toString());
        }

        /*
         * WARNING - void declaration
         */
        public void waitForReassignmentToComplete() {
            long l = 1000L;
            long l2 = 3600000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!Experiment.$anonfun$waitForReassignmentToComplete$1(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(Experiment.$anonfun$waitForReassignmentToComplete$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }

        public void renderChart(scala.collection.mutable.Map<Object, double[]> data, String name, Journal journal, boolean displayChartsOnScreen) {
            XYSeriesCollection dataset = this.addDataToChart(data);
            JFreeChart chart = this.createChart(name, dataset);
            this.writeToFile(name, journal, chart);
            this.maybeDisplayOnScreen(displayChartsOnScreen, chart);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(20).append("Chart generated for ").append(name).toString());
        }

        public void maybeDisplayOnScreen(boolean displayChartsOnScreen, JFreeChart chart) {
            if (displayChartsOnScreen) {
                ChartFrame frame = new ChartFrame(this.experimentName(), chart);
                frame.pack();
                frame.setVisible(true);
            }
        }

        public void writeToFile(String name, Journal journal, JFreeChart chart) {
            File file = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), new java.lang.StringBuilder(5).append(this.experimentName()).append("-").append(name).append(".png").toString());
            ImageIO.write((RenderedImage)chart.createBufferedImage(1000, 700), "png", file);
            journal.appendChart(file.getAbsolutePath(), name == "Leader");
        }

        public JFreeChart createChart(String name, XYSeriesCollection dataset) {
            return ChartFactory.createXYLineChart((String)new java.lang.StringBuilder(26).append(this.experimentName()).append(" - ").append(name).append(" Throttling Performance").toString(), (String)"Time (s)", (String)"Throttle Throughput (B/s)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        }

        /*
         * WARNING - void declaration
         */
        public XYSeriesCollection addDataToChart(scala.collection.mutable.Map<Object, double[]> data) {
            void var2_2;
            XYSeriesCollection dataset = new XYSeriesCollection();
            data.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Experiment.$anonfun$addDataToChart$1(dataset, x0$1);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }

        public Option<double[]> record(scala.collection.mutable.Map<Object, double[]> rates, int brokerId, double currentRate) {
            double[] leaderRatesBroker = (double[])rates.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
            leaderRatesBroker = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(leaderRatesBroker)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{currentRate})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            return rates.put((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)leaderRatesBroker);
        }

        public void printRateMetrics() {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$printRateMetrics$1(this, broker);
                return BoxedUnit.UNIT;
            });
        }

        private double measuredRate(KafkaServer broker, QuotaType repType) {
            MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
            if (((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).contains((Object)metricName)) {
                return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue());
            }
            return -1.0;
        }

        public String json(Seq<String> topic) {
            String topicStr = ((TraversableOnce)topic.map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(13).append("{\"topic\": \"").append((String)t).append("\"}").toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            return new java.lang.StringBuilder(26).append("{\"topics\": [").append(topicStr).append("],\"version\":1}").toString();
        }

        private static final int nextReplicaRoundRobin$1(IntRef count$1, int shift$1, ExperimentDef config$1) {
            ++count$1.elem;
            return 100 + (count$1.elem + shift$1) % config$1.brokers();
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Tuple2 $anonfun$run$1(IntRef count$1, int shift$1, ExperimentDef config$1, int partition) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Experiment.nextReplicaRoundRobin$1(count$1, shift$1, config$1)}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }

        public static final /* synthetic */ void $anonfun$run$2(Experiment $this, ExperimentDef config$1, KafkaProducer producer$1, int x) {
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, config$1.partitions());
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    producer$1.send(new ProducerRecord($this.topicName(), Predef$.MODULE$.int2Integer(foreach_i), null, (Object)new byte[config$1.msgSize()]));
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
        }

        public static final /* synthetic */ long $anonfun$validateAllOffsetsMatch$4() {
            return -1L;
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$2(Experiment $this, KafkaServer broker$1, ExperimentDef config$2, int partitionId) {
            LogManager qual$1 = broker$1.getLogManager();
            TopicPartition x$1 = new TopicPartition($this.topicName(), partitionId);
            boolean x$2 = qual$1.getLog$default$2();
            Option option = qual$1.getLog(x$1, x$2);
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((Log)map_this.get()).logEndOffset()));
            if (object == null) {
                throw null;
            }
            Object object2 = object.isEmpty() ? BoxesRunTime.boxToLong((long)Experiment.$anonfun$validateAllOffsetsMatch$4()) : object.get();
            long offset = BoxesRunTime.unboxToLong((Object)object2);
            if (offset >= 0L && offset != (long)config$2.msgsPerPartition()) {
                throw new RuntimeException(new java.lang.StringBuilder(82).append("Run failed as offsets did not match for partition ").append(partitionId).append(" on broker ").append(broker$1.config().brokerId()).append(". Expected ").append(config$2.msgsPerPartition()).append(" but was ").append(offset).append(".").toString());
            }
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$1(Experiment $this, ExperimentDef config$2, KafkaServer broker) {
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, config$2.partitions());
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    Experiment.$anonfun$validateAllOffsetsMatch$2($this, broker, config$2, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
        }

        public static final /* synthetic */ boolean $anonfun$waitForReassignmentToComplete$1(Experiment $this) {
            $this.printRateMetrics();
            return !$this.zkClient().reassignPartitionsInProgress();
        }

        public static final /* synthetic */ String $anonfun$waitForReassignmentToComplete$2() {
            return new java.lang.StringBuilder(21).append("Znode ").append(ReassignPartitionsZNode$.MODULE$.path()).append(" wasn't deleted").toString();
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$2(XYSeries series$1, IntRef x$7, double value) {
            series$1.add((double)x$7.elem, value);
            ++x$7.elem;
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$1(XYSeriesCollection dataset$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                int broker = x0$1._1$mcI$sp();
                double[] values = (double[])x0$1._2();
                XYSeries series = new XYSeries((Comparable)((Object)new java.lang.StringBuilder(7).append("Broker:").append(broker).toString()));
                IntRef x = IntRef.create((int)0);
                ArrayOps.ofDouble foreach_this = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values));
                int foreach_len = foreach_this.length();
                for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                    double d = BoxesRunTime.unboxToDouble((Object)foreach_this.apply(foreach_i));
                    Experiment.$anonfun$addDataToChart$2(series, x, d);
                }
                dataset$1.addSeries(series);
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printRateMetrics$1(Experiment $this, KafkaServer broker) {
            double leaderRate = $this.measuredRate(broker, (QuotaType)QuotaType.LeaderReplication$.MODULE$);
            if (broker.config().brokerId() == 100) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("waiting... Leader rate on 101 is ").append(leaderRate).toString());
            }
            $this.record($this.leaderRates(), broker.config().brokerId(), leaderRate);
            if (leaderRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Leader Rate on ").append(broker.config().brokerId()).append(" is ").append(leaderRate).toString());
            }
            double followerRate = $this.measuredRate(broker, (QuotaType)QuotaType.FollowerReplication$.MODULE$);
            $this.record($this.followerRates(), broker.config().brokerId(), followerRate);
            if (followerRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("Follower Rate on ").append(broker.config().brokerId()).append(" is ").append(followerRate).toString());
            }
        }

        public Experiment() {
            this.topicName = "my-topic";
            this.partitionId = 0;
        }

        public static final /* synthetic */ Future $anonfun$run$3$adapted(Experiment $this, KafkaProducer producer$1, ExperimentDef config$1, Object partition) {
            return producer$1.send(new ProducerRecord($this.topicName(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)partition)), null, (Object)new byte[config$1.msgSize()]));
        }

        public static final /* synthetic */ Object $anonfun$validateAllOffsetsMatch$3$adapted(Log x$2) {
            return BoxesRunTime.boxToLong((long)x$2.logEndOffset());
        }
    }

    public static class ExperimentDef
    implements Product,
    scala.Serializable {
        private final String name;
        private final int brokers;
        private final int partitions;
        private final long throttle;
        private final int msgsPerPartition;
        private final int msgSize;
        private final long targetBytesPerBrokerMB;

        public String name() {
            return this.name;
        }

        public int brokers() {
            return this.brokers;
        }

        public int partitions() {
            return this.partitions;
        }

        public long throttle() {
            return this.throttle;
        }

        public int msgsPerPartition() {
            return this.msgsPerPartition;
        }

        public int msgSize() {
            return this.msgSize;
        }

        public long targetBytesPerBrokerMB() {
            return this.targetBytesPerBrokerMB;
        }

        public ExperimentDef copy(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            return new ExperimentDef(name, brokers, partitions, throttle, msgsPerPartition, msgSize);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.brokers();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public long copy$default$4() {
            return this.throttle();
        }

        public int copy$default$5() {
            return this.msgsPerPartition();
        }

        public int copy$default$6() {
            return this.msgSize();
        }

        public String productPrefix() {
            return "ExperimentDef";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokers());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this.partitions());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.throttle());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.msgsPerPartition());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this.msgSize());
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExperimentDef;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.name())), (int)this.brokers()), (int)this.partitions()), (int)Statics.longHash((long)this.throttle())), (int)this.msgsPerPartition()), (int)this.msgSize()), (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ExperimentDef)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExperimentDef experimentDef = (ExperimentDef)x$1;
            String string = this.name();
            String string2 = experimentDef.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.brokers() != experimentDef.brokers()) return false;
            if (this.partitions() != experimentDef.partitions()) return false;
            if (this.throttle() != experimentDef.throttle()) return false;
            if (this.msgsPerPartition() != experimentDef.msgsPerPartition()) return false;
            if (this.msgSize() != experimentDef.msgSize()) return false;
            if (!experimentDef.canEqual(this)) return false;
            return true;
        }

        public ExperimentDef(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            this.name = name;
            this.brokers = brokers;
            this.partitions = partitions;
            this.throttle = throttle;
            this.msgsPerPartition = msgsPerPartition;
            this.msgSize = msgSize;
            Product.$init$((Product)this);
            this.targetBytesPerBrokerMB = (long)msgsPerPartition * (long)msgSize * (long)partitions / (long)brokers / 1000000L;
        }
    }

    public static class Journal {
        private final File log = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), "Log.html");

        private File log() {
            return this.log;
        }

        public void appendToJournal(ExperimentDef config) {
            double arg$macro$1 = config.throttle();
            double arg$macro$2 = config.msgsPerPartition();
            double arg$macro$3 = config.msgSize();
            String message = new java.lang.StringBuilder(82).append("\n\n<h3>").append(config.name()).append("</h3>").append("<p>- BrokerCount: ").append(config.brokers()).append("<p>- PartitionCount: ").append(config.partitions()).append(new StringOps("<p>- Throttle: %,.0f MB/s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}))).append(new StringOps("<p>- MsgCount: %,.0f ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$2)}))).append(new StringOps("<p>- MsgSize: %,.0f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}))).append("<p>- TargetBytesPerBrokerMB: ").append(config.targetBytesPerBrokerMB()).append("<p>").toString();
            this.append(message);
        }

        public void appendChart(String path, boolean first) {
            StringBuilder message = new StringBuilder();
            if (first) {
                message.append("<p><p>");
            }
            message.append(new java.lang.StringBuilder(72).append("<img src=\"").append(path).append("\" alt=\"Chart\" style=\"width:600px;height:400px;align=\"middle\"\">").toString());
            if (!first) {
                message.append("<p><p>");
            }
            this.append(message.toString());
        }

        public void header() {
            this.append("<html><head><h1>Replication Quotas Test Rig</h1></head><body>");
        }

        public void footer() {
            this.append("</body></html>");
        }

        public void append(String message) {
            OutputStream stream = Files.newOutputStream(this.log().toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            new PrintWriter(null, stream, message){
                {
                    this.append(message$1);
                    this.close();
                }
            };
        }

        public String path() {
            return this.log().getAbsolutePath();
        }

        public Journal() {
            this.header();
        }
    }
}

