/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.server.ReplicaManagerTest$$anon$2$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0011ub\u0001B)S\u0001]CQA\u0018\u0001\u0005\u0002}CqA\u0019\u0001C\u0002\u0013\u00051\r\u0003\u0004m\u0001\u0001\u0006I\u0001\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u0019)\b\u0001)A\u0005_\"9a\u000f\u0001b\u0001\n\u00039\bbBA\u0005\u0001\u0001\u0006I\u0001\u001f\u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0001C\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\u0002\u0005u\u0001bCA\u0015\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001fA\u0011\"a\u000b\u0001\u0005\u0004%\t!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%\t!!\f\t\u0011\u0005e\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000f\u0001\u0001\u0004%\t!!\f\t\u0013\u0005u\u0002\u00011A\u0005\u0002\u0005}\u0002\u0002CA\"\u0001\u0001\u0006K!a\f\t\u0013\u0005\u0015\u0003A1A\u0005\u0002\u0005\u001d\u0003\u0002CA(\u0001\u0001\u0006I!!\u0013\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u00111\r\u0001\u0005\u0002\u0005M\u0003bBA7\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003o\u0002A\u0011AA*\u0011\u001d\tY\b\u0001C\u0001\u0003'Bq!a \u0001\t\u0003\t\u0019\u0006C\u0004\u0002\u0004\u0002!\t!a\u0015\t\u0011\u0005\r\u0005\u0001)C\u0005\u0003\u000fCq!!$\u0001\t\u0003\t\u0019\u0006C\u0004\u0002\u0012\u0002!\t!a\u0015\t\u000f\u0005U\u0005\u0001\"\u0001\u0002T!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005M\u0003bBAO\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003C\u0003A\u0011AA*\u0011\u001d\t)\u000b\u0001C\u0001\u0003'Bq!!+\u0001\t\u0003\t\u0019\u0006C\u0004\u0002.\u0002!\t!a\u0015\t\u000f\u0005E\u0006\u0001\"\u0001\u0002T!9\u0011Q\u0017\u0001\u0005\u0002\u0005M\u0003bBAb\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003\u000f\u0004A\u0011AA*\u0011\u001d\tY\r\u0001C\u0001\u0003'Bq!a4\u0001\t\u0003\t\u0019\u0006C\u0004\u0002T\u0002!\t!a\u0015\t\u000f\u0005]\u0007\u0001\"\u0001\u0002T!9\u00111\u001c\u0001\u0005\u0002\u0005M\u0003bBAp\u0001\u0011%\u0011\u0011\u001d\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0011%\u00119\bAI\u0001\n\u0013\u0011I\bC\u0004\u0003\u0010\u0002!IA!%\t\u0013\tU\u0007!%A\u0005\n\t]\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0004\u0007\u0007'\u0001Aa!\u0006\t\ry#D\u0011AB\r\u0011%\u0019)\u0004\u000ea\u0001\n\u0013\u00199\u0004C\u0005\u0004<Q\u0002\r\u0011\"\u0003\u0004>!A1\u0011\t\u001b!B\u0013\u0019I\u0004C\u0005\u0004DQ\u0002\r\u0011\"\u0003\u0004F!I1q\n\u001bA\u0002\u0013%1\u0011\u000b\u0005\t\u0007+\"\u0004\u0015)\u0003\u0004H!91q\u000b\u001b\u0005\u0002\re\u0003bBB.i\u0011\u00051Q\f\u0005\b\u0007?\"D\u0011AB1\u0011\u001d\u0019)\u0007\u000eC\u0001\u0007OBqaa\u001b\u0001\t\u0013\u0019i\u0007C\u0005\u0004\u001c\u0002\t\n\u0011\"\u0003\u0004\u001e\"I1\u0011\u0015\u0001\u0012\u0002\u0013%11\u0015\u0005\b\u0007O\u0003A\u0011BBU\u0011%\u0019I\rAI\u0001\n\u0013\u0019Y\rC\u0005\u0004P\u0002\t\n\u0011\"\u0003\u0004R\"I1Q\u001b\u0001\u0012\u0002\u0013%1q\u001b\u0005\b\u00077\u0004A\u0011BBo\u0011%\u0019Y\u000fAI\u0001\n\u0013\u0019Y\rC\u0005\u0004n\u0002\t\n\u0011\"\u0003\u0004R\"I1q\u001e\u0001\u0012\u0002\u0013%1q\u001b\u0005\b\u0007c\u0004A\u0011BBz\u0011\u001d!)\u0001\u0001C\u0005\t\u000fA\u0011\u0002b\u0007\u0001#\u0003%I\u0001\"\b\t\u000f\u0011\u0005\u0002\u0001\"\u0001\u0002T!9AQ\u0005\u0001\u0005\u0002\u0005M\u0003b\u0002C\u0015\u0001\u0011%A1\u0006\u0002\u0013%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002T)\u000611/\u001a:wKJT\u0011!V\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\f\u0005\u0002Z96\t!LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0004\"!\u0019\u0001\u000e\u0003I\u000bQ\u0001^8qS\u000e,\u0012\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\fA\u0001\\1oO*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0001^5nKV\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s)\u0006)Q\u000f^5mg&\u0011A/\u001d\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#\u0001=\u0011\u0007e\f)!D\u0001{\u0015\t18P\u0003\u0002}{\u000611m\\7n_:T!!\u0016@\u000b\u0007}\f\t!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0007\t1a\u001c:h\u0013\r\t9A\u001f\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!D6bM.\f'l[\"mS\u0016tG/\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016Q\u000b!A_6\n\t\u0005e\u00111\u0003\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002#-\fgm[1[W\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005\u0015\u0002cA-\u0002\"%\u0019\u00111\u0005.\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003OI\u0011\u0011!a\u0001\u0003\u001f\t1\u0001\u001f\u00132\u00039Y\u0017MZ6b5.\u001cE.[3oi\u0002\n\u0011B_6WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005=\u0002cA-\u00022%\u0019\u00111\u0007.\u0003\u0007%sG/\u0001\u0006{WZ+'o]5p]\u0002\nQbY8se\u0016d\u0017\r^5p]&#\u0017AD2peJ,G.\u0019;j_:LE\rI\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\u0006\u00192m\u001c8ue>dG.\u001a:Fa>\u001c\u0007n\u0018\u0013fcR!\u0011qDA!\u0011%\t9\u0003EA\u0001\u0002\u0004\ty#\u0001\td_:$(o\u001c7mKJ,\u0005o\\2iA\u0005Y!M]8lKJ,\u0005o\\2i+\t\tI\u0005E\u0002Z\u0003\u0017J1!!\u0014[\u0005\u0011auN\\4\u0002\u0019\t\u0014xn[3s\u000bB|7\r\u001b\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005}\u0001f\u0001\u000b\u0002XA!\u0011\u0011LA0\u001b\t\tYF\u0003\u0003\u0002^\u0005\u0005\u0011!\u00026v]&$\u0018\u0002BA1\u00037\u0012aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007U\t9\u0007\u0005\u0003\u0002Z\u0005%\u0014\u0002BA6\u00037\u0012Q!\u00114uKJ\f\u0011\u0005^3ti\"Kw\r[,bi\u0016\u0014X*\u0019:l\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001eD3AFA9!\u0011\tI&a\u001d\n\t\u0005U\u00141\f\u0002\u0005)\u0016\u001cH/A\u0015uKN$\b*[4io\u0006$XM]'be.\u0014V\r\\1uSZ,G)\u001b:fGR|'/_'baBLgn\u001a\u0015\u0004/\u0005E\u0014a\u0006;fgRLE\u000e\\3hC2\u0014V-];je\u0016$\u0017iY6tQ\rA\u0012\u0011O\u0001%i\u0016\u001cHo\u00117fCJ\u0004VO]4bi>\u0014\u0018p\u00148CK\u000e|W.\u001b8h\r>dGn\\<fe\"\u001a\u0011$!\u001d\u0002GQ,7\u000f\u001e$f]\u000e,G-\u0012:s_J\u001c\u0015-^:fI\nK()Z2p[\u0016dU-\u00193fe\"\u001a!$!\u001d\u0015\t\u0005}\u0011\u0011\u0012\u0005\b\u0003\u0017[\u0002\u0019AA\u0018\u0003=awn\u001c9Fa>\u001c\u0007n\u00115b]\u001e,\u0017\u0001\u000f;fgR\u0014VmY3jm\u0016|U\u000f^(g\u001fJ$WM]*fcV,gnY3Fq\u000e,\u0007\u000f^5p]^KG\u000f\u001b'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0015\u00049\u0005E\u0014A\t;fgR\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u001a+Go\u00195MS6LG/\u001a3Bi2\u001bv\nK\u0002\u001e\u0003c\n1\u0006^3ti\u0012+G.Y=fI\u001a+Go\u00195J]\u000edW\u000fZ3t\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d\u0015\u0004=\u0005E\u0014a\f;fgR4U\r^2i\u0005\u0016LxN\u001c3IS\u001eDw+\u0019;fe6\f'o\u001b*fiV\u0014h.R7qif\u0014Vm\u001d9p]N,\u0007fA\u0010\u0002r\u0005IC/Z:u\r>dGn\\<feN#\u0018\r^3O_R,\u0006\u000fZ1uK\u0012Le\rT8h%\u0016\fGMR1jYND3\u0001IA9\u0003=\"Xm\u001d;GKR\u001c\u0007.T3tg\u0006<Wm],iK:tu\u000e\u001e$pY2|w/\u001a:G_J|e.\u001a)beRLG/[8oQ\r\t\u0013\u0011O\u0001=i\u0016\u001cHOQ3d_6,gi\u001c7m_^,'o\u00165f]2+\u0017\rZ3s\u0013N,fn\u00195b]\u001e,GMQ;u\u001b&\u001c8/\u001a3MK\u0006$WM]+qI\u0006$X\rK\u0002#\u0003c\n1\u0003^3tiJ+\u0007\u000f\\5dCN+G.Z2u_JD3aIA9\u0003y!Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0006\u001bhi\u001c7m_^,'\u000fK\u0002%\u0003c\nA\u0004^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0017i\u001d'fC\u0012,'\u000fK\u0002&\u0003c\n!\u0004^3tiVs7N\\8x]J+\u0007\u000f\\5dCN+G.Z2u_JDsAJA9\u0003s\u000bY,\u0001\u0005fqB,7\r^3eG\t\ti\fE\u0002f\u0003\u007fK1!!1g\u0005Y\u0019E.Y:t\u001d>$hi\\;oI\u0016C8-\u001a9uS>t\u0017A\u0007;fgR$UMZ1vYR\u0014V\r\u001d7jG\u0006\u001cV\r\\3di>\u0014\bfA\u0014\u0002r\u0005QC/Z:u\r\u0016$8\r\u001b$pY2|w/\u001a:O_R\fE\u000e\\8xK\u00124uN](mI\u0016\u00148\t\\5f]R\u001c\bf\u0001\u0015\u0002r\u0005\u0001D/Z:u\u0005\u0016\u001cw.\\3G_2dwn^3s/\"LG.Z(mI\u000ec\u0017.\u001a8u\r\u0016$8\r[%o!V\u0014x-\u0019;pefD3!KA9\u0003A\"Xm\u001d;CK\u000e|W.\u001a$pY2|w/\u001a:XQ&dWMT3x\u00072LWM\u001c;GKR\u001c\u0007.\u00138QkJ<\u0017\r^8ss\"\u001a!&!\u001d\u0002AQ,7\u000f\u001e$fi\u000eDgI]8n\u0019\u0016\fG-\u001a:BY^\f\u0017p]!mY><X\r\u001a\u0015\u0004W\u0005E\u0014\u0001\n;fgR\u001cE.Z1s\r\u0016$8\r\u001b)ve\u001e\fGo\u001c:z\u001f:\u001cFo\u001c9SKBd\u0017nY1)\u00071\n\t(\u0001\u0014uKN$8\t\\3beB\u0013x\u000eZ;dKB+(oZ1u_JLxJ\\*u_B\u0014V\r\u001d7jG\u0006D3!LA9\u0003I\u0019XM\u001c3Qe>$WoY3s\u0003B\u0004XM\u001c3\u0015\r\u0005\r(1\u0005B\u0017!\u0019\t)/a=\u0002x6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003[\fy/\u0001\u0006d_:\u001cWO\u001d:f]RT1!!=i\u0003\u0011)H/\u001b7\n\t\u0005U\u0018q\u001d\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB!\u0011\u0011 B\u000f\u001d\u0011\tYPa\u0006\u000f\t\u0005u(1\u0003\b\u0005\u0003\u007f\u0014\tB\u0004\u0003\u0003\u0002\t=a\u0002\u0002B\u0002\u0005\u001bqAA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0004\u0005\u00131\u0016A\u0002\u001fs_>$h(\u0003\u0002\u0002\u0004%\u0019q0!\u0001\n\u0005Us\u0018B\u0001?~\u0013\r\u0011)b_\u0001\te\u0016\fX/Z:ug&!!\u0011\u0004B\u000e\u0003=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,'b\u0001B\u000bw&!!q\u0004B\u0011\u0005E\u0001\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u00053\u0011Y\u0002C\u0004\u0003&9\u0002\rAa\n\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0019\u0011M!\u000b\n\u0007\t-\"K\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\t=b\u00061\u0001\u00032\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003\u0002B\u001a\u0005ki\u0011a_\u0005\u0004\u0005oY(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0012g\u0016tGmQ8ogVlWM\u001d$fi\u000eDG\u0003\u0004B\u001f\u0005\u000b\u00129E!\u0013\u0003^\tM\u0004CBAs\u0003g\u0014y\u0004E\u0002b\u0005\u0003J1Aa\u0011S\u0005I1U\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u000f\t\u0015r\u00061\u0001\u0003(!9!qF\u0018A\u0002\tE\u0002b\u0002B&_\u0001\u0007!QJ\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\t=#q\u000b\b\u0005\u0005#\u0012\u0019&\u0004\u0002\u0003\u001c%!!Q\u000bB\u000e\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u0011IFa\u0017\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\u0011)Fa\u0007\t\u000f\t}s\u00061\u0001\u0003b\u0005\t2\r\\5f]RlU\r^1eCR\fw\n\u001d;\u0011\u000be\u0013\u0019Ga\u001a\n\u0007\t\u0015$L\u0001\u0004PaRLwN\u001c\t\u0005\u0005S\u0012y'\u0004\u0002\u0003l)\u0019!QN>\u0002\u000fI,\u0007\u000f\\5dC&!!\u0011\u000fB6\u00059\u0019E.[3oi6+G/\u00193bi\u0006D\u0011B!\u001e0!\u0003\u0005\r!!\u0013\u0002\u000fQLW.Z8vi\u0006Y2/\u001a8e\u0007>t7/^7fe\u001a+Go\u00195%I\u00164\u0017-\u001e7uIU*\"Aa\u001f+\t\u0005%#QP\u0016\u0003\u0005\u007f\u0002BA!!\u0003\f6\u0011!1\u0011\u0006\u0005\u0005\u000b\u00139)A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0012.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u000e\n\r%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\u0003O]3qCJ,'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018I\u001c3M_\u001el\u0015M\\1hKJ$\u0002Ca%\u0003&\n\u001d&1\u0016BX\u0005g\u0013yL!3\u0011\u000fe\u0013)Ja\n\u0003\u001a&\u0019!q\u0013.\u0003\rQ+\b\u000f\\33!\u0011\u0011YJ!)\u000e\u0005\tu%b\u0001BP)\u0006\u0019An\\4\n\t\t\r&Q\u0014\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\bb\u0002B\u0018c\u0001\u0007\u0011q\u0006\u0005\b\u0005S\u000b\u0004\u0019AA\u0018\u0003eaW-\u00193fe\u0016\u0003xn\u00195J]2+\u0017\rZ3s\u0003:$\u0017j\u001d:\t\u000f\t5\u0016\u00071\u0001\u00020\u0005\u0001bm\u001c7m_^,'O\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0005c\u000b\u0004\u0019AA\u0018\u00039aW-\u00193fe\n\u0013xn[3s\u0013\u0012DqA!.2\u0001\u0004\u00119,\u0001\bd_VtG\u000fR8x]2\u000bGo\u00195\u0011\t\te&1X\u0007\u0003\u0003WLAA!0\u0002l\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0007b\u0002Bac\u0001\u0007!1Y\u0001\u0011Kb\u0004Xm\u0019;UeVt7-\u0019;j_:\u00042!\u0017Bc\u0013\r\u00119M\u0017\u0002\b\u0005>|G.Z1o\u0011%\u0011Y-\rI\u0001\u0002\u0004\u0011i-\u0001\u0006fqR\u0014\u0018\r\u0015:paN\u0004BAa4\u0003R6\u0011\u0011q^\u0005\u0005\u0005'\fyO\u0001\u0006Qe>\u0004XM\u001d;jKN\fA\u0006\u001d:fa\u0006\u0014XMU3qY&\u001c\u0017-T1oC\u001e,'/\u00118e\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\te'\u0006\u0002Bg\u0005{\n!\u0004\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$\"Ba8\u0003v\n](1 B\u007f!\u0011\u0011\tOa<\u000f\t\t\r(\u0011\u001e\b\u0005\u0003{\u0014)/C\u0002\u0003hn\fq!\\3tg\u0006<W-\u0003\u0003\u0003l\n5\u0018a\u0006'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$H)\u0019;b\u0015\r\u00119o_\u0005\u0005\u0005c\u0014\u0019P\u0001\u000eMK\u0006$WM]!oI&\u001b(\u000fU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0003l\n5\bb\u0002B\u0018g\u0001\u0007!\u0011\u0007\u0005\b\u0005s\u001c\u0004\u0019AA\u0018\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\tE6\u00071\u0001\u00020!9!q`\u001aA\u0002\r\u0005\u0011AD1mSZ,'I]8lKJLEm\u001d\t\u0007\u0007\u0007\u0019Ia!\u0004\u000e\u0005\r\u0015!bAB\u00045\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r-1Q\u0001\u0002\u0004'\u0016\f\bcA3\u0004\u0010%\u00191\u0011\u00034\u0003\u000f%sG/Z4fe\nq1)\u00197mE\u0006\u001c7NU3tk2$X\u0003BB\f\u0007G\u0019\"\u0001\u000e-\u0015\u0005\rm\u0001#BB\u000fi\r}Q\"\u0001\u0001\u0011\t\r\u000521\u0005\u0007\u0001\t\u001d\u0019)\u0003\u000eb\u0001\u0007O\u0011\u0011\u0001V\t\u0005\u0007S\u0019y\u0003E\u0002Z\u0007WI1a!\f[\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!WB\u0019\u0013\r\u0019\u0019D\u0017\u0002\u0004\u0003:L\u0018!\u0002<bYV,WCAB\u001d!\u0015I&1MB\u0010\u0003%1\u0018\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002 \r}\u0002\"CA\u0014o\u0005\u0005\t\u0019AB\u001d\u0003\u00191\u0018\r\\;fA\u0005\u0019a-\u001e8\u0016\u0005\r\u001d\u0003#B-\u0003d\r%\u0003cB-\u0004L\r}\u0011qD\u0005\u0004\u0007\u001bR&!\u0003$v]\u000e$\u0018n\u001c82\u0003\u001d1WO\\0%KF$B!a\b\u0004T!I\u0011q\u0005\u001e\u0002\u0002\u0003\u00071qI\u0001\u0005MVt\u0007%A\u0006bgN,'\u000f\u001e$je\u0016$WCAB\u0010\u0003\u001dI7OR5sK\u0012,\"Aa1\u0002\t\u0019L'/\u001a\u000b\u0005\u0003?\u0019\u0019\u0007C\u0004\u00046y\u0002\raa\b\u0002\r=tg)\u001b:f)\u0011\u0019Yb!\u001b\t\u000f\r\rs\b1\u0001\u0004J\u0005i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$Bba\u001c\u0004r\rM4qOBD\u0007#\u0003Ra!\b5\u0003oDqA!\nA\u0001\u0004\u00119\u0003C\u0004\u0004v\u0001\u0003\rA!\r\u0002\u0013A\f'\u000f^5uS>t\u0007bBB=\u0001\u0002\u000711P\u0001\be\u0016\u001cwN\u001d3t!\u0011\u0019iha!\u000e\u0005\r}$bABAw\u00061!/Z2pe\u0012LAa!\"\u0004\u0000\tiQ*Z7pef\u0014VmY8sIND\u0011b!#A!\u0003\u0005\raa#\u0002\r=\u0014\u0018nZ5o!\u0011\u0011Yj!$\n\t\r=%Q\u0014\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\u001c\u0005\n\u0007'\u0003\u0005\u0013!a\u0001\u0007+\u000bAB]3rk&\u0014X\rZ!dWN\u00042!WBL\u0013\r\u0019IJ\u0017\u0002\u0006'\"|'\u000f^\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"aa(+\t\r-%QP\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIU*\"a!*+\t\rU%QP\u0001\u0010M\u0016$8\r[!t\u0007>t7/^7feRq11VBW\u0007_\u001b\tla.\u0004<\u000e\u0015\u0007#BB\u000fi\t}\u0002b\u0002B\u0013\u0007\u0002\u0007!q\u0005\u0005\b\u0007k\u001a\u0005\u0019\u0001B\u0019\u0011\u001d\u0011Ye\u0011a\u0001\u0007g\u0003Ba!.\u0003X9!\u00111 B*\u0011%\u0019Il\u0011I\u0001\u0002\u0004\ty#\u0001\u0005nS:\u0014\u0015\u0010^3t\u0011%\u0019il\u0011I\u0001\u0002\u0004\u0019y,\u0001\bjg>d\u0017\r^5p]2+g/\u001a7\u0011\t\tM2\u0011Y\u0005\u0004\u0007\u0007\\(AD%t_2\fG/[8o\u0019\u00164X\r\u001c\u0005\n\u0007\u000f\u001c\u0005\u0013!a\u0001\u0005C\nab\u00197jK:$X*\u001a;bI\u0006$\u0018-A\rgKR\u001c\u0007.Q:D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\"TCABgU\u0011\tyC! \u00023\u0019,Go\u00195Bg\u000e{gn];nKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007'TCaa0\u0003~\u0005Ib-\u001a;dQ\u0006\u001b8i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019IN\u000b\u0003\u0003b\tu\u0014a\u00044fi\u000eD\u0017i\u001d$pY2|w/\u001a:\u0015\u001d\r-6q\\Bq\u0007G\u001c)oa:\u0004j\"9!QE$A\u0002\t\u001d\u0002bBB;\u000f\u0002\u0007!\u0011\u0007\u0005\b\u0005\u0017:\u0005\u0019ABZ\u0011%\u0019Il\u0012I\u0001\u0002\u0004\ty\u0003C\u0005\u0004>\u001e\u0003\n\u00111\u0001\u0004@\"I1qY$\u0011\u0002\u0003\u0007!\u0011M\u0001\u001aM\u0016$8\r[!t\r>dGn\\<fe\u0012\"WMZ1vYR$C'A\rgKR\u001c\u0007.Q:G_2dwn^3sI\u0011,g-Y;mi\u0012*\u0014!\u00074fi\u000eD\u0017i\u001d$pY2|w/\u001a:%I\u00164\u0017-\u001e7uIY\nQBZ3uG\"lUm]:bO\u0016\u001cH\u0003EBV\u0007k\u001c9pa?\u0004~\u000e}H\u0011\u0001C\u0002\u0011\u001d\u0011)c\u0013a\u0001\u0005OAqa!?L\u0001\u0004\ty#A\u0005sKBd\u0017nY1JI\"91QO&A\u0002\tE\u0002b\u0002B&\u0017\u0002\u000711\u0017\u0005\b\u0007s[\u0005\u0019AA\u0018\u0011\u001d\u0019il\u0013a\u0001\u0007\u007fCqaa2L\u0001\u0004\u0011\t'\u0001\u0015tKR,\bOU3qY&\u001c\u0017-T1oC\u001e,'oV5uQ6{7m[3e!V\u0014x-\u0019;pe&,7\u000f\u0006\u0004\u0003(\u0011%Aq\u0003\u0005\b\t\u0017a\u0005\u0019\u0001C\u0007\u0003\u0015!\u0018.\\3s!\u0011!y\u0001b\u0005\u000e\u0005\u0011E!b\u0001C\u0006c&!AQ\u0003C\t\u0005%iunY6US6,'\u000fC\u0005\u0003\u00002\u0003\n\u00111\u0001\u0005\u001aA111AB\u0005\u0003_\t!g]3ukB\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5N_\u000e\\W\r\u001a)ve\u001e\fGo\u001c:jKN$C-\u001a4bk2$HEM\u000b\u0003\t?QC\u0001\"\u0007\u0003~\u0005yC/Z:u\u001f2$G*Z1eKJdun]3t\u001b\u0016$(/[2t/\",gNU3bgNLwM\u001c)beRLG/[8og\"\u001aa*!\u001d\u0002cQ,7\u000f^(mI\u001a{G\u000e\\8xKJdun]3t\u001b\u0016$(/[2t/\",gNU3bgNLwM\u001c)beRLG/[8og\"\u001aq*!\u001d\u0002?A\u0014X\r]1sK\u0012KgMZ3sK:$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148\u000f\u0006\u0004\u0005.\u0011=B\u0011\b\t\b3\nU%q\u0005B\u0014\u0011\u001d!\t\u0004\u0015a\u0001\tg\t\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:2!\r\tGQG\u0005\u0004\to\u0011&\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u001d!Y\u0004\u0015a\u0001\tg\t\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:3\u0001")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private KafkaZkClient kafkaZkClient;
    private final int zkVersion;
    private final int correlationId;
    private int controllerEpoch = 0;
    private final long brokerEpoch;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public void kafkaZkClient_$eq(KafkaZkClient x$1) {
        this.kafkaZkClient = x$1;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Before
    public void setUp() {
        this.kafkaZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        EasyMock.expect((Object)this.kafkaZkClient().getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafkaZkClient()});
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            rm.createPartition(new TopicPartition(this.topic(), 1)).createLogIfNotExists(1, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            rm.createPartition(new TopicPartition(this.topic(), 1)).createLogIfNotExists(1, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            rm.appendRecords(0L, (short)3, false, (AppendOrigin)AppendOrigin.Client$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.callback$1(responseStatus);
                return BoxedUnit.UNIT;
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        finally {
            rm.shutdown(false);
        }
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$4 -> new File((String)x$4), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            rm.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$2(x$5, x$6);
                return BoxedUnit.UNIT;
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.appendRecords(rm, new TopicPartition(this.topic(), 0), records, this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$3(response);
                return BoxedUnit.UNIT;
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$4(x$7, x$8);
                return BoxedUnit.UNIT;
            });
            Assert.assertTrue((boolean)appendResult.isFired());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testFencedErrorCausedByBecomeLeader() {
        this.testFencedErrorCausedByBecomeLeader(0);
        this.testFencedErrorCausedByBecomeLeader(1);
        this.testFencedErrorCausedByBecomeLeader(10);
    }

    /*
     * WARNING - void declaration
     */
    private void testFencedErrorCausedByBecomeLeader(int loopEpochChange) {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
            replicaManager.createPartition(topicPartition).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            replicaManager.becomeLeaderOrFollower(0, this.leaderAndIsrRequest$1(0, brokerList), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
                ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$1(x$9, x$10);
                return BoxedUnit.UNIT;
            });
            Partition partition = replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true);
            Assert.assertEquals((long)1L, (long)((SeqLike)replicaManager.logManager().liveLogDirs().filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$2(partition, x$11)))).size());
            File previousReplicaFolder = ((Log)partition.log().get()).dir().getParentFile();
            File newReplicaFolder = (File)((IterableLike)replicaManager.logManager().liveLogDirs().filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$3(partition, x$12)))).head();
            Assert.assertEquals((long)0L, (long)replicaManager.replicaAlterLogDirsManager().fetcherThreadMap().size());
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = newReplicaFolder.getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            replicaManager.alterReplicaLogDirs((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
            replicaManager.futureLocalLogOrException(topicPartition);
            Assert.assertEquals((long)1L, (long)replicaManager.replicaAlterLogDirsManager().fetcherThreadMap().size());
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, loopEpochChange);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    replicaManager.becomeLeaderOrFollower(0, this.leaderAndIsrRequest$1(foreach_i, brokerList), (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
                        ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$5(x$13, x$14);
                        return BoxedUnit.UNIT;
                    });
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$6(replicaManager)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            Assert.assertEquals((long)0L, (long)replicaManager.replicaAlterLogDirsManager().failedPartitions().size());
            Assert.assertTrue((boolean)partition.futureLog().isEmpty());
            Assert.assertEquals((Object)newReplicaFolder.getAbsolutePath(), (Object)((Log)partition.log().get()).dir().getParent());
            Tuple2[] tuple2Array2 = new Tuple2[1];
            String string2 = previousReplicaFolder.getAbsolutePath();
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Map response = replicaManager.alterReplicaLogDirs((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
            Assert.assertNotEquals((long)0L, (long)response.size());
            response.values().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$8(x$15);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)replicaManager.replicaAlterLogDirsManager().fetcherThreadMap().size());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.createPartition(new TopicPartition(this.topic(), 0));
            partition.createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$16, x$17) -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(x$16, x$17);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(this, producerId, epoch, replicaManager, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(9).append("message: ").append(outOfRangeSequence).toString().getBytes())});
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(response);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            replicaManager.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$18, x$19) -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$1(x$18, x$19);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2(this, producerId, epoch, replicaManager, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            TopicPartition x$2 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000, Optional.empty());
            IsolationLevel x$4 = IsolationLevel.READ_UNCOMMITTED;
            int x$5 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$6 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(replicaManager, x$2, x$3, x$5, x$4, x$6);
            TopicPartition x$8 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$9 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$10 = IsolationLevel.READ_COMMITTED;
            int x$11 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$12 = this.fetchAsConsumer$default$6();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(replicaManager, x$8, x$9, x$11, x$10, x$12);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            TopicPartition x$14 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$15 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$16 = IsolationLevel.READ_COMMITTED;
            int x$17 = 1000;
            Option<ClientMetadata> x$182 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(replicaManager, x$14, x$15, x$17, x$16, x$182);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$4(response);
                return BoxedUnit.UNIT;
            });
            TopicPartition x$20 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$21 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$22 = IsolationLevel.READ_COMMITTED;
            int x$23 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$24 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(replicaManager, x$20, x$21, x$23, x$22, x$24);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            TopicPartition x$26 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$27 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$28 = IsolationLevel.READ_UNCOMMITTED;
            int x$29 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$30 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(replicaManager, x$26, x$27, x$29, x$28, x$30);
            TopicPartition x$32 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$33 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$34 = IsolationLevel.READ_COMMITTED;
            int x$35 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$36 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(replicaManager, x$32, x$33, x$35, x$34, x$36);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            replicaManager.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$20, x$21) -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$1(x$20, x$21);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2(this, producerId, epoch, replicaManager, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$4(response);
                return BoxedUnit.UNIT;
            });
            TopicPartition x$2 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$4 = IsolationLevel.READ_UNCOMMITTED;
            int x$5 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$6 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(replicaManager, x$2, x$3, x$5, x$4, x$6);
            TopicPartition x$8 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$9 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$10 = IsolationLevel.READ_COMMITTED;
            int x$11 = 10000;
            Option<ClientMetadata> x$12 = this.fetchAsConsumer$default$6();
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(replicaManager, x$8, x$9, x$11, x$10, x$12);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            rm.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$22, x$23) -> {
                ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(x$22, x$23);
                return BoxedUnit.UNIT;
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 2);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(this, rm, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            FetchPartitionData followerFetchData = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5(), this.fetchAsFollower$default$6()).assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            FetchPartitionData consumerFetchData = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5(), this.fetchAsConsumer$default$6()).assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        finally {
            rm.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerStateNotUpdatedIfLogReadFails() {
        int maxFetchBytes = 0x100000;
        Seq aliveBrokersIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int leaderEpoch = 5;
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)aliveBrokersIds);
        try {
            void $minus$greater$extension_$this;
            void $minus$greater$extension_$this2;
            Object object;
            void map_bf;
            TopicPartition tp = new TopicPartition(this.topic(), 0);
            List list = aliveBrokersIds.toList();
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(BoxesRunTime.unboxToInt((Object)x));
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (map_this == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(BoxesRunTime.unboxToInt((Object)map_this.head())), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$((TraversableLike)map_this, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(0).setReplicas(replicas).setIsNew(true);
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{leaderAndIsrPartitionState}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            LeaderAndIsrResponse leaderAndIsrResponse = replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$24, x$25) -> {
                ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$2(x$24, x$25);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((Object)Errors.NONE, (Object)leaderAndIsrResponse.error());
            Assert.assertTrue((boolean)replicaManager.nonOfflinePartition(tp).isDefined());
            Partition partition = (Partition)replicaManager.nonOfflinePartition(tp).get();
            Assert.assertTrue((boolean)partition.getReplica(1).isDefined());
            Replica followerReplica = (Replica)partition.getReplica(1).get();
            Assert.assertEquals((long)-1L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)-1L, (long)followerReplica.logEndOffset());
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 5);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$3(this, replicaManager, tp, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            ObjectRef successfulFetch = ObjectRef.create((Object)None$.MODULE$);
            FetchRequest.PartitionData validFetchPartitionData = new FetchRequest.PartitionData(0L, 0L, maxFetchBytes, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
            long x$1 = 0L;
            int x$2 = 1;
            int x$3 = 1;
            boolean x$5 = false;
            Tuple2[] tuple2Array = new Tuple2[1];
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)validFetchPartitionData);
            Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            QuotaFactory.UnboundedQuota$ x$7 = QuotaFactory.UnboundedQuota$.MODULE$;
            IsolationLevel x$8 = IsolationLevel.READ_UNCOMMITTED;
            Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.callback$2(response, successfulFetch, tp);
                return BoxedUnit.UNIT;
            };
            None$ x$10 = None$.MODULE$;
            replicaManager.fetchMessages(x$1, x$2, x$3, maxFetchBytes, x$5, x$6, (ReplicaQuota)x$7, (Function1)x$9, x$8, (Option)x$10);
            Assert.assertTrue((boolean)((Option)successfulFetch.elem).isDefined());
            Assert.assertEquals((long)0L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)0L, (long)followerReplica.logEndOffset());
            FetchRequest.PartitionData invalidFetchPartitionData = new FetchRequest.PartitionData(3L, 0L, maxFetchBytes, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)));
            long x$11 = 0L;
            int x$12 = 1;
            int x$13 = 1;
            boolean x$15 = false;
            Tuple2[] tuple2Array2 = new Tuple2[1];
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)invalidFetchPartitionData);
            Seq x$16 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
            QuotaFactory.UnboundedQuota$ x$17 = QuotaFactory.UnboundedQuota$.MODULE$;
            IsolationLevel x$18 = IsolationLevel.READ_UNCOMMITTED;
            Function1 & Serializable & scala.Serializable x$19 = (Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.callback$2(response, successfulFetch, tp);
                return BoxedUnit.UNIT;
            };
            None$ x$20 = None$.MODULE$;
            replicaManager.fetchMessages(x$11, x$12, x$13, maxFetchBytes, x$15, x$16, (ReplicaQuota)x$17, (Function1)x$19, x$18, (Option)x$20);
            Assert.assertTrue((boolean)((Option)successfulFetch.elem).isDefined());
            Assert.assertEquals((long)0L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)0L, (long)followerReplica.logEndOffset());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
            replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
            replicaManager.createPartition(tp1).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
            java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            java.util.List partition1Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$28, x$29) -> {
                ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(x$28, x$29);
                return BoxedUnit.UNIT;
            });
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 2);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(this, replicaManager, tp0, tp1, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            Tuple2[] tuple2Array = new Tuple2[2];
            FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)tp0);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            FetchRequest.PartitionData partitionData2 = new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty());
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            replicaManager.fetchMessages(1000L, 1, 0, Integer.MAX_VALUE, false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.fetchCallback$1(responseStatus, tp0, tp1);
                return BoxedUnit.UNIT;
            }, IsolationLevel.READ_UNCOMMITTED, (Option)None$.MODULE$);
            Option tp0Log = replicaManager.localLog(tp0);
            Assert.assertTrue((boolean)tp0Log.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Log)tp0Log.get()).highWatermark());
            replicaManager.localLog(tp1);
            Option tp1Replica = replicaManager.localLog(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Log)tp1Replica.get()).highWatermark());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate() {
        void var12_12;
        void var11_11;
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        LogManager mockLogMgr = (LogManager)tuple2._2();
        void replicaManager2 = var11_11;
        void mockLogMgr2 = var12_12;
        TopicPartition tp = new TopicPartition(this.topic(), topicPartition);
        Partition partition = replicaManager2.createPartition(tp);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager2.highWatermarkCheckpoints());
        partition.createLogIfNotExists(followerBrokerId, false, false, (OffsetCheckpoints)offsetCheckpoints);
        partition.makeFollower(controllerId, this.leaderAndIsrPartitionState(tp, leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId(), (OffsetCheckpoints)offsetCheckpoints);
        LeaderAndIsrRequest leaderAndIsrRequest0 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{this.leaderAndIsrPartitionState(tp, leaderEpoch += leaderEpochIncrement, leaderBrokerId, (Seq<Integer>)aliveBrokerIds)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(followerBrokerId, "host1", 0), new Node(leaderBrokerId, "host2", 1)}))).asJava()).build();
        replicaManager2.becomeLeaderOrFollower(this.correlationId(), leaderAndIsrRequest0, (Function2 & Serializable & scala.Serializable)(x$31, followers) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate$1(followerBrokerId, x$31, followers);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)countDownLatch.await(1000L, TimeUnit.MILLISECONDS));
        EasyMock.verify((Object[])new Object[]{mockLogMgr2});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaSelector() {
        void var10_10;
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        TopicPartition tp = new TopicPartition(this.topic(), topicPartition);
        Partition partition = var10_10.createPartition(tp);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(var10_10.highWatermarkCheckpoints());
        partition.createLogIfNotExists(leaderBrokerId, false, false, (OffsetCheckpoints)offsetCheckpoints);
        partition.makeLeader(controllerId, this.leaderAndIsrPartitionState(tp, leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId(), (OffsetCheckpoints)offsetCheckpoints);
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
        Assert.assertFalse((boolean)var10_10.findPreferredReadReplica(tp0, (ClientMetadata)metadata, Request$.MODULE$.OrdinaryConsumerId(), 1L, System.currentTimeMillis()).isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaAsFollower() {
        void var8_8;
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        var8_8.createPartition(new TopicPartition(this.topic(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        var8_8.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$32, x$33) -> {
            ReplicaManagerTest.$anonfun$testPreferredReplicaAsFollower$1(x$32, x$33);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
        FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
        Some x$4 = new Some((Object)metadata);
        int x$5 = this.fetchAsConsumer$default$4();
        IsolationLevel x$6 = this.fetchAsConsumer$default$5();
        CallbackResult<FetchPartitionData> consumerResult = this.fetchAsConsumer((ReplicaManager)var8_8, tp0, x$3, x$5, x$6, (Option<ClientMetadata>)x$4);
        Assert.assertTrue((boolean)consumerResult.isFired());
        Assert.assertTrue((boolean)consumerResult.assertFired().preferredReadReplica().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaAsLeader() {
        void var8_8;
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        var8_8.createPartition(new TopicPartition(this.topic(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        var8_8.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$34, x$35) -> {
            ReplicaManagerTest.$anonfun$testPreferredReplicaAsLeader$1(x$34, x$35);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
        FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
        Some x$4 = new Some((Object)metadata);
        int x$5 = this.fetchAsConsumer$default$4();
        IsolationLevel x$6 = this.fetchAsConsumer$default$5();
        CallbackResult<FetchPartitionData> consumerResult = this.fetchAsConsumer((ReplicaManager)var8_8, tp0, x$3, x$5, x$6, (Option<ClientMetadata>)x$4);
        Assert.assertTrue((boolean)consumerResult.isFired());
        Assert.assertFalse((boolean)consumerResult.assertFired().preferredReadReplica().isDefined());
    }

    @Test(expected=ClassNotFoundException.class)
    public void testUnknownReplicaSelector() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ReplicaSelectorClassProp(), "non-a-class");
        this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDefaultReplicaSelector() {
        void var8_8;
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        Assert.assertFalse((boolean)var8_8.replicaSelectorOpt().isDefined());
    }

    @Test
    public void testFetchFollowerNotAllowedForOlderClients() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(0).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2 & Serializable & scala.Serializable)(x$36, x$37) -> {
            ReplicaManagerTest.$anonfun$testFetchFollowerNotAllowedForOlderClients$1(x$36, x$37);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(0)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
        partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(0)));
        fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testBecomeFollowerWhileOldClientFetchInPurgatory() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$38, x$39) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$1(x$38, x$39);
            return BoxedUnit.UNIT;
        });
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, 10L);
        Assert.assertNull((Object)fetchResult.get());
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(2).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2 & Serializable & scala.Serializable)(x$40, x$41) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$2(x$40, x$41);
            return BoxedUnit.UNIT;
        });
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testBecomeFollowerWhileNewClientFetchInPurgatory() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$42, x$43) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$1(x$42, x$43);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), 10L);
        Assert.assertNull((Object)fetchResult.get());
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(2).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2 & Serializable & scala.Serializable)(x$44, x$45) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$2(x$44, x$45);
            return BoxedUnit.UNIT;
        });
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.get().error());
    }

    @Test
    public void testFetchFromLeaderAlwaysAllowed() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$46, x$47) -> {
            ReplicaManagerTest.$anonfun$testFetchFromLeaderAlwaysAllowed$1(x$46, x$47);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
        partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
    }

    @Test
    public void testClearFetchPurgatoryOnStopReplica() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$48, x$49) -> {
            ReplicaManagerTest.$anonfun$testClearFetchPurgatoryOnStopReplica$1(x$48, x$49);
            return BoxedUnit.UNIT;
        });
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, 10L);
        Assert.assertNull((Object)fetchResult.get());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.metadataCache().contains(tp0))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        replicaManager.stopReplica(tp0, true);
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testClearProducePurgatoryOnStopReplica() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$50, x$51) -> {
            ReplicaManagerTest.$anonfun$testClearProducePurgatoryOnStopReplica$1(x$50, x$51);
            return BoxedUnit.UNIT;
        });
        AtomicReference<ProduceResponse.PartitionResponse> produceResult = this.sendProducerAppend(replicaManager, tp0);
        Assert.assertNull((Object)produceResult.get());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.metadataCache().contains(tp0))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        replicaManager.stopReplica(tp0, true);
        Assert.assertNotNull((Object)produceResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)produceResult.get().error);
    }

    /*
     * WARNING - void declaration
     */
    private AtomicReference<ProduceResponse.PartitionResponse> sendProducerAppend(ReplicaManager replicaManager, TopicPartition topicPartition) {
        void var3_3;
        void $minus$greater$extension_$this;
        AtomicReference produceResult = new AtomicReference();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes())});
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)records);
        replicaManager.appendRecords(10L, (short)-1, false, (AppendOrigin)AppendOrigin.Client$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.callback$3(response, produceResult, topicPartition);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private AtomicReference<FetchPartitionData> sendConsumerFetch(ReplicaManager replicaManager, TopicPartition topicPartition, FetchRequest.PartitionData partitionData, Option<ClientMetadata> clientMetadataOpt, long timeout) {
        void $minus$greater$extension_$this;
        AtomicReference<FetchPartitionData> fetchResult = new AtomicReference<FetchPartitionData>();
        int x$2 = Request$.MODULE$.OrdinaryConsumerId();
        int x$3 = 1;
        int x$4 = 100;
        boolean x$5 = false;
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)partitionData);
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        QuotaFactory.UnboundedQuota$ x$7 = QuotaFactory.UnboundedQuota$.MODULE$;
        IsolationLevel x$8 = IsolationLevel.READ_UNCOMMITTED;
        Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.callback$4(response, fetchResult, topicPartition);
            return BoxedUnit.UNIT;
        };
        replicaManager.fetchMessages(timeout, x$2, x$3, x$4, x$5, x$6, (ReplicaQuota)x$7, (Function1)x$9, x$8, clientMetadataOpt);
        return fetchResult;
    }

    private long sendConsumerFetch$default$5() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ReplicaManager, LogManager> prepareReplicaManagerAndLogManager(int topicPartition, int leaderEpochInLeaderAndIsr, int followerBrokerId, int leaderBrokerId, CountDownLatch countDownLatch, boolean expectTruncation, Properties extraProps) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        ((Growable)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(extraProps).asScala());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        int localLogOffset = 10;
        int offsetFromLeader = 5;
        int leaderEpochFromLeader = 3;
        MockScheduler mockScheduler = new MockScheduler((Time)this.time());
        BrokerTopicStats mockBrokerTopicStats = new BrokerTopicStats();
        LogDirFailureChannel mockLogDirFailureChannel = new LogDirFailureChannel(config.logDirs().size());
        Log mockLog = new Log(this, config, mockScheduler, mockBrokerTopicStats, topicPartition, mockLogDirFailureChannel, leaderEpochFromLeader, localLogOffset){
            private final int leaderEpochFromLeader$1;
            private final int localLogOffset$1;

            public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
                Assert.assertEquals((long)leaderEpoch, (long)this.leaderEpochFromLeader$1);
                return new Some((Object)new OffsetAndEpoch((long)this.localLogOffset$1, this.leaderEpochFromLeader$1));
            }

            public Option<Object> latestEpoch() {
                return new Some((Object)BoxesRunTime.boxToInteger((int)this.leaderEpochFromLeader$1));
            }

            public LogOffsetMetadata logEndOffsetMetadata() {
                return new LogOffsetMetadata((long)this.localLogOffset$1, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
            }

            public long logEndOffset() {
                return this.localLogOffset$1;
            }
            {
                this.leaderEpochFromLeader$1 = leaderEpochFromLeader$1;
                this.localLogOffset$1 = localLogOffset$1;
                super(new File(new File((String)config$1.logDirs().head()), new StringBuilder(2).append($outer.topic()).append("-0").toString()), LogConfig$.MODULE$.apply(), 0L, 0L, (Scheduler)mockScheduler$1, mockBrokerTopicStats$1, (Time)$outer.time(), 30000, 30000, new TopicPartition($outer.topic(), topicPartition$3), new ProducerStateManager(new TopicPartition($outer.topic(), topicPartition$3), new File(new File((String)config$1.logDirs().head()), new StringBuilder(1).append($outer.topic()).append("-").append(topicPartition$3).toString()), 30000), mockLogDirFailureChannel$1);
            }
        };
        TopicPartition topicPartitionObj = new TopicPartition(this.topic(), topicPartition);
        LogManager mockLogMgr = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)mockLogMgr.liveLogDirs()).andReturn(config.logDirs().map((Function1 & Serializable & scala.Serializable)x$52 -> new File((String)x$52).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom())).anyTimes();
        EasyMock.expect((Object)mockLogMgr.currentDefaultConfig()).andReturn((Object)LogConfig$.MODULE$.apply());
        EasyMock.expect((Object)mockLogMgr.getOrCreateLog(topicPartitionObj, LogConfig$.MODULE$.apply(), false, false)).andReturn((Object)mockLog).anyTimes();
        if (expectTruncation) {
            void $minus$greater$extension_y4;
            void $minus$greater$extension_$this4;
            Tuple2[] tuple2Array = new Tuple2[1];
            Long l = BoxesRunTime.boxToLong((long)offsetFromLeader);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartitionObj);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
            mockLogMgr.truncateTo((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), false);
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
        }
        mockLogMgr.initializingLog(topicPartitionObj);
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)mockLogMgr.getLog(topicPartitionObj, true)).andReturn((Object)None$.MODULE$);
        mockLogMgr.finishedInitializingLog((TopicPartition)EasyMock.eq((Object)topicPartitionObj), (Option)EasyMock.anyObject(), (Function0)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLogMgr});
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringBuilder(4).append("host").append(brokerId).toString(), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> EasyMock.expect((Object)metadataCache.getAliveBroker(BoxesRunTime.unboxToInt((Object)EasyMock.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))))).andReturn((Object)Option$.MODULE$.apply((Object)TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringBuilder(4).append("host").append(brokerId).toString(), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4()))).anyTimes());
        Tuple2[] tuple2Array = new Tuple2[2];
        Node node = new Node(leaderBrokerId, "host1", 9092, "rack-a");
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Node node2 = new Node(followerBrokerId, "host2", 9092, "rack-b");
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)followerBrokerId));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EasyMock.expect((Object)metadataCache.getPartitionReplicaEndpoints((TopicPartition)EasyMock.anyObject(), (ListenerName)EasyMock.anyObject())).andReturn((Object)((TraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).toMap(Predef$.MODULE$.$conforms())).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        MockTimer timer = new MockTimer();
        String x$1 = "Produce";
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$1, (Timer)timer, x$4, x$5, x$3, x$6);
        String x$7 = "Fetch";
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$7, (Timer)timer, x$10, x$11, x$9, x$12);
        String x$13 = "DeleteRecords";
        boolean x$15 = false;
        int x$16 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$17 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$18 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$13, (Timer)timer, x$16, x$17, x$15, x$18);
        String x$19 = "ElectLeader";
        boolean x$21 = false;
        int x$22 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$23 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$24 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockElectLeaderPurgatory = new DelayedOperationPurgatory(x$19, (Timer)timer, x$22, x$23, x$21, x$24);
        QuotaFactory.QuotaManagers quota = QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "");
        Tuple2[] tuple2Array2 = new Tuple2[1];
        EpochEndOffset epochEndOffset = new EpochEndOffset(leaderEpochFromLeader, (long)offsetFromLeader);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topicPartitionObj);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ReplicaFetcherMockBlockingSend blockingSend = new ReplicaFetcherMockBlockingSend((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava(), new BrokerEndPoint(1, "host1", 1), (Time)this.time());
        ReplicaManager replicaManager = new ReplicaManager(this, config, mockScheduler, mockLogMgr, quota, mockBrokerTopicStats, metadataCache, mockLogDirFailureChannel, mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockElectLeaderPurgatory, blockingSend, leaderEpochInLeaderAndIsr, topicPartition, countDownLatch){
            private final /* synthetic */ ReplicaManagerTest $outer;
            public final QuotaFactory.QuotaManagers quota$1;
            public final ReplicaFetcherMockBlockingSend blockingSend$1;
            public final int leaderEpochInLeaderAndIsr$1;
            public final int topicPartition$3;
            public final CountDownLatch countDownLatch$1;

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return new ReplicaFetcherManager(this, metrics, time, threadNamePrefix, quotaManager){
                    private final /* synthetic */ $anon$2 $outer;
                    public final Metrics metrics$1;
                    public final Time time$1;

                    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                        return new ReplicaFetcherThread(this, fetcherId, sourceBroker){
                            private final /* synthetic */ $anon$2$$anon$3 $outer;

                            /*
                             * WARNING - void declaration
                             */
                            public void doWork() {
                                void $minus$greater$extension_$this;
                                OffsetAndEpoch initialOffset = new OffsetAndEpoch(0L, this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().leaderEpochInLeaderAndIsr$1);
                                Tuple2[] tuple2Array = new Tuple2[1];
                                Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().kafka$server$ReplicaManagerTest$$anon$$$outer().topic(), this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().topicPartition$3));
                                if (Predef.ArrowAssoc$.MODULE$ == null) {
                                    throw null;
                                }
                                tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)initialOffset);
                                this.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
                                super.doWork();
                                this.initiateShutdown();
                                this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().countDownLatch$1.countDown();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new StringBuilder(21).append("ReplicaFetcherThread-").append(fetcherId$1).toString(), fetcherId$1, sourceBroker$1, $outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().config(), $outer.failedPartitions(), $outer.replicaManager(), $outer.metrics$1, $outer.time$1, (ReplicaQuota)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().quota$1.follower(), (Option)new Some((Object)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().blockingSend$1));
                            }
                        };
                    }

                    public /* synthetic */ $anon$2 kafka$server$ReplicaManagerTest$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metrics$1 = metrics$1;
                        this.time$1 = time$1;
                        super($outer.config(), (ReplicaManager)$outer, metrics$1, time$1, threadNamePrefix$1, quotaManager$1);
                    }
                };
            }

            public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quota$1 = quota$1;
                this.blockingSend$1 = blockingSend$1;
                this.leaderEpochInLeaderAndIsr$1 = leaderEpochInLeaderAndIsr$1;
                this.topicPartition$3 = topicPartition$3;
                this.countDownLatch$1 = countDownLatch$1;
                super(config$1, $outer.metrics(), (Time)$outer.time(), $outer.kafkaZkClient(), (Scheduler)mockScheduler$1, mockLogMgr$1, new AtomicBoolean(false), quota$1, mockBrokerTopicStats$1, metadataCache$1, mockLogDirFailureChannel$1, mockProducePurgatory$1, mockFetchPurgatory$1, mockDeleteRecordsPurgatory$1, mockElectLeaderPurgatory$1, Option$.MODULE$.apply((Object)$outer.getClass().getName()));
            }
        };
        return new Tuple2((Object)replicaManager, (Object)mockLogMgr);
    }

    private Properties prepareReplicaManagerAndLogManager$default$7() {
        return new Properties();
    }

    private LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState(TopicPartition topicPartition, int leaderEpoch, int leaderBrokerId, Seq<Integer> aliveBrokerIds) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(topicPartition.partition()).setControllerEpoch(this.controllerEpoch()).setLeader(leaderBrokerId).setLeaderEpoch(leaderEpoch).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava()).setZkVersion(this.zkVersion()).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava()).setIsNew(false);
    }

    /*
     * WARNING - void declaration
     */
    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        void $minus$greater$extension_$this;
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)records);
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Function1 & Serializable & scala.Serializable)responses -> {
            ReplicaManagerTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.Client$.MODULE$;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel, clientMetadata);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private Option<ClientMetadata> fetchAsConsumer$default$6() {
        return None$.MODULE$;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel, clientMetadata);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private Option<ClientMetadata> fetchAsFollower$default$6() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        void $minus$greater$extension_$this;
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)partitionData);
        replicaManager.fetchMessages(1000L, replicaId, minBytes, Integer.MAX_VALUE, false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1 & Serializable & scala.Serializable)responseStatus -> {
            ReplicaManagerTest.fetchCallback$2(responseStatus, partition, result);
            return BoxedUnit.UNIT;
        }, isolationLevel, clientMetadata);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dirs", new StringBuilder(1).append(TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath()).append(",").append(TestUtils$.MODULE$.tempRelativeDir("data2").getAbsolutePath()).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$54 -> new File((String)x$54), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)brokerId), new StringBuilder(4).append("host").append(BoxesRunTime.unboxToInt((Object)brokerId)).toString(), BoxesRunTime.unboxToInt((Object)brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.getAliveBrokers()).thenReturn((Object)aliveBrokers);
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReplicaManagerTest.$anonfun$setupReplicaManagerWithMockedPurgatories$3(metadataCache, BoxesRunTime.unboxToInt((Object)brokerId)));
        String x$1 = "Produce";
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$1, (Timer)timer, x$4, x$5, x$3, x$6);
        String x$7 = "Fetch";
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$7, (Timer)timer, x$10, x$11, x$9, x$12);
        String x$13 = "DeleteRecords";
        boolean x$15 = false;
        int x$16 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$17 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$18 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$13, (Timer)timer, x$16, x$17, x$15, x$18);
        String x$19 = "DelayedElectLeader";
        boolean x$21 = false;
        int x$22 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$23 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$24 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDelayedElectLeaderPurgatory = new DelayedOperationPurgatory(x$19, (Timer)timer, x$22, x$23, x$21, x$24);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockDelayedElectLeaderPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOldLeaderLosesMetricsWhenReassignPartitions() {
        void var9_9;
        void var8_8;
        int controllerEpoch = 0;
        int leaderEpoch = 0;
        int leaderEpochIncrement = 1;
        int correlationId = 0;
        int controllerId = 0;
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)EasyMock.mock(BrokerTopicStats.class);
        Tuple2<ReplicaManager, ReplicaManager> tuple2 = this.prepareDifferentReplicaManagers((BrokerTopicStats)EasyMock.mock(BrokerTopicStats.class), mockTopicStats1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager rm0 = (ReplicaManager)tuple2._1();
        ReplicaManager rm1 = (ReplicaManager)tuple2._2();
        void rm02 = var8_8;
        void rm12 = var9_9;
        mockTopicStats1.removeOldLeaderMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        EasyMock.replay((Object[])new Object[]{mockTopicStats1});
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            java.util.List partition1Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$56, x$57) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$1(x$56, x$57);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$58, x$59) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$2(x$58, x$59);
                return BoxedUnit.UNIT;
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$60, x$61) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$3(x$60, x$61);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$62, x$63) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$4(x$62, x$63);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            rm02.shutdown(rm02.shutdown$default$1());
            rm12.shutdown(rm12.shutdown$default$1());
        }
        EasyMock.verify((Object[])new Object[]{mockTopicStats1});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOldFollowerLosesMetricsWhenReassignPartitions() {
        void var9_9;
        void var8_8;
        int controllerEpoch = 0;
        int leaderEpoch = 0;
        int leaderEpochIncrement = 1;
        int correlationId = 0;
        int controllerId = 0;
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)EasyMock.mock(BrokerTopicStats.class);
        Tuple2<ReplicaManager, ReplicaManager> tuple2 = this.prepareDifferentReplicaManagers((BrokerTopicStats)EasyMock.mock(BrokerTopicStats.class), mockTopicStats1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager rm0 = (ReplicaManager)tuple2._1();
        ReplicaManager rm1 = (ReplicaManager)tuple2._2();
        void rm02 = var8_8;
        void rm12 = var9_9;
        mockTopicStats1.removeOldLeaderMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        mockTopicStats1.removeOldFollowerMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        EasyMock.replay((Object[])new Object[]{mockTopicStats1});
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            java.util.List partition1Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$65, x$66) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$1(x$65, x$66);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$67, x$68) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$2(x$67, x$68);
                return BoxedUnit.UNIT;
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$69, x$70) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$3(x$69, x$70);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$71, x$72) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$4(x$71, x$72);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            rm02.shutdown(rm02.shutdown$default$1());
            rm12.shutdown(rm12.shutdown$default$1());
        }
        EasyMock.verify((Object[])new Object[]{mockTopicStats1});
    }

    private Tuple2<ReplicaManager, ReplicaManager> prepareDifferentReplicaManagers(BrokerTopicStats brokerTopicStats1, BrokerTopicStats brokerTopicStats2) {
        Properties props0 = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props0.put("log0.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        props1.put("log1.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config0 = KafkaConfig$.MODULE$.fromProps(props0);
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(props1);
        LogManager mockLogMgr0 = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config0.logDirs().map((Function1 & Serializable & scala.Serializable)x$73 -> new File((String)x$73), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        LogManager mockLogMgr1 = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config1.logDirs().map((Function1 & Serializable & scala.Serializable)x$74 -> new File((String)x$74), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        MetadataCache metadataCache0 = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        MetadataCache metadataCache1 = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        EasyMock.expect((Object)metadataCache0.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache0});
        EasyMock.expect((Object)metadataCache1.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache1});
        ReplicaManager rm0 = new ReplicaManager(config0, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr0, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config0, this.metrics(), (Time)this.time(), ""), brokerTopicStats1, metadataCache0, new LogDirFailureChannel(config0.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        ReplicaManager rm1 = new ReplicaManager(config1, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr1, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config1, this.metrics(), (Time)this.time(), ""), brokerTopicStats2, metadataCache1, new LogDirFailureChannel(config1.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        return new Tuple2((Object)rm0, (Object)rm1);
    }

    private static final void callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$4(Iterable x$7, Iterable x$8) {
    }

    private final LeaderAndIsrRequest leaderAndIsrRequest$1(int epoch, java.util.List brokerList$1) {
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(epoch).setIsr(brokerList$1).setZkVersion(0).setReplicas(brokerList$1).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
    }

    public static final /* synthetic */ void $anonfun$testFencedErrorCausedByBecomeLeader$1(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ boolean $anonfun$testFencedErrorCausedByBecomeLeader$2(Partition partition$1, File x$11) {
        File file = x$11;
        File file2 = ((Log)partition$1.log().get()).dir().getParentFile();
        return !(file != null ? !((Object)file).equals(file2) : file2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testFencedErrorCausedByBecomeLeader$3(Partition partition$1, File x$12) {
        File file = x$12;
        File file2 = ((Log)partition$1.log().get()).dir().getParentFile();
        return !(file != null ? !((Object)file).equals(file2) : file2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFencedErrorCausedByBecomeLeader$5(Iterable x$13, Iterable x$14) {
    }

    public static final /* synthetic */ boolean $anonfun$testFencedErrorCausedByBecomeLeader$6(ReplicaManager replicaManager$1) {
        replicaManager$1.replicaAlterLogDirsManager().shutdownIdleFetcherThreads();
        return replicaManager$1.replicaAlterLogDirsManager().fetcherThreadMap().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testFencedErrorCausedByBecomeLeader$7() {
        return "ReplicaAlterLogDirsThread should be gone";
    }

    public static final /* synthetic */ void $anonfun$testFencedErrorCausedByBecomeLeader$8(Errors x$15) {
        Assert.assertEquals((Object)Errors.NONE, (Object)x$15);
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(Iterable x$16, Iterable x$17) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(ReplicaManagerTest $this, long producerId$1, short epoch$1, ReplicaManager replicaManager$2, int sequence) {
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$2, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
        Assert.assertEquals((long)0L, (long)response.logStartOffset);
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$1(Iterable x$18, Iterable x$19) {
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2(ReplicaManagerTest $this, long producerId$2, short epoch$2, ReplicaManager replicaManager$3, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$2, (short)epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$3, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$1(Iterable x$20, Iterable x$21) {
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2(ReplicaManagerTest $this, long producerId$3, short epoch$3, ReplicaManager replicaManager$4, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$3, (short)epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$4, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(Iterable x$22, Iterable x$23) {
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(ReplicaManagerTest $this, ReplicaManager rm$1, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return $this.appendRecords(rm$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Integer $anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$testFollowerStateNotUpdatedIfLogReadFails$2(Iterable x$24, Iterable x$25) {
    }

    public static final /* synthetic */ void $anonfun$testFollowerStateNotUpdatedIfLogReadFails$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFollowerStateNotUpdatedIfLogReadFails$3(ReplicaManagerTest $this, ReplicaManager replicaManager$5, TopicPartition tp$1, int i) {
        return $this.appendRecords(replicaManager$5, tp$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$4(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testFollowerStateNotUpdatedIfLogReadFails$5(TopicPartition tp$1, Tuple2 x$26) {
        Object object = x$26._1();
        return !(object != null ? !object.equals(tp$1) : tp$1 != null);
    }

    public static final /* synthetic */ FetchPartitionData $anonfun$testFollowerStateNotUpdatedIfLogReadFails$6(Tuple2 x$27) {
        return (FetchPartitionData)x$27._2();
    }

    private static final void callback$2(Seq response, ObjectRef successfulFetch$1, TopicPartition tp$1) {
        Tuple2 tuple2;
        Option option = response.headOption();
        if (option == null) {
            throw null;
        }
        Option filter_this = option;
        Object object = filter_this.isEmpty() || ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$5(tp$1, tuple2 = (Tuple2)filter_this.get()) ? filter_this : None$.MODULE$;
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? None$.MODULE$ : new Some((Object)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$6((Tuple2)object.get()));
        successfulFetch$1.elem = object2;
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(Iterable x$28, Iterable x$29) {
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(ReplicaManagerTest $this, ReplicaManager replicaManager$6, TopicPartition tp0$1, TopicPartition tp1$1, int i) {
        $this.appendRecords(replicaManager$6, tp0$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(response);
            return BoxedUnit.UNIT;
        });
        return $this.appendRecords(replicaManager$6, tp1$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(response);
            return BoxedUnit.UNIT;
        });
    }

    private static final void fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate$1(int followerBrokerId$1, Iterable x$31, Iterable followers) {
        Assert.assertEquals((long)followerBrokerId$1, (long)((Partition)followers.head()).partitionId());
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplicaAsFollower$1(Iterable x$32, Iterable x$33) {
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplicaAsLeader$1(Iterable x$34, Iterable x$35) {
    }

    public static final /* synthetic */ void $anonfun$testFetchFollowerNotAllowedForOlderClients$1(Iterable x$36, Iterable x$37) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$1(Iterable x$38, Iterable x$39) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$2(Iterable x$40, Iterable x$41) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$1(Iterable x$42, Iterable x$43) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$2(Iterable x$44, Iterable x$45) {
    }

    public static final /* synthetic */ void $anonfun$testFetchFromLeaderAlwaysAllowed$1(Iterable x$46, Iterable x$47) {
    }

    public static final /* synthetic */ void $anonfun$testClearFetchPurgatoryOnStopReplica$1(Iterable x$48, Iterable x$49) {
    }

    public static final /* synthetic */ void $anonfun$testClearProducePurgatoryOnStopReplica$1(Iterable x$50, Iterable x$51) {
    }

    private static final void callback$3(Map response, AtomicReference produceResult$1, TopicPartition topicPartition$1) {
        produceResult$1.set(response.apply((Object)topicPartition$1));
    }

    private static final void callback$4(Seq response, AtomicReference fetchResult$1, TopicPartition topicPartition$2) {
        fetchResult$1.set(response.toMap(Predef$.MODULE$.$conforms()).apply((Object)topicPartition$2));
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$2, CallbackResult result$1) {
        Option response = responses.get((Object)partition$2);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    /*
     * WARNING - void declaration
     */
    private static final void fetchCallback$2(Seq responseStatus, TopicPartition partition$3, CallbackResult result$2) {
        void var5_5;
        void var4_4;
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
        void topicPartition2 = var4_4;
        void fetchData2 = var5_5;
        Assert.assertEquals((Object)partition$3, (Object)topicPartition2);
        result$2.fire(fetchData2);
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$setupReplicaManagerWithMockedPurgatories$3(MetadataCache metadataCache$2, int brokerId) {
        return Mockito.when((Object)metadataCache$2.getAliveBroker(brokerId)).thenReturn((Object)Option$.MODULE$.apply((Object)TestUtils$.MODULE$.createBroker(brokerId, new StringBuilder(4).append("host").append(brokerId).toString(), brokerId, TestUtils$.MODULE$.createBroker$default$4())));
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$1(Iterable x$56, Iterable x$57) {
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$2(Iterable x$58, Iterable x$59) {
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$3(Iterable x$60, Iterable x$61) {
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$4(Iterable x$62, Iterable x$63) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$1(Iterable x$65, Iterable x$66) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$2(Iterable x$67, Iterable x$68) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$3(Iterable x$69, Iterable x$70) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$4(Iterable x$71, Iterable x$72) {
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
        this.zkVersion = 0;
        this.correlationId = 0;
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ LeaderAndIsrResponse $anonfun$testFencedErrorCausedByBecomeLeader$4$adapted(ReplicaManagerTest $this, ReplicaManager replicaManager$1, java.util.List brokerList$1, Object epoch) {
        return replicaManager$1.becomeLeaderOrFollower(0, $this.leaderAndIsrRequest$1(BoxesRunTime.unboxToInt((Object)epoch), brokerList$1), (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
            ReplicaManagerTest.$anonfun$testFencedErrorCausedByBecomeLeader$5(x$13, x$14);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2$adapted(ReplicaManagerTest $this, long producerId$1, short epoch$1, ReplicaManager replicaManager$2, Object sequence) {
        return ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2($this, producerId$1, epoch$1, replicaManager$2, BoxesRunTime.unboxToInt((Object)sequence));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2$adapted(ReplicaManagerTest $this, long producerId$2, short epoch$2, ReplicaManager replicaManager$3, Object sequence) {
        return ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2($this, producerId$2, epoch$2, replicaManager$3, BoxesRunTime.unboxToInt((Object)sequence));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2$adapted(ReplicaManagerTest $this, long producerId$3, short epoch$3, ReplicaManager replicaManager$4, Object sequence) {
        return ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2($this, producerId$3, epoch$3, replicaManager$4, BoxesRunTime.unboxToInt((Object)sequence));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2$adapted(ReplicaManagerTest $this, ReplicaManager rm$1, Object i) {
        return ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2($this, rm$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFollowerStateNotUpdatedIfLogReadFails$3$adapted(ReplicaManagerTest $this, ReplicaManager replicaManager$5, TopicPartition tp$1, Object i) {
        return ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$3($this, replicaManager$5, tp$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2$adapted(ReplicaManagerTest $this, ReplicaManager replicaManager$6, TopicPartition tp0$1, TopicPartition tp1$1, Object i) {
        return ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2($this, replicaManager$6, tp0$1, tp1$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testFollowerStateNotUpdatedIfLogReadFails$5$adapted(TopicPartition tp$1, Tuple2 x$26) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$5(tp$1, x$26));
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            Option<Function1<T, BoxedUnit>> option = this.fun();
            if (option == null) {
                throw null;
            }
            Option<Function1<T, BoxedUnit>> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((Function1)foreach_this.get()).apply(value);
                return;
            }
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.isFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public static final /* synthetic */ void $anonfun$fire$1(Object value$1, Function1 f) {
            f.apply(value$1);
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }

        public static final /* synthetic */ Object $anonfun$fire$1$adapted(Object value$1, Function1 f) {
            f.apply(value$1);
            return BoxedUnit.UNIT;
        }
    }
}

