/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kafka.utils.json.JsonValue;
import kafka.utils.json.JsonValue$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;

public final class Json$ {
    public static Json$ MODULE$;
    private final ObjectMapper mapper;

    static {
        new Json$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public Option<JsonValue> parseFull(String input) {
        try {
            Option option = Option$.MODULE$.apply((Object)this.mapper().readTree(input));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)JsonValue$.MODULE$.apply((JsonNode)map_this.get()));
            return object;
        }
        catch (JsonProcessingException jsonProcessingException) {
            String escapedInput = input.replaceAll("\\\\", "\\\\\\\\");
            try {
                Option option = Option$.MODULE$.apply((Object)this.mapper().readTree(escapedInput));
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)JsonValue$.MODULE$.apply((JsonNode)map_this.get()));
                return object;
            }
            catch (JsonProcessingException jsonProcessingException2) {
                return None$.MODULE$;
            }
        }
    }

    public <T> Either<JsonProcessingException, T> parseStringAs(String input, ClassTag<T> tag) {
        try {
            return package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public Option<JsonValue> parseBytes(byte[] input) {
        try {
            Option option = Option$.MODULE$.apply((Object)this.mapper().readTree(input));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)JsonValue$.MODULE$.apply((JsonNode)map_this.get()));
            return object;
        }
        catch (JsonProcessingException jsonProcessingException) {
            return None$.MODULE$;
        }
    }

    public Either<JsonProcessingException, JsonValue> tryParseBytes(byte[] input) {
        try {
            Either either;
            Either.RightProjection rightProjection = package$.MODULE$.Right().apply((Object)this.mapper().readTree(input)).right();
            if (rightProjection == null) {
                throw null;
            }
            Either.RightProjection map_this = rightProjection;
            Either either2 = map_this.e();
            if (either2 instanceof Right) {
                Object map_b = ((Right)either2).value();
                either = new Right((Object)JsonValue$.MODULE$.apply((JsonNode)map_b));
            } else {
                either = map_this.e();
            }
            return either;
        }
        catch (JsonProcessingException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public <T> Either<JsonProcessingException, T> parseBytesAs(byte[] input, ClassTag<T> tag) {
        try {
            return package$.MODULE$.Right().apply(this.mapper().readValue(input, tag.runtimeClass()));
        }
        catch (JsonProcessingException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public String legacyEncodeAsString(Object obj2) {
        String string;
        block9: {
            while (true) {
                if (obj2 == null) {
                    string = "null";
                    break block9;
                }
                if (obj2 instanceof Boolean) {
                    string = ((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)obj2))).toString();
                    break block9;
                }
                if (obj2 instanceof String) {
                    String string2 = (String)obj2;
                    string = this.mapper().writeValueAsString((Object)string2);
                    break block9;
                }
                if (obj2 instanceof Number) {
                    string = ((Number)obj2).toString();
                    break block9;
                }
                if (obj2 instanceof Map) {
                    Map map = (Map)obj2;
                    string = new StringBuilder(2).append("{").append(((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        if (x0$1 == null) {
                            throw new IllegalArgumentException(new StringBuilder(26).append("Invalid map element '").append((Object)null).append("' in ").append(obj2).toString());
                        }
                        Object k = x0$1._1();
                        Object v = x0$1._2();
                        String string = new StringBuilder(1).append(MODULE$.legacyEncodeAsString(k)).append(":").append(MODULE$.legacyEncodeAsString(v)).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).append("}").toString();
                    break block9;
                }
                if (!ScalaRunTime$.MODULE$.isArray(obj2, 1)) break;
                obj2 = Predef$.MODULE$.genericArrayOps(obj2).toSeq();
            }
            if (obj2 instanceof Iterable) {
                Iterable iterable = (Iterable)obj2;
                string = new StringBuilder(2).append("[").append(((TraversableOnce)iterable.map((Function1 & Serializable & scala.Serializable)obj -> MODULE$.legacyEncodeAsString(obj), Iterable$.MODULE$.canBuildFrom())).mkString(",")).append("]").toString();
            } else {
                if (obj2 instanceof Object) {
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unknown argument of type ").append(obj2.getClass()).append(": ").append(obj2).toString());
                }
                throw new MatchError(obj2);
            }
        }
        return string;
    }

    public String encodeAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    public byte[] encodeAsBytes(Object obj) {
        return this.mapper().writeValueAsBytes(obj);
    }

    private Json$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
    }
}

