/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$2$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfigTest;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u001db\u0001B$I\u00015CQA\u0017\u0001\u0005\u0002mCQA\u0018\u0001\u0005\u0002}CQa\u001c\u0001\u0005\u0002}CQ!\u001d\u0001\u0005\u0002}CQa\u001d\u0001\u0005\nQDa!a\u0003\u0001\t\u0003y\u0006BBA\b\u0001\u0011\u0005q\f\u0003\u0004\u0002\u0014\u0001!\ta\u0018\u0005\u0007\u0003/\u0001A\u0011A0\t\r\u0005m\u0001\u0001\"\u0001`\u0011\u0019\ty\u0002\u0001C\u0001?\"1\u00111\u0005\u0001\u0005\u0002}Cq!a\n\u0001\t\u0003\tI\u0003\u0003\u0004\u0002:\u0001!\ta\u0018\u0005\u0007\u0003{\u0001A\u0011A0\t\r\u0005]\u0003\u0001\"\u0001`\u0011\u0019\tY\u0006\u0001C\u0001?\"1\u0011q\f\u0001\u0005\u0002}Ca!a\u0019\u0001\t\u0003y\u0006BBA4\u0001\u0011\u0005q\f\u0003\u0004\u0002l\u0001!\ta\u0018\u0005\u0007\u0003_\u0002A\u0011A0\t\r\u0005M\u0004\u0001\"\u0001`\u0011\u0019\t9\b\u0001C\u0001?\"1\u00111\u0010\u0001\u0005\u0002}Ca!a \u0001\t\u0003y\u0006BBAB\u0001\u0011\u0005q\f\u0003\u0004\u0002\b\u0002!\ta\u0018\u0005\u0007\u0003\u0017\u0003A\u0011A0\t\r\u0005=\u0005\u0001\"\u0001`\u0011\u0019\t\u0019\n\u0001C\u0001?\"1\u0011q\u0013\u0001\u0005\u0002}Ca!a'\u0001\t\u0003y\u0006BBAP\u0001\u0011\u0005q\f\u0003\u0004\u0002$\u0002!\ta\u0018\u0005\u0007\u0003\u007f\u0003A\u0011A0\t\r\u0005\r\u0007\u0001\"\u0001`\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Da!!:\u0001\t\u0003y\u0006bBAu\u0001\u0011\u0005\u00111\u001e\u0005\u0007\u0005\u0013\u0001A\u0011A0\t\r\t5\u0001\u0001\"\u0001`\u0011\u0019\u0011\t\u0002\u0001C\u0001?\"1!Q\u0003\u0001\u0005\u0002}CaA!\u0007\u0001\t\u0003y\u0006B\u0002B\u000f\u0001\u0011\u0005q\f\u0003\u0004\u0003\"\u0001!\ta\u0018\u0005\u0007\u0005K\u0001A\u0011A0\t\r\t%\u0002\u0001\"\u0001`\u0011\u0019\u0011i\u0003\u0001C\u0001?\"1!\u0011\u0007\u0001\u0005\u0002}CaA!\u000e\u0001\t\u0003y\u0006B\u0002B\u001d\u0001\u0011\u0005q\f\u0003\u0004\u0003>\u0001!\ta\u0018\u0005\u0007\u0005\u0003\u0002A\u0011A0\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H\u00191!1\u000b\u0001\u0001\u0005+B!B!\u0018:\u0005\u0003\u0005\u000b\u0011\u0002B0\u0011\u0019Q\u0016\b\"\u0001\u0003f!9!QN\u001d\u0005B\t=\u0004b\u0002BKs\u0011\u0005#q\u0013\u0005\b\u0005;KD\u0011\tBP\u0011\u001d\u00119+\u000fC!\u0005SCqA!-:\t\u0003\u0012\u0019L\u0002\u0004\u0003<\u0002\u0001!Q\u0018\u0005\u000b\u0003\u001b\f%\u0011!Q\u0001\n\u0005=\u0007B\u0002.B\t\u0003\u0011)\rC\u0004\u0003L\u0006#\tE!4\t\u000f\tU\u0018\t\"\u0011\u0003x\"91qC!\u0005B\re!!E\"p]\u001aLwmQ8n[\u0006tG\rV3ti*\u0011\u0011JS\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u0017\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001O)B\u0011qJU\u0007\u0002!*\u0011\u0011KS\u0001\u0003u.L!a\u0015)\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t)\u0006,D\u0001W\u0015\t9&*A\u0003vi&d7/\u0003\u0002Z-\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001]!\ti\u0006!D\u0001I\u0003\u0015\u001a\bn\\;mI\u0016C\u0018\u000e^,ji\"tuN\u001c.fe>\u001cF/\u0019;vg>s\u0017I]4FeJ|'\u000fF\u0001a!\t\tG-D\u0001c\u0015\u0005\u0019\u0017!B:dC2\f\u0017BA3c\u0005\u0011)f.\u001b;)\u0005\t9\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0015QWO\\5u\u0015\u0005a\u0017aA8sO&\u0011a.\u001b\u0002\u0005)\u0016\u001cH/A\u0016tQ>,H\u000eZ#ySR<\u0016\u000e\u001e5O_:TVM]8Ti\u0006$Xo](o5.\u001cu.\\7b]\u0012,%O]8sQ\t\u0019q-A\u0018tQ>,H\u000eZ#ySR<\u0016\u000e\u001e5O_:TVM]8Ti\u0006$Xo](o\u0005J|7.\u001a:D_6l\u0017M\u001c3FeJ|'\u000f\u000b\u0002\u0005O\u00069\u0012m]:feRtuN\u001c.fe>\u001cF/\u0019;vg\u0016C\u0018\u000e\u001e\u000b\u0003AVDQA^\u0003A\u0002]\fA!\u0019:hgB\u0019\u0011\r\u001f>\n\u0005e\u0014'!B!se\u0006L\bcA>\u0002\u00069\u0019A0!\u0001\u0011\u0005u\u0014W\"\u0001@\u000b\u0005}d\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0004\t\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002E\u000614\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN]\"mS\u0016tGo]#oi&$\u0018\u0010V=qKV\u001b\u0018N\\4[_>\\W-\u001a9fe\"\u0012aaZ\u00015g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J,6/\u001a:t\u000b:$\u0018\u000e^=UsB,Wk]5oOj{wn[3fa\u0016\u0014\bFA\u0004h\u0003U\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'\u000fV8qS\u000e\u001cXI\u001c;jif$\u0016\u0010]3Vg&twMW8pW\u0016,\u0007/\u001a:)\u0005!9\u0017aJ:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s)>\u0004\u0018nY:F]RLG/\u001f+za\u0016D#!C4\u0002mMDw.\u001e7e!\u0006\u00148/Z!sOVlWM\u001c;t\r>\u0014(I]8lKJ\u001cXI\u001c;jif$\u0016\u0010]3Vg&twMW8pW\u0016,\u0007/\u001a:)\u0005)9\u0017\u0001K:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s\u0005J|7.\u001a:t\u000b:$\u0018\u000e^=UsB,\u0007FA\u0006h\u00039\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'O\u0011:pW\u0016\u0014Hj\\4hKJ\u001cXI\u001c;jif$\u0016\u0010]3)\u000519\u0017!\u0005;fgR\f%oZ;nK:$\b+\u0019:tKR)\u0001-a\u000b\u00020!1\u0011QF\u0007A\u0002i\f!\"\u001a8uSRLH+\u001f9f\u0011\u001d\t\t$\u0004a\u0001\u0003g\t\u0001B_6D_:4\u0017n\u001a\t\u0004C\u0006U\u0012bAA\u001cE\n9!i\\8mK\u0006t\u0017!\u0007;fgR|\u0005\u000f^5p]\u0016sG/\u001b;z)f\u0004XMT1nKND#AD4\u0002aMDw.\u001e7e\r\u0006LG.\u00134V]J,7m\\4oSN,G-\u00128uSRLH+\u001f9f+NLgn\u001a.p_.,W\r]3sQ\u0019yq-!\u0011\u0002D\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0002FA!\u0011qIA)\u001d\u0011\tI%!\u0014\u000f\u0007u\fY%C\u0001d\u0013\r\tyEY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gNC\u0002\u0002P\t\f!e\u001d5pk2$g)Y5m\u0013\u001a,fN]3d_\u001et\u0017n]3e\u000b:$\u0018\u000e^=UsB,\u0007F\u0002\th\u0003\u0003\n\u0019%\u0001\u001dtQ>,H\u000e\u001a$bS2LeM\u0011:pW\u0016\u0014XI\u001c;jif$\u0016\u0010]3Jg:{G/\u00118J]R,w-\u001a:Vg&twMW8pW\u0016,\u0007/\u001a:)\rE9\u0017\u0011IA\"\u0003)\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u0005J|7.\u001a:F]RLG/\u001f+za\u0016L5OT8u\u0003:Le\u000e^3hKJDcAE4\u0002B\u0005\r\u0013!P:i_VdGMR1jY&37\u000b[8si\n\u0013xn[3s\u000b:$\u0018\u000e^=UsB,\u0017j\u001d(pi\u0006s\u0017J\u001c;fO\u0016\u0014Xk]5oOj{wn[3fa\u0016\u0014\bFB\nh\u0003\u0003\n\u0019%A\u0018tQ>,H\u000e\u001a$bS2Lem\u00155peR\u0014%o\\6fe\u0016sG/\u001b;z)f\u0004X-S:O_R\fe.\u00138uK\u001e,'\u000f\u000b\u0004\u0015O\u0006\u0005\u00131I\u0001/g\"|W\u000f\u001c3GC&d\u0017JZ'jq\u0016$WI\u001c;jif$\u0016\u0010]3GY\u0006<7/V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0004\u0016O\u0006\u0005\u00131I\u0001$g\"|W\u000f\u001c3BI\u0012\u001cE.[3oi\u000e{gNZ5h+NLgn\u001a.p_.,W\r]3sQ\t1r-\u0001\u0012tQ>,H\u000eZ!eIR{\u0007/[2D_:4\u0017nZ+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0003/\u001d\fac\u001d5pk2$\u0017\t\u001c;feR{\u0007/[2D_:4\u0017n\u001a\u0015\u00031\u001d\fAd\u001d5pk2$G)Z:de&\u0014WmQ8oM&<7+\u001f8p]fl7\u000f\u000b\u0002\u001aO\u0006Q2\u000f[8vY\u0012\fE\r\u001a\"s_.,'/U;pi\u0006\u001cuN\u001c4jO\"\u0012!dZ\u0001\u001cg\"|W\u000f\u001c3BI\u0012\u0014%o\\6fe2{wmZ3s\u0007>tg-[4)\u0005m9\u0017a\u000f;fgRtun\u00159fG&4\u0017.\u001a3F]RLG/_(qi&|gnV5uQ\u0012+7o\u0019:jE\u0016\u0014%o\\6feNLeNW&Jg\u0006cGn\\<fI\"\u0012AdZ\u0001Ii\u0016\u001cHOT8Ta\u0016\u001c\u0017NZ5fI\u0016sG/\u001b;z\u001fB$\u0018n\u001c8XSRDG)Z:de&\u0014WM\u0011:pW\u0016\u00148/\u00138C_>$8\u000f\u001e:baN+'O^3s\u0013N\fE\u000e\\8xK\u0012D#!H4\u00027Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3BY2\u0014%o\\6fe\u000e{gNZ5hQ\tqr-\u0001\u000euKN$H)Z:de&\u0014W-\u00117m)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002 O\u0006\u0011D/Z:u\t\u0016\u001c8M]5cK\u0006cGN\u0011:pW\u0016\u00148i\u001c8gS\u001e\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u0014(+Z9vSJ,G\r\u000b\u0004!O\u0006\u0005\u00131I\u0001<i\u0016\u001cH/\u00128uSRLH)\u001a4bk2$x\n\u001d;j_:<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0005J|7.\u001a:M_\u001e<WM]%t\u001d>$\u0018\t\u001c7po\u0016$\u0007FB\u0011h\u0003\u0003\n\u0019%\u0001\u001duKN$XI\u001c;jif$UMZ1vYR|\u0005\u000f^5p]^KG\u000f[!mi\u0016\u0014(I]8lKJdunZ4fe&\u001bhj\u001c;BY2|w/\u001a3)\r\t:\u0017\u0011IA\"\u0003-\u001b\bn\\;mIJ\u000b\u0017n]3J]Z\fG.\u001b3D_:4\u0017nZ;sCRLwN\\#yG\u0016\u0004H/[8o/\",g.\u00113eS:<\u0017J\u001c<bY&$'I]8lKJdunZ4fe\u000e{gNZ5hQ\u0019\u0019s-!\u0011\u0002(\u000e\u0012\u0011\u0011\u0016\t\u0005\u0003W\u000bY,\u0004\u0002\u0002.*!\u0011qVAY\u0003\u0019)'O]8sg*!\u00111WA[\u0003\u0019\u0019w.\\7p]*\u00191*a.\u000b\u0007\u0005e6.\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003{\u000biKA\u000fJ]Z\fG.\u001b3D_:4\u0017nZ;sCRLwN\\#yG\u0016\u0004H/[8o\u0003\r\u001a\bn\\;mI\u0006#G\rR3gCVdGO\u0011:pW\u0016\u0014H)\u001f8b[&\u001c7i\u001c8gS\u001eD#\u0001J4\u00029MDw.\u001e7e\u0003\u0012$'I]8lKJ$\u0015P\\1nS\u000e\u001cuN\u001c4jO\"\u0012QeZ\u0001\u0018m\u0016\u0014\u0018NZ=BYR,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e$r\u0001YAf\u0003/\fY\u000eC\u0004\u0002N\u001a\u0002\r!a4\u0002\t9|G-\u001a\t\u0005\u0003#\f\u0019.\u0004\u0002\u00022&!\u0011Q[AY\u0005\u0011qu\u000eZ3\t\r\u0005eg\u00051\u0001{\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011\u001d\tiN\na\u0001\u0003?\fAB]3t_V\u00148-Z(qiN\u0004R!a\u0012\u0002bjLA!a9\u0002V\t!A*[:u\u0003-\u001a\bn\\;mI\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jO\n\u0013xn[3s/&$\bn\\;u\u000b:$\u0018\u000e^=OC6,\u0007FA\u0014h\u0003u1XM]5gs\u0006cG/\u001a:Ce>\\WM\u001d'pO\u001e,'oQ8oM&<G#\u00031\u0002n\u0006=\u0018\u0011_A{\u0011\u001d\ti\r\u000ba\u0001\u0003\u001fDa!!7)\u0001\u0004Q\bBBAzQ\u0001\u0007!0\u0001\u0006f]RLG/\u001f(b[\u0016Dq!a>)\u0001\u0004\tI0A\u000beKN\u001c'/\u001b2f\u0007>tg-[4F]R\u0014\u0018.Z:\u0011\r\u0005\u001d\u0013\u0011]A~!\u0011\tiP!\u0002\u000e\u0005\u0005}(bA%\u0003\u0002)!!1AA[\u0003\u001d\u0019G.[3oiNLAAa\u0002\u0002\u0000\nY1i\u001c8gS\u001e,e\u000e\u001e:z\u0003=\u001a\bn\\;mIN+\b\u000f]8si\u000e{W.\\1TKB\f'/\u0019;fIZ\u000bG.^3t+NLgn\u001a.p_.,W\r]3sQ\tIs-\u0001 tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012,e\u000e^5us:\u000bW.Z+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0007U\u001d\f\t%a\u0011\u0002aMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,G-\u00128uSRLh*Y7fQ\u0019Ys-!\u0011\u0002D\u0005YC/Z:u\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ+qI\u0006$X-V:j]\u001eTvn\\&fKB,'\u000f\u000b\u0002-O\u0006Q4\u000f[8vY\u0012tu\u000e^+qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001eLe-T1mM>\u0014X.\u001a3D_:4\u0017nZ+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0007[\u001d\f\t%a\u0011\u0002YMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,GmQ8oM&<\u0007F\u0002\u0018h\u0003\u0003\n\u0019%A!tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012\u0014%/Y2lKR\u001cuN\u001c4jOV\u001b\u0018N\\4[_>\\W-\u001a9fe\"2qfZA!\u0003\u0007\n1g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0005J\f7m[3u\u0007>tg-[4)\rA:\u0017\u0011IA\"\u0003y\u001a\bn\\;mI:{G/\u00169eCR,7i\u001c8gS\u001eLeMT8o\u000bbL7\u000f^5oO\u000e{gNZ5h\u0013N$U\r\\3uK\u0012,6/\u001b8h5>|7.\u001a9fe\"2\u0011gZA!\u0003O\u000b\u0011g\u001d5pk2$gj\u001c;Va\u0012\fG/Z\"p]\u001aLw-\u00134O_:,\u00050[:uS:<7i\u001c8gS\u001eL5\u000fR3mKR,G\r\u000b\u00043O\u0006\u0005\u0013qU\u0001\u0019g\"|W\u000f\u001c3EK2,G/\u001a\"s_.,'oQ8oM&<\u0007FA\u001ah\u0003Q!Xm\u001d;TGJ\fWn\u0011:fI\u0016tG/[1mg\"\u0012AgZ\u0001\u0016i\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jO\u0016sG/\u001b;zQ\t)t-A\fuKN$Xk]3s\u00072LWM\u001c;Rk>$\u0018m\u00149ug\"\u0012agZ\u0001\u001ai\u0016\u001cH/U;pi\u0006$Um]2sS\n,WI\u001c;ji&,7\u000f\u000b\u00028O\u0006\u0011\"/Z4jgR,'O\u0011:pW\u0016\u0014\u0018J\u001c.l)\r\u0001'\u0011\n\u0005\b\u0005\u0017B\u0004\u0019\u0001B'\u0003\tIG\rE\u0002b\u0005\u001fJ1A!\u0015c\u0005\rIe\u000e\u001e\u0002\u0013\tVlW._!e[&t'l[\"mS\u0016tGoE\u0002:\u0005/\u00022a\u0014B-\u0013\r\u0011Y\u0006\u0015\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0002\u0011i\\7\t\\5f]R\u00042a\u0014B1\u0013\r\u0011\u0019\u0007\u0015\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0015\t\t\u001d$1\u000e\t\u0004\u0005SJT\"\u0001\u0001\t\u000f\tu3\b1\u0001\u0003`\u0005\u00112\r[1oO\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0015\u0001'\u0011\u000fBA\u0011\u001d\u0011\u0019\b\u0010a\u0001\u0005k\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\r\t]$Q\u0010B'\u001b\t\u0011IHC\u0002\u0003|\t\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yH!\u001f\u0003\u0007M+\u0017\u000fC\u0004\u0003\u0004r\u0002\rA!\"\u0002\u000f\r|gNZ5hgB!!q\u0011BI\u001b\t\u0011II\u0003\u0003\u0003\f\n5\u0015\u0001B;uS2T!Aa$\u0002\t)\fg/Y\u0005\u0005\u0005'\u0013II\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011CZ3uG\",e\u000e^5us\u000e{gNZ5h)\u0019\u0011)I!'\u0003\u001c\"1\u0011QF\u001fA\u0002iDa!a=>\u0001\u0004Q\u0018\u0001F2iC:<Wm\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003a\u0005C\u0013)\u000b\u0003\u0004\u0003$z\u0002\rA_\u0001\tG2LWM\u001c;JI\"9!1\u0011 A\u0002\t\u0015\u0015AH2iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015\u0001'1\u0016BX\u0011\u0019\u0011ik\u0010a\u0001u\u0006\u00192/\u00198ji&TX\rZ#oi&$\u0018PT1nK\"9!1Q A\u0002\t\u0015\u0015!E2iC:<W\rV8qS\u000e\u001cuN\u001c4jOR)\u0001M!.\u0003:\"1!q\u0017!A\u0002i\fQ\u0001^8qS\u000eDqAa!A\u0001\u0004\u0011)I\u0001\tEk6l\u00170\u00113nS:\u001cE.[3oiN\u0019\u0011Ia0\u0011\t\u0005u(\u0011Y\u0005\u0005\u0005\u0007\fyPA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u)\u0011\u00119M!3\u0011\u0007\t%\u0014\tC\u0004\u0002N\u000e\u0003\r!a4\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$bAa4\u0003V\n-\b\u0003BA\u007f\u0005#LAAa5\u0002\u0000\n)B)Z:de&\u0014WmQ8oM&<7OU3tk2$\bb\u0002Bl\t\u0002\u0007!\u0011\\\u0001\ne\u0016\u001cx.\u001e:dKN\u0004bAa\"\u0003\\\n}\u0017\u0002\u0002Bo\u0005\u0013\u0013!bQ8mY\u0016\u001cG/[8o!\u0011\u0011\tOa:\u000e\u0005\t\r(\u0002\u0002Bs\u0003c\u000baaY8oM&<\u0017\u0002\u0002Bu\u0005G\u0014abQ8oM&<'+Z:pkJ\u001cW\rC\u0004\u0003n\u0012\u0003\rAa<\u0002\u000f=\u0004H/[8ogB!\u0011Q By\u0013\u0011\u0011\u00190a@\u0003-\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON|\u0005\u000f^5p]N\fq#\u001b8de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:\u0015\r\te(q`B\b!\u0011\tiPa?\n\t\tu\u0018q \u0002\u0013\u00032$XM]\"p]\u001aLwm\u001d*fgVdG\u000fC\u0004\u0003\u0004\u0016\u0003\ra!\u0001\u0011\u0011\t\u001d51\u0001Bp\u0007\u000fIAa!\u0002\u0003\n\n\u0019Q*\u00199\u0011\r\t\u001d%1\\B\u0005!\u0011\tipa\u0003\n\t\r5\u0011q \u0002\u000e\u00032$XM]\"p]\u001aLwm\u00149\t\u000f\t5X\t1\u0001\u0004\u0012A!\u0011Q`B\n\u0013\u0011\u0019)\"a@\u0003'\u0005cG/\u001a:D_:4\u0017nZ:PaRLwN\\:\u0002\u0019\u0005dG/\u001a:D_:4\u0017nZ:\u0015\r\te81DB\u0013\u0011\u001d\u0011\u0019I\u0012a\u0001\u0007;\u0001\u0002Ba\"\u0004\u0004\t}7q\u0004\t\u0005\u0003{\u001c\t#\u0003\u0003\u0004$\u0005}(AB\"p]\u001aLw\rC\u0004\u0003n\u001a\u0003\ra!\u0005")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--blah"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"}));
    }

    /*
     * WARNING - void declaration
     */
    private void assertNonZeroStatusExit(String[] args) {
        void setExitProcedure_exitProcedure;
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$1) -> ConfigCommandTest.$anonfun$assertNonZeroStatusExit$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityTypeUsingZookeeper() {
        this.testArgumentParse("topics", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics", false);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeUsingZookeeper() {
        this.testArgumentParse("brokers", true);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers", false);
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityType() {
        this.testArgumentParse("broker-loggers", false);
    }

    public void testArgumentParse(String entityType, boolean zkConfig) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        String shortFlag = new StringBuilder(2).append("--").append(new StringOps(entityType).dropRight(1)).toString();
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps2.size());
        Assert.assertEquals((Object)"b", (Object)addedProps2.getProperty("a"));
        Assert.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assert.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assert.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
    }

    @Test
    public void testOptionEntityTypeNames() {
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "0", "--entity-type", "brokers"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients", "--entity-name", "A", "--entity-default"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default", "--entity-name", "B", "--entity-type", "users", "--entity-type", "clients"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--broker", "0"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user-defaults"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "brokers"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityTypeUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--broker", "A", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--broker", "A", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfMixedEntityTypeFlagsUsingZookeeper() {
        new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"})).checkArgs();
    }

    @Test
    public void shouldAddClientConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(null, this.zkClient()));
    }

    @Test
    public void shouldAddTopicConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(null, this.zkClient()));
    }

    @Test
    public void shouldAlterTopicConfig() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--add-config", "delete.retention.ms=1000000,min.insync.replicas=2", "--delete-config", "unclean.leader.election.enable"}));
        BooleanRef alteredConfigs = BooleanRef.create((boolean)false);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "1"), (List)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", "1"), (List)Nil$.MODULE$))).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String resourceName$1;
            private final DescribeConfigsResult describeResult$1;
            private final BooleanRef alteredConfigs$1;
            private final AlterConfigsResult alterResult$1;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$1);
                return this.describeResult$1;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Assert.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("delete.retention.ms", "1000000"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "2"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", ""), AlterConfigOp.OpType.DELETE)}))), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toSet());
                this.alteredConfigs$1.elem = true;
                return this.alterResult$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resourceName$1 = resourceName$1;
                this.describeResult$1 = describeResult$1;
                this.alteredConfigs$1 = alteredConfigs$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldDescribeConfigSynonyms() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--describe", "--all"}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(Collections.emptyList())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resource, describeResult){
            private final ConfigResource resource$1;
            private final DescribeConfigsResult describeResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.resource$1})), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(resources).asScala()).toSet());
                return this.describeResult$2;
            }
            {
                this.resource$1 = resource$1;
                this.describeResult$2 = describeResult$2;
                super(Collections.singletonList(node$2), node$2);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.log.LogCleaner", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.ReplicaManager", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$))));
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInZKIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--zookeeper", (List)new .colon.colon((Object)this.zkConnect(), (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInBootstrapServerIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllBrokerConfig() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllTopicConfig() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Topic(), "--entity-name", "foo", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDescribeAllBrokerConfigBootstrapServerRequired() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithDescribeBrokerLoggerIsNotAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigCommand$.MODULE$.BrokerLoggerConfigType(), (List)new .colon.colon((Object)"--entity-default", (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$))))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithAlterBrokerLoggerIsNotAllowed() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--entity-default", "--alter", "--add-config", "kafka.log.LogCleaner=DEBUG"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldRaiseInvalidConfigurationExceptionWhenAddingInvalidBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)new .colon.colon((Object)"--entity-default", (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)new .colon.colon((Object)"--entity-name", (List)new .colon.colon((Object)"1", (List)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        List optsList = (List)new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)"brokers", (List)new .colon.colon((Object)"--alter", (List)new .colon.colon((Object)"--add-config", (List)new .colon.colon((Object)"message.max.bytes=10", (List)Nil$.MODULE$))))))).$plus$plus(resourceOpts, List$.MODULE$.canBuildFrom());
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = "5";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, brokerConfigs, alterResult){
            private final String resourceName$2;
            private final DescribeConfigsResult describeResult$3;
            private final scala.collection.mutable.Map brokerConfigs$1;
            private final AlterConfigsResult alterResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$2, (Object)resource.name());
                return this.describeResult$3;
            }

            public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> $this.brokerConfigs$1.put((Object)e.name(), (Object)e.value()));
                return this.alterResult$2;
            }
            {
                this.resourceName$2 = resourceName$2;
                this.describeResult$3 = describeResult$3;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.alterResult$2 = alterResult$2;
                super(Collections.singletonList(node$3), node$3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterConfigs$1(kafka.admin.ConfigCommandTest$$anon$3 org.apache.kafka.clients.admin.ConfigEntry )}, serializedLambda);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Tuple2[] tuple2Array2 = new Tuple2[2];
        String string2 = "10";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.bytes");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string3 = "5";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)brokerConfigs.toMap(Predef$.MODULE$.$conforms()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldDescribeConfigBrokerWithoutEntityName() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--describe"}));
        String BrokerDefaultEntityName = "";
        ConfigResource resourceCustom = new ConfigResource(ConfigResource.Type.BROKER, "1");
        ConfigResource resourceDefault = new ConfigResource(ConfigResource.Type.BROKER, BrokerDefaultEntityName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        Config emptyConfig = new Config(Collections.emptyList());
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)resourceCustom);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)emptyConfig);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)resourceDefault);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)emptyConfig);
        java.util.Map resultMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        future.complete((Object)resultMap);
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).times(2);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceCustom, resourceDefault, describeResult){
            private final ConfigResource resourceCustom$1;
            private final ConfigResource resourceDefault$1;
            private final DescribeConfigsResult describeResult$4;

            /*
             * Unable to fully structure code
             */
            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                v0 = this.resourceCustom$1.name();
                var4_4 = resource.name();
                if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
                v1 = this.resourceDefault$1.name();
                var5_5 = resource.name();
                if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                Assert.assertTrue((boolean)v2);
                Assert.assertEquals((long)1L, (long)resources.size());
                return this.describeResult$4;
            }
            {
                this.resourceCustom$1 = resourceCustom$1;
                this.resourceDefault$1 = resourceDefault$1;
                this.describeResult$4 = describeResult$4;
                super(Collections.singletonList(node$4), node$4);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.verify((Object[])new Object[]{describeResult});
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    public void verifyAlterBrokerLoggerConfig(Node node, String resourceName, String entityName, List<ConfigEntry> describeConfigEntries) {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--alter", "--entity-name", entityName, "--add-config", "kafka.log.LogCleaner=DEBUG", "--delete-config", "kafka.server.ReplicaManager,kafka.server.KafkaApi"}));
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        BooleanRef alteredConfigs = BooleanRef.create((boolean)false);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(describeConfigEntries).asJava())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final String resourceName$3;
            private final DescribeConfigsResult describeResult$5;
            private final BooleanRef alteredConfigs$2;
            private final AlterConfigsResult alterResult$3;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$3, (Object)resource.name());
                return this.describeResult$5;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Assert.assertEquals((Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "DEBUG"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaApi", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toList());
                this.alteredConfigs$2.elem = true;
                return this.alterResult$3;
            }
            {
                this.resourceName$3 = resourceName$3;
                this.describeResult$5 = describeResult$5;
                this.alteredConfigs$2 = alteredConfigs$2;
                this.alterResult$3 = alterResult$3;
                super(Collections.singletonList(node$5), node$5);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValuesUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(null, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityNameUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_$this13;
        void $minus$greater$extension_y14;
        void $minus$greater$extension_$this14;
        void $minus$greater$extension_y15;
        void $minus$greater$extension_$this15;
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        String[] alterOpts = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"});
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = "110000";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y15);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Tuple2[] tuple2Array2 = new Tuple2[1];
        String string2 = "120000";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y14);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Option)None$.MODULE$, alterOpts, adminZkClient);
        Tuple2[] tuple2Array3 = new Tuple2[1];
        String string3 = "130000";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y13);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Tuple2[] tuple2Array4 = new Tuple2[1];
        String string4 = "140000";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)), (Option)None$.MODULE$, alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)None$.MODULE$, alterOpts, adminZkClient);
        Tuple2[] tuple2Array5 = new Tuple2[1];
        String string5 = "/tmp/test.jks";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5)), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "/tmp/test.jks";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "/tmp/test.jks";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"})), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "secret";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        Tuple2[] tuple2Array6 = new Tuple2[2];
        String string6 = "secret";
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        String string7 = "2";
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[1] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6));
        Tuple2[] tuple2Array7 = new Tuple2[1];
        String string8 = "encoder-secret";
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7));
        this.alterConfigWithZk$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, alterOpts, adminZkClient);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assert.assertFalse((String)"Encoder secret stored in ZooKeeper", (boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()));
        Assert.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assert.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assert.assertEquals((long)configs.size(), (long)brokerConfigs.size());
        Tuple2[] tuple2Array8 = new Tuple2[1];
        String string9 = "secret2";
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.password");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array8[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array8));
        Tuple2[] tuple2Array9 = new Tuple2[5];
        String string10 = "encoder-secret";
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        String string11 = "DES/CBC/PKCS5Padding";
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        String string12 = "1024";
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string13 = "PBKDF2WithHmacSHA1";
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string14 = "64";
        Object object14 = Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array9));
        this.alterConfigWithZk$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, alterOpts, adminZkClient);
        String encodedPassword2 = this.zkClient().getEntityConfigs("brokers", brokerId).getProperty("listener.name.internal.ssl.keystore.password");
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterConfigWithZk$1(configs, (Option)None$.MODULE$, encoderConfigs, alterOpts, adminZkClient), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.registerBrokerInZk(new StringOps(brokerId).toInt());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "210000";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = "220000";
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
        Tuple2[] tuple2Array10 = new Tuple2[1];
        String string15 = "230000";
        Object object15 = Predef$.MODULE$.ArrowAssoc((Object)"message.max.size");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array10[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array10)), (Option)new Some((Object)"2"), alterOpts, adminZkClient);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeletedUsingZookeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeleted() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult){
            private final String resourceName$4;
            private final DescribeConfigsResult describeResult$6;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$4);
                return this.describeResult$6;
            }
            {
                this.resourceName$4 = resourceName$4;
                this.describeResult$6 = describeResult$6;
                super(Collections.singletonList(node$6), node$6);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, createOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(null, this.zkClient()));
    }

    @Test
    public void testScramCredentials() {
        LazyRef CredentialChange$module = new LazyRef();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$1
        extends AdminZkClient
        implements Product,
        scala.Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final scala.collection.mutable.Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0 & Serializable & scala.Serializable)() -> new Properties());
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
                    String value = configChange.getProperty((String)mechanism);
                    Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    Assert.assertEquals((long)this.iterations(), (long)scramCredential.iterations());
                    return $this.credentials$1.put((Object)this.user(), (Object)configChange);
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$1 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$1(this.$outer, user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return this.user();
                    }
                    case 1: {
                        return this.mechanisms();
                    }
                    case 2: {
                        return BoxesRunTime.boxToInteger((int)this.iterations());
                    }
                }
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1;
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.user())), (int)Statics.anyHash(this.mechanisms())), (int)this.iterations()), (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                if (!(x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$1 var3_3 = (Kafka_admin_ConfigCommandTest$CredentialChange$1)((Object)x$1);
                String string = this.user();
                String string2 = var3_3.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var3_3.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var3_3.iterations()) return false;
                if (!var3_3.canEqual((Object)((Object)this))) return false;
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$1(String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
                Product.$init$((Product)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetchEntityConfig$1(), $anonfun$changeUserOrUserClientIdConfig$1(kafka.admin.ConfigCommandTest$CredentialChange$1 java.util.Properties java.lang.String )}, serializedLambda);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsA, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsB, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del256, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del512, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$1(this, clientId, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$2(this, principal, sanitizedPrincipal, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1 & Serializable & scala.Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$3(this, principal, userClient, clientId, sanitizedPrincipal, describeOpts, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder(8).append(sanitizedPrincipal).append("/clients").toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(8).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", new StringBuilder(9).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/").append(Sanitizer.sanitize((String)"client1?@%")).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaDescribeEntities() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"clients");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        Tuple2[] tuple2Array2 = new Tuple2[1];
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"users");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        ConfigCommandTest.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append(sanitizedPrincipal).append("/clients/<default>").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        Tuple2[] tuple2Array3 = new Tuple2[1];
        GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-4").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        Tuple2[] tuple2Array4 = new Tuple2[1];
        GenTraversable genTraversable4 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"}));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        Tuple2[] tuple2Array5 = new Tuple2[1];
        GenTraversable genTraversable5 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"}));
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5));
        Tuple2[] tuple2Array6 = new Tuple2[1];
        GenTraversable genTraversable6 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"}));
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6));
        Tuple2[] tuple2Array7 = new Tuple2[1];
        GenTraversable genTraversable7 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)"users");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ConfigCommandTest.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-2").toString()})), zkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$), ApiVersion$.MODULE$.latestVersion(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertNonZeroStatusExit$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    private final void testExpectedEntityTypeNames$1(List expectedTypes, List expectedNames, Seq args) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe"})).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        createOpts.checkArgs();
        Assert.assertEquals((Object)createOpts.entityTypes(), (Object)expectedTypes);
        Assert.assertEquals((Object)createOpts.entityNames(), (Object)expectedNames);
    }

    public static final ConfigEntry kafka$admin$ConfigCommandTest$$newConfigEntry$1(String name, String value) {
        return ConfigTest.newConfigEntry((String)name, (String)value, (ConfigEntry.ConfigSource)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, (boolean)false, (boolean)false, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()));
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1(String id) {
        return (String[])((Object[])new String[]{"--entity-name", id});
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() {
        return (String[])((Object[])new String[]{"--entity-default"});
    }

    private static final String[] entityOpt$1(Option brokerId) {
        if (brokerId == null) {
            throw null;
        }
        Object object = brokerId.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1((String)brokerId.get()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() : object.get();
        return object2;
    }

    private final void alterConfigWithZk$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        String configStr = ((TraversableOnce)configs.$plus$plus((GenTraversableOnce)encoderConfigs).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.entityOpt$1(brokerId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--add-config", configStr})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), addOpts, adminZkClient$1);
    }

    private static final scala.collection.immutable.Map alterConfigWithZk$default$3$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        if (brokerId == null) {
            throw null;
        }
        Object object = brokerId.isEmpty() ? ConfigEntityName$.MODULE$.Default() : brokerId.get();
        Properties entityConfigs = this.zkClient().getEntityConfigs("brokers", (String)object);
        Assert.assertEquals((Object)configs, (Object)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        this.alterConfigWithZk$1(configs, brokerId, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts$1, adminZkClient$1);
        this.verifyConfig$1(configs, brokerId);
    }

    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])alterOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.entityOpt$1(brokerId))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--delete-config", configNames.mkString(",")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), deleteOpts, adminZkClient$1);
        this.verifyConfig$1(Predef$.MODULE$.Map().empty(), brokerId);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final /* synthetic */ ConfigCommandTest$CredentialChange$2$ CredentialChange$lzycompute$1(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        synchronized (CredentialChange$module$1) {
            ConfigCommandTest$CredentialChange$2$ configCommandTest$CredentialChange$2$ = CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.value()) : (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.initialize((Object)new ConfigCommandTest$CredentialChange$2$(this, credentials$1)));
            return configCommandTest$CredentialChange$2$;
        }
    }

    private final ConfigCommandTest$CredentialChange$2$ CredentialChange$3(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        if (CredentialChange$module$1.initialized()) {
            return (ConfigCommandTest$CredentialChange$2$)((Object)CredentialChange$module$1.value());
        }
        return this.CredentialChange$lzycompute$1(CredentialChange$module$1, credentials$1);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        String[] stringArray;
        String[] optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
        if (entityName instanceof Some) {
            String name = (String)((Some)entityName).value();
            stringArray = (String[])((Object[])new String[]{"--entity-name", name});
        } else if (None$.MODULE$.equals(entityName)) {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)entityName);
        }
        return new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])optArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            Assert.fail((String)"Did not fail with invalid argument list");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$1(ConfigCommandTest $this, String clientId$1, String[] opts) {
        $this.checkEntity$1("clients", (Option)new Some((Object)clientId$1), clientId$1, opts);
        $this.checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$2(ConfigCommandTest $this, String principal$1, String sanitizedPrincipal$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1, opts);
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    private static final String[] clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$3(ConfigCommandTest $this, String principal$1, String userClient$1, String clientId$1, String sanitizedPrincipal$1, String[] describeOpts$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), userClient$1, (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), new StringBuilder(9).append(sanitizedPrincipal$1).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(clientId$1).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeOpts$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(clientId$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigCommandTest.clientIdOpts$1(""))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()})).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private static final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])opts)).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Seq values = (Seq)x0$1._2();
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
            return iExpectationSetters;
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1 & Serializable & scala.Serializable)e -> e.fullSanitizedName(), Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminClient
    extends MockAdminClient {
        public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
            return (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        }

        public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminClient(Node node) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

