/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rEg\u0001\u0002.\\\u0001\u0001DQa\u001a\u0001\u0005\u0002!Dqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004{\u0001\u0001\u0006I!\u001c\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nuD\u0011\"!\u0002\u0001\u0005\u0004%\t!a\u0002\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0013A\u0011\"a\u0006\u0001\u0005\u0004%\t!!\u0007\t\u0011\u0005\r\u0003\u0001)A\u0005\u00037Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002^\u0001!\t!a\u0012\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002H!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003\u0017\u0003A\u0011BAG\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!!*\u0001\t\u0013\t9\u000bC\u0004\u0002V\u0002!\t!a\u0012\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u001d\u0003bBAq\u0001\u0011\u0005\u0011q\t\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\ti\u000f\u0001C\u0001\u0003\u000fBq!!=\u0001\t\u0003\t9\u0005C\u0004\u0002v\u0002!I!a>\t\u000f\u0005m\b\u0001\"\u0001\u0002H!9\u0011q \u0001\u0005\n\t\u0005\u0001b\u0002B\t\u0001\u0011%!1\u0003\u0005\b\u00053\u0001A\u0011AA$\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003\u000fBqA!\t\u0001\t\u0013\u0011\u0019\u0003C\u0004\u0003(\u0001!\t!a\u0012\t\u000f\t-\u0002\u0001\"\u0001\u0002H!9!q\u0006\u0001\u0005\n\tE\u0002b\u0002B\u001b\u0001\u0011\u0005\u0011q\t\u0005\b\u0005s\u0001A\u0011AA$\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007fAqA!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0003J\u0001!\t!a\u0012\t\u000f\t5\u0003\u0001\"\u0001\u0002H!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B,\u0001\u0011\u0005\u0011q\t\u0005\b\u00057\u0002A\u0011AA$\u0011\u001d\u0011i\u0007\u0001C\u0001\u0003\u000fBqA!\u001d\u0001\t\u0003\t9\u0005C\u0004\u0003v\u0001!\t!a\u0012\t\u000f\te\u0004\u0001\"\u0001\u0002H!9!Q\u0010\u0001\u0005\u0002\u0005\u001d\u0003b\u0002BA\u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u000b\u0003A\u0011AA$\u0011\u001d\u0011I\t\u0001C\u0001\u0003\u000fBqA!$\u0001\t\u0003\t9\u0005C\u0004\u0003\u0012\u0002!\t!a\u0012\t\u000f\tU\u0005\u0001\"\u0001\u0002H!9!\u0011\u0014\u0001\u0005\u0002\u0005\u001d\u0003b\u0002BO\u0001\u0011\u0005\u0011q\t\u0005\b\u0005C\u0003A\u0011AA$\u0011\u001d\u0011i\u000b\u0001C\u0001\u0003\u000fBqA!-\u0001\t\u0003\t9\u0005C\u0004\u00036\u0002!\t!a\u0012\t\u000f\te\u0006\u0001\"\u0001\u0002H!9!Q\u0018\u0001\u0005\u0002\u0005\u001d\u0003b\u0002Ba\u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u000b\u0004A\u0011AA$\u0011\u001d\u0011I\r\u0001C\u0001\u0003\u000fBqAa7\u0001\t\u0003\t9\u0005C\u0004\u0003`\u0002!\t!a\u0012\t\u000f\t\r\b\u0001\"\u0001\u0002H!9!q\u001d\u0001\u0005\u0002\u0005\u001d\u0003b\u0002Bv\u0001\u0011\u0005\u0011q\t\u0005\b\u0005_\u0004A\u0011AA$\u0011\u001d\u0011Y\u0010\u0001C\u0001\u0003\u000fBqAa@\u0001\t\u0003\t9\u0005C\u0004\u0004\u0004\u0001!\t!a\u0012\t\u000f\r\u001d\u0001\u0001\"\u0001\u0002H!911\u0002\u0001\u0005\u0002\u0005\u001d\u0003bBB\b\u0001\u0011%1\u0011\u0003\u0005\b\u0007O\u0001A\u0011BB\u0015\u0011%\u0019i\u0004AI\u0001\n\u0013\u0019y\u0004C\u0004\u0004V\u0001!Iaa\u0016\t\u0013\r}\u0003!%A\u0005\n\r}\u0002\"CB1\u0001E\u0005I\u0011BB2\u0011\u001d\u00199\u0007\u0001C\u0005\u0007SBqa!\u001d\u0001\t\u0003\u0019\u0019\bC\u0004\u0004|\u0001!Ia! \t\u000f\r\u001d\u0005\u0001\"\u0003\u0004\n\"91Q\u0013\u0001\u0005\u0002\r]\u0005bBBS\u0001\u0011\u00051q\u0015\u0005\b\u0007g\u0003A\u0011AB[\u0005Aaun\u001a,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002];\u0006\u0019An\\4\u000b\u0003y\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A5\u0011\u0005)\u0004Q\"A.\u0002\tQLW.Z\u000b\u0002[B\u0011a\u000e_\u0007\u0002_*\u0011\u0001/]\u0001\u0006kRLGn\u001d\u0006\u0003eN\faaY8n[>t'B\u00010u\u0015\t)h/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0006\u0019qN]4\n\u0005e|'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001~!\tqx0D\u0001r\u0013\r\t\t!\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\t\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!X\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005M\u0011Q\u0002\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u00035iW\r\u001e:jGN\\U-_*fiV\u0011\u00111\u0004\t\u0007\u0003;\t9#a\u000b\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tq!\\;uC\ndWMC\u0002\u0002&\r\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0007M+G\u000f\u0005\u0003\u0002.\u0005}RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t\r|'/\u001a\u0006\u0005\u0003k\t9$A\u0004nKR\u0014\u0018nY:\u000b\t\u0005e\u00121H\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005u\u0012aA2p[&!\u0011\u0011IA\u0018\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u000f[\u0016$(/[2t\u0017\u0016L8+\u001a;!\u0003A!Xm\u001d;P]2LxJ\\3CCR\u001c\u0007\u000e\u0006\u0002\u0002JA\u0019!-a\u0013\n\u0007\u000553M\u0001\u0003V]&$\bf\u0001\u0006\u0002RA!\u00111KA-\u001b\t\t)FC\u0002\u0002XY\fQA[;oSRLA!a\u0017\u0002V\t!A+Z:u\u0003M!Xm\u001d;BY2|w/T;mi&\u0014\u0015\r^2iQ\rY\u0011\u0011K\u00015i\u0016\u001cHOV1mS\u0012\fG/[8o\u001f\u001a\u0014\u0015\r^2iKN<\u0016\u000e\u001e5O_:\u001cV-];f]RL\u0017\r\\%o]\u0016\u0014xJ\u001a4tKR\u001c\bf\u0001\u0007\u0002R\u0005\tB/Z:u\u001b&\u001cX*\u0019;dQ6\u000bw-[2)\u00075\t\t&A\tdQ\u0016\u001c7n\u00148ms>sWMQ1uG\"$\u0002\"!\u0013\u0002n\u0005]\u0014q\u0011\u0005\b\u0003_r\u0001\u0019AA9\u0003\u0015i\u0017mZ5d!\r\u0011\u00171O\u0005\u0004\u0003k\u001a'\u0001\u0002\"zi\u0016Dq!!\u001f\u000f\u0001\u0004\tY(A\u000bt_V\u00148-Z\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!r\u0003\u0019\u0011XmY8sI&!\u0011QQA@\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007bBAE\u001d\u0001\u0007\u00111P\u0001\u0016i\u0006\u0014x-\u001a;D_6\u0004(/Z:tS>tG+\u001f9f\u0003Q\u0019\u0007.Z2l\u00032dwn^'vYRL')\u0019;dQRA\u0011\u0011JAH\u0003#\u000b\u0019\nC\u0004\u0002p=\u0001\r!!\u001d\t\u000f\u0005et\u00021\u0001\u0002|!9\u0011\u0011R\bA\u0002\u0005m\u0014AE2iK\u000e\\W*[:nCR\u001c\u0007.T1hS\u000e$\u0002\"!\u0013\u0002\u001a\u0006u\u0015\u0011\u0015\u0005\b\u00037\u0003\u0002\u0019AA9\u0003)\u0011\u0017\r^2i\u001b\u0006<\u0017n\u0019\u0005\b\u0003?\u0003\u0002\u0019AA9\u0003-\u0011XmY8sI6\u000bw-[2\t\u000f\u0005\r\u0006\u00031\u0001\u0002|\u0005y1m\\7qe\u0016\u001c8/[8o)f\u0004X-\u0001\twC2LG-\u0019;f\u001b\u0016\u001c8/Y4fgRQ\u0011\u0011VAc\u0003\u001f\f\t.a5\u0011\t\u0005-\u0016q\u0018\b\u0005\u0003[\u000bYL\u0004\u0003\u00020\u0006ef\u0002BAY\u0003ok!!a-\u000b\u0007\u0005Uv,\u0001\u0004=e>|GOP\u0005\u0002=&\u0011A,X\u0005\u0004\u0003{[\u0016\u0001\u0004'pOZ\u000bG.\u001b3bi>\u0014\u0018\u0002BAa\u0003\u0007\u0014qDV1mS\u0012\fG/[8o\u0003:$wJ\u001a4tKR\f5o]5h]J+7/\u001e7u\u0015\r\til\u0017\u0005\b\u0003\u000f\f\u0002\u0019AAe\u0003\u001d\u0011XmY8sIN\u0004B!! \u0002L&!\u0011QZA@\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011qN\tA\u0002\u0005E\u0004bBA=#\u0001\u0007\u00111\u0010\u0005\b\u0003\u0013\u000b\u0002\u0019AA>\u0003\u0001\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007I\t\t&A\u0010dQ\u0016\u001c7\u000eT8h\u0003B\u0004XM\u001c3US6,gj\u001c8D_6\u0004(/Z:tK\u0012$B!!\u0013\u0002^\"9\u0011qN\nA\u0002\u0005E\u0014\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-J\nA\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bNU3d_6\u0004(/Z:tS>tg+\r\u0015\u0004+\u0005E\u0013aI2iK\u000e\\Gj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5SK\u000e|W\u000e\u001d:fgNLwN\u001c\u000b\u0005\u0003\u0013\nI\u000fC\u0004\u0002lZ\u0001\r!!\u001d\u0002\u0017Q\f'oZ3u\u001b\u0006<\u0017nY\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u001aq#!\u0015\u0002OQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWmV5uQ>,HOU3d_6\u0004(/Z:tS>tg+\r\u0015\u00041\u0005E\u0013AJ2iK\u000e\\Gj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5pkR\u0014VmY8naJ,7o]5p]R!\u0011\u0011JA}\u0011\u001d\ty'\u0007a\u0001\u0003c\nA\u0005^3ti&sg/\u00197jI>3gm]3u%\u0006tw-Z!oIJ+7m\u001c:e\u0007>,h\u000e\u001e\u0015\u00045\u0005E\u0013\u0001I1tg\u0016\u0014H/\u00138wC2LGMQ1uG\"\u001cu.\u001e8u\u001fZ,'O]5eKN$b!!\u0013\u0003\u0004\t5\u0001b\u0002B\u00037\u0001\u0007!qA\u0001\u0010Y\u0006\u001cHo\u00144gg\u0016$H)\u001a7uCB\u0019!M!\u0003\n\u0007\t-1MA\u0002J]RDqAa\u0004\u001c\u0001\u0004\u00119!A\u0003d_VtG/A\u0013wC2LG-\u0019;f%\u0016\u001cwN\u001d3CCR\u001c\u0007nV5uQ\u000e{WO\u001c;Pm\u0016\u0014(/\u001b3fgR1\u0011\u0011\nB\u000b\u0005/AqA!\u0002\u001d\u0001\u0004\u00119\u0001C\u0004\u0003\u0010q\u0001\rAa\u0002\u0002OQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWmV5uQ>,HOU3d_6\u0004(/Z:tS>tgK\r\u0015\u0004;\u0005E\u0013a\u0005;fgRtuN\\\"p[B\u0014Xm]:fIZ\u000b\u0004f\u0001\u0010\u0002R\u0005\u00112\r[3dW:{gnQ8naJ,7o]3e)\u0011\tIE!\n\t\u000f\u0005=t\u00041\u0001\u0002r\u0005\u0019B/Z:u\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u001a\u0001%!\u0015\u0002'Q,7\u000f\u001e*fG>l\u0007O]3tg&|gNV\u0019)\u0007\u0005\n\t&\u0001\ndQ\u0016\u001c7NU3d_6\u0004(/Z:tS>tG\u0003BA%\u0005gAq!a\u001c#\u0001\u0004\t\t(A\nuKN$(+Z2p[B\u0014Xm]:j_:4&\u0007K\u0002$\u0003#\n\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0006\u0007V8Wc!\u001aA%!\u0015\u0002C\rDWmY6De\u0016\fG/\u001a+j[\u0016,\u0006oQ8om\u0016\u00148/[8o\rJ|WN\u0016\u0019\u0015\t\u0005%#\u0011\t\u0005\b\u0005\u0007*\u0003\u0019AA9\u0003\u001d!x.T1hS\u000e\f\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0006\u0007V8We!\u001aa%!\u0015\u0002AQ,7\u000f^\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WcQ{gK\r\u0015\u0004O\u0005E\u0013\u0001\u0005;fgR\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\rA\u0013\u0011K\u0001\u0010G\",7m[\"p[B\u0014Xm]:fIR!\u0011\u0011\nB+\u0011\u001d\ty'\u000ba\u0001\u0003c\n\u0001\u0003^3ti\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u0007)\n\t&\u0001\u0013uKN$\u0018J\u001c<bY&$7I]3bi\u0016$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\u001dY\u0013\u0011\u000bB0\u0005C\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0005G\u0002BA!\u001a\u0003j5\u0011!q\r\u0006\u0003evKAAa\u001b\u0003h\tI\"+Z2pe\u00124\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8o\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u0013\u0004f\u0002\u0017\u0002R\t}#\u0011M\u0001\"i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,G+[7f\u0007>l\u0007O]3tg\u0016$g+\r\u0015\b[\u0005E#q\fB1\u0003\u0005\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\u001dq\u0013\u0011\u000bB0\u0005C\n\u0011\u0006^3ti\u0006\u00137o\u001c7vi\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGOT8o\u0007>l\u0007O]3tg\u0016$\u0007fA\u0018\u0002R\u00051C/Z:u\u0003\n\u001cx\u000e\\;uK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$8i\\7qe\u0016\u001c8/\u001a3)\u0007A\n\t&A\u0016uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,2Q\r\t\u0014\u0011K\u0001,i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u001a!'!\u0015\u0002QQ,7\u000f\u001e*fY\u0006$\u0018N^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007M\n\t&\u0001\u0015uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;D_6\u0004(/Z:tK\u00124&\u0007K\u00025\u0003#\n\u0001\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{g+\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u00026\u0003#\n\u0001\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{gK\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u00027\u0003#\nQ\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{g+M\"p[B\u0014Xm]:fI\"\u001aq'!\u0015\u0002kQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-J\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004q\u0005E\u0013a\n;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^!mY><X\r\u001a$s_6\u001cE.[3oiNDs!OA)\u0005?\u0012)k\t\u0002\u0003(B\u0019aP!+\n\u0007\t-\u0016O\u0001\fJ]Z\fG.\u001b3SK\u000e|'\u000fZ#yG\u0016\u0004H/[8o\u0003}!Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000fZ:O_R\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004u\u0005E\u0013A\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4\u0016\u0007V8Wa9{gnQ8naJ,7o]3eQ\rY\u0014\u0011K\u00018i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gNV\u0019U_Z\u00034i\\7qe\u0016\u001c8/\u001a3)\u0007q\n\t&\u0001\u001duKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u000bDk\u001c,3\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007u\n\t&A\u001buKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u000bDk\u001c,3\u0007>l\u0007O]3tg\u0016$\u0007f\u0001 \u0002R\u0005QD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vNV\u0019O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u007f\u0005E\u0013a\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4&\u0007V8Wc\r{W\u000e\u001d:fgN,G\rK\u0002A\u0003#\nA\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]>3GK]1og\u0006\u001cG/[8oC2\u0014VmY8sINtu\u000e\u001e)fe6LG\u000f^3eQ\u001d\t\u0015\u0011\u000bB0\u0005\u001b\u001c#Aa4\u0011\t\tE'q[\u0007\u0003\u0005'T1A!6r\u0003\u0019)'O]8sg&!!\u0011\u001cBj\u0005\u0011*fn];qa>\u0014H/\u001a3G_JlUm]:bO\u00164uN]7bi\u0016C8-\u001a9uS>t\u0017!\r;fgR$un\u001e8D_:4XM]:j_:|e-\u00133f[B|G/\u001a8u%\u0016\u001cwN\u001d3t\u001d>$\b+\u001a:nSR$X\r\u001a\u0015\b\u0005\u0006E#q\fBg\u0003i\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WeQ{g\u000b\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u0002D\u0003#\nq\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,1\u0007>l\u0007O]3tg\u0016$\u0007f\u0001#\u0002R\u0005\u0011D/Z:u\u001d>t\u0017J\\2sK\u0006\u001c\u0018N\\4PM\u001a\u001cX\r\u001e*fG>\u0014HMQ1uG\"D\u0015m]'fiJL7m\u001d'pO\u001e,G\rK\u0002F\u0003#\n1\u0006^3ti\u000e{W\u000e\u001d:fgN,GMQ1uG\"<\u0016\u000e\u001e5pkR\u0014VmY8sINtu\u000e^!mY><X\r\u001a\u0015\b\r\u0006E#q\fBS\u0003-\"Xm\u001d;['R$7i\\7qe\u0016\u001c8/\u001a3XSRDWK\\1wC&d\u0017M\u00197f\u0013\n\u0003f+\u001a:tS>t\u0007fB$\u0002R\t}#1_\u0012\u0003\u0005k\u0004BA!5\u0003x&!!\u0011 Bj\u0005\r*fn];qa>\u0014H/\u001a3D_6\u0004(/Z:tS>tG+\u001f9f\u000bb\u001cW\r\u001d;j_:\fQ\u0006^3tiVs7m\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\u001dA\u0015\u0011\u000bB0\u0005K\u000bQ\u0006^3tiJ+7m\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\u001dI\u0015\u0011\u000bB0\u0005K\u000b!\u0006^3ti&sg/\u00197jIRKW.Z:uC6\u0004X\t_2faRLwN\u001c%bg\n\u000bGo\u00195J]\u0012,\u0007\u0010K\u0002K\u0003#\nq\u0005^3ti&sg/\u00197jIJ+7m\u001c:e\u000bb\u001cW\r\u001d;j_:D\u0015m\u001d\"bi\u000eD\u0017J\u001c3fq\"\u001a1*!\u0015\u0002]Q,7\u000f\u001e\"bi\u000eDw+\u001b;i\u0013:4\u0018\r\\5e%\u0016\u001cwN\u001d3t\u0003:$\u0017J\u001c<bY&$G+[7fgR\fW\u000e\u001d\u0015\u0004\u0019\u0006E\u0013!\t;fgR\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$GCBA%\u0007'\u0019\u0019\u0003C\u0004\u0004\u00165\u0003\raa\u0006\u0002\u0017M|WO]2f\u0007>$Wm\u0019\t\u0005\u00073\u0019y\"\u0004\u0002\u0004\u001c)\u00191QD/\u0002\u000f5,7o]1hK&!1\u0011EB\u000e\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u0004\u0004&5\u0003\raa\u0006\u0002\u0017Q\f'oZ3u\u0007>$WmY\u0001\u000eGJ,\u0017\r^3SK\u000e|'\u000fZ:\u0015\u0011\u0005%71FB\u0018\u0007sAqa!\fO\u0001\u0004\t\t(\u0001\u0006nC\u001eL7MV1mk\u0016D\u0011b!\rO!\u0003\u0005\raa\r\u0002\u0013QLW.Z:uC6\u0004\bc\u00012\u00046%\u00191qG2\u0003\t1{gn\u001a\u0005\b\u0007wq\u0005\u0019AA>\u0003\u0015\u0019w\u000eZ3d\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$#'\u0006\u0002\u0004B)\"11GB\"W\t\u0019)\u0005\u0005\u0003\u0004H\rESBAB%\u0015\u0011\u0019Ye!\u0014\u0002\u0013Ut7\r[3dW\u0016$'bAB(G\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rM3\u0011\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001I2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$\u0002\"!3\u0004Z\rm3Q\f\u0005\b\u0007[\u0001\u0006\u0019AA9\u0011%\u0019\t\u0004\u0015I\u0001\u0002\u0004\u0019\u0019\u0004C\u0005\u0004<A\u0003\n\u00111\u0001\u0002|\u0005Q3M]3bi\u0016tuN\\%oGJ,\u0017m]5oO>3gm]3u%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012\u0014AK2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0003\u0007KRC!a\u001f\u0004D\u000592M]3bi\u0016$vo\u001c\"bi\u000eDW\r\u001a*fG>\u0014Hm\u001d\u000b\t\u0003\u0013\u001cYg!\u001c\u0004p!91QF*A\u0002\u0005E\u0004bBB\u0019'\u0002\u000711\u0007\u0005\b\u0007w\u0019\u0006\u0019AA>\u00031\u0019\u0007.Z2l\u001f\u001a47/\u001a;t)\u0019\tIe!\u001e\u0004x!9\u0011q\u0019+A\u0002\u0005%\u0007bBB=)\u0002\u000711G\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018\u0001\n:fG>\u0014Hm],ji\"tuN\\*fcV,g\u000e^5bY&sg.\u001a:PM\u001a\u001cX\r^:\u0015\u0011\u0005%7qPBA\u0007\u0007Cqa!\fV\u0001\u0004\t\t\bC\u0004\u0004<U\u0003\r!a\u001f\t\u000f\r\u0015U\u000b1\u0001\u0003\b\u0005Qa.^7SK\u000e|'\u000fZ:\u00029I,7m\u001c:eg^KG\u000f[%om\u0006d\u0017\u000eZ%o]\u0016\u0014X*Y4jGRA\u0011\u0011ZBF\u0007\u001f\u001b\u0019\nC\u0004\u0004\u000eZ\u0003\r!!\u001d\u0002\u001f\t\fGo\u00195NC\u001eL7MV1mk\u0016Dqa!%W\u0001\u0004\t\t(\u0001\tsK\u000e|'\u000fZ'bO&\u001cg+\u00197vK\"911\b,A\u0002\u0005m\u0014aF7bs\n,7\t[3dW\n\u000b7/\u001a+j[\u0016\u001cH/Y7q)\u0019\tIe!'\u0004\u001c\"9!qL,A\u0002\rM\u0002bBBO/\u0002\u00071qT\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0003{\u001a\t+\u0003\u0003\u0004$\u0006}$a\u0003*fG>\u0014HMQ1uG\"\fQC^1mS\u0012\fG/\u001a'pO\u0006\u0003\b/\u001a8e)&lW\r\u0006\u0005\u0002J\r%6QVBY\u0011\u001d\u0019Y\u000b\u0017a\u0001\u0007g\tQ#\u001a=qK\u000e$X\r\u001a'pO\u0006\u0003\b/\u001a8e)&lW\rC\u0004\u00040b\u0003\raa\r\u0002+\u0015D\b/Z2uK\u0012\u0014\u0015m]3US6,7\u000f^1na\"91Q\u0014-A\u0002\r}\u0015a\u0007<fe&4\u0017PU3d_J$7i\u001c8wKJ\u001c\u0018n\u001c8Ti\u0006$8\u000f\u0006\u0006\u0002J\r]6\u0011YBc\u0007\u000fDqa!/Z\u0001\u0004\u0019Y,A\u0003ti\u0006$8\u000f\u0005\u0003\u0002~\ru\u0016\u0002BB`\u0003\u007f\u0012QCU3d_J$7i\u001c8wKJ\u001c\u0018n\u001c8Ti\u0006$8\u000fC\u0004\u0004Df\u0003\rAa\u0002\u0002'9,XnQ8om\u0016\u0014H/\u001a3SK\u000e|'\u000fZ:\t\u000f\u0005\u001d\u0017\f1\u0001\u0002J\"91\u0011Z-A\u0002\r-\u0017AC2p[B\u0014Xm]:fIB\u0019!m!4\n\u0007\r=7MA\u0004C_>dW-\u00198")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Set<MetricName> metricsKeySet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values()));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            RecordVersion recordVersion = (RecordVersion)foreach_this.apply(foreach_i);
            this.testMessageValidation$1(recordVersion.value);
        }
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$2))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private LogValidator.ValidationAndOffsetAssignResult validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_3_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)"The offset of max timestamp should be 0", (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, -1L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (boolean)var10_8, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 1", (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, toMagic, x$13, x$14, x$15, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString(), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        MemoryRecords records = this.createRecords(x$1, timestamp, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        byte x$11 = 2;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, timestamp, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, x$15, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, magic, x$10, x$11, (int)var11_9, (AppendOrigin)x$13, x$14, x$15);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        byte x$8 = 1;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        int x$12 = -1;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        byte x$8 = 1;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        int x$12 = -1;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef((long)offset);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        NoCompressionCodec$ x$9 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$10 = NoCompressionCodec$.MODULE$;
        byte x$11 = 0;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, x$15, (AppendOrigin)x$16, x$17, x$18).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        List batches = TestUtils.toList((Iterable)LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, this.createNonIncreasingOffsetRecords$default$2(), this.createNonIncreasingOffsetRecords$default$3());
        ((MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head()).setLastOffset(2L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1221));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$9))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_0_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            int x$12 = -1;
            AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$15 = this.brokerTopicStats();
            return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1284));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)e.recordErrors().size(), (long)3L);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e2 = (RecordValidationException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1310));
        e2.recordErrors().foreach((Function1 & Serializable & scala.Serializable)e -> {
            Predef$.MODULE$.println((Object)new StringBuilder(1).append(e.batchIndex).append(" ").append(e.message).toString());
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)(e2.invalidException() instanceof InvalidRecordException));
        Assert.assertTrue((boolean)e2.recordErrors().nonEmpty());
        Assert.assertEquals((long)e2.recordErrors().size(), (long)20L);
        e2.recordErrors().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$3(x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, 5).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])"timestamp".getBytes()));
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1344));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)6L, (long)e.recordErrors().size());
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        long l = 1324L;
        short s = (short)10;
        int n = 984;
        boolean bl = true;
        int n2 = 40;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)l, (short)s, (int)n, (long)0L, (long)5L, (int)n2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)bl, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, CompressionType codec, int numRecords) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, numRecords).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            builder.appendUncheckedWithOffset(0L, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, 20).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assert.assertEquals((String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString(), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString(), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString(), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString(), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString(), (tempBytes > (long)originalSize ? 1 : 0) != 0);
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((long)0L, (long)tempBytes);
    }

    private final void testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, CompressionType.GZIP, numRecords);
        if (magicValue >= 2) {
            Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            return;
        }
        LogValidator.ValidationAndOffsetAssignResult result = this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((Object)RichInt$.MODULE$.until$extension0(n, numRecords), (Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(result.validatedRecords().records()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()), Iterable$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$2) {
        return x$2.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$1, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$1, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$1, (long)batch.baseSequence());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assert.assertEquals((long)partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$2, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$2, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$2, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assert.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$3, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$3, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$3, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$9) {
        return x$9.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$3(ProduceResponse.RecordError x$10) {
        Assert.assertNotNull((Object)x$10);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$1, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$1.elem += 30;
        builder$1.appendUncheckedWithOffset((long)offset$1.elem, record);
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$2, Record entry) {
        Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)offset$2.elem, (long)entry.offset());
        ++offset$2.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1(int id) {
        return new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        return LegacyRecord.create((byte)recordMagicValue$1, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$3, IntRef offset$3, LegacyRecord record) {
        builder$3.appendUncheckedWithOffset((long)offset$3.elem, record);
        ++offset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString(), (long)expectedLogAppendTime$1, (long)record.timestamp());
    }

    public static final /* synthetic */ Object $anonfun$testValidationOfBatchesWithNonSequentialInnerOffsets$3$adapted(LogValidatorTest $this, RecordVersion version) {
        $this.testMessageValidation$1(version.value);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }
}

