/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.controller;

import java.io.Serializable;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0006\f\u0001;!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001a\u0001\n\u0003I\u0003b\u0002\u0019\u0001\u0001\u0004%\t!\r\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\u0016\t\u000fa\u0002!\u0019!C\u0001s!1\u0011\n\u0001Q\u0001\niBqA\u0013\u0001C\u0002\u0013\u00051\n\u0003\u0004X\u0001\u0001\u0006I\u0001\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0001L\u0011\u0019I\u0006\u0001)A\u0005\u0019\"9!\f\u0001b\u0001\n\u0003Y\u0005BB.\u0001A\u0003%A\nC\u0003]\u0001\u0011\u0005Q\fC\u0003f\u0001\u0011\u0005Q\fC\u0003k\u0001\u0011\u0005Q\fC\u0003m\u0001\u0011\u0005Q\fC\u0003o\u0001\u0011\u0005Q\fC\u0003q\u0001\u0011\u0005Q\fC\u0003s\u0001\u0011\u0005Q\fC\u0003u\u0001\u0011\u0005QLA\u000bD_:$(o\u001c7mKJ\u001cuN\u001c;fqR$Vm\u001d;\u000b\u0005]A\u0012AC2p]R\u0014x\u000e\u001c7fe*\u0011\u0011DG\u0001\u0006W\u000647.\u0019\u0006\u00027\u0005!QO\\5u\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002(\u00015\ta#A\u0004d_:$X\r\u001f;\u0016\u0003)\u0002\"a\u000b\u0018\u000e\u00031R!aF\u0017\u000b\u0003eI!a\f\u0017\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/A\u0006d_:$X\r\u001f;`I\u0015\fHC\u0001\u001a6!\ty2'\u0003\u00025A\t!QK\\5u\u0011\u001d14!!AA\u0002)\n1\u0001\u001f\u00132\u0003!\u0019wN\u001c;fqR\u0004\u0013a\u00022s_.,'o]\u000b\u0002uA\u00191h\u0011$\u000f\u0005q\neBA\u001fA\u001b\u0005q$BA \u001d\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002CA\u00059\u0001/Y2lC\u001e,\u0017B\u0001#F\u0005\r\u0019V-\u001d\u0006\u0003\u0005\u0002\u0002\"aH$\n\u0005!\u0003#aA%oi\u0006A!M]8lKJ\u001c\b%A\u0002uaF*\u0012\u0001\u0014\t\u0003\u001bVk\u0011A\u0014\u0006\u0003\u001fB\u000baaY8n[>t'BA\rR\u0015\t\u00116+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0006\u0019qN]4\n\u0005Ys%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0005iB\f\u0004%A\u0002uaJ\nA\u0001\u001e93A\u0005\u0019A\u000f]\u001a\u0002\tQ\u00048\u0007I\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002e!\u0012Qb\u0018\t\u0003A\u000el\u0011!\u0019\u0006\u0003EN\u000bQA[;oSRL!\u0001Z1\u0003\r\t+gm\u001c:f\u0003\u0001#Xm\u001d;Va\u0012\fG/\u001a)beRLG/[8o\rVdGNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u+B$\u0017\r^3t%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bF\u0001\bh!\t\u0001\u0007.\u0003\u0002jC\n!A+Z:u\u0003-#Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tGOU3ukJt7/R7qif\u001cV-]%g)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:$u.Z:O_R,\u00050[:uQ\tyq-\u0001,uKN$\b+\u0019:uSRLwN\u001c$vY2\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e*fiV\u0014hn]#naRL\u0018i]:jO:lWM\u001c;JMR{\u0007/[2PeB\u000b'\u000f^5uS>tGi\\3t\u001d>$X\t_5ti\"\u0012\u0001cZ\u0001Ii\u0016\u001cH\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1BgNLwM\\7f]R4uN\u001d+pa&\u001c'+\u001a;ve:\u001cX)\u001c9us6\u000b\u0007/\u00134U_BL7\rR8fg:{G/\u0012=jgRD#!E4\u0002\u000fR,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$hi\u001c:U_BL7MU3ukJt7/\u0012=qK\u000e$X\r\u001a*fa2L7-Y!tg&<g.\\3oiND#AE4\u0002=Q,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bFA\nh\u00039!Xm\u001d;SK\u0006\u001c8/[4o)>D#\u0001F4")
public class ControllerContextTest {
    private ControllerContext context = null;
    private final Seq<Object> brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @Before
    public void setUp() {
        this.context_$eq(new ControllerContext());
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)brokerId -> ControllerContextTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.context().setLiveBrokerAndEpochs((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2(), this.tp3()}))).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ControllerContextTest.$anonfun$setUp$2(this, leaderIndex, partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        Seq initialReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(initialReplicas));
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.addingReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assert.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assert.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assert.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assert.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assert.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        Seq seq = this.context().partitionReplicaAssignment(this.tp1());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.tp1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Seq seq2 = this.context().partitionReplicaAssignment(this.tp2());
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.tp2());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map expectedAssignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assert.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6})));
        Assert.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassigningPartition.targetReplicas());
        ReplicaAssignment reassigningPartition2 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassigningPartition2.targetReplicas());
        ReplicaAssignment reassigningPartition3 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Assert.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Object)reassigningPartition3.targetReplicas());
        ReplicaAssignment partition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Assert.assertFalse((boolean)partition.isBeingReassigned());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Object)partition.targetReplicas());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Object)reassigningPartition4.targetReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assert.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.targetReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assert.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.targetReplicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.addingReplicas());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.removingReplicas());
        Assert.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        ReplicaAssignment firstReassign = assignment.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
        Assert.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)firstReassign);
        Assert.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)firstReassign.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))));
        Assert.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)assignment.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))));
        Assert.assertEquals((Object)assignment, (Object)firstReassign.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$setUp$1(int brokerId) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
        Long l = BoxesRunTime.boxToLong((long)1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ void $anonfun$setUp$2(ControllerContextTest $this, IntRef leaderIndex$1, TopicPartition partition) {
        IndexedSeq replicas = (IndexedSeq)$this.brokers().indices().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)$this.brokers().apply((i + leaderIndex$1.elem) % $this.brokers().size())), IndexedSeq$.MODULE$.canBuildFrom());
        $this.context().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas));
        ++leaderIndex$1.elem;
    }
}

