/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.LeaderElectionCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LeaderElectionCommand$
implements Logging {
    public static LeaderElectionCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        this.run(args, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).second());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run(String[] args, Duration timeout) {
        commandOptions = new LeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool attempts to elect a new leader for a set of topic partitions. The type of elections supported are preferred replicas and unclean replicas.");
        this.validate(commandOptions);
        electionType = (ElectionType)commandOptions.options().valueOf(commandOptions.electionType());
        v0 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.pathToJsonFile()));
        if (v0 == null) {
            throw null;
        }
        map_this = v0;
        var14_6 /* !! */  = map_this.isEmpty() != false ? None$.MODULE$ : new Some((Object)LeaderElectionCommand$.$anonfun$run$1((String)map_this.get()));
        var19_7 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.partition()));
        var6_8 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.topic()));
        var7_9 = var19_7;
        if (!(var6_8 instanceof Some)) ** GOTO lbl-1000
        topic = (String)((Some)var6_8).value();
        if (var7_9 instanceof Some) {
            partition = (Integer)((Some)var7_9).value();
            var3_12 = new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition))})));
        } else lbl-1000:
        // 2 sources

        {
            var3_12 = None$.MODULE$;
        }
        if (var14_6 /* !! */  == null) {
            throw null;
        }
        var15_13 /* !! */  = var14_6 /* !! */ .isEmpty() != false ? LeaderElectionCommand$.$anonfun$run$2((Option)var3_12) : var14_6 /* !! */ ;
        v1 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.adminClientConfig()));
        if (v1 == null) {
            throw null;
        }
        map_this = v1;
        var17_15 /* !! */  = map_this.isEmpty() != false ? None$.MODULE$ : new Some((Object)LeaderElectionCommand$.$anonfun$run$3((String)map_this.get()));
        if (var17_15 /* !! */  == null) {
            throw null;
        }
        var18_16 = var17_15 /* !! */ .isEmpty() != false ? LeaderElectionCommand$.$anonfun$run$4() : var17_15 /* !! */ .get();
        props = (Properties)var18_16;
        props.setProperty("bootstrap.servers", (String)commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("default.api.timeout.ms", BoxesRunTime.boxToLong((long)timeout.toMillis()).toString());
        props.setProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)(timeout.toMillis() / 2L)).toString());
        adminClient = Admin.create((Properties)props);
        try {
            this.electLeaders(adminClient, electionType, (Option<scala.collection.immutable.Set<TopicPartition>>)var15_13 /* !! */ );
        }
        finally {
            adminClient.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private scala.collection.immutable.Set<TopicPartition> parseReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Option<JsonValue> option2 = ((JsonValue)((Some)option).value()).asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Buffer partitions = ((JsonValue)((Some)option2).value()).asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1 & Serializable & scala.Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt((Object)p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (!duplicatePartitions.nonEmpty()) return partitions.toSet();
                throw new AdminOperationException(new StringBuilder(53).append("Replica election data contains duplicate partitions: ").append(duplicatePartitions.mkString(",")).toString());
            }
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            throw new AdminOperationException("Replica election data is missing \"partitions\" field");
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("Replica election data is empty");
    }

    /*
     * WARNING - void declaration
     */
    private void electLeaders(Admin client, ElectionType electionType, Option<scala.collection.immutable.Set<TopicPartition>> topicPartitions) {
        scala.collection.mutable.Map map;
        try {
            void orNull_ev;
            if (topicPartitions == null) {
                throw null;
            }
            Object object = topicPartitions.isEmpty() ? None$.MODULE$ : new Some((Object)LeaderElectionCommand$.$anonfun$electLeaders$1((scala.collection.immutable.Set)topicPartitions.get()));
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
            if (object == null) {
                throw null;
            }
            Object object2 = object.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : object.get();
            java.util.Set partitions = (java.util.Set)object2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(LeaderElectionCommand$.$anonfun$electLeaders$2(electionType, partitions)));
            }
            map = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)client.electLeaders(electionType, partitions).partitions().get()).asScala();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for election results";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized to perform leader election";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while making request");
            throw e;
        }
        scala.collection.mutable.Map electionResults = map;
        scala.collection.mutable.Set succeeded = Set$.MODULE$.empty();
        scala.collection.mutable.Set noop = Set$.MODULE$.empty();
        scala.collection.mutable.Map failed = Map$.MODULE$.empty();
        electionResults.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LeaderElectionCommand$.$anonfun$electLeaders$3(noop, failed, succeeded, x0$1);
            return BoxedUnit.UNIT;
        });
        if (succeeded.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(57).append("Successfully completed leader election (").append(electionType).append(") for partitions ").append(partitions).toString());
        }
        if (noop.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(45).append("Valid replica already elected for partitions ").append(partitions).toString());
        }
        if (failed.nonEmpty()) {
            AdminCommandFailedException rootException = new AdminCommandFailedException(new StringBuilder(32).append(failed.size()).append(" replica(s) could not be elected").toString());
            failed.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                LeaderElectionCommand$.$anonfun$electLeaders$4(electionType, rootException, x0$2);
                return BoxedUnit.UNIT;
            });
            throw rootException;
        }
    }

    private void validate(LeaderElectionCommandOptions commandOptions) {
        List missingOptions = List$.MODULE$.empty();
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (!commandOptions.options().has(commandOptions.electionType())) {
            String string = (String)commandOptions.electionType().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(missingOptions.mkString(", ")).toString());
        }
        Seq mutuallyExclusiveOptions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractOptionSpec[]{commandOptions.topic(), commandOptions.allTopicPartitions(), commandOptions.pathToJsonFile()}));
        switch (mutuallyExclusiveOptions.count(arg_0 -> LeaderElectionCommand$.$anonfun$validate$1$adapted(commandOptions.options(), arg_0))) {
            case 1: {
                break;
            }
            default: {
                throw new AdminCommandFailedException(new StringBuilder(55).append("One and only one of the following options is required: ").append(((TraversableOnce)mutuallyExclusiveOptions.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.options().get(0), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            }
        }
        boolean bl = commandOptions.options().has(commandOptions.partition());
        boolean bl2 = commandOptions.options().has(commandOptions.topic());
        if (bl2 && !bl) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(commandOptions.partition().options().get(0)).toString());
        }
        if (!bl2 && bl) {
            throw new AdminCommandFailedException(new StringBuilder(35).append("Option ").append(commandOptions.partition().options().get(0)).append(" is only allowed if ").append(commandOptions.topic().options().get(0)).append(" is used").toString());
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$run$1(String path) {
        return MODULE$.parseReplicaElectionData(Utils.readFileAsString((String)path));
    }

    public static final /* synthetic */ Option $anonfun$run$2(Option singleTopicPartition$1) {
        return singleTopicPartition$1;
    }

    public static final /* synthetic */ Properties $anonfun$run$3(String config) {
        return Utils.loadProps((String)config);
    }

    public static final /* synthetic */ Properties $anonfun$run$4() {
        return new Properties();
    }

    public static final /* synthetic */ java.util.Set $anonfun$electLeaders$1(scala.collection.immutable.Set x$2) {
        return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)x$2).asJava();
    }

    public static final /* synthetic */ String $anonfun$electLeaders$2(ElectionType electionType$1, java.util.Set partitions$1) {
        return new StringBuilder(36).append("Calling AdminClient.electLeaders(").append(electionType$1).append(", ").append(partitions$1).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$electLeaders$3(scala.collection.mutable.Set noop$1, scala.collection.mutable.Map failed$1, scala.collection.mutable.Set succeeded$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Optional error = (Optional)x0$1._2();
            if (error.isPresent()) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if ((Throwable)error.get() instanceof ElectionNotNeededException) {
                    noop$1.$plus$eq((Object)topicPartition);
                    return;
                }
                Object t = error.get();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                failed$1.$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y));
                return;
            }
            succeeded$1.$plus$eq((Object)topicPartition);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$electLeaders$4(ElectionType electionType$1, AdminCommandFailedException rootException$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            Throwable exception = (Throwable)x0$2._2();
            Predef$.MODULE$.println((Object)new StringBuilder(53).append("Error completing leader election (").append(electionType$1).append(") for partition: ").append(topicPartition).append(": ").append(exception).toString());
            rootException$1.addSuppressed(exception);
            return;
        }
        throw new MatchError(null);
    }

    private LeaderElectionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$validate$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }
}

