/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableLike;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.TraversableLikeExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.IsTraversableLike$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CoreUtils$ {
    public static CoreUtils$ MODULE$;
    private final Logger logger;

    static {
        new CoreUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public <A, B> A min(Iterable<A> iterable, A ifEmpty, Ordering<B> cmp) {
        if (iterable.isEmpty()) {
            return ifEmpty;
        }
        return (A)iterable.min(cmp);
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if (Level.ERROR.equals(logLevel)) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(e.getMessage(), e);
                    return;
                }
            } else if (Level.WARN.equals(logLevel)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(e.getMessage(), e);
                    return;
                }
            } else if (Level.INFO.equals(logLevel)) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(e.getMessage(), e);
                    return;
                }
            } else if (Level.DEBUG.equals(logLevel)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(e.getMessage(), e);
                    return;
                }
            } else if (Level.TRACE.equals(logLevel)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(e.getMessage(), e);
                    return;
                }
            } else {
                throw new MatchError((Object)logLevel);
            }
            return;
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1 & Serializable & scala.Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef exception = ObjectRef.create(null);
        all.foreach((Function1 & Serializable & scala.Serializable)element -> {
            try {
                element.apply$mcV$sp();
            }
            catch (Throwable $anonfun$tryAll$1_e) {
                if ((Throwable)exception$1.elem != null) {
                    ((Throwable)exception$1.elem).addSuppressed($anonfun$tryAll$1_e);
                }
                exception$1.elem = $anonfun$tryAll$1_e;
            }
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mbs) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : mbs
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(25).append("Failed to register Mbean ").append(name).toString(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mbs) {
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
            return;
        }
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        switch (n) {
            case -1: {
                throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
            }
        }
        return n;
    }

    public Map<String, String> parseCsvMap(String str) {
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        Tuple2[] keyVals = (Tuple2[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split("\\s*,\\s*"))), (Function1 & Serializable & scala.Serializable)s -> {
            int lio = s.lastIndexOf(":");
            return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
        }, (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyVals)).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseCsvList(String csvList) {
        if (csvList == null || csvList.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csvList.split("\\s*,\\s*"))).filterImpl((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$parseCsvList$1(v)), false));
    }

    public <T> T createObject(String className, Seq<Object> args) {
        return (T)Class.forName(className, true, Utils.getContextOrKafkaClassLoader()).getConstructor((Class[])((TraversableOnce)args.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getClass(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class))).newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    /*
     * WARNING - void declaration
     */
    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        void continually_elem;
        JFunction0.mcI.sp & Serializable & scala.Serializable intersect = (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1;
        if (Iterator$.MODULE$ == null) {
            throw null;
        }
        return new /* Unavailable Anonymous Inner Class!! */.flatMap((Function1 & Serializable & scala.Serializable)_ -> CoreUtils$.$anonfun$circularIterator$2(coll, BoxesRunTime.unboxToInt((Object)_)));
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (!s.endsWith(oldSuffix)) {
            String string = "Expected string to end with '%s' but string is '%s'";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new IllegalArgumentException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
        }
        return new StringBuilder(0).append(s.substring(0, s.length() - oldSuffix.length())).append(newSuffix).toString();
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        Object object;
        lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.readLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.writeLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> Iterable<T> duplicates(Iterable<T> s) {
        return ((MapLike)((TraversableLike)s.groupBy((Function1 & Serializable & scala.Serializable)x -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return x;
        }).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Object k = x0$1._1();
            Iterable l = (Iterable)x0$1._2();
            Tuple2 tuple2 = new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)l.size()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        void var3_4;
        Seq seq;
        try {
            seq = (Seq)this.parseCsvList(listeners).map((Function1 & Serializable & scala.Serializable)x$5 -> EndPoint$.MODULE$.createEndPoint((String)x$5, (Option<Map<ListenerName, SecurityProtocol>>)new Some((Object)securityProtocolMap)), Seq$.MODULE$.canBuildFrom());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Error creating broker listeners from '").append(listeners).append("': ").append(e.getMessage()).toString(), e);
        }
        Seq endPoints = seq;
        CoreUtils$.validate$1(endPoints, listeners);
        return var3_4;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value)}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propsWith(Seq<Tuple2<String, String>> props) {
        void var2_2;
        Properties properties = new Properties();
        props.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = properties.put(k, v);
            return object;
        });
        return var2_2;
    }

    public <K, V> V atomicGetOrUpdate(scala.collection.concurrent.Map<K, V> map, K key, Function0<V> createValue) {
        Object object;
        Option option = map.get(key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            Object value = createValue.apply();
            Option option2 = map.putIfAbsent(key, value);
            if (option2 == null) {
                throw null;
            }
            Option getOrElse_this = option2;
            Object object2 = getOrElse_this.isEmpty() ? value : getOrElse_this.get();
            object = object2;
        } else {
            throw new MatchError((Object)option);
        }
        return (V)object;
    }

    /*
     * WARNING - void declaration
     */
    public <T, K, B> Map<K, B> groupMapReduce(Iterable<T> elements, Function1<T, K> key, Function1<T, B> f, Function2<B, B, B> reduce) {
        void groupMapReduce$extension_$this;
        GenTraversableLike genTraversableLike = package$.MODULE$.toTraversableLikeExtensionMethods(elements, IsTraversableLike$.MODULE$.genTraversableLikeRepr((Function1)Predef$.MODULE$.$conforms()));
        if (TraversableLikeExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        scala.collection.mutable.Map groupMapReduce$extension_map = Map$.MODULE$.empty();
        groupMapReduce$extension_$this.foreach(arg_0 -> TraversableLikeExtensionMethods$.$anonfun$groupMapReduce$1(key, (scala.collection.mutable.Map)groupMapReduce$extension_map, reduce, f, arg_0));
        return groupMapReduce$extension_map.toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete((File)new File(f));
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        try {
            element.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if ((Throwable)exception$1.elem != null) {
                ((Throwable)exception$1.elem).addSuppressed(e);
                return;
            }
            exception$1.elem = e;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseCsvList$1(String v) {
        return !v.equals("");
    }

    public static final /* synthetic */ Iterable $anonfun$circularIterator$2(Iterable coll$1, int _) {
        return (Iterable)coll$1.map((Function1 & Serializable & scala.Serializable)t -> t, Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() > 1;
        return bl;
    }

    public static final /* synthetic */ String $anonfun$listenerListToEndPoints$4(String listeners$1) {
        return new StringBuilder(53).append("Each listener must have a different port, listeners: ").append(listeners$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listenerListToEndPoints$5(String listeners$1) {
        return new StringBuilder(53).append("Each listener must have a different name, listeners: ").append(listeners$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final void validate$1(Seq endPoints, String listeners$1) {
        void require_requirement;
        boolean bl;
        void require_requirement2;
        boolean bl2;
        Seq portsExcludingZero = (Seq)((TraversableLike)endPoints.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.port()), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != 0);
        Seq distinctPorts = (Seq)portsExcludingZero.distinct();
        Seq distinctListenerNames = (Seq)((SeqLike)endPoints.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.listenerName(), Seq$.MODULE$.canBuildFrom())).distinct();
        boolean bl3 = bl2 = distinctPorts.size() == portsExcludingZero.size();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement2 == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)CoreUtils$.$anonfun$listenerListToEndPoints$4(listeners$1)).toString());
        }
        boolean bl4 = bl = distinctListenerNames.size() == endPoints.size();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)CoreUtils$.$anonfun$listenerListToEndPoints$5(listeners$1)).toString());
        }
    }

    private CoreUtils$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }
}

