/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u000f\u001f\u0003\u0003\u0019\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011\u0011\u0003!\u0011!Q\u0001\neB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")!\n\u0001C\u0001\u0017\"AA\f\u0001b\u0001\n\u0003qR\f\u0003\u0004j\u0001\u0001\u0006IA\u0018\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019!\b\u0001)A\u0005Y\"9Q\u000f\u0001a\u0001\n\u00131\bbB<\u0001\u0001\u0004%I\u0001\u001f\u0005\u0007}\u0002\u0001\u000b\u0015B$\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003A\u0001\"!\u0003\u0001A\u0003%\u00111\u0001\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"a\u0007\u0001A\u0003%\u0011q\u0002\u0005\b\u0003;\u0001A\u0011\u0001\u0010w\u0011\u001d\ty\u0002\u0001C\u0001\u0003CA\u0001\"a\n\u0001\t\u0003q\u0012\u0011\u0006\u0005\t\u0003\u0017\u0002A\u0011\u0001\u0010\u0002N!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003bBA3\u0001\u0019\u0005\u0011q\r\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!a%\u0001\t#\t)\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005]&AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u000b\u0005}\u0001\u0013AB:feZ,'OC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"\u0001\n)\u0014\t\u0001)3&\r\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00051zS\"A\u0017\u000b\u00059\u0002\u0013!B;uS2\u001c\u0018B\u0001\u0019.\u0005\u001daunZ4j]\u001e\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0011\u0002\u000f5,GO]5dg&\u0011ag\r\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018\u0001\u00028b[\u0016,\u0012!\u000f\t\u0003u\u0005s!aO \u0011\u0005q:S\"A\u001f\u000b\u0005y\u0012\u0013A\u0002\u001fs_>$h(\u0003\u0002AO\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001u%A\u0003oC6,\u0007%\u0001\u0005dY&,g\u000e^%e\u0003-qW/\u001c$fi\u000eDWM]:\u0011\u0005\u0019B\u0015BA%(\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1K&l\u0017\t\u0004\u001b\u0002qU\"\u0001\u0010\u0011\u0005=\u0003F\u0002\u0001\u0003\u0006#\u0002\u0011\rA\u0015\u0002\u0002)F\u00111K\u0016\t\u0003MQK!!V\u0014\u0003\u000f9{G\u000f[5oOB\u0011QjV\u0005\u00031z\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rC\u00038\u000b\u0001\u0007\u0011\bC\u0003F\u000b\u0001\u0007\u0011\bC\u0003G\u000b\u0001\u0007q)\u0001\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ'baV\ta\f\u0005\u0003`I\u001atU\"\u00011\u000b\u0005\u0005\u0014\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003G\u001e\n!bY8mY\u0016\u001cG/[8o\u0013\t)\u0007MA\u0004ICNDW*\u00199\u0011\u00055;\u0017B\u00015\u001f\u0005Q\u0011%o\\6fe&#\u0017I\u001c3GKR\u001c\u0007.\u001a:JI\u0006\tb-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012l\u0015\r\u001d\u0011\u0002\t1|7m[\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0005Y\u0006twMC\u0001r\u0003\u0011Q\u0017M^1\n\u0005Mt'AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%\u0001\u000bok64U\r^2iKJ\u001c\b+\u001a:Ce>\\WM]\u000b\u0002\u000f\u0006Ab.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ|F%Z9\u0015\u0005ed\bC\u0001\u0014{\u0013\tYxE\u0001\u0003V]&$\bbB?\f\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014!\u00068v[\u001a+Go\u00195feN\u0004VM\u001d\"s_.,'\u000fI\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N,\"!a\u0001\u0011\u00075\u000b)!C\u0002\u0002\by\u0011\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002#\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0003uC\u001e\u001cXCAA\b!\u001d\t\t\"a\u0005\u0002\u0018ej\u0011AY\u0005\u0004\u0003+\u0011'aA'baB\u0019Q.!\u0007\n\u0005\ts\u0017!\u0002;bON\u0004\u0013a\u00043fC\u0012$\u0006N]3bI\u000e{WO\u001c;\u0002!I,7/\u001b>f)\"\u0014X-\u00193Q_>dGcA=\u0002$!1\u0011Q\u0005\nA\u0002\u001d\u000bqA\\3x'&TX-\u0001\u0006hKR4U\r^2iKJ$B!a\u000b\u00022A!a%!\fO\u0013\r\tyc\n\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005M2\u00031\u0001\u00026\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\u001c\u0003\u000fj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0007G>lWn\u001c8\u000b\u0007\u0005\nyD\u0003\u0003\u0002B\u0005\r\u0013AB1qC\u000eDWM\u0003\u0002\u0002F\u0005\u0019qN]4\n\t\u0005%\u0013\u0011\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u000319W\r\u001e$fi\u000eDWM]%e)\r9\u0015q\n\u0005\b\u0003g!\u0002\u0019AA\u001b\u0003mi\u0017M]6QCJ$\u0018\u000e^5p]N4uN\u001d+sk:\u001c\u0017\r^5p]R9\u00110!\u0016\u0002Z\u0005m\u0003BBA,+\u0001\u0007q)\u0001\u0005ce>\\WM]%e\u0011\u001d\t\u0019$\u0006a\u0001\u0003kAq!!\u0018\u0016\u0001\u0004\ty&\u0001\tueVt7-\u0019;j_:|eMZ:fiB\u0019a%!\u0019\n\u0007\u0005\rtE\u0001\u0003M_:<\u0017aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$G#\u0002(\u0002j\u00055\u0004BBA6-\u0001\u0007q)A\u0005gKR\u001c\u0007.\u001a:JI\"9\u0011q\u000e\fA\u0002\u0005E\u0014\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\b\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]\u0004%A\u0004dYV\u001cH/\u001a:\n\t\u0005m\u0014Q\u000f\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0003]\tG\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002z\u0003\u0003Cq!a!\u0018\u0001\u0004\t))A\nqCJ$\u0018\u000e^5p]\u0006sGm\u00144gg\u0016$8\u000f\u0005\u0005\u0002\u0012\u0005M\u0011QGAD!\ri\u0015\u0011R\u0005\u0004\u0003\u0017s\"!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\u0006\u0011\u0012\r\u001a3GC&dW\r\u001a)beRLG/[8o)\rI\u0018\u0011\u0013\u0005\b\u0003gA\u0002\u0019AA\u001b\u0003q\tG\r\u001a)beRLG/[8ogR{g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$R!_AL\u00037Ca!!'\u001a\u0001\u0004q\u0015!\u00044fi\u000eDWM\u001d+ie\u0016\fG\rC\u0004\u0002\u001ef\u0001\r!!\"\u0002-%t\u0017\u000e^5bY>3gm]3u\u0003:$W\t]8dQN\f!D]3n_Z,g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$B!a)\u0002,BA\u0011\u0011CA\n\u0003k\t)\u000bE\u0002N\u0003OK1!!+\u001f\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0011\u001d\tiK\u0007a\u0001\u0003_\u000b!\u0002]1si&$\u0018n\u001c8t!\u0019\t\t\"!-\u00026%\u0019\u00111\u00172\u0003\u0007M+G/\u0001\u000etQV$Hm\\<o\u0013\u0012dWMR3uG\",'\u000f\u00165sK\u0006$7\u000fF\u0001z\u0003A\u0019Gn\\:f\u00032dg)\u001a;dQ\u0016\u00148\u000f")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Added fetcher to broker ").append(fetcherThread.sourceBroker().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        void var2_2;
        scala.collection.mutable.Map fetchStates = Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return var2_2;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BoxedUnit boxedUnit;
                if (x$4 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)x$4._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$4._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$5)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$6);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return scala.math.package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ double $anonfun$new$5(AbstractFetcherThread x$1) {
        return x$1.fetcherStats().requestRate().oneMinuteRate();
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        double headRate = BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$5(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$9() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, BrokerIdAndFetcherId id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = $this.removeFetcherForPartitions(thread.partitions());
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Map fetchStates = (Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            PartitionFetchState currentFetchState = (PartitionFetchState)x0$1._2();
            InitialFetchState initialFetchState = new InitialFetchState(thread.sourceBroker(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)initialFetchState);
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
        $this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)fetchStates);
    }

    /*
     * WARNING - void declaration
     */
    private final void migratePartitions$1(int newSize) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, id, thread);
            return BoxedUnit.UNIT;
        };
        Map<BrokerIdAndFetcherId, T> map = Implicits$.MODULE$.MapExtensionMethods(this.fetcherThreadMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
            var6_5 = false;
            var7_6 = null;
            var8_7 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            currentFetcherThread = (AbstractFetcherThread)var7_6.value();
            v0 = currentFetcherThread.sourceBroker();
            var10_9 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                var2_10 = currentFetcherThread;
            } else if (var6_5) {
                ((AbstractFetcherThread)var7_6.value()).shutdown();
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else if (None$.MODULE$.equals(var8_7)) {
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else {
                throw new MatchError((Object)var8_7);
            }
            $this.addPartitionsToFetcherThread(var2_10, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$5) {
        if (x$5 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractFetcherThread)x$5._2()).initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$6) {
        if (x$6 != null) {
            ((AbstractFetcherThread)x$6._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}));
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.tags());
    }
}

