/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rUs!\u0002(P\u0011\u0003!f!\u0002,P\u0011\u00039\u0006\"\u00020\u0002\t\u0003y\u0006\u0002\u00031\u0002\u0005\u0004%\taT1\t\r)\f\u0001\u0015!\u0003c\u0011\u0015Y\u0017\u0001\"\u0001m\u0011\u0019y\u0018\u0001\"\u0003\u0002\u0002!9\u00111C\u0001\u0005\n\u0005U\u0001\u0002CA\r\u0003\u0011\u0005q*a\u0007\t\u0011\u0005%\u0014\u0001\"\u0001P\u0003W2!\"!2\u0002!\u0003\r\n!UAd\u0011\u001d\tYM\u0003D\u0001\u0003\u001b4aA!\u0005\u0002\t\tM\u0001B\u0003B\u0011\u0019\t\u0005\t\u0015!\u0003\u0003$!Q!q\u0006\u0007\u0003\u0002\u0003\u0006IA!\r\t\rycA\u0011\u0001B\u001a\u0011\u001d\tY\r\u0004C!\u0005wAqA!\u0012\u0002\t\u0013\u00119\u0005C\u0004\u0003r\u0005!IAa\u001d\u0007\r\u0005m\u0014\u0001AA?\u0011\u0019q6\u0003\"\u0001\u0002\u0000!I\u0011\u0011Q\nC\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003\u001b\u001b\u0002\u0015!\u0003\u0002\u0006\"I\u0011qR\nC\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003#\u001b\u0002\u0015!\u0003\u0002\u0006\"I\u00111S\nC\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003+\u001b\u0002\u0015!\u0003\u0002\u0006\"9\u0011qS\n\u0005\u0002\u0005e\u0005bBAS'\u0011\u0005\u0011q\u0015\u0005\b\u0003c\u001bB\u0011AAZ\u0011\u001d\tyl\u0005C\u0001\u0003\u00034aAa#\u0002\t\t5\u0005B\u00020 \t\u0003\u0011\t\nC\u0004\u0002L~!\tE!&\u0007\r\tu\u0015\u0001\u0002BP\u0011\u0019q&\u0005\"\u0001\u0003\"\"9\u00111\u001a\u0012\u0005B\t\u0015fA\u0002BU\u0003\u0011\u0011Y\u000b\u0003\u0004_K\u0011\u0005!Q\u0016\u0005\n\u0005c+#\u0019!C\u0001\u0005gC\u0001B!1&A\u0003%!Q\u0017\u0005\b\u0003\u0017,C\u0011\tBb\r\u0019\u00119-\u0001\u0003\u0003J\"Q\u0011O\u000bB\u0001B\u0003%!Oa6\t\rySC\u0011\u0001Bm\u0011%\u0011yN\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u0003p*\u0002\u000b\u0011\u0002Br\u0011%\u0011\tP\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u0003t*\u0002\u000b\u0011\u0002Br\u0011%\u0011)P\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u0003x*\u0002\u000b\u0011\u0002Br\u0011%\u0011IP\u000bb\u0001\n\u0003\u0011Y\u0010\u0003\u0005\u0004\u0004)\u0002\u000b\u0011\u0002B\u007f\u0011%\u0019)A\u000bb\u0001\n\u0003\u00199\u0001\u0003\u0005\u0004\u0012)\u0002\u000b\u0011BB\u0005\u0011%\u0019\u0019B\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u0004\u0016)\u0002\u000b\u0011\u0002Br\u0011%\u00199B\u000bb\u0001\n\u0003\u0019I\u0002\u0003\u0005\u0004\u001e)\u0002\u000b\u0011BB\u000e\u0011%\u0019yB\u000bb\u0001\n\u0003\u0019I\u0002\u0003\u0005\u0004\")\u0002\u000b\u0011BB\u000e\u0011%\u0019\u0019C\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u0004&)\u0002\u000b\u0011\u0002Br\u0011%\u00199C\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u0004*)\u0002\u000b\u0011\u0002Br\u0011%\u0019YC\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u0004.)\u0002\u000b\u0011\u0002Br\u0011%\u0019yC\u000bb\u0001\n\u0003\u0011\t\u000f\u0003\u0005\u00042)\u0002\u000b\u0011\u0002Br\u0011\u001d\u0019\u0019D\u000bC\u0001\u0007kA!ba\u0012+\u0011\u000b\u0007I\u0011AB%\u0011)\u0011yG\u000bEC\u0002\u0013\u00051\u0011\n\u0005\u000b\u0005+R\u0003R1A\u0005\u0002\r%\u0003BCA\u0016U!\u0015\r\u0011\"\u0001\u0004J!Q\u0011\u0011\u0005\u0016\t\u0006\u0004%\ta!\u0013\t\u0015\r-#\u0006#b\u0001\n\u0003\u0019i\u0005\u0003\u0006\u0002b)B)\u0019!C\u0001\u0007#Bqaa\u0015+\t\u0003\t\t-A\bEk6\u0004Hj\\4TK\u001elWM\u001c;t\u0015\t\u0001\u0016+A\u0003u_>d7OC\u0001S\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!V\u0001\u000e\u0003=\u0013q\u0002R;na2{wmU3h[\u0016tGo]\n\u0003\u0003a\u0003\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001U\u00031\u0011VmY8sI&sG-\u001a8u+\u0005\u0011\u0007CA2i\u001b\u0005!'BA3g\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\fAA[1wC&\u0011\u0011\u000e\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u001bI+7m\u001c:e\u0013:$WM\u001c;!\u0003\u0011i\u0017-\u001b8\u0015\u00055\u0004\bCA-o\u0013\ty'L\u0001\u0003V]&$\b\"B9\u0006\u0001\u0004\u0011\u0018\u0001B1sON\u00042!W:v\u0013\t!(LA\u0003BeJ\f\u0017\u0010\u0005\u0002w{:\u0011qo\u001f\t\u0003qjk\u0011!\u001f\u0006\u0003uN\u000ba\u0001\u0010:p_Rt\u0014B\u0001?[\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N \u0006\u0003yj\u000bA\u0002Z;naRCh.\u00138eKb$2!\\A\u0002\u0011\u001d\t)A\u0002a\u0001\u0003\u000f\tAAZ5mKB!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0019\f!![8\n\t\u0005E\u00111\u0002\u0002\u0005\r&dW-\u0001\fek6\u0004\bK]8ek\u000e,'/\u00133T]\u0006\u00048\u000f[8u)\ri\u0017q\u0003\u0005\b\u0003\u000b9\u0001\u0019AA\u0004\u0003%!W/\u001c9J]\u0012,\u0007\u0010F\u0006n\u0003;\ty\"!\u000b\u0002.\u0005}\u0003bBA\u0003\u0011\u0001\u0007\u0011q\u0001\u0005\b\u0003CA\u0001\u0019AA\u0012\u0003=Ig\u000eZ3y'\u0006t\u0017\u000e^=P]2L\bcA-\u0002&%\u0019\u0011q\u0005.\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0006\u0005A\u0002\u0005\r\u0012A\u0003<fe&4\u0017p\u00148ms\"9\u0011q\u0006\u0005A\u0002\u0005E\u0012AG7jg6\u000bGo\u00195fg\u001a{'/\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\bcBA\u001a\u0003{)\u0018\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u00059Q.\u001e;bE2,'bAA\u001e5\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0004\u001b\u0006\u0004\bCBA\"\u0003\u001b\n\u0019F\u0004\u0003\u0002F\u0005%cb\u0001=\u0002H%\t1,C\u0002\u0002Li\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002P\u0005E#\u0001\u0002'jgRT1!a\u0013[!\u001dI\u0016QKA-\u00033J1!a\u0016[\u0005\u0019!V\u000f\u001d7feA\u0019\u0011,a\u0017\n\u0007\u0005u#L\u0001\u0003M_:<\u0007bBA1\u0011\u0001\u0007\u00111M\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f!\rI\u0016QM\u0005\u0004\u0003OR&aA%oi\u0006iA-^7q)&lW-\u00138eKb$2\"\\A7\u0003_\n\t(a\u001d\u0002D\"9\u0011QA\u0005A\u0002\u0005\u001d\u0001bBA\u0011\u0013\u0001\u0007\u00111\u0005\u0005\b\u0003WI\u0001\u0019AA\u0012\u0011\u001d\t)(\u0003a\u0001\u0003o\n1\u0003^5nK&sG-\u001a=Ek6\u0004XI\u001d:peN\u00042!!\u001f\u0014\u001b\u0005\t!a\u0005+j[\u0016Le\u000eZ3y\tVl\u0007/\u0012:s_J\u001c8CA\nY)\t\t9(\u0001\u0010nSNl\u0015\r^2iKN4uN\u001d+j[\u0016Le\u000eZ3y\r&dWm]'baV\u0011\u0011Q\u0011\t\b\u0003g\ti$^AD!\u0019\t\u0019$!#\u0002T%!\u00111RA\u001b\u0005-\t%O]1z\u0005V4g-\u001a:\u0002?5L7/T1uG\",7OR8s)&lW-\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\b%A\npkR|em\u0014:eKJ$\u0016.\\3ti\u0006l\u0007/\u0001\u000bpkR|em\u0014:eKJ$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0016g\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8e\u0003Y\u0019\b.\u00197m_^|eMZ:fi:{GOR8v]\u0012\u0004\u0013a\u0006:fG>\u0014H-T5t[\u0006$8\r\u001b+j[\u0016Le\u000eZ3y)\u001di\u00171TAO\u0003CCq!!\u0002\u001c\u0001\u0004\t9\u0001C\u0004\u0002 n\u0001\r!!\u0017\u0002\u001d%tG-\u001a=US6,7\u000f^1na\"9\u00111U\u000eA\u0002\u0005e\u0013\u0001\u00047pORKW.Z:uC6\u0004\u0018A\b:fG>\u0014HmT;u\u001f\u001a|%\u000fZ3s\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q)\u001di\u0017\u0011VAV\u0003[Cq!!\u0002\u001d\u0001\u0004\t9\u0001C\u0004\u0002 r\u0001\r!!\u0017\t\u000f\u0005=F\u00041\u0001\u0002Z\u0005\u0011\u0002O]3w\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q\u0003m\u0011XmY8sINC\u0017\r\u001c7po>3gm]3u\u001d>$hi\\;oIR9Q.!.\u00028\u0006m\u0006bBA\u0003;\u0001\u0007\u0011q\u0001\u0005\b\u0003sk\u0002\u0019AA-\u0003-Ig\u000eZ3y\u001f\u001a47/\u001a;\t\u000f\u0005uV\u00041\u0001\u0002Z\u0005IAn\\4PM\u001a\u001cX\r^\u0001\faJLg\u000e^#se>\u00148\u000fF\u0001n\u0011\u001d\t\t'\u0003a\u0001\u0003G\u0012Q\"T3tg\u0006<W\rU1sg\u0016\u0014XCBAe\u00037\f\tp\u0005\u0002\u000b1\u0006)\u0001/\u0019:tKR!\u0011qZA{!\u001dI\u0016QKAi\u0003[\u0004R!WAj\u0003/L1!!6[\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011\\An\u0019\u0001!q!!8\u000b\u0005\u0004\tyNA\u0001L#\u0011\t\t/a:\u0011\u0007e\u000b\u0019/C\u0002\u0002fj\u0013qAT8uQ&tw\rE\u0002Z\u0003SL1!a;[\u0005\r\te.\u001f\t\u00063\u0006M\u0017q\u001e\t\u0005\u00033\f\t\u0010B\u0004\u0002t*\u0011\r!a8\u0003\u0003YCq!a>\f\u0001\u0004\tI0\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u0003w\u0014i!\u0004\u0002\u0002~*!\u0011q_A\u0000\u0015\u0011\u0011\tAa\u0001\u0002\r\r|W.\\8o\u0015\r\u0011&Q\u0001\u0006\u0005\u0005\u000f\u0011I!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0005\u0017\t1a\u001c:h\u0013\u0011\u0011y!!@\u0003\rI+7m\u001c:e\u0005Q!UmY8eKJlUm]:bO\u0016\u0004\u0016M]:feV1!Q\u0003B\u000e\u0005?\u0019B\u0001\u0004-\u0003\u0018A9\u0011\u0011\u0010\u0006\u0003\u001a\tu\u0001\u0003BAm\u00057!q!!8\r\u0005\u0004\ty\u000e\u0005\u0003\u0002Z\n}AaBAz\u0019\t\u0007\u0011q\\\u0001\u000bW\u0016LH)Z2pI\u0016\u0014\bC\u0002B\u0013\u0005W\u0011I\"\u0004\u0002\u0003()\u0019!\u0011F)\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0003.\t\u001d\"a\u0002#fG>$WM]\u0001\rm\u0006dW/\u001a#fG>$WM\u001d\t\u0007\u0005K\u0011YC!\b\u0015\r\tU\"q\u0007B\u001d!\u001d\tI\b\u0004B\r\u0005;AqA!\t\u0010\u0001\u0004\u0011\u0019\u0003C\u0004\u00030=\u0001\rA!\r\u0015\t\tu\"1\t\t\b3\u0006U#q\bB!!\u0015I\u00161\u001bB\r!\u0015I\u00161\u001bB\u000f\u0011\u001d\t9\u0010\u0005a\u0001\u0003s\fq\u0001Z;na2{w\rF\bn\u0005\u0013\u0012YEa\u0014\u0003T\t]#\u0011\fB7\u0011\u001d\t)!\u0005a\u0001\u0003\u000fAqA!\u0014\u0012\u0001\u0004\t\u0019#A\u0007qe&tGoQ8oi\u0016tGo\u001d\u0005\b\u0005#\n\u0002\u0019AA\u0019\u0003\u0005rwN\\\"p]N,7-\u001e;jm\u0016\u0004\u0016-\u001b:t\r>\u0014Hj\\4GS2,7/T1q\u0011\u001d\u0011)&\u0005a\u0001\u0003G\tq\"[:EK\u0016\u0004\u0018\n^3sCRLwN\u001c\u0005\b\u0003C\n\u0002\u0019AA2\u0011\u001d\u0011Y&\u0005a\u0001\u0005;\na\u0001]1sg\u0016\u0014\bG\u0002B0\u0005G\u0012I\u0007E\u0004\u0002z)\u0011\tGa\u001a\u0011\t\u0005e'1\r\u0003\r\u0005K\u0012I&!A\u0001\u0002\u000b\u0005\u0011q\u001c\u0002\u0004?\u0012\n\u0004\u0003BAm\u0005S\"ABa\u001b\u0003Z\u0005\u0005\t\u0011!B\u0001\u0003?\u00141a\u0018\u00133\u0011\u001d\u0011y'\u0005a\u0001\u0003G\t!c]6jaJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uC\u0006y\u0001O]5oi\n\u000bGo\u00195MKZ,G\u000eF\u0003n\u0005k\u00129\tC\u0004\u0003xI\u0001\rA!\u001f\u0002\u000b\t\fGo\u00195\u0011\t\tm$\u0011\u0011\b\u0005\u0003w\u0014i(\u0003\u0003\u0003\u0000\u0005u\u0018A\u0005$jY\u0016dunZ%oaV$8\u000b\u001e:fC6LAAa!\u0003\u0006\n1b)\u001b7f\u0007\"\fgN\\3m%\u0016\u001cwN\u001d3CCR\u001c\u0007N\u0003\u0003\u0003\u0000\u0005u\bb\u0002BE%\u0001\u0007\u0011\u0011L\u0001\u0012C\u000e\u001cW/\\;mCRLg/\u001a\"zi\u0016\u001c(\u0001F(gMN,Go]'fgN\fw-\u001a)beN,'o\u0005\u0003 1\n=\u0005#BA=\u0015U,HC\u0001BJ!\r\tIh\b\u000b\u0005\u0005/\u0013Y\nE\u0004Z\u0003+\u0012IJ!'\u0011\te\u000b\u0019.\u001e\u0005\b\u0003o\f\u0003\u0019AA}\u0005m!&/\u00198tC\u000e$\u0018n\u001c8M_\u001elUm]:bO\u0016\u0004\u0016M]:feN!!\u0005\u0017BH)\t\u0011\u0019\u000bE\u0002\u0002z\t\"BAa&\u0003(\"9\u0011q\u001f\u0013A\u0002\u0005e(aH\"mkN$XM]'fi\u0006$\u0017\r^1M_\u001elUm]:bO\u0016\u0004\u0016M]:feN!Q\u0005\u0017BH)\t\u0011y\u000bE\u0002\u0002z\u0015\n1#\\3uC\u0012\fG/\u0019*fG>\u0014HmU3sI\u0016,\"A!.\u0011\t\t]&QX\u0007\u0003\u0005sSAAa/\u0003\u0004\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0003@\ne&aE'fi\u0006$\u0017\r^1SK\u000e|'\u000fZ*fe\u0012,\u0017\u0001F7fi\u0006$\u0017\r^1SK\u000e|'\u000fZ*fe\u0012,\u0007\u0005\u0006\u0003\u0003\u0018\n\u0015\u0007bBA|S\u0001\u0007\u0011\u0011 \u0002\u0017\tVl\u0007\u000fT8h'\u0016<W.\u001a8ug>\u0003H/[8ogN\u0019!Fa3\u0011\t\t5'1[\u0007\u0003\u0005\u001fT1A!5R\u0003\u0015)H/\u001b7t\u0013\u0011\u0011)Na4\u0003+\r{W.\\1oI\u0012+g-Y;mi>\u0003H/[8og&\u0019\u0011Oa5\u0015\t\tm'Q\u001c\t\u0004\u0003sR\u0003\"B9-\u0001\u0004\u0011\u0018\u0001\u00039sS:$x\n\u001d;\u0016\u0005\t\r\b\u0003\u0002Bs\u0005Wl!Aa:\u000b\u0005\t%\u0018A\u00036paR\u001c\u0018.\u001c9mK&!!Q\u001eBt\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM]\u0001\naJLg\u000e^(qi\u0002\n\u0011B^3sS\u001aLx\n\u001d;\u0002\u0015Y,'/\u001b4z\u001fB$\b%\u0001\bj]\u0012,\u0007pU1oSRLx\n\u001d;\u0002\u001f%tG-\u001a=TC:LG/_(qi\u0002\n\u0001BZ5mKN|\u0005\u000f^\u000b\u0003\u0005{\u0004RA!:\u0003\u0000VLAa!\u0001\u0003h\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000e\f\u0011BZ5mKN|\u0005\u000f\u001e\u0011\u0002#5\f\u00070T3tg\u0006<WmU5{K>\u0003H/\u0006\u0002\u0004\nA1!Q\u001dB\u0000\u0007\u0017\u00012aYB\u0007\u0013\r\u0019y\u0001\u001a\u0002\b\u0013:$XmZ3s\u0003Ii\u0017\r_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\u0002!\u0011,W\r]%uKJ\fG/[8o\u001fB$\u0018!\u00053fKBLE/\u001a:bi&|gn\u00149uA\u0005ya/\u00197vK\u0012+7m\u001c3fe>\u0003H/\u0006\u0002\u0004\u001cA)!Q\u001dB\u0000E\u0006\u0001b/\u00197vK\u0012+7m\u001c3fe>\u0003H\u000fI\u0001\u000eW\u0016LH)Z2pI\u0016\u0014x\n\u001d;\u0002\u001d-,\u0017\u0010R3d_\u0012,'o\u00149uA\u0005QqN\u001a4tKR\u001cx\n\u001d;\u0002\u0017=4gm]3ug>\u0003H\u000fI\u0001\u0012iJ\fgn]1di&|g\u000eT8h\u001fB$\u0018A\u0005;sC:\u001c\u0018m\u0019;j_:dunZ(qi\u0002\n!c\u00197vgR,'/T3uC\u0012\fG/Y(qi\u0006\u00192\r\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00149uA\u0005)2o[5q%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u001fB$\u0018AF:lSB\u0014VmY8sI6+G/\u00193bi\u0006|\u0005\u000f\u001e\u0011\u0002\u001b5,7o]1hKB\u000b'o]3s+\t\u00199\u0004\r\u0004\u0004:\ru21\t\t\b\u0003sR11HB!!\u0011\tIn!\u0010\u0005\u0017\r}R)!A\u0001\u0002\u000b\u0005\u0011q\u001c\u0002\u0004?\u0012\u001a\u0004\u0003BAm\u0007\u0007\"1b!\u0012F\u0003\u0003\u0005\tQ!\u0001\u0002`\n\u0019q\f\n\u001b\u0002%MDw.\u001e7e!JLg\u000e\u001e#bi\u0006dunZ\u000b\u0003\u0003G\tQAZ5mKN,\"aa\u0014\u0011\u0007e\u001b(-\u0006\u0002\u0002d\u0005I1\r[3dW\u0006\u0013xm\u001d")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        public MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private final OptionSpecBuilder clusterMetadataOpt = this.parser().accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
        private final OptionSpecBuilder skipRecordMetadataOpt = this.parser().accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        public OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options().has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has((OptionSpec)this.clusterMetadataOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options().has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options().valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    private static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

